                                                        ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Parses a gem.deps.rb.lock file and constructs a LockSet containing the
# dependencies found inside.  If the lock file is missing no LockSet is
# constructed.

class Gem::RequestSet::Lockfile
  ##
  # Raised when a lockfile cannot be parsed

  class ParseError < Gem::Exception
    ##
    # The column where the error was encountered

    attr_reader :column

    ##
    # The line where the error was encountered

    attr_reader :line

    ##
    # The location of the lock file

    attr_reader :path

    ##
    # Raises a ParseError with the given +message+ which was encountered at a
    # +line+ and +column+ while parsing.

    def initialize(message, column, line, path)
      @line   = line
      @column = column
      @path   = path
      super "#{message} (at line #{line} column #{column})"
    end
  end

  ##
  # Creates a new Lockfile for the given +request_set+ and +gem_deps_file+
  # location.

  def self.build(request_set, gem_deps_file, dependencies = nil)
                                                                                                                                                                                                                  rubygems/rubygems/resolver/molinillo/lib/molinillo/dependency_graph.rb                              0000644                 00000020252 15040313417 0022464 0                                                                                                    ustar 00                                                         