
    raise Gem::Exception, "Failed to parse gem specification out of gem file"
  end

  ##
  # Raises                                                                                                                                                                                                                  rubygems/rubygems/package/digest_io.rb                                                              0000644                 00000002524 15040313421 0014120 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       rubygems/rubygems/package/io_source.rb                                                              0000644                 00000001456 15040313421 0014144 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Supports reading and writing gems from/to a generic IO object.  This is
# useful for other applications built on top of rubygems, such as
# rubygems.org.
#
# This is a private class, do not depend on it directly. Instead, pass an IO
# object to `Gem::Package.new`.

class Gem::Package::IOSource < Gem::Package::Source # :nodoc: all
  attr_reader :io

  def initialize(io)
    @io = io
  end

  def start
    @start ||= begin
      if io.pos > 0
        raise Gem::Package::Error, "Cannot read start unless IO is at start"
      end

      value = io.read 20
      io.rewind
      value
    end
  end

  def present?
    true
  end

  def with_read_io
    yield io
  ensure
    io.rewind
  end

  def with_write_io
    yield io
  ensure
    io.rewind
  end

  def path
  end
end
                                                                                                                                                                                                                  rubygems/rubygems/mock_gem_ui.rb                                                                    0000644                 00000002605 15040313421 0013035 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# IO wrapper that creates digests of contents written to the IO it wraps.

class Gem::Package::DigestIO
  ##
  # Collected digests for wrapped writes.
  #
  #   {
  #     'SHA1'   => #<OpenSSL::Digest: [...]>,
  #     'SHA512' => #<OpenSSL::Digest: [...]>,
  #   }

  attr_reader :digests

  ##
  # Wraps +io+ and updates digest for each of the digest algorithms in
  # the +digests+ Hash.  Returns the digests hash.  Example:
  #
  #   io = StringIO.new
  #   digests = {
  #     'SHA1'   => OpenSSL::Digest.new('SHA1'),
  #     'SHA512' => OpenSSL::Digest.new('SHA512'),
  #   }
  #
  #   Gem::Package::DigestIO.wrap io, digests do |digest_io|
  #     digest_io.write "hello"
  #   end
  #
  #   digests['SHA1'].hexdigest   #=> "aaf4c61d[...]"
  #   digests['SHA512'].hexdigest #=> "9b71d224[...]"

  def self.wrap(io, digests)
    digest_io = new io, digests

    yield digest_io

    return digests
  end

  ##
  # Creates a new DigestIO instance.  Using ::wrap is recommended, see the
  # ::wrap documentation for documentation of +io+ and +digests+.

  def initialize(io, digests)
    @io = io
    @digests = digests
  end

  ##
  # Writes +data+ to the underlying IO and updates the digests

  def write(data)
    result = @io.write data

    @digests.each do |_, digest|
      digest << data
    end

    result
  end
end
                                                                                                                                                                            rubygems/rubygems/defaults.rb                                                                       0000644                 00000015722 15040313421 0012372 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "user_interaction"

##
# This Gem::StreamUI subclass records input and output to StringIO for
# retrieval during tests.

class Gem::MockGemUi < Gem::StreamUI
  ##
  # Raised when you haven't provided enough input to your MockGemUi

  class InputEOFError < RuntimeError
    def initialize(question)
      super "Out of input for MockGemUi on #{question.inspect}"
    end
  end

  class TermError < RuntimeError
    attr_reader :exit_code

    def initialize(exit_code)
      super
      @exit_code = exit_code
    end
  end
  class SystemExitException < RuntimeError; end

  module TTY

    attr_accessor :tty

    def tty?()
      @tty = true unless defined?(@tty)
      @tty
    end

    def noecho
      yield self
    end
  end

  def initialize(input = "")
    require "stringio"
    ins = StringIO.new input
    outs = StringIO.new
    errs = StringIO.new

    ins.extend TTY
    outs.extend TTY
    errs.extend TTY

    super ins, outs, errs, true

    @terminated = false
  end

  def ask(question)
    raise InputEOFError, question if @ins.eof?

    super
  end

  def input
    @ins.string
  end

  def output
    @outs.string
  end

  def error
    @errs.string
  end

  def terminated?
    @terminated
  end

  def terminate_interaction(status=0)
    @terminated = true

    raise TermError, status if status != 0
    raise SystemExitException
  end
end
                                                                                                                           rubygems/rubygems/defaults.rb                                                                       0000644                 00000015722 15040313421 0012372 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Gem
  DEFAULT_HOST = "https://rubygems.org"

  @post_install_hooks ||= []
  @done_installing_hooks ||= []
  @post_uninstall_hooks ||= []
  @pre_uninstall_hooks  ||= []
  @pre_install_hooks    ||= []

  ##
  # An Array of the default sources that come with RubyGems

  def self.default_sources
    %w[https://rubygems.org/]
  end

  ##
  # Default spec directory path to be used if an alternate value is not
  # specified in the environment

  def self.default_spec_cache_dir
    default_spec_cache_dir = File.join Gem.user_home, ".gem", "specs"

    unless File.exist?(default_spec_cache_dir)
      default_spec_cache_dir = File.join Gem.data_home, "gem", "specs"
    end

    default_spec_cache_dir
  end

  ##
  # Default home directory path to be used if an alternate value is not
  # specified in the environment

  def self.default_dir
    @default_dir ||= File.join(RbConfig::CONFIG["rubylibprefix"], "gems", RbConfig::CONFIG["ruby_version_dir_name"] || RbConfig::CONFIG["ruby_version"])
  end

  ##
  # Returns binary extensions dir for specified RubyGems base dir or nil
  # if such directory cannot be determined.
  #
  # By default, the binary extensions are located side by side with their
  # Ruby counterparts, therefore nil is returned

  def self.default_ext_dir_for(base_dir)
    nil
  end

  ##
  # Paths where RubyGems' .rb files and bin f