# frozen_string_literal: true

##
# Resolver sets are used to look up specifications (and their
# dependencies) used in resolution.  This set is abstract.

class Gem::Resolver::Set
  ##
  # Set to true to disable network access for this set

  attr_accessor :remote

  ##
  # Errors encountered when resolving gems

  attr_accessor :errors

  ##
  # When true, allows matching of requests to prerelease gems.

  attr_accessor :prerelease

  def initialize # :nodoc:
    @prerelease = false
    @remote     = true
    @errors     = []
  end

  ##
  # The find_all method must be implemented.  It returns all Resolver
  # Specification objects matching the given DependencyRequest +r