rubygems/rubygems/resolver/index_specification.rb                                                   0000644                 00000004567 15040313417 0016445 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Represents a possible Specification object returned from IndexSet.  Used to
# delay needed to download full Specification objects when only the +name+
# and +version+ are needed.

class Gem::Resolver::IndexSpecification < Gem::Resolver::Specification
  ##
  # An IndexSpecification is created from the index format described in `gem
  # help generate_index`.
  #
  # The +set+ contains other specifications for this (URL) +source+.
  #
  # The +name+, +version+ and +platform+ are the name, version and platform of
  # the gem.

  def initialize(set, name, version, source, platform)
    super()

    @set = set
    @name = name
    @version = version
    @source = source
    @platform = Gem::Platform.new(platform.to_s)
    @original_platform = platform.to_s

    @spec = nil
  end

  ##
  # The dependencies of the gem for this specification

  def dependencies
    spec.dependencies
  end

  ##
  # The required_ruby_version constraint for this specification
  #
  # A fallback is included because when generated, some marshalled specs have it
  # set to +nil+.

  def required_ruby_version
    spec.required_ruby_version || Gem::Requirement.default
  end

  ##
  # The required_rubygems_version constraint for this specification
  #
  # A fallback is included because the original version of the specification
  # API didn't include that field, so some marshalled specs in the index have it
  # set to +nil+.

  def required_rubygems_version
    spec.required_rubygems_version || Gem::Requirement.default
  end

  def ==(other)
    self.class === other &&
      @name == other.name &&
      @version == other.version &&
      @platform == other.platform
  end

  def hash
    @name.hash ^ @version.hash ^ @platform.hash
  end

  def inspect # :nodoc:
    format("#<%s %s source %s>", self.class, full_name, @source)
  end

  def pretty_print(q) # :nodoc:
    q.group 2, "[Index specification", "]" do
      q.breakable
      q.text full_name

      unless @platform == Gem::Platform::RUBY
        q.breakable
        q.text @platform.to_s
      end

      q.breakable
      q.text "source "
      q.pp @source
    end
  end

  ##
  # Fetches a Gem::Specification for this IndexSpecification from the #source.

  def spec # :nodoc:
    @spec ||=
      begin
        tuple = Gem::NameTuple.new @name, @version, @original_platform

        @source.fetch_spec tuple
      end
  end
end
                                                                                                                                         rubygems/rubygems/resolver/index_set.rb                                                             0000644                 00000002645 15040313417 0014413 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The global rubygems pool represented via the traditional
# source index.

class Gem::Resolver::IndexSet < Gem::Resolver::Set
  def initialize(source = nil) # :nodoc:
    super()

    @f =
      if source
        sources = Gem::SourceList.from [source]

        Gem::SpecFetcher.new sources
      else
        Gem::SpecFetcher.fetcher
      end

    @all = Hash.new {|h,k| h[k] = [] }

    list, errors = @f.available_specs :complete

    @errors.concat errors

    list.each do |uri, specs|
      specs.each do |n|
        @all[n.name] << [uri, n]
      end
    end

    @specs = {}
  end

  ##
  # Return an array of IndexSpecification objects matching
  # DependencyRequest +req+.

  def find_all(req)
    res = []

    return res unless @remote

    name = req.dependency.name

    @all[name].each do |uri, n|
      next unless req.match? n, @prerelease
      res << Gem::Resolver::IndexSpecification.new(
        self, n.name, n.version, uri, n.platform
      )
    end

    res
  end

  def pretty_print(q) # :nodoc:
    q.group 2, "[IndexSet", "]" do
      q.breakable
      q.text "sources:"
      q.breakable
      q.pp @f.sources

      q.breakable
      q.text "specs:"

      q.breakable

      names = @all.values.flat_map do |tuples|
        tuples.map do |_, tuple|
          tuple.full_name
        end
      end

      q.seplist names do |name|
        q.text name
      end
    end
  end
end
                                                                                           rubygems/rubygems/resolver/molinillo/lib/molinillo.rb                         