tall_gem list[index]
      else
        say "Error: must enter a number [1-#{list.size + 1}]"
      end
    else
      uninstall_gem list.first
    end
  end

  ##
  # Uninstalls gem +spec+

  def uninstall_gem(spec)
    @spec = spec

    unless dependencies_ok? spec
      if abort_on_dependent? || !ask_if_ok(spec)
        raise Gem::DependencyRemovalException,
          "Uninstallation aborted due to dependent gem(s)"
      end
    end

    Gem.pre_uninstall_hooks.each do |hook|
      hook.call self
    end

    remove_executables @spec
    remove_plugins @spec
    remove @spec

    regenerate_plugins

    Gem.post_uninstall_hooks.each do |hook|
      hook.call self
    end

    @spec = nil
  end

  ##
  # Removes installed executables and batch files (windows only) for +spec+.

  def remove_executables(spec)
    return if spec.executables.empty?

    executables = spec.executables.clone

    # Leave any executables created by other installed versions
    # of this gem installed.

    list = Gem::Specification.find_all do |s|
      s.name == spec.name && s.version != spec.version
    end

    list.each do |s|
      s.executables.each do |exe_name|
        executables.delete exe_name
      end
    end

    return if executables.empty?

    executables = executables.map {|exec| formatted_program_filename exec }

    remove = if @force_executables.nil?
      ask_yes_no("Remove executables:\n" +
                 "\t#{executables.join ', '}\n\n" +
                 "in addition to the gem?",
                 true)
    else
      @force_executables
    end

    if remove
      bin_dir = @bin_dir || Gem.bindir(spec.base_dir)

      raise Gem::FilePermissionError, bin_dir unless File.writable? bin_dir

      executables.each do |exe_name|
        say "Removing #{exe_name}"

        exe_file = File.join bin_dir, exe_name

        safe_delete { FileUtils.rm exe_file }
        safe_delete { FileUtils.rm "#{exe_file}.bat" }
      end
    else
      say "Executables and scripts will remain installed."
    end
  end

  ##
  # Removes all gems in +list+.
  #
  # NOTE: removes uninstalled gems from +list+.

  def remove_all(list)
    list.each {|spec| uninstall_gem spec }
  end

  ##
  # spec:: the spec of the gem to be uninstalled

  def remove(spec)
    unless path_ok?(@gem_home, spec) ||
           (@user_install && path_ok?(Gem.user_dir, spec))
      e = Gem::GemNotInHomeException.new \
            "Gem '#{spec.full_name}' is not installed in directory #{@gem_home}"
      e.spec = spec

      raise e
    end

    raise Gem::FilePermissionError, spec.base_dir unless
      File.writable?(spec.base_dir)

    safe_delete { FileUtils.rm_r spec.full_gem_path }
    safe_delete { FileUtils.rm_r spec.extension_dir }

    old_platform_name                                                                                                                                                                                                                                                                                                                 rubygems/rubygems/resolver/molinillo/lib/molinillo/delegates/resolution_state.rb                    0000644                 00000003653 15040313417 0024533 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       pec.name)
    return if latest.nil?

    regenerate_plugins_for(latest, @plugins_dir)
  end

  ##
  # Is +spec+ in +gem_dir+?

  def path_ok?(gem_dir, spec)
    full_path     = File.join gem_dir, "gems", spec.full_name
    original_path = File.join gem_dir, "gems", spec.original_name

    full_path == spec.full_gem_path || original_path == spec.full_gem_path
  end

  ##
  # Returns true if it is OK to remove +spec+ or this is a forced
  # uninstallation.

  def dependencies_ok?(spec) # :nodoc:
    return true if @force_ignore

    deplist = Gem::DependencyList.from_specs
    deplist.ok_to_remove?(spec.full_name, @check_dev)
  end

  ##
  # Should the uninstallation abort if a dependency will go unsatisfied?
  #
  # See ::new.

  def abort_on_dependent? # :nodoc:
    @abort_on_dependent
  end

  ##
  # Asks if it is OK to remove +spec+.  Returns true if it is OK.

  def ask_if_ok(spec) # :nodoc:
    msg = [""]
    msg << "You have requested to uninstall the gem:"
    msg << "\t#{spec.full_name}"
    msg << ""

                                                                                                                                                                                                                                                                                                                      rubygems/rubygems/uri_formatter.rb                                                                  0000644                 00000001415 15040313421 0013437 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       staller"
      Gem::Installer.exec_format % File.basename(filename)
    else
      filename
    end
  end

  def saf                                                                                     rubygems/rubygems/resolver/molinillo/lib/molinillo/resolver.rb                                      0000644                 00000003045 15040313417 0021027 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       y default gems are `==` to the given `spec`.
  def default_spec_matc                                                                                                                                                                                                                                                   rubygems/rubygems/package/tar_reader/entry.rb                                                       0000644                 00000010467 15040313421 0015430 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       rubygems/rubygems/uri_formatter.rb                                                                  0000644                 00000001415 15040313421 0013437 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The UriFormatter handles URIs from user-input and escaping.
#
#   uf = Gem::UriFormatter.new 'example.com'
#
#   p uf.normalize #=> 'http://example.com'

class Gem::UriFormatter
  ##
  # The URI to be f                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           rubygems/rubygems/resolver/molinillo/lib/molinillo/modules/ui.rb                                    0000644                 00000003321 15040313417 0021250 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                               ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#++
# Copyright (C) 2004 Mauricio Julio Fernández Pradier
# See LICENSE.txt for additional licensing information.
#--

##
# Class for reading entries out of a tar file

class Gem::Package::TarReader::Entry
  ##
  # Creates a new tar entry for +header+ that will be read from +io+
  # If a block is given, the entry is yielded and then closed.

  def self.open(header, io, &block)
    entry = new header, io
    return entry unless block_given?
    begin
      yield entry
    ensure
      entry.close
    end
  end

  ##
  # Header for this tar entry

  attr_reader :header

  ##
  # Creates a new tar entry for +header+ that will be read from +io+

  def initialize(header, io)
    @closed = false
    @header = header
    @io = io
    @orig_pos = @io.pos
    @end_pos = @orig_pos + @header.size
    @read = 0
  end

  def check_closed # :nodoc:
    raise IOError, "closed #{self.class}" if closed?
  end

  ##
  # Number of bytes read out of the tar entry

  def bytes_read
    @read
  end

  ##
  # Closes the tar entry

  def close
    return if closed?
    # Seek to the end of the entry if it wasn't fully read
    seek(0, IO::SEEK_END)
    # discard trailing zeros
    skip = (512 - (@header.size % 512)) % 512
    @io.read(skip)
    @closed = true
    nil
  end

  ##
  # Is the tar entry closed?

  def closed?
    @closed
  end

  ##
  # Are we at the end of the tar entry?

  def eof?
    ch                                                                                                                                                                                                                                                                                                               rubygems/rubygems/resolver/molinillo/lib/molinillo/modules/specification_provider.rb                0000644                 00000010147 15040313417 0025371 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       = "2"
  end

  ##
  # The position in the tar entry

  def pos
    check_closed

    bytes_read
  end

  ##
                                                                                                                                                                                                           rubygems/rubygems/package/tar_reader.rb                                                             0000644                 00000003300 15040313421 0014253 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       @io.readpartial(max_read, outbuf)
    @read += outbuf.size

    outbuf
  end

  ##
  # Seeks to +offset+ bytes into the tar file entry
  # +whence+ can be IO::SEEK_SET, IO::SEEK_CUR, or IO::SEEK_END

  def seek(offset, whence = IO::SEEK_SET)
    check_closed

    new_pos =
      case whence
      when IO::SEEK_SET then @orig_pos + offset
      when IO::SEEK_CUR then @io.pos + offset
      when IO::SEEK_END then @end_pos + offset
      else
        raise ArgumentError, "invalid whence"
      end

    if new_pos < @orig_pos
      new_pos = @orig_pos
    elsif new_pos > @end_pos
      new_pos = @end_pos
    end

    pending = new_pos - @io.pos

    if @io.respond_to?(:seek)
      begin
        # avoid reading if the @io supports seeking
        @io.seek new_pos, IO::SEEK_SET
        pending = 0
      rescue Errno::EINVAL
      end
    end

    # if seeking isn't supported or failed
    # negative seek requires that we rewind and read
    if pending < 0
      @io.rewind
      pending = new_pos
    end

    while pending > 0 do
      size_read = @io.read([pending, 4096].min).size
      raise UnexpectedEOF if @io.eof?
      pending -= size_read
    end

    @read = @io.pos - @orig_pos

    0
  end

  ##
  # Rewinds to the beginning of the tar file entry

  def rewind
    check_closed
    seek(0, IO::SEEK_SET)
  end
end
                                                                                                                                                                                                         rubygems/rubygems/package/tar_reader.rb                                                             0000644                 00000003300 15040313421 0014253 0                                                                                                                                                                                                                                                                                                                                                                   rubygems/rubygems/package/tar_writer.rb                                                             0000644                 00000017013 15040313421 0014333 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       k_given?

    begin
      yield reader
    ensure
      reader.close
    end

    nil
  end

  ##
  # Creates a new tar file reader on +io+ which needs to respond to #pos,
  # #eof?, #read, #getc and #pos=

  def initialize(io)
    @io = io
    @init_pos = io.pos
  end

  ##
  # Close the tar file

  def close
  end

  ##
  # Iterates over files in the tarball yielding each entry

  def each
    return enum_for __method__ unless block_given?

    until @io.eof? do
      header = Gem::Package::TarHeader.from @io
      return if header.empty?
      entry = Gem::Package::TarReader::Entry.new header, @io
      yield entry
      entry.close
    end
  end

  alias each_entry each

  ##
  # NOTE: Do not call #rewind during #each

  def rewind
    if @init_pos == 0
      @io.rewind
    else
      @io.pos = @init_                                                                                                                                                                                                                                                                                                                                                                                                                         rubygems/rubygems/resolver/molinillo/lib/molinillo/resolution.rb                                    0000644                 00000103243 15040313417 0021372 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                               ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright (C) 2004 Mauricio Julio Fernández Pradier
# See LICENSE.txt for additional licensing information.
#++

##
# Allows writing of tar files

class Gem::Package::TarWriter
  class FileOverflow < StandardError; end

  ##
  # IO wrapper that allows writing a limited amount of data

  class BoundedStream
    ##
    # Maximum number of bytes that can be written

    attr_reader :limit

    ##
    # Number of bytes written

    attr_reader :written

    ##
    # Wraps +io+ and allows up to +limit+ bytes to be written

    def initialize(io, limit)
      @io = io
      @limit = limit
      @written = 0
    end

    ##
    # Writes +data+ onto the IO, raising a FileOverflow exception if the
    # number of bytes will be more than #limit

    def write(data)
      if data.bytesize + @written > @limit
        raise FileOverflow, "You tried to feed more data than fits in the file."
      end
      @io.write data
      @written += data.bytesize
      data.bytesize
    end
  end

  ##
  # IO wrapper that provides only #write

  class RestrictedStream
    ##
    # Creates a new RestrictedStream wrapping +io+

    def initialize(io)
      @io = io
    end

    ##
    # Writes +data+ onto the IO

    def write(data)
      @io.write data
    end
  end

  ##
  # Creates a new TarWriter, yielding it if a block is given

  def self.new(io)
    writer = super

    return writer unless block_given?

    begin
      yield writer
    ensure
      writer.close
    end

    nil
  end

  ##
  # Creates a new TarWriter that will write to +io+

  def initialize(io)
    @io = io
    @closed = false
  end

  ##
  # Adds file +name+ with permissions +mode+, and yields an IO for writing the
  # file to

  def add_file(name, mode) # :yields: io
    check_closed

    name, prefix = split_name name

    init_pos = @io.pos
    @io.write Gem::Package::TarHeader::EMPTY_HEADER # placeholder for the header

    yield RestrictedStream.new(@io) if block_given?

    size = @io.pos - init_pos - 512

    remainder = (512 - (size % 512)) % 512
    @io.write "\0" * remainder

    final_pos = @io.pos
    @io.pos = init_pos

    header = Gem::Package::TarHeader.new :name => name, :mode => mode,
                                         :size => size, :prefix => prefix,
                                         :mtime => Gem.source_date_epoch

    @io.write header
    @io.pos = final_pos

    self
  end

  ##
  # Adds +name+ with permissions +mode+ to the tar, yielding +io+ for writing
  # the file.  The +digest_algorithm+ is written to a read-only +name+.sum
  # file following the given file contents containing the digest name and
  # hexdigest separated by a tab.
  #
  # The created digest object is returned.

  def add_file_digest(name, mode, digest_algorithms) # :yields: io
    digests = digest_algorithms.map do |digest_algorithm|
      digest = digest_algorithm.new
      digest_name =
        if digest.respond_to? :name
          digest.name
        else
          digest_algorithm.class.name[/::([^:]+)\z/, 1]
        end

      [digest_name, digest]
    end

    digests = Hash[*digests.flatten]

    add_file name, mode do |io|
      Gem::Package::DigestIO.wrap io, digests do |digest_io|
        yield digest_io
      end
    end

    digests
  end

  ##
  # Adds +name+ with permissions +mode+ to the tar, yielding +io+ for writing
  # the file.  The +signer+ is used to add a digest file using its
  # digest_algorithm per add_file_digest and a cryptographic signature in
  # +name+.sig.  If the signer has no key only the checksum file is added.
  #
  # Returns the digest.

  def add_file_signed(name, mode, signer)
    digest_algorithms = [
      signer.digest_algorithm,
      Gem::Security.create_digest("SHA512"),
    ].compact.uniq

    digests = add_file_digest name, mode, digest_algorithms do |io|
      yield io
    end

    signature_digest = digests.values.compact.find do |digest|
      digest_name =
        if digest.respond_to? :name
          digest.name
        else
          digest.class.name[/::([^:]+)\z/, 1]
        end

      digest_name == signer.digest_name
    end

    raise "no #{signer.digest_name} in #{digests.values.compact}" unless signature_digest

    if signer.key
      signature = signer.sign signature_digest.digest

      add_file_simple "#{name}.sig", 0444, signature.length do |io|
        io.write signature
      end
    end

    digests
  end

  ##
  # Add file +name+ with permissions +mode+ +size+ bytes long.  Yields an IO
  # to write the file to.

  def add_file_simple(name, mode, size) # :yields: io
    check_closed

    name, prefix = split_name name

    header = Gem::Package::TarHeader.new(:name => name, :mode => mode,
                                         :size => size, :prefix => prefix,
                                         :mtime => Gem.source_date_epoch).to_s

    @io.write header
    os = BoundedStream.new @io, size

    yield os if block_given?

    min_padding = size - os.written
    @io.write("\0" * min_padding)

    remainder = (512 - (size % 512)) % 512
    @io.write("\0" * remainder)

    self
  end

  ##
  # Adds symlink +name+ with permissions +mode+, linking to +target+.

  def add_symlink(name, target, mode)
    check_closed

    name, prefix = split_name name

    header = Gem::Package::TarHeader.new(:name => name, :mode => mode,
                                         :size => 0, :typeflag => "2",
                                         :linkname => target,
                                         :prefix => prefix,
                                         :mtime => Gem.source_date_ep                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     rubygems/rubygems/package/source.rb                                                                 0000644                 00000000110 15040313421 0013437 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        TarHeader

  def split_name(name) # :nodoc:
    if name.bytesize > 256
                                                                                                                                                                                                                                                                                                                                                                                                                                                        rubygems/rubygems/package/file_source.rb                                                            0000644                 00000001142 15040313421 0014444 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     rubygems/rubygems/package/source.rb                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             rubygems/rubygems/package/tar_header.rb                                                             0000644                 00000013547 15040313421 0014257 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       rubygems/rubygems/package/file_source.rb                                                            0000644                 00000001142 15040313421 0014444 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The primary source of gems is a file on disk, including all usages
# internal to rubygems.
#
# This is a private class, do not depend on it directly. Instead, pass a path
# object to `Gem::Package.new`.

class Gem::Package::FileSource < Gem::Package::Source # :nodoc: all
  attr_reader :path

  def initialize(path)
    @path = path
  end

  def start
    @start ||= File.read path, 20
  end

  def present?
    File.exist? path
  end

  def with_write_io(&block)
    File.open path, "wb", &block
  end

  def with_read_io(&block)
    File.open path, "rb", &block
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                              rubygems/rubygems/package/tar_header.rb                                                             0000644                 00000013547 15040313421 0014257 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright (C) 2004 Mauricio Julio Fernández Pradier
# See LICENSE.txt for additional licensing information.
#++

##
#--
# struct tarfile_entry_posix {
#   char name[100];     # ASCII + (Z unless filled)
#   char mode[8];       # 0 padded, octal, null
#   char uid[8];        # ditto
#   char gid[8];        # ditto
#   char size[12];      # 0 padded, octal, null
#   char mtime[12];     # 0 padded, octal, null
#   char checksum[8];   # 0 padded, octal, null, space
#   char typeflag[1];   # file: "0"  dir: "5"
#   char linkname[100]; # ASCII + (Z unless filled)
#   char magic[6];      # "ustar\0"
#   char version[2];    # "00"
#   char uname[32];     # ASCIIZ
#   char gname[32];     # ASCIIZ
#   char devmajor[8];   # 0 padded, octal, null
#   char devminor[8];   # o padded, octal, null
#   char prefix[155];   # ASCII + (Z unless filled)
# };
#++
# A header for a tar file

class Gem::Package::TarHeader
  ##
  # Fields in the tar header

  FIELDS = [
    :checksum,
    :devmajor,
    :devminor,
    :gid,
    :gname,
    :linkname,
    :magic,
    :mode,
    :mtime,
    :name,
    :prefix,
    :size,
    :typeflag,
    :uid,
    :uname,
    :version,
  ].freeze

  ##
  # Pack format for a tar header

  PACK_FORMAT = "a100" + # name
                "a8"   + # mode
                "a8"   + # uid
                "a8"   + # gid
                "a12"  + # size
                "a12"  + # mtime
                "a7a"  + # chksum
                "a"    + # typeflag
                "a100" + # linkname
                "a6"   + # magic
                "a2"   + # version
                "a32"  + # uname
                "a32"  + # gname
                "a8"   + # devmajor
                "a8"   + # devminor
                "a155"   # prefix

  ##
  # Unpack format for a tar header

  UNPACK_FORMAT = "A100" + # name
                  "A8"   + # mode
                  "A8"   + # uid
                  "A8"   + # gid
                  "A12"  + # size
                  "A12"  + # mtime
                  "A8"   + # checksum
                  "A"    + # typeflag
                  "A100" + # linkname
                  "A6"   + # magic
                  "A2"   + # version
                  "A32"  + # uname
                  "A32"  + # gname
                  "A8"   + # devmajor
                  "A8"   + # devminor
                  "A155"   # prefix

  attr_reader(*FIELDS)

  EMPTY_HEADER = ("\0" * 512).freeze # :nodoc:

  ##
  # Creates a tar header from IO +stream+

  def self.from(stream)
    header = stream.read 512
    empty = (EMPTY_HEADER == header)

    fields = header.unpack UNPACK_FORMAT

    new :name => fields.shift,
        :mode => strict_oct(fields.shift),
        :uid => oct_or_256based(fields.shift),
        :gid => oct_or_256based(fields.shift),
        :size => strict_oct(fields.shift),
        :mtime => strict_oct(fields.shift),
        :checksum => strict_oct(fields.shift),
        :typeflag => fields.shift,
        :linkname => fields.shift,
        :magic => fields.shift,
        :version => strict_oct(fields.shift),
        :uname => fields.shift,
        :gname => fields.shift,
        :devmajor => strict_oct(fields.shift),
        :devminor => strict_oct(fields.shift),
        :prefix => fields.shift,

        :empty => empty
  end

  def self.strict_oct(str)
    return str.strip.oct if str.strip =~ /\A[0-7]*\z/

    raise ArgumentError, "#{str.inspect} is not an octal string"
  end

  def self.oct_or_256based(str)
    # \x80 flags a positive 256-based number
    # \ff flags a negative 256-based number
    # In case we have a match, parse it as a signed binary value
    # in big-endian order, except that the high-order bit is ignored.
    return str.unpack("N2").last if str =~ /\A[\x80\xff]/n
    strict_oct(str)
  end

  ##
  # Creates a new TarHeader using +vals+

  def initialize(vals)
    unless vals[:name] && vals[:size] && vals[:pr                                                                                                                                                         rubygems/rubygems/package/old.rb                                                                    0000644                 00000007203 15040313421 0012727 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       other &&
      @checksum == other.checksum &&
      @devmajor == other.devmajor &&
      @devminor == other.devminor &&
      @gid      == other.gid      &&
      @gname    == other.gname    &&
      @linkname == other.linkname &&
      @magic    == other.magic    &&
      @mode     == other.mode     &&
      @mtime    == other.mtime    &&
      @name     == other.name     &&
      @prefix   == other.prefix   &&
      @size     == other.size     &&
      @typeflag == other.typeflag &&
      @uid      == other.uid      &&
      @uname    == other.uname    &&
      @version  == other.version
  end

  def to_s # :nodoc:
    update_checksum
    header
  end

  ##
  # Updates the TarHeader's checksum

  def update_checksum
    header = header " " * 8
    @checksum = oct calculate_checksum(header), 6
  end

  private

  def calculate_checksum(header)
    header.sum(0)
  end

  def header(checksum = @checksum)
    header = [
      name,
      oct(mode, 7),
      oct(uid, 7),
      oct(gid, 7),
      oct(size, 11),
      oct(mtime, 11),
      checksum,
      " ",
      typeflag,
      linkname,
      magic,
      oct(version, 2),
      uname,
      gname,
      oct(devmajor, 7),
      oct(devminor, 7),
      prefix,
    ]

    header = header.pack PACK_FORMAT

    header << ("\0" * ((512 - header.size) % 512))
  end

  def oct(num, len)
    "%0#{len}o" % num
  end
end
                                                                                                                                                         rubygems/rubygems/package/old.rb                                                                    0000644                 00000007203 15040313421 0012727 0                                                                                                    ustar 00                                                                                                   