# frozen_string_literal: true

##
# The LockSpecification comes from a lockfile (Gem::RequestSet::Lockfile).
#
# A LockSpecification's dependency information is pre-filled from the
# lockfile.

class Gem::Resolver::LockSpecification < Gem::Resolver::Specification
  attr_reader :sources

  def initialize(set, name, version, sources, platform)
    super()

    @name     = name
    @platform = platform
    @set      = set
    @source   = sources.first
    @sources  = sources
    @version  = version

    @dependencies = []
    @spec         = nil
  end

  ##
  # This is a null install as a locked specification is considered installed.
  # +options+ are ignored.

  def install(options = {})
    destination = options[:install_dir] || Gem.dir

    if File.exist? File.join(destination, "specifications", spec.spec_name)
      yield nil
      return
    end

    super
  end

  ##
  # Adds +dependency+ from the lockfile to this 