rubygems/rubygems/resolver/api_set.rb                                                               0000644                 00000005724 15040313417 0014056 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The global rubygems pool, available via the rubygems.org API.
# Returns instances of APISpecification.

class Gem::Resolver::APISet < Gem::Resolver::Set
  autoload :GemParser, File.expand_path("api_set/gem_parser", __dir__)

  ##
  # The URI for the dependency API this APISet uses.

  attr_reader :dep_uri # :nodoc:

  ##
  # The Gem::Source that gems are fetched from

  attr_reader :source

  ##
  # The corresponding place to fetch gems.

  attr_reader :uri

  ##
  # Creates a new APISet that will retrieve gems from +uri+ using the RubyGems
  # API URL +dep_uri+ which is described at
  # https://guides.rubygems.org/rubygems-org-api

  def initialize(dep_uri = "https://index.rubygems.org/info/")
    super()

    dep_uri = Gem::URI dep_uri unless Gem::URI === dep_uri

    @dep_uri = dep_uri
    @uri     = dep