rubygems/rubygems/resolver/best_set.rb                                                              0000644                 00000001656 15040313417 0014242 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The BestSet chooses the best available method to query a remote index.
#
# It combines IndexSet and APISet

class Gem::Resolver::BestSet < Gem::Resolver::ComposedSet
  ##
  # Creates a BestSet for the given +sources+ or Gem::sources if none are
  # specified.  +sources+ must be a Gem::SourceList.

  def initialize(sources = Gem.sources)
    super()

    @sources = sources
  end

  ##
  # Picks which sets to use for the configured sources.

  def pick_sets # :nodoc:
    @sources.each_source do |source|
      @sets << source.dependency_resolver_set
    end
  end

  def find_all(req) # :nodoc:
    pick_sets if @remote && @sets.empty?

    super
  end

  def prefetch(reqs) # :nodoc:
    pick_sets if @remote && @sets.empty?

    super
  end

  def pretty_print(q) # :nodoc:
    q.group 2, "[BestSet", "]" do
      q.breakable
      q.text "sets:"

      q.breakable
      q.pp @sets
    end
  end
end
                                                                                  rubygems/rubygems/resolver/git_specification.rb                                                     0000644                 00000002423 15040313417 0016106 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# A GitSpecification represents a gem that is sourced from a git repository
# and is being loaded through a gem dependencies file through the +git:+
# option.

class Gem::Resolver::GitSpecification < Gem::Resolver::SpecSpecification
  def ==(other) # :nodoc:
    self.class === other &&
      @set  == other.set &&
      @spec == other.spec &&
      @source == other.source
  end

  def add_dependency(dependency) # :nodoc:
    spec.dependencies << dependency
  end

  ##
  # Installing a git gem only involves building the extensions and generating
  # the executables.

  def install(options = {})
    require_relative "../installer"

    in