# frozen_string_literal: true

module Gem
  if defined? ::Psych::Visitors
    class NoAliasYAMLTree < Psych::Visitors::YAMLTree
      def self.create
        new({})
      end unless respond_to? :create

      def visit_String(str)
        return super unless str == "=" # or whatever you want

        quote = Psych::Nodes::Scalar::SINGLE_QUOTED
        @emitter.scalar str, nil, nil, false, true, quote
      end

      def visit_Hash(o)
        super(o.compact)
      end

      # Noop this out so there are no anchors
      def register(target, obj)
      end

      # This is ported over from the yaml_tree in 1.9.3
      def format_time(time)
        if time.utc?
          time.strftime("%Y-%m-%d %H:%M:%S.%9N Z")
        else
          time.strftime("%Y-%m-%d %H:%M:%S.%9N %:z")
        end
      end

      private :format_time
    end
  end
end
                                                                                                                                                                         rubygems/rubygems/safe_yaml.rb                                                                      0000644                 00000002053 15040313423 0012516 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Gem
  ###
  # This module is used for safely loading YAML specs from a gem.  The
  # `safe_load` method defined on this module is specifically designed for
  # loading Gem specifications.  For loading other YAML safely, please see
  # Psych.safe_load

  module SafeYAML
    PERMITTED_CLASSES = %w[
      Symbol
      Time
      Date
      Gem::Dependency
      Gem::Platform
      Gem::Requirement
      Gem::Specification
      Gem::Version
      Gem::Version::Requirement
    ].freeze

    PERMITTED_SYMBOLS = %w[
      development
      runtime
    ].freeze

    @aliases_enabled = true
    def self.aliases_enabled=(value) # :nodoc:
      @aliases_enabled = !!value
    end

    def self.aliases_enabled? # :nodoc:
      @aliases_enabled
    end

    def self.safe_load(input)
      ::Psych.safe_load(input, permitted_classes: PERMITTED_CLASSES, permitted_symbols: PERMITTED_SYMBOLS, aliases: @aliases_enabled)
    end

    def self.load(input)
      ::Psych.safe_load(input, permitted_classes: [::Symbol])
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     rubygems/rubygems/compatibility.rb                                                                  0000644                 00000001776 15040313423 0013442 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# This file contains all sorts of little compatibility hacks that we've
# had to introduce over the years. Quarantining them into one file helps
# us know when we can get rid of them.
#
# Ruby 1.9.x has introduced some things that are awkward, and we need to
# support them, so we define some constants to use later.
#
# TODO remove at RubyGems 4
#++

module Gem
  # :stopdoc:

  RubyGemsVersion = VERSION
  deprecate_constant(:RubyGemsVersion)

  RbConfigPriorities = %w[
    MAJOR
    MINOR
    TEENY
    EXEEXT RUBY_SO_NAME arch bindir datadir libdir ruby_install_name
    ruby_version rubylibprefix sitedir sitelibdir vendordir vendorlibdir
    rubylibdir
  ].freeze

  if defined?(ConfigMap)
    RbConfigPriorities.each do |key|
      ConfigMap[key.to_sym] = RbConfig::CONFIG[key]
    end
  else
    ##
    # Configuration settings from ::RbConfig
    ConfigMap = Hash.new do |cm, key|
      cm[key] = RbConfig::CONFIG[key.to_s]
    end
    deprecate_constant(:ConfigMap)
  end
end
  rubygems/rubygems/name_tuple.rb                                                                     0000644                 00000004612 15040313423 0012712 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
#
# Represents a gem of name +name+ at +version+ of +platform+. These
# wrap the data returned from the indexes.

class Gem::NameTuple
  def initialize(name, version, platform=Gem::Platform::RUBY)
    @name = name
    @version = version

    platform &&= platform.to_s
    platform = Gem::Platform::RUBY if !platform || platform.empty?
    @platform = platform
  end

  attr_reader :name, :version, :platform

  ##
  # Turn an array of [name, version, platform] into an array of
  # NameTuple objects.

  def self.from_list(list)
    list.map {|t| new(*t) }
  end

  ##
  # Turn an array of NameTuple objects back into an array of
  # [name, version, platform] tuples.

  def self.to_basic(list)
    list.map(&:to_a)
  end

  ##
  # A null NameTuple, ie name=nil, version=0

  def self.null
    new nil, Gem::Version.new(0), nil
  end

  ##
  # Returns the full name (name-version) of this Gem.  Platform informa