end

  ##
  # Sign data with given digest algorithm

  def sign(data)
    return unless @key

    raise Gem::Security::Exception, "no certs provided" if @cert_chain.empty?

    if @cert_chain.length == 1 && @cert_chain.last.not_after < Time.now
      alert("Your certificate has expired, trying to re-sign it...")

      re_sign_key(
        expiration_length: (Gem::Security::ONE_DAY * options[:expiration_length_days])
      )
    end

    full_name = extract_name @cert_chain.last

    Gem::Security::SigningPolicy.verify @cert_chain, @key, {}, {}, full_name

    @key.sign @digest_algorithm.new, data
  end

  ##
  # Attempts to re-sign the private key if the signing certificate is expired.
  #
  # The key will be re-signed if:
  # * The expired certificate is self-signed
  # * The expired certificate is saved at ~/.gem/gem-public_cert.pem
  #   and the private key is saved at ~/.gem/gem-private_key.pem
  # * There is no file matching the expiry date at
  #   ~/.gem/gem-public_cert.pem.expired.%Y%m%d%H%M%S
  #
  # If the signing certificate can be re-signed the expired certificate will
  # be saved as ~/.gem/gem-public_cert.pem.expired.%Y%m%d%H%M%S where the
  # expiry time (not after) is used for the timestamp.

  def re_sign_key(expiration_length: Gem::Security::ONE_YEAR) # :nodoc:
    old_cert = @cert_chain.last

    disk_cert_path = File.join(Gem.default_cert_path)
    disk_cert = begin
                  File.read(disk_cert_path)
                rescue StandardError
                  nil
                end

    disk_key_path = File.join(Gem.default_key_path)
    disk_key = begin
                 OpenSSL::PKey.read(File.read(disk_key_path), @passphrase)
               rescue StandardError
                 nil
               end

    return unless disk_key

    if disk_key.to_pem == @key.to_pem && disk_cert == old_cert.to_pem
      expiry = old_cert.not_after.strftime("%Y%m%d%H%M%S")
      old_cert_file = "gem-public_cert.pem.expired.#{expiry}"
      old_cert_path = File.join(Gem.user_home, ".gem", old_cert_file)

      unless File.exist?(old_cert_path)
        Gem::Security.write(old_cert, old_cert_path)

        cert = Gem::Security.re_sign(old_cert, @key, expiration_length)

        Gem::Security.write(cert, disk_cert_path)

        alert("Your cert: #{disk_cert_path} has been auto re-signed with the key: #{disk_key_path}")
        alert("Your expired cert will be located at: #{old_cert_path}")

        @cert_chain = [cert]
      end
    end
  end
end
                                                              rubygems/rubygems/security/trust_dir.rb                                                             0000644                 00000004773 15040313417 0014462 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The TrustDir manages the trusted certificates for gem signature
# verification.

class Gem::Security::TrustDir
  ##
  # Default permissio