quirement.default
      elsif source_set
        Gem::Requirement.source_set
      else
        Gem::Requirement.create requirements
      end

    return unless gem_platforms name, options

    groups = gem_group name, options

    return unless (groups & @without_groups).empty?

    pin_gem_source name, :default unless source_set

    gem_requires name, options

    if duplicate
      warn <<-WARNING
Gem dependencies file #{@path} requires #{name} more than once.
      WARNING
    end

    @set.gem name, *requirements
  end

  ##
  # Handles the git: option from +options+ for gem +name+.
  #
  # Returns +true+ if the gist or git option was handled.

  def gem_git(name, options) # :nodoc:
    if gist = options.delete(:gist)
      options[:git] = "https://gist.github.com/#{gist}.git"
    end

    return unless repository = options.delete(:git)

    pin_gem_source name, :git, repository

    reference = gem_git_reference options

    submodules = options.delete :submodules

    @git_set.add_git_gem name, repository, reference, submodules

    true
  end

  ##
  # Handles the git options from +options+ for git gem.
  #
  # Returns reference for the git gem.

  def gem_git_reference(options) # :nodoc:
    ref    = options.delete :ref
    branch = options.delete :branch
    tag    = options.delete :tag

    reference = nil
    reference ||= ref
    reference ||= branch
    reference ||= tag

    if ref && branch
      warn <<-WARNING
Gem dependencies file #{@path} includes git reference for both ref and branch but only ref is used.
      WARNING
    end
    if (ref || branch) && tag
      warn <<-WARNING
Gem dependencies file #{@path} includes git reference for both ref/branch and tag but only ref/branch is used.
      WARNING
    end

    reference
  end

  private :gem_git

  ##
  # Handles a git gem option from +options+ for gem +name+ for a git source
  # registered through git_source.
  #
  # Returns +true+ if the custom source option was handled.

  def gem_git_source(name, options) # :nodoc:
    return unless git_source = (@git_sources.keys & options.keys).last

    source_callback = @git_sources[git_source]
    source_param = options.delete git_source

    git_url = source_callback.call source_param

    options[:git] = git_url

    gem_git name, options

    true
  end

  private :gem_git_source

  ##
  # Handles the :group and :groups +options+ for the gem with the given
  # +name+.

  def gem_group(name, options) # :nodoc:
    g = options.delete :group
    all_groups = g ? Array(g) : []

    groups = options.delete :groups
    all_groups |= groups if groups

    all_groups |= @current_groups if @current_groups

    all_groups
  end

  private :gem_group

  ##
  # Handles the path: option from +options+ for gem +name+.
  #
  # Returns +true+ if the path option was handled.

  def gem_path(name, options) # :nodoc:
    return unless directory = options.delete(:path)

    pin_gem_source name, :path, directory

    @vendor_set.add_vendor_gem name, directory

    true
  end

  private :gem_path

  ##
  # Handles the source: option from +options+ for gem +name+.
  #
  # Returns +true+ if the source option was handled.

  def gem_source(name, options) # :nodoc:
    return unless source = options.delete(:source)

    pin_gem_source name, :source, source

    @source_set.add_source_gem name, source

    true
  end

  private :gem_source

  ##
  # Handles the platforms: option from +options+.  Returns true if the
  # platform matches the current platform.

  def gem_platforms(name, options) # :nodoc:
    platform_names = Array(options.delete(:platform))
    platform_names.concat Array(options.delete(:platforms))
    platform_names.concat @current_platforms if @current_platforms

    return true if platform_names.empty?

    platform_names.any? do |platform_name|
      raise ArgumentError, "unknown platform #{platform_name.inspect}" unless
        platform = PLATFORM_MAP[platform_name]

      next false unless Gem::Platform.match_gem? platform, name

      if engines = ENGINE_MAP[platform_name]
        next false unless engines.include? Gem.ruby_engine
      end

      case WINDOWS[platform_name]
      when :only then
        next false unless Gem.win_platform?
      when :never then
        next false if Gem.win_platform?
      end

      VERSION_MAP[platform_name].satisfied_by? Gem.ruby_version
    end
  end

  private :gem_platforms

  ##
  # Records the require: option from +options+ and adds those files, or the
  # default file to the require list for +name+.

  def gem_requires(name, options) # :nodoc:
    if options.include? :require
      if requires = options.delete(:require)
        @requires[name].concat Array requires
      end
    else
      @requires[name] << name
    end
    raise ArgumentError, "Unhandled gem options #{options.inspect}" unless options.empty?
  end

  private :gem_requires

  ##
  # :category: Gem Dependencies DSL
  #
  # Block form for specifying gems from a git +repository+.
  #
  #   git 'https://github.com/rails/rails.git' do
  #     gem 'activesupport'
  #     gem 'activerecord'
  #   end

  def git(repository)
    @current_repository = repository

    yield
  ensure
    @current_repository = nil
  end

  ##
  # Defines a custom git source that uses +name+ to expand git repositories
  # for use in gems built from git repositories.  You must provide a block
  # that accepts a git repository name for expansion.

  def git_source(name, &callback)
    @git_sources[name] = callback
  end

  ##
  # Returns the basename of the file the dependencies were loaded from

  def gem_deps_file # :nodoc:
    File.basename @path
  end

  ##
  # :category: Gem Dependencies DSL
  #
  # Load