reserved.

  def require(path) # :doc:
    return gem_original_require(path) unless Gem.discover_gems_on_require

    RUBYGEMS_ACTIVATION_MONITOR.synchronize do
      path = File.path(path)

      # If +path+ belongs to a default gem, we activate it and then go straight
      # to normal require

      if spec = Gem.find_default_spec(path)
        name = spec.name

        next if Gem.loaded_specs[name]

        # Ensure -I beats a default gem
        resolved_path = begin
          rp = nil
          load_path_check_index = Gem.load_path_insert_index - Gem.activated_gem_paths
          Gem.suffixes.find do |s|
            $LOAD_PATH[0...load_path_check_index].find do |lp|
              if File.symlink? lp # for backward compatibility
                next
              end

              full_path = File.expand_path(File.join(lp, "#{path}#{s}"))
              rp = full_path if File.file?(full_path)
            end