encies groups, spec.runtime_dependencies

    @dependencies[spec.name] = Gem::Requirement.source_set

    spec.dependencies.each do |dep|
      @dependencies[dep.name] = dep.requirement
    end

    groups << development_group

    add_dependencies groups, spec.development_dependencies

    @vendor_set.add_vendor_gem spec.name, path
    gem_requires spec.name, options
  end

  ##
  # :category: Gem Dependencies DSL
  #
  # Block form for placing a dependency in the given +groups+.
  #
  #   group :development do
  #     gem 'debugger'
  #   end
  #
  #   group :development, :test do
  #     gem 'minitest'
  #   end
  #
  # Groups can be excluded at install time using `gem install -g --without
  # development`.  See `gem help install` and `gem help gem_dependencies` for
  # further details.

  def group(*groups)
    @current_groups = groups

    yield
  ensure
    @current_groups = nil
  end

  ##
  # Pins the gem +name+ to the given +source+.  Adding a gem with the same
  # name from a different +source+ will raise an exception.

  def pin_gem_source(name, type = :default, source = nil)
    source_description =
      case type
      when :default then "(default)"
      when :path    then "path: #{source}"
      when :git     then "git: #{source}"
      when :source  then "source: #{source}"
      else               "(unknown)"
      end

    raise ArgumentError,
      "duplicate source #{source_description} for gem #{name}" if
        @gem_sources.fetch(name, source) != source

    @gem_sources[name] = source
  end

  private :pin_gem_source

  ##
  # :category: Gem Dependencies DSL
  #
  # Block form for restricting gems to a set of platforms.
  #
  # The gem dependencies platform is different from Gem::Platform.  A platform
  # gem.deps.rb platform matches on the ruby engine, the ruby version and
  # whether or not windows is allowed.
  #
  # :ruby, :ruby_XY ::
  #   Matches non-windows, non-jruby implementations where X and Y can be used
  #   to match releases in the 1.8, 1.9, 2.0 or 2.1 series.
  #
  # :mri, :mri_XY ::
  #   Matches non-windows C Ruby (Matz Ruby) or only the 1.8, 1.9, 2.0 or
  #   2.1 series.
  #
  # :mingw, :mingw_XY ::
  #   Matches 32 bit C Ruby on MinGW or only the 1.8, 1.9, 2.0 or 2.1 series.
  #
  # :x64_mingw, :x64_mingw_XY ::
  #   Matches 64 bit C Ruby on MinGW or only the 1.8, 1.9, 2.0 or 2.1 series.
  #
  # :mswin, :mswin_XY ::
  #   Matches 32 bit C Ruby on Microsoft Windows or only the 1.