build_info_file = File.join build_info_dir, "#{spec.full_name}.info"

    File.open build_info_file, "w" do |io|
      build_args.each do |arg|
        io.puts arg
      end
    end

    File.chmod(dir_mode, build_info_dir) if dir_mode
  end

  ##
  # Writes the .gem file to the cache directory

  def write_cache_file
    cache_file = File.join gem_home, "cache", spec.file_name
    @package.copy_to cache_file
  end

  def ensure_writable_dir(dir) # :nodoc:
    begin
      Dir.mkdir dir, *[options[:dir_mode] && 0o755].compact
    rescue SystemCallError
      raise unless File.directory? dir
    end

    raise Gem::FilePermissionError.new(dir) unless File.writable? dir
  end

  private

  def user_install_dir
    # never install to user home in --build-root mode
    return unless @build_root.nil?

    # Please note that @user_install might have three states:
    # * `true`: `--user-install`
    # * `false`: `--no-user-install` and
    # * `nil`: option was not specified
    if @user_install || (@user_install.nil? && Gem.default_user_install)
      Gem.user_dir
    end
  end

  def build_args
    @build_args ||= begin
                      require_relative "command"
                      Gem::Command.build_args
                    end
  end

  def rb_config
    Gem.target_rbconfig
  end

  def ruby_install_name
    rb_config["ruby_install_name"]
  end

  def load_relative_enabled?
    rb_config["LIBRUBY_RELATIVE"] == "yes"
  end

  def bash_prolog_script
    if load_relative_enabled?
      <<~EOS
        #!/bin/sh
        # -*- ruby -*-
        _=_\\
        =begin
        bindir="${0%/*}"
        ruby="$bindir/#{ruby_install_name}"
        if [ ! -f "$ruby" ]; then
          ruby="#{ruby_install_name}"
        fi
        exec "$ruby" "-x" "$0" "$@"
        =end
      EOS
    else
      ""
    end
  end

  def load_plugin
    specs = Gem::Specification.find_all_by_name(spec.name)
    # If old version already exists, this plugin isn't loaded
    # immediately. It's for avoiding a case that multiple versions
    # are loaded at the same time.
    return unless specs.size == 1

    plugin_files = spec.plugins.map do |plugin|
      File.join(@plugins_dir, "#{spec.name}_plugin#{File.extname(plugin)}")
    end
    Gem.load_plugin_files(plugin_files)
  end
end
                                                                                                                                                                                                                                                                             rubygems/rubygems/install_default_message.rb                                                        0000644                 00000000535 15040313423 0015437 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../rubygems"
require_relative "user_interaction"

##
# A post-install hook that displays "Successfully installed
# some_gem-1.0 as a default gem"

Gem.post_install do |installer|
  ui = Gem::DefaultUserInteraction.ui
  ui.say "Successfully installed #{installer.spec.full_name} as a default gem"
end
                                                                                                                                                                   rubygems/rubygems/security.rb                                                                       0000644                 00000053306 15040313423 0012434 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

require_relative "exceptions"
require_relative "openssl"

##
# = Signing gems
#
# The Gem::Security implements cryptographic signatures for gems.  The section
# below is a step-by-step guide to using signed gems and generating your own.
#
# == Walkthrough
#
# === Building your certificate
#
# In order to start signing your gems, you'll need to build a private key and
# a self-signed certificate.  Here's how:
#
#   # build a private key and certificate for yourself:
#   $ gem cert --build you@example.com
#
# This could take anywhere from a few seconds to a minute or two, depending on
# the speed of your computer (public key algorithms aren't exactly the
# speediest crypto algorithms in the world).  When it's finished, you'll see
# the files "gem-private_key.pem" and "gem-public_cert.pem" in the current
# directory.
#
# First things first: Move both files to ~/.gem if you don't already have a
# key and certificate in that directory.  Ensure the file permissions make the
# key unreadable by others (by default the file is saved securely).
#
# Keep your private key hidden; if it's compromised, someone can sign packages
# as you (note: PKI has ways of mitigating the risk of stolen keys; more on
# that later).
#
# === Signing Gems
#
# In RubyGems 2 and newer there is no extra work to sign a gem.  RubyGems will
# automatically find your key and certificate in your home directory and use
# them to sign newly packaged gems.
#
# If your certificate is not self-signed (signed by a third party) RubyGems
# will attempt to load the certificate chain from the trusted certificates.
# Use <code>gem cert --add signing_cert.pem</code> to add your signers as
# trusted certificates.  See below for further information on certificate
# chains.
#
# If you build your gem it will automatically be signed.  If you peek inside
# your gem file, you'll see a couple of new files have been added:
#
#   $ tar tf your-gem-1.0.gem
#   metadata.gz
#   metadata.gz.sig # metadata signature
#   data.tar.gz
#   data.tar.gz.sig # data signature
#   checksums.yaml.gz
#   checksums.yaml.gz.sig # checksums signature
#
# === Manually signing gems
#
# If you wish to store your key in a separate secure location you'll need to
# set your gems up for signing by hand.  To do this, set the
# <code>signing_key</code> and <code>cert_chain</code> in the gemspec before
# packaging your gem:
#
#   s.signing_key = '/secure/path/to/gem-private_key.pem'
#   s.cert_chain = %w[/secure/path/to/gem-public_cert.pem]
#
# When you package your gem with these options set RubyGems will automatically
# load your key and certificate from the secure paths.
#
# === Signed gems and security policies
#
# Now let's verify the signature.  Go ahead and install the gem, but add the
# following options: <code>-P HighSecurity</code>, like this:
#
#   # install the gem with using the security policy "HighSecurity"
#   $ sudo gem install your.gem -P HighSecurity
#
# The <code>-P</code> option sets your security policy -- we'll talk about
# that in just a minute.  Eh, what's this?
#
#   $ gem install -P HighSecurity your-gem-1.0.gem
#   ERROR:  While executing gem ... (Gem::Security::Exception)
#       root cert /CN=you/DC=example is not trusted
#
# The culprit here is the security policy.  RubyGems has several different
# security policies.  Let's take a short break and go over the security
# policies.  Here's a list of the available security policies, and a brief
# description of each one:
#
# * NoSecurity - Well, no security at all.  Signed packages are treated like
#   unsigned packages.
# * LowSecurity - Pretty much no security.  If a package is signed then
#   RubyGems will make sure the signature matches the signing
#   certificate, and that the signing certificate hasn't expired, but
#   that's it.  A malicious user could easily circumvent this kind of
#   security.
# * MediumSecurity - Better than LowSecurity and NoSecurity, but still
#   fallible.  Package contents are verified against the signing
#   certificate, and the signing certificate is checked for validity,
#   and checked against the rest of the certificate chain (if you don't
#   know what a certificate chain is, stay tuned, we'll get to that).
#   The biggest improvement over LowSecurity is that MediumSecurity
#   won't install packages that are signed by untrusted sources.
#   Unfortunately, MediumSecurity still isn't totally secure -- a
#   malicious user can still unpack the gem, strip the signatures, and
#   distribute the gem unsigned.
# * HighSecurity - Here's the bugger that got us into this mess.
#   The HighSecurity policy is identical to the MediumSecurity policy,
#   except that it does not allow unsigned gems.  A malicious user
#   doesn't have a whole lot of options here; they can't modify the
#   package contents without invalidating the signature, and they can't
#   modify or remove signature or the signing certificate chain, or
#   RubyGems will simply refuse to install the package.  Oh well, maybe
#   they'll have better luck causing problems for CPAN users instead :).
#
# The reason RubyGems refused to install your shiny new signed gem was because
# it was from an untrusted source.  Well, your code is infallible (naturally),
# so you need to add yourself as a trusted source:
#
#   # add trusted certificate
#   gem cert --add ~/.gem/gem-public_cert.pem
#
# You've now added your public certificate as a trusted source.  Now you can
# install packages signed by your private key without any hassle.  Let's try
# the install command above again:
#
#   # install the gem with using the HighSecurity policy (and this time
#   # without any shenanigans)
#   $ gem install -P HighSecurity your-gem-1.0.gem
#   Successfully installed your-gem-1.0
#   1 gem installed
#
# This time RubyGems will accept your signed package and begin installing.
#
# While you're waiting for RubyGems to work it's magic, have a look at some of
# the other security commands by running <code>gem help cert</code>:
#
#   Options:
#     -a, --add CERT                   Add a trusted certificate.
#     -l, --list [FILTER]              List trusted certificates where the
#                                      subject contains FILTER
#     -r, --remove FILTER              Remove trusted certificates where the
#                                      subject contains FILTER
#     -b, --build EMAIL_ADDR           Build private key and self-signed
#                                      certificate for EMAIL_ADDR
#     -C, --certificate CERT           Signing certificate for --sign
#     -K, --private-key KEY            Key for --sign or --build
#     -A, --key-algorithm ALGORITHM    Select key algorithm for --build from RSA, DSA, or EC. Defaults to RSA.
#     -s, --sign CERT                  Signs CERT with the key from -K
#                                      and the certificate from -C
#     -d, --days NUMBER_OF_DAYS        Days before the certificate expires
#     -R, --re-sign                    Re-signs the certificate from -C with the key from -K
#
# We've already covered the <code>--build</code> option, and the
# <code>--add</code>, <code>--list</code>, and <code>--remove</code> commands
# seem fairly straightforward; they allow you to add, list, and remove the
# certificates in your trusted certificate list.  But what's with this
# <code>--sign</code> option?
#
# === Certificate chains
#
# To answer that question, let's take a look at "certificate chains", a
# concept I mentioned earlier.  There are a couple of problems with
# self-signed certificates: first of all, self-signed certificates don't offer
# a whole lot of security.  Sure, the certificate says Yukihiro Matsumoto, but
# how do I know it was actually generated and signed by matz himself unless he
# gave me the certificate in person?
#
# The second problem is scalability.  Sure, if there are 50 gem authors, then
# I have 50 trusted certificates, no problem.  What if there are 500 gem
# authors?  1000?  Having to constantly add new trusted certificates is a
# pain, and it actually makes the trust system less secure by encouraging
# RubyGems users to blindly trust new certificates.
#
# Here's where certificate chains come in.  A certificate chain establishes an
# arbitrarily long chain of trust between an issuing certificate and a child
# certificate.  So instead of trusting certificates on a per-developer basis,
# we use the PKI concept of certificate chains to build a logical hierarchy of
# trust.  Here's a hypothetical example of a trust hierarchy based (roughly)
# on geography:
#
#                         --------------------------
#                         | rubygems@rubygems.org |
#                         --------------------------
#                                     |
#                   -----------------------------------
#                   |                                 |
#       ----------------------------    -----------------------------
#       |  seattlerb@seattlerb.org |    | dcrubyists@richkilmer.com |
#       ----------------------------    -----------------------------
#            |                |                 |             |
#     ---------------   ----------------   -----------   --------------
#     |   drbrain   |   |   zenspider  |   | pabs@dc |   | tomcope@dc |
#     ---------------   ----------------   -----------   --------------
#
#
# Now, rather than having 4 trusted certificates (one for drbrain, zenspider,
# pabs@dc, and tomecope@dc), a user could actually get by with one
# certificate, the "rubygems@rubygems.org" certificate.
#
# Here's how it works:
#
# I install "rdoc-3.12.gem", a package signed by "drbrain".  I've never heard
# of "drbrain", but his certificate has a valid signature from the
# "seattle.rb@seattlerb.org" certificate, which in turn has a valid signature
# from the "rubygems@rubygems.org" certificate.  Voila!  At this point, it's
# much more reasonable for me to trust a package signed by "drbrain", because
# I can establish a chain to "rubygems@rubygems.org", which I do trust.
#
# === Signing certificates
#
# The <code>--sign</code> option allows all this to happen.  A developer
# creates their build certificate with the <code>--build</code> option, then
# has their certificate signed by taking it with them to their next regional
# Ruby meetup (in our hypothetical example), and it's signed there by the
# person holding the regional RubyGems signing certificate, which is signed at
# the next RubyConf by the holder of the top-level RubyGems certificate.  At
# each point the issue