ption
    openvpn-openssl-exception
    romic-exception
    stunnel-exception
    u-boot-exception-2.0
    vsftpd-openssl-exception
    x11vnc-openssl-exception
  ].freeze

  DEPRECATED_EXCEPTION_IDENTIFIERS = %w[
    Nokia-Qt-exception-1.1
  ].freeze

  VALID_REGEXP = /
    \A
    (?:
      #{Regexp.union(LICENSE_IDENTIFIERS)}
      \+?
      (?:\s WITH \s #{Regexp.union(EXCEPTION_IDENTIFIERS)})?
      | #{NONSTANDARD}
      | #{LICENSE_REF}
    )
    \Z
  /ox

  DEPRECATED_LICENSE_REGEXP = /
    \A
    #{Regexp.union(DEPRECATED_LICENSE_IDENTIFIERS)}
    \+?
    (?:\s WITH \s .+?)?
    \Z
  /ox

  DEPRECATED_EXCEPTION_REGEXP = /
    \A
    .+?
    \+?
    (?:\s WITH \s #{Regexp.union(DEPRECATED_EXCEPTION_IDENTIFIERS)})
    \Z
  /ox

  def self.match?(license)
    VALID_REGEXP.match?(license)
  end

  def self.deprecated_license_id?(license)
    DEPRECATED_LICENSE_REGEXP.match?(license)
  end

  def self.deprecated_exception_id?(license)
    DEPRECATED_EXCEPTION_REGEXP.match?(license)
  end

  def self.suggestions(license)
    by_distance = LICENSE_IDENTIFIERS.group_by do |identifier|
      levenshtein_distance(identifier, license)
    end
    lowest = by_distance.keys.min
    return unless lowest < license.size
    by_distance[lowest]
  end
end
                                                                                                                                                                                                                                                                              rubygems/rubygems/local_remote_options.rb                                                           0000644                 00000007133 15040313421 0015000 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

require_relative "vendor/uri/lib/uri"
require_relative "../rubygems"

##
# Mixin methods for local and remote Gem::Command options.

module Gem::LocalRemoteOptions
  ##
  # Allows Gem::OptionParser to handle HTTP URIs.

  def accept_uri_http
    Gem::OptionParser.accept Gem::URI::HTTP do |value|
      begin
        uri = Gem::URI.parse value
      rescue Gem::URI::InvalidURIError
        raise Gem::OptionParser::InvalidArgument, value
      end

      valid_uri_schemes = ["http", "https", "file", "s3"]
      unless valid_uri_schemes.include?(uri.scheme)
        msg = "Invalid uri scheme for #{value}\nPreface URLs with one of #{valid_uri_schemes.map {|s| "#{s}://" }}"
        raise ArgumentError, msg
      end

      value
    end
  end

  ##
  # Add local/remote options to the command line parser.

  def add_local_remote_options
    add_option(:"Local/Remote", "-l", "--local",
               "Restrict operations to the LOCAL domain") do |_value, options|
      options[:domain] = :local
    end

    add_option(:"Local/Remote", "-r", "--remote",
      "Restrict operations to the REMOTE domain") do |_value, options|
      options[:domain] = :remote
    end

    add_option(:"Local/Remote", "-b", "--both",
               "Allow LOCAL and REMOTE operations") do |_value, options|
      options[:domain] = :both
    end

    add_bulk_threshold_option
    add_clear_sources_option
    add_source_option
    add_proxy_option
    add_update_sources_option
  end

  ##
  # Add the --bulk-threshold option

  def add_bulk_threshold_option
    add_option(:"Local/Remote", "-B", "--bulk-threshold COUNT",
               "Threshold for switching to bulk",
               "synchronization (default #{Gem.configuration.bulk_threshold})") do |value, _options|
      Gem.configuration.bulk_threshold = value.to_i
    end
  end

  ##
  # Add the --clear-sources option

  def add_clear_sources_option
    add_option(:"Local/Remote", "--clear-sources",
               "Clear the gem sources") do |_value, options|
      Gem.sources = nil
      options[:sources_cleared] = true
    end
  end

  ##
  # Add the --http-proxy option

  def add_proxy_option
    accept_uri_http

    add_option(:"Local/Remote", "-p", "--[no-]http-proxy [URL]", Gem::URI::HTTP,
               "Use HTTP proxy for remote operations") do |value, options|
      options[:http_proxy] = value == false ? :no_proxy : value
      Gem.configuration[:http_proxy] = options[:http_proxy]
    end
  end

  ##
  # Add the --source option

  def add_source_option
    accept_uri_http

    add_option(:"Local/Remote", "-s", "--source URL", Gem::URI::HTTP,
               "Append URL to list of remote gem sources") do |source, options|
      source << "/" unless source.end_with?("/")

      if options.delete :sources_cleared
        Gem.sources = [source]
      else
        Gem.sources << source unless Gem.sources.include?(source)
      end
    end
  end

  ##
  # Add the --update-sources option

  def add_update_sources_option
    add_option(:Deprecated, "-u", "--[no-]update-sources",
               "Update local source cache") do |value, _options|
      Gem.configuration.update_sources = value
    end
  end

  ##
  # Is fetching of local and remote information enabled?

  def both?
    options[:domain] == :both
  end

  ##
  # Is local fetching enabled?

  def local?
    [:local, :both].include?(options[:domain])
  end

  ##
  # Is remote fetching enabled?

  def remote?
    [:remote, :both].include?(options[:domain])
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                     rubygems/rubygems/specification_policy.rb                                                           0000644                 00000037134 15040313421 0014763 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "user_interaction"

class Gem::SpecificationPolicy
  include Gem::UserInteraction

  VALID_NAME_PATTERN = /\A[a-zA-Z0-9\.\-\_]+\z/ # :nodoc:

  SPECIAL_CHARACTERS = /\A[#{Regexp.escape(".-_")}]+/ # :nodoc:

  VALID_URI_PATTERN = %r{\Ahttps?:\/\/([^\s:@]+:[^\s:@]*@)?[A-Za-z\d\-]+(\.[A-Za-z\d\-]+)+\.?(:\d{1,5})?([\/?]\S*)?\z} # :nodoc:

  METADATA_LINK_KEYS = %w[
    homepage_uri
    changelog_uri
    source_code_uri
    documentation_uri
    wiki_uri
    mailing_list_uri
    bug_tracker_uri
    download_uri
    funding_uri
  ].freeze # :nodoc:

  def initialize(specification)
    @warnings = 0

    @specification = specification
  end

  ##
  # If set to true, run packaging-specific checks, as well.

  attr_accessor :packaging

  ##
  # Does a sanity check on the specification.
  #
  # Raises InvalidSpecificationException if the spec does not pass the
  # checks.
  #
  # It also performs some validations that do not raise but print warning
  # messages instead.

  def validate(strict = false)
    validate_required!
    validate_required_metadata!

    validate_optional(strict) if packaging || strict

    true
  end

  ##
  # Does a sanity check on the specification.
  #
  # Raises InvalidSpecificationException if the spec does not pass the
  # checks.
  #
  # Only runs checks that are considered necessary for the specification to be
  # functional.

  def validate_required!
    validate_nil_attributes

    validate_rubygems_version

    validate_required_attributes

    validate_name

    validate_require_paths

    @specification.keep_only_files_and_directories

    validate_non_files

    validate_self_inclusion_in_files_list

    validate_specification_version

    validate_platform

    validate_array_attributes

    validate_authors_field

    validate_licenses_length

    validate_duplicate_dependencies
  end

  def validate_required_metadata!
    validate_metadata

    validate_lazy_metadata
  end

  def validate_optional(strict)
    validate_licenses

    validate_permissions

    validate_values

    validate_dependencies

    validate_required_ruby_version

    validate_extensions

    validate_removed_attributes

    validate_unique_links

    if @warnings > 0
      if strict
        error "specification has warnings"
      else
        alert_warning help_text
      end
    end
  end

  ##
  # Implementation for Specification#validate_for_resolution

  def validate_for_resolution
    validate_required!
  end

  ##
  # Implementation for Specification#validate_metadata

  def validate_metadata
    metadata = @specification.metadata

    unless Hash === metadata
      error "metadata must be a hash"
    end

    metadata.each do |key, value|
      entry = "metadata['#{key}']"
      unless key.is_a?(String)
        error "metadata keys must be a String"
      end

      if key.size > 128
        error "metadata key is too large (#{key.size} > 128)"
      end

      unless value.is_a?(String)
        error "#{entry} value must be a String"
      end

      if value.size > 1024
        error "#{entry} value is too large (#{value.size} > 1024)"
      end

      next unless METADATA_LINK_KEYS.include? key
      unless VALID_URI_PATTERN.match?(value)
        error "#{entry} has invalid link: #{value.inspect}"
      end
    end
  end

  ##
  # Checks that no duplicate dependencies are specified.

  def validate_duplicate_dependencies # :nodoc:
    # NOTE: see REFACTOR note in Gem::Dependency about types - this might be brittle
    seen = Gem::Dependency::TYPES.inject({}) {|types, type| types.merge({ type => {} }) }

    error_messages = []
    @specification.dependencies.each do |dep|
      if prev = seen[dep.type][dep.name]
        error_messages << <<-MESSAGE
duplicate 