ifications/default and extract only its bin") do |v,_o|
      options[:install_as_default] = v
    end

    add_option(:"Install/Update", "--explain",
               "Rather than install the gems, indicate which would",
               "be installed") do |v,_o|
      options[:explain] = v
    end

    add_option(:"Install/Update", "--[no-]lock",
               "Create a lock file (when used with -g/--file)") do |v,_o|
      options[:lock] = v
    end

    add_option(:"Install/Update", "--[no-]suggestions",
               "Suggest alternates when gems are not found") do |v,_o|
      options[:suggest_alternate] = v
    end

    add_option(:"Install/Update", "--target-rbconfig [FILE]",
                "rbconfig.rb for the deployment target platform") do |v, _o|
      Gem.set_target_rbconfig(v)
    end
  end

  ##
  # Default options for the gem install and update commands.

  def install_update_options
    {
      document: %w[ri],
    }
  end

  ##
  # Default description for the gem install and update commands.

  def install_update_defaults_str
    "--document=ri"
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                              rubygems/rubygems/util.rb                                                                           0000644                 00000004727 15040313421 0011543 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "deprecate"

##
# This module contains various utility methods as module methods.

module Gem::Util
  ##
  # Zlib::GzipReader wrapper that unzips +data+.

  def self.gunzip(data)
    require "zlib"
    require "stringio"
    data = StringIO.new(data, "r")

    gzip_reader = begin
                    Zlib::GzipReader.new(data)
                  rescue Zlib::GzipFile::Error => e
                    raise e.class, e.inspect, e.backtrace
                  end

    unzipped = gzip_reader.read
    unzipped.force_encoding Encoding::BINARY
    unzipped
  end

  ##
  # Zlib::GzipWriter wrapper that zips +data+.

  def self.gzip(data)
    require "zlib"
    require "stringio"
    zipped = StringIO.new(String.new, "w")
    zipped.set_encoding Encoding::BINARY

    Zlib::GzipWriter.wrap zipped do |io|
      io.write data
    end

    zipped.string
  end

  ##
  # A Zlib::Inflate#inflate wrapper

  def self.inflate(data)
    require "zlib"
    Zlib::Inflate.inflate data
  end

  ##
  # This calls IO.popen and reads the result

  def self.popen(*command)
    IO.popen command, &:read
  end

  ##
  # Invokes system, but silences all output.

  def self.silent_system(*command)
    opt = { out: IO::NULL, err: [:child, :out] }
    if Hash === command.last
      opt.update(command.last)
      cmds = command[0...-1]
    else
      cmds = command.dup
    end
    system(*(cmds << opt))
  end

  class << self
    extend Gem::Deprecate

    rubygems_deprecate :silent_system
  end

  ##
  # Enumerates the parents of +directory+.

  def self.traverse_parents(directory, &block)
    return enum_for __method__, directory unless block_given?

    here = File.expand_path directory
    loop do
      begin
        Dir.chdir here, &block
      rescue StandardError
        Errno::EACCES
      end

      new_here = File.expand_path("..", here)
      return if new_here == here # toplevel
      here = new_here
    end
  end

  ##
  # Globs for files matching +pattern+ inside of +directory+,
  # returning absolute paths to the matching files.

  def self.glob_files_in_dir(glob, base_path)
    Dir.glob(glob, base: base_path).map! {|f| File.expand_path(f, base_path) }
  end

  ##
  # Corrects +path+ (usually returned by `Gem::URI.parse().path` on Windows), that
  # comes with a leading slash.

  def self.correct_for_windows_path(path)
    if path[0].chr == "/" && path[1].chr.match?(/[a-z]/i) && path[2].chr == ":"
      path[1..-1]
    else
      path
    end
  end
end
                                         rubygems/rubygems/basic_specification.rb                                                            0000644                 00000020211 15040313421 0014531 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# BasicSpecification is an abstract class which implements some common code
# used by both Specification and StubSpecification.

class Gem::BasicSpecification
  ##
  # Allows installation of extensions for git: gems.

  attr_writer :base_dir # :nodoc:

  ##
  # Sets the directory where extensions for this gem will be installed.

  attr_writer :extension_dir # :nodoc:

  ##
  # Is this specification ignored for activation purposes?

  attr_writer :ignored # :nodoc:

  ##
  # The path this gemspec was loaded from.  This attribute is not persisted.

  attr_accessor :loaded_from

  ##
  # Allows correct activation of git: and path: gems.

  attr_writer :full_gem_path # :nodoc:

  def initialize
    internal_init
  end

  def self.default_specifications_dir
    Gem.default_specifications_dir
  end

  class << self
    extend Gem::Deprecate
    rubygems_deprecate :default_specifications_dir, "Gem.default_specifications_dir"
  end

  ##
  # The path to the gem.build_complete file within the extension install
  # directory.

  def gem_build_complete_path # :nodoc:
    File.join extension_dir, "gem.build_complete"
  end

  ##
  # True when the gem has been activated

  def activated?
    raise NotImplementedError
  end

  ##
  # Returns the full path to the base gem directory.
  #
  # eg: /usr/local/lib/ruby/gems/1.8

  def base_dir
    raise NotImplementedError
  end

  ##
  # Return true if this spec can require +file+.

  def contains_requirable_file?(file)
    if ignored?
      if platform == Gem::Platform::RUBY || Gem::Platform.local === platform
        warn "Ignoring #{full_name} because its extensions are not built. " \
             "Try: gem pristine #{name} --version #{version}"
      end

      return false
    end

    is_soext = file.end_with?(".so", ".o")

    if is_soext
      have_file? file.delete_suffix(File.extname(file)), Gem.dynamic_library_suffixes
    else
      have_file? file, Gem.suffixes
    end
  end

  ##
  # Return true if this spec should be ignored because it's missing extensions.

  def ignored?
    return @ignored unless @ignored.nil?

    @ignored = missing_extensions?
  end

  def default_gem?
    !loaded_from.nil? &&
      File.dirname(loaded_from) == Gem.default_specifications_dir
  end

  ##
  # Regular gems take precedence over default gems

  def default_gem_priority
    default_gem? ? 1 : -1
  end

  ##
  # Gems higher up in +gem_path+ take precedence

  def base_dir_priority(gem_path)
    gem_path.index(base_dir) || gem_path.size
  end

  ##
  # Returns full path to the directory where gem's extensions are installed.

  def extension_dir
    @extension_dir ||= File.expand_path(File.join(extensions_dir, full_name))
  end

  ##
  # Returns path to the extensions directory.

  def extensions_dir
    Gem.default_ext_dir_for(base_dir) ||
      File.join(base_dir, "extensions", Gem::Platform.local.to_s,
                Gem.extension_api_version)
  end

  def find_full_gem_path # :nodoc:
    File.expand_path File.join(gems_dir, full_name)
  end

  private :find_full_gem_path

  ##
  # The full path to the gem (install path + full name).
  #
  # TODO: This is duplicated with #gem_dir. Eventually either of them should be deprecated.

  def full_gem_path
    @full_gem_path ||= find_full_gem_path
  end

  ##
  # Returns the full name (name-version) of this Gem.  Platform information
  # is included (name-version-platform) if it is specified and not the
  # default Ruby platform.

  def full_name
    if platform == Gem::Platform::RUBY || platform.nil?
      "#{name}-#{version}"
    else
      "#{name}-#{version}-#{platform}"
    end
  end

  ##
  # Returns the full name of this Gem (see `Gem::BasicSpecification#full_name`).
  # Information about where the gem is installed is also included if not
  # installed in the default GEM_HOME.

  def full_name_with_location
    if base_dir != Gem.dir
      "#{full_name} in #{base_