certificate certificate_file

      yield certificate, certificate_file
    rescue OpenSSL::X509::CertificateError
      next # HACK: warn
    end
  end

  ##
  # Returns the issuer certificate of the given +certificate+ if it exists in
  # the trust directory.

  def issuer_of(certificate)
    path = name_path certificate.issuer

    return unless File.exist? path

    load_certificate path
  end

  ##
  # Returns the path to the trusted certificate with the given ASN.1 +name+

  def name_path(name)
    digest = @digester.hexdigest name.to_s

    File.join @dir, "cert-#{digest}.pem"
  end

  ##
  # Loads the given +certificate_file+

  def load_certificate(certificate_file)
    pem = File.read certificate_file

    OpenSSL::X509::Certificate.new pem
  end

  ##
  # Add a certificate to trusted certificate list.

  def trust_cert(certificate)
    verify

    destination = cert_path certificate

    File.open destination, "wb", 0o600 do |io|
      io.write certificate.to_pem
      io.chmod(@permissions[:trusted_cert])
    end
  end

  ##
  # Make sure the trust directory exists.  If it does exist, make sure it's
  # actually a directory.  If not, then create it with the appropriate
  # permissions.

  def verify
    require "fileutils"
    if File.exist? @dir
      raise Gem::Security::Exception,
        "trust directory #{@dir} is not a directory" unless
          File.directory? @dir

      FileUtils.chmod 0o700, @dir
    else
      FileUtils.mkdir_p @dir, mode: @permissions[:trust_dir]
    end
  end
end
     rubygems/rubygems/security/policy.rb                                                                0000644                 00000017461 15040313417 0013740 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../user_interaction"

##
# A Gem::Security::Policy object encapsulates the settings for verifying
# signed gem files.  This is the base class.  You can either declare an
# instance of this or use one of the preset security policies in
# Gem::Security::Policies.

class Gem::Security::Policy
  include Gem::UserInteraction

  attr_reader :name

  attr_accessor :only_signed
  attr_accessor :only_trusted
  attr_accessor :verify_chain
  attr_accessor :verify_data
  attr_accessor :verify_root
  attr_accessor :verify_signer

  ##
  # Create a new Gem::Security::Policy object with the given mode and
  # options.

  def initialize(name, policy = {}, opt = {})
    @name = name

    @opt = opt

    # Default to security
    @only_signed   = true
    @only_trusted  = true
    @verify_chain  = true
    @verify_data   = true
    @verify_root   = true
    @verify_signer = true

    policy.each_pair do |key, val|
      case key
      when :verify_data   then @verify_data   = val
      when :verify_signer then @verify_signer = val
      when :verify_chain  then @verify_chain  = val
      when :verify_root   then @verify_root   = val
      when :only_trusted  then @only_trusted  = val
      when :only_signed   then @only_signed   = val
      end
    end
  end

  ##
  # Verifies each certificate in +chain+ has signed the following certificate
  # and is valid for the given +time+.

  def check_chain(chain, time)
    raise Gem::Security::Exception, "missing signing chain" unless chain
    raise Gem::Security::Exception, "empty signing chain" if chain.empty?

    begin
      chain.each_cons 2 do |issuer, cert|
        check_cert cert, issuer