"use strict";(window.webpackJsonpAdministration=window.webpackJsonpAdministration||[]).push([[40021],{440021:function(e,n,t){t.r(n),t.d(n,{default:function(){return r}});let{Mixin:s}=Shopware,{Criteria:i}=Shopware.Data;var r={template:'{% block sw_settings_list %}\n{% block sw_settings_currency_index %}\n<sw-page class="sw-settings-currency-list">\n\n    {% block sw_settings_currency_list_language_switch %}\n    <template #language-switch>\n        <sw-language-switch @on-change="onChangeLanguage" />\n    </template>>\n    {% endblock %}\n\n    {% block sw_settings_currency_list_search_bar %}\n    <template #search-bar>\n        <sw-search-bar\n            initial-search-type="currency"\n            :placeholder="$tc(\'sw-settings-currency.general.placeholderSearchBar\')"\n            :initial-search="term"\n            @search="onSearch"\n        />\n    </template>\n    {% endblock %}\n\n    {% block sw_settings_currency_list_smart_bar_header %}\n    <template #smart-bar-header>\n        {% block sw_settings_currency_list_smart_bar_header_title %}\n        <h2>\n            {% block sw_settings_currency_list_smart_bar_header_title_text %}\n            {{ $tc(\'sw-settings.index.title\') }} <sw-icon\n                name="regular-chevron-right-xs"\n                small\n            /> {{ $tc(\'sw-settings-currency.list.textHeadline\') }}\n            {% endblock %}\n\n            {% block sw_settings_currency_list_smart_bar_header_amount %}\n            <span\n                v-if="!isLoading"\n                class="sw-page__smart-bar-amount"\n            >\n                ({{ total }})\n            </span>\n            {% endblock %}\n        </h2>\n        {% endblock %}\n    </template>\n    {% endblock %}\n\n    {% block sw_settings_currency_list_smart_bar_actions %}\n    <template #smart-bar-actions>\n        {% block sw_settings_currency_list_smart_bar_actions_add %}\n        <sw-button\n            :router-link="{ name: \'sw.settings.currency.create\' }"\n            class="sw-settings-currency-list__button-create"\n            :disabled="!acl.can(\'currencies.creator\') || undefined"\n            variant="primary"\n        >\n            {{ $tc(\'sw-settings-currency.list.buttonAddCurrency\') }}\n        </sw-button>\n        {% endblock %}\n    </template>\n    {% endblock %}\n\n    <template #content>\n        {% block sw_settings_currency_list_content %}\n        <div class="sw-currency-list__content">\n            <sw-entity-listing\n                v-if="isLoading || currency"\n                ref="swSettingsCurrencyGrid"\n                class="sw-settings-currency-list-grid"\n                :items="currency"\n                :columns="getCurrencyColumns()"\n                :repository="currencyRepository"\n                :full-page="false"\n                :allow-edit="acl.can(\'currencies.editor\')"\n                :allow-delete="acl.can(\'currencies.deleter\')"\n                :allow-inline-edit="acl.can(\'currencies.editor\') || undefined"\n                detail-route="sw.settings.currency.detail"\n                :show-selection="false"\n                :is-loading="isLoading"\n                :sort-by="sortBy"\n                :sort-direction="sortDirection"\n                :disable-data-fetching="true"\n                identifier="sw-settings-currency-list"\n                @page-change="onPageChange"\n                @column-sort="onSortColumn"\n                @inline-edit-save="onInlineEditSave"\n            >\n\n                {% block sw_settings_currency_list_grid_columns_actions %}\n                <template #actions="{ item }">\n                    {% block sw_settings_currency_list_grid_columns_actions_edit %}\n                    <sw-context-menu-item\n                        :disabled="!acl.can(\'currencies.editor\') || undefined"\n                        :router-link="{ name: \'sw.settings.currency.detail\', params: { id: item.id, edit: \'edit\' }}"\n                        class="sw-currency-list__edit-action"\n                    >\n                        {{ $tc(\'sw-settings-currency.list.contextMenuEdit\') }}\n                    </sw-context-menu-item>\n                    {% endblock %}\n\n                    {% block sw_settings_currency_list_grid_columns_actions_delete %}\n                    <sw-context-menu-item\n                        :disabled="item.isSystemDefault || !acl.can(\'currencies.deleter\') || undefined"\n                        variant="danger"\n                        class="sw-currency-list__delete-action"\n                        @click="onDelete(item.id)"\n                    >\n                        {{ $tc(\'sw-settings-currency.list.contextMenuDelete\') }}\n                    </sw-context-menu-item>\n                    {% endblock %}\n                </template>\n                {% endblock %}\n\n                {% block sw_settings_currency_list_grid_action_modals %}\n                <template #action-modals="{ item }">\n                    {% block sw_settings_currency_list_delete_modal %}\n                    <sw-modal\n                        v-if="showDeleteModal === item.id"\n                        :title="$tc(\'global.default.warning\')"\n                        variant="small"\n                        @modal-close="onCloseDeleteModal"\n                    >\n                        {% block sw_settings_currency_list_delete_modal_confirm_delete_text %}\n                        <p class="sw-settings-currency-list__confirm-delete-text">\n                            {{ $tc(\'sw-settings-currency.list.textDeleteConfirm\', 0, { name: item.name }) }}\n                        </p>\n                        {% endblock %}\n\n                        {% block sw_settings_currency_list_delete_modal_footer %}\n                        <template #modal-footer>\n                            {% block sw_settings_currency_list_delete_modal_cancel %}\n                            <sw-button\n                                size="small"\n                                @click="onCloseDeleteModal"\n                            >\n                                {{ $tc(\'global.default.cancel\') }}\n                            </sw-button>\n                            {% endblock %}\n\n                            {% block sw_settings_currency_list_delete_modal_confirm %}\n                            <sw-button\n                                variant="danger"\n                                size="small"\n                                @click="onConfirmDelete(item.id)"\n                            >\n                                {{ $tc(\'sw-settings-currency.list.buttonDelete\') }}\n                            </sw-button>\n                            {% endblock %}\n                        </template>\n                        {% endblock %}\n                    </sw-modal>\n                    {% endblock %}\n                </template>\n                {% endblock %}\n            </sw-entity-listing>\n        </div>\n        {% endblock %}\n    </template>\n</sw-page>\n    {% endblock %}\n{% endblock %}\n',compatConfig:Shopware.compatConfig,inject:["repositoryFactory","acl"],mixins:[s.getByName("listing"),s.getByName("notification")],data(){return{entityName:"currency",currency:null,sortBy:"currency.name",isLoading:!1,sortDirection:"ASC",naturalSorting:!0,showDeleteModal:!1}},metaInfo(){return{title:this.$createTitle()}},computed:{currencyRepository(){return this.repositoryFactory.create("currency")}},methods:{metaInfo(){return{title:this.$createTitle()}},getList(){let e=new i(this.page,this.limit);this.isLoading=!0,this.naturalSorting="name"===this.sortBy,e.setTerm(this.term),e.addSorting(i.sort(this.sortBy,this.sortDirection,this.naturalSorting)),this.currencyRepository.search(e).then(e=>(this.total=e.total,this.currency=e,this.isLoading=!1,e)).catch(()=>{this.isLoading=!1})},onChangeLanguage(e){Shopware.State.commit("context/setApiLanguageId",e),this.getList()},onInlineEditSave(e,n){e.then(()=>{this.createNotificationSuccess({message:this.$tc("sw-settings-currency.detail.messageSaveSuccess",0,{name:n.name})})}).catch(()=>{this.getList(),this.createNotificationError({message:this.$tc("sw-settings-currency.detail.messageSaveError")})})},onDelete(e){this.showDeleteModal=e},onCloseDeleteModal(){this.showDeleteModal=!1},onConfirmDelete(e){return this.showDeleteModal=!1,this.currencyRepository.delete(e).then(()=>{this.getList()})},getCurrencyColumns(){return[{property:"name",dataIndex:"name",inlineEdit:"string",label:"sw-settings-currency.list.columnName",routerLink:"sw.settings.currency.detail",width:"250px",primary:!0},{property:"shortName",inlineEdit:"string",label:"sw-settings-currency.list.columnShortName"},{property:"symbol",inlineEdit:"string",label:"sw-settings-currency.list.columnSymbol"},{property:"factor",inlineEdit:"string",label:"sw-settings-currency.list.columnFactor"}]}}}}}]);