/**
 * @sw-package after-sales
 */

/* eslint-disable max-len, sw-deprecation-rules/private-feature-declarations */
Shopware.Component.register('sw-settings-newsletter', () => import('./page/sw-settings-newsletter'));
/* eslint-enable max-len, sw-deprecation-rules/private-feature-declarations */

const { Module, Feature } = Shopware;

// eslint-disable-next-line sw-deprecation-rules/private-feature-declarations
Module.register('sw-settings-newsletter', {
    type: 'core',
    name: 'settings-newsletter',
    title: 'sw-settings-newsletter.general.mainMenuItemGeneral',
    description: 'sw-settings-newsletter.general.description',
    version: '1.0.0',
    targetVersion: '1.0.0',
    color: '#9AA8B5',
    icon: 'regular-cog',
    favicon: 'icon-module-settings.png',

    routes: {
        index: {
            component: 'sw-settings-newsletter',
            path: 'index',
            meta: {
                parentPath: 'sw.settings.index',
                privilege: 'system.system_config',
            },
        },
    },

    settingsItem: {
        group: function () {
            // @deprecated tag:v6.7.0 - Remove condition and function callback
            if (!Feature.isActive('v6.7.0.0')) {
                return 'shop';
            }

            return 'content';
        },
        to: 'sw.settings.newsletter.index',
        icon: 'regular-inbox',
        privilege: 'system.system_config',
    },
});
