(window.webpackJsonpAdministration=window.webpackJsonpAdministration||[]).push([[60243],{896827:function(){},160243:function(e,n,t){"use strict";t.r(n),t.d(n,{default:function(){return i}}),t(457984);let{Mixin:s,Defaults:a}=Shopware,{Criteria:l}=Shopware.Data;var i={template:'{% block sw_sales_channel_list %}\n<sw-page class="sw-sales-channel-list">\n    {% block sw_sales_channel_list_search_bar %}\n    <template #search-bar>\n        <sw-search-bar\n            initial-search-type="sales_channel"\n            :placeholder="$tc(\'sw-sales-channel.list.placeholderSearchBar\')"\n            :initial-search="term"\n            @search="onSearch"\n        />\n    </template>\n    {% endblock %}\n\n    {% block sw_sales_channel_list_smart_bar_header %}\n    <template #smart-bar-header>\n        {% block sw_sales_channel_list_smart_bar_header_title %}\n        <h2>\n            {% block sw_sales_channel_list_smart_bar_header_title_text %}\n            {{ $tc(\'sw-sales-channel.list.title\') }}\n            {% endblock %}\n\n            {% block sw_sales_channel_list_smart_bar_header_amount %}\n            <span\n                v-if="!isLoading"\n                class="sw-page__smart-bar-amount"\n            >\n                ({{ total }})\n            </span>\n            {% endblock %}\n        </h2>\n        {% endblock %}\n    </template>\n    {% endblock %}\n\n    {% block sw_sales_channel_list_actions %}\n    <template #smart-bar-actions>\n        {% block sw_sales_channel_list_smart_bar_actions %}\n        <sw-button\n            v-tooltip.bottom="{\n                message: $tc(\'sw-privileges.tooltip.warning\'),\n                disabled: acl.can(\'sales_channel.creator\'),\n                showOnDisabledElements: true\n            }"\n            :disabled="!acl.can(\'sales_channel.creator\')"\n            variant="primary"\n            @click="onAddSalesChannel"\n        >\n            {{ $tc(\'sw-sales-channel.list.buttonAddSalesChannel\') }}\n        </sw-button>\n        {% endblock %}\n    </template>\n    {% endblock %}\n\n    {% block sw_sales_channel_list_content %}\n    <template #content>\n        <sw-card-view>\n            {% block sw_sales_channel_list_content_card %}\n            <sw-card\n                v-if="entitySearchable && total > 0"\n                position-identifier="sw-sales-channel-list"\n                :title="$tc(\'sw-sales-channel.list.title\')"\n                :subtitle="$tc(\'sw-sales-channel.list.subTitle\')"\n            >\n                {% block sw_sales_channel_list_grid %}\n                <template #grid>\n                    <sw-entity-listing\n                        :is-loading="isLoading"\n                        identifier="sw-sales-channel-list"\n                        :columns="salesChannelColumns"\n                        :repository="salesChannelRepository"\n                        :items="salesChannels"\n                        :full-page="false"\n                        :show-selection="false"\n                        :sort-by="currentSortBy"\n                        :sort-direction="sortDirection"\n                        :plain-appearance="true"\n                        :show-settings="true"\n                        :allow-column-edit="true"\n                    >\n                        {% block sw_sales_channel_list_grid_column_name %}\n                        <template #column-name="{ item }">\n                            <sw-icon\n                                :name="item.type.iconName"\n                                size="18px"\n                            />\n                            <router-link\n                                :to="{\n                                    name: \'sw.sales.channel.detail\',\n                                    params: { id: item.id }\n                                }"\n                            >{{ item.translated.name || item.name }}</router-link>\n                        </template>\n                        {% endblock %}\n\n                        {# @deprecated tag:v6.7.0 - Remove block #}\n                        {% block sw_sales_channel_list_grid_column_product_visibilites %}\n                        <template #column-product_visibilities="{ item }">\n                            {{ getCountForSalesChannel(item.id) }}\n                            {{ $tc(\'sw-sales-channel.list.productsCount\', getCountForSalesChannel(item.id)) }}\n                        </template>\n                        {% endblock %}\n\n                        {% block sw_sales_channel_list_grid_column_status %}\n                        <template #column-status="{ item }">\n                            <template v-if="item.maintenance">\n                                <sw-status color="orange">\n                                    {{ $tc(\'sw-sales-channel.list.status.maintenance\') }}\n                                </sw-status>\n                            </template>\n\n                            <template v-else-if="item.active">\n                                <sw-status color="green">\n                                    {{ $tc(\'sw-sales-channel.list.status.online\') }}\n                                </sw-status>\n                            </template>\n\n                            <template v-else>\n                                <sw-status color="gray">\n                                    {{ $tc(\'sw-sales-channel.list.status.offline\') }}\n                                </sw-status>\n                            </template>\n                        </template>\n                        {% endblock %}\n\n                        {% block sw_sales_channel_list_grid_column_created_at %}\n                        <template #column-createdAt="{ item }">\n                            {{ dateFilter(item.createdAt, { hour: \'2-digit\', minute: \'2-digit\' }) }}\n                        </template>\n                        {% endblock %}\n\n                        {% block sw_sales_channel_list_grid_column_favorite %}\n                        <template #column-id="{ item }">\n                            <sw-switch-field\n                                v-tooltip.right="{ message: $tc(\'sw-sales-channel.detail.favouriteLabel\') }"\n                                class="favorite-switch"\n                                :disabled="!acl.can(\'user_config:create\') || !acl.can(\'user_config:update\')"\n                                :value="isFavorite(item.id)"\n                                @update:value="(isFavorite) => { salesChannelFavoritesService?.update(isFavorite, item.id) }"\n                            />\n                        </template>\n                        {% endblock %}\n\n                        {% block sw_sales_channel_list_grid_actions %}\n                        <template #actions="{ item }">\n                            {% block sw_sales_channel_list_grid_actions_item_detail %}\n                            <sw-context-menu-item\n                                :router-link="{\n                                    name: \'sw.sales.channel.detail\',\n                                    params: { id: item.id }\n                                }"\n                            >\n                                {{ $tc(\'sw-sales-channel.list.contextMenuEdit\') }}\n                            </sw-context-menu-item>\n                            {% endblock %}\n\n                            {% block sw_sales_channel_list_grid_actions_item_open_storefront %}\n                            <sw-context-menu-item\n                                v-if="isStorefrontSalesChannel(item)"\n                                :disabled="!item.active || !checkForDomainLink(item)"\n                                @click.prevent="openStorefrontLink(item.domainLink)"\n                            >\n                                {{ $tc(\'sw-sales-channel.general.tooltipOpenStorefront\') }}\n                            </sw-context-menu-item>\n                            {% endblock %}\n                        </template>\n                        {% endblock %}\n                    </sw-entity-listing>\n                </template>\n                {% endblock %}\n            </sw-card>\n            {% endblock %}\n\n            {% block sw_sales_channel_list_empty_state %}\n            <template v-if="!isLoading && !total">\n                <sw-empty-state\n                    v-if="isValidTerm(term)"\n                    :style="{ minHeight: \'200px\' }"\n                    :title="$tc(\'sw-empty-state.messageNoResultTitle\')"\n                >\n                    <template #default>\n                        {{ $tc(\'sw-empty-state.messageNoResultSublineBefore\') }}\n                        <router-link\n                            class="sw-empty-state__description-link"\n                            :to="{ name: \'sw.profile.index.searchPreferences\' }"\n                        >\n                            {{ $tc(\'sw-empty-state.messageNoResultSublineLink\') }}\n                        </router-link>\n                        {{ $tc(\'sw-empty-state.messageNoResultSublineAfter\') }}\n                    </template>\n                </sw-empty-state>\n            </template>\n            {% endblock %}\n        </sw-card-view>\n    </template>\n    {% endblock %}\n</sw-page>\n{% endblock %}\n',compatConfig:Shopware.compatConfig,inject:["repositoryFactory","acl","domainLinkService"],mixins:[s.getByName("listing")],data(){return{salesChannels:null,productsForSalesChannel:{},isLoading:!0,sortBy:"name",searchConfigEntity:"sales_channel",lastSortedColumn:null}},metaInfo(){return{title:this.$createTitle()}},computed:{salesChannelColumns(){let e=[{property:"name",dataIndex:"name",allowResize:!0,routerLink:"sw.sales.channel.detail",label:"sw-sales-channel.list.columnName",primary:!0},{property:"status",dataIndex:"status",allowResize:!0,sortable:!1,label:"sw-sales-channel.list.columnStatus"},{property:"id",dataIndex:"id",allowResize:!0,sortable:!1,label:"sw-sales-channel.list.columnFavourite",align:"center"},{property:"createdAt",dataIndex:"createdAt",allowResize:!0,label:"sw-sales-channel.list.columnCreatedAt"}];return e.splice(1,0,{property:"type.name",dataIndex:"type.name",allowResize:!0,label:"sw-sales-channel.list.columnType"}),e},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},salesChannelCriteria(){let e=new l(this.page,this.limit);return e.setTerm(this.term),e.addSorting(l.sort(this.sortBy,this.sortDirection,this.naturalSorting)),e.addAssociation("type"),e.addAssociation("domains"),e},salesChannelFavoritesService(){return Shopware.Service("salesChannelFavorites")},dateFilter(){return Shopware.Filter.getByName("date")}},methods:{onAddSalesChannel(){this.$root.$emit("on-add-sales-channel")},async getList(){this.isLoading=!0;let e=await this.addQueryScores(this.term,this.salesChannelCriteria);return this.entitySearchable?(this.freshSearchTerm&&e.resetSorting(),this.salesChannelRepository.search(e).then(e=>{this.salesChannels=e,this.total=e.total,this.isLoading=!1})):(this.isLoading=!1,this.total=0,!1)},setProductAggregations(e){this.productsForSalesChannel=e.reduce((e,n)=>({...e,[n.key]:n.visible_products?.count}),{})},getCountForSalesChannel(e){return this.productsForSalesChannel[e]??0},checkForDomainLink(e){let n=this.domainLinkService.getDomainLink(e);return null!==n&&(e.domainLink=n,!0)},openStorefrontLink(e){window.open(e,"_blank")},isFavorite(e){return this.salesChannelFavoritesService.isFavorite(e)},isStorefrontSalesChannel(e){return e.type.id===a.storefrontSalesChannelTypeId}}}},457984:function(e,n,t){var s=t(896827);s.__esModule&&(s=s.default),"string"==typeof s&&(s=[[e.id,s,""]]),s.locals&&(e.exports=s.locals),(0,t(370534).A)("37a632a0",s,!0,{})}}]);