"use strict";(window.webpackJsonpAdministration=window.webpackJsonpAdministration||[]).push([[60416],{660416:function(e,i,t){t.r(i),t.d(i,{default:function(){return r}});let{Component:n,Mixin:s}=Shopware,l=Shopware.Classes.ShopwareError,{mapPropertyErrors:a}=n.getComponentHelper();var r={template:'{% block sw_settings_delivery_time_detail %}\n<sw-page class="sw-settings-delivery-time-detail">\n\n    {% block sw_settings_delivery_time_detail_smart_bar_header %}\n    <template #smart-bar-header>\n        <h2>{{ displayName }}</h2>\n    </template>\n    {% endblock %}\n\n    {% block sw_settings_delivery_time_detail_language_switch %}\n    <template #language-switch>\n        <sw-language-switch\n            :disabled="!$route.params.id || undefined"\n            @on-change="onChangeLanguage"\n        />\n    </template>\n    {% endblock %}\n\n    {% block sw_settings_delivery_time_detail_smart_bar_actions %}\n    <template #smart-bar-actions>\n\n        {% block sw_settings_delivery_time_detail_smart_bar_actions_cancel %}\n        <sw-button\n            v-tooltip.bottom="tooltipCancel"\n            @click="onCancel"\n        >\n            {{ $tc(\'global.default.cancel\') }}\n        </sw-button>\n        {% endblock %}\n\n        {% block sw_settings_delivery_time_detail_smart_bar_actions_save %}\n        <sw-button-process\n            v-tooltip.bottom="tooltipSave"\n            class="sw-settings-delivery-time-detail__save"\n            :is-loading="isLoading"\n            :process-success="isSaveSuccessful"\n            :disabled="!allowSave || undefined"\n            variant="primary"\n            @update:process-success="saveFinish"\n            @click.prevent="onSave"\n        >\n            {{ $tc(\'sw-settings-delivery-time.general.buttonSave\') }}\n        </sw-button-process>\n        {% endblock %}\n    </template>\n    {% endblock %}\n\n    {% block sw_settings_delivery_time_detail_content %}\n    <template #content>\n        <sw-card-view>\n\n            <sw-skeleton v-if="isLoading" />\n\n            <template v-else>\n                {% block sw_settings_delivery_time_language_info %}\n                <sw-language-info\n                    :entity-description="displayName"\n                    :is-new-entity="!$route.params.id"\n                />\n                {% endblock %}\n\n                {% block sw_settings_delivery_time_detail_form %}\n                <sw-card\n                    :is-loading="isLoading"\n                    position-identifier="sw-settings-delivery-time-detail-form"\n                >\n                    <template v-if="deliveryTime">\n\n                        {% block sw_settings_delivery_time_detail_name_field %}\n                        <sw-text-field\n                            v-model:value="deliveryTime.name"\n                            name="sw-field--deliveryTime-name"\n                            :label="$tc(\'sw-settings-delivery-time.detail.labelName\')"\n                            :error="deliveryTimeNameError"\n                            :disabled="!acl.can(\'delivery_times.editor\') || undefined"\n                            required\n                        />\n                        {% endblock %}\n\n                        {% block sw_settings_delivery_time_detail_unit_field %}\n                        <sw-single-select\n                            v-model:value="deliveryTime.unit"\n                            name="sw-field--deliveryTime-unit"\n                            class="sw-delivery-time-detail__field-unit"\n                            :options="deliveryTimeUnits"\n                            :error="deliveryTimeUnitError"\n                            :label="$tc(\'sw-settings-delivery-time.detail.labelUnit\')"\n                            :disabled="!acl.can(\'delivery_times.editor\') || undefined"\n                            required\n                            show-clearable-button\n                        />\n                        {% endblock %}\n\n                        {% block sw_settings_delivery_time_min_max_container %}\n                        <sw-container\n                            columns="1fr 1fr"\n                            gap="30px"\n                        >\n\n                            {% block sw_settings_delivery_time_detail_min_field %}\n                            <sw-number-field\n                                v-model:value="deliveryTime.min"\n                                name="sw-field--deliveryTime-min"\n                                :label="$tc(\'sw-settings-delivery-time.detail.labelMin\')"\n                                :error="deliveryTimeMinError || invalidMinError"\n                                :min="0"\n                                :max="deliveryTime.max"\n                                :disabled="!acl.can(\'delivery_times.editor\') || undefined"\n                                required\n                            />\n                            {% endblock %}\n\n                            {% block sw_settings_delivery_time_detail_max_field %}\n                            <sw-number-field\n                                v-model:value="deliveryTime.max"\n                                name="sw-field--deliveryTime-max"\n                                :label="$tc(\'sw-settings-delivery-time.detail.labelMax\')"\n                                :error="deliveryTimeMaxError"\n                                :min="deliveryTime.min"\n                                :disabled="!acl.can(\'delivery_times.editor\') || undefined"\n                                required\n                            />\n                            {% endblock %}\n                        </sw-container>\n                        {% endblock %}\n                    </template>\n                </sw-card>\n                {% endblock %}\n\n                {% block sw_settings_delivery_time_detail_custom_field_sets %}\n                <sw-card\n                    v-if="showCustomFields"\n                    position-identifier="sw-settings-delivery-time-detail-custom-field-sets"\n                    :title="$tc(\'sw-settings-custom-field.general.mainMenuItemGeneral\')"\n                    :is-loading="isLoading"\n                >\n                    <sw-custom-field-set-renderer\n                        :entity="deliveryTime"\n                        :disabled="!acl.can(\'delivery_times.editor\') || undefined"\n                        :sets="customFieldSets"\n                    />\n                </sw-card>\n                {% endblock %}\n            </template>\n        </sw-card-view>\n    </template>\n    {% endblock %}\n</sw-page>\n{% endblock %}\n',compatConfig:Shopware.compatConfig,inject:["repositoryFactory","acl","customFieldDataProviderService"],mixins:[s.getByName("notification")],shortcuts:{"SYSTEMKEY+S":{active(){return this.allowSave},method:"onSave"},ESCAPE:"onCancel"},data(){return{deliveryTime:null,isLoading:!1,isSaveSuccessful:!1,customFieldSets:null}},metaInfo(){return{title:this.$createTitle()}},computed:{...a("deliveryTime",["name","min","max","unit"]),deliveryTimeRepository(){return this.repositoryFactory.create("delivery_time")},deliveryTimeUnits(){return[{value:"hour",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitHour")},{value:"day",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitDay")},{value:"week",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitWeek")},{value:"month",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitMonth")},{value:"year",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitYear")}]},displayName(){return this.deliveryTime&&this.deliveryTime.name?this.deliveryTime.name:this.$tc("sw-settings-delivery-time.detail.textHeadlineNew")},isInvalidMinField(){return this.deliveryTime.min>this.deliveryTime.max},invalidMinError(){return this.isInvalidMinField?new l({code:"DELIVERY_TIME_MIN_INVALID"}):null},allowSave(){return!!this.deliveryTime&&(this.deliveryTime.isNew()?this.acl.can("delivery_times.creator"):this.acl.can("delivery_times.editor"))},tooltipSave(){if(!this.allowSave)return{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.allowSave,showOnDisabledElements:!0};let e=this.$device.getSystemKey();return{message:`${e} + S`,appearance:"light"}},tooltipCancel(){return{message:"ESC",appearance:"light"}},showCustomFields(){return this.deliveryTime&&this.customFieldSets&&this.customFieldSets.length>0}},created(){this.createdComponent()},methods:{createdComponent(){this.isLoading=!0,this.loadCustomFieldSets(),this.deliveryTimeRepository.get(this.$route.params.id).then(e=>{this.deliveryTime=e,this.isLoading=!1}).catch(e=>{throw this.createNotificationError({message:this.$tc("sw-settings-delivery-time.detail.errorLoad")}),this.isLoading=!1,e})},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("delivery_time").then(e=>{this.customFieldSets=e})},onSave(){return this.isLoading=!0,this.isSaveSuccessful=!1,this.deliveryTimeRepository.save(this.deliveryTime,Shopware.Context.api).then(()=>{this.isLoading=!1,this.isSaveSuccessful=!0}).catch(e=>{throw this.createNotificationError({message:this.$tc("sw-settings-delivery-time.detail.errorSave")}),this.isLoading=!1,e})},onChangeLanguage(){this.createdComponent()},saveFinish(){this.isSaveSuccessful=!1},onCancel(){this.$router.push({name:"sw.settings.delivery.time.index"})}}}}}]);