<?php declare(strict_types=1);

namespace Shopware\Core\Framework\DataAbstractionLayer\Attribute;

use Shopware\Core\Framework\Log\Package;

#[Package('framework')]
#[\Attribute(\Attribute::TARGET_PROPERTY)]
class ForeignKey extends Field
{
    public const TYPE = 'fk';

    public bool $nullable;

    public function __construct(
        public string $entity,
        public bool|array $api = false,
        public ?string $column = null
    ) {
        parent::__construct(type: self::TYPE, api: $api, column: $column);
    }
}
