
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `shopware66105`
--


-- --------------------------------------------------------

--
-- Table structure for table `acl_role`
--

CREATE TABLE `acl_role` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `privileges` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_user_role`
--

CREATE TABLE `acl_user_role` (
  `user_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`acl_role_id`),
  KEY `fk.acl_user_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app`
--

CREATE TABLE `app` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(4096) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_app_url` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `allow_disable` tinyint(1) NOT NULL DEFAULT '1',
  `configurable` tinyint(1) NOT NULL DEFAULT '0',
  `icon` mediumblob,
  `app_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modules` json DEFAULT NULL,
  `main_module` json DEFAULT NULL,
  `cookies` json DEFAULT NULL,
  `allowed_hosts` json DEFAULT NULL,
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_load_priority` int DEFAULT '0',
  `checkout_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `self_managed` tinyint(1) NOT NULL DEFAULT '0',
  `source_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `source_config` json NOT NULL DEFAULT (json_object()),
  `in_app_purchases_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.name` (`name`),
  KEY `fk.app.integration_id` (`integration_id`),
  KEY `fk.app.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button`
--

CREATE TABLE `app_action_button` (
  `id` binary(16) NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `view` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_action_button.action` (`action`,`app_id`),
  KEY `fk.app_action_button.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button_translation`
--

CREATE TABLE `app_action_button_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_action_button_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  PRIMARY KEY (`app_action_button_id`,`language_id`),
  KEY `fk.app_action_button_translation.app_action_button_id` (`app_action_button_id`),
  KEY `fk.app_action_button_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_administration_snippet`
--

CREATE TABLE `app_administration_snippet` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `locale_id` binary(16) NOT NULL,
  `value` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_id` (`app_id`),
  KEY `fk.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block`
--

CREATE TABLE `app_cms_block` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `block` json NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `styles` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_cms_block.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block_translation`
--

CREATE TABLE `app_cms_block_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_cms_block_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_cms_block_id`,`language_id`),
  KEY `fk.app_cms_block_translation.app_cms_block_id` (`app_cms_block_id`),
  KEY `fk.app_cms_block_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_config`
--

CREATE TABLE `app_config` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action`
--

CREATE TABLE `app_flow_action` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `badge` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delayable` tinyint(1) NOT NULL DEFAULT '0',
  `parameters` json DEFAULT NULL,
  `config` json DEFAULT NULL,
  `headers` json DEFAULT NULL,
  `requirements` json DEFAULT NULL,
  `icon` mediumblob,
  `sw_icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_flow_action.name` (`name`),
  KEY `fk.app_flow_action.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action_translation`
--

CREATE TABLE `app_flow_action_translation` (
  `app_flow_action_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_flow_action_id`,`language_id`),
  KEY `fk.app_flow_action_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_event`
--

CREATE TABLE `app_flow_event` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `aware` json NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `uniq.app_flow_event.name` (`name`),
  KEY `fk.app_flow_event.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_payment_method`
--

CREATE TABLE `app_payment_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `payment_method_id` binary(16) NOT NULL,
  `app_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pay_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `finalize_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validate_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `capture_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refund_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `recurring_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_payment_method.payment_method_id` (`payment_method_id`),
  KEY `fk.app_payment_method.app_id` (`app_id`),
  KEY `fk.app_payment_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition`
--

CREATE TABLE `app_script_condition` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `script` longtext COLLATE utf8mb4_unicode_ci,
  `constraints` longblob,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_script_condition.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition_translation`
--

CREATE TABLE `app_script_condition_translation` (
  `app_script_condition_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_script_condition_id`,`language_id`),
  KEY `fk.app_script_condition_translation.app_script_condition_id` (`app_script_condition_id`),
  KEY `fk.app_script_condition_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_shipping_method`
--

CREATE TABLE `app_shipping_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `app_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_method_id` binary(16) NOT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `identifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_shipping_method.shipping_method_id` (`shipping_method_id`),
  KEY `fk.app_shipping_method.app_id` (`app_id`),
  KEY `fk.app_shipping_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_template`
--

CREATE TABLE `app_template` (
  `id` binary(16) NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.template.path` (`path`(256)),
  KEY `fk.template.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_translation`
--

CREATE TABLE `app_translation` (
  `app_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `privacy_policy_extensions` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_id`,`language_id`),
  KEY `fk.app_translation.app_id` (`app_id`),
  KEY `fk.app_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cart`
--

CREATE TABLE `cart` (
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule_ids` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `auto_increment` bigint NOT NULL AUTO_INCREMENT,
  `compressed` tinyint(1) NOT NULL DEFAULT '0',
  `payload` longblob,
  PRIMARY KEY (`token`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.cart.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category`
--

CREATE TABLE `category` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `auto_increment` int NOT NULL AUTO_INCREMENT,
  `parent_id` binary(16) DEFAULT NULL,
  `parent_version_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) DEFAULT NULL,
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `product_stream_id` binary(16) DEFAULT NULL,
  `product_assignment_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'product',
  `path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `after_category_id` binary(16) DEFAULT NULL,
  `after_category_version_id` binary(16) DEFAULT NULL,
  `level` int unsigned NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `child_count` int unsigned NOT NULL DEFAULT '0',
  `display_nested_products` tinyint unsigned NOT NULL DEFAULT '1',
  `visible` tinyint unsigned NOT NULL DEFAULT '1',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `custom_entity_type_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.level` (`level`),
  KEY `fk.category.media_id` (`media_id`),
  KEY `fk.category.parent_id` (`parent_id`,`parent_version_id`),
  KEY `fk.category.after_category_id` (`after_category_id`,`after_category_version_id`),
  KEY `fk.category.product_stream_id` (`product_stream_id`),
  KEY `fk.category.cms_page_id` (`cms_page_id`,`cms_page_version_id`),
  KEY `fk.category.custom_entity_type_id` (`custom_entity_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `category`
--

INSERT INTO `category` VALUES
('hA<q>Jj`=N', 'jK¾Ku,4%', 1, NULL, NULL, NULL, NULL, 'jK¾Ku,4%', NULL, 'product', NULL, NULL, NULL, 1, 1, 0, 1, 1, 'page', '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `category_tag`
--

CREATE TABLE `category_tag` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`tag_id`),
  KEY `fk.category_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `category_translation`
--

CREATE TABLE `category_translation` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `breadcrumb` json DEFAULT NULL,
  `internal_link` binary(16) DEFAULT NULL,
  `link_new_tab` tinyint DEFAULT NULL,
  `link_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`language_id`),
  KEY `fk.category_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `category_translation`
--

INSERT INTO `category_translation` VALUES
('hA<q>Jj`=N', 'jK¾Ku,4%', 'hA,r+(', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL),
('hA<q>Jj`=N', 'jK¾Ku,4%', '/_MpXT|', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_block`
--

CREATE TABLE `cms_block` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_section_id` binary(16) DEFAULT NULL,
  `cms_section_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `section_position` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'main',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `margin_top` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_bottom` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_left` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_right` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_block.background_media_id` (`background_media_id`),
  KEY `fk.cms_block.cms_section_id` (`cms_section_id`,`cms_section_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_block`
--

INSERT INTO `cms_block` VALUES
('hADIrN\r0K', 'jK¾Ku,4%', 'hA_rI^', 'jK¾Ku,4%', 2, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hADIrN\rğ', 'jK¾Ku,4%', 'hA_rI^', 'jK¾Ku,4%', 0, 'main', 'image-text', 'Category info', 1, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAdsuňk', 'jK¾Ku,4%', 'hA_rI^', 'jK¾Ku,4%', 1, 'main', 'sidebar-filter', 'Filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAdr\Z٥s', 'jK¾Ku,4%', 'hAdpتx ;"', 'jK¾Ku,4%', 0, 'main', 'image-text', 'Category info', 1, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAdr\Z٥p', 'jK¾Ku,4%', 'hAdpتx ;溄', 'jK¾Ku,4%', 1, 'sidebar', 'category-navigation', 'Sidebar navigation', 1, NULL, '30px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAdr\Z٥', 'jK¾Ku,4%', 'hAdpتx ;溄', 'jK¾Ku,4%', 2, 'sidebar', 'sidebar-filter', 'Sidebar filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAdr\Z٦Y', 'jK¾Ku,4%', 'hAdpتx ;溄', 'jK¾Ku,4%', 2, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAzréb\\QO', 'jK¾Ku,4%', 'hAzpj"ז2', 'jK¾Ku,4%', 1, 'main', 'form', 'Contact form', 1, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAz_q-r:[', 'jK¾Ku,4%', 'hAzUq?9''_lqá', 'jK¾Ku,4%', 1, 'main', 'form', 'Newsletter form', 1, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAp/l7', 'jK¾Ku,4%', 'hAr:', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAgq\\EGr', 'jK¾Ku,4%', 'hAgq\\EG*', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAq00,֥', 'jK¾Ku,4%', 'hAq0/Ы', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hArn2A', 'jK¾Ku,4%', 'hArnn', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hA8p2jjS', 'jK¾Ku,4%', 'hA8p2jc{', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAs3]', 'jK¾Ku,4%', 'hAp\nAU#V', 'jK¾Ku,4%', 0, 'main', 'product-heading', 'Product heading', 1, '0', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAs32', 'jK¾Ku,4%', 'hAp\nAU#V', 'jK¾Ku,4%', 1, 'main', 'gallery-buybox', 'Gallery buy box', 1, '20px', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAs3', 'jK¾Ku,4%', 'hAp\nAU#V', 'jK¾Ku,4%', 2, 'main', 'product-description-reviews', 'Product description and reviews', 1, '20px', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAs3mM', 'jK¾Ku,4%', 'hAp\nAU#V', 'jK¾Ku,4%', 3, 'main', 'cross-selling', 'Cross selling', 1, '0', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page`
--

CREATE TABLE `cms_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preview_media_id` binary(16) DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_page.preview_media_id` (`preview_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page`
--

INSERT INTO `cms_page` VALUES
('hAD5p.L3', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('hAds䇵', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('hAys씄ݸ', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('hAz<r60X', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('hAr9h&', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('hAgq\\EG', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('hAq0.֥', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('hArnw', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('hA8p2ir', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'product_detail', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page_translation`
--

CREATE TABLE `cms_page_translation` (
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_page_id`,`language_id`,`cms_page_version_id`),
  KEY `fk.cms_page_translation.language_id` (`language_id`),
  KEY `fk.cms_page_translation.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page_translation`
--

INSERT INTO `cms_page_translation` VALUES
('hAD5p.L3', 'jK¾Ku,4%', 'hA,r+(', 'Standard Kategorie-Layout', NULL, '[[regtime_]]', NULL),
('hAD5p.L3', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout', NULL, '[[regtime_]]', NULL),
('hAds䇵', 'jK¾Ku,4%', 'hA,r+(', 'Standard Kategorie-Layout mit Sidebar', NULL, '[[regtime_]]', NULL),
('hAds䇵', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout with sidebar', NULL, '[[regtime_]]', NULL),
('hAys씄ݸ', 'jK¾Ku,4%', 'hA,r+(', 'Standard Shopseiten-Layout mit Kontaktformular', NULL, '[[regtime_]]', NULL),
('hAys씄ݸ', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with contact form', NULL, '[[regtime_]]', NULL),
('hAz<r60X', 'jK¾Ku,4%', 'hA,r+(', 'Standard Shopseiten-Layout mit Newsletterformular', NULL, '[[regtime_]]', NULL),
('hAz<r60X', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with newsletter form', NULL, '[[regtime_]]', NULL),
('hAr9h&', 'jK¾Ku,4%', 'hA,r+(', 'Versand und Zahlung', NULL, '[[regtime_]]', NULL),
('hAr9h&', 'jK¾Ku,4%', '/_MpXT|', 'Payment / Shipping', NULL, '[[regtime_]]', NULL),
('hAgq\\EG', 'jK¾Ku,4%', 'hA,r+(', 'AGB', NULL, '[[regtime_]]', NULL),
('hAgq\\EG', 'jK¾Ku,4%', '/_MpXT|', 'Terms of service', NULL, '[[regtime_]]', NULL),
('hAq0.֥', 'jK¾Ku,4%', 'hA,r+(', 'Widerrufsbelehrungen', NULL, '[[regtime_]]', NULL),
('hAq0.֥', 'jK¾Ku,4%', '/_MpXT|', 'Right of rescission', NULL, '[[regtime_]]', NULL),
('hArnw', 'jK¾Ku,4%', 'hA,r+(', 'Datenschutz', NULL, '[[regtime_]]', NULL),
('hArnw', 'jK¾Ku,4%', '/_MpXT|', 'Privacy', NULL, '[[regtime_]]', NULL),
('hA8p2ir', 'jK¾Ku,4%', 'hA,r+(', 'Impressum', NULL, '[[regtime_]]', NULL),
('hA8p2ir', 'jK¾Ku,4%', '/_MpXT|', 'Imprint', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'hA,r+(', 'Standard Produktseite-Layout', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', '/_MpXT|', 'Default product page Layout', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_section`
--

CREATE TABLE `cms_section` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `sizing_mode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'boxed',
  `mobile_behavior` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'wrap',
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_section.background_media_id` (`background_media_id`),
  KEY `fk.cms_section.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_section`
--

INSERT INTO `cms_section` VALUES
('hA_rI^', 'jK¾Ku,4%', 'hAD5p.L3', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAdpتx ;"', 'jK¾Ku,4%', 'hAds䇵', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAdpتx ;溄', 'jK¾Ku,4%', 'hAds䇵', 'jK¾Ku,4%', 1, 'sidebar', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAzpj"ז2', 'jK¾Ku,4%', 'hAys씄ݸ', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAzUq?9''_lqá', 'jK¾Ku,4%', 'hAz<r60X', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAr:', 'jK¾Ku,4%', 'hAr9h&', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAgq\\EG*', 'jK¾Ku,4%', 'hAgq\\EG', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAq0/Ы', 'jK¾Ku,4%', 'hAq0.֥', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hArnn', 'jK¾Ku,4%', 'hArnw', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hA8p2jc{', 'jK¾Ku,4%', 'hA8p2ir', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('hAp\nAU#V', 'jK¾Ku,4%', 'zm%:g @7oB', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot`
--

CREATE TABLE `cms_slot` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `cms_block_id` binary(16) NOT NULL,
  `cms_block_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slot` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_slot.cms_block_id` (`cms_block_id`,`cms_block_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot`
--

INSERT INTO `cms_slot` VALUES
('hAD]pBPH', 'jK¾Ku,4%', 'hADIrN\r0K', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('hAD]pBPH&', 'jK¾Ku,4%', 'hADIrN\rğ', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('hAD]pBPHoE', 'jK¾Ku,4%', 'hADIrN\rğ', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('hAdr?ѿG\Z?', 'jK¾Ku,4%', 'hAdsuňk', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('hAdsTn', 'jK¾Ku,4%', 'hAdr\Z٥s', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('hAdsTh(', 'jK¾Ku,4%', 'hAdr\Z٥s', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('hAdsT\rX', 'jK¾Ku,4%', 'hAdr\Z٥p', 'jK¾Ku,4%', 'category-navigation', 'content', 1, '[[regtime_]]', NULL),
('hAdsT', 'jK¾Ku,4%', 'hAdr\Z٥', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('hAdsT', 'jK¾Ku,4%', 'hAdr\Z٥', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('hAdsTx$', 'jK¾Ku,4%', 'hAdr\Z٦Y', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('hAz!p45', 'jK¾Ku,4%', 'hAzréb\\QO', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('hAzgp? &}Ӗ', 'jK¾Ku,4%', 'hAz_q-r:[', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('hAp/v6', 'jK¾Ku,4%', 'hAp/l7', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('hAgq\\EG`e', 'jK¾Ku,4%', 'hAgq\\EGr', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('hAq00h', 'jK¾Ku,4%', 'hAq00,֥', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('hArnӤ', 'jK¾Ku,4%', 'hArn2A', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('hA8p2j', 'jK¾Ku,4%', 'hA8p2jjS', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('hAr-*=k', 'jK¾Ku,4%', 'hAs3]', 'jK¾Ku,4%', 'product-name', 'left', 1, '[[regtime_]]', NULL),
('hAr-*=&', 'jK¾Ku,4%', 'hAs3]', 'jK¾Ku,4%', 'manufacturer-logo', 'right', 1, '[[regtime_]]', NULL),
('hAr-*=', 'jK¾Ku,4%', 'hAs32', 'jK¾Ku,4%', 'image-gallery', 'left', 1, '[[regtime_]]', NULL),
('hAr-*=bN', 'jK¾Ku,4%', 'hAs32', 'jK¾Ku,4%', 'buy-box', 'right', 1, '[[regtime_]]', NULL),
('hAr-*=A', 'jK¾Ku,4%', 'hAs3', 'jK¾Ku,4%', 'product-description-reviews', 'content', 1, '[[regtime_]]', NULL),
('hAr-*=B', 'jK¾Ku,4%', 'hAs3mM', 'jK¾Ku,4%', 'cross-selling', 'content', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot_translation`
--

CREATE TABLE `cms_slot_translation` (
  `cms_slot_id` binary(16) NOT NULL,
  `cms_slot_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_slot_id`,`cms_slot_version_id`,`language_id`),
  KEY `fk.cms_slot_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot_translation`
--

INSERT INTO `cms_slot_translation` VALUES
('hAD]pBPH', 'jK¾Ku,4%', 'hA,r+(', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAD]pBPH', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAD]pBPH&', 'jK¾Ku,4%', 'hA,r+(', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAD]pBPH&', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAD]pBPHoE', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('hAD]pBPHoE', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('hAdr?ѿG\Z?', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('hAdsTn', 'jK¾Ku,4%', 'hA,r+(', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAdsTn', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAdsTh(', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('hAdsTh(', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('hAdsT\rX', 'jK¾Ku,4%', 'hA,r+(', NULL, NULL, '[[regtime_]]', NULL),
('hAdsT\rX', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('hAdsT', 'jK¾Ku,4%', 'hA,r+(', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAdsT', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAz!p45', 'jK¾Ku,4%', 'hA,r+(', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAz!p45', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAzgp? &}Ӗ', 'jK¾Ku,4%', 'hA,r+(', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAzgp? &}Ӗ', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAp/v6', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "<h2>Versand und Zahlung</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAp/v6', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Payment / Shipping</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAgq\\EG`e', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "<h2>AGB</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAgq\\EG`e', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Terms of service</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAq00h', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "<h2>Widerrufsbelehrungen</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAq00h', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Right of rescission</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hArnӤ', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "<h2>Datenschutz</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hArnӤ', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Privacy</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hA8p2j', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "<h2>Impressum</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hA8p2j', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Imprint</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=k', 'jK¾Ku,4%', 'hA,r+(', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=k', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=&', 'jK¾Ku,4%', 'hA,r+(', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=&', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=', 'jK¾Ku,4%', 'hA,r+(', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=', 'jK¾Ku,4%', '/_MpXT|', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=bN', 'jK¾Ku,4%', 'hA,r+(', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=bN', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=A', 'jK¾Ku,4%', 'hA,r+(', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=A', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=B', 'jK¾Ku,4%', 'hA,r+(', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('hAr-*=B', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `id` binary(16) NOT NULL,
  `iso` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `iso3` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `force_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `check_vat_id_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `vat_id_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_id_required` tinyint(1) NOT NULL DEFAULT '0',
  `customer_tax` json DEFAULT NULL,
  `company_tax` json DEFAULT NULL,
  `advanced_postal_code_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_advanced_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `check_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `default_postal_code_pattern` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code_required` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `shipping_available` tinyint(1) NOT NULL DEFAULT '1',
  `is_eu` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
('hA-r6sx', 'DE', 1, 1, 'DEU', 0, 0, 0, 'DE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('hA.s|-', 'GR', 10, 1, 'GRC', 0, 0, 0, '(EL|GR)\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('hA.r@RY', 'GB', 5, 1, 'GBR', 0, 0, 0, '(GB)?([0-9]{9}([0-9]{3})?|[A-Z]{2}[0-9]{3})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^GIR ?0AA$|^(?:(?:AB|AL|B|BA|BB|BD|BH|BL|BN|BR|BS|BT|BX|CA|CB|CF|CH|CM|CO|CR|CT|CV|CW|DA|DD|DE|DG|DH|DL|DN|DT|DY|E|EC|EH|EN|EX|FK|FY|G|GL|GY|GU|HA|HD|HG|HP|HR|HS|HU|HX|IG|IM|IP|IV|JE|KA|KT|KW|KY|L|LA|LD|LE|LL|LN|LS|LU|M|ME|MK|ML|N|NE|NG|NN|NP|NR|NW|OL|OX|PA|PE|PH|PL|PO|PR|RG|RH|RM|S|SA|SE|SG|SK|SL|SM|SN|SO|SP|SR|SS|ST|SW|SY|TA|TD|TF|TN|TQ|TR|TS|TW|UB|W|WA|WC|WD|WF|WN|WR|WS|WV|YO|ZE)(?:\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}))$|^BFPO ?\\d{1,4}$', 1, '[[regtime_]]', NULL, 1, 0),
('hA7pZl|', 'IE', 10, 1, 'IRL', 0, 0, 0, 'IE(\\d{7}[A-Z]{1,2}|(\\d{1}[A-Z]{1}\\d{5}[A-Z]{1}))', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[\\dA-Z]{3}( ?[\\dA-Z]{4})?', 1, '[[regtime_]]', NULL, 1, 1),
('hA8q年@', 'IS', 10, 1, 'ISL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hA8p\n\\M,e"', 'IT', 10, 1, 'ITA', 0, 0, 0, 'IT\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('hA8!sЊTqxWx', 'JP', 10, 1, 'JPN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}-?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hA8/s&}\n', 'CA', 10, 1, 'CAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[ABCEGHJKLMNPRSTVXY]\\d[ABCEGHJ-NPRSTV-Z] ?\\d[ABCEGHJ-NPRSTV-Z]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('hA8=r(q;U', 'LU', 10, 1, 'LUX', 0, 0, 0, 'LU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hA8Ks\nkm8', 'NA', 10, 1, 'NAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA8Zp (', 'NL', 10, 1, 'NLD', 0, 0, 0, 'NL\\d{9}B\\d{2}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]{1}\\d{3}([ ]?[A-Z]{2})', 1, '[[regtime_]]', NULL, 1, 1),
('hA8hqNtƈ', 'NO', 10, 1, 'NOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hA8vp}~p<B', 'AT', 10, 1, 'AUT', 0, 0, 0, 'ATU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hA8pRsQ', 'PT', 10, 1, 'PRT', 0, 0, 0, 'PT\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('hA8p''߅OZ', 'SE', 10, 1, 'SWE', 0, 0, 0, 'SE\\d{12}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('hA8p/`', 'CH', 10, 1, 'CHE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 1, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hA8st"', 'ES', 10, 1, 'ESP', 0, 0, 0, 'ES[A-Z]\\d{7}[A-Z]$|^ES[A-Z][0-9]{7}[0-9A-Z]$|^ES[0-9]{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^([0-4]\\d{4}|5[0-2]\\d{3})$', 1, '[[regtime_]]', NULL, 1, 1),
('hA8pGϕ|', 'US', 10, 1, 'USA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(\\d{5})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hA:rԖ/n', 'LI', 10, 1, 'LIE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '948[5-9]|949[0-7]', 1, '[[regtime_]]', NULL, 1, 0),
('hA:sDo', 'AE', 10, 1, 'ARE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA:rgؿD>', 'PL', 10, 1, 'POL', 0, 0, 0, 'PL\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('hA:q~Mo>', 'HU', 10, 1, 'HUN', 0, 0, 0, 'HU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hA;sk;-eL', 'TR', 10, 1, 'TUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA;pChv^O', 'CZ', 10, 1, 'CZE', 0, 0, 0, 'CZ\\d{8,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('hA;*rDp', 'SK', 10, 1, 'SVK', 0, 0, 0, 'SK\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('hA;8pބOrG\r', 'RO', 10, 1, 'ROU', 0, 0, 0, 'RO(?!0)\\d{1,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 1),
('hA;Fpuav\Z', 'BR', 10, 1, 'BRA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hA;Tp@IR', 'IL', 10, 1, 'ISR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('hA;cp''w^', 'AU', 10, 1, 'AUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hA;rr줙l]', 'BE', 10, 1, 'BEL', 0, 0, 0, 'BE\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hA;pe%!>', 'DK', 10, 1, 'DNK', 0, 0, 0, 'DK\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hA;r#~Ĥx}	', 'FI', 10, 1, 'FIN', 0, 0, 0, 'FI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('hA;rw4!', 'FR', 10, 1, 'FRA', 0, 0, 0, 'FR[A-HJ-NP-Z0-9]{2}\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{1}(?:A|B|\\d{1}) ?\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('hA3s\nc:3&', 'BG', 10, 1, 'BGR', 0, 0, 0, 'BG\\d{9,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hAOrl[4tcI', 'EE', 10, 1, 'EST', 0, 0, 0, 'EE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('hAjp4', 'HR', 10, 1, 'HRV', 0, 0, 0, 'HR\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('hAsBtk{O', 'LV', 10, 1, 'LVA', 0, 0, 0, 'LV\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LV-)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hArN}d', 'LT', 10, 1, 'LTU', 0, 0, 0, 'LT(\\d{12}|\\d{9})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LT-)?\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('hAr4~ൻ', 'MT', 10, 1, 'MLT', 0, 0, 0, 'MT\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{3} ?\\d{2,4}', 1, '[[regtime_]]', NULL, 1, 1),
('hArߐnV', 'SI', 10, 1, 'SVN', 0, 0, 0, 'SI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hAsgE!', 'CY', 10, 1, 'CYP', 0, 0, 0, 'CY\\d{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('hAqqZSB', 'AF', 10, 1, 'AFG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hArW1', 'AX', 10, 1, 'ALA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '22\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hA,rÁnK', 'AL', 10, 1, 'ALB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hA>sfgYw', 'DZ', 10, 1, 'DZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAQrޠU,Y', 'AS', 10, 1, 'ASM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(96799)(?  :[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAds버', 'AD', 10, 1, 'AND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'AD[1-7]0\\d', 1, '[[regtime_]]', NULL, 1, 0),
('hAup{<', 'AO', 10, 1, 'AGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAr+EB!-', 'AI', 10, 1, 'AIA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:AI-)?2640', 1, '[[regtime_]]', NULL, 1, 0),
('hAsL	au^', 'AQ', 10, 1, 'ATA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAs-]''', 'AG', 10, 1, 'ATG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAq5ESS\Zt', 'AR', 10, 1, 'ARG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '((?:[A-HJ-NP-Z])?\\d{4})([A-Z]{3})?', 1, '[[regtime_]]', NULL, 1, 0),
('hApID-', 'AM', 10, 1, 'ARM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:37)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAra7', 'AW', 10, 1, 'ABW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAqֈTed<*', 'AZ', 10, 1, 'AZE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAr6Ǿͬ', 'BS', 10, 1, 'BHS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA#r@1S8+U', 'BH', 10, 1, 'BHR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d|1[0-2])\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hA6pT\rY', 'BD', 10, 1, 'BGD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAHs[G', 'BB', 10, 1, 'BRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'BB\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA[pb͑b', 'BY', 10, 1, 'BLR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqs"y\\', 'BZ', 10, 1, 'BLZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAr0DIb', 'BJ', 10, 1, 'BEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAsꏸ', 'BM', 10, 1, 'BMU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?[A-Z0-9]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hArJt\r', 'BT', 10, 1, 'BTN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsixg1<', 'BO', 10, 1, 'BOL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsM:o', 'BQ', 10, 1, 'BES', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAsMw~6b}', 'BA', 10, 1, 'BIH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsZN', 'BW', 10, 1, 'BWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAq	L̤', 'BV', 10, 1, 'BVT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA\Zr53\Z', 'IO', 10, 1, 'IOT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Bb]{2}[Nn][Dd]\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hA.r-犕g', 'UM', 10, 1, 'UMI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '96898', 1, '[[regtime_]]', NULL, 1, 0),
('hA@sL', 'VG', 10, 1, 'VGB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VG\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAVqSi', 'VI', 10, 1, 'VIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(008(?:(?:[0-4]\\d)|(?:5[01])))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAjqrND.', 'BN', 10, 1, 'BRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAq% ', 'BF', 10, 1, 'BFA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hArHz,!b', 'BI', 10, 1, 'BDI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAsiMY8lk', 'KH', 10, 1, 'KHM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqrHL', 'CM', 10, 1, 'CMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hApꐣ8ض', 'CV', 10, 1, 'CPV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp~0I[', 'KY', 10, 1, 'CYM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'KY\\d-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAr''dR', 'CF', 10, 1, 'CAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA''pK4SIk0', 'TD', 10, 1, 'TCD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAKp|ع	', 'CL', 10, 1, 'CHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{7}', 1, '[[regtime_]]', NULL, 1, 0),
('hAjqqw\0', 'CN', 10, 1, 'CHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAq3`''}', 'CX', 10, 1, 'CXR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6798', 1, '[[regtime_]]', NULL, 1, 0),
('hAp뇿Z', 'CC', 10, 1, 'CCK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6799', 1, '[[regtime_]]', NULL, 1, 0),
('hApŅ>R ', 'CO', 10, 1, 'COL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp@Jt', 'KM', 10, 1, 'COM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA\rpڌ~3\Z', 'CG', 10, 1, 'COG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA pi^', 'CD', 10, 1, 'COD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Cc][Dd]', 1, '[[regtime_]]', NULL, 1, 0),
('hA4r|\0Jn', 'CK', 10, 1, 'COK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAJqwCq[', 'CR', 10, 1, 'CRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}|\\d{3}-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hA^q䎡', 'CU', 10, 1, 'CUB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAos#|', 'CW', 10, 1, 'CUW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAp>=QA;', 'DJ', 10, 1, 'DJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAp*Ұ', 'DM', 10, 1, 'DMA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hArBRm', 'DO', 10, 1, 'DOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hArc3', 'EC', 10, 1, 'ECU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hApD`^e', 'EG', 10, 1, 'EGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqk`z', 'SV', 10, 1, 'SLV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'CP [1-3][1-7][0-2]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('hAs3NK', 'GQ', 10, 1, 'GNQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA!rl''', 'ER', 10, 1, 'ERI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA3rɦ=j4w', 'ET', 10, 1, 'ETH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hACpL](?', 'FK', 10, 1, 'FLK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ff][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hASsʩ', 'FO', 10, 1, 'FRO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hAbpJ', 'FJ', 10, 1, 'FJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAvqÈ', 'GF', 10, 1, 'GUF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]3\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsxdň', 'PF', 10, 1, 'PYF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '987\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqZq$H', 'TF', 10, 1, 'ATF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAqxE[J', 'GA', 10, 1, 'GAB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}\\s[a-zA-Z-_ ]\\s\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqCdI	', 'GM', 10, 1, 'GMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAprK*xP', 'GE', 10, 1, 'GEO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsHCO', 'GH', 10, 1, 'GHA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAp?a\0Ogwz', 'GI', 10, 1, 'GIB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Gg][Xx][1]{2}\\s{0,1}[1][Aa]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hA\rp@#', 'GL', 10, 1, 'GRL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '39\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqqKȩ', 'GD', 10, 1, 'GRD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA4p餆h~!', 'GP', 10, 1, 'GLP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAFrN5*', 'GU', 10, 1, 'GUM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:[12]\\d|3[12]))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAVqțl@ڜ', 'GT', 10, 1, 'GTM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAhqϷ$Qm', 'GG', 10, 1, 'GGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'GY\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAyrcˎvZ', 'GN', 10, 1, 'GIN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp!', 'GW', 10, 1, 'GNB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsKk~', 'GY', 10, 1, 'GUY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAqq5	', 'HT', 10, 1, 'HTI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp䛇vU', 'HM', 10, 1, 'HMD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hApf', 'VA', 10, 1, 'VAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '00120', 1, '[[regtime_]]', NULL, 1, 0),
('hApBc2I', 'HN', 10, 1, 'HND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp\\D4', 'HK', 10, 1, 'HKG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999077', 1, '[[regtime_]]', NULL, 1, 0),
('hA rVXN4Q', 'IN', 10, 1, 'IND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hA>rH<Tjm', 'ID', 10, 1, 'IDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAVr', 'CI', 10, 1, 'CIV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAosT)fE', 'IR', 10, 1, 'IRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqHvL"', 'IQ', 10, 1, 'IRQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hApQ*V#', 'IM', 10, 1, 'IMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'IM\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp*O*P', 'JM', 10, 1, 'JAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[a-zA-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAq?a(c', 'JE', 10, 1, 'JEY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'JE\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hArgd|', 'JO', 10, 1, 'JOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqU[', 'KZ', 10, 1, 'KAZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAq(@\\(;U', 'KE', 10, 1, 'KEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA0sտv^y', 'KI', 10, 1, 'KIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAAsty{&"', 'KW', 10, 1, 'KWT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAVr{\Z]L8', 'KG', 10, 1, 'KGZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAgrM\nO7=', 'LA', 10, 1, 'LAO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAwqúKD\Z', 'LB', 10, 1, 'LBN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d{4})(?: ?(?:\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAq7(h', 'LS', 10, 1, 'LSO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hAr/\r+`', 'LR', 10, 1, 'LBR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hApoI', 'LY', 10, 1, 'LBY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAr콠*\\', 'MO', 10, 1, 'MAC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999078', 1, '[[regtime_]]', NULL, 1, 0),
('hAr/3_', 'MK', 10, 1, 'MKD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp@I){=', 'MG', 10, 1, 'MDG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hApO77%', 'MW', 10, 1, 'MWI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAr6p', 'MY', 10, 1, 'MYS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hApѷu\r^', 'MV', 10, 1, 'MDV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA''q!Qt,', 'ML', 10, 1, 'MLI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA7sl"t', 'MH', 10, 1, 'MHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969[67]\\d)(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAGs߯\0N/', 'MQ', 10, 1, 'MTQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]2\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAWrQUX', 'MR', 10, 1, 'MRT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAgrWo\\', 'MU', 10, 1, 'MUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|[A-Z]{2}\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('hA}rI<', 'YT', 10, 1, 'MYT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '976\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAr~A}K/', 'MX', 10, 1, 'MEX', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsaL8	.', 'FM', 10, 1, 'FSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9694[1-4])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAr5', 'MD', 10, 1, 'MDA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hApSIo\Z(8', 'MC', 10, 1, 'MCO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '980\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqO |h', 'MN', 10, 1, 'MNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp3h!', 'ME', 10, 1, 'MNE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '8\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hArsd@', 'MS', 10, 1, 'MSR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Mm][Ss][Rr]\\s{0,1}\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAq!~F', 'MA', 10, 1, 'MAR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA!p~', 'MZ', 10, 1, 'MOZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hA0pȭ[(', 'MM', 10, 1, 'MMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hADsq', 'NR', 10, 1, 'NRU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);
INSERT INTO `country` VALUES
('hATr6nb0', 'NP', 10, 1, 'NPL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAcr.(*V$', 'NC', 10, 1, 'NCL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '988\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hArs=', 'NZ', 10, 1, 'NZL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAs	΄', 'NI', 10, 1, 'NIC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqDi', 'NE', 10, 1, 'NER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAq\nf]', 'NG', 10, 1, 'NGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAr*LZq', 'NU', 10, 1, 'NIU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAr2@', 'NF', 10, 1, 'NFK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '2899', 1, '[[regtime_]]', NULL, 1, 0),
('hAr	h', 'KP', 10, 1, 'PRK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hArMr''', 'MP', 10, 1, 'MNP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9695[012])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAqBY\rt', 'OM', 10, 1, 'OMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:PC )?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hA%p)ykhs', 'PK', 10, 1, 'PAK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA=rd#', 'PW', 10, 1, 'PLW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:39|40))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAWq)V ', 'PS', 10, 1, 'PSE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hArs?i};', 'PA', 10, 1, 'PAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsȡ8Ԧ', 'PG', 10, 1, 'PNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hAs\r;\Z#', 'PY', 10, 1, 'PRY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqלrsT)V', 'PE', 10, 1, 'PER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:LIMA \\d{1,2}|CALLAO 0?\\d)|[0-2]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqA`V', 'PH', 10, 1, 'PHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqhfL', 'PN', 10, 1, 'PCN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'PCRN 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('hAqtnf-+T', 'PR', 10, 1, 'PRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(00[679]\\d{2})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('hAs:G', 'QA', 10, 1, 'QAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAq[zE>zQ\0', 'XK', 10, 1, 'KOS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-7]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hA#pO', 'RE', 10, 1, 'REU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]4\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hA2pqp2o', 'RU', 10, 1, 'RUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hABrg(xW', 'RW', 10, 1, 'RWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAQrX\\7R솚', 'BL', 10, 1, 'BLM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAap1ry5(\0', 'SH', 10, 1, 'SHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:ASCN|STHL) 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('hAqq.=>pA', 'KN', 10, 1, 'KNA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAq.x?l', 'LC', 10, 1, 'LCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAruS+}', 'MF', 10, 1, 'MAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hArCOhi', 'PM', 10, 1, 'SPM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]5\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsb>', 'VC', 10, 1, 'VCT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VC\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hApFJu', 'WS', 10, 1, 'WSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAs݀', 'SM', 10, 1, 'SMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '4789\\d', 1, '[[regtime_]]', NULL, 1, 0),
('hAs\0HN*#)', 'ST', 10, 1, 'STP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAr(LAlKD', 'SA', 10, 1, 'SAU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hApN?G^', 'SN', 10, 1, 'SEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsݼ*$#', 'RS', 10, 1, 'SRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5,6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAr}:F$', 'SC', 10, 1, 'SYC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA/r^+^sя', 'SL', 10, 1, 'SLE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA>p?FEP6', 'SG', 10, 1, 'SGP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hANpΙ	', 'SX', 10, 1, 'SXM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA^qܿ7\\', 'SB', 10, 1, 'SLB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAmpdnZ', 'SO', 10, 1, 'SOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hA}p{樵l', 'ZA', 10, 1, 'ZAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqXW`^', 'GS', 10, 1, 'SGS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ss][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqH<ѱ', 'KR', 10, 1, 'KOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|-\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('hApϺ[m\\2', 'SS', 10, 1, 'SSD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hArq(c', 'LK', 10, 1, 'LKA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAp>-P', 'SD', 10, 1, 'SDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hApi8-', 'SR', 10, 1, 'SUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hApͬ''\\0+g', 'SJ', 10, 1, 'SJM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAs{4zO', 'SZ', 10, 1, 'SWZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[HLMS]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('hA$rό\r', 'SY', 10, 1, 'SYR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA4rJ', 'TW', 10, 1, 'TWN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('hADq2e', 'TJ', 10, 1, 'TJK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hASr|@', 'TZ', 10, 1, 'TZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAcqlj=y', 'TH', 10, 1, 'THA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsr''', 'TL', 10, 1, 'TLS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAqhy&4', 'TG', 10, 1, 'TGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAqO$o', 'TK', 10, 1, 'TKL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAsߞ23', 'TO', 10, 1, 'TON', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAp.%8y', 'TT', 10, 1, 'TTO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hApZG"', 'TN', 10, 1, 'TUN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAs', 'TM', 10, 1, 'TKM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsܶl&nk', 'TC', 10, 1, 'TCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'TKCA 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('hAp4M', 'TV', 10, 1, 'TUV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hA2r"', 'UG', 10, 1, 'UGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hANqM!t', 'UA', 10, 1, 'UKR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAlqw', 'UY', 10, 1, 'URY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hArRv_', 'UZ', 10, 1, 'UZB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAqJ8Fl', 'VU', 10, 1, 'VUT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hArݭNh2', 'VE', 10, 1, 'VEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('hAq:PϦ', 'VN', 10, 1, 'VNM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('hAs\\_f', 'WF', 10, 1, 'WLF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '986\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('hArԅL\r%b', 'EH', 10, 1, 'ESH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hAsG+ei', 'YE', 10, 1, 'YEM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('hAs[adXU', 'ZM', 10, 1, 'ZMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('hApac6t', 'ZW', 10, 1, 'ZWE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `country_state`
--

CREATE TABLE `country_state` (
  `id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `short_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.country_state.country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state`
--

INSERT INTO `country_state` VALUES
('hA-p', 'hA-r6sx', 'DE-BW', 1, 1, '[[regtime_]]', NULL),
('hA.rh!', 'hA-r6sx', 'DE-BY', 1, 1, '[[regtime_]]', NULL),
('hA.sj;kvh', 'hA-r6sx', 'DE-BE', 1, 1, '[[regtime_]]', NULL),
('hA.!p;A9', 'hA-r6sx', 'DE-BB', 1, 1, '[[regtime_]]', NULL),
('hA.2qw', 'hA-r6sx', 'DE-HB', 1, 1, '[[regtime_]]', NULL),
('hA.@qh', 'hA-r6sx', 'DE-HH', 1, 1, '[[regtime_]]', NULL),
('hA.Mp\\}Nk', 'hA-r6sx', 'DE-HE', 1, 1, '[[regtime_]]', NULL),
('hA.Zs	Mk', 'hA-r6sx', 'DE-NI', 1, 1, '[[regtime_]]', NULL),
('hA.hqW''', 'hA-r6sx', 'DE-MV', 1, 1, '[[regtime_]]', NULL),
('hA.vqV$h', 'hA-r6sx', 'DE-NW', 1, 1, '[[regtime_]]', NULL),
('hA.sY', 'hA-r6sx', 'DE-RP', 1, 1, '[[regtime_]]', NULL),
('hA.ppD', 'hA-r6sx', 'DE-SL', 1, 1, '[[regtime_]]', NULL),
('hA.r;rC~', 'hA-r6sx', 'DE-SN', 1, 1, '[[regtime_]]', NULL),
('hA.s뢫MԖ6D', 'hA-r6sx', 'DE-ST', 1, 1, '[[regtime_]]', NULL),
('hA.q޿BѺ;', 'hA-r6sx', 'DE-SH', 1, 1, '[[regtime_]]', NULL),
('hA.somLs!H_', 'hA-r6sx', 'DE-TH', 1, 1, '[[regtime_]]', NULL),
('hA.p^u', 'hA.r@RY', 'GB-ENG', 1, 1, '[[regtime_]]', NULL),
('hA/\0rlMoA', 'hA.r@RY', 'GB-NIR', 1, 1, '[[regtime_]]', NULL),
('hA/	rT^d', 'hA.r@RY', 'GB-SCT', 1, 1, '[[regtime_]]', NULL),
('hA/rk8֦d', 'hA.r@RY', 'GB-WLS', 1, 1, '[[regtime_]]', NULL),
('hA/sXʠIvy^', 'hA.r@RY', 'GB-EAW', 1, 1, '[[regtime_]]', NULL),
('hA/#ptOXb', 'hA.r@RY', 'GB-GBN', 1, 1, '[[regtime_]]', NULL),
('hA/,rf\Z`', 'hA.r@RY', 'GB-UKM', 1, 1, '[[regtime_]]', NULL),
('hA/6rBտ+', 'hA.r@RY', 'GB-BKM', 1, 1, '[[regtime_]]', NULL),
('hA/Aq[U]I)', 'hA.r@RY', 'GB-CAM', 1, 1, '[[regtime_]]', NULL),
('hA/Jr`H''RA', 'hA.r@RY', 'GB-CMA', 1, 1, '[[regtime_]]', NULL),
('hA/Sr[:-,', 'hA.r@RY', 'GB-DBY', 1, 1, '[[regtime_]]', NULL),
('hA/`s{؛4ZV', 'hA.r@RY', 'GB-DEV', 1, 1, '[[regtime_]]', NULL),
('hA/is<Sr', 'hA.r@RY', 'GB-DOR', 1, 1, '[[regtime_]]', NULL),
('hA/rr_A\nH/Y', 'hA.r@RY', 'GB-ESX', 1, 1, '[[regtime_]]', NULL),
('hA/{r.-(\0s	', 'hA.r@RY', 'GB-ESS', 1, 1, '[[regtime_]]', NULL),
('hA/qMo@W=', 'hA.r@RY', 'GB-GLS', 1, 1, '[[regtime_]]', NULL),
('hA/sAI+J	', 'hA.r@RY', 'GB-HAM', 1, 1, '[[regtime_]]', NULL),
('hA/qd)\r', 'hA.r@RY', 'GB-HRT', 1, 1, '[[regtime_]]', NULL),
('hA/q ֿy', 'hA.r@RY', 'GB-KEN', 1, 1, '[[regtime_]]', NULL),
('hA/q&._/ƀ', 'hA.r@RY', 'GB-LAN', 1, 1, '[[regtime_]]', NULL),
('hA/qZR<Ux', 'hA.r@RY', 'GB-LEC', 1, 1, '[[regtime_]]', NULL),
('hA/p\Z8²', 'hA.r@RY', 'GB-LIN', 1, 1, '[[regtime_]]', NULL),
('hA/r5L', 'hA.r@RY', 'GB-NFK', 1, 1, '[[regtime_]]', NULL),
('hA/p}uRd', 'hA.r@RY', 'GB-NYK', 1, 1, '[[regtime_]]', NULL),
('hA/sP08Up', 'hA.r@RY', 'GB-NTH', 1, 1, '[[regtime_]]', NULL),
('hA/s;p\nX', 'hA.r@RY', 'GB-NTT', 1, 1, '[[regtime_]]', NULL),
('hA0s"', 'hA.r@RY', 'GB-OXF', 1, 1, '[[regtime_]]', NULL),
('hA0q1h\n*X', 'hA.r@RY', 'GB-SOM', 1, 1, '[[regtime_]]', NULL),
('hA0#s/5οE', 'hA.r@RY', 'GB-STS', 1, 1, '[[regtime_]]', NULL),
('hA0,r\n\0b~', 'hA.r@RY', 'GB-SFK', 1, 1, '[[regtime_]]', NULL),
('hA05p9l', 'hA.r@RY', 'GB-SRY', 1, 1, '[[regtime_]]', NULL),
('hA0>qrҴ', 'hA.r@RY', 'GB-WAR', 1, 1, '[[regtime_]]', NULL),
('hA0HpJj\n\n', 'hA.r@RY', 'GB-WSX', 1, 1, '[[regtime_]]', NULL),
('hA0QpBĈ', 'hA.r@RY', 'GB-WOR', 1, 1, '[[regtime_]]', NULL),
('hA0ZqVl@C', 'hA.r@RY', 'GB-LND', 1, 1, '[[regtime_]]', NULL),
('hA0cp0P0R', 'hA.r@RY', 'GB-BDG', 1, 1, '[[regtime_]]', NULL),
('hA0lsԶ@@T:B', 'hA.r@RY', 'GB-BNE', 1, 1, '[[regtime_]]', NULL),
('hA0uqbeq', 'hA.r@RY', 'GB-BEX', 1, 1, '[[regtime_]]', NULL),
('hA0r(>IS', 'hA.r@RY', 'GB-BEN', 1, 1, '[[regtime_]]', NULL),
('hA0r$PnXF', 'hA.r@RY', 'GB-BRY', 1, 1, '[[regtime_]]', NULL),
('hA0r7͜4֩', 'hA.r@RY', 'GB-CMD', 1, 1, '[[regtime_]]', NULL),
('hA0q]lxoR', 'hA.r@RY', 'GB-CRY', 1, 1, '[[regtime_]]', NULL),
('hA0sR	\r', 'hA.r@RY', 'GB-EAL', 1, 1, '[[regtime_]]', NULL),
('hA0pհlwF}5', 'hA.r@RY', 'GB-ENF', 1, 1, '[[regtime_]]', NULL),
('hA0perR', 'hA.r@RY', 'GB-GRE', 1, 1, '[[regtime_]]', NULL),
('hA0r؆y', 'hA.r@RY', 'GB-HCK', 1, 1, '[[regtime_]]', NULL),
('hA0p9-ʪ', 'hA.r@RY', 'GB-HMF', 1, 1, '[[regtime_]]', NULL),
('hA0sFzp+A', 'hA.r@RY', 'GB-HRY', 1, 1, '[[regtime_]]', NULL),
('hA0seaa"', 'hA.r@RY', 'GB-HRW', 1, 1, '[[regtime_]]', NULL),
('hA0s$]#P', 'hA.r@RY', 'GB-HAV', 1, 1, '[[regtime_]]', NULL),
('hA0qBg', 'hA.r@RY', 'GB-HIL', 1, 1, '[[regtime_]]', NULL),
('hA0q̀', 'hA.r@RY', 'GB-HNS', 1, 1, '[[regtime_]]', NULL),
('hA1rV', 'hA.r@RY', 'GB-ISL', 1, 1, '[[regtime_]]', NULL),
('hA1s۶"kr', 'hA.r@RY', 'GB-KEC', 1, 1, '[[regtime_]]', NULL),
('hA1qǝA]', 'hA.r@RY', 'GB-KTT', 1, 1, '[[regtime_]]', NULL),
('hA1$rɏˌ</', 'hA.r@RY', 'GB-LBH', 1, 1, '[[regtime_]]', NULL),
('hA1-s\0!I', 'hA.r@RY', 'GB-LEW', 1, 1, '[[regtime_]]', NULL),
('hA16qo$<=', 'hA.r@RY', 'GB-MRT', 1, 1, '[[regtime_]]', NULL),
('hA1>q 9vo', 'hA.r@RY', 'GB-NWM', 1, 1, '[[regtime_]]', NULL),
('hA1Hr]%', 'hA.r@RY', 'GB-RDB', 1, 1, '[[regtime_]]', NULL),
('hA1Up8[S', 'hA.r@RY', 'GB-RIC', 1, 1, '[[regtime_]]', NULL),
('hA1^s\0z', 'hA.r@RY', 'GB-SWK', 1, 1, '[[regtime_]]', NULL),
('hA1hsߺ7w', 'hA.r@RY', 'GB-STN', 1, 1, '[[regtime_]]', NULL),
('hA1qrű_', 'hA.r@RY', 'GB-TWH', 1, 1, '[[regtime_]]', NULL),
('hA1{sT0z', 'hA.r@RY', 'GB-WFT', 1, 1, '[[regtime_]]', NULL),
('hA1r!k/', 'hA.r@RY', 'GB-WND', 1, 1, '[[regtime_]]', NULL),
('hA1r#s&', 'hA.r@RY', 'GB-WSM', 1, 1, '[[regtime_]]', NULL),
('hA1q!ޚ', 'hA.r@RY', 'GB-BNS', 1, 1, '[[regtime_]]', NULL),
('hA1rݻbe\Z-', 'hA.r@RY', 'GB-BIR', 1, 1, '[[regtime_]]', NULL),
('hA1sZ(Ww*', 'hA.r@RY', 'GB-BOL', 1, 1, '[[regtime_]]', NULL),
('hA1sxox', 'hA.r@RY', 'GB-BRD', 1, 1, '[[regtime_]]', NULL),
('hA1p -?<l', 'hA.r@RY', 'GB-BUR', 1, 1, '[[regtime_]]', NULL),
('hA1rr,|', 'hA.r@RY', 'GB-CLD', 1, 1, '[[regtime_]]', NULL),
('hA1rE7\Zj', 'hA.r@RY', 'GB-COV', 1, 1, '[[regtime_]]', NULL),
('hA1rU', 'hA.r@RY', 'GB-DNC', 1, 1, '[[regtime_]]', NULL),
('hA1s㡖HGW(', 'hA.r@RY', 'GB-DUD', 1, 1, '[[regtime_]]', NULL),
('hA1sQIC>', 'hA.r@RY', 'GB-GAT', 1, 1, '[[regtime_]]', NULL),
('hA1qJ\r_ܗ', 'hA.r@RY', 'GB-KIR', 1, 1, '[[regtime_]]', NULL),
('hA1sv#3+', 'hA.r@RY', 'GB-KWL', 1, 1, '[[regtime_]]', NULL),
('hA2rc!$\r;&', 'hA.r@RY', 'GB-LDS', 1, 1, '[[regtime_]]', NULL),
('hA2r(Ԭ"FN', 'hA.r@RY', 'GB-LIV', 1, 1, '[[regtime_]]', NULL),
('hA2rE@', 'hA.r@RY', 'GB-MAN', 1, 1, '[[regtime_]]', NULL),
('hA2%r', 'hA.r@RY', 'GB-NET', 1, 1, '[[regtime_]]', NULL),
('hA2/st6mtK', 'hA.r@RY', 'GB-NTY', 1, 1, '[[regtime_]]', NULL),
('hA28sڸGL', 'hA.r@RY', 'GB-OLD', 1, 1, '[[regtime_]]', NULL),
('hA2Ar¥`&hC', 'hA.r@RY', 'GB-RCH', 1, 1, '[[regtime_]]', NULL),
('hA2Js})]', 'hA.r@RY', 'GB-ROT', 1, 1, '[[regtime_]]', NULL),
('hA2SpoC折', 'hA.r@RY', 'GB-SHN', 1, 1, '[[regtime_]]', NULL),
('hA2\\sG超)', 'hA.r@RY', 'GB-SLF', 1, 1, '[[regtime_]]', NULL),
('hA2fs<|)', 'hA.r@RY', 'GB-SAW', 1, 1, '[[regtime_]]', NULL),
('hA2ps-', 'hA.r@RY', 'GB-SFT', 1, 1, '[[regtime_]]', NULL),
('hA2}s#', 'hA.r@RY', 'GB-SHF', 1, 1, '[[regtime_]]', NULL),
('hA2pJ0H', 'hA.r@RY', 'GB-SOL', 1, 1, '[[regtime_]]', NULL),
('hA2r5Ju', 'hA.r@RY', 'GB-STY', 1, 1, '[[regtime_]]', NULL),
('hA2rQHY^', 'hA.r@RY', 'GB-SKP', 1, 1, '[[regtime_]]', NULL),
('hA2pyuY', 'hA.r@RY', 'GB-SND', 1, 1, '[[regtime_]]', NULL),
('hA2qϴQjn', 'hA.r@RY', 'GB-TAM', 1, 1, '[[regtime_]]', NULL),
('hA2rꂛld\0?', 'hA.r@RY', 'GB-TRF', 1, 1, '[[regtime_]]', NULL),
('hA2pOERx', 'hA.r@RY', 'GB-WKF', 1, 1, '[[regtime_]]', NULL),
('hA2rN=', 'hA.r@RY', 'GB-WLL', 1, 1, '[[regtime_]]', NULL),
('hA2rn', 'hA.r@RY', 'GB-WGN', 1, 1, '[[regtime_]]', NULL),
('hA2rE', 'hA.r@RY', 'GB-WRL', 1, 1, '[[regtime_]]', NULL),
('hA2pʏ\Zz', 'hA.r@RY', 'GB-WLV', 1, 1, '[[regtime_]]', NULL),
('hA2sԴ_eF', 'hA.r@RY', 'GB-BAS', 1, 1, '[[regtime_]]', NULL),
('hA2pg', 'hA.r@RY', 'GB-BDF', 1, 1, '[[regtime_]]', NULL),
('hA3	qn!j', 'hA.r@RY', 'GB-BBD', 1, 1, '[[regtime_]]', NULL),
('hA3rT', 'hA.r@RY', 'GB-BPL', 1, 1, '[[regtime_]]', NULL),
('hA3s\rf88M&', 'hA.r@RY', 'GB-BMH', 1, 1, '[[regtime_]]', NULL),
('hA3(pf`Fŏ!?', 'hA.r@RY', 'GB-BRC', 1, 1, '[[regtime_]]', NULL),
('hA32qʪ ', 'hA.r@RY', 'GB-BNH', 1, 1, '[[regtime_]]', NULL),
('hA3<r	d', 'hA.r@RY', 'GB-BST', 1, 1, '[[regtime_]]', NULL),
('hA3Jp,t', 'hA.r@RY', 'GB-CBF', 1, 1, '[[regtime_]]', NULL),
('hA3Ts.VN', 'hA.r@RY', 'GB-CHE', 1, 1, '[[regtime_]]', NULL),
('hA3^r&%MLM', 'hA.r@RY', 'GB-CHW', 1, 1, '[[regtime_]]', NULL),
('hA3hpu1$IO%', 'hA.r@RY', 'GB-CON', 1, 1, '[[regtime_]]', NULL),
('hA3rq@`c>', 'hA.r@RY', 'GB-DAL', 1, 1, '[[regtime_]]', NULL),
('hA3{r)y:l', 'hA.r@RY', 'GB-DER', 1, 1, '[[regtime_]]', NULL),
('hA3s''B ', 'hA.r@RY', 'GB-DUR', 1, 1, '[[regtime_]]', NULL),
('hA3rC@B', 'hA.r@RY', 'GB-ERY', 1, 1, '[[regtime_]]', NULL),
('hA3sL넠.x', 'hA.r@RY', 'GB-HAL', 1, 1, '[[regtime_]]', NULL),
('hA3sUb ', 'hA.r@RY', 'GB-HPL', 1, 1, '[[regtime_]]', NULL),
('hA3s|t^9', 'hA.r@RY', 'GB-HEF', 1, 1, '[[regtime_]]', NULL),
('hA3r%=0ς', 'hA.r@RY', 'GB-IOW', 1, 1, '[[regtime_]]', NULL),
('hA3sjQ78', 'hA.r@RY', 'GB-IOS', 1, 1, '[[regtime_]]', NULL),
('hA3qGA''', 'hA.r@RY', 'GB-KHL', 1, 1, '[[regtime_]]', NULL),
('hA3pu8\ZV<', 'hA.r@RY', 'GB-LCE', 1, 1, '[[regtime_]]', NULL),
('hA3qŭ{R\n', 'hA.r@RY', 'GB-LUT', 1, 1, '[[regtime_]]', NULL),
('hA4s،a', 'hA.r@RY', 'GB-MDW', 1, 1, '[[regtime_]]', NULL),
('hA4sV', 'hA.r@RY', 'GB-MDB', 1, 1, '[[regtime_]]', NULL),
('hA4qd', 'hA.r@RY', 'GB-MIK', 1, 1, '[[regtime_]]', NULL),
('hA4&pԧsk+', 'hA.r@RY', 'GB-NEL', 1, 1, '[[regtime_]]', NULL),
('hA41s]Ci', 'hA.r@RY', 'GB-NLN', 1, 1, '[[regtime_]]', NULL),
('hA4;q>=', 'hA.r@RY', 'GB-NSM', 1, 1, '[[regtime_]]', NULL),
('hA4DrٍL!(Ȏ', 'hA.r@RY', 'GB-NBL', 1, 1, '[[regtime_]]', NULL),
('hA4Ms)mT', 'hA.r@RY', 'GB-NGM', 1, 1, '[[regtime_]]', NULL),
('hA4Vr&l\n', 'hA.r@RY', 'GB-PTE', 1, 1, '[[regtime_]]', NULL),
('hA4`q6mYJ', 'hA.r@RY', 'GB-PLY', 1, 1, '[[regtime_]]', NULL),
('hA4irK$6:t', 'hA.r@RY', 'GB-POL', 1, 1, '[[regtime_]]', NULL),
('hA4vs*8R', 'hA.r@RY', 'GB-POR', 1, 1, '[[regtime_]]', NULL),
('hA4qŢ4	e-J', 'hA.r@RY', 'GB-RDG', 1, 1, '[[regtime_]]', NULL),
('hA4qJ=:\r', 'hA.r@RY', 'GB-RCC', 1, 1, '[[regtime_]]', NULL),
('hA4qΉKcR|', 'hA.r@RY', 'GB-RUT', 1, 1, '[[regtime_]]', NULL),
('hA4r]!>CGGT', 'hA.r@RY', 'GB-SHR', 1, 1, '[[regtime_]]', NULL),
('hA4rHU#', 'hA.r@RY', 'GB-SLG', 1, 1, '[[regtime_]]', NULL),
('hA4qUvPE', 'hA.r@RY', 'GB-SGC', 1, 1, '[[regtime_]]', NULL),
('hA4s/Ae\Z/', 'hA.r@RY', 'GB-STH', 1, 1, '[[regtime_]]', NULL),
('hA4qlub=', 'hA.r@RY', 'GB-SOS', 1, 1, '[[regtime_]]', NULL),
('hA4pWJ ', 'hA.r@RY', 'GB-STT', 1, 1, '[[regtime_]]', NULL),
('hA4r1Btw', 'hA.r@RY', 'GB-STE', 1, 1, '[[regtime_]]', NULL),
('hA4rNQ;n', 'hA.r@RY', 'GB-SWD', 1, 1, '[[regtime_]]', NULL),
('hA4p7)`O', 'hA.r@RY', 'GB-TFW', 1, 1, '[[regtime_]]', NULL),
('hA4rޒN', 'hA.r@RY', 'GB-THR', 1, 1, '[[regtime_]]', NULL),
('hA4sY ', 'hA.r@RY', 'GB-TOB', 1, 1, '[[regtime_]]', NULL),
('hA5s}iZ', 'hA.r@RY', 'GB-WRT', 1, 1, '[[regtime_]]', NULL),
('hA5r/i', 'hA.r@RY', 'GB-WBK', 1, 1, '[[regtime_]]', NULL),
('hA5p΀p,F', 'hA.r@RY', 'GB-WIL', 1, 1, '[[regtime_]]', NULL),
('hA5$qlĪQx%', 'hA.r@RY', 'GB-WNM', 1, 1, '[[regtime_]]', NULL),
('hA5.s2l\Z', 'hA.r@RY', 'GB-WOK', 1, 1, '[[regtime_]]', NULL),
('hA58pI', 'hA.r@RY', 'GB-YOR', 1, 1, '[[regtime_]]', NULL),
('hA5Cp~Ɣ', 'hA.r@RY', 'GB-ANN', 1, 1, '[[regtime_]]', NULL),
('hA5MsFbW', 'hA.r@RY', 'GB-AND', 1, 1, '[[regtime_]]', NULL),
('hA5VrrSwf]>', 'hA.r@RY', 'GB-ABC', 1, 1, '[[regtime_]]', NULL),
('hA5brՉv''~', 'hA.r@RY', 'GB-BFS', 1, 1, '[[regtime_]]', NULL),
('hA5lq#\\U', 'hA.r@RY', 'GB-CCG', 1, 1, '[[regtime_]]', NULL),
('hA5vs}''VP', 'hA.r@RY', 'GB-DRS', 1, 1, '[[regtime_]]', NULL),
('hA5sRbh|', 'hA.r@RY', 'GB-FMO', 1, 1, '[[regtime_]]', NULL),
('hA5p.!<|C|', 'hA.r@RY', 'GB-LBC', 1, 1, '[[regtime_]]', NULL),
('hA5pfV', 'hA.r@RY', 'GB-MEA', 1, 1, '[[regtime_]]', NULL),
('hA5r''ܲ]', 'hA.r@RY', 'GB-MUL', 1, 1, '[[regtime_]]', NULL),
('hA5q*', 'hA.r@RY', 'GB-NMD', 1, 1, '[[regtime_]]', NULL),
('hA5rG?X', 'hA.r@RY', 'GB-ABE', 1, 1, '[[regtime_]]', NULL),
('hA5suaᙞ', 'hA.r@RY', 'GB-ABD', 1, 1, '[[regtime_]]', NULL),
('hA5pӠODѲ', 'hA.r@RY', 'GB-ANS', 1, 1, '[[regtime_]]', NULL),
('hA5q	"j|OU', 'hA.r@RY', 'GB-AGB', 1, 1, '[[regtime_]]', NULL),
('hA5r4#<bh', 'hA.r@RY', 'GB-CLK', 1, 1, '[[regtime_]]', NULL),
('hA5sq!ܛ', 'hA.r@RY', 'GB-DGY', 1, 1, '[[regtime_]]', NULL),
('hA5q$I', 'hA.r@RY', 'GB-DND', 1, 1, '[[regtime_]]', NULL),
('hA5p;w', 'hA.r@RY', 'GB-EAY', 1, 1, '[[regtime_]]', NULL),
('hA5sp', 'hA.r@RY', 'GB-EDU', 1, 1, '[[regtime_]]', NULL),
('hA6p_', 'hA.r@RY', 'GB-ELN', 1, 1, '[[regtime_]]', NULL),
('hA6pNCp{ ', 'hA.r@RY', 'GB-ERW', 1, 1, '[[regtime_]]', NULL),
('hA6\ZpKc8', 'hA.r@RY', 'GB-EDH', 1, 1, '[[regtime_]]', NULL),
('hA60s%@', 'hA.r@RY', 'GB-ELS', 1, 1, '[[regtime_]]', NULL),
('hA6:ppP', 'hA.r@RY', 'GB-FAL', 1, 1, '[[regtime_]]', NULL),
('hA6Cs34', 'hA.r@RY', 'GB-FIF', 1, 1, '[[regtime_]]', NULL),
('hA6Ms\\cMyb', 'hA.r@RY', 'GB-GLG', 1, 1, '[[regtime_]]', NULL),
('hA6Vqf{!W)', 'hA.r@RY', 'GB-HLD', 1, 1, '[[regtime_]]', NULL),
('hA6`s$*5l', 'hA.r@RY', 'GB-IVC', 1, 1, '[[regtime_]]', NULL),
('hA6jq2/\rd', 'hA.r@RY', 'GB-MLN', 1, 1, '[[regtime_]]', NULL),
('hA6tqŉ7܀/T', 'hA.r@RY', 'GB-MRY', 1, 1, '[[regtime_]]', NULL),
('hA6}pzO6', 'hA.r@RY', 'GB-NAY', 1, 1, '[[regtime_]]', NULL),
('hA6s}k', 'hA.r@RY', 'GB-NLK', 1, 1, '[[regtime_]]', NULL),
('hA6rkyҲѷ', 'hA.r@RY', 'GB-ORK', 1, 1, '[[regtime_]]', NULL),
('hA6p', 'hA.r@RY', 'GB-PKN', 1, 1, '[[regtime_]]', NULL),
('hA6p(`+#', 'hA.r@RY', 'GB-RFW', 1, 1, '[[regtime_]]', NULL),
('hA6rZ@5^Q', 'hA.r@RY', 'GB-SCB', 1, 1, '[[regtime_]]', NULL),
('hA6r-z|', 'hA.r@RY', 'GB-ZET', 1, 1, '[[regtime_]]', NULL),
('hA6p_foLU', 'hA.r@RY', 'GB-SAY', 1, 1, '[[regtime_]]', NULL),
('hA6pl;z*', 'hA.r@RY', 'GB-SLK', 1, 1, '[[regtime_]]', NULL),
('hA6rި\n׸q,', 'hA.r@RY', 'GB-STG', 1, 1, '[[regtime_]]', NULL),
('hA6s\n', 'hA.r@RY', 'GB-WDU', 1, 1, '[[regtime_]]', NULL),
('hA6p|Z6', 'hA.r@RY', 'GB-WLN', 1, 1, '[[regtime_]]', NULL),
('hA6p2mzd', 'hA.r@RY', 'GB-BGW', 1, 1, '[[regtime_]]', NULL),
('hA7pUl', 'hA.r@RY', 'GB-BGE', 1, 1, '[[regtime_]]', NULL),
('hA7\rsCX', 'hA.r@RY', 'GB-CAY', 1, 1, '[[regtime_]]', NULL),
('hA7sE>>7', 'hA.r@RY', 'GB-CRF', 1, 1, '[[regtime_]]', NULL),
('hA7 qMV`m', 'hA.r@RY', 'GB-CMN', 1, 1, '[[regtime_]]', NULL),
('hA7.pw', 'hA.r@RY', 'GB-CGN', 1, 1, '[[regtime_]]', NULL),
('hA77qG|', 'hA.r@RY', 'GB-CWY', 1, 1, '[[regtime_]]', NULL),
('hA7Ap&į=,', 'hA.r@RY', 'GB-DEN', 1, 1, '[[regtime_]]', NULL),
('hA7Kp^b', 'hA.r@RY', 'GB-FLN', 1, 1, '[[regtime_]]', NULL),
('hA7Uq9bk', 'hA.r@RY', 'GB-GWN', 1, 1, '[[regtime_]]', NULL),
('hA7^r	B', 'hA.r@RY', 'GB-AGY', 1, 1, '[[regtime_]]', NULL),
('hA7hrEx', 'hA.r@RY', 'GB-MTY', 1, 1, '[[regtime_]]', NULL),
('hA7rqkM', 'hA.r@RY', 'GB-MON', 1, 1, '[[regtime_]]', NULL),
('hA7|sj%', 'hA.r@RY', 'GB-NTL', 1, 1, '[[regtime_]]', NULL),
('hA7q"/Z', 'hA.r@RY', 'GB-NWP', 1, 1, '[[regtime_]]', NULL),
('hA7r$H3', 'hA.r@RY', 'GB-PEM', 1, 1, '[[regtime_]]', NULL),
('hA7r5*"p', 'hA.r@RY', 'GB-POW', 1, 1, '[[regtime_]]', NULL),
('hA7sU\0l', 'hA.r@RY', 'GB-RCT', 1, 1, '[[regtime_]]', NULL),
('hA7r۾-', 'hA.r@RY', 'GB-SWA', 1, 1, '[[regtime_]]', NULL),
('hA7sހEFs', 'hA.r@RY', 'GB-TOF', 1, 1, '[[regtime_]]', NULL),
('hA7rF>LjM', 'hA.r@RY', 'GB-VGL', 1, 1, '[[regtime_]]', NULL),
('hA7qM', 'hA.r@RY', 'GB-WRX', 1, 1, '[[regtime_]]', NULL),
('hA8peg4', 'hA8pGϕ|', 'US-AL', 1, 1, '[[regtime_]]', NULL),
('hA8qA鮺L+G', 'hA8pGϕ|', 'US-AK', 1, 1, '[[regtime_]]', NULL),
('hA8reeՔ;', 'hA8pGϕ|', 'US-AZ', 1, 1, '[[regtime_]]', NULL),
('hA8sƹhO$', 'hA8pGϕ|', 'US-AR', 1, 1, '[[regtime_]]', NULL),
('hA8rФLDÍ', 'hA8pGϕ|', 'US-CA', 1, 1, '[[regtime_]]', NULL),
('hA8rF\Zsm', 'hA8pGϕ|', 'US-CO', 1, 1, '[[regtime_]]', NULL),
('hA9rh6', 'hA8pGϕ|', 'US-CT', 1, 1, '[[regtime_]]', NULL),
('hA9s%xeò', 'hA8pGϕ|', 'US-DE', 1, 1, '[[regtime_]]', NULL),
('hA9rX\\/m', 'hA8pGϕ|', 'US-FL', 1, 1, '[[regtime_]]', NULL),
('hA9&qx ', 'hA8pGϕ|', 'US-GA', 1, 1, '[[regtime_]]', NULL),
('hA90q8}UE', 'hA8pGϕ|', 'US-HI', 1, 1, '[[regtime_]]', NULL),
('hA9:pNbc7Z', 'hA8pGϕ|', 'US-ID', 1, 1, '[[regtime_]]', NULL),
('hA9Dr'',ķ-o@', 'hA8pGϕ|', 'US-IL', 1, 1, '[[regtime_]]', NULL),
('hA9Np)C{ ', 'hA8pGϕ|', 'US-IN', 1, 1, '[[regtime_]]', NULL),
('hA9Xp)c8', 'hA8pGϕ|', 'US-IA', 1, 1, '[[regtime_]]', NULL),
('hA9br\\O/', 'hA8pGϕ|', 'US-KS', 1, 1, '[[regtime_]]', NULL),
('hA9lpE', 'hA8pGϕ|', 'US-KY', 1, 1, '[[regtime_]]', NULL),
('hA9urpۃ', 'hA8pGϕ|', 'US-LA', 1, 1, '[[regtime_]]', NULL),
('hA9pC', 'hA8pGϕ|', 'US-ME', 1, 1, '[[regtime_]]', NULL),
('hA9p$', 'hA8pGϕ|', 'US-MD', 1, 1, '[[regtime_]]', NULL),
('hA9qs)n''', 'hA8pGϕ|', 'US-MA', 1, 1, '[[regtime_]]', NULL),
('hA9pH', 'hA8pGϕ|', 'US-MI', 1, 1, '[[regtime_]]', NULL),
('hA9p[8NI', 'hA8pGϕ|', 'US-MN', 1, 1, '[[regtime_]]', NULL),
('hA9q贛Wo', 'hA8pGϕ|', 'US-MS', 1, 1, '[[regtime_]]', NULL),
('hA9sǃLYr', 'hA8pGϕ|', 'US-MO', 1, 1, '[[regtime_]]', NULL),
('hA9sߠ:զ', 'hA8pGϕ|', 'US-MT', 1, 1, '[[regtime_]]', NULL),
('hA9riGރu', 'hA8pGϕ|', 'US-NE', 1, 1, '[[regtime_]]', NULL),
('hA9si$!͢', 'hA8pGϕ|', 'US-NV', 1, 1, '[[regtime_]]', NULL),
('hA9p^7$.', 'hA8pGϕ|', 'US-NH', 1, 1, '[[regtime_]]', NULL),
('hA9p뻉}a`', 'hA8pGϕ|', 'US-NJ', 1, 1, '[[regtime_]]', NULL),
('hA9q{\Zِ*Rj', 'hA8pGϕ|', 'US-NM', 1, 1, '[[regtime_]]', NULL),
('hA:r.,.', 'hA8pGϕ|', 'US-NY', 1, 1, '[[regtime_]]', NULL),
('hA:qKrP/', 'hA8pGϕ|', 'US-NC', 1, 1, '[[regtime_]]', NULL),
('hA:pG\\', 'hA8pGϕ|', 'US-ND', 1, 1, '[[regtime_]]', NULL),
('hA: s˻1|Uo', 'hA8pGϕ|', 'US-OH', 1, 1, '[[regtime_]]', NULL),
('hA:)s*~8>', 'hA8pGϕ|', 'US-OK', 1, 1, '[[regtime_]]', NULL),
('hA:3sIn]~', 'hA8pGϕ|', 'US-OR', 1, 1, '[[regtime_]]', NULL),
('hA:<qӎuz', 'hA8pGϕ|', 'US-PA', 1, 1, '[[regtime_]]', NULL),
('hA:Fsw;{>l', 'hA8pGϕ|', 'US-RI', 1, 1, '[[regtime_]]', NULL),
('hA:SsC/', 'hA8pGϕ|', 'US-SC', 1, 1, '[[regtime_]]', NULL),
('hA:_pZTn', 'hA8pGϕ|', 'US-SD', 1, 1, '[[regtime_]]', NULL),
('hA:kqj*K>', 'hA8pGϕ|', 'US-TN', 1, 1, '[[regtime_]]', NULL),
('hA:ur˄S', 'hA8pGϕ|', 'US-TX', 1, 1, '[[regtime_]]', NULL),
('hA:~sO>', 'hA8pGϕ|', 'US-UT', 1, 1, '[[regtime_]]', NULL),
('hA:sӚ1[', 'hA8pGϕ|', 'US-VT', 1, 1, '[[regtime_]]', NULL),
('hA:r>s', 'hA8pGϕ|', 'US-VA', 1, 1, '[[regtime_]]', NULL),
('hA:qZq', 'hA8pGϕ|', 'US-WA', 1, 1, '[[regtime_]]', NULL),
('hA:s', 'hA8pGϕ|', 'US-WV', 1, 1, '[[regtime_]]', NULL),
('hA:sL}`3', 'hA8pGϕ|', 'US-WI', 1, 1, '[[regtime_]]', NULL),
('hA:s꯳M):', 'hA8pGϕ|', 'US-WY', 1, 1, '[[regtime_]]', NULL),
('hA:q\Z', 'hA8pGϕ|', 'US-DC', 1, 1, '[[regtime_]]', NULL),
('hB:rz[cH', 'hA8/s&}\n', 'CA-ON', 1, 1, '[[regtime_]]', NULL),
('hB:rz[cvQ', 'hA8/s&}\n', 'CA-QC', 1, 1, '[[regtime_]]', NULL),
('hB:rz[d1', 'hA8/s&}\n', 'CA-NS', 1, 1, '[[regtime_]]', NULL),
('hB:rz[e', 'hA8/s&}\n', 'CA-NB', 1, 1, '[[regtime_]]', NULL),
('hB:rz[eO9', 'hA8/s&}\n', 'CA-MB', 1, 1, '[[regtime_]]', NULL),
('hB:rz[e', 'hA8/s&}\n', 'CA-BC', 1, 1, '[[regtime_]]', NULL),
('hB:rz[fH`', 'hA8/s&}\n', 'CA-PE', 1, 1, '[[regtime_]]', NULL),
('hB:rz[fNw', 'hA8/s&}\n', 'CA-SK', 1, 1, '[[regtime_]]', NULL),
('hB:rz[gi', 'hA8/s&}\n', 'CA-AB', 1, 1, '[[regtime_]]', NULL),
('hB:rz[gz', 'hA8/s&}\n', 'CA-NL', 1, 1, '[[regtime_]]', NULL),
('hB:rz[hh', 'hA8/s&}\n', 'CA-NT', 1, 1, '[[regtime_]]', NULL),
('hB;r[\Z', 'hA8/s&}\n', 'CA-YT', 1, 1, '[[regtime_]]', NULL),
('hB;r[@p', 'hA8/s&}\n', 'CA-NU', 1, 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_state_translation`
--

CREATE TABLE `country_state_translation` (
  `country_state_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_state_id`,`language_id`),
  KEY `fk.country_state_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state_translation`
--

INSERT INTO `country_state_translation` VALUES
('hA-p', 'hA,r+(', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('hA-p', '/_MpXT|', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('hA.rh!', 'hA,r+(', 'Bayern', NULL, '[[regtime_]]', NULL),
('hA.rh!', '/_MpXT|', 'Bavaria', NULL, '[[regtime_]]', NULL),
('hA.sj;kvh', 'hA,r+(', 'Berlin', NULL, '[[regtime_]]', NULL),
('hA.sj;kvh', '/_MpXT|', 'Berlin', NULL, '[[regtime_]]', NULL),
('hA.!p;A9', 'hA,r+(', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('hA.!p;A9', '/_MpXT|', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('hA.2qw', 'hA,r+(', 'Bremen', NULL, '[[regtime_]]', NULL),
('hA.2qw', '/_MpXT|', 'Bremen', NULL, '[[regtime_]]', NULL),
('hA.@qh', 'hA,r+(', 'Hamburg', NULL, '[[regtime_]]', NULL),
('hA.@qh', '/_MpXT|', 'Hamburg', NULL, '[[regtime_]]', NULL),
('hA.Mp\\}Nk', 'hA,r+(', 'Hessen', NULL, '[[regtime_]]', NULL),
('hA.Mp\\}Nk', '/_MpXT|', 'Hesse', NULL, '[[regtime_]]', NULL),
('hA.Zs	Mk', 'hA,r+(', 'Niedersachsen', NULL, '[[regtime_]]', NULL),
('hA.Zs	Mk', '/_MpXT|', 'Lower Saxony', NULL, '[[regtime_]]', NULL),
('hA.hqW''', 'hA,r+(', 'Mecklenburg-Vorpommern', NULL, '[[regtime_]]', NULL),
('hA.hqW''', '/_MpXT|', 'Mecklenburg-Western Pomerania', NULL, '[[regtime_]]', NULL),
('hA.vqV$h', 'hA,r+(', 'Nordrhein-Westfalen', NULL, '[[regtime_]]', NULL),
('hA.vqV$h', '/_MpXT|', 'North Rhine-Westphalia', NULL, '[[regtime_]]', NULL),
('hA.sY', 'hA,r+(', 'Rheinland-Pfalz', NULL, '[[regtime_]]', NULL),
('hA.sY', '/_MpXT|', 'Rhineland-Palatinate', NULL, '[[regtime_]]', NULL),
('hA.ppD', 'hA,r+(', 'Saarland', NULL, '[[regtime_]]', NULL),
('hA.ppD', '/_MpXT|', 'Saarland', NULL, '[[regtime_]]', NULL),
('hA.r;rC~', 'hA,r+(', 'Sachsen', NULL, '[[regtime_]]', NULL),
('hA.r;rC~', '/_MpXT|', 'Saxony', NULL, '[[regtime_]]', NULL),
('hA.s뢫MԖ6D', 'hA,r+(', 'Sachsen-Anhalt', NULL, '[[regtime_]]', NULL),
('hA.s뢫MԖ6D', '/_MpXT|', 'Saxony-Anhalt', NULL, '[[regtime_]]', NULL),
('hA.q޿BѺ;', 'hA,r+(', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('hA.q޿BѺ;', '/_MpXT|', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('hA.somLs!H_', 'hA,r+(', 'Thüringen', NULL, '[[regtime_]]', NULL),
('hA.somLs!H_', '/_MpXT|', 'Thuringia', NULL, '[[regtime_]]', NULL),
('hA.p^u', '/_MpXT|', 'England', NULL, '[[regtime_]]', NULL),
('hA/\0rlMoA', '/_MpXT|', 'Northern Ireland', NULL, '[[regtime_]]', NULL),
('hA/	rT^d', '/_MpXT|', 'Scotland', NULL, '[[regtime_]]', NULL),
('hA/rk8֦d', '/_MpXT|', 'Wales', NULL, '[[regtime_]]', NULL),
('hA/sXʠIvy^', '/_MpXT|', 'England and Wales', NULL, '[[regtime_]]', NULL),
('hA/#ptOXb', '/_MpXT|', 'Great Britain', NULL, '[[regtime_]]', NULL),
('hA/,rf\Z`', '/_MpXT|', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('hA/6rBտ+', '/_MpXT|', 'Buckinghamshire', NULL, '[[regtime_]]', NULL),
('hA/Aq[U]I)', '/_MpXT|', 'Cambridgeshire', NULL, '[[regtime_]]', NULL),
('hA/Jr`H''RA', '/_MpXT|', 'Cumbria', NULL, '[[regtime_]]', NULL),
('hA/Sr[:-,', '/_MpXT|', 'Derbyshire', NULL, '[[regtime_]]', NULL),
('hA/`s{؛4ZV', '/_MpXT|', 'Devon', NULL, '[[regtime_]]', NULL),
('hA/is<Sr', '/_MpXT|', 'Dorset', NULL, '[[regtime_]]', NULL),
('hA/rr_A\nH/Y', '/_MpXT|', 'East Sussex', NULL, '[[regtime_]]', NULL),
('hA/{r.-(\0s	', '/_MpXT|', 'Essex', NULL, '[[regtime_]]', NULL),
('hA/qMo@W=', '/_MpXT|', 'Gloucestershire', NULL, '[[regtime_]]', NULL),
('hA/sAI+J	', '/_MpXT|', 'Hampshire', NULL, '[[regtime_]]', NULL),
('hA/qd)\r', '/_MpXT|', 'Hertfordshire', NULL, '[[regtime_]]', NULL),
('hA/q ֿy', '/_MpXT|', 'Kent', NULL, '[[regtime_]]', NULL),
('hA/q&._/ƀ', '/_MpXT|', 'Lancashire', NULL, '[[regtime_]]', NULL),
('hA/qZR<Ux', '/_MpXT|', 'Leicestershire', NULL, '[[regtime_]]', NULL),
('hA/p\Z8²', '/_MpXT|', 'Lincolnshire', NULL, '[[regtime_]]', NULL),
('hA/r5L', '/_MpXT|', 'Norfolk', NULL, '[[regtime_]]', NULL),
('hA/p}uRd', '/_MpXT|', 'North Yorkshire', NULL, '[[regtime_]]', NULL),
('hA/sP08Up', '/_MpXT|', 'Northamptonshire', NULL, '[[regtime_]]', NULL),
('hA/s;p\nX', '/_MpXT|', 'Nottinghamshire', NULL, '[[regtime_]]', NULL),
('hA0s"', '/_MpXT|', 'Oxfordshire', NULL, '[[regtime_]]', NULL),
('hA0q1h\n*X', '/_MpXT|', 'Somerset', NULL, '[[regtime_]]', NULL),
('hA0#s/5οE', '/_MpXT|', 'Staffordshire', NULL, '[[regtime_]]', NULL),
('hA0,r\n\0b~', '/_MpXT|', 'Suffolk', NULL, '[[regtime_]]', NULL),
('hA05p9l', '/_MpXT|', 'Surrey', NULL, '[[regtime_]]', NULL),
('hA0>qrҴ', '/_MpXT|', 'Warwickshire', NULL, '[[regtime_]]', NULL),
('hA0HpJj\n\n', '/_MpXT|', 'West Sussex', NULL, '[[regtime_]]', NULL),
('hA0QpBĈ', '/_MpXT|', 'Worcestershire', NULL, '[[regtime_]]', NULL),
('hA0ZqVl@C', '/_MpXT|', 'London, City of', NULL, '[[regtime_]]', NULL),
('hA0cp0P0R', '/_MpXT|', 'Barking and Dagenham', NULL, '[[regtime_]]', NULL),
('hA0lsԶ@@T:B', '/_MpXT|', 'Barnet', NULL, '[[regtime_]]', NULL),
('hA0uqbeq', '/_MpXT|', 'Bexley', NULL, '[[regtime_]]', NULL),
('hA0r(>IS', '/_MpXT|', 'Brent', NULL, '[[regtime_]]', NULL),
('hA0r$PnXF', '/_MpXT|', 'Bromley', NULL, '[[regtime_]]', NULL),
('hA0r7͜4֩', '/_MpXT|', 'Camden', NULL, '[[regtime_]]', NULL),
('hA0q]lxoR', '/_MpXT|', 'Croydon', NULL, '[[regtime_]]', NULL),
('hA0sR	\r', '/_MpXT|', 'Ealing', NULL, '[[regtime_]]', NULL),
('hA0pհlwF}5', '/_MpXT|', 'Enfield', NULL, '[[regtime_]]', NULL),
('hA0perR', '/_MpXT|', 'Greenwich', NULL, '[[regtime_]]', NULL),
('hA0r؆y', '/_MpXT|', 'Hackney', NULL, '[[regtime_]]', NULL),
('hA0p9-ʪ', '/_MpXT|', 'Hammersmith and Fulham', NULL, '[[regtime_]]', NULL),
('hA0sFzp+A', '/_MpXT|', 'Haringey', NULL, '[[regtime_]]', NULL),
('hA0seaa"', '/_MpXT|', 'Harrow', NULL, '[[regtime_]]', NULL),
('hA0s$]#P', '/_MpXT|', 'Havering', NULL, '[[regtime_]]', NULL),
('hA0qBg', '/_MpXT|', 'Hillingdon', NULL, '[[regtime_]]', NULL),
('hA0q̀', '/_MpXT|', 'Hounslow', NULL, '[[regtime_]]', NULL),
('hA1rV', '/_MpXT|', 'Islington', NULL, '[[regtime_]]', NULL),
('hA1s۶"kr', '/_MpXT|', 'Kensington and Chelsea', NULL, '[[regtime_]]', NULL),
('hA1qǝA]', '/_MpXT|', 'Kingston upon Thames', NULL, '[[regtime_]]', NULL),
('hA1$rɏˌ</', '/_MpXT|', 'Lambeth', NULL, '[[regtime_]]', NULL),
('hA1-s\0!I', '/_MpXT|', 'Lewisham', NULL, '[[regtime_]]', NULL),
('hA16qo$<=', '/_MpXT|', 'Merton', NULL, '[[regtime_]]', NULL),
('hA1>q 9vo', '/_MpXT|', 'Newham', NULL, '[[regtime_]]', NULL),
('hA1Hr]%', '/_MpXT|', 'Redbridge', NULL, '[[regtime_]]', NULL),
('hA1Up8[S', '/_MpXT|', 'Richmond upon Thames', NULL, '[[regtime_]]', NULL),
('hA1^s\0z', '/_MpXT|', 'Southwark', NULL, '[[regtime_]]', NULL),
('hA1hsߺ7w', '/_MpXT|', 'Sutton', NULL, '[[regtime_]]', NULL),
('hA1qrű_', '/_MpXT|', 'Tower Hamlets', NULL, '[[regtime_]]', NULL),
('hA1{sT0z', '/_MpXT|', 'Waltham Forest', NULL, '[[regtime_]]', NULL),
('hA1r!k/', '/_MpXT|', 'Wandsworth', NULL, '[[regtime_]]', NULL),
('hA1r#s&', '/_MpXT|', 'Westminster', NULL, '[[regtime_]]', NULL),
('hA1q!ޚ', '/_MpXT|', 'Barnsley', NULL, '[[regtime_]]', NULL),
('hA1rݻbe\Z-', '/_MpXT|', 'Birmingham', NULL, '[[regtime_]]', NULL),
('hA1sZ(Ww*', '/_MpXT|', 'Bolton', NULL, '[[regtime_]]', NULL),
('hA1sxox', '/_MpXT|', 'Bradford', NULL, '[[regtime_]]', NULL),
('hA1p -?<l', '/_MpXT|', 'Bury', NULL, '[[regtime_]]', NULL),
('hA1rr,|', '/_MpXT|', 'Calderdale', NULL, '[[regtime_]]', NULL),
('hA1rE7\Zj', '/_MpXT|', 'Coventry', NULL, '[[regtime_]]', NULL),
('hA1rU', '/_MpXT|', 'Doncaster', NULL, '[[regtime_]]', NULL),
('hA1s㡖HGW(', '/_MpXT|', 'Dudley', NULL, '[[regtime_]]', NULL),
('hA1sQIC>', '/_MpXT|', 'Gateshead', NULL, '[[regtime_]]', NULL),
('hA1qJ\r_ܗ', '/_MpXT|', 'Kirklees', NULL, '[[regtime_]]', NULL),
('hA1sv#3+', '/_MpXT|', 'Knowsley', NULL, '[[regtime_]]', NULL),
('hA2rc!$\r;&', '/_MpXT|', 'Leeds', NULL, '[[regtime_]]', NULL),
('hA2r(Ԭ"FN', '/_MpXT|', 'Liverpool', NULL, '[[regtime_]]', NULL),
('hA2rE@', '/_MpXT|', 'Manchester', NULL, '[[regtime_]]', NULL),
('hA2%r', '/_MpXT|', 'Newcastle upon Tyne', NULL, '[[regtime_]]', NULL),
('hA2/st6mtK', '/_MpXT|', 'North Tyneside', NULL, '[[regtime_]]', NULL),
('hA28sڸGL', '/_MpXT|', 'Oldham', NULL, '[[regtime_]]', NULL),
('hA2Ar¥`&hC', '/_MpXT|', 'Rochdale', NULL, '[[regtime_]]', NULL),
('hA2Js})]', '/_MpXT|', 'Rotherham', NULL, '[[regtime_]]', NULL),
('hA2SpoC折', '/_MpXT|', 'St. Helens', NULL, '[[regtime_]]', NULL),
('hA2\\sG超)', '/_MpXT|', 'Salford', NULL, '[[regtime_]]', NULL),
('hA2fs<|)', '/_MpXT|', 'Sandwell', NULL, '[[regtime_]]', NULL),
('hA2ps-', '/_MpXT|', 'Sefton', NULL, '[[regtime_]]', NULL),
('hA2}s#', '/_MpXT|', 'Sheffield', NULL, '[[regtime_]]', NULL),
('hA2pJ0H', '/_MpXT|', 'Solihull', NULL, '[[regtime_]]', NULL),
('hA2r5Ju', '/_MpXT|', 'South Tyneside', NULL, '[[regtime_]]', NULL),
('hA2rQHY^', '/_MpXT|', 'Stockport', NULL, '[[regtime_]]', NULL),
('hA2pyuY', '/_MpXT|', 'Sunderland', NULL, '[[regtime_]]', NULL),
('hA2qϴQjn', '/_MpXT|', 'Tameside', NULL, '[[regtime_]]', NULL),
('hA2rꂛld\0?', '/_MpXT|', 'Trafford', NULL, '[[regtime_]]', NULL),
('hA2pOERx', '/_MpXT|', 'Wakefield', NULL, '[[regtime_]]', NULL),
('hA2rN=', '/_MpXT|', 'Walsall', NULL, '[[regtime_]]', NULL),
('hA2rn', '/_MpXT|', 'Wigan', NULL, '[[regtime_]]', NULL),
('hA2rE', '/_MpXT|', 'Wirral', NULL, '[[regtime_]]', NULL),
('hA2pʏ\Zz', '/_MpXT|', 'Wolverhampton', NULL, '[[regtime_]]', NULL),
('hA2sԴ_eF', '/_MpXT|', 'Bath and North East Somerset', NULL, '[[regtime_]]', NULL),
('hA2pg', '/_MpXT|', 'Bedford', NULL, '[[regtime_]]', NULL),
('hA3	qn!j', '/_MpXT|', 'Blackburn with Darwen', NULL, '[[regtime_]]', NULL),
('hA3rT', '/_MpXT|', 'Blackpool', NULL, '[[regtime_]]', NULL),
('hA3s\rf88M&', '/_MpXT|', 'Bournemouth', NULL, '[[regtime_]]', NULL),
('hA3(pf`Fŏ!?', '/_MpXT|', 'Bracknell Forest', NULL, '[[regtime_]]', NULL),
('hA32qʪ ', '/_MpXT|', 'Brighton and Hove', NULL, '[[regtime_]]', NULL),
('hA3<r	d', '/_MpXT|', 'Bristol, City of', NULL, '[[regtime_]]', NULL),
('hA3Jp,t', '/_MpXT|', 'Central Bedfordshire', NULL, '[[regtime_]]', NULL),
('hA3Ts.VN', '/_MpXT|', 'Cheshire East', NULL, '[[regtime_]]', NULL),
('hA3^r&%MLM', '/_MpXT|', 'Cheshire West and Chester', NULL, '[[regtime_]]', NULL),
('hA3hpu1$IO%', '/_MpXT|', 'Cornwall', NULL, '[[regtime_]]', NULL),
('hA3rq@`c>', '/_MpXT|', 'Darlington', NULL, '[[regtime_]]', NULL),
('hA3{r)y:l', '/_MpXT|', 'Derby', NULL, '[[regtime_]]', NULL),
('hA3s''B ', '/_MpXT|', 'Durham County', NULL, '[[regtime_]]', NULL),
('hA3rC@B', '/_MpXT|', 'East Riding of Yorkshire', NULL, '[[regtime_]]', NULL),
('hA3sL넠.x', '/_MpXT|', 'Halton', NULL, '[[regtime_]]', NULL),
('hA3sUb ', '/_MpXT|', 'Hartlepool', NULL, '[[regtime_]]', NULL),
('hA3s|t^9', '/_MpXT|', 'Herefordshire', NULL, '[[regtime_]]', NULL),
('hA3r%=0ς', '/_MpXT|', 'Isle of Wight', NULL, '[[regtime_]]', NULL),
('hA3sjQ78', '/_MpXT|', 'Isles of Scilly', NULL, '[[regtime_]]', NULL),
('hA3qGA''', '/_MpXT|', 'Kingston upon Hull', NULL, '[[regtime_]]', NULL),
('hA3pu8\ZV<', '/_MpXT|', 'Leicester', NULL, '[[regtime_]]', NULL),
('hA3qŭ{R\n', '/_MpXT|', 'Luton', NULL, '[[regtime_]]', NULL),
('hA4s،a', '/_MpXT|', 'Medway', NULL, '[[regtime_]]', NULL),
('hA4sV', '/_MpXT|', 'Middlesbrough', NULL, '[[regtime_]]', NULL),
('hA4qd', '/_MpXT|', 'Milton Keynes', NULL, '[[regtime_]]', NULL),
('hA4&pԧsk+', '/_MpXT|', 'North East Lincolnshire', NULL, '[[regtime_]]', NULL),
('hA41s]Ci', '/_MpXT|', 'North Lincolnshire', NULL, '[[regtime_]]', NULL),
('hA4;q>=', '/_MpXT|', 'North Somerset', NULL, '[[regtime_]]', NULL),
('hA4DrٍL!(Ȏ', '/_MpXT|', 'Northumberland', NULL, '[[regtime_]]', NULL),
('hA4Ms)mT', '/_MpXT|', 'Nottingham', NULL, '[[regtime_]]', NULL),
('hA4Vr&l\n', '/_MpXT|', 'Peterborough', NULL, '[[regtime_]]', NULL),
('hA4`q6mYJ', '/_MpXT|', 'Plymouth', NULL, '[[regtime_]]', NULL),
('hA4irK$6:t', '/_MpXT|', 'Poole', NULL, '[[regtime_]]', NULL),
('hA4vs*8R', '/_MpXT|', 'Portsmouth', NULL, '[[regtime_]]', NULL),
('hA4qŢ4	e-J', '/_MpXT|', 'Reading', NULL, '[[regtime_]]', NULL),
('hA4qJ=:\r', '/_MpXT|', 'Redcar and Cleveland', NULL, '[[regtime_]]', NULL),
('hA4qΉKcR|', '/_MpXT|', 'Rutland', NULL, '[[regtime_]]', NULL),
('hA4r]!>CGGT', '/_MpXT|', 'Shropshire', NULL, '[[regtime_]]', NULL),
('hA4rHU#', '/_MpXT|', 'Slough', NULL, '[[regtime_]]', NULL),
('hA4qUvPE', '/_MpXT|', 'South Gloucestershire', NULL, '[[regtime_]]', NULL),
('hA4s/Ae\Z/', '/_MpXT|', 'Southampton', NULL, '[[regtime_]]', NULL),
('hA4qlub=', '/_MpXT|', 'Southend-on-Sea', NULL, '[[regtime_]]', NULL),
('hA4pWJ ', '/_MpXT|', 'Stockton-on-Tees', NULL, '[[regtime_]]', NULL),
('hA4r1Btw', '/_MpXT|', 'Stoke-on-Trent', NULL, '[[regtime_]]', NULL),
('hA4rNQ;n', '/_MpXT|', 'Swindon', NULL, '[[regtime_]]', NULL),
('hA4p7)`O', '/_MpXT|', 'Telford and Wrekin', NULL, '[[regtime_]]', NULL),
('hA4rޒN', '/_MpXT|', 'Thurrock', NULL, '[[regtime_]]', NULL),
('hA4sY ', '/_MpXT|', 'Torbay', NULL, '[[regtime_]]', NULL),
('hA5s}iZ', '/_MpXT|', 'Warrington', NULL, '[[regtime_]]', NULL),
('hA5r/i', '/_MpXT|', 'West Berkshire', NULL, '[[regtime_]]', NULL),
('hA5p΀p,F', '/_MpXT|', 'Wiltshire', NULL, '[[regtime_]]', NULL),
('hA5$qlĪQx%', '/_MpXT|', 'Windsor and Maidenhead', NULL, '[[regtime_]]', NULL),
('hA5.s2l\Z', '/_MpXT|', 'Wokingham', NULL, '[[regtime_]]', NULL),
('hA58pI', '/_MpXT|', 'York', NULL, '[[regtime_]]', NULL),
('hA5Cp~Ɣ', '/_MpXT|', 'Antrim and Newtownabbey', NULL, '[[regtime_]]', NULL),
('hA5MsFbW', '/_MpXT|', 'Ards and North Down', NULL, '[[regtime_]]', NULL),
('hA5VrrSwf]>', '/_MpXT|', 'Armagh, Banbridge and Craigavon', NULL, '[[regtime_]]', NULL),
('hA5brՉv''~', '/_MpXT|', 'Belfast', NULL, '[[regtime_]]', NULL),
('hA5lq#\\U', '/_MpXT|', 'Causeway Coast and Glens', NULL, '[[regtime_]]', NULL),
('hA5vs}''VP', '/_MpXT|', 'Derry and Strabane', NULL, '[[regtime_]]', NULL),
('hA5sRbh|', '/_MpXT|', 'Fermanagh and Omagh', NULL, '[[regtime_]]', NULL),
('hA5p.!<|C|', '/_MpXT|', 'Lisburn and Castlereagh', NULL, '[[regtime_]]', NULL),
('hA5pfV', '/_MpXT|', 'Mid and East Antrim', NULL, '[[regtime_]]', NULL),
('hA5r''ܲ]', '/_MpXT|', 'Mid Ulster', NULL, '[[regtime_]]', NULL),
('hA5q*', '/_MpXT|', 'Newry, Mourne and Down', NULL, '[[regtime_]]', NULL),
('hA5rG?X', '/_MpXT|', 'Aberdeen City', NULL, '[[regtime_]]', NULL),
('hA5suaᙞ', '/_MpXT|', 'Aberdeenshire', NULL, '[[regtime_]]', NULL),
('hA5pӠODѲ', '/_MpXT|', 'Angus', NULL, '[[regtime_]]', NULL),
('hA5q	"j|OU', '/_MpXT|', 'Argyll and Bute', NULL, '[[regtime_]]', NULL),
('hA5r4#<bh', '/_MpXT|', 'Clackmannanshire', NULL, '[[regtime_]]', NULL),
('hA5sq!ܛ', '/_MpXT|', 'Dumfries and Galloway', NULL, '[[regtime_]]', NULL),
('hA5q$I', '/_MpXT|', 'Dundee City', NULL, '[[regtime_]]', NULL),
('hA5p;w', '/_MpXT|', 'East Ayrshire', NULL, '[[regtime_]]', NULL),
('hA5sp', '/_MpXT|', 'East Dunbartonshire', NULL, '[[regtime_]]', NULL),
('hA6p_', '/_MpXT|', 'East Lothian', NULL, '[[regtime_]]', NULL),
('hA6pNCp{ ', '/_MpXT|', 'East Renfrewshire', NULL, '[[regtime_]]', NULL),
('hA6\ZpKc8', '/_MpXT|', 'Edinburgh, City of', NULL, '[[regtime_]]', NULL),
('hA60s%@', '/_MpXT|', 'Eilean Siar', NULL, '[[regtime_]]', NULL),
('hA6:ppP', '/_MpXT|', 'Falkirk', NULL, '[[regtime_]]', NULL),
('hA6Cs34', '/_MpXT|', 'Fife', NULL, '[[regtime_]]', NULL),
('hA6Ms\\cMyb', '/_MpXT|', 'Glasgow City', NULL, '[[regtime_]]', NULL),
('hA6Vqf{!W)', '/_MpXT|', 'Highland', NULL, '[[regtime_]]', NULL),
('hA6`s$*5l', '/_MpXT|', 'Inverclyde', NULL, '[[regtime_]]', NULL),
('hA6jq2/\rd', '/_MpXT|', 'Midlothian', NULL, '[[regtime_]]', NULL),
('hA6tqŉ7܀/T', '/_MpXT|', 'Moray', NULL, '[[regtime_]]', NULL),
('hA6}pzO6', '/_MpXT|', 'North Ayrshire', NULL, '[[regtime_]]', NULL),
('hA6s}k', '/_MpXT|', 'North Lanarkshire', NULL, '[[regtime_]]', NULL),
('hA6rkyҲѷ', '/_MpXT|', 'Orkney Islands', NULL, '[[regtime_]]', NULL),
('hA6p', '/_MpXT|', 'Perth and Kinross', NULL, '[[regtime_]]', NULL),
('hA6p(`+#', '/_MpXT|', 'Renfrewshire', NULL, '[[regtime_]]', NULL),
('hA6rZ@5^Q', '/_MpXT|', 'Scottish Borders, The', NULL, '[[regtime_]]', NULL),
('hA6r-z|', '/_MpXT|', 'Shetland Islands', NULL, '[[regtime_]]', NULL),
('hA6p_foLU', '/_MpXT|', 'South Ayrshire', NULL, '[[regtime_]]', NULL),
('hA6pl;z*', '/_MpXT|', 'South Lanarkshire', NULL, '[[regtime_]]', NULL),
('hA6rި\n׸q,', '/_MpXT|', 'Stirling', NULL, '[[regtime_]]', NULL),
('hA6s\n', '/_MpXT|', 'West Dunbartonshire', NULL, '[[regtime_]]', NULL),
('hA6p|Z6', '/_MpXT|', 'West Lothian', NULL, '[[regtime_]]', NULL),
('hA6p2mzd', '/_MpXT|', 'Blaenau Gwent', NULL, '[[regtime_]]', NULL),
('hA7pUl', '/_MpXT|', 'Bridgend', NULL, '[[regtime_]]', NULL),
('hA7\rsCX', '/_MpXT|', 'Caerphilly', NULL, '[[regtime_]]', NULL),
('hA7sE>>7', '/_MpXT|', 'Cardiff', NULL, '[[regtime_]]', NULL),
('hA7 qMV`m', '/_MpXT|', 'Carmarthenshire', NULL, '[[regtime_]]', NULL),
('hA7.pw', '/_MpXT|', 'Ceredigion', NULL, '[[regtime_]]', NULL),
('hA77qG|', '/_MpXT|', 'Conwy', NULL, '[[regtime_]]', NULL),
('hA7Ap&į=,', '/_MpXT|', 'Denbighshire', NULL, '[[regtime_]]', NULL),
('hA7Kp^b', '/_MpXT|', 'Flintshire', NULL, '[[regtime_]]', NULL),
('hA7Uq9bk', '/_MpXT|', 'Gwynedd', NULL, '[[regtime_]]', NULL),
('hA7^r	B', '/_MpXT|', 'Isle of Anglesey', NULL, '[[regtime_]]', NULL),
('hA7hrEx', '/_MpXT|', 'Merthyr Tydfil', NULL, '[[regtime_]]', NULL),
('hA7rqkM', '/_MpXT|', 'Monmouthshire', NULL, '[[regtime_]]', NULL),
('hA7|sj%', '/_MpXT|', 'Neath Port Talbot', NULL, '[[regtime_]]', NULL),
('hA7q"/Z', '/_MpXT|', 'Newport', NULL, '[[regtime_]]', NULL),
('hA7r$H3', '/_MpXT|', 'Pembrokeshire', NULL, '[[regtime_]]', NULL),
('hA7r5*"p', '/_MpXT|', 'Powys', NULL, '[[regtime_]]', NULL),
('hA7sU\0l', '/_MpXT|', 'Rhondda, Cynon, Taff', NULL, '[[regtime_]]', NULL),
('hA7r۾-', '/_MpXT|', 'Swansea', NULL, '[[regtime_]]', NULL),
('hA7sހEFs', '/_MpXT|', 'Torfaen', NULL, '[[regtime_]]', NULL),
('hA7rF>LjM', '/_MpXT|', 'Vale of Glamorgan, The', NULL, '[[regtime_]]', NULL),
('hA7qM', '/_MpXT|', 'Wrexham', NULL, '[[regtime_]]', NULL),
('hA8peg4', '/_MpXT|', 'Alabama', NULL, '[[regtime_]]', NULL),
('hA8qA鮺L+G', '/_MpXT|', 'Alaska', NULL, '[[regtime_]]', NULL),
('hA8reeՔ;', '/_MpXT|', 'Arizona', NULL, '[[regtime_]]', NULL),
('hA8sƹhO$', '/_MpXT|', 'Arkansas', NULL, '[[regtime_]]', NULL),
('hA8rФLDÍ', '/_MpXT|', 'California', NULL, '[[regtime_]]', NULL),
('hA8rF\Zsm', '/_MpXT|', 'Colorado', NULL, '[[regtime_]]', NULL),
('hA9rh6', '/_MpXT|', 'Connecticut', NULL, '[[regtime_]]', NULL),
('hA9s%xeò', '/_MpXT|', 'Delaware', NULL, '[[regtime_]]', NULL),
('hA9rX\\/m', '/_MpXT|', 'Florida', NULL, '[[regtime_]]', NULL),
('hA9&qx ', '/_MpXT|', 'Georgia', NULL, '[[regtime_]]', NULL),
('hA90q8}UE', '/_MpXT|', 'Hawaii', NULL, '[[regtime_]]', NULL),
('hA9:pNbc7Z', '/_MpXT|', 'Idaho', NULL, '[[regtime_]]', NULL),
('hA9Dr'',ķ-o@', '/_MpXT|', 'Illinois', NULL, '[[regtime_]]', NULL),
('hA9Np)C{ ', '/_MpXT|', 'Indiana', NULL, '[[regtime_]]', NULL),
('hA9Xp)c8', '/_MpXT|', 'Iowa', NULL, '[[regtime_]]', NULL),
('hA9br\\O/', '/_MpXT|', 'Kansas', NULL, '[[regtime_]]', NULL),
('hA9lpE', '/_MpXT|', 'Kentucky', NULL, '[[regtime_]]', NULL),
('hA9urpۃ', '/_MpXT|', 'Louisiana', NULL, '[[regtime_]]', NULL),
('hA9pC', '/_MpXT|', 'Maine', NULL, '[[regtime_]]', NULL),
('hA9p$', '/_MpXT|', 'Maryland', NULL, '[[regtime_]]', NULL),
('hA9qs)n''', '/_MpXT|', 'Massachusetts', NULL, '[[regtime_]]', NULL),
('hA9pH', '/_MpXT|', 'Michigan', NULL, '[[regtime_]]', NULL),
('hA9p[8NI', '/_MpXT|', 'Minnesota', NULL, '[[regtime_]]', NULL),
('hA9q贛Wo', '/_MpXT|', 'Mississippi', NULL, '[[regtime_]]', NULL),
('hA9sǃLYr', '/_MpXT|', 'Missouri', NULL, '[[regtime_]]', NULL),
('hA9sߠ:զ', '/_MpXT|', 'Montana', NULL, '[[regtime_]]', NULL),
('hA9riGރu', '/_MpXT|', 'Nebraska', NULL, '[[regtime_]]', NULL),
('hA9si$!͢', '/_MpXT|', 'Nevada', NULL, '[[regtime_]]', NULL),
('hA9p^7$.', '/_MpXT|', 'New Hampshire', NULL, '[[regtime_]]', NULL),
('hA9p뻉}a`', '/_MpXT|', 'New Jersey', NULL, '[[regtime_]]', NULL),
('hA9q{\Zِ*Rj', '/_MpXT|', 'New Mexico', NULL, '[[regtime_]]', NULL),
('hA:r.,.', '/_MpXT|', 'New York', NULL, '[[regtime_]]', NULL),
('hA:qKrP/', '/_MpXT|', 'North Carolina', NULL, '[[regtime_]]', NULL),
('hA:pG\\', '/_MpXT|', 'North Dakota', NULL, '[[regtime_]]', NULL),
('hA: s˻1|Uo', '/_MpXT|', 'Ohio', NULL, '[[regtime_]]', NULL),
('hA:)s*~8>', '/_MpXT|', 'Oklahoma', NULL, '[[regtime_]]', NULL),
('hA:3sIn]~', '/_MpXT|', 'Oregon', NULL, '[[regtime_]]', NULL),
('hA:<qӎuz', '/_MpXT|', 'Pennsylvania', NULL, '[[regtime_]]', NULL),
('hA:Fsw;{>l', '/_MpXT|', 'Rhode Island', NULL, '[[regtime_]]', NULL),
('hA:SsC/', '/_MpXT|', 'South Carolina', NULL, '[[regtime_]]', NULL),
('hA:_pZTn', '/_MpXT|', 'South Dakota', NULL, '[[regtime_]]', NULL),
('hA:kqj*K>', '/_MpXT|', 'Tennessee', NULL, '[[regtime_]]', NULL),
('hA:ur˄S', '/_MpXT|', 'Texas', NULL, '[[regtime_]]', NULL),
('hA:~sO>', '/_MpXT|', 'Utah', NULL, '[[regtime_]]', NULL),
('hA:sӚ1[', '/_MpXT|', 'Vermont', NULL, '[[regtime_]]', NULL),
('hA:r>s', '/_MpXT|', 'Virginia', NULL, '[[regtime_]]', NULL),
('hA:qZq', '/_MpXT|', 'Washington', NULL, '[[regtime_]]', NULL),
('hA:s', '/_MpXT|', 'West Virginia', NULL, '[[regtime_]]', NULL),
('hA:sL}`3', '/_MpXT|', 'Wisconsin', NULL, '[[regtime_]]', NULL),
('hA:s꯳M):', '/_MpXT|', 'Wyoming', NULL, '[[regtime_]]', NULL),
('hA:q\Z', '/_MpXT|', 'District of Columbia', NULL, '[[regtime_]]', NULL),
('hB:rz[cH', 'hA,r+(', 'Ontario', NULL, '[[regtime_]]', NULL),
('hB:rz[cH', '/_MpXT|', 'Ontario', NULL, '[[regtime_]]', NULL),
('hB:rz[cvQ', 'hA,r+(', 'Québec', NULL, '[[regtime_]]', NULL),
('hB:rz[cvQ', '/_MpXT|', 'Quebec', NULL, '[[regtime_]]', NULL),
('hB:rz[d1', 'hA,r+(', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('hB:rz[d1', '/_MpXT|', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('hB:rz[e', 'hA,r+(', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('hB:rz[e', '/_MpXT|', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('hB:rz[eO9', 'hA,r+(', 'Manitoba', NULL, '[[regtime_]]', NULL),
('hB:rz[eO9', '/_MpXT|', 'Manitoba', NULL, '[[regtime_]]', NULL),
('hB:rz[e', 'hA,r+(', 'British Columbia', NULL, '[[regtime_]]', NULL),
('hB:rz[e', '/_MpXT|', 'British Columbia', NULL, '[[regtime_]]', NULL),
('hB:rz[fH`', 'hA,r+(', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('hB:rz[fH`', '/_MpXT|', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('hB:rz[fNw', 'hA,r+(', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('hB:rz[fNw', '/_MpXT|', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('hB:rz[gi', 'hA,r+(', 'Alberta', NULL, '[[regtime_]]', NULL),
('hB:rz[gi', '/_MpXT|', 'Alberta', NULL, '[[regtime_]]', NULL),
('hB:rz[gz', 'hA,r+(', 'Neufundland und Labrador', NULL, '[[regtime_]]', NULL),
('hB:rz[gz', '/_MpXT|', 'Newfoundland and Labrador', NULL, '[[regtime_]]', NULL),
('hB:rz[hh', 'hA,r+(', 'Nordwest-Territorien', NULL, '[[regtime_]]', NULL),
('hB:rz[hh', '/_MpXT|', 'Northwest Territories', NULL, '[[regtime_]]', NULL),
('hB;r[\Z', 'hA,r+(', 'Yukon', NULL, '[[regtime_]]', NULL),
('hB;r[\Z', '/_MpXT|', 'Yukon', NULL, '[[regtime_]]', NULL),
('hB;r[@p', 'hA,r+(', 'Nunavut', NULL, '[[regtime_]]', NULL),
('hB;r[@p', '/_MpXT|', 'Nunavut', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_translation`
--

CREATE TABLE `country_translation` (
  `country_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_format` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_id`,`language_id`),
  KEY `fk.country_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_translation`
--

INSERT INTO `country_translation` VALUES
('hA-r6sx', 'hA,r+(', 'Deutschland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA-r6sx', '/_MpXT|', 'Germany', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA.s|-', 'hA,r+(', 'Griechenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA.s|-', '/_MpXT|', 'Greece', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA.r@RY', 'hA,r+(', 'Vereinigtes Königreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA.r@RY', '/_MpXT|', 'United Kingdom', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA7pZl|', 'hA,r+(', 'Irland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA7pZl|', '/_MpXT|', 'Ireland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8q年@', 'hA,r+(', 'Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8q年@', '/_MpXT|', 'Iceland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8p\n\\M,e"', 'hA,r+(', 'Italien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8p\n\\M,e"', '/_MpXT|', 'Italy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8!sЊTqxWx', 'hA,r+(', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8!sЊTqxWx', '/_MpXT|', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8/s&}\n', 'hA,r+(', 'Kanada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8/s&}\n', '/_MpXT|', 'Canada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8=r(q;U', 'hA,r+(', 'Luxemburg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8=r(q;U', '/_MpXT|', 'Luxembourg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8Ks\nkm8', 'hA,r+(', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8Ks\nkm8', '/_MpXT|', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8Zp (', 'hA,r+(', 'Niederlande', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8Zp (', '/_MpXT|', 'Netherlands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8hqNtƈ', 'hA,r+(', 'Norwegen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8hqNtƈ', '/_MpXT|', 'Norway', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8vp}~p<B', 'hA,r+(', 'Österreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8vp}~p<B', '/_MpXT|', 'Austria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8pRsQ', 'hA,r+(', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8pRsQ', '/_MpXT|', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8p''߅OZ', 'hA,r+(', 'Schweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8p''߅OZ', '/_MpXT|', 'Sweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8p/`', 'hA,r+(', 'Schweiz', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8p/`', '/_MpXT|', 'Switzerland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8st"', 'hA,r+(', 'Spanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8st"', '/_MpXT|', 'Spain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA8pGϕ|', 'hA,r+(', 'Vereinigte Staaten von Amerika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('hA8pGϕ|', '/_MpXT|', 'United States of America', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('hA:rԖ/n', 'hA,r+(', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA:rԖ/n', '/_MpXT|', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA:sDo', 'hA,r+(', 'Arabische Emirate', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA:sDo', '/_MpXT|', 'Arab Emirates', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA:rgؿD>', 'hA,r+(', 'Polen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA:rgؿD>', '/_MpXT|', 'Poland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA:q~Mo>', 'hA,r+(', 'Ungarn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA:q~Mo>', '/_MpXT|', 'Hungary', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;sk;-eL', 'hA,r+(', 'Türkei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;sk;-eL', '/_MpXT|', 'Turkey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;pChv^O', 'hA,r+(', 'Tschechische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;pChv^O', '/_MpXT|', 'Czech Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;*rDp', 'hA,r+(', 'Slowakei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('hA;*rDp', '/_MpXT|', 'Slovakia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('hA;8pބOrG\r', 'hA,r+(', 'Rumänien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;8pބOrG\r', '/_MpXT|', 'Romania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;Fpuav\Z', 'hA,r+(', 'Brasilien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;Fpuav\Z', '/_MpXT|', 'Brazil', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;Tp@IR', 'hA,r+(', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;Tp@IR', '/_MpXT|', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;cp''w^', 'hA,r+(', 'Australien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;cp''w^', '/_MpXT|', 'Australia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;rr줙l]', 'hA,r+(', 'Belgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;rr줙l]', '/_MpXT|', 'Belgium', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;pe%!>', 'hA,r+(', 'Dänemark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;pe%!>', '/_MpXT|', 'Denmark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;r#~Ĥx}	', 'hA,r+(', 'Finnland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;r#~Ĥx}	', '/_MpXT|', 'Finland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;rw4!', 'hA,r+(', 'Frankreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA;rw4!', '/_MpXT|', 'France', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA3s\nc:3&', 'hA,r+(', 'Bulgarien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA3s\nc:3&', '/_MpXT|', 'Bulgaria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAOrl[4tcI', 'hA,r+(', 'Estland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAOrl[4tcI', '/_MpXT|', 'Estonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAjp4', 'hA,r+(', 'Kroatien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAjp4', '/_MpXT|', 'Croatia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsBtk{O', 'hA,r+(', 'Lettland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsBtk{O', '/_MpXT|', 'Latvia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArN}d', 'hA,r+(', 'Litauen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArN}d', '/_MpXT|', 'Lithuania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr4~ൻ', 'hA,r+(', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr4~ൻ', '/_MpXT|', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArߐnV', 'hA,r+(', 'Slowenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArߐnV', '/_MpXT|', 'Slovenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsgE!', 'hA,r+(', 'Zypern', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsgE!', '/_MpXT|', 'Cyprus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqqZSB', 'hA,r+(', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqqZSB', '/_MpXT|', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArW1', 'hA,r+(', 'Åland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArW1', '/_MpXT|', 'Åland Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA,rÁnK', 'hA,r+(', 'Albanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA,rÁnK', '/_MpXT|', 'Albania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA>sfgYw', 'hA,r+(', 'Algerien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA>sfgYw', '/_MpXT|', 'Algeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAQrޠU,Y', 'hA,r+(', 'Amerikanisch-Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAQrޠU,Y', '/_MpXT|', 'American Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAds버', 'hA,r+(', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAds버', '/_MpXT|', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAup{<', 'hA,r+(', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAup{<', '/_MpXT|', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr+EB!-', 'hA,r+(', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr+EB!-', '/_MpXT|', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsL	au^', 'hA,r+(', 'Antarktika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsL	au^', '/_MpXT|', 'Antarctica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs-]''', 'hA,r+(', 'Antigua und Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs-]''', '/_MpXT|', 'Antigua and Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq5ESS\Zt', 'hA,r+(', 'Argentinien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq5ESS\Zt', '/_MpXT|', 'Argentina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApID-', 'hA,r+(', 'Armenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApID-', '/_MpXT|', 'Armenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAra7', 'hA,r+(', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAra7', '/_MpXT|', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqֈTed<*', 'hA,r+(', 'Aserbaidschan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqֈTed<*', '/_MpXT|', 'Azerbaijan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr6Ǿͬ', 'hA,r+(', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr6Ǿͬ', '/_MpXT|', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA#r@1S8+U', 'hA,r+(', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA#r@1S8+U', '/_MpXT|', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA6pT\rY', 'hA,r+(', 'Bangladesch', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA6pT\rY', '/_MpXT|', 'Bangladesh', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAHs[G', 'hA,r+(', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAHs[G', '/_MpXT|', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA[pb͑b', 'hA,r+(', 'Weißrussland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA[pb͑b', '/_MpXT|', 'Belarus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqs"y\\', 'hA,r+(', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqs"y\\', '/_MpXT|', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr0DIb', 'hA,r+(', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr0DIb', '/_MpXT|', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsꏸ', 'hA,r+(', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsꏸ', '/_MpXT|', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArJt\r', 'hA,r+(', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArJt\r', '/_MpXT|', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsixg1<', 'hA,r+(', 'Bolivien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsixg1<', '/_MpXT|', 'Bolivia (Plurinational State of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsM:o', 'hA,r+(', 'Bonaire, Sint Eustatius und Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsM:o', '/_MpXT|', 'Bonaire, Sint Eustatius and Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsMw~6b}', 'hA,r+(', 'Bosnien und Herzegowina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsMw~6b}', '/_MpXT|', 'Bosnia and Herzegovina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsZN', 'hA,r+(', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsZN', '/_MpXT|', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq	L̤', 'hA,r+(', 'Bouvetinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq	L̤', '/_MpXT|', 'Bouvet Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA\Zr53\Z', 'hA,r+(', 'Britisches Territorium im Indischen Ozean', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA\Zr53\Z', '/_MpXT|', 'British Indian Ocean Territory', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA.r-犕g', 'hA,r+(', 'Kleinere Inselbesitzungen der Vereinigten Staaten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA.r-犕g', '/_MpXT|', 'United States Minor Outlying Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA@sL', 'hA,r+(', 'Britische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA@sL', '/_MpXT|', 'Virgin Islands (British)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVqSi', 'hA,r+(', 'Amerikanische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVqSi', '/_MpXT|', 'Virgin Islands (U.S.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAjqrND.', 'hA,r+(', 'Brunei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAjqrND.', '/_MpXT|', 'Brunei Darussalam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq% ', 'hA,r+(', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq% ', '/_MpXT|', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArHz,!b', 'hA,r+(', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArHz,!b', '/_MpXT|', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsiMY8lk', 'hA,r+(', 'Kambodscha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsiMY8lk', '/_MpXT|', 'Cambodia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqrHL', 'hA,r+(', 'Kamerun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqrHL', '/_MpXT|', 'Cameroon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApꐣ8ض', 'hA,r+(', 'Kap Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApꐣ8ض', '/_MpXT|', 'Cabo Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp~0I[', 'hA,r+(', 'Kaimaninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp~0I[', '/_MpXT|', 'Cayman Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr''dR', 'hA,r+(', 'Zentralafrikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr''dR', '/_MpXT|', 'Central African Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA''pK4SIk0', 'hA,r+(', 'Tschad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA''pK4SIk0', '/_MpXT|', 'Chad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAKp|ع	', 'hA,r+(', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAKp|ع	', '/_MpXT|', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAjqqw\0', 'hA,r+(', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAjqqw\0', '/_MpXT|', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq3`''}', 'hA,r+(', 'Weihnachtsinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq3`''}', '/_MpXT|', 'Christmas Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp뇿Z', 'hA,r+(', 'Kokosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp뇿Z', '/_MpXT|', 'Cocos (Keeling) Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApŅ>R ', 'hA,r+(', 'Kolumbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApŅ>R ', '/_MpXT|', 'Colombia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp@Jt', 'hA,r+(', 'Union der Komoren', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp@Jt', '/_MpXT|', 'Comoros', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA\rpڌ~3\Z', 'hA,r+(', 'Kongo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA\rpڌ~3\Z', '/_MpXT|', 'Congo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('hA pi^', 'hA,r+(', 'Kongo (Dem. Rep.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA pi^', '/_MpXT|', 'Congo (Democratic Republic of the)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA4r|\0Jn', 'hA,r+(', 'Cookinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA4r|\0Jn', '/_MpXT|', 'Cook Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAJqwCq[', 'hA,r+(', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAJqwCq[', '/_MpXT|', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA^q䎡', 'hA,r+(', 'Kuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA^q䎡', '/_MpXT|', 'Cuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAos#|', 'hA,r+(', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAos#|', '/_MpXT|', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp>=QA;', 'hA,r+(', 'Dschibuti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp>=QA;', '/_MpXT|', 'Djibouti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp*Ұ', 'hA,r+(', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp*Ұ', '/_MpXT|', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArBRm', 'hA,r+(', 'Dominikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArBRm', '/_MpXT|', 'Dominican Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArc3', 'hA,r+(', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArc3', '/_MpXT|', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApD`^e', 'hA,r+(', 'Ägypten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApD`^e', '/_MpXT|', 'Egypt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqk`z', 'hA,r+(', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqk`z', '/_MpXT|', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs3NK', 'hA,r+(', 'Äquatorial-Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs3NK', '/_MpXT|', 'Equatorial Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA!rl''', 'hA,r+(', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA!rl''', '/_MpXT|', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA3rɦ=j4w', 'hA,r+(', 'Äthiopien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA3rɦ=j4w', '/_MpXT|', 'Ethiopia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hACpL](?', 'hA,r+(', 'Falklandinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hACpL](?', '/_MpXT|', 'Falkland Islands (Malvinas)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hASsʩ', 'hA,r+(', 'Färöer-Inseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hASsʩ', '/_MpXT|', 'Faroe Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAbpJ', 'hA,r+(', 'Fidschi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAbpJ', '/_MpXT|', 'Fiji', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAvqÈ', 'hA,r+(', 'Französisch Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAvqÈ', '/_MpXT|', 'French Guiana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsxdň', 'hA,r+(', 'Französisch-Polynesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsxdň', '/_MpXT|', 'French Polynesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqZq$H', 'hA,r+(', 'Französische Süd- und Antarktisgebiete', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqZq$H', '/_MpXT|', 'French Southern Territories', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqxE[J', 'hA,r+(', 'Gabun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqxE[J', '/_MpXT|', 'Gabon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqCdI	', 'hA,r+(', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqCdI	', '/_MpXT|', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAprK*xP', 'hA,r+(', 'Georgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAprK*xP', '/_MpXT|', 'Georgia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsHCO', 'hA,r+(', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsHCO', '/_MpXT|', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp?a\0Ogwz', 'hA,r+(', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp?a\0Ogwz', '/_MpXT|', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA\rp@#', 'hA,r+(', 'Grönland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA\rp@#', '/_MpXT|', 'Greenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqqKȩ', 'hA,r+(', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqqKȩ', '/_MpXT|', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA4p餆h~!', 'hA,r+(', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA4p餆h~!', '/_MpXT|', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAFrN5*', 'hA,r+(', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAFrN5*', '/_MpXT|', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVqțl@ڜ', 'hA,r+(', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVqțl@ڜ', '/_MpXT|', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAhqϷ$Qm', 'hA,r+(', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAhqϷ$Qm', '/_MpXT|', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAyrcˎvZ', 'hA,r+(', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAyrcˎvZ', '/_MpXT|', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp!', 'hA,r+(', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp!', '/_MpXT|', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsKk~', 'hA,r+(', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsKk~', '/_MpXT|', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqq5	', 'hA,r+(', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqq5	', '/_MpXT|', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp䛇vU', 'hA,r+(', 'Heard und die McDonaldinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp䛇vU', '/_MpXT|', 'Heard Island and McDonald Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApf', 'hA,r+(', 'Staat Vatikanstadt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApf', '/_MpXT|', 'Vatican City', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApBc2I', 'hA,r+(', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApBc2I', '/_MpXT|', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp\\D4', 'hA,r+(', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp\\D4', '/_MpXT|', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA rVXN4Q', 'hA,r+(', 'Indien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA rVXN4Q', '/_MpXT|', 'India', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA>rH<Tjm', 'hA,r+(', 'Indonesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA>rH<Tjm', '/_MpXT|', 'Indonesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVr', 'hA,r+(', 'Elfenbeinküste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVr', '/_MpXT|', 'Côte d''Ivoire', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAosT)fE', 'hA,r+(', 'Iran', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAosT)fE', '/_MpXT|', 'Iran (Islamic Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqHvL"', 'hA,r+(', 'Irak', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqHvL"', '/_MpXT|', 'Iraq', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApQ*V#', 'hA,r+(', 'Insel Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApQ*V#', '/_MpXT|', 'Isle of Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp*O*P', 'hA,r+(', 'Jamaika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp*O*P', '/_MpXT|', 'Jamaica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq?a(c', 'hA,r+(', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq?a(c', '/_MpXT|', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArgd|', 'hA,r+(', 'Jordanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArgd|', '/_MpXT|', 'Jordan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqU[', 'hA,r+(', 'Kasachstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqU[', '/_MpXT|', 'Kazakhstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq(@\\(;U', 'hA,r+(', 'Kenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq(@\\(;U', '/_MpXT|', 'Kenya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA0sտv^y', 'hA,r+(', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA0sտv^y', '/_MpXT|', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAAsty{&"', 'hA,r+(', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAAsty{&"', '/_MpXT|', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVr{\Z]L8', 'hA,r+(', 'Kirgisistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAVr{\Z]L8', '/_MpXT|', 'Kyrgyzstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAgrM\nO7=', 'hA,r+(', 'Laos', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAgrM\nO7=', '/_MpXT|', 'Lao People''s Democratic Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAwqúKD\Z', 'hA,r+(', 'Libanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAwqúKD\Z', '/_MpXT|', 'Lebanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq7(h', 'hA,r+(', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq7(h', '/_MpXT|', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr/\r+`', 'hA,r+(', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr/\r+`', '/_MpXT|', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApoI', 'hA,r+(', 'Libyen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApoI', '/_MpXT|', 'Libya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr콠*\\', 'hA,r+(', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr콠*\\', '/_MpXT|', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr/3_', 'hA,r+(', 'Mazedonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr/3_', '/_MpXT|', 'Macedonia (the former Yugoslav Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp@I){=', 'hA,r+(', 'Madagaskar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp@I){=', '/_MpXT|', 'Madagascar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApO77%', 'hA,r+(', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApO77%', '/_MpXT|', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr6p', 'hA,r+(', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr6p', '/_MpXT|', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApѷu\r^', 'hA,r+(', 'Malediven', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApѷu\r^', '/_MpXT|', 'Maldives', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA''q!Qt,', 'hA,r+(', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA''q!Qt,', '/_MpXT|', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA7sl"t', 'hA,r+(', 'Marshallinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA7sl"t', '/_MpXT|', 'Marshall Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAGs߯\0N/', 'hA,r+(', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAGs߯\0N/', '/_MpXT|', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAWrQUX', 'hA,r+(', 'Mauretanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAWrQUX', '/_MpXT|', 'Mauritania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAgrWo\\', 'hA,r+(', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAgrWo\\', '/_MpXT|', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA}rI<', 'hA,r+(', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA}rI<', '/_MpXT|', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr~A}K/', 'hA,r+(', 'Mexiko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr~A}K/', '/_MpXT|', 'Mexico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsaL8	.', 'hA,r+(', 'Mikronesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsaL8	.', '/_MpXT|', 'Micronesia (Federated States of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr5', 'hA,r+(', 'Moldawie', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr5', '/_MpXT|', 'Moldova (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApSIo\Z(8', 'hA,r+(', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApSIo\Z(8', '/_MpXT|', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqO |h', 'hA,r+(', 'Mongolei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqO |h', '/_MpXT|', 'Mongolia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp3h!', 'hA,r+(', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp3h!', '/_MpXT|', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArsd@', 'hA,r+(', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArsd@', '/_MpXT|', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq!~F', 'hA,r+(', 'Marokko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq!~F', '/_MpXT|', 'Morocco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA!p~', 'hA,r+(', 'Mosambik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA!p~', '/_MpXT|', 'Mozambique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA0pȭ[(', 'hA,r+(', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA0pȭ[(', '/_MpXT|', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hADsq', 'hA,r+(', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hADsq', '/_MpXT|', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hATr6nb0', 'hA,r+(', 'Népal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hATr6nb0', '/_MpXT|', 'Nepal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAcr.(*V$', 'hA,r+(', 'Neukaledonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAcr.(*V$', '/_MpXT|', 'New Caledonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArs=', 'hA,r+(', 'Neuseeland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArs=', '/_MpXT|', 'New Zealand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs	΄', 'hA,r+(', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs	΄', '/_MpXT|', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqDi', 'hA,r+(', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqDi', '/_MpXT|', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq\nf]', 'hA,r+(', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq\nf]', '/_MpXT|', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr*LZq', 'hA,r+(', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr*LZq', '/_MpXT|', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr2@', 'hA,r+(', 'Norfolkinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr2@', '/_MpXT|', 'Norfolk Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr	h', 'hA,r+(', 'Nordkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('hAr	h', '/_MpXT|', 'Korea (Democratic People''s Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArMr''', 'hA,r+(', 'Nördliche Marianen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArMr''', '/_MpXT|', 'Northern Mariana Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqBY\rt', 'hA,r+(', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqBY\rt', '/_MpXT|', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA%p)ykhs', 'hA,r+(', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA%p)ykhs', '/_MpXT|', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA=rd#', 'hA,r+(', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA=rd#', '/_MpXT|', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAWq)V ', 'hA,r+(', 'Palästina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAWq)V ', '/_MpXT|', 'Palestine, State of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArs?i};', 'hA,r+(', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArs?i};', '/_MpXT|', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsȡ8Ԧ', 'hA,r+(', 'Papua-Neuguinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsȡ8Ԧ', '/_MpXT|', 'Papua New Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs\r;\Z#', 'hA,r+(', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs\r;\Z#', '/_MpXT|', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqלrsT)V', 'hA,r+(', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqלrsT)V', '/_MpXT|', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqA`V', 'hA,r+(', 'Philippinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqA`V', '/_MpXT|', 'Philippines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqhfL', 'hA,r+(', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqhfL', '/_MpXT|', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqtnf-+T', 'hA,r+(', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqtnf-+T', '/_MpXT|', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs:G', 'hA,r+(', 'Katar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs:G', '/_MpXT|', 'Qatar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq[zE>zQ\0', 'hA,r+(', 'Republik Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq[zE>zQ\0', '/_MpXT|', 'Republic of Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA#pO', 'hA,r+(', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA#pO', '/_MpXT|', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA2pqp2o', 'hA,r+(', 'Russland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA2pqp2o', '/_MpXT|', 'Russian Federation', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hABrg(xW', 'hA,r+(', 'Ruanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hABrg(xW', '/_MpXT|', 'Rwanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAQrX\\7R솚', 'hA,r+(', 'Saint-Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAQrX\\7R솚', '/_MpXT|', 'Saint Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAap1ry5(\0', 'hA,r+(', 'Sankt Helena', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAap1ry5(\0', '/_MpXT|', 'Saint Helena, Ascension and Tristan da Cunha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqq.=>pA', 'hA,r+(', 'St. Kitts und Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqq.=>pA', '/_MpXT|', 'Saint Kitts and Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq.x?l', 'hA,r+(', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq.x?l', '/_MpXT|', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAruS+}', 'hA,r+(', 'Saint Martin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAruS+}', '/_MpXT|', 'Saint Martin (French part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArCOhi', 'hA,r+(', 'Saint-Pierre und Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArCOhi', '/_MpXT|', 'Saint Pierre and Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsb>', 'hA,r+(', 'Saint Vincent und die Grenadinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsb>', '/_MpXT|', 'Saint Vincent and the Grenadines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApFJu', 'hA,r+(', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApFJu', '/_MpXT|', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs݀', 'hA,r+(', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs݀', '/_MpXT|', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs\0HN*#)', 'hA,r+(', 'São Tomé und Príncipe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs\0HN*#)', '/_MpXT|', 'Sao Tome and Principe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr(LAlKD', 'hA,r+(', 'Saudi-Arabien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr(LAlKD', '/_MpXT|', 'Saudi Arabia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApN?G^', 'hA,r+(', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApN?G^', '/_MpXT|', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsݼ*$#', 'hA,r+(', 'Serbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsݼ*$#', '/_MpXT|', 'Serbia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr}:F$', 'hA,r+(', 'Seychellen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAr}:F$', '/_MpXT|', 'Seychelles', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA/r^+^sя', 'hA,r+(', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA/r^+^sя', '/_MpXT|', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA>p?FEP6', 'hA,r+(', 'Singapur', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA>p?FEP6', '/_MpXT|', 'Singapore', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hANpΙ	', 'hA,r+(', 'Sint Maarten (niederl. Teil)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hANpΙ	', '/_MpXT|', 'Sint Maarten (Dutch part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA^qܿ7\\', 'hA,r+(', 'Salomonen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA^qܿ7\\', '/_MpXT|', 'Solomon Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAmpdnZ', 'hA,r+(', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAmpdnZ', '/_MpXT|', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA}p{樵l', 'hA,r+(', 'Republik Südafrika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA}p{樵l', '/_MpXT|', 'South Africa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqXW`^', 'hA,r+(', 'Südgeorgien und die Südlichen Sandwichinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqXW`^', '/_MpXT|', 'South Georgia and the South Sandwich Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqH<ѱ', 'hA,r+(', 'Südkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqH<ѱ', '/_MpXT|', 'Korea (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApϺ[m\\2', 'hA,r+(', 'Südsudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApϺ[m\\2', '/_MpXT|', 'South Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArq(c', 'hA,r+(', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArq(c', '/_MpXT|', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp>-P', 'hA,r+(', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp>-P', '/_MpXT|', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApi8-', 'hA,r+(', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApi8-', '/_MpXT|', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApͬ''\\0+g', 'hA,r+(', 'Svalbard und Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApͬ''\\0+g', '/_MpXT|', 'Svalbard and Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs{4zO', 'hA,r+(', 'Swasiland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs{4zO', '/_MpXT|', 'Swaziland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA$rό\r', 'hA,r+(', 'Syrien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA$rό\r', '/_MpXT|', 'Syrian Arab Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA4rJ', 'hA,r+(', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA4rJ', '/_MpXT|', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hADq2e', 'hA,r+(', 'Tadschikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hADq2e', '/_MpXT|', 'Tajikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hASr|@', 'hA,r+(', 'Tansania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hASr|@', '/_MpXT|', 'Tanzania, United Republic of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAcqlj=y', 'hA,r+(', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAcqlj=y', '/_MpXT|', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsr''', 'hA,r+(', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsr''', '/_MpXT|', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqhy&4', 'hA,r+(', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqhy&4', '/_MpXT|', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqO$o', 'hA,r+(', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqO$o', '/_MpXT|', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsߞ23', 'hA,r+(', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsߞ23', '/_MpXT|', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp.%8y', 'hA,r+(', 'Trinidad und Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp.%8y', '/_MpXT|', 'Trinidad and Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApZG"', 'hA,r+(', 'Tunesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApZG"', '/_MpXT|', 'Tunisia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs', 'hA,r+(', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs', '/_MpXT|', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsܶl&nk', 'hA,r+(', 'Turks- und Caicosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsܶl&nk', '/_MpXT|', 'Turks and Caicos Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp4M', 'hA,r+(', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAp4M', '/_MpXT|', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA2r"', 'hA,r+(', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hA2r"', '/_MpXT|', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hANqM!t', 'hA,r+(', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hANqM!t', '/_MpXT|', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAlqw', 'hA,r+(', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAlqw', '/_MpXT|', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArRv_', 'hA,r+(', 'Usbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArRv_', '/_MpXT|', 'Uzbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqJ8Fl', 'hA,r+(', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAqJ8Fl', '/_MpXT|', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArݭNh2', 'hA,r+(', 'Venezuela', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArݭNh2', '/_MpXT|', 'Venezuela (Bolivarian Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq:PϦ', 'hA,r+(', 'Vietnam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAq:PϦ', '/_MpXT|', 'Viet Nam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs\\_f', 'hA,r+(', 'Wallis und Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs\\_f', '/_MpXT|', 'Wallis and Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArԅL\r%b', 'hA,r+(', 'Westsahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hArԅL\r%b', '/_MpXT|', 'Western Sahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsG+ei', 'hA,r+(', 'Jemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAsG+ei', '/_MpXT|', 'Yemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs[adXU', 'hA,r+(', 'Sambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hAs[adXU', '/_MpXT|', 'Zambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApac6t', 'hA,r+(', 'Simbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('hApac6t', '/_MpXT|', 'Zimbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE `currency` (
  `id` binary(16) NOT NULL,
  `iso_code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `factor` double NOT NULL,
  `symbol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `item_rounding` json DEFAULT NULL,
  `total_rounding` json DEFAULT NULL,
  `tax_free_from` double DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.currency.iso_code` (`iso_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` VALUES
('UKG͂', 'USD', 1, '$', 1, '[[regtime_]]', NULL, '{"decimals": "2", "interval": 0.01, "roundForNet": true}', '{"decimals": "2", "interval": 0.01, "roundForNet": true}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `currency_country_rounding`
--

CREATE TABLE `currency_country_rounding` (
  `id` binary(16) NOT NULL,
  `currency_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `item_rounding` json NOT NULL,
  `total_rounding` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_id` (`currency_id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currency_translation`
--

CREATE TABLE `currency_translation` (
  `currency_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`currency_id`,`language_id`),
  KEY `fk.currency_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency_translation`
--

INSERT INTO `currency_translation` VALUES
('UKG͂', 'hA,r+(', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL),
('UKG͂', '/_MpXT|', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `id` binary(16) NOT NULL,
  `auto_increment` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` binary(16) NOT NULL,
  `requested_customer_group_id` binary(16) DEFAULT NULL,
  `default_payment_method_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `last_payment_method_id` binary(16) DEFAULT NULL,
  `default_billing_address_id` binary(16) NOT NULL,
  `default_shipping_address_id` binary(16) NOT NULL,
  `customer_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_encoder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_ids` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `double_opt_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `double_opt_in_email_sent_date` datetime(3) DEFAULT NULL,
  `double_opt_in_confirm_date` datetime(3) DEFAULT NULL,
  `hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guest` tinyint(1) NOT NULL DEFAULT '0',
  `first_login` datetime(3) DEFAULT NULL,
  `last_login` datetime(3) DEFAULT NULL,
  `newsletter_sales_channel_ids` json DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `last_order_date` datetime(3) DEFAULT NULL,
  `order_count` int NOT NULL DEFAULT '0',
  `order_total_amount` double DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `affiliate_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `remote_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag_ids` json DEFAULT NULL,
  `bound_sales_channel_id` binary(16) DEFAULT NULL,
  `created_by_id` binary(16) DEFAULT NULL,
  `updated_by_id` binary(16) DEFAULT NULL,
  `account_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'private',
  `review_count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.auto_increment` (`auto_increment`),
  UNIQUE KEY `hash` (`hash`),
  KEY `idx.firstlogin` (`first_login`),
  KEY `idx.lastlogin` (`last_login`),
  KEY `idx.customer.default_billing_address_id` (`default_billing_address_id`),
  KEY `idx.customer.default_shipping_address_id` (`default_shipping_address_id`),
  KEY `fk.customer.customer_group_id` (`customer_group_id`),
  KEY `fk.customer.default_payment_method_id` (`default_payment_method_id`),
  KEY `fk.customer.last_payment_method_id` (`last_payment_method_id`),
  KEY `fk.customer.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer.requested_customer_group_id` (`requested_customer_group_id`),
  KEY `fk.customer.bound_sales_channel_id` (`bound_sales_channel_id`),
  KEY `idx.email` (`email`),
  KEY `fk.customer.salutation_id` (`salutation_id`),
  KEY `fk.customer.created_by_id` (`created_by_id`),
  KEY `fk.customer.updated_by_id` (`updated_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customer_address`
--

CREATE TABLE `customer_address` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `country_state_id` binary(16) DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zipcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(70) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.customer_address.country_id` (`country_id`),
  KEY `fk.customer_address.country_state_id` (`country_state_id`),
  KEY `fk.customer_address.customer_id` (`customer_id`),
  KEY `fk.customer_address.salutation_id` (`salutation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group`
--

CREATE TABLE `customer_group` (
  `id` binary(16) NOT NULL,
  `display_gross` tinyint(1) NOT NULL DEFAULT '1',
  `registration_active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group`
--

INSERT INTO `customer_group` VALUES
('ϽPӍAحOȽ', 1, 0, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_registration_sales_channels`
--

CREATE TABLE `customer_group_registration_sales_channels` (
  `customer_group_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  PRIMARY KEY (`customer_group_id`,`sales_channel_id`),
  KEY `fk.customer_group_registration_sales_channels.customer_group_id` (`customer_group_id`),
  KEY `fk.customer_group_registration_sales_channels.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_translation`
--

CREATE TABLE `customer_group_translation` (
  `customer_group_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `registration_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_introduction` longtext COLLATE utf8mb4_unicode_ci,
  `registration_only_company_registration` tinyint(1) DEFAULT NULL,
  `registration_seo_meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`customer_group_id`,`language_id`),
  KEY `fk.customer_group_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group_translation`
--

INSERT INTO `customer_group_translation` VALUES
('ϽPӍAحOȽ', 'hA,r+(', 'Standard-Kundengruppe', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ϽPӍAحOȽ', '/_MpXT|', 'Standard customer group', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_recovery`
--

CREATE TABLE `customer_recovery` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_recovery.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_tag`
--

CREATE TABLE `customer_tag` (
  `customer_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`customer_id`,`tag_id`),
  KEY `fk.customer_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist`
--

CREATE TABLE `customer_wishlist` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist` (`sales_channel_id`,`customer_id`),
  KEY `fk.customer_wishlist.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer_wishlist.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist_product`
--

CREATE TABLE `customer_wishlist_product` (
  `id` binary(16) NOT NULL,
  `customer_wishlist_id` binary(16) NOT NULL,
  `product_id` binary(16) NOT NULL,
  `product_version_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist.sales_channel_id__customer_id` (`customer_wishlist_id`,`product_id`),
  KEY `fk.customer_wishlist_product.product_id` (`product_id`,`product_version_id`),
  KEY `fk.customer_wishlist_product.customer_wishlist_id` (`customer_wishlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_entity`
--

CREATE TABLE `custom_entity` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` json NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `flags` json DEFAULT NULL,
  `plugin_id` binary(16) DEFAULT NULL,
  `custom_fields_aware` tinyint(1) NOT NULL DEFAULT '0',
  `label_property` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `app_id` (`app_id`),
  KEY `fk.custom_entity.plugin_id` (`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field`
--

CREATE TABLE `custom_field` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `set_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `allow_customer_write` tinyint NOT NULL DEFAULT '0',
  `allow_cart_expose` tinyint(1) NOT NULL DEFAULT '0',
  `store_api_aware` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field.name` (`name`),
  KEY `fk.custom_field.set_id` (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set`
--

CREATE TABLE `custom_field_set` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `app_id` binary(16) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `global` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.custom_field_set.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set_relation`
--

CREATE TABLE `custom_field_set_relation` (
  `id` binary(16) NOT NULL,
  `set_id` binary(16) NOT NULL,
  `entity_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field_set_relation.entity_name` (`set_id`,`entity_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time`
--

CREATE TABLE `delivery_time` (
  `id` binary(16) NOT NULL,
  `min` int NOT NULL,
  `max` int NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time`
--

INSERT INTO `delivery_time` VALUES
('hA<WrX8X', 1, 3, 'day', '[[regtime_]]', NULL),
('hA<WrX8תt', 2, 5, 'day', '[[regtime_]]', NULL),
('hA<WrX8;', 1, 2, 'week', '[[regtime_]]', NULL),
('hA<WrX8+', 3, 4, 'week', '[[regtime_]]', NULL),
('hB`Ps\n9nx	', 0, 0, 'hour', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time_translation`
--

CREATE TABLE `delivery_time_translation` (
  `delivery_time_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`delivery_time_id`,`language_id`),
  KEY `fk.delivery_time_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time_translation`
--

INSERT INTO `delivery_time_translation` VALUES
('hA<WrX8X', 'hA,r+(', '1-3 Tage', NULL, '[[regtime_]]', NULL),
('hA<WrX8X', '/_MpXT|', '1-3 days', NULL, '[[regtime_]]', NULL),
('hA<WrX8תt', 'hA,r+(', '2-5 Tage', NULL, '[[regtime_]]', NULL),
('hA<WrX8תt', '/_MpXT|', '2-5 days', NULL, '[[regtime_]]', NULL),
('hA<WrX8;', 'hA,r+(', '1-2 Wochen', NULL, '[[regtime_]]', NULL),
('hA<WrX8;', '/_MpXT|', '1-2 weeks', NULL, '[[regtime_]]', NULL),
('hA<WrX8+', 'hA,r+(', '3-4 Wochen', NULL, '[[regtime_]]', NULL),
('hA<WrX8+', '/_MpXT|', '3-4 weeks', NULL, '[[regtime_]]', NULL),
('hB`Ps\n9nx	', 'hA,r+(', 'Sofort verfügbar', NULL, '[[regtime_]]', NULL),
('hB`Ps\n9nx	', '/_MpXT|', 'Instant download', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document`
--

CREATE TABLE `document` (
  `id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `referenced_document_id` binary(16) DEFAULT NULL,
  `file_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_id` binary(16) NOT NULL,
  `order_version_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `static` tinyint(1) NOT NULL DEFAULT '0',
  `deep_link_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_media_file_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `document_number` varchar(255) COLLATE utf8mb4_unicode_ci GENERATED ALWAYS AS (json_unquote(json_extract(`config`,_utf8mb4'$.documentNumber'))) STORED,
  `document_a11y_media_file_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.deep_link_code` (`deep_link_code`),
  KEY `fk.document.document_type_id` (`document_type_id`),
  KEY `fk.document.referenced_document_id` (`referenced_document_id`),
  KEY `fk.document.order_id` (`order_id`,`order_version_id`),
  KEY `fk.document.document_media_file_id` (`document_media_file_id`),
  KEY `idx.document.document_number` (`document_number`),
  KEY `fk.document.document_a11y_media_file_id` (`document_a11y_media_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config`
--

CREATE TABLE `document_base_config` (
  `id` binary(16) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename_prefix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `filename_suffix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `document_number` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `global` tinyint(1) DEFAULT '0',
  `document_type_id` binary(16) NOT NULL,
  `logo_id` binary(16) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.document_base_config.type_id` (`document_type_id`),
  KEY `fk.document_base_config.logo_id` (`logo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config`
--

INSERT INTO `document_base_config` VALUES
('hA?pj6t=*', 'cancellation_invoice', 'cancellation_invoice_', '', '', 1, 'hA?p멘AH', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true, "referencedDocumentType": "invoice", "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL),
('hA?pj6tP', 'invoice', 'invoice_', '', '', 1, 'hA-~qߧSMK', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "deliveryCountries": ["019768412de37288a236f67398c21b78", "019768412ed873febdca7c1b192d0e91", "019768412ee572409cb15259dc1d17ce", "0197684137f5705aa6c76c85a99fd57c", "019768413813700ab5975c4d2c650222", "01976841383d7206ac2871993b5593ba", "01976841385a702098ec0e9bd02810e0", "019768413876707db297ff7e70d33c42", "019768413886701b89c617528c7351a8", "019768413894702791ebccdf854f5a04", "0197684138af73bfb5a774dafd2296a9", "019768413aed7293b867d8bf1f44043e", "019768413afc717e814dd06fa1a73efe", "019768413b1b7043a911f168765e4faf", "019768413b2a72c1b244d770e6e3e0a4", "019768413b3870918fde844f72470da9", "019768413b7272f8b6e1dbeca4996c5d", "019768413b847065882521e892de3eaa", "019768413b9b7223847ec4a4787d09fc", "019768413bb472beb27782ad349421b0", "01976841a133730aa463953a9a33268d", "01976841a14f726c9d5b9b34746349ac", "01976841a16a708eb0e4e2b8ff1d3419", "01976841a18473429590dc74ea6b7b4f", "01976841a19d72a086dfd9c94e7dc364", "01976841a1b772349d8dd27ee0b5bbc1", "01976841a1d372df900e6eb7fc561b06", "01976841a1ed7367a904452102deeef7"], "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('hA?pj6u\n#5', 'delivery_note', 'delivery_note_', '', '', 1, 'hA-~qߧSMX', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": false, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('hA?pj6u', 'credit_note', 'credit_note_', '', '', 1, 'hA-~qߧSNe', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true, "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config_sales_channel`
--

CREATE TABLE `document_base_config_sales_channel` (
  `id` binary(16) NOT NULL,
  `document_base_config_id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_base_configuration_id__sales_channel_id` (`document_type_id`,`sales_channel_id`),
  KEY `fk.document_base_config_sales_channel.document_base_config_id` (`document_base_config_id`),
  KEY `fk.document_base_config_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config_sales_channel`
--

INSERT INTO `document_base_config_sales_channel` VALUES
('hA@	pϏ', 'hA?pj6t=*', 'hA?p멘AH', NULL, '[[regtime_]]', NULL),
('hA@s+Bm', 'hA?pj6tP', 'hA-~qߧSMK', NULL, '[[regtime_]]', NULL),
('hA@r-ێB^', 'hA?pj6u\n#5', 'hA-~qߧSMX', NULL, '[[regtime_]]', NULL),
('hA@sv9~ ;', 'hA?pj6u', 'hA-~qߧSNe', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type`
--

CREATE TABLE `document_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type`
--

INSERT INTO `document_type` VALUES
('hA-~qߧSMK', 'invoice', '[[regtime_]]', NULL),
('hA-~qߧSMX', 'delivery_note', '[[regtime_]]', NULL),
('hA-~qߧSNe', 'credit_note', '[[regtime_]]', NULL),
('hA?p멘AH', 'storno', '[[regtime_]]', NULL),
('hBpĖ:<ˠ', 'zugferd_invoice', '[[regtime_]]', NULL),
('hBpĖ:=jN', 'zugferd_embedded_invoice', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type_translation`
--

CREATE TABLE `document_type_translation` (
  `document_type_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`document_type_id`,`language_id`),
  KEY `fk.document_type_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type_translation`
--

INSERT INTO `document_type_translation` VALUES
('hA-~qߧSMK', 'hA,r+(', 'Rechnung', NULL, '[[regtime_]]', NULL),
('hA-~qߧSMK', '/_MpXT|', 'Invoice', NULL, '[[regtime_]]', NULL),
('hA-~qߧSMX', 'hA,r+(', 'Lieferschein', NULL, '[[regtime_]]', NULL),
('hA-~qߧSMX', '/_MpXT|', 'Delivery note', NULL, '[[regtime_]]', NULL),
('hA-~qߧSNe', 'hA,r+(', 'Gutschrift', NULL, '[[regtime_]]', NULL),
('hA-~qߧSNe', '/_MpXT|', 'Credit note', NULL, '[[regtime_]]', NULL),
('hA?p멘AH', 'hA,r+(', 'Stornorechnung', NULL, '[[regtime_]]', NULL),
('hA?p멘AH', '/_MpXT|', 'Cancellation invoice', NULL, '[[regtime_]]', NULL),
('hBpĖ:<ˠ', 'hA,r+(', 'Rechnung: ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('hBpĖ:<ˠ', '/_MpXT|', 'Invoice: ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL),
('hBpĖ:=jN', 'hA,r+(', 'Rechnung: PDF mit eingebetteter ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('hBpĖ:=jN', '/_MpXT|', 'Invoice: PDF with embedded ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow`
--

CREATE TABLE `flow` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `event_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL DEFAULT '1',
  `payload` longblob,
  `invalid` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_flow_event_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.flow.event_name` (`event_name`,`priority`),
  KEY `fk.flow.app_flow_event_id` (`app_flow_event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow`
--

INSERT INTO `flow` VALUES
('hB8pl\roZ7,', 'Order placed', NULL, 'checkout.order.placed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ro[YXz', 'Customer account registered', NULL, 'checkout.customer.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ro[', 'Newsletter sign-up registered', NULL, 'newsletter.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ro]', 'Newsletter sign-up confirmed', NULL, 'newsletter.confirm', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ro]muR', 'User recovery request sent', NULL, 'user.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ro^^', 'Contact form sent', NULL, 'contact_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ro_?\\', 'Customer requests new password', NULL, 'customer.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ro`[', 'Customer account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_registration', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roa', 'Guest account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_guest_order', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roa', 'Customer group registration request accepted', NULL, 'customer.group.registration.accepted', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roa\Z', 'Customer group registration request declined', NULL, 'customer.group.registration.declined', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\rob:', 'Shipment enters status partially returned', NULL, 'state_enter.order_delivery.state.returned_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\rodp$', 'Shipment enters status partially shipped', NULL, 'state_enter.order_delivery.state.shipped_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roeϊ?', 'Shipment enters status returned', NULL, 'state_enter.order_delivery.state.returned', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\rog7~', 'Shipment enters status shipped', NULL, 'state_enter.order_delivery.state.shipped', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roh3~|', 'Shipment enters status cancelled', NULL, 'state_enter.order_delivery.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roh', 'Payment enters status reminder sent', NULL, 'state_enter.order_transaction.state.reminded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roi', 'Payment enters status partially refunded', NULL, 'state_enter.order_transaction.state.refunded_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roj', 'Payment enters status cancelled', NULL, 'state_enter.order_transaction.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\rok(c', 'Payment enters status paid', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\rolj', 'Payment enters status refunded', NULL, 'state_enter.order_transaction.state.refunded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\rol', 'Payment enters status partially paid', NULL, 'state_enter.order_transaction.state.paid_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\romb', 'Payment enters status open', NULL, 'state_enter.order_transaction.state.open', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\ron	(', 'Order enters status in progress', NULL, 'state_enter.order.state.in_progress', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\rooCo', 'Order enters status cancelled', NULL, 'state_enter.order.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB8pl\roo', 'Order enters status completed', NULL, 'state_enter.order.state.completed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hBg7pz}ߍ', 'Deliver ordered product downloads', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hBu{q*ƝI', 'Review form sent', NULL, 'review_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hBp+', 'Order enters status authorized', NULL, 'state_enter.order_transaction.state.authorized', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hBp@''<lJ', 'Order enters status chargeback', NULL, 'state_enter.order_transaction.state.chargeback', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('hB3qW;a!', 'Order enters status unconfirmed', NULL, 'state_enter.order_transaction.state.unconfirmed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_sequence`
--

CREATE TABLE `flow_sequence` (
  `id` binary(16) NOT NULL,
  `flow_id` binary(16) NOT NULL,
  `app_flow_action_id` binary(16) DEFAULT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `rule_id` binary(16) DEFAULT NULL,
  `action_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `display_group` int NOT NULL DEFAULT '1',
  `true_case` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.flow_sequence.flow_id` (`flow_id`),
  KEY `fk.flow_sequence.rule_id` (`rule_id`),
  KEY `fk.flow_sequence.parent_id` (`parent_id`),
  KEY `fk.flow_sequence.app_flow_action_id` (`app_flow_action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_sequence`
--

INSERT INTO `flow_sequence` VALUES
('hB8pl\roZν', 'hB8pl\roZ7,', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684140af712d838cde98c52269a6", "mailTemplateTypeId": "01976841d4ff73db875949ad95275e23"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ro[', 'hB8pl\ro[YXz', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684140c9715f93061c634d6fb69c", "mailTemplateTypeId": "01976841d50473f9adbd7db9df0ed0a2"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ro\\(+?', 'hB8pl\ro[', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768413fb67028a6051cdd9e03cede", "mailTemplateTypeId": "01976841d50d700698c50144e4965072"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ro]', 'hB8pl\ro]', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768413fb67028a6051cdd9e26382c", "mailTemplateTypeId": "01976841d51370a98c73be4f68f49fb0"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ro]', 'hB8pl\ro]muR', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684151bd72f68f96c3d488a5fbe6", "mailTemplateTypeId": "01976841d519712cb5c1648a3d3f1f4e"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ro_>5', 'hB8pl\ro^^', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768415f29708489ef2b410594787c", "mailTemplateTypeId": "01976841d52272fa991dc300195fa1f3"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ro_]IE', 'hB8pl\ro_?\\', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684165b9734383019303a50edcb0", "mailTemplateTypeId": "01976841d527735da4518dc01996d3d8"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\roa', 'hB8pl\ro`[', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684170e6733883ab4f36827cec2e", "mailTemplateTypeId": "01976841d531719db8cc61c6db6c6e41"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\roa6=', 'hB8pl\roa', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684171a37175a0f14d94a3d00cf0", "mailTemplateTypeId": "01976841d53570739c608fc3d2b38980"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\roa', 'hB8pl\roa', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01976841cbcc7388a9cbc7221e1fbfbe", "mailTemplateTypeId": "01976841d53a712c8d56f71b85cc6af0"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rob\r', 'hB8pl\roa\Z', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01976841cbff72509e9765603dfaf014", "mailTemplateTypeId": "01976841d53f7183802568302aa8638c"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\roc', 'hB8pl\rob:', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416ac97281a2103aed64d214ce", "mailTemplateTypeId": "01976841d546723e8cbf4fa7317aebed"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rod', 'hB8pl\rodp$', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416a9d725ea0362a2054ff66a8", "mailTemplateTypeId": "01976841d54e7114af90042cce655225"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rof_\n', 'hB8pl\roeϊ?', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416af07224bfab1618c727d281", "mailTemplateTypeId": "01976841d553712fa48114210c6c5249"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rog', 'hB8pl\rog7~', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b3673708e9f2ff3798be727", "mailTemplateTypeId": "01976841d558714fa83e78f000073f30"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rohmά', 'hB8pl\roh3~|', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b1571ce9b8250671ed0c4cf", "mailTemplateTypeId": "01976841d55f704f9b6c091d78146e9b"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rohз', 'hB8pl\roh', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416bda7123b98361a25d61f9bc", "mailTemplateTypeId": "01976841d5647195aebb1d43f30cc1b6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\roi', 'hB8pl\roi', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416bc7733d80f2b687b07a2bbb", "mailTemplateTypeId": "01976841d56970f0a13e4584991312d7"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\roj', 'hB8pl\roj', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c23703e98689fda4a7869de", "mailTemplateTypeId": "01976841d56f72f8beec8018dfa40dae"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rol ', 'hB8pl\rok(c', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c0571a2903c2b60e10b26b3", "mailTemplateTypeId": "01976841d57472c1bc0066fe21464b4a"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\rol', 'hB8pl\rolj', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c377017bbfb3d7727be0995", "mailTemplateTypeId": "01976841d57b711ba6d9bcf959e4c87e"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\romVC', 'hB8pl\rol', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c4c70b49a438ed0dc37d48d", "mailTemplateTypeId": "01976841d5807280b4fde3aae4362d35"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ron', 'hB8pl\romb', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416bed725bb48304d82ab03005", "mailTemplateTypeId": "01976841d58570d588e4f8a41e19887b"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ron)', 'hB8pl\ron	(', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b777083a881333b4b3063a6", "mailTemplateTypeId": "01976841d58a71b0b069edba31a64c45"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\roo\n', 'hB8pl\rooCo', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416ba8732d91b29f192c86efdc", "mailTemplateTypeId": "01976841d58f731c949f12dfb5e009b6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB8pl\ropSm', 'hB8pl\roo', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b8f71f1a45ee29d037414a6", "mailTemplateTypeId": "01976841d59473c6ad400d62f27f7c38"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hBg;q*t', 'hBg7pz}ߍ', NULL, NULL, 'hBgqAFeس', NULL, '[]', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hBgApV]T', 'hBg7pz}ߍ', NULL, 'hBg;q*t', NULL, 'action.grant.download.access', '{"value": true}', 1, 1, 1, NULL, '[[regtime_]]', NULL),
('hBgFq=[#\Z', 'hBg7pz}ߍ', NULL, 'hBg;q*t', NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01976842635c731b8112247973990c8f", "documentTypeIds": []}', 2, 1, 1, NULL, '[[regtime_]]', NULL),
('hBup7,-', 'hBu{q*ƝI', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "admin"}, "mailTemplateId": "01976842754e73c0b29bb872b7bd982a", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hBrրMt', 'hBp+', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768428e3373adb79fed409d8b58d1", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB%s˴p9', 'hBp@''<lJ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768428e6e731d977363057afc20b8", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('hB7sԥy\Z)', 'hB3qW;a!', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768428ea870f6922b171ff6d3c1aa", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_template`
--

CREATE TABLE `flow_template` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_template`
--

INSERT INTO `flow_template` VALUES
('hBg\nqݚ', 'Contact form sent', '{"eventName": "contact_form.send", "sequences": [{"id": "01976842670a71868605f0ea8cf128b6", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768415f29708489ef2b410594787c", "mailTemplateTypeId": "01976841567f70ee9f015c033a41b10b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBg\nqꍽX', 'Newsletter sign-up registered', '{"eventName": "newsletter.register", "sequences": [{"id": "01976842670a71868605f0ea8e0e58b1", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768413fb67028a6051cdd9e26382c", "mailTemplateTypeId": "019768413e0c726287c3f21f2b22fcee"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBg\nqZs?', 'User recovery request sent', '{"eventName": "user.recovery.request", "sequences": [{"id": "01976842670b73d5a5d7d3cdbf1f8358", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684151bd72f68f96c3d488a5fbe6", "mailTemplateTypeId": "0197684151ae7187960ba136807a5db0"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեCK', 'Guest account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_guest_order", "sequences": [{"id": "01976842670b73d5a5d7d3cdc06dcd02", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684171a37175a0f14d94a3d00cf0", "mailTemplateTypeId": "0197684171a37175a0f14d94a492677d"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsե6', 'Customer account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_registration", "sequences": [{"id": "01976842670b73d5a5d7d3cdc18ff913", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684170e6733883ab4f36827cec2e", "mailTemplateTypeId": "0197684170e6733883ab4f368338ae94"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեT', 'Order placed', '{"eventName": "checkout.order.placed", "sequences": [{"id": "01976842670b73d5a5d7d3cdc1ff8ba8", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684140af712d838cde98c52269a6", "mailTemplateTypeId": "019768413e0c726287c3f21f2b563843"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեT', 'Customer group registration request declined', '{"eventName": "customer.group.registration.declined", "sequences": [{"id": "01976842670b73d5a5d7d3cdc352db89", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01976841cbff72509e9765603dfaf014", "mailTemplateTypeId": "01976841cbf1724a91825252a8c5d50b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեï', 'Customer group registration request accepted', '{"eventName": "customer.group.registration.accepted", "sequences": [{"id": "01976842670b73d5a5d7d3cdc405dabd", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01976841cbcc7388a9cbc7221e1fbfbe", "mailTemplateTypeId": "01976841cbbb72fa8b238bf08a85c14e"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsե,3}', 'Newsletter sign-up confirmed', '{"eventName": "newsletter.confirm", "sequences": [{"id": "01976842670b73d5a5d7d3cdc42e46c7", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768413fb67028a6051cdd9e26382c", "mailTemplateTypeId": "019768413e0c726287c3f21f2b22fcee"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեA', 'Customer requests new password', '{"eventName": "customer.recovery.request", "sequences": [{"id": "01976842670b73d5a5d7d3cdc4f6e18b", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684165b9734383019303a50edcb0", "mailTemplateTypeId": "0197684165a6703fa96911ef794da24d"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեŹM', 'Customer account registered', '{"eventName": "checkout.customer.register", "sequences": [{"id": "01976842670b73d5a5d7d3cdc6a5ad49", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0197684140c9715f93061c634d6fb69c", "mailTemplateTypeId": "019768413e0c726287c3f21f29e24769"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեpz', 'Payment enters status partially paid', '{"eventName": "state_enter.order_transaction.state.paid_partially", "sequences": [{"id": "01976842670b73d5a5d7d3cdc7b39fd4", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c4c70b49a438ed0dc37d48d", "mailTemplateTypeId": "019768413e0c726287c3f21f32ee099b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեȎ', 'Shipment enters status returned', '{"eventName": "state_enter.order_delivery.state.returned", "sequences": [{"id": "01976842670b73d5a5d7d3cdc938dc2c", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416af07224bfab1618c727d281", "mailTemplateTypeId": "019768413e0c726287c3f21f2eacf5a3"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեn', 'Shipment enters status partially returned', '{"eventName": "state_enter.order_delivery.state.returned_partially", "sequences": [{"id": "01976842670b73d5a5d7d3cdc9d7afa6", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416ac97281a2103aed64d214ce", "mailTemplateTypeId": "019768413e0c726287c3f21f2dfe9d6b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեj	', 'Payment enters status refunded', '{"eventName": "state_enter.order_transaction.state.refunded", "sequences": [{"id": "01976842670b73d5a5d7d3cdca78532d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c377017bbfb3d7727be0995", "mailTemplateTypeId": "019768413e0c726287c3f21f3288300f"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեIy', 'Payment enters status paid', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "01976842670b73d5a5d7d3cdcb4b128d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c0571a2903c2b60e10b26b3", "mailTemplateTypeId": "019768413e0c726287c3f21f323ee2ee"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեS', 'Order enters status in progress', '{"eventName": "state_enter.order.state.in_progress", "sequences": [{"id": "01976842670b73d5a5d7d3cdcc08ca69", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b777083a881333b4b3063a6", "mailTemplateTypeId": "019768413e0c726287c3f21f33bb4ec0"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsե`4', 'Payment enters status partially refunded', '{"eventName": "state_enter.order_transaction.state.refunded_partially", "sequences": [{"id": "01976842670b73d5a5d7d3cdcc172243", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416bc7733d80f2b687b07a2bbb", "mailTemplateTypeId": "019768413e0c726287c3f21f313859f1"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեN', 'Payment enters status open', '{"eventName": "state_enter.order_transaction.state.open", "sequences": [{"id": "01976842670b73d5a5d7d3cdcded8fd8", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416bed725bb48304d82ab03005", "mailTemplateTypeId": "019768413e0c726287c3f21f3325fbcc"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեz', 'Shipment enters status shipped', '{"eventName": "state_enter.order_delivery.state.shipped", "sequences": [{"id": "01976842670b73d5a5d7d3cdcfa4f801", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b3673708e9f2ff3798be727", "mailTemplateTypeId": "019768413e0c726287c3f21f2fa4c89a"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsե6-', 'Shipment enters status partially shipped', '{"eventName": "state_enter.order_delivery.state.shipped_partially", "sequences": [{"id": "01976842670b73d5a5d7d3cdd0f04c2e", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416a9d725ea0362a2054ff66a8", "mailTemplateTypeId": "019768413e0c726287c3f21f2e5b832a"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեQy', 'Shipment enters status cancelled', '{"eventName": "state_enter.order_delivery.state.cancelled", "sequences": [{"id": "01976842670b73d5a5d7d3cdd21da753", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b1571ce9b8250671ed0c4cf", "mailTemplateTypeId": "019768413e0c726287c3f21f3053fe2b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsե҄', 'Payment enters status cancelled', '{"eventName": "state_enter.order_transaction.state.cancelled", "sequences": [{"id": "01976842670b73d5a5d7d3cdd2ae401a", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416c23703e98689fda4a7869de", "mailTemplateTypeId": "019768413e0c726287c3f21f31e940a1"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեC^', 'Order enters status cancelled', '{"eventName": "state_enter.order.state.cancelled", "sequences": [{"id": "01976842670b73d5a5d7d3cdd3de6693", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416ba8732d91b29f192c86efdc", "mailTemplateTypeId": "019768413e0c726287c3f21f343396fe"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsեԫ*', 'Payment enters status reminder sent', '{"eventName": "state_enter.order_transaction.state.reminded", "sequences": [{"id": "01976842670b73d5a5d7d3cdd4ef976c", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416bda7123b98361a25d61f9bc", "mailTemplateTypeId": "019768413e0c726287c3f21f30e8f752"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgsե	c', 'Order enters status completed', '{"eventName": "state_enter.order.state.completed", "sequences": [{"id": "01976842670b73d5a5d7d3cdd59882b8", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019768416b8f71f1a45ee29d037414a6", "mailTemplateTypeId": "019768413e0c726287c3f21f34425f68"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hBgPq[zca', 'Deliver ordered product downloads', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "01976842862a721faddcb60f79220b70", "config": [], "ruleId": "01976842671f7141b1084665d8b380c0", "parentId": null, "position": 1, "trueCase": 0, "actionName": null, "displayGroup": 1}, {"id": "01976842862a721faddcb60f79eee980", "config": {"value": true}, "ruleId": null, "parentId": "01976842862a721faddcb60f79220b70", "position": 1, "trueCase": 1, "actionName": "action.grant.download.access", "displayGroup": 1}, {"id": "01976842862a721faddcb60f79fd5a4b", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01976842635c731b8112247973990c8f", "documentTypeIds": [], "mailTemplateTypeId": "01976842634773afaff4ad9d1ddca8b3"}, "ruleId": null, "parentId": "01976842862a721faddcb60f79220b70", "position": 2, "trueCase": 1, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hB\nswE#v', 'Order enters status authorized', '{"eventName": "state_enter.order_transaction.state.authorized", "sequences": [{"id": "01976842980a73778b9c45c12356111c", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019768428e3373adb79fed409d8b58d1\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hB-q:YZP0', 'Order enters status chargeback', '{"eventName": "state_enter.order_transaction.state.chargeback", "sequences": [{"id": "01976842982d713aba595a50c7fb1cab", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019768428e6e731d977363057afc20b8\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('hB=q+7', 'Order enters status unconfirmed', '{"eventName": "state_enter.order_transaction.state.unconfirmed", "sequences": [{"id": "01976842983d71898614b6f7e6ca5a7f", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019768428ea870f6922b171ff6d3c1aa\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `import_export_file`
--

CREATE TABLE `import_export_file` (
  `id` binary(16) NOT NULL,
  `original_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire_date` datetime(3) NOT NULL,
  `size` int DEFAULT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `access_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_log`
--

CREATE TABLE `import_export_log` (
  `id` binary(16) NOT NULL,
  `activity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `records` int NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` binary(16) DEFAULT NULL,
  `profile_id` binary(16) DEFAULT NULL,
  `file_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `result` json DEFAULT NULL,
  `invalid_records_log_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.import_export_log.user_id` (`user_id`),
  KEY `fk.import_export_log.profile_id` (`profile_id`),
  KEY `fk.import_export_log.invalid_records_log_id` (`invalid_records_log_id`),
  KEY `fk.import_export_log.file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile`
--

CREATE TABLE `import_export_profile` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `source_entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delimiter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enclosure` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'import-export',
  `mapping` longtext COLLATE utf8mb4_unicode_ci,
  `update_by` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.import_export_profile.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile`
--

INSERT INTO `import_export_profile` VALUES
('hAssSq', 'Default category', 1, 'category', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"active","mappedKey":"active","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"visible","mappedKey":"visible","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.externalLink","mappedKey":"external_link","position":6},{"key":"translations.DEFAULT.description","mappedKey":"description","position":7},{"key":"translations.DEFAULT.metaTitle","mappedKey":"meta_title","position":8},{"key":"translations.DEFAULT.metaDescription","mappedKey":"meta_description","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15},{"key":"cmsPageId","mappedKey":"cms_page_id","position":16}]', NULL, '[[regtime_]]', NULL, NULL, 'default_category'),
('hAs[?GCkd', 'Default media', 1, 'media', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"mediaFolderId","mappedKey":"folder_id","position":1},{"key":"url","mappedKey":"url","position":2},{"key":"private","mappedKey":"private","position":3},{"key":"mediaType","mappedKey":"type","position":4},{"key":"translations.DEFAULT.title","mappedKey":"title","position":5},{"key":"translations.DEFAULT.alt","mappedKey":"alt","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_media'),
('hArňd).', 'Default product', 1, 'product', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"productNumber","mappedKey":"product_number","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"stock","mappedKey":"stock","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.description","mappedKey":"description","position":6},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":7},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":8},{"key":"purchasePrices.DEFAULT.net","mappedKey":"purchase_prices_net","position":9},{"key":"purchasePrices.DEFAULT.gross","mappedKey":"purchase_prices_gross","position":10},{"key":"tax.id","mappedKey":"tax_id","position":11},{"key":"tax.taxRate","mappedKey":"tax_rate","position":12},{"key":"tax.name","mappedKey":"tax_name","position":13},{"key":"cover.media.id","mappedKey":"cover_media_id","position":14},{"key":"cover.media.url","mappedKey":"cover_media_url","position":15},{"key":"cover.media.translations.DEFAULT.title","mappedKey":"cover_media_title","position":16},{"key":"cover.media.translations.DEFAULT.alt","mappedKey":"cover_media_alt","position":17},{"key":"manufacturer.id","mappedKey":"manufacturer_id","position":18},{"key":"manufacturer.translations.DEFAULT.name","mappedKey":"manufacturer_name","position":19},{"key":"categories","mappedKey":"categories","position":20},{"key":"visibilities.all","mappedKey":"sales_channel","position":21},{"key":"properties","mappedKey":"propertyIds","position":22},{"key":"options","mappedKey":"optionIds","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_product'),
('hAs\nuQH\\', 'Default newsletter recipient', 1, 'newsletter_recipient', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"email","mappedKey":"email","position":1},{"key":"title","mappedKey":"title","position":2},{"key":"salutation.salutationKey","mappedKey":"salutation","position":3},{"key":"firstName","mappedKey":"first_name","position":4},{"key":"lastName","mappedKey":"last_name","position":5},{"key":"zipCode","mappedKey":"zip_code","position":6},{"key":"city","mappedKey":"city","position":7},{"key":"street","mappedKey":"street","position":8},{"key":"status","mappedKey":"status","position":9},{"key":"hash","mappedKey":"hash","position":10},{"key":"salesChannel.id","mappedKey":"sales_channel_id","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_newsletter_recipient'),
('hAq҆Q', 'Default variant configuration settings', 1, 'product_configurator_setting', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"optionId","mappedKey":"option_id","position":2},{"key":"position","mappedKey":"position","position":3},{"key":"media.id","mappedKey":"media_id","position":4},{"key":"media.url","mappedKey":"media_url","position":5},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":6},{"key":"media.mediaType","mappedKey":"media_type","position":7},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":8},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":9},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":10},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_variant_configuration_settings'),
('hAsΉSJz', 'Default properties', 1, 'property_group_option', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"colorHexCode","mappedKey":"color_hex_code","position":1},{"key":"translations.DEFAULT.name","mappedKey":"name","position":2},{"key":"translations.DEFAULT.position","mappedKey":"position","position":3},{"key":"group.id","mappedKey":"group_id","position":4},{"key":"group.displayType","mappedKey":"group_display_type","position":5},{"key":"group.sortingType","mappedKey":"group_sorting_type","position":6},{"key":"group.translations.DEFAULT.name","mappedKey":"group_name","position":7},{"key":"group.translations.DEFAULT.description","mappedKey":"group_description","position":8},{"key":"group.translations.DEFAULT.position","mappedKey":"group_position","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15}]', NULL, '[[regtime_]]', NULL, NULL, 'default_properties'),
('hB0rK\r5', 'Default cross-selling', 1, 'product_cross_selling', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"translations.DEFAULT.name","mappedKey":"name","position":1},{"key":"productId","mappedKey":"product_id","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"position","mappedKey":"position","position":4},{"key":"limit","mappedKey":"limit","position":5},{"key":"type","mappedKey":"type","position":6},{"key":"sortBy","mappedKey":"sort_by","position":7},{"key":"sortDirection","mappedKey":"sort_direction","position":8},{"key":"assignedProducts","mappedKey":"assigned_products","position":9}]', NULL, '[[regtime_]]', NULL, NULL, 'default_cross_selling'),
('hB1\ZqJk', 'Default customer', 1, 'customer', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"salutation.salutationKey","mappedKey":"salutation","position":1},{"key":"customerNumber","mappedKey":"customer_number","position":2},{"key":"firstName","mappedKey":"first_name","position":3},{"key":"lastName","mappedKey":"last_name","position":4},{"key":"email","mappedKey":"email","position":5},{"key":"active","mappedKey":"active","position":6},{"key":"guest","mappedKey":"guest","position":7},{"key":"group.translations.DEFAULT.name","mappedKey":"customer_group","position":8},{"key":"language.locale.code","mappedKey":"language","position":9},{"key":"salesChannel.translations.DEFAULT.name","mappedKey":"sales_channel","position":10},{"key":"defaultPaymentMethod.translations.DEFAULT.name","mappedKey":"payment_method","position":11},{"key":"defaultBillingAddress.id","mappedKey":"billing_id","position":12},{"key":"defaultBillingAddress.salutation.salutationKey","mappedKey":"billing_salutation","position":13},{"key":"defaultBillingAddress.title","mappedKey":"billing_title","position":14},{"key":"defaultBillingAddress.firstName","mappedKey":"billing_first_name","position":15},{"key":"defaultBillingAddress.lastName","mappedKey":"billing_last_name","position":16},{"key":"defaultBillingAddress.company","mappedKey":"billing_company","position":17},{"key":"defaultBillingAddress.street","mappedKey":"billing_street","position":18},{"key":"defaultBillingAddress.zipcode","mappedKey":"billing_zipcode","position":19},{"key":"defaultBillingAddress.city","mappedKey":"billing_city","position":20},{"key":"defaultBillingAddress.country.iso","mappedKey":"billing_country","position":21},{"key":"defaultBillingAddress.phoneNumber","mappedKey":"billing_phone_number","position":22},{"key":"defaultShippingAddress.id","mappedKey":"shipping_id","position":23},{"key":"defaultShippingAddress.salutation.salutationKey","mappedKey":"shipping_salutation","position":24},{"key":"defaultShippingAddress.title","mappedKey":"shipping_title","position":25},{"key":"defaultShippingAddress.firstName","mappedKey":"shipping_first_name","position":26},{"key":"defaultShippingAddress.lastName","mappedKey":"shipping_last_name","position":27},{"key":"defaultShippingAddress.company","mappedKey":"shipping_company","position":28},{"key":"defaultShippingAddress.street","mappedKey":"shipping_street","position":29},{"key":"defaultShippingAddress.zipcode","mappedKey":"shipping_zipcode","position":30},{"key":"defaultShippingAddress.city","mappedKey":"shipping_city","position":31},{"key":"defaultShippingAddress.country.iso","mappedKey":"shipping_country","position":32},{"key":"defaultShippingAddress.phoneNumber","mappedKey":"shipping_phone_number","position":33},{"key":"accountType","mappedKey":"account_type"}]', NULL, '[[regtime_]]', NULL, NULL, 'default_customer'),
('hB3\0ph<{"', 'Default promotion codes', 1, 'promotion_individual_code', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"code","mappedKey":"code","position":2}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_codes'),
('hB32qΠ', 'Default orders', 1, 'order', 'text/csv', ';', '"', 'export', '[{"key":"id","mappedKey":"id","position":0},{"key":"orderNumber","mappedKey":"order_number","position":1},{"key":"salesChannelId","mappedKey":"sales_channel_id","position":2},{"key":"orderCustomer.firstName","mappedKey":"customer_firstname","position":3},{"key":"orderCustomer.lastName","mappedKey":"customer_lastname","position":4},{"key":"orderCustomer.email","mappedKey":"customer_email","position":5},{"key":"billingAddress.street","mappedKey":"billing_address_street","position":6},{"key":"billingAddress.zipcode","mappedKey":"billing_address_zipcode","position":7},{"key":"billingAddress.city","mappedKey":"billing_address_city","position":8},{"key":"billingAddress.company","mappedKey":"billing_address_company","position":9},{"key":"billingAddress.department","mappedKey":"billing_address_department","position":10},{"key":"billingAddress.countryId","mappedKey":"billing_address_country_id","position":11},{"key":"billingAddress.countryStateId","mappedKey":"billing_address_country_state_id","position":12},{"key":"deliveries.shippingOrderAddress.street","mappedKey":"shipping_address_street","position":13},{"key":"deliveries.shippingOrderAddress.zipcode","mappedKey":"shipping_address_zipcode","position":14},{"key":"deliveries.shippingOrderAddress.city","mappedKey":"shipping_address_city","position":15},{"key":"deliveries.shippingOrderAddress.company","mappedKey":"shipping_address_company","position":16},{"key":"deliveries.shippingOrderAddress.department","mappedKey":"shipping_address_department","position":17},{"key":"deliveries.shippingOrderAddress.countryId","mappedKey":"shipping_address_country_id","position":18},{"key":"deliveries.shippingOrderAddress.countryStateId","mappedKey":"shipping_address_country_state_id","position":19},{"key":"amountTotal","mappedKey":"amount_total","position":20},{"key":"stateId","mappedKey":"order_state_id","position":21},{"key":"lineItems","mappedKey":"line_items","position":22},{"key":"orderDateTime","mappedKey":"order_date_time","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_orders'),
('hB<-pDLV@o', 'Default advanced prices', 1, 'product_price', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"ruleId","mappedKey":"rule_id","position":2},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":3},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":4},{"key":"quantityStart","mappedKey":"quantity_start","position":5},{"key":"quantityEnd","mappedKey":"quantity_end","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_advanced_prices'),
('hB<Mr͢Y绩', 'Default promotion discounts', 1, 'promotion_discount', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"scope","mappedKey":"scope","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"value","mappedKey":"value","position":4},{"key":"considerAdvancedRules","mappedKey":"consider_advanced_rules","position":5},{"key":"maxValue","mappedKey":"max_value","position":6},{"key":"sorterKey","mappedKey":"sorter_key","position":7,"useDefaultValue":true,"defaultValue":"PRICE_ASC"},{"key":"applierKey","mappedKey":"applier_key","position":8,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"usageKey","mappedKey":"usage_key","position":9,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"pickerKey","mappedKey":"picker_key","position":10},{"key":"discountRules","mappedKey":"discount_rules","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_discounts');

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile_translation`
--

CREATE TABLE `import_export_profile_translation` (
  `import_export_profile_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`import_export_profile_id`,`language_id`),
  KEY `fk.import_export_profile_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile_translation`
--

INSERT INTO `import_export_profile_translation` VALUES
('hAssSq', 'hA,r+(', 'Standardprofil Kategorie', '[[regtime_]]', NULL),
('hAssSq', '/_MpXT|', 'Default category', '[[regtime_]]', NULL),
('hAs[?GCkd', 'hA,r+(', 'Standardprofil Medien', '[[regtime_]]', NULL),
('hAs[?GCkd', '/_MpXT|', 'Default media', '[[regtime_]]', NULL),
('hArňd).', 'hA,r+(', 'Standardprofil Produkt', '[[regtime_]]', NULL),
('hArňd).', '/_MpXT|', 'Default product', '[[regtime_]]', NULL),
('hAs\nuQH\\', 'hA,r+(', 'Standardprofil Newsletter-Empfänger', '[[regtime_]]', NULL),
('hAs\nuQH\\', '/_MpXT|', 'Default newsletter recipient', '[[regtime_]]', NULL),
('hAq҆Q', 'hA,r+(', 'Standardprofil Variantenkonfiguration', '[[regtime_]]', NULL),
('hAq҆Q', '/_MpXT|', 'Default variant configuration settings', '[[regtime_]]', NULL),
('hAsΉSJz', 'hA,r+(', 'Standardprofil Eigenschaften', '[[regtime_]]', NULL),
('hAsΉSJz', '/_MpXT|', 'Default properties', '[[regtime_]]', NULL),
('hB0rK\r5', 'hA,r+(', 'Standardprofil Cross-Selling', '[[regtime_]]', NULL),
('hB0rK\r5', '/_MpXT|', 'Default cross-selling', '[[regtime_]]', NULL),
('hB1\ZqJk', 'hA,r+(', 'Standardprofil Kunde', '[[regtime_]]', NULL),
('hB1\ZqJk', '/_MpXT|', 'Default customer', '[[regtime_]]', NULL),
('hB3\0ph<{"', 'hA,r+(', 'Standardprofil Aktionscodes', '[[regtime_]]', NULL),
('hB3\0ph<{"', '/_MpXT|', 'Default promotion codes', '[[regtime_]]', NULL),
('hB32qΠ', 'hA,r+(', 'Standardprofil Bestellungen', '[[regtime_]]', NULL),
('hB32qΠ', '/_MpXT|', 'Default orders', '[[regtime_]]', NULL),
('hB<-pDLV@o', 'hA,r+(', 'Standardprofil Erweiterte Preise', '[[regtime_]]', NULL),
('hB<-pDLV@o', '/_MpXT|', 'Default advanced prices', '[[regtime_]]', NULL),
('hB<Mr͢Y绩', 'hA,r+(', 'Standardprofil Aktionsrabatte', '[[regtime_]]', NULL),
('hB<Mr͢Y绩', '/_MpXT|', 'Default promotion discounts', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `increment`
--

CREATE TABLE `increment` (
  `pool` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cluster` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`pool`,`cluster`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration`
--

CREATE TABLE `integration` (
  `id` binary(16) NOT NULL,
  `access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret_access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '1',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `last_usage_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.access_key` (`access_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration_role`
--

CREATE TABLE `integration_role` (
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  PRIMARY KEY (`integration_id`,`acl_role_id`),
  KEY `fk.integration_acl_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invalidation_tags`
--

CREATE TABLE `invalidation_tags` (
  `id` binary(16) NOT NULL,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page`
--

CREATE TABLE `landing_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.landing_page.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_sales_channel`
--

CREATE TABLE `landing_page_sales_channel` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`sales_channel_id`),
  KEY `fk.landing_page_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_tag`
--

CREATE TABLE `landing_page_tag` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`tag_id`),
  KEY `fk.landing_page_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_translation`
--

CREATE TABLE `landing_page_translation` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`language_id`),
  KEY `fk.landing_page_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `id` binary(16) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `locale_id` binary(16) NOT NULL,
  `translation_code_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.language.translation_code_id` (`translation_code_id`),
  KEY `idx.language.language_id_parent_language_id` (`id`,`parent_id`),
  KEY `fk.language.parent_id` (`parent_id`),
  KEY `fk.language.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `language`
--

INSERT INTO `language` VALUES
('hA,r+(', 'Deutsch', NULL, 'hA,r+T', 'hA,r+T', NULL, '[[regtime_]]', NULL),
('/_MpXT|', 'English', NULL, 'hA,r+G', 'hA,r+G', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `locale`
--

CREATE TABLE `locale` (
  `id` binary(16) NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale`
--

INSERT INTO `locale` VALUES
('hA,r+G', 'en-GB', '[[regtime_]]', NULL),
('hA,r+T', 'de-DE', '[[regtime_]]', NULL),
('hA-%rP', 'aa-DJ', '[[regtime_]]', NULL),
('hA-%r?', 'aa-ER', '[[regtime_]]', NULL),
('hA-%r}s', 'aa-ET', '[[regtime_]]', NULL),
('hA-%r', 'af-NA', '[[regtime_]]', NULL),
('hA-%r\rF', 'af-ZA', '[[regtime_]]', NULL),
('hA-%r؝', 'ak-GH', '[[regtime_]]', NULL),
('hA-%r<V', 'am-ET', '[[regtime_]]', NULL),
('hA-%rپL', 'ar-AE', '[[regtime_]]', NULL),
('hA-%rڃn', 'ar-BH', '[[regtime_]]', NULL),
('hA-%rA', 'ar-DZ', '[[regtime_]]', NULL),
('hA-%r[', 'ar-EG', '[[regtime_]]', NULL),
('hA-%r4', 'ar-IQ', '[[regtime_]]', NULL),
('hA-%r', 'ar-JO', '[[regtime_]]', NULL),
('hA-%r8', 'ar-KW', '[[regtime_]]', NULL),
('hA-%r2=', 'ar-LB', '[[regtime_]]', NULL),
('hA-%rW', 'ar-LY', '[[regtime_]]', NULL),
('hA-%r', 'ar-MA', '[[regtime_]]', NULL),
('hA-%r{', 'ar-OM', '[[regtime_]]', NULL),
('hA-%rVW', 'ar-QA', '[[regtime_]]', NULL),
('hA-%rߞP''', 'ar-SA', '[[regtime_]]', NULL),
('hA-%rT', 'ar-SD', '[[regtime_]]', NULL),
('hA-%r', 'ar-SY', '[[regtime_]]', NULL),
('hA-%rᡬ7', 'ar-TN', '[[regtime_]]', NULL),
('hA-%r', 'ar-YE', '[[regtime_]]', NULL),
('hA-%r✂', 'as-IN', '[[regtime_]]', NULL),
('hA-%rZ', 'az-AZ', '[[regtime_]]', NULL),
('hA-%r	', 'be-BY', '[[regtime_]]', NULL),
('hA-%rp', 'bg-BG', '[[regtime_]]', NULL),
('hA-%r%', 'bn-BD', '[[regtime_]]', NULL),
('hA-%r(', 'bn-IN', '[[regtime_]]', NULL),
('hA-%r', 'bo-CN', '[[regtime_]]', NULL),
('hA-%rٖ', 'bo-IN', '[[regtime_]]', NULL),
('hA-%rQ|k', 'bs-BA', '[[regtime_]]', NULL),
('hA-%rnr', 'byn-ER', '[[regtime_]]', NULL),
('hA-%r', 'ca-ES', '[[regtime_]]', NULL),
('hA-%r8:', 'cch-NG', '[[regtime_]]', NULL),
('hA-%r', 'cs-CZ', '[[regtime_]]', NULL),
('hA-%r&1', 'cy-GB', '[[regtime_]]', NULL),
('hA-%r+8*', 'da-DK', '[[regtime_]]', NULL),
('hA-%r鳵t', 'de-AT', '[[regtime_]]', NULL),
('hA-%rӇ', 'de-BE', '[[regtime_]]', NULL),
('hA-%r', 'de-CH', '[[regtime_]]', NULL),
('hA-%r"]', 'de-LI', '[[regtime_]]', NULL),
('hA-%r\0%', 'de-LU', '[[regtime_]]', NULL),
('hA-%r3', 'dv-MV', '[[regtime_]]', NULL),
('hA-%rl', 'dz-BT', '[[regtime_]]', NULL),
('hA-%r w', 'ee-GH', '[[regtime_]]', NULL),
('hA-%rz', 'ee-TG', '[[regtime_]]', NULL),
('hA-%r 2', 'el-CY', '[[regtime_]]', NULL),
('hA-&r֗ڣ6sw', 'el-GR', '[[regtime_]]', NULL),
('hA-&r֗ڣ6B', 'en-AS', '[[regtime_]]', NULL),
('hA-&r֗ڣ6&', 'en-AU', '[[regtime_]]', NULL),
('hA-&r֗ڣ6{', 'en-BE', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'en-BW', '[[regtime_]]', NULL),
('hA-&r֗ڣ6W', 'en-BZ', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'en-CA', '[[regtime_]]', NULL),
('hA-&r֗ڣ6?R', 'en-GU', '[[regtime_]]', NULL),
('hA-&r֗ڣ6\Z|', 'en-HK', '[[regtime_]]', NULL),
('hA-&r֗ڣ6;5', 'en-IE', '[[regtime_]]', NULL),
('hA-&r֗ڣ61', 'en-IN', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'en-JM', '[[regtime_]]', NULL),
('hA-&r֗ڣ6,!@', 'en-MH', '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', 'en-MP', '[[regtime_]]', NULL),
('hA-&r֗ڣ6`m<', 'en-MT', '[[regtime_]]', NULL),
('hA-&r֗ڣ6]S', 'en-NA', '[[regtime_]]', NULL),
('hA-&r֗ڣ6lV', 'en-NZ', '[[regtime_]]', NULL),
('hA-&r֗ڣ6>', 'en-PH', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'en-PK', '[[regtime_]]', NULL),
('hA-&r֗ڣ6\0', 'en-SG', '[[regtime_]]', NULL),
('hA-&r֗ڣ6P', 'en-TT', '[[regtime_]]', NULL),
('hA-&r֗ڣ6U-', 'en-UM', '[[regtime_]]', NULL),
('hA-&r֗ڣ6C', 'en-US', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'en-VI', '[[regtime_]]', NULL),
('hA-&r֗ڣ6L', 'en-ZA', '[[regtime_]]', NULL),
('hA-&r֗ڣ6]', 'en-ZW', '[[regtime_]]', NULL),
('hA-&r֗ڣ6%', 'es-AR', '[[regtime_]]', NULL),
('hA-&r֗ڣ6_|', 'es-BO', '[[regtime_]]', NULL),
('hA-&r֗ڣ6{', 'es-CL', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'es-CO', '[[regtime_]]', NULL),
('hA-&r֗ڣ6\\', 'es-CR', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'es-DO', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'es-EC', '[[regtime_]]', NULL),
('hA-&r֗ڣ6Q`', 'es-ES', '[[regtime_]]', NULL),
('hA-&r֗ڣ6Gmy', 'es-GT', '[[regtime_]]', NULL),
('hA-&r֗ڣ69', 'es-HN', '[[regtime_]]', NULL),
('hA-&r֗ڣ6 ', 'es-MX', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'es-NI', '[[regtime_]]', NULL),
('hA-&r֗ڣ6u9T', 'es-PA', '[[regtime_]]', NULL),
('hA-&r֗ڣ6J', 'es-PE', '[[regtime_]]', NULL),
('hA-&r֗ڣ6|Q', 'es-PR', '[[regtime_]]', NULL),
('hA-&r֗ڣ6El', 'es-PY', '[[regtime_]]', NULL),
('hA-&r֗ڣ6Z', 'es-SV', '[[regtime_]]', NULL),
('hA-&r֗ڣ6!h*', 'es-US', '[[regtime_]]', NULL),
('hA-&r֗ڣ69*', 'es-UY', '[[regtime_]]', NULL),
('hA-&r֗ڣ6)Q', 'es-VE', '[[regtime_]]', NULL),
('hA-&r֗ڣ6|2', 'et-EE', '[[regtime_]]', NULL),
('hA-&r֗ڣ6\Z', 'eu-ES', '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', 'fa-AF', '[[regtime_]]', NULL),
('hA-&r֗ڣ6Dd', 'fa-IR', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'fi-FI', '[[regtime_]]', NULL),
('hA-&r֗ڣ6S', 'fil-PH', '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', 'fo-FO', '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'fr-BE', '[[regtime_]]', NULL),
('hA-&r֗ڣ6\\', 'fr-CA', '[[regtime_]]', NULL),
('hA-''qGe', 'fr-CH', '[[regtime_]]', NULL),
('hA-''qG	', 'fr-FR', '[[regtime_]]', NULL),
('hA-''qG갞', 'fr-LU', '[[regtime_]]', NULL),
('hA-''qGg', 'fr-MC', '[[regtime_]]', NULL),
('hA-''qG^O', 'fr-SN', '[[regtime_]]', NULL),
('hA-''qG', 'fur-IT', '[[regtime_]]', NULL),
('hA-''qG', 'ga-IE', '[[regtime_]]', NULL),
('hA-''qG', 'gaa-GH', '[[regtime_]]', NULL),
('hA-''qGE', 'gez-ER', '[[regtime_]]', NULL),
('hA-''qGj8', 'gez-ET', '[[regtime_]]', NULL),
('hA-''qGC''', 'gl-ES', '[[regtime_]]', NULL),
('hA-''qG+P', 'gsw-CH', '[[regtime_]]', NULL),
('hA-''qG', 'gu-IN', '[[regtime_]]', NULL),
('hA-''qGJ$', 'gv-GB', '[[regtime_]]', NULL),
('hA-''qG{\n', 'ha-GH', '[[regtime_]]', NULL),
('hA-''qGr', 'ha-NE', '[[regtime_]]', NULL),
('hA-''qG@~', 'ha-NG', '[[regtime_]]', NULL),
('hA-''qGqd', 'ha-SD', '[[regtime_]]', NULL),
('hA-''qG!', 'haw-US', '[[regtime_]]', NULL),
('hA-''qG	-', 'he-IL', '[[regtime_]]', NULL),
('hA-''qG	', 'hi-IN', '[[regtime_]]', NULL),
('hA-''qG#', 'hr-HR', '[[regtime_]]', NULL),
('hA-''qGm', 'hu-HU', '[[regtime_]]', NULL),
('hA-''qG', 'hy-AM', '[[regtime_]]', NULL),
('hA-''qG%,', 'id-ID', '[[regtime_]]', NULL),
('hA-''qGE\0', 'ig-NG', '[[regtime_]]', NULL),
('hA-''qG', 'ii-CN', '[[regtime_]]', NULL),
('hA-''qGư', 'is-IS', '[[regtime_]]', NULL),
('hA-''qG-c', 'it-CH', '[[regtime_]]', NULL),
('hA-''qGm', 'it-IT', '[[regtime_]]', NULL),
('hA-''qG<\\', 'ja-JP', '[[regtime_]]', NULL),
('hA-''qGr', 'ka-GE', '[[regtime_]]', NULL),
('hA-''qGO', 'kaj-NG', '[[regtime_]]', NULL),
('hA-''qG	', 'kam-KE', '[[regtime_]]', NULL),
('hA-''qGX\0', 'kcg-NG', '[[regtime_]]', NULL),
('hA-''qG?', 'kfo-CI', '[[regtime_]]', NULL),
('hA-''qGH', 'kk-KZ', '[[regtime_]]', NULL),
('hA-''qG)zU', 'kl-GL', '[[regtime_]]', NULL),
('hA-''qGq=', 'km-KH', '[[regtime_]]', NULL),
('hA-''qGM', 'kn-IN', '[[regtime_]]', NULL),
('hA-''qG0', 'ko-KR', '[[regtime_]]', NULL),
('hA-''qGe', 'kok-IN', '[[regtime_]]', NULL),
('hA-''qGz', 'kpe-GN', '[[regtime_]]', NULL),
('hA-''qG', 'kpe-LR', '[[regtime_]]', NULL),
('hA-''qG', 'ku-IQ', '[[regtime_]]', NULL),
('hA-''qGU', 'ku-IR', '[[regtime_]]', NULL),
('hA-''qG', 'ku-SY', '[[regtime_]]', NULL),
('hA-''qGKr', 'ku-TR', '[[regtime_]]', NULL),
('hA-''qGQ', 'kw-GB', '[[regtime_]]', NULL),
('hA-''qG4-2', 'ky-KG', '[[regtime_]]', NULL),
('hA-''qGX', 'ln-CD', '[[regtime_]]', NULL),
('hA-''qGO', 'ln-CG', '[[regtime_]]', NULL),
('hA-(sv]B', 'lo-LA', '[[regtime_]]', NULL),
('hA-(sv]C\r`', 'lt-LT', '[[regtime_]]', NULL),
('hA-(sv]D@', 'lv-LV', '[[regtime_]]', NULL),
('hA-(sv]D#', 'mk-MK', '[[regtime_]]', NULL),
('hA-(sv]E	', 'ml-IN', '[[regtime_]]', NULL),
('hA-(sv]E<', 'mn-CN', '[[regtime_]]', NULL),
('hA-(sv]F?`', 'mn-MN', '[[regtime_]]', NULL),
('hA-(sv]F]', 'mr-IN', '[[regtime_]]', NULL),
('hA-(sv]GI', 'ms-BN', '[[regtime_]]', NULL),
('hA-(sv]HJI', 'ms-MY', '[[regtime_]]', NULL),
('hA-(sv]Hi', 'mt-MT', '[[regtime_]]', NULL),
('hA-(sv]Hr\Z', 'my-MM', '[[regtime_]]', NULL),
('hA-(sv]IN', 'nb-NO', '[[regtime_]]', NULL),
('hA-(sv]Ix', 'nds-DE', '[[regtime_]]', NULL),
('hA-(sv]J@A', 'ne-IN', '[[regtime_]]', NULL),
('hA-(sv]Jm', 'ne-NP', '[[regtime_]]', NULL),
('hA-(sv]K=2', 'nl-BE', '[[regtime_]]', NULL),
('hA-(sv]Kjs-', 'nl-NL', '[[regtime_]]', NULL),
('hA-(sv]KQ', 'nn-NO', '[[regtime_]]', NULL),
('hA-(sv]K*', 'nr-ZA', '[[regtime_]]', NULL),
('hA-(sv]KG', 'nso-ZA', '[[regtime_]]', NULL),
('hA-(sv]L`', 'ny-MW', '[[regtime_]]', NULL),
('hA-(sv]M ', 'oc-FR', '[[regtime_]]', NULL),
('hA-(sv]Mɤ#', 'om-ET', '[[regtime_]]', NULL),
('hA-(sv]N', 'om-KE', '[[regtime_]]', NULL),
('hA-(sv]Nr', 'or-IN', '[[regtime_]]', NULL),
('hA-(sv]OP.', 'pa-IN', '[[regtime_]]', NULL),
('hA-(sv]PFA~', 'pa-PK', '[[regtime_]]', NULL),
('hA-(sv]Pa', 'pl-PL', '[[regtime_]]', NULL),
('hA-(sv]Q\Z', 'ps-AF', '[[regtime_]]', NULL),
('hA-(sv]RI', 'pt-BR', '[[regtime_]]', NULL),
('hA-(sv]R%Q', 'pt-PT', '[[regtime_]]', NULL),
('hA-(sv]SK/>', 'ro-MD', '[[regtime_]]', NULL),
('hA-(sv]T,D', 'ro-RO', '[[regtime_]]', NULL),
('hA-(sv]Tu', 'ru-RU', '[[regtime_]]', NULL),
('hA-(sv]U@', 'ru-UA', '[[regtime_]]', NULL),
('hA-(sv]Vj', 'rw-RW', '[[regtime_]]', NULL),
('hA-(sv]W3Ѥ', 'sa-IN', '[[regtime_]]', NULL),
('hA-(sv]X', 'se-FI', '[[regtime_]]', NULL),
('hA-(sv]X5', 'se-NO', '[[regtime_]]', NULL),
('hA-(sv]Y֥', 'sh-BA', '[[regtime_]]', NULL),
('hA-(sv]Zu''', 'sh-CS', '[[regtime_]]', NULL),
('hA-(sv]Z', 'si-LK', '[[regtime_]]', NULL),
('hA-(sv][\n', 'sid-ET', '[[regtime_]]', NULL),
('hA-(sv]\\T', 'sk-SK', '[[regtime_]]', NULL),
('hA-(sv]\\o', 'sl-SI', '[[regtime_]]', NULL),
('hA-(sv]]p', 'so-DJ', '[[regtime_]]', NULL),
('hA-(sv]]-', 'so-ET', '[[regtime_]]', NULL),
('hA-(sv]]', 'so-KE', '[[regtime_]]', NULL),
('hA-(sv]^\r7', 'so-SO', '[[regtime_]]', NULL),
('hA-(sv]^#Y', 'sq-AL', '[[regtime_]]', NULL),
('hA-(sv]_', 'sr-BA', '[[regtime_]]', NULL),
('hA-(sv]_*', 'sr-CS', '[[regtime_]]', NULL),
('hA-(sv]`ɰ', 'sr-ME', '[[regtime_]]', NULL),
('hA-(sv]a', 'sr-RS', '[[regtime_]]', NULL),
('hA-(sv]aw', 'ss-SZ', '[[regtime_]]', NULL),
('hA-(sv]bw', 'ss-ZA', '[[regtime_]]', NULL),
('hA-(sv]ciځ', 'st-LS', '[[regtime_]]', NULL),
('hA-(sv]c', 'st-ZA', '[[regtime_]]', NULL),
('hA-(sv]dc', 'sv-FI', '[[regtime_]]', NULL),
('hA-)rtB', 'sv-SE', '[[regtime_]]', NULL),
('hA-)rt~@', 'sw-KE', '[[regtime_]]', NULL),
('hA-)rt', 'sw-TZ', '[[regtime_]]', NULL),
('hA-)rt)', 'syr-SY', '[[regtime_]]', NULL),
('hA-)rt', 'ta-IN', '[[regtime_]]', NULL),
('hA-)rt;R', 'te-IN', '[[regtime_]]', NULL),
('hA-)rt\ZQ', 'tg-TJ', '[[regtime_]]', NULL),
('hA-)rt\Z	o', 'th-TH', '[[regtime_]]', NULL),
('hA-)rtvJY', 'ti-ER', '[[regtime_]]', NULL),
('hA-)rtv:', 'ti-ET', '[[regtime_]]', NULL),
('hA-)rtP', 'tig-ER', '[[regtime_]]', NULL),
('hA-)rt+\\', 'tn-ZA', '[[regtime_]]', NULL),
('hA-)rt}', 'to-TO', '[[regtime_]]', NULL),
('hA-)rtIw', 'tr-TR', '[[regtime_]]', NULL),
('hA-)rt6', 'ts-ZA', '[[regtime_]]', NULL),
('hA-)rt>', 'tt-RU', '[[regtime_]]', NULL),
('hA-)rt r', 'ug-CN', '[[regtime_]]', NULL),
('hA-)rt 5', 'uk-UA', '[[regtime_]]', NULL),
('hA-)rt!pRp', 'ur-IN', '[[regtime_]]', NULL),
('hA-)rt"~', 'ur-PK', '[[regtime_]]', NULL),
('hA-)rt"Jm', 'uz-AF', '[[regtime_]]', NULL),
('hA-)rt#pE', 'uz-UZ', '[[regtime_]]', NULL),
('hA-)rt#t', 've-ZA', '[[regtime_]]', NULL),
('hA-)rt$f|', 'vi-VN', '[[regtime_]]', NULL),
('hA-)rt%Z1', 'wal-ET', '[[regtime_]]', NULL),
('hA-)rt%Y', 'wo-SN', '[[regtime_]]', NULL),
('hA-)rt&!', 'xh-ZA', '[[regtime_]]', NULL),
('hA-)rt&', 'yo-NG', '[[regtime_]]', NULL),
('hA-)rt''', 'zh-CN', '[[regtime_]]', NULL),
('hA-)rt(', 'zh-HK', '[[regtime_]]', NULL),
('hA-)rt(9', 'zh-MO', '[[regtime_]]', NULL),
('hA-)rt)s', 'zh-SG', '[[regtime_]]', NULL),
('hA-)rt)?', 'zh-TW', '[[regtime_]]', NULL),
('hA-)rt)^', 'zu-ZA', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `locale_translation`
--

CREATE TABLE `locale_translation` (
  `locale_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `territory` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`locale_id`,`language_id`),
  KEY `fk.locale_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale_translation`
--

INSERT INTO `locale_translation` VALUES
('hA,r+G', 'hA,r+(', 'Englisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('hA,r+G', '/_MpXT|', 'English', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('hA,r+T', 'hA,r+(', 'Deutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('hA,r+T', '/_MpXT|', 'German', 'Germany', NULL, '[[regtime_]]', NULL),
('hA-%rP', 'hA,r+(', 'Afar', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('hA-%rP', '/_MpXT|', 'Afar', 'Djibouti', NULL, '[[regtime_]]', NULL),
('hA-%r?', 'hA,r+(', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-%r?', '/_MpXT|', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-%r}s', 'hA,r+(', 'Afar', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-%r}s', '/_MpXT|', 'Afar', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('hA-%r\rF', 'hA,r+(', 'Afrikaans', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-%r\rF', '/_MpXT|', 'Afrikaans', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-%r؝', 'hA,r+(', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-%r؝', '/_MpXT|', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-%r<V', 'hA,r+(', 'Amharisch', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-%r<V', '/_MpXT|', 'Amharic', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-%rپL', 'hA,r+(', 'Arabisch', 'Vereinigte Arabische Emirate', NULL, '[[regtime_]]', NULL),
('hA-%rپL', '/_MpXT|', 'Arabic', 'United Arab Emirates', NULL, '[[regtime_]]', NULL),
('hA-%rڃn', 'hA,r+(', 'Arabisch', 'Bahrain', NULL, '[[regtime_]]', NULL),
('hA-%rڃn', '/_MpXT|', 'Arabic', 'Bahrain', NULL, '[[regtime_]]', NULL),
('hA-%rA', 'hA,r+(', 'Arabisch', 'Algerien', NULL, '[[regtime_]]', NULL),
('hA-%rA', '/_MpXT|', 'Arabic', 'Algeria', NULL, '[[regtime_]]', NULL),
('hA-%r[', 'hA,r+(', 'Arabisch', 'Ägypten', NULL, '[[regtime_]]', NULL),
('hA-%r[', '/_MpXT|', 'Arabic', 'Egypt', NULL, '[[regtime_]]', NULL),
('hA-%r4', 'hA,r+(', 'Arabisch', 'Irak', NULL, '[[regtime_]]', NULL),
('hA-%r4', '/_MpXT|', 'Arabic', 'Iraq', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Arabisch', 'Jordanien', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Arabic', 'Jordan', NULL, '[[regtime_]]', NULL),
('hA-%r8', 'hA,r+(', 'Arabisch', 'Kuwait', NULL, '[[regtime_]]', NULL),
('hA-%r8', '/_MpXT|', 'Arabic', 'Kuwait', NULL, '[[regtime_]]', NULL),
('hA-%r2=', 'hA,r+(', 'Arabisch', 'Libanon', NULL, '[[regtime_]]', NULL),
('hA-%r2=', '/_MpXT|', 'Arabic', 'Lebanon', NULL, '[[regtime_]]', NULL),
('hA-%rW', 'hA,r+(', 'Arabisch', 'Libyen', NULL, '[[regtime_]]', NULL),
('hA-%rW', '/_MpXT|', 'Arabic', 'Libya', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Arabisch', 'Marokko', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Arabic', 'Morocco', NULL, '[[regtime_]]', NULL),
('hA-%r{', 'hA,r+(', 'Arabisch', 'Oman', NULL, '[[regtime_]]', NULL),
('hA-%r{', '/_MpXT|', 'Arabic', 'Oman', NULL, '[[regtime_]]', NULL),
('hA-%rVW', 'hA,r+(', 'Arabisch', 'Katar', NULL, '[[regtime_]]', NULL),
('hA-%rVW', '/_MpXT|', 'Arabic', 'Qatar', NULL, '[[regtime_]]', NULL),
('hA-%rߞP''', 'hA,r+(', 'Arabisch', 'Saudi-Arabien', NULL, '[[regtime_]]', NULL),
('hA-%rߞP''', '/_MpXT|', 'Arabic', 'Saudi Arabia', NULL, '[[regtime_]]', NULL),
('hA-%rT', 'hA,r+(', 'Arabisch', 'Sudan', NULL, '[[regtime_]]', NULL),
('hA-%rT', '/_MpXT|', 'Arabic', 'Sudan', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Arabisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Arabic', 'Syria', NULL, '[[regtime_]]', NULL),
('hA-%rᡬ7', 'hA,r+(', 'Arabisch', 'Tunesien', NULL, '[[regtime_]]', NULL),
('hA-%rᡬ7', '/_MpXT|', 'Arabic', 'Tunisia', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Arabisch', 'Jemen', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Arabic', 'Yemen', NULL, '[[regtime_]]', NULL),
('hA-%r✂', 'hA,r+(', 'Assamesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-%r✂', '/_MpXT|', 'Assamese', 'India', NULL, '[[regtime_]]', NULL),
('hA-%rZ', 'hA,r+(', 'Aserbaidschanisch', 'Aserbaidschan', NULL, '[[regtime_]]', NULL),
('hA-%rZ', '/_MpXT|', 'Azerbaijani', 'Azerbaijan', NULL, '[[regtime_]]', NULL),
('hA-%r	', 'hA,r+(', 'Weißrussisch', 'Belarus', NULL, '[[regtime_]]', NULL),
('hA-%r	', '/_MpXT|', 'Belarusian', 'Belarus', NULL, '[[regtime_]]', NULL),
('hA-%rp', 'hA,r+(', 'Bulgarisch', 'Bulgarien', NULL, '[[regtime_]]', NULL),
('hA-%rp', '/_MpXT|', 'Bulgarian', 'Bulgaria', NULL, '[[regtime_]]', NULL),
('hA-%r%', 'hA,r+(', 'Bengalisch', 'Bangladesch', NULL, '[[regtime_]]', NULL),
('hA-%r%', '/_MpXT|', 'Bengali', 'Bangladesh', NULL, '[[regtime_]]', NULL),
('hA-%r(', 'hA,r+(', 'Bengalisch', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-%r(', '/_MpXT|', 'Bengali', 'India', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Tibetisch', 'China', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Tibetan', 'China', NULL, '[[regtime_]]', NULL),
('hA-%rٖ', 'hA,r+(', 'Tibetisch', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-%rٖ', '/_MpXT|', 'Tibetan', 'India', NULL, '[[regtime_]]', NULL),
('hA-%rQ|k', 'hA,r+(', 'Bosnisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('hA-%rQ|k', '/_MpXT|', 'Bosnian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('hA-%rnr', 'hA,r+(', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-%rnr', '/_MpXT|', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Katalanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Catalan', 'Spain', NULL, '[[regtime_]]', NULL),
('hA-%r8:', 'hA,r+(', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-%r8:', '/_MpXT|', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Tschechisch', 'Tschechische Republik', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'Czech', 'Czech Republic', NULL, '[[regtime_]]', NULL),
('hA-%r&1', 'hA,r+(', 'Walisisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('hA-%r&1', '/_MpXT|', 'Welsh', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('hA-%r+8*', 'hA,r+(', 'Dänisch', 'Dänemark', NULL, '[[regtime_]]', NULL),
('hA-%r+8*', '/_MpXT|', 'Danish', 'Denmark', NULL, '[[regtime_]]', NULL),
('hA-%r鳵t', 'hA,r+(', 'Deutsch', 'Österreich', NULL, '[[regtime_]]', NULL),
('hA-%r鳵t', '/_MpXT|', 'German', 'Austria', NULL, '[[regtime_]]', NULL),
('hA-%rӇ', 'hA,r+(', 'Deutsch', 'Belgien', NULL, '[[regtime_]]', NULL),
('hA-%rӇ', '/_MpXT|', 'German', 'Belgium', NULL, '[[regtime_]]', NULL),
('hA-%r', 'hA,r+(', 'Deutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('hA-%r', '/_MpXT|', 'German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('hA-%r"]', 'hA,r+(', 'Deutsch', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('hA-%r"]', '/_MpXT|', 'German', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('hA-%r\0%', 'hA,r+(', 'Deutsch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('hA-%r\0%', '/_MpXT|', 'German', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('hA-%r3', 'hA,r+(', 'Maledivisch', 'Malediven', NULL, '[[regtime_]]', NULL),
('hA-%r3', '/_MpXT|', 'Maldivian', 'Maldive Islands', NULL, '[[regtime_]]', NULL),
('hA-%rl', 'hA,r+(', 'Bhutanisch', 'Bhutan', NULL, '[[regtime_]]', NULL),
('hA-%rl', '/_MpXT|', 'Bhutanese', 'Bhutan', NULL, '[[regtime_]]', NULL),
('hA-%r w', 'hA,r+(', 'Ewe-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-%r w', '/_MpXT|', 'Ewe', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-%rz', 'hA,r+(', 'Ewe-Sprache', 'Togo', NULL, '[[regtime_]]', NULL),
('hA-%rz', '/_MpXT|', 'Ewe', 'Togo', NULL, '[[regtime_]]', NULL),
('hA-%r 2', 'hA,r+(', 'Griechisch', 'Zypern', NULL, '[[regtime_]]', NULL),
('hA-%r 2', '/_MpXT|', 'Greek', 'Cyprus', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6sw', 'hA,r+(', 'Griechisch', 'Griechenland', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6sw', '/_MpXT|', 'Greek', 'Greece', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6B', 'hA,r+(', 'Englisch', 'Amerikanisch-Samoa', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6B', '/_MpXT|', 'English', 'American Samoa', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6&', 'hA,r+(', 'Englisch', 'Australien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6&', '/_MpXT|', 'English', 'Australia', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6{', 'hA,r+(', 'Englisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6{', '/_MpXT|', 'English', 'Belgium', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Englisch', 'Botsuana', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'English', 'Botswana', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6W', 'hA,r+(', 'Englisch', 'Belize', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6W', '/_MpXT|', 'English', 'Belize', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Englisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'English', 'Canada', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6?R', 'hA,r+(', 'Englisch', 'Guam', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6?R', '/_MpXT|', 'English', 'Guam', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\Z|', 'hA,r+(', 'Englisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\Z|', '/_MpXT|', 'English', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6;5', 'hA,r+(', 'Englisch', 'Irland', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6;5', '/_MpXT|', 'English', 'Ireland', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ61', 'hA,r+(', 'Englisch', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ61', '/_MpXT|', 'English', 'India', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Englisch', 'Jamaika', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'English', 'Jamaica', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6,!@', 'hA,r+(', 'Englisch', 'Marshallinseln', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6,!@', '/_MpXT|', 'English', 'Marshall Islands', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', 'hA,r+(', 'Englisch', 'Nördliche Marianen', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', '/_MpXT|', 'English', 'Northern Mariana Islands', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6`m<', 'hA,r+(', 'Englisch', 'Malta', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6`m<', '/_MpXT|', 'English', 'Malta', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6]S', 'hA,r+(', 'Englisch', 'Namibia', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6]S', '/_MpXT|', 'English', 'Namibia', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6lV', 'hA,r+(', 'Englisch', 'Neuseeland', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6lV', '/_MpXT|', 'English', 'New Zealand', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6>', 'hA,r+(', 'Englisch', 'Philippinen', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6>', '/_MpXT|', 'English', 'Philippines', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Englisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'English', 'Pakistan', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\0', 'hA,r+(', 'Englisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\0', '/_MpXT|', 'English', 'Singapore', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6P', 'hA,r+(', 'Englisch', 'Trinidad und Tobago', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6P', '/_MpXT|', 'English', 'Trinidad and Tobago', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6U-', 'hA,r+(', 'Englisch', 'Amerikanisch-Ozeanien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6U-', '/_MpXT|', 'English', 'U.S. Minor Outlying Islands', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6C', 'hA,r+(', 'Englisch (US)', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6C', '/_MpXT|', 'English (US)', 'United States', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Englisch', 'Amerikanische Jungferninseln', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'English', 'American Virgin Islands', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6L', 'hA,r+(', 'Englisch', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6L', '/_MpXT|', 'English', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6]', 'hA,r+(', 'Englisch', 'Simbabwe', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6]', '/_MpXT|', 'English', 'Zimbabwe', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6%', 'hA,r+(', 'Spanisch', 'Argentinien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6%', '/_MpXT|', 'Spanish', 'Argentina', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6_|', 'hA,r+(', 'Spanisch', 'Bolivien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6_|', '/_MpXT|', 'Spanish', 'Bolivia', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6{', 'hA,r+(', 'Spanisch', 'Chile', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6{', '/_MpXT|', 'Spanish', 'Chile', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Spanisch', 'Kolumbien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'Spanish', 'Colombia', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\\', 'hA,r+(', 'Spanisch', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\\', '/_MpXT|', 'Spanish', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Spanisch', 'Dominikanische Republik', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'Spanish', 'Dominican Republic', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Spanisch', 'Ecuador', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'Spanish', 'Ecuador', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Q`', 'hA,r+(', 'Spanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Q`', '/_MpXT|', 'Spanish', 'Spain', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Gmy', 'hA,r+(', 'Spanisch', 'Guatemala', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Gmy', '/_MpXT|', 'Spanish', 'Guatemala', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ69', 'hA,r+(', 'Spanisch', 'Honduras', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ69', '/_MpXT|', 'Spanish', 'Honduras', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6 ', 'hA,r+(', 'Spanisch', 'Mexiko', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6 ', '/_MpXT|', 'Spanish', 'Mexico', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Spanisch', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'Spanish', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6u9T', 'hA,r+(', 'Spanisch', 'Panama', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6u9T', '/_MpXT|', 'Spanish', 'Panama', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6J', 'hA,r+(', 'Spanisch', 'Peru', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6J', '/_MpXT|', 'Spanish', 'Peru', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6|Q', 'hA,r+(', 'Spanisch', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6|Q', '/_MpXT|', 'Spanish', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6El', 'hA,r+(', 'Spanisch', 'Paraguay', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6El', '/_MpXT|', 'Spanish', 'Paraguay', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Z', 'hA,r+(', 'Spanisch', 'El Salvador', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Z', '/_MpXT|', 'Spanish', 'El Salvador', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6!h*', 'hA,r+(', 'Spanisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6!h*', '/_MpXT|', 'Spanish', 'United States', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ69*', 'hA,r+(', 'Spanisch', 'Uruguay', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ69*', '/_MpXT|', 'Spanish', 'Uruguay', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6)Q', 'hA,r+(', 'Spanisch', 'Venezuela', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6)Q', '/_MpXT|', 'Spanish', 'Venezuela', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6|2', 'hA,r+(', 'Estnisch', 'Estland', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6|2', '/_MpXT|', 'Estonian', 'Estonia', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\Z', 'hA,r+(', 'Baskisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\Z', '/_MpXT|', 'Basque', 'Spain', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', 'hA,r+(', 'Persisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', '/_MpXT|', 'Persian', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Dd', 'hA,r+(', 'Persisch', 'Iran', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6Dd', '/_MpXT|', 'Persian', 'Iran', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Finnisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'Finnish', 'Finland', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6S', 'hA,r+(', 'Filipino', 'Philippinen', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6S', '/_MpXT|', 'Filipino', 'Philippines', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', 'hA,r+(', 'Färöisch', 'Färöer', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6}', '/_MpXT|', 'Faeroese', 'Faeroe Islands', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', 'hA,r+(', 'Französisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6', '/_MpXT|', 'French', 'Belgium', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\\', 'hA,r+(', 'Französisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('hA-&r֗ڣ6\\', '/_MpXT|', 'French', 'Canada', NULL, '[[regtime_]]', NULL),
('hA-''qGe', 'hA,r+(', 'Französisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('hA-''qGe', '/_MpXT|', 'French', 'Switzerland', NULL, '[[regtime_]]', NULL),
('hA-''qG	', 'hA,r+(', 'Französisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('hA-''qG	', '/_MpXT|', 'French', 'France', NULL, '[[regtime_]]', NULL),
('hA-''qG갞', 'hA,r+(', 'Französisch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('hA-''qG갞', '/_MpXT|', 'French', 'Luxembourg', NULL, '[[regtime_]]', NULL),
('hA-''qGg', 'hA,r+(', 'Französisch', 'Monaco', NULL, '[[regtime_]]', NULL),
('hA-''qGg', '/_MpXT|', 'French', 'Monaco', NULL, '[[regtime_]]', NULL),
('hA-''qG^O', 'hA,r+(', 'Französisch', 'Senegal', NULL, '[[regtime_]]', NULL),
('hA-''qG^O', '/_MpXT|', 'French', 'Senegal', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Friulisch', 'Italien', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Friulian', 'Italy', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Irisch', 'Irland', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Irish', 'Ireland', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Ga-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Ga', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-''qGE', 'hA,r+(', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-''qGE', '/_MpXT|', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-''qGj8', 'hA,r+(', 'Geez', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-''qGj8', '/_MpXT|', 'Geez', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-''qGC''', 'hA,r+(', 'Galizisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('hA-''qGC''', '/_MpXT|', 'Galician', 'Spain', NULL, '[[regtime_]]', NULL),
('hA-''qG+P', 'hA,r+(', 'Schweizerdeutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('hA-''qG+P', '/_MpXT|', 'Swiss German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Gujarati', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Gujarati', 'India', NULL, '[[regtime_]]', NULL),
('hA-''qGJ$', 'hA,r+(', 'Manx', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('hA-''qGJ$', '/_MpXT|', 'Manx', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('hA-''qG{\n', 'hA,r+(', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-''qG{\n', '/_MpXT|', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('hA-''qGr', 'hA,r+(', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('hA-''qGr', '/_MpXT|', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('hA-''qG@~', 'hA,r+(', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qG@~', '/_MpXT|', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qGqd', 'hA,r+(', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('hA-''qGqd', '/_MpXT|', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('hA-''qG!', 'hA,r+(', 'Hawaiisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('hA-''qG!', '/_MpXT|', 'Hawaiian', 'United States', NULL, '[[regtime_]]', NULL),
('hA-''qG	-', 'hA,r+(', 'Hebräisch', 'Israel', NULL, '[[regtime_]]', NULL),
('hA-''qG	-', '/_MpXT|', 'Hebrew', 'Israel', NULL, '[[regtime_]]', NULL),
('hA-''qG	', 'hA,r+(', 'Hindi', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-''qG	', '/_MpXT|', 'Hindi', 'India', NULL, '[[regtime_]]', NULL),
('hA-''qG#', 'hA,r+(', 'Kroatisch', 'Kroatien', NULL, '[[regtime_]]', NULL),
('hA-''qG#', '/_MpXT|', 'Croatian', 'Croatia', NULL, '[[regtime_]]', NULL),
('hA-''qGm', 'hA,r+(', 'Ungarisch', 'Ungarn', NULL, '[[regtime_]]', NULL),
('hA-''qGm', '/_MpXT|', 'Hungarian', 'Hungary', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Armenisch', 'Armenien', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Armenian', 'Armenia', NULL, '[[regtime_]]', NULL),
('hA-''qG%,', 'hA,r+(', 'Indonesisch', 'Indonesien', NULL, '[[regtime_]]', NULL),
('hA-''qG%,', '/_MpXT|', 'Indonesian', 'Indonesia', NULL, '[[regtime_]]', NULL),
('hA-''qGE\0', 'hA,r+(', 'Igbo-Sprache', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qGE\0', '/_MpXT|', 'Igbo', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('hA-''qGư', 'hA,r+(', 'Isländisch', 'Island', NULL, '[[regtime_]]', NULL),
('hA-''qGư', '/_MpXT|', 'Icelandic', 'Iceland', NULL, '[[regtime_]]', NULL),
('hA-''qG-c', 'hA,r+(', 'Italienisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('hA-''qG-c', '/_MpXT|', 'Italian', 'Switzerland', NULL, '[[regtime_]]', NULL),
('hA-''qGm', 'hA,r+(', 'Italienisch', 'Italien', NULL, '[[regtime_]]', NULL),
('hA-''qGm', '/_MpXT|', 'Italian', 'Italy', NULL, '[[regtime_]]', NULL),
('hA-''qG<\\', 'hA,r+(', 'Japanisch', 'Japan', NULL, '[[regtime_]]', NULL),
('hA-''qG<\\', '/_MpXT|', 'Japanese', 'Japan', NULL, '[[regtime_]]', NULL),
('hA-''qGr', 'hA,r+(', 'Georgisch', 'Georgien', NULL, '[[regtime_]]', NULL),
('hA-''qGr', '/_MpXT|', 'Georgian', 'Georgia', NULL, '[[regtime_]]', NULL),
('hA-''qGO', 'hA,r+(', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qGO', '/_MpXT|', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qG	', 'hA,r+(', 'Kamba', 'Kenia', NULL, '[[regtime_]]', NULL),
('hA-''qG	', '/_MpXT|', 'Kamba', 'Kenya', NULL, '[[regtime_]]', NULL),
('hA-''qGX\0', 'hA,r+(', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qGX\0', '/_MpXT|', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-''qG?', 'hA,r+(', 'Koro', 'Elfenbeinküste', NULL, '[[regtime_]]', NULL),
('hA-''qG?', '/_MpXT|', 'Koro', 'Ivory Coast', NULL, '[[regtime_]]', NULL),
('hA-''qGH', 'hA,r+(', 'Kasachisch', 'Kasachstan', NULL, '[[regtime_]]', NULL),
('hA-''qGH', '/_MpXT|', 'Kazakh', 'Kazakhstan', NULL, '[[regtime_]]', NULL),
('hA-''qG)zU', 'hA,r+(', 'Grönländisch', 'Grönland', NULL, '[[regtime_]]', NULL),
('hA-''qG)zU', '/_MpXT|', 'Greenlandic', 'Greenland', NULL, '[[regtime_]]', NULL),
('hA-''qGq=', 'hA,r+(', 'Kambodschanisch', 'Kambodscha', NULL, '[[regtime_]]', NULL),
('hA-''qGq=', '/_MpXT|', 'Cambodian', 'Cambodia', NULL, '[[regtime_]]', NULL),
('hA-''qGM', 'hA,r+(', 'Kannada', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-''qGM', '/_MpXT|', 'Kannada', 'India', NULL, '[[regtime_]]', NULL),
('hA-''qG0', 'hA,r+(', 'Koreanisch', 'Republik Korea', NULL, '[[regtime_]]', NULL),
('hA-''qG0', '/_MpXT|', 'Korean', 'Republic of Korea', NULL, '[[regtime_]]', NULL),
('hA-''qGe', 'hA,r+(', 'Konkani', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-''qGe', '/_MpXT|', 'Konkani', 'India', NULL, '[[regtime_]]', NULL),
('hA-''qGz', 'hA,r+(', 'Kpelle-Sprache', 'Guinea', NULL, '[[regtime_]]', NULL),
('hA-''qGz', '/_MpXT|', 'Kpelle', 'Guinea', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Kpelle-Sprache', 'Liberia', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Kpelle', 'Liberia', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Kurdisch', 'Irak', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Kurdish', 'Iraq', NULL, '[[regtime_]]', NULL),
('hA-''qGU', 'hA,r+(', 'Kurdisch', 'Iran', NULL, '[[regtime_]]', NULL),
('hA-''qGU', '/_MpXT|', 'Kurdish', 'Iran', NULL, '[[regtime_]]', NULL),
('hA-''qG', 'hA,r+(', 'Kurdisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('hA-''qG', '/_MpXT|', 'Kurdish', 'Syria', NULL, '[[regtime_]]', NULL),
('hA-''qGKr', 'hA,r+(', 'Kurdisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('hA-''qGKr', '/_MpXT|', 'Kurdish', 'Turkey', NULL, '[[regtime_]]', NULL),
('hA-''qGQ', 'hA,r+(', 'Kornisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('hA-''qGQ', '/_MpXT|', 'Cornish', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('hA-''qG4-2', 'hA,r+(', 'Kirgisisch', 'Kirgisistan', NULL, '[[regtime_]]', NULL),
('hA-''qG4-2', '/_MpXT|', 'Kirghiz', 'Kyrgyzstan', NULL, '[[regtime_]]', NULL),
('hA-''qGX', 'hA,r+(', 'Lingala', 'Demokratische Republik Kongo', NULL, '[[regtime_]]', NULL),
('hA-''qGX', '/_MpXT|', 'Lingala', 'Democratic Republic of the Congo', NULL, '[[regtime_]]', NULL),
('hA-''qGO', 'hA,r+(', 'Lingala', 'Kongo', NULL, '[[regtime_]]', NULL),
('hA-''qGO', '/_MpXT|', 'Lingala', 'Congo', NULL, '[[regtime_]]', NULL),
('hA-(sv]B', 'hA,r+(', 'Laotisch', 'Laos', NULL, '[[regtime_]]', NULL),
('hA-(sv]B', '/_MpXT|', 'Lao', 'Laos', NULL, '[[regtime_]]', NULL),
('hA-(sv]C\r`', 'hA,r+(', 'Litauisch', 'Litauen', NULL, '[[regtime_]]', NULL),
('hA-(sv]C\r`', '/_MpXT|', 'Lithuanian', 'Lithuania', NULL, '[[regtime_]]', NULL),
('hA-(sv]D@', 'hA,r+(', 'Lettisch', 'Lettland', NULL, '[[regtime_]]', NULL),
('hA-(sv]D@', '/_MpXT|', 'Latvian', 'Latvia', NULL, '[[regtime_]]', NULL),
('hA-(sv]D#', 'hA,r+(', 'Mazedonisch', 'Mazedonien', NULL, '[[regtime_]]', NULL),
('hA-(sv]D#', '/_MpXT|', 'Macedonian', 'Macedonia', NULL, '[[regtime_]]', NULL),
('hA-(sv]E	', 'hA,r+(', 'Malayalam', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-(sv]E	', '/_MpXT|', 'Malayalam', 'India', NULL, '[[regtime_]]', NULL),
('hA-(sv]E<', 'hA,r+(', 'Mongolisch', 'China', NULL, '[[regtime_]]', NULL),
('hA-(sv]E<', '/_MpXT|', 'Mongol', 'China', NULL, '[[regtime_]]', NULL),
('hA-(sv]F?`', 'hA,r+(', 'Mongolisch', 'Mongolei', NULL, '[[regtime_]]', NULL),
('hA-(sv]F?`', '/_MpXT|', 'Mongol', 'Mongolia', NULL, '[[regtime_]]', NULL),
('hA-(sv]F]', 'hA,r+(', 'Marathi', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-(sv]F]', '/_MpXT|', 'Marathi', 'India', NULL, '[[regtime_]]', NULL),
('hA-(sv]GI', 'hA,r+(', 'Malaiisch', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('hA-(sv]GI', '/_MpXT|', 'Malay', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('hA-(sv]HJI', 'hA,r+(', 'Malaiisch', 'Malaysia', NULL, '[[regtime_]]', NULL),
('hA-(sv]HJI', '/_MpXT|', 'Malay', 'Malaysia', NULL, '[[regtime_]]', NULL),
('hA-(sv]Hi', 'hA,r+(', 'Maltesisch', 'Malta', NULL, '[[regtime_]]', NULL),
('hA-(sv]Hi', '/_MpXT|', 'Maltese', 'Malta', NULL, '[[regtime_]]', NULL),
('hA-(sv]Hr\Z', 'hA,r+(', 'Birmanisch', 'Myanmar', NULL, '[[regtime_]]', NULL),
('hA-(sv]Hr\Z', '/_MpXT|', 'Burmese', 'Myanmar', NULL, '[[regtime_]]', NULL),
('hA-(sv]IN', 'hA,r+(', 'Norwegisch Bokmål', 'Norwegen', NULL, '[[regtime_]]', NULL),
('hA-(sv]IN', '/_MpXT|', 'Norwegian Bokmål', 'Norway', NULL, '[[regtime_]]', NULL),
('hA-(sv]Ix', 'hA,r+(', 'Niederdeutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('hA-(sv]Ix', '/_MpXT|', 'Low German', 'Germany', NULL, '[[regtime_]]', NULL),
('hA-(sv]J@A', 'hA,r+(', 'Nepalesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-(sv]J@A', '/_MpXT|', 'Nepalese', 'India', NULL, '[[regtime_]]', NULL),
('hA-(sv]Jm', 'hA,r+(', 'Nepalesisch', 'Nepal', NULL, '[[regtime_]]', NULL),
('hA-(sv]Jm', '/_MpXT|', 'Nepalese', 'Nepal', NULL, '[[regtime_]]', NULL),
('hA-(sv]K=2', 'hA,r+(', 'Niederländisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('hA-(sv]K=2', '/_MpXT|', 'Dutch', 'Belgium', NULL, '[[regtime_]]', NULL),
('hA-(sv]Kjs-', 'hA,r+(', 'Niederländisch', 'Niederlande', NULL, '[[regtime_]]', NULL),
('hA-(sv]Kjs-', '/_MpXT|', 'Dutch', 'Netherlands', NULL, '[[regtime_]]', NULL),
('hA-(sv]KQ', 'hA,r+(', 'Norwegisch Nynorsk', 'Norwegen', NULL, '[[regtime_]]', NULL),
('hA-(sv]KQ', '/_MpXT|', 'Norwegian Nynorsk', 'Norway', NULL, '[[regtime_]]', NULL),
('hA-(sv]K*', 'hA,r+(', 'Süd-Ndebele-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-(sv]K*', '/_MpXT|', 'Southern Ndebele', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-(sv]KG', 'hA,r+(', 'Nord-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-(sv]KG', '/_MpXT|', 'Northern Sotho language', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-(sv]L`', 'hA,r+(', 'Nyanja-Sprache', 'Malawi', NULL, '[[regtime_]]', NULL),
('hA-(sv]L`', '/_MpXT|', 'Nyanja', 'Malawi', NULL, '[[regtime_]]', NULL),
('hA-(sv]M ', 'hA,r+(', 'Okzitanisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('hA-(sv]M ', '/_MpXT|', 'Occitan', 'France', NULL, '[[regtime_]]', NULL),
('hA-(sv]Mɤ#', 'hA,r+(', 'Oromo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-(sv]Mɤ#', '/_MpXT|', 'Oromo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-(sv]N', 'hA,r+(', 'Oromo', 'Kenia', NULL, '[[regtime_]]', NULL),
('hA-(sv]N', '/_MpXT|', 'Oromo', 'Kenya', NULL, '[[regtime_]]', NULL),
('hA-(sv]Nr', 'hA,r+(', 'Orija', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-(sv]Nr', '/_MpXT|', 'Orija', 'India', NULL, '[[regtime_]]', NULL),
('hA-(sv]OP.', 'hA,r+(', 'Pandschabisch', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-(sv]OP.', '/_MpXT|', 'Punjabi', 'India', NULL, '[[regtime_]]', NULL),
('hA-(sv]PFA~', 'hA,r+(', 'Pandschabisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('hA-(sv]PFA~', '/_MpXT|', 'Punjabi', 'Pakistan', NULL, '[[regtime_]]', NULL),
('hA-(sv]Pa', 'hA,r+(', 'Polnisch', 'Polen', NULL, '[[regtime_]]', NULL),
('hA-(sv]Pa', '/_MpXT|', 'Polish', 'Poland', NULL, '[[regtime_]]', NULL),
('hA-(sv]Q\Z', 'hA,r+(', 'Paschtu', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('hA-(sv]Q\Z', '/_MpXT|', 'Pashto', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('hA-(sv]RI', 'hA,r+(', 'Portugiesisch', 'Brasilien', NULL, '[[regtime_]]', NULL),
('hA-(sv]RI', '/_MpXT|', 'Portuguese', 'Brazil', NULL, '[[regtime_]]', NULL),
('hA-(sv]R%Q', 'hA,r+(', 'Portugiesisch', 'Portugal', NULL, '[[regtime_]]', NULL),
('hA-(sv]R%Q', '/_MpXT|', 'Portuguese', 'Portugal', NULL, '[[regtime_]]', NULL),
('hA-(sv]SK/>', 'hA,r+(', 'Rumänisch', 'Republik Moldau', NULL, '[[regtime_]]', NULL),
('hA-(sv]SK/>', '/_MpXT|', 'Romanian', 'Republic of Moldova', NULL, '[[regtime_]]', NULL),
('hA-(sv]T,D', 'hA,r+(', 'Rumänisch', 'Rumänien', NULL, '[[regtime_]]', NULL),
('hA-(sv]T,D', '/_MpXT|', 'Romanian', 'Romania', NULL, '[[regtime_]]', NULL),
('hA-(sv]Tu', 'hA,r+(', 'Russisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('hA-(sv]Tu', '/_MpXT|', 'Russian', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('hA-(sv]U@', 'hA,r+(', 'Russisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('hA-(sv]U@', '/_MpXT|', 'Russian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('hA-(sv]Vj', 'hA,r+(', 'Ruandisch', 'Ruanda', NULL, '[[regtime_]]', NULL),
('hA-(sv]Vj', '/_MpXT|', 'Rwandan', 'Rwanda', NULL, '[[regtime_]]', NULL),
('hA-(sv]W3Ѥ', 'hA,r+(', 'Sanskrit', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-(sv]W3Ѥ', '/_MpXT|', 'Sanskrit', 'India', NULL, '[[regtime_]]', NULL),
('hA-(sv]X', 'hA,r+(', 'Nord-Samisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('hA-(sv]X', '/_MpXT|', 'Northen Samian', 'Finland', NULL, '[[regtime_]]', NULL),
('hA-(sv]X5', 'hA,r+(', 'Nord-Samisch', 'Norwegen', NULL, '[[regtime_]]', NULL),
('hA-(sv]X5', '/_MpXT|', 'Northen Samian', 'Norway', NULL, '[[regtime_]]', NULL),
('hA-(sv]Y֥', 'hA,r+(', 'Serbo-Kroatisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('hA-(sv]Y֥', '/_MpXT|', 'Serbo-Croat', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('hA-(sv]Zu''', 'hA,r+(', 'Serbo-Kroatisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('hA-(sv]Zu''', '/_MpXT|', 'Serbo-Croat', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('hA-(sv]Z', 'hA,r+(', 'Singhalesisch', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('hA-(sv]Z', '/_MpXT|', 'Singhalese', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('hA-(sv][\n', 'hA,r+(', 'Sidamo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-(sv][\n', '/_MpXT|', 'Sidamo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-(sv]\\T', 'hA,r+(', 'Slowakisch', 'Slowakei', NULL, '[[regtime_]]', NULL),
('hA-(sv]\\T', '/_MpXT|', 'Slovak', 'Slovakia', NULL, '[[regtime_]]', NULL),
('hA-(sv]\\o', 'hA,r+(', 'Slowenisch', 'Slowenien', NULL, '[[regtime_]]', NULL),
('hA-(sv]\\o', '/_MpXT|', 'Slovene', 'Slovenia', NULL, '[[regtime_]]', NULL),
('hA-(sv]]p', 'hA,r+(', 'Somali', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('hA-(sv]]p', '/_MpXT|', 'Somali', 'Djibouti', NULL, '[[regtime_]]', NULL),
('hA-(sv]]-', 'hA,r+(', 'Somali', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-(sv]]-', '/_MpXT|', 'Somali', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-(sv]]', 'hA,r+(', 'Somali', 'Kenia', NULL, '[[regtime_]]', NULL),
('hA-(sv]]', '/_MpXT|', 'Somali', 'Kenya', NULL, '[[regtime_]]', NULL),
('hA-(sv]^\r7', 'hA,r+(', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('hA-(sv]^\r7', '/_MpXT|', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('hA-(sv]^#Y', 'hA,r+(', 'Albanisch', 'Albanien', NULL, '[[regtime_]]', NULL),
('hA-(sv]^#Y', '/_MpXT|', 'Albanian', 'Albania', NULL, '[[regtime_]]', NULL),
('hA-(sv]_', 'hA,r+(', 'Serbisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('hA-(sv]_', '/_MpXT|', 'Serbian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('hA-(sv]_*', 'hA,r+(', 'Serbisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('hA-(sv]_*', '/_MpXT|', 'Serbian', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('hA-(sv]`ɰ', 'hA,r+(', 'Serbisch', 'Montenegro', NULL, '[[regtime_]]', NULL),
('hA-(sv]`ɰ', '/_MpXT|', 'Serbian', 'Montenegro', NULL, '[[regtime_]]', NULL),
('hA-(sv]a', 'hA,r+(', 'Serbisch', 'Serbien', NULL, '[[regtime_]]', NULL),
('hA-(sv]a', '/_MpXT|', 'Serbian', 'Serbia', NULL, '[[regtime_]]', NULL),
('hA-(sv]aw', 'hA,r+(', 'Swazi', 'Swasiland', NULL, '[[regtime_]]', NULL),
('hA-(sv]aw', '/_MpXT|', 'Swazi', 'Swaziland', NULL, '[[regtime_]]', NULL),
('hA-(sv]bw', 'hA,r+(', 'Swazi', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-(sv]bw', '/_MpXT|', 'Swazi', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-(sv]ciځ', 'hA,r+(', 'Süd-Sotho-Sprache', 'Lesotho', NULL, '[[regtime_]]', NULL),
('hA-(sv]ciځ', '/_MpXT|', 'Southern Sotho Language', 'Lesotho', NULL, '[[regtime_]]', NULL),
('hA-(sv]c', 'hA,r+(', 'Süd-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-(sv]c', '/_MpXT|', 'Southern Sotho Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-(sv]dc', 'hA,r+(', 'Schwedisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('hA-(sv]dc', '/_MpXT|', 'Swedish', 'Finland', NULL, '[[regtime_]]', NULL),
('hA-)rtB', 'hA,r+(', 'Schwedisch', 'Schweden', NULL, '[[regtime_]]', NULL),
('hA-)rtB', '/_MpXT|', 'Swedish', 'Sweden', NULL, '[[regtime_]]', NULL),
('hA-)rt~@', 'hA,r+(', 'Suaheli', 'Kenia', NULL, '[[regtime_]]', NULL),
('hA-)rt~@', '/_MpXT|', 'Swahili', 'Kenya', NULL, '[[regtime_]]', NULL),
('hA-)rt', 'hA,r+(', 'Suaheli', 'Tansania', NULL, '[[regtime_]]', NULL),
('hA-)rt', '/_MpXT|', 'Swahili', 'Tanzania', NULL, '[[regtime_]]', NULL),
('hA-)rt)', 'hA,r+(', 'Syrisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('hA-)rt)', '/_MpXT|', 'Syriac', 'Syria', NULL, '[[regtime_]]', NULL),
('hA-)rt', 'hA,r+(', 'Tamilisch', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-)rt', '/_MpXT|', 'Tamil', 'India', NULL, '[[regtime_]]', NULL),
('hA-)rt;R', 'hA,r+(', 'Telugu', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-)rt;R', '/_MpXT|', 'Telugu', 'India', NULL, '[[regtime_]]', NULL),
('hA-)rt\ZQ', 'hA,r+(', 'Tadschikisch', 'Tadschikistan', NULL, '[[regtime_]]', NULL),
('hA-)rt\ZQ', '/_MpXT|', 'Tadjik', 'Tajikistan', NULL, '[[regtime_]]', NULL),
('hA-)rt\Z	o', 'hA,r+(', 'Thailändisch', 'Thailand', NULL, '[[regtime_]]', NULL),
('hA-)rt\Z	o', '/_MpXT|', 'Thai', 'Thailand', NULL, '[[regtime_]]', NULL),
('hA-)rtvJY', 'hA,r+(', 'Tigrinja', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-)rtvJY', '/_MpXT|', 'Tigrinya', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-)rtv:', 'hA,r+(', 'Tigrinja', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-)rtv:', '/_MpXT|', 'Tigrinya', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-)rtP', 'hA,r+(', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-)rtP', '/_MpXT|', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('hA-)rt+\\', 'hA,r+(', 'Tswana-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-)rt+\\', '/_MpXT|', 'Tswana Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-)rt}', 'hA,r+(', 'Tongaisch', 'Tonga', NULL, '[[regtime_]]', NULL),
('hA-)rt}', '/_MpXT|', 'Tongan', 'Tonga', NULL, '[[regtime_]]', NULL),
('hA-)rtIw', 'hA,r+(', 'Türkisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('hA-)rtIw', '/_MpXT|', 'Turkish', 'Turkey', NULL, '[[regtime_]]', NULL),
('hA-)rt6', 'hA,r+(', 'Tsonga', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-)rt6', '/_MpXT|', 'Tsonga', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-)rt>', 'hA,r+(', 'Tatarisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('hA-)rt>', '/_MpXT|', 'Tartar', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('hA-)rt r', 'hA,r+(', 'Uigurisch', 'China', NULL, '[[regtime_]]', NULL),
('hA-)rt r', '/_MpXT|', 'Uighur', 'China', NULL, '[[regtime_]]', NULL),
('hA-)rt 5', 'hA,r+(', 'Ukrainisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('hA-)rt 5', '/_MpXT|', 'Ukrainian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('hA-)rt!pRp', 'hA,r+(', 'Urdu', 'Indien', NULL, '[[regtime_]]', NULL),
('hA-)rt!pRp', '/_MpXT|', 'Urdu', 'India', NULL, '[[regtime_]]', NULL),
('hA-)rt"~', 'hA,r+(', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('hA-)rt"~', '/_MpXT|', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('hA-)rt"Jm', 'hA,r+(', 'Usbekisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('hA-)rt"Jm', '/_MpXT|', 'Uzbek', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('hA-)rt#pE', 'hA,r+(', 'Usbekisch', 'Usbekistan', NULL, '[[regtime_]]', NULL);
INSERT INTO `locale_translation` VALUES
('hA-)rt#pE', '/_MpXT|', 'Uzbek', 'Uzbekistan', NULL, '[[regtime_]]', NULL),
('hA-)rt#t', 'hA,r+(', 'Venda-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-)rt#t', '/_MpXT|', 'Venda Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-)rt$f|', 'hA,r+(', 'Vietnamesisch', 'Vietnam', NULL, '[[regtime_]]', NULL),
('hA-)rt$f|', '/_MpXT|', 'Vietnamese', 'Vietnam', NULL, '[[regtime_]]', NULL),
('hA-)rt%Z1', 'hA,r+(', 'Walamo-Sprache', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('hA-)rt%Z1', '/_MpXT|', 'Walamo Language', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('hA-)rt%Y', 'hA,r+(', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('hA-)rt%Y', '/_MpXT|', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('hA-)rt&!', 'hA,r+(', 'Xhosa', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-)rt&!', '/_MpXT|', 'Xhosa', 'South Africa', NULL, '[[regtime_]]', NULL),
('hA-)rt&', 'hA,r+(', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-)rt&', '/_MpXT|', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('hA-)rt''', 'hA,r+(', 'Chinesisch', 'China', NULL, '[[regtime_]]', NULL),
('hA-)rt''', '/_MpXT|', 'Chinese', 'China', NULL, '[[regtime_]]', NULL),
('hA-)rt(', 'hA,r+(', 'Chinesisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('hA-)rt(', '/_MpXT|', 'Chinese', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('hA-)rt(9', 'hA,r+(', 'Chinesisch', 'Sonderverwaltungszone Macao', NULL, '[[regtime_]]', NULL),
('hA-)rt(9', '/_MpXT|', 'Chinese', 'Macao', NULL, '[[regtime_]]', NULL),
('hA-)rt)s', 'hA,r+(', 'Chinesisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('hA-)rt)s', '/_MpXT|', 'Chinese', 'Singapur', NULL, '[[regtime_]]', NULL),
('hA-)rt)?', 'hA,r+(', 'Chinesisch', 'Taiwan', NULL, '[[regtime_]]', NULL),
('hA-)rt)?', '/_MpXT|', 'Chinese', 'Taiwan', NULL, '[[regtime_]]', NULL),
('hA-)rt)^', 'hA,r+(', 'Zulu', 'Südafrika', NULL, '[[regtime_]]', NULL),
('hA-)rt)^', '/_MpXT|', 'Zulu', 'South Africa', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `log_entry`
--

CREATE TABLE `log_entry` (
  `id` binary(16) NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` smallint NOT NULL,
  `channel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` json DEFAULT NULL,
  `extra` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.log_entry.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer`
--

CREATE TABLE `mail_header_footer` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer`
--

INSERT INTO `mail_header_footer` VALUES
('hB''reN\rh', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer_translation`
--

CREATE TABLE `mail_header_footer_translation` (
  `mail_header_footer_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `header_html` longtext COLLATE utf8mb4_unicode_ci,
  `header_plain` longtext COLLATE utf8mb4_unicode_ci,
  `footer_html` longtext COLLATE utf8mb4_unicode_ci,
  `footer_plain` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_header_footer_id`,`language_id`),
  KEY `fk.mail_header_footer_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer_translation`
--

INSERT INTO `mail_header_footer_translation` VALUES
('hB''reN\rh', 'hA,r+(', 'Standard-E-Mail-Fußzeile', 'Standard-E-Mail-Fußzeile basierend auf den Stammdaten', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Adresse:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bankverbindung:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Adresse:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bankverbindung:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL),
('hB''reN\rh', '/_MpXT|', 'Default email footer', 'Default email footer derived from basic information', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Address:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bank account:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Address:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bank account:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template`
--

CREATE TABLE `mail_template` (
  `id` binary(16) NOT NULL,
  `mail_template_type_id` binary(16) DEFAULT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.mail_template.mail_template_type_id` (`mail_template_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template`
--

INSERT INTO `mail_template` VALUES
('hA?p(ݞ', 'hA>rb*+', 1, '[[regtime_]]', NULL),
('hA?p(ݞ&8,', 'hA>rb+"', 1, '[[regtime_]]', NULL),
('hA@q-ޘ"i', 'hA>rb+V8C', 1, '[[regtime_]]', NULL),
('hA@q_cMo', 'hA>rb)Gi', 1, '[[regtime_]]', NULL),
('hA@r', 'hA>rb,l ', 1, '[[regtime_]]', NULL),
('hA@rѲ9<', 'hA>rb+Ҷ/', 1, '[[regtime_]]', NULL),
('hAA\rp(G尃', 'hA>rb,w', 1, '[[regtime_]]', NULL),
('hAQrԈ', 'hAQq6z]', 1, '[[regtime_]]', NULL),
('hA_)p+Ax|', 'hAVp\\:A', 1, '[[regtime_]]', NULL),
('hAesCܰ', 'hAep?iyMM', 1, '[[regtime_]]', NULL),
('hAjr^6* Tf', 'hA>rb.[*', 1, '[[regtime_]]', NULL),
('hAjr:d', 'hA>rb-k', 1, '[[regtime_]]', NULL),
('hAjr$''ҁ', 'hA>rb.', 1, '[[regtime_]]', NULL),
('hAkqΛPg', 'hA>rb0S+', 1, '[[regtime_]]', NULL),
('hAk6sp/y''', 'hA>rb/Ț', 1, '[[regtime_]]', NULL),
('hAkdqO)>8.', 'hA>rb3x', 1, '[[regtime_]]', NULL),
('hAkwp3;K0c', 'hA>rb3N', 1, '[[regtime_]]', NULL),
('hAkq^t', 'hA>rb4B_h', 1, '[[regtime_]]', NULL),
('hAks-,', 'hA>rb43', 1, '[[regtime_]]', NULL),
('hAks=򶇰z+', 'hA>rb18Y', 1, '[[regtime_]]', NULL),
('hAkq#a]a', 'hA>rb0R', 1, '[[regtime_]]', NULL),
('hAkr[*0', 'hA>rb3%', 1, '[[regtime_]]', NULL),
('hAlq<+`&', 'hA>rb2>', 1, '[[regtime_]]', NULL),
('hAl#p>hJxi', 'hA>rb1@', 1, '[[regtime_]]', NULL),
('hAl7p=w''	', 'hA>rb20', 1, '[[regtime_]]', NULL),
('hAlLpC7ԍ', 'hA>rb2	', 1, '[[regtime_]]', NULL),
('hAps8O6|.', 'hAps8O68', 1, '[[regtime_]]', NULL),
('hAqquM', 'hAqquMg}', 1, '[[regtime_]]', NULL),
('hAs"', 'hA˻r#N', 1, '[[regtime_]]', NULL),
('hArPe`=', 'hArJRR', 1, '[[regtime_]]', NULL),
('hB9pD:y:', 'hB9pD:ܣ', 1, '[[regtime_]]', NULL),
('hB9pD:މ', 'hB9pD:A', 1, '[[regtime_]]', NULL),
('hB9pD:*', 'hB9pD:%7', 1, '[[regtime_]]', NULL),
('hB9pD:L', 'hB9pD:߷', 1, '[[regtime_]]', NULL),
('hBc\\s$ys', 'hBcGsܨ', 1, '[[regtime_]]', NULL),
('hBuNsr*', 'hBuNsr:#', 1, '[[regtime_]]', NULL),
('hB3s@X', 'hB"p	Ɩ0', 1, '[[regtime_]]', NULL),
('hBnsscz ', 'hB\\p8-2?', 1, '[[regtime_]]', NULL),
('hBp+', 'hBs(', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_media`
--

CREATE TABLE `mail_template_media` (
  `id` binary(16) NOT NULL,
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk.mail_template_media.mail_template_id` (`mail_template_id`),
  KEY `fk.mail_template_media.media_id` (`media_id`),
  KEY `fk.mail_template_media.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_translation`
--

CREATE TABLE `mail_template_translation` (
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `sender_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `content_html` longtext COLLATE utf8mb4_unicode_ci,
  `content_plain` longtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_template_id`,`language_id`),
  KEY `fk.mail_template_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_translation`
--

INSERT INTO `mail_template_translation` VALUES
('hA?p(ݞ', 'hA,r+(', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Schön, dass Sie sich für unseren Newsletter interessieren!</p>\n                <p>Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie <a href="{{ url }}">hier</a> klicken.</p>\n                <p>Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Schön, dass Sie sich für unseren Newsletter interessieren!\n\n                Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie auf den folgenden Link klicken: {{ url }}\n\n                Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.\n        ', NULL, '[[regtime_]]', NULL),
('hA?p(ݞ', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Thank you for your interest in our newsletter!</p>\n                <p>In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking <a href="{{ url }}">here</a>.</p>\n                <p>If you have not subscribed to the newsletter, please ignore this email.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Thank you for your interest in our newsletter!\n\n                In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking on the link: {{ url }}\n\n                If you have not subscribed to the newsletter, please ignore this email.\n        ', NULL, '[[regtime_]]', NULL),
('hA?p(ݞ&8,', 'hA,r+(', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>vielen Dank für Ihre Anmeldung.</p>\n                <p>Sie haben sich erfolgreich zu unserem Newsletter angemeldet.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                vielen Dank für Ihre Anmeldung.\n\n                Sie haben sich erfolgreich zu unserem Newsletter angemeldet.\n        ', NULL, '[[regtime_]]', NULL),
('hA?p(ݞ&8,', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>thank you very much for your registration.</p>\n                <p>You have successfully subscribed to our newsletter.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                thank you very much for your registration.\n\n                You have successfully subscribed to our newsletter.\n        ', NULL, '[[regtime_]]', NULL),
('hA@q-ޘ"i', 'hA,r+(', '{{ salesChannel.name }}', 'Bestellbestätigung', '', '<div style="font-family:arial; font-size:12px;">\n\n{% set currencyIsoCode = order.currency.isoCode %}\n\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n<br>\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n<br>\nBestellnummer: {{ order.orderNumber }}<br>\n<br>\nSobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.<br>\n<br>\nDen aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\nÜber diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.<br>\n<br>\n<strong>Informationen zu Ihrer Bestellung:</strong><br>\n<br>\n\n<table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n    <tr>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n    </tr>\n\n    {% for lineItem in order.nestedLineItems %}\n        {% set nestingLevel = 0 %}\n        {% set nestedItem = lineItem %}\n        {% block lineItem %}\n            <tr>\n                <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                <td>\n                    {% if nestingLevel > 0 %}\n                        {% for i in 1..nestingLevel %}\n                            <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                        {% endfor %}\n                    {% endif %}\n\n                    <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                        {{ nestedItem.label|u.wordwrap(80) }}\n                    </div>\n\n                    {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                        <div>\n                            {% for option in nestedItem.payload.options %}\n                                {{ option.group }}: {{ option.option }}\n                                {% if nestedItem.payload.options|last != option %}\n                                    {{ " | " }}\n                                {% endif %}\n                            {% endfor %}\n                        </div>\n                    {% endif %}\n\n                    {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                        {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                        {% if referencePriceFeatures|length >= 1 %}\n                            {% set referencePriceFeature = referencePriceFeatures|first %}\n                            <div>\n                                {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                            </div>\n                        {% endif %}\n                    {% endif %}\n                </td>\n                <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n            </tr>\n\n            {% if nestedItem.children.count > 0 %}\n                {% set nestingLevel = nestingLevel + 1 %}\n                {% for lineItem in nestedItem.children %}\n                    {% set nestedItem = lineItem %}\n                    {{ block(''lineItem'') }}\n                {% endfor %}\n            {% endif %}\n        {% endblock %}\n    {% endfor %}\n</table>\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n<p>\n    <br>\n    <br>\n    {% for shippingCost in order.deliveries %}\n        Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n    Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n    {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n    {% if displayRounded %}\n        <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n    {% endif %}\n    <br>\n\n    {% if delivery %}\n        <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n        {{ delivery.shippingMethod.translated.description }}<br>\n        <br>\n    {% endif %}\n\n    {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n    <strong>Rechnungsadresse:</strong><br>\n    {{ billingAddress.company }}<br>\n    {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n    {{ billingAddress.street }} <br>\n    {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n    {{ billingAddress.country.translated.name }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Lieferadresse:</strong><br>\n        {{ delivery.shippingOrderAddress.company }}<br>\n        {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n        {{ delivery.shippingOrderAddress.street }} <br>\n        {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n        {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n        <br>\n    {% endif %}\n    {% if order.orderCustomer.vatIds %}\n        Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n        Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n        bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n    {% endif %}\n    <br/>\n    Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n</p>\n<br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nSobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.\n\nDen aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nÜber diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.\n\nInformationen zu Ihrer Bestellung:\n\nPos.   Artikel-Nr.			Produktbild(Alt-Text) 			Beschreibung			Menge			Preis			Summe\n\n{% for lineItem in order.lineItems %}\n{{ loop.index }}      {% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}      {% if nestedItem.cover is defined and nestedItem.cover is not null %}{{ lineItem.cover.alt }}{% endif %}        {{ lineItem.label|u.wordwrap(80) }}{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}, {% for option in lineItem.payload.options %}{{ option.group }}: {{ option.option }}{% if lineItem.payload.options|last != option %}{{ " | " }}{% endif %}{% endfor %}{% endif %}{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}{% if referencePriceFeatures|length >= 1 %}{% set referencePriceFeature = referencePriceFeatures|first %}, {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}){% endif %}{% endif %}\n    {{ lineItem.quantity }}			{{ lineItem.unitPrice|currency(currencyIsoCode) }}			{{ lineItem.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n{% for shippingCost in order.deliveries %}\n    Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n{% endif %}\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n', NULL, '[[regtime_]]', NULL),
('hA@q-ޘ"i', '/_MpXT|', '{{ salesChannel.name }}', 'Order confirmation', '', '<div style="font-family:arial; font-size:12px;">\n\n{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n<br>\nWe have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n<br>\nOrder number: {{ order.orderNumber }}<br>\n<br>\nAs soon as your payment has been made, you will receive a separate notification and your order will be processed.<br>\n<br>\nYou may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\nYou may use this link to edit your order, change the payment method or make additional payments.<br>\n<br>\n<strong>Information on your order:</strong><br>\n<br>\n\n<table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n    <tr>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n    </tr>\n\n    {% for lineItem in order.nestedLineItems %}\n        {% set nestingLevel = 0 %}\n        {% set nestedItem = lineItem %}\n        {% block lineItem %}\n        <tr>\n            <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n            <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n            <td>\n                {% if nestingLevel > 0 %}\n                    {% for i in 1..nestingLevel %}\n                        <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                    {% endfor %}\n                {% endif %}\n\n                <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                    {{ nestedItem.label|u.wordwrap(80) }}\n                </div>\n\n                {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                    <div>\n                        {% for option in nestedItem.payload.options %}\n                            {{ option.group }}: {{ option.option }}\n                            {% if nestedItem.payload.options|last != option %}\n                                {{ " | " }}\n                            {% endif %}\n                        {% endfor %}\n                    </div>\n                {% endif %}\n\n                {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                    {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                    {% if referencePriceFeatures|length >= 1 %}\n                        {% set referencePriceFeature = referencePriceFeatures|first %}\n                        <div>\n                            {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                            ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                        </div>\n                    {% endif %}\n                {% endif %}\n            </td>\n            <td style="text-align: center">{{ nestedItem.quantity }}</td>\n            <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n            <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n        </tr>\n\n            {% if nestedItem.children.count > 0 %}\n                {% set nestingLevel = nestingLevel + 1 %}\n                {% for lineItem in nestedItem.children %}\n                    {% set nestedItem = lineItem %}\n                    {{ block(''lineItem'') }}\n                {% endfor %}\n            {% endif %}\n        {% endblock %}\n    {% endfor %}\n</table>\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n<p>\n    <br>\n    <br>\n    {% for shippingCost in order.deliveries %}\n        Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n\n    Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n    {% for calculatedTax in order.price.calculatedTaxes %}\n        {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n    {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n    {% if displayRounded %}\n        <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n    {% endif %}\n    <br>\n\n    {% if delivery %}\n        <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n        {{ delivery.shippingMethod.translated.description }}<br>\n        <br>\n    {% endif %}\n\n    {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n    <strong>Billing address:</strong><br>\n    {{ billingAddress.company }}<br>\n    {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n    {{ billingAddress.street }} <br>\n    {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n    {{ billingAddress.country.translated.name }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Shipping address:</strong><br>\n        {{ delivery.shippingOrderAddress.company }}<br>\n        {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n        {{ delivery.shippingOrderAddress.street }} <br>\n        {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n        {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n        <br>\n    {% endif %}\n    {% if order.orderCustomer.vatIds %}\n        Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n        In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n    {% endif %}\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    If you have any questions, do not hesitate to contact us.\n\n</p>\n<br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}\n\nAs soon as your payment has been made, you will receive a separate notification and your order will be processed.\n\nYou may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nYou may use this link to edit your order, change the payment method or make additional payments.\n\nInformation on your order:\n\nPos.   Prod. No.			Product image(Alt text)			Description			Quantities			Price			Total\n\n{% for lineItem in order.lineItems %}\n{{ loop.index }}      {% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}        {% if nestedItem.cover is defined and nestedItem.cover is not null %}{{ lineItem.cover.alt }}{% endif %}        {{ lineItem.label|u.wordwrap(80) }}{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}, {% for option in lineItem.payload.options %}{{ option.group }}: {{ option.option }}{% if lineItem.payload.options|last != option %}{{ " | " }}{% endif %}{% endfor %}{% endif %}{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}{% if referencePriceFeatures|length >= 1 %}{% set referencePriceFeature = referencePriceFeatures|first %}, {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}){% endif %}{% endif %}\n    {{ lineItem.quantity }}			{{ lineItem.unitPrice|currency(currencyIsoCode) }}			{{ lineItem.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n{% for shippingCost in order.deliveries %}\n    Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n{% endif %}\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n', NULL, '[[regtime_]]', NULL),
('hA@q_cMo', 'hA,r+(', '{{ salesChannel.name }}', 'Deine Registrierung bei {{ salesChannel.name }}', 'Registrierungsbestätigung', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n                <br/>\n                vielen Dank für Ihre Anmeldung in unserem Shop.<br/>\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse <strong>{{ customer.email }}</strong> und dem von Ihnen gewählten Kennwort.<br/>\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                vielen Dank für Ihre Anmeldung in unserem Shop.\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse {{ customer.email }} und dem von Ihnen gewählten Kennwort.\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n', NULL, '[[regtime_]]', NULL),
('hA@q_cMo', '/_MpXT|', '{{ salesChannel.name }}', 'Your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n                <br/>\n                thank you for your signing up with our Shop.<br/>\n                You will gain access via the email address <strong>{{ customer.email }}</strong> and the password you have chosen.<br/>\n                You can change your password anytime.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                thank you for your signing up with our Shop.\n                You will gain access via the email address {{ customer.email }} and the password you have chosen.\n                You can change your password anytime.\n        ', NULL, '[[regtime_]]', NULL),
('hA@r', 'hA,r+(', '{{ salesChannel.name }}', 'Password zurücksetzen - {{ salesChannel.name }}', 'Anfrage zum Zurücksetzen des Passworts', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n        <br/>\n        im Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', 'Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nim Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\nBitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\nPasswort zurücksetzen: {{ resetUrl }}\n\nDieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\nFalls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('hA@r', '/_MpXT|', '{{ salesChannel.name }}', 'Password reset - {{ salesChannel.name }}', 'Password reset request', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n        <br/>\n        there has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nthere has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\nPlease confirm the link below to specify a new password.\n\nReset password: {{ resetUrl }}\n\nThis link is valid for the next 2 hours. After that you have to request a new confirmation link.\nIf you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('hA@rѲ9<', 'hA,r+(', '{{ salesChannel.name }}', 'Ihr Händleraccount wurde freigeschaltet - {{ salesChannel.name }}', 'Kundengruppenwechsel freigeschaltet', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        ihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.<br/>\n        Von nun an werden wir Ihnen den Netto-Preis berechnen.\n    </p>\n</div>\n', 'Hallo,\n\nihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.\nVon nun an werden wir Ihnen den Netto-Preis berechnen.\n', NULL, '[[regtime_]]', NULL),
('hA@rѲ9<', '/_MpXT|', '{{ salesChannel.name }}', 'Your merchant account has been unlocked - {{ salesChannel.name }}', 'Customer Group Change accepted', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        your merchant account at {{ salesChannel.translated.name }} has been unlocked.<br/>\n        From now on, we will charge you the net purchase price.\n    </p>\n</div>\n', 'Hello,\n\nyour merchant account at {{ salesChannel.translated.name }} has been unlocked.\nFrom now on, we will charge you the net purchase price.\n', NULL, '[[regtime_]]', NULL),
('hAA\rp(G尃', 'hA,r+(', '{{ salesChannel.name }}', 'Ihr Händleraccountantrag wurde abgelehnt - {{ salesChannel.name }}', 'Kundengruppenwechsel abgelehnt', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        vielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine <br/>\n        Händlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen. <br/>\n        Bei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail. <br/>\n    </p>\n</div>\n', 'Hallo,\n\nvielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine\nHändlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen.\nBei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail.\n', NULL, '[[regtime_]]', NULL),
('hAA\rp(G尃', '/_MpXT|', '{{ salesChannel.name }}', 'Your trader account has not been accepted - {{ salesChannel.name }}', 'Customer Group Change rejected', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        thank you for your interest in our trade prices.\n        Unfortunately, we do not have a trading license yet so that we cannot accept you as a merchant.<br/>\n        In case of further questions please do not hesitate to contact us via telephone, fax or email.\n    </p>\n</div>\n', 'Hello,\n\nthank you for your interest in our trade prices. Unfortunately,\nwe do not have a trading license yet so that we cannot accept you as a merchant.\nIn case of further questions please do not hesitate to contact us via telephone, fax or email.\n', NULL, '[[regtime_]]', NULL),
('hAQrԈ', 'hA,r+(', 'Shopware Administration', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', '        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\n        Passwort zurücksetzen: {{ resetUrl }}\n\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('hAQrԈ', '/_MpXT|', 'Shopware Administration', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>', '        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.\n\n        Reset password: {{ resetUrl }}\n\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.\n        If you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('hA_)p+Ax|', 'hA,r+(', '{{ salesChannel.name }}', 'Kontaktanfrage erhalten - {{ salesChannel.name }}', 'Kontaktanfrage erhalten', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.<br/>\n        <br/>\n        Name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Kontakt E-Mail: {{ contactFormData.email }}<br/>\n        <br>\n        Telefonnummer: {{ contactFormData.phone }}<br/>\n        <br/>\n        Betreff: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.\n\nName: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nKontakt E-Mail: {{ contactFormData.email }}\n\nTelefonnummer: {{ contactFormData.phone }}\n\nBetreff: {{ contactFormData.subject }}\n\nNachricht:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('hA_)p+Ax|', '/_MpXT|', '{{ salesChannel.name }}', 'Contact form received - {{ salesChannel.name }}', 'Contact form received', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        The following Message was sent to you via the contact form.<br/>\n        <br/>\n        Contact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Contact email address: {{ contactFormData.email }}\n        <br/>\n        Phone: {{ contactFormData.phone }}<br/>\n        <br/>\n        Subject: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'The following Message was sent to you via the contact form.\n\nContact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nContact email address: {{ contactFormData.email }}\nPhone: {{ contactFormData.phone }}\n\nSubject: {{ contactFormData.subject }}\n\nMessage:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('hAesCܰ', 'hA,r+(', '{{ shopName }}', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.<br/>\n        <br/>\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team\n    </p>\n</div>', '        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:\n\n        {{ resetUrl }}\n\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team', NULL, '[[regtime_]]', NULL),
('hAesCܰ', '/_MpXT|', '{{ shopName }}', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.<br/>\n        <br/>\n        Yours sincerely\n        Your {{ shopName }} team\n    </p>\n</div>', '        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:\n\n        {{ resetUrl }}\n\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.\n\n        Yours sincerely\n        Your {{ shopName }}-Team', NULL, '[[regtime_]]', NULL),
('hAjr^6* Tf', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('hAjr^6* Tf', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAjr:d', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAjr:d', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAjr$''ҁ', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAjr$''ҁ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkqΛPg', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkqΛPg', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAk6sp/y''', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAk6sp/y''', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkdqO)>8.', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkdqO)>8.', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkwp3;K0c', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkwp3;K0c', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n    <br/>\n    the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n    <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    However, in case you have purchased without a registration or a customer account, you do not have this option.\n    <br><br>\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('hAkq^t', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkq^t', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAks-,', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAks-,', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAks=򶇰z+', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAks=򶇰z+', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkq#a]a', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkq#a]a', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkr[*0', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAkr[*0', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('hAlq<+`&', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n<br>\nWir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.<br>\n<br>\nBestellnummer: {{ order.orderNumber }}<br>\n<br>\n<strong>Informationen zu Ihrer Bestellung:</strong><br>\n<br>\n\n<table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n    <tr>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n    </tr>\n\n    {% for lineItem in order.nestedLineItems %}\n        {% set nestingLevel = 0 %}\n        {% set nestedItem = lineItem %}\n        {% block lineItem %}\n            <tr>\n                <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                <td>\n                    {% if nestingLevel > 0 %}\n                        {% for i in 1..nestingLevel %}\n                            <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                        {% endfor %}\n                    {% endif %}\n\n                    <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                        {{ nestedItem.label|u.wordwrap(80) }}\n                    </div>\n\n                    {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                        <div>\n                            {% for option in nestedItem.payload.options %}\n                                {{ option.group }}: {{ option.option }}\n                                {% if nestedItem.payload.options|last != option %}\n                                    {{ " | " }}\n                                {% endif %}\n                            {% endfor %}\n                        </div>\n                    {% endif %}\n\n                    {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                        {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                        {% if referencePriceFeatures|length >= 1 %}\n                            {% set referencePriceFeature = referencePriceFeatures|first %}\n                            <div>\n                                {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                            </div>\n                        {% endif %}\n                    {% endif %}\n                </td>\n                <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n            </tr>\n\n            {% if nestedItem.children.count > 0 %}\n                {% set nestingLevel = nestingLevel + 1 %}\n                {% for lineItem in nestedItem.children %}\n                    {% set nestedItem = lineItem %}\n                    {{ block(''lineItem'') }}\n                {% endfor %}\n            {% endif %}\n        {% endblock %}\n    {% endfor %}\n</table>\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n<p>\n    <br>\n    <br>\n    {% for shippingCost in order.deliveries %}\n        Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n    Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n    {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n    {% if displayRounded %}\n        <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n    {% endif %}\n    <br>\n\n    <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n    {{ order.transactions.first.paymentMethod.translated.description }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n        {{ delivery.shippingMethod.translated.description }}<br>\n        <br>\n    {% endif %}\n\n    {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n    <strong>Rechnungsadresse:</strong><br>\n    {{ billingAddress.company }}<br>\n    {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n    {{ billingAddress.street }} <br>\n    {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n    {{ billingAddress.country.translated.name }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Lieferadresse:</strong><br>\n        {{ delivery.shippingOrderAddress.company }}<br>\n        {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n        {{ delivery.shippingOrderAddress.street }} <br>\n        {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n        {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n        <br>\n    {% endif %}\n    {% if order.orderCustomer.vatIds %}\n        Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n        Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n        bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n    {% endif %}\n    <br/>\n    Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n    <br><br>\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</p>\n<br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.\n\nBestellnummer: {{ order.orderNumber }}\n\nInformationen zu Ihrer Bestellung:\n\nPos.   Artikel-Nr.			Beschreibung			Menge			Preis			Summe\n{% for lineItem in order.lineItems %}\n{{ loop.index }}      {% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}				{{ lineItem.label|u.wordwrap(80) }}{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}, {% for option in lineItem.payload.options %}{{ option.group }}: {{ option.option }}{% if lineItem.payload.options|last != option %}{{ " | " }}{% endif %}{% endfor %}{% endif %}{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}{% if referencePriceFeatures|length >= 1 %}{% set referencePriceFeature = referencePriceFeatures|first %}, {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}){% endif %}{% endif %}\n    {{ lineItem.quantity }}			{{ lineItem.unitPrice|currency(currencyIsoCode) }}			{{ lineItem.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n{% for shippingCost in order.deliveries %}\n    Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n{% endif %}\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAlq<+`&', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n<br>\nWe received your payment and will now start processing the order.<br>\nOrder number: {{ order.orderNumber }}<br>\n<br>\n\n<strong>Information on your order:</strong><br>\n<br>\n\n<table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n    <tr>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n    </tr>\n\n    {% for lineItem in order.nestedLineItems %}\n        {% set nestingLevel = 0 %}\n        {% set nestedItem = lineItem %}\n        {% block lineItem %}\n            <tr>\n                <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                <td>\n                    {% if nestingLevel > 0 %}\n                        {% for i in 1..nestingLevel %}\n                            <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                        {% endfor %}\n                    {% endif %}\n\n                    <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                        {{ nestedItem.label|u.wordwrap(80) }}\n                    </div>\n\n                    {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                        <div>\n                            {% for option in nestedItem.payload.options %}\n                                {{ option.group }}: {{ option.option }}\n                                {% if nestedItem.payload.options|last != option %}\n                                    {{ " | " }}\n                                {% endif %}\n                            {% endfor %}\n                        </div>\n                    {% endif %}\n\n                    {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                        {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                        {% if referencePriceFeatures|length >= 1 %}\n                            {% set referencePriceFeature = referencePriceFeatures|first %}\n                            <div>\n                                {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                            </div>\n                        {% endif %}\n                    {% endif %}\n                </td>\n                <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n            </tr>\n\n            {% if nestedItem.children.count > 0 %}\n                {% set nestingLevel = nestingLevel + 1 %}\n                {% for lineItem in nestedItem.children %}\n                    {% set nestedItem = lineItem %}\n                    {{ block(''lineItem'') }}\n                {% endfor %}\n            {% endif %}\n        {% endblock %}\n    {% endfor %}\n</table>\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n<p>\n    <br>\n    <br>\n    {% for shippingCost in order.deliveries %}\n        Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n\n    Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n    {% for calculatedTax in order.price.calculatedTaxes %}\n        {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n    {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n    {% if displayRounded %}\n        <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n    {% endif %}\n    <br>\n\n    <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n    {{ order.transactions.first.paymentMethod.translated.description }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n        {{ delivery.shippingMethod.translated.description }}<br>\n        <br>\n    {% endif %}\n\n    {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n    <strong>Billing address:</strong><br>\n    {{ billingAddress.company }}<br>\n    {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n    {{ billingAddress.street }} <br>\n    {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n    {{ billingAddress.country.translated.name }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Shipping address:</strong><br>\n        {{ delivery.shippingOrderAddress.company }}<br>\n        {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n        {{ delivery.shippingOrderAddress.street }} <br>\n        {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n        {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n        <br>\n    {% endif %}\n    {% if order.orderCustomer.vatIds %}\n        Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n        In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n    {% endif %}\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</p>\n<br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe received your payment and will now start processing the order.\n\nOrder number: {{ order.orderNumber }}\n\n\nInformation on your order:\n\nPos.   Prod. No.			Description			Quantities			Price			Total\n{% for lineItem in order.lineItems %}\n{{ loop.index }}      {% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}				{{ lineItem.label|u.wordwrap(80) }}{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}, {% for option in lineItem.payload.options %}{{ option.group }}: {{ option.option }}{% if lineItem.payload.options|last != option %}{{ " | " }}{% endif %}{% endfor %}{% endif %}{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}{% if referencePriceFeatures|length >= 1 %}{% set referencePriceFeature = referencePriceFeatures|first %}, {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}){% endif %}{% endif %}\n    {{ lineItem.quantity }}			{{ lineItem.unitPrice|currency(currencyIsoCode) }}			{{ lineItem.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n{% for shippingCost in order.deliveries %}\n    Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n{% endif %}\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAl#p>hJxi', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n<br>\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n<br>\nBestellnummer: {{ order.orderNumber }}\n<br>\nDer Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n<br>\n<strong>Informationen zu Ihrer Bestellung:</strong><br>\n<br>\n\n<table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n    <tr>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n    </tr>\n\n    {% for lineItem in order.nestedLineItems %}\n        {% set nestingLevel = 0 %}\n        {% set nestedItem = lineItem %}\n        {% block lineItem %}\n            <tr>\n                <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                <td>\n                    {% if nestingLevel > 0 %}\n                        {% for i in 1..nestingLevel %}\n                            <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                        {% endfor %}\n                    {% endif %}\n\n                    <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                        {{ nestedItem.label|u.wordwrap(80) }}\n                    </div>\n\n                    {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                        <div>\n                            {% for option in nestedItem.payload.options %}\n                                {{ option.group }}: {{ option.option }}\n                                {% if nestedItem.payload.options|last != option %}\n                                    {{ " | " }}\n                                {% endif %}\n                            {% endfor %}\n                        </div>\n                    {% endif %}\n\n                    {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                        {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                        {% if referencePriceFeatures|length >= 1 %}\n                            {% set referencePriceFeature = referencePriceFeatures|first %}\n                            <div>\n                                {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                            </div>\n                        {% endif %}\n                    {% endif %}\n                </td>\n                <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                <td>{% if nestingLevel == 0 %}{{ nestedItem.totalPrice|currency(currencyIsoCode) }}{% endif %}</td>\n            </tr>\n\n            {% if nestedItem.children.count > 0 %}\n                {% set nestingLevel = nestingLevel + 1 %}\n                {% for lineItem in nestedItem.children %}\n                    {% set nestedItem = lineItem %}\n                    {{ block(''lineItem'') }}\n                {% endfor %}\n            {% endif %}\n        {% endblock %}\n    {% endfor %}\n</table>\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n<p>\n    <br>\n    <br>\n    {% for shippingCost in order.deliveries %}\n        Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n    Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n    {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n    {% if displayRounded %}\n        <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n    {% endif %}\n\n    <br>\n\n    <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n    {{ order.transactions.first.paymentMethod.translated.description }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n        {{ delivery.shippingMethod.translated.description }}<br>\n        <br>\n    {% endif %}\n\n    {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n    <strong>Rechnungsadresse:</strong><br>\n    {{ billingAddress.company }}<br>\n    {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n    {{ billingAddress.street }} <br>\n    {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n    {{ billingAddress.country.translated.name }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Lieferadresse:</strong><br>\n        {{ delivery.shippingOrderAddress.company }}<br>\n        {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n        {{ delivery.shippingOrderAddress.street }} <br>\n        {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n        {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n        <br>\n    {% endif %}\n    {% if order.orderCustomer.vatIds %}\n        Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n        Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n        bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n    {% endif %}\n    <br/>\n    Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n    <br><br>\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</p>\n<br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nDer Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformationen zu Ihrer Bestellung:\n\nPos.   Artikel-Nr.			Beschreibung			Menge			Preis			Summe\n{% for lineItem in order.lineItems %}\n{{ loop.index }}      {% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}				{{ lineItem.label|u.wordwrap(80) }}{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}, {% for option in lineItem.payload.options %}{{ option.group }}: {{ option.option }}{% if lineItem.payload.options|last != option %}{{ " | " }}{% endif %}{% endfor %}{% endif %}{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}{% if referencePriceFeatures|length >= 1 %}{% set referencePriceFeature = referencePriceFeatures|first %}, {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}){% endif %}{% endif %}\n    {{ lineItem.quantity }}			{{ lineItem.unitPrice|currency(currencyIsoCode) }}			{{ lineItem.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n{% for shippingCost in order.deliveries %}\n    Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n    {% for calculatedTax in order.price.calculatedTaxes %}\n        {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n    {% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n{% endif %}\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('hAl#p>hJxi', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n<br>\nWe have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n<br>\nOrder number: {{ order.orderNumber }}.<br>\n<br>\nYou have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n<br>\n<strong>Information on your order:</strong><br>\n<br>\n\n<table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n    <tr>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n        <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n    </tr>\n\n    {% for lineItem in order.nestedLineItems %}\n        {% set nestingLevel = 0 %}\n        {% set nestedItem = lineItem %}\n        {% block lineItem %}\n            <tr>\n                <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                <td>\n                    {% if nestingLevel > 0 %}\n                        {% for i in 1..nestingLevel %}\n                            <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                        {% endfor %}\n                    {% endif %}\n\n                    <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                        {{ nestedItem.label|u.wordwrap(80) }}\n                    </div>\n\n                    {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                        <div>\n                            {% for option in nestedItem.payload.options %}\n                                {{ option.group }}: {{ option.option }}\n                                {% if nestedItem.payload.options|last != option %}\n                                    {{ " | " }}\n                                {% endif %}\n                            {% endfor %}\n                        </div>\n                    {% endif %}\n\n                    {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                        {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                        {% if referencePriceFeatures|length >= 1 %}\n                            {% set referencePriceFeature = referencePriceFeatures|first %}\n                            <div>\n                                {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                            </div>\n                        {% endif %}\n                    {% endif %}\n                </td>\n                <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n            </tr>\n\n            {% if nestedItem.children.count > 0 %}\n                {% set nestingLevel = nestingLevel + 1 %}\n                {% for lineItem in nestedItem.children %}\n                    {% set nestedItem = lineItem %}\n                    {{ block(''lineItem'') }}\n                {% endfor %}\n            {% endif %}\n        {% endblock %}\n    {% endfor %}\n</table>\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n<p>\n    <br>\n    <br>\n    {% for shippingCost in order.deliveries %}\n        Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n\n    Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n    {% for calculatedTax in order.price.calculatedTaxes %}\n        {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n    {% endfor %}\n    {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n    {% if displayRounded %}\n        <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n    {% endif %}\n\n    <br>\n\n    <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n    {{ order.transactions.first.paymentMethod.translated.description }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n        {{ delivery.shippingMethod.translated.description }}<br>\n        <br>\n    {% endif %}\n\n    {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n    <strong>Billing address:</strong><br>\n    {{ billingAddress.company }}<br>\n    {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n    {{ billingAddress.street }} <br>\n    {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n    {{ billingAddress.country.translated.name }}<br>\n    <br>\n\n    {% if delivery %}\n        <strong>Shipping address:</strong><br>\n        {{ delivery.shippingOrderAddress.company }}<br>\n        {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n        {{ delivery.shippingOrderAddress.street }} <br>\n        {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n        {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n        <br>\n    {% endif %}\n    {% if order.orderCustomer.vatIds %}\n        Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n        In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n    {% endif %}\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</p>\n<br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}.\n\nYou have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformation on your order:\n\nPos.   Prod. No.			Description			Quantities			Price			Total\n{% for lineItem in order.lineItems %}\n{{ loop.index }}      {% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}				{{ lineItem.label|u.wordwrap(80) }}{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}, {% for option in lineItem.payload.options %}{{ option.group }}: {{ option.option }}{% if lineItem.payload.options|last != option %}{{ " | " }}{% endif %}{% endfor %}{% endif %}{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}{% if referencePriceFeatures|length >= 1 %}{% set referencePriceFeature = referencePriceFeatures|first %}, {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }}* / {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}){% endif %}{% endif %}\n    {{ lineItem.quantity }}			{{ lineItem.unitPrice|currency(currencyIsoCode) }}			{{ lineItem.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\n\n{% set delivery = order.deliveries.first %}\n\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n\n{% for shippingCost in order.deliveries %}\n    Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n{% endif %}\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAl7p=w''	', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAl7p=w''	', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAlLpC7ԍ', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAlLpC7ԍ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hAps8O6|.', 'hA,r+(', '{{ salesChannel.translated.name }}', 'Bitte bestätigen Sie Ihre Anmeldung bei {{ salesChannel.translated.name }}', 'Anmeldebestätigung', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.<br/>\n                    Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Anmeldung abschließen</a><br/>\n                    <br/>\n                    Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n                </p>\n            </div>\n        ', '\n            Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.\n            Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:\n\n            {{ confirmUrl }}\n\n            Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n        ', NULL, '[[regtime_]]', NULL),
('hAps8O6|.', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Please confirm your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    thank you for your signing up with {{ salesChannel.translated.name }}.<br/>\n                    Please confirm the sign-up via the following link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Completing sign-up</a><br/>\n                    <br/>\n                    By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n                </p>\n            </div>\n        ', '\n            Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            thank you for your signing up with {{ salesChannel.translated.name }}.\n            Please confirm the sign-up via the following link:\n\n            {{ confirmUrl }}\n\n            By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n        ', NULL, '[[regtime_]]', NULL),
('hAqquM', 'hA,r+(', '{{ salesChannel.name }}', 'Bitte bestätigen Sie Ihre E-Mail-Adresse bei {{ salesChannel.name }}', 'Anmeldebestätigung bei Gastbestellungen', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Bitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">E-Mail bestätigen</a><br/>\n        <br/>\n        Nach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.<br/>\n        Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n    </p>\n</div>\n', 'Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nBitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:\n\n{{ confirmUrl }}\n\nNach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.\nDurch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n', NULL, '[[regtime_]]', NULL),
('hAqquM', '/_MpXT|', '{{ salesChannel.name }}', 'Please confirm your email address at {{ salesChannel.name }}', 'Email confirmation at guest orders', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Please confirm your email address via the following link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">Confirm email</a><br/>\n        <br/>\n        After the confirmation, you will be directed to the checkout, where you can check and complete your order again.<br/>\n        By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nPlease confirm your email address via the following link:\n\n{{ confirmUrl }}\n\nAfter the confirmation, you will be directed to the checkout, where you can check and complete your order again.\nBy this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n', NULL, '[[regtime_]]', NULL),
('hAs"', 'hA,r+(', 'Shop', 'Kunden Gruppen Registrierung Akzeptiert', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Ihr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.<br/>\n        Ab sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.<br/>\n\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nIhr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.\nAb sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.<br/><br/>\n\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n', NULL, '[[regtime_]]', NULL),
('hAs"', '/_MpXT|', 'Shop', 'Customer Group Registration Accepted', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Your account has been activated for the customer group {{ customerGroup.translated.name }}.<br/>\n        From now on you can shop at the new conditions of this customer group.<br/><br/>\n\n        Please do not hesitate to contact us at any time if you have any questions.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nYour account has been activated for the customer group {{ customerGroup.translated.name }}.<br/>\nFrom now on you can shop at the new conditions of this customer group.<br/><br/>\n\nPlease do not hesitate to contact us at any time if you have any questions.\n', NULL, '[[regtime_]]', NULL),
('hArPe`=', 'hA,r+(', 'Shop', 'Kunden Gruppen Registrierung Abgelehnt', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Vielen Dank für Ihr Interesse an den Konditionen für Kundengruppe {{ customerGroup.translated.name }}.<br/>\n        Leider können wir sie nicht für diese Kundengruppe freischalten.<br/>\n\n        Bei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nVielen Dank für Ihr Interesse an den Konditionen für Kundengruppe  {{ customerGroup.translated.name }}.\nLeider können wir sie nicht für diese Kundengruppe freischalten.<br/>\n\nBei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n', NULL, '[[regtime_]]', NULL),
('hArPe`=', '/_MpXT|', 'Shop', 'Customer Group Registration Declined', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Thank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.<br/>\n        Unfortunately we cannot activate your account for this customer group.<br/><br/>\n\n        If you have any questions, please feel free to contact us by phone or mail.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nThank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.<br/>\nUnfortunately we cannot activate your account for this customer group.\n\nIf you have any questions, please feel free to contact us by phone or mail.\n', NULL, '[[regtime_]]', NULL),
('hB9pD:y:', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hB9pD:y:', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            ''deepLinkCode'': a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hB9pD:މ', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hB9pD:މ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('hB9pD:*', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hB9pD:*', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hB9pD:L', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hB9pD:L', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hBc\\s$ys', 'hA,r+(', '{{ salesChannel.name }}', 'Ihre Dateien von {{ salesChannel.name }} stehen bereit', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Mit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nMit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('hBc\\s$ys', '/_MpXT|', '{{ salesChannel.name }}', 'Your downloads from {{ salesChannel.name }} are ready', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the files to the order: {{ order.orderNumber }}\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the files to the order: {{ order.orderNumber }}\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('hBuNsr*', 'hA,r+(', '{{ salesChannel.name }}', 'Neue Produktbewertung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            E-Mail-Adresse: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Produkt: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Bewertung: {{ reviewFormData.points }}<br/>\n        <br/>\n        Titel: {{ reviewFormData.title }}<br/>\n        <br/>\n        Inhalt:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}E-Mail-Adresse: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Produkt: {{ product.translated.name }}{% endif %}\n\nBewertung: {{ reviewFormData.points }}\n\nTitel: {{ reviewFormData.title }}\n\nInhalt:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('hBuNsr*', '/_MpXT|', '{{ salesChannel.name }}', 'New product review', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            Email address: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Product: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Rating: {{ reviewFormData.points }}<br/>\n        <br/>\n        Title: {{ reviewFormData.title }}<br/>\n        <br/>\n        Content:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}Email address: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Product: {{ product.translated.name }}{% endif %}\n\nRating: {{ reviewFormData.points }}\n\nTitle: {{ reviewFormData.title }}\n\nContent:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('hB3s@X', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hB3s@X', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hBnsscz ', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hBnsscz ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hBp+', 'hA,r+(', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('hBp+', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_type`
--

CREATE TABLE `mail_template_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `available_entities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.mail_template_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_type`
--

INSERT INTO `mail_template_type` VALUES
('hA>rb)Gi', 'customer_register', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('hA>rb*+', 'newsletterDoubleOptIn', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('hA>rb+"', 'newsletterRegister', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('hA>rb+V8C', 'order_confirmation_mail', '{"order":"order","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('hA>rb+Ҷ/', 'customer_group_change_accept', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb,w', 'customer_group_change_reject', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('hA>rb,l ', 'password_change', '{"customer":"customer","resetUrl":null,"salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL),
('hA>rb-M', 'sepa_confirmation', '{"order":"order","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('hA>rb-B[', 'product_stock_warning', '{"product":"product","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL);
INSERT INTO `mail_template_type` VALUES
('hA>rb-k', 'order_delivery.state.returned_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb.[*', 'order_delivery.state.shipped_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb.', 'order_delivery.state.returned', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb/Ț', 'order_delivery.state.shipped', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb0S+', 'order_delivery.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb0R', 'order_transaction.state.reminded', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb18Y', 'order_transaction.state.refunded_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb1@', 'order_transaction.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('hA>rb2>', 'order_transaction.state.paid', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId"