const l=`{% block sw_import_export_new_profile_wizard %} <sw-wizard ref="wizard" class="sw-import-export-new-profile-wizard" variant="full" :right-button-disabled="nextButtonDisabled" :active-page="currentlyActivePage" @close="onClose" @finish="onFinish" @current-page-change="onCurrentPageChange" > {% block sw_import_export_new_profile_wizard_page_general %} <sw-wizard-page :position="0" :title="pageTitleSnippet('sw-import-export.profile.generalTab')" > <sw-import-export-new-profile-wizard-general-page :profile="profile" @next-disable="onNextDisable" @next-allow="onNextAllow" /> </sw-wizard-page> {% endblock %} {% block sw_import_export_new_profile_wizard_page_csv %} <sw-wizard-page :position="csvUploadPagePosition" :title="pageTitleSnippet('sw-import-export.profile.csvUploadTab')" > <sw-import-export-new-profile-wizard-csv-page :profile="profile" @next-disable="onNextDisable" @next-allow="onNextAllow" /> </sw-wizard-page> {% endblock %} {% block sw_import_export_new_profile_wizard_page_mapping %} <sw-wizard-page :position="2" :title="pageTitleSnippet('sw-import-export.profile.mappingsTab')" > <sw-import-export-new-profile-wizard-mapping-page :profile="profile" :system-required-fields="systemRequiredFields" @next-disable="onNextDisable" @next-allow="onNextAllow" /> </sw-wizard-page> {% endblock %} {% block sw_import_export_new_profile_wizard_footer_right_button %} <template #footer-right-button> <div class="sw-import-export-new-profile-wizard__footer-right-button-group"> {% block sw_import_export_new_profile_wizard_footer_right_button_finish %} <mt-button v-if="showNextButton" size="small" variant="primary" :disabled="nextButtonDisabled" @click="onFinish" > {{ $tc('sw-import-export.profile.addProfileLabel') }} </mt-button> {% endblock %} <template v-else> {% block sw_import_export_new_profile_wizard_footer_right_button_skip %} <mt-button v-if="showCsvSkipButton" size="small" variant="secondary" @click="onNextPage" > {{ $tc('sw-import-export.profile.skipCsvUpload') }} </mt-button> {% endblock %} {% block sw_import_export_new_profile_wizard_footer_right_button_next %} <mt-button size="small" variant="primary" :disabled="nextButtonDisabled" @click="onNextPage" > {{ $tc('sw-wizard.nextButton') }} </mt-button> {% endblock %} </template> </div> </template> {% endblock %} {% block sw_import_export_new_profile_wizard_violation_modal %} <sw-modal v-if="showValidationError" :title="$tc('global.default.error')" class="sw-import-export-new-profile-wizard__violation-modal" @modal-close="resetViolations" > {% block sw_import_export_new_profile_wizard_violation_modal_message %} <p>{{ $tc('sw-import-export.profile.violationMessage') }}</p> {% endblock %} {% block sw_import_export_new_profile_wizard_violation_modal_required_fields %} <ul> {% block sw_import_export_new_profile_wizard_violation_modal_required_field %} <li v-for="requiredField in missingRequiredFields" :key="requiredField" > {{ requiredField }} </li> {% endblock %} </ul> {% endblock %} {% block sw_import_export_new_profile_wizard_violation_modal_footer %} <template #modal-footer> <mt-button size="small" variant="secondary" @click="resetViolations" > {{ $tc('sw-import-export.profile.closeViolation') }} </mt-button> </template> {% endblock %} </sw-modal> {% endblock %} </sw-wizard> {% endblock %}`,{Criteria:t}=Shopware.Data,s={template:l,inject:["repositoryFactory","feature","importExportProfileMapping"],emits:["close","profile-save"],props:{profile:{type:Object,required:!0}},data(){return{nextButtonDisabled:!0,missingRequiredFields:[],systemRequiredFields:{},csvUploadPagePosition:1,currentlyActivePage:0,pagesCount:3}},computed:{profileRepository(){return this.repositoryFactory.create("import_export_profile")},showValidationError(){return this.missingRequiredFields.length>0},showNextButton(){return this.currentlyActivePage>=this.pagesCount-1},showCsvSkipButton(){return this.currentlyActivePage===this.csvUploadPagePosition},parentProfileCriteria(){const e=new t(1,25);return e.addFilter(t.equals("sourceEntity",this.profile.sourceEntity)),e.addFilter(t.equals("systemDefault",!0)),e}},watch:{"profile.sourceEntity":{handler(e){e&&this.loadSystemRequiredFieldsForEntity(e)}}},methods:{onClose(){this.$emit("close")},onFinish(){return this.saveProfile()},pageTitleSnippet(e){return`${this.$tc("sw-import-export.profile.newProfileLabel")} - ${this.$tc(e)}`},onNextAllow(){this.nextButtonDisabled=!1},onNextDisable(){this.nextButtonDisabled=!0},loadSystemRequiredFieldsForEntity(e){this.systemRequiredFields=this.importExportProfileMapping.getSystemRequiredFields(e)},saveProfile(){return this.getParentProfileSelected().then(e=>{this.checkValidation(e),this.missingRequiredFields.length===0&&this.$emit("profile-save")})},getParentProfileSelected(){return this.profileRepository.search(this.parentProfileCriteria).then(e=>e.total>0?e[0]:null).catch(()=>{this.createNotificationError({message:this.$tc("sw-import-export.profile.messageSearchParentProfileError")})})},checkValidation(e){if(this.profile.type==="export")return;const o=e?e.mapping:[],r=this.profile.config.createEntities===!1&&this.profile.config.updateEntities===!0,i=this.importExportProfileMapping.validate(this.profile.sourceEntity,this.profile.mapping,o,r);i.missingRequiredFields.length>0&&(this.missingRequiredFields=i.missingRequiredFields)},resetViolations(){this.missingRequiredFields=[]},onCurrentPageChange(e){this.currentlyActivePage=e},onNextPage(){this.$refs.wizard.nextPage()}}};export{s as default};
