const r=`{% block sw_manufacturer_list %} <sw-page class="sw-manufacturer-list"> {% block sw_manufacturer_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="product_manufacturer" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_manufacturer_list_smart_bar_header %} <template #smart-bar-header> {% block sw_manufacturer_list_smart_bar_header_title %} <h2> {% block sw_manufacturer_list_smart_bar_header_title_text %} {{ $tc('sw-manufacturer.list.textManufacturerOverview') }} {% endblock %} {% block sw_manufacturer_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_manufacturer_list_actions %} <template #smart-bar-actions> {% block sw_manufacturer_list_smart_bar_actions %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('product_manufacturer.creator'), showOnDisabledElements: true }" :disabled="!acl.can('product_manufacturer.creator') || undefined" class="sw-manufacturer-list__add-manufacturer" variant="primary" size="default" @click="$router.push({ name: 'sw.manufacturer.create' })" > {{ $tc('sw-manufacturer.list.buttonAddManufacturer') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_manufacturer_list_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} <template #content> {% block sw_manufacturer_list_content %} <div class="sw-manufacturer-list__content"> {% block sw_manufacturer_list_grid %} <sw-entity-listing v-if="entitySearchable" class="sw-manufacturer-list__grid" detail-route="sw.manufacturer.detail" :is-loading="isLoading" :columns="manufacturerColumns" :repository="manufacturerRepository" :items="manufacturers" :criteria-limit="limit" :sort-by="currentSortBy" :sort-direction="sortDirection" :disable-data-fetching="true" :allow-edit="acl.can('product_manufacturer.editor') || undefined" :allow-inline-edit="acl.can('product_manufacturer.editor') || undefined" :allow-delete="acl.can('product_manufacturer.deleter') || undefined" :show-selections="acl.can('product_manufacturer.deleter') || undefined" identifier="sw-manufacturer-list" @update-records="updateTotal" @page-change="onPageChange" @column-sort="onSortColumn" > {% block sw_manufacturer_list_grid_columns_name_preview %} <template #preview-name="{ item }"> <sw-media-preview-v2 :source="item.mediaId" /> </template> {% endblock %} </sw-entity-listing> {% endblock %} {% block sw_manufacturer_list_empty_state %} <sw-empty-state v-if="!isLoading && !total && isValidTerm(term)" :title="$tc('sw-empty-state.messageNoResultTitle')" > <template #default> {{ $tc('sw-empty-state.messageNoResultSublineBefore') }} <router-link class="sw-empty-state__description-link" :to="{ name: 'sw.profile.index.searchPreferences' }" > {{ $tc('sw-empty-state.messageNoResultSublineLink') }} </router-link> {{ $tc('sw-empty-state.messageNoResultSublineAfter') }} </template> </sw-empty-state> {% endblock %} </div> {% endblock %} </template> </sw-page> {% endblock %}`,{Mixin:s}=Shopware,{Criteria:a}=Shopware.Data,i={template:r,inject:["repositoryFactory","acl"],mixins:[s.getByName("listing")],data(){return{manufacturers:null,isLoading:!0,sortBy:"name",sortDirection:"ASC",total:0,searchConfigEntity:"product_manufacturer"}},metaInfo(){return{title:this.$createTitle()}},computed:{manufacturerRepository(){return this.repositoryFactory.create("product_manufacturer")},manufacturerColumns(){return[{property:"name",dataIndex:"name",allowResize:!0,routerLink:"sw.manufacturer.detail",label:"sw-manufacturer.list.columnName",inlineEdit:"string",primary:!0},{property:"link",label:"sw-manufacturer.list.columnLink",inlineEdit:"string"}]},manufacturerCriteria(){const t=new a(this.page,this.limit);return t.setTerm(this.term),t.addSorting(a.sort(this.sortBy,this.sortDirection,this.naturalSorting)),t}},methods:{onChangeLanguage(t){this.getList(t)},async getList(){this.isLoading=!0;const t=await this.addQueryScores(this.term,this.manufacturerCriteria);return this.entitySearchable?(this.freshSearchTerm&&t.resetSorting(),this.manufacturerRepository.search(t).then(e=>{this.manufacturers=e,this.total=e.total,this.isLoading=!1})):(this.isLoading=!1,this.total=0,!1)},updateTotal({total:t}){this.total=t}}};export{i as default};
