const s=`{% block sw_order_list %} <sw-page class="sw-order-list"> {% block sw_order_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="order" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_order_list_smart_bar_header %} <template #smart-bar-header> {% block sw_order_list_smart_bar_header_title %} <h2> {% block sw_order_list_smart_bar_header_title_text %} {{ $tc('sw-order.list.textOrders') }} {% endblock %} {% block sw_order_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_order_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_order_list_smart_bar_actions_slot %} {% block sw_order_list_smart_bar_actions_add %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('order.creator'), showOnDisabledElements: true }" class="sw-order-list__add-order" :disabled="!acl.can('order.creator') || undefined" variant="primary" size="default" @click="$router.push({ name: 'sw.order.create' })" > {{ $tc('sw-order.list.buttonAddOrder') }} </mt-button> {% endblock %} {% endblock %} </template> {% endblock %} {% block sw_order_list_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_order_list_content %} <template #content> {% block sw_order_list_content_slot %} <div class="sw-order-list__content"> {% block sw_order_list_grid %} <sw-data-grid v-if="entitySearchable" ref="orderGrid" :data-source="orders" :columns="orderColumns" :full-page="true" :show-settings="true" :show-selection="true" :sort-by="currentSortBy" :sort-direction="sortDirection" :is-loading="isLoading" :allow-column-edit="true" identifier="sw-order-list" :disable-data-fetching="true" :maximum-select-items="100" @column-sort="onSortColumn" @page-change="onPageChange" @selection-change="updateSelection" > {% block sw_order_list_grid_columns %} {% block sw_order_list_grid_columns_order_number %} <template #column-orderNumber="{ item }"> {% block sw_order_list_grid_order_number_link %} <router-link :to="{ name: 'sw.order.detail', params: { id: item.id } }"> {{ item.orderNumber }} </router-link> {% endblock %} {% block sw_order_list_grid_label_manual_order %} <sw-label v-if="item.createdById" appearance="pill" size="small" class="sw-order-list__manual-order-label" > {{ $tc('sw-order.list.labelManualOrder') }} </sw-label> {% endblock %} <mt-button v-if="item.customerComment" v-tooltip="{ message: item.customerComment }" class="sw-order-list__tooltip-order-comment" size="x-small" variant="secondary" > <mt-icon name="regular-comments" size="14px" /> </mt-button> </template> {% endblock %} {% block sw_order_list_grid_columns_customer_name %} <template #column-orderCustomer.firstName="{ item }"> <router-link v-if="item.orderCustomer && item.orderCustomer.customerId" :to="{ name: 'sw.customer.detail', params: { id: item.orderCustomer.customerId } }" > {{ item.orderCustomer.lastName }}, {{ item.orderCustomer.firstName }} </router-link> <template v-else-if="item.orderCustomer"> {{ item.orderCustomer.lastName }}, {{ item.orderCustomer.firstName }} </template> </template> {% endblock %} {% block sw_order_list_grid_columns_billing_address %} <template #column-billingAddressId="{ item }"> <span v-if="item.billingAddress.company">{{ item.billingAddress.company }}<span v-if="item.billingAddress.department"> - {{ item.billingAddress.department }}</span>,&nbsp;</span> {{ item.billingAddress.street }}, {{ item.billingAddress.zipcode }} {{ item.billingAddress.city }} </template> {% endblock %} {% block sw_order_list_grid_columns_delivery_address %} <template #column-deliveries.id="{ item }"> <template v-if="getDelivery(item) && getDelivery(item).shippingOrderAddress"> <div v-tooltip="{ showDelay: 300, width: 400, disabled: item.deliveries.length <= 1, message: deliveryTooltip(item.deliveries) }" class="sw-order-list__delivery_address" > <span v-if="getDelivery(item).shippingOrderAddress.company">{{ getDelivery(item).shippingOrderAddress.company }}<span v-if="getDelivery(item).shippingOrderAddress.department"> - {{ getDelivery(item).shippingOrderAddress.department }}</span>,</span> {{ getDelivery(item).shippingOrderAddress.street }}, {{ getDelivery(item).shippingOrderAddress.zipcode }} {{ getDelivery(item).shippingOrderAddress.city }} </div> </template> </template> {% endblock %} {% block sw_order_list_grid_columns_amount %} <template #column-amountTotal="{ item }"> {{ currencyFilter(item.amountTotal, item.currency.isoCode) }} </template> {% endblock %} {% block sw_order_list_grid_columns_state %} <template #column-stateMachineState.name="{ item }"> <div class="sw-order-list__state" > <sw-color-badge :color="getVariantFromOrderState(item)" rounded /> {{ item.stateMachineState.translated.name }} </div> </template> {% endblock %} {% block sw_order_list_grid_columns_transaction_state %} <template #column-transactions.last().stateMachineState.name="{ item }"> <div v-if="item.transactions && item.transactions[0]" class="sw-order-list__state" > <sw-color-badge v-if="item.transactions && item.transactions[0]" :color="getVariantFromPaymentState(item)" rounded /> {{ transaction(item).stateMachineState.translated.name }} </div> </template> {% endblock %} {% block sw_order_list_grid_columns_delivery_state %} <template #column-deliveries[0].stateMachineState.name="{ item }"> <div v-if="getDelivery(item)" class="sw-order-list__state" > <sw-color-badge v-if="getDelivery(item)" :color="getVariantFromDeliveryState(item)" rounded /> {{ getDelivery(item).stateMachineState.translated.name }} </div> </template> {% endblock %} {% block sw_order_list_grid_columns_order_date %} <template #column-orderDateTime="{ item }"> <sw-time-ago :date="item.orderDateTime" /> </template> {% endblock %} {% endblock %} {% block sw_order_list_grid_columns_actions %} <template #actions="{ item }"> {% block sw_order_list_grid_columns_actions_view %} <sw-context-menu-item class="sw-order-list__order-view-action" :router-link="{ name: 'sw.order.detail', params: { id: item.id } }" > {{ $tc('sw-order.list.contextMenuView') }} </sw-context-menu-item> {% endblock %} {% block sw_order_list_grid_columns_actions_delete %} <sw-context-menu-item variant="danger" :disabled="disableDeletion(item)" @click="onDelete(item.id)" > {{ $tc('sw-order.list.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_order_list_grid_action_modals %} <template #action-modals="{ item }"> {% block sw_order_list_delete_modal %} <sw-modal v-if="showDeleteModal === item.id" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_order_list_delete_modal_confirm_delete_text %} <p class="sw-order-list__confirm-delete-text"> {{ $tc('sw-order.list.textDeleteConfirm', { orderNumber: \`\${item.orderNumber}\` }, 0) }} </p> {% endblock %} {% block sw_order_list_delete_modal_footer %} <template #modal-footer> {% block sw_order_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_order_list_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmDelete(item.id)" > {{ $tc('sw-order.list.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> {% endblock %} <template #pagination> {% block sw_order_list_grid_pagination %} <sw-pagination :page="page" :limit="limit" :total="total" :total-visible="7" @page-change="onPageChange" /> {% endblock %} </template> {% block sw_order_list_bulk_selected_actions_content %} <template #bulk> {% block sw_order_list_bulk_selected_actions_content_bulk_edit %} <a v-if="acl.can('order.editor')" class="link link-primary" role="link" tabindex="0" @click="showBulkEditModal = true" @keydown.enter="showBulkEditModal = true" > {{ $tc('global.sw-bulk-edit-modal.bulkEdit') }} </a> {% endblock %} </template> {% endblock %} {% block sw_order_list_bulk_edit_modal %} <template #bulk-modals="{ selection }"> {% block sw_order_list_bulk_edit_modal_inner %} <sw-bulk-edit-modal v-if="showBulkEditModal" ref="bulkEditModal" class="sw-order-bulk-edit-modal" :selection="selection" :bulk-grid-edit-columns="orderColumns" @edit-items="onBulkEditItems" @modal-close="showBulkEditModal = false" > {% block sw_order_list_bulk_edit_grid_columns_order_number %} <template #column-orderNumber="{ item }"> {% block sw_order_list_bulk_edit_grid_order_number_link %} <router-link :to="{ name: 'sw.order.detail', params: { id: item.id } }" target="_blank" rel="noreferrer noopener" > {{ item.orderNumber }} </router-link> {% endblock %} {% block sw_order_list_bulk_edit_grid_label_manual_order %} <sw-label v-if="item.createdById" appearance="pill" size="small" class="sw-order-bulk_edit__manual-order-label" > {{ $tc('sw-order.list.labelManualOrder') }} </sw-label> {% endblock %} </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_customer_name %} <template #column-orderCustomer.firstName="{ item }"> <router-link v-if="item.orderCustomer" :to="{ name: 'sw.customer.detail', params: { id: item.orderCustomer.customerId } }" target="_blank" rel="noreferrer noopener" > {{ item.orderCustomer.lastName }}, {{ item.orderCustomer.firstName }} </router-link> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_billing_address %} <template #column-billingAddressId="{ item }"> {{ item.billingAddress.street }}, {{ item.billingAddress.zipcode }} {{ item.billingAddress.city }} </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_amount %} <template #column-amountTotal="{ item }"> {{ currencyFilter(item.amountTotal, item.currency.isoCode) }} </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_state %} <template #column-stateMachineState.name="{ item }"> <sw-label :variant="getVariantFromOrderState(item)" appearance="pill" > {{ item.stateMachineState.translated.name }} </sw-label> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_transaction_state %} <template #column-transactions.last().stateMachineState.name="{ item }"> <sw-label v-if="item.transactions && item.transactions[0]" :variant="getVariantFromPaymentState(item)" appearance="pill" > {{ transaction(item).stateMachineState.translated.name }} </sw-label> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_delivery_state %} <template #column-getDelivery(item).stateMachineState.name="{ item }"> <sw-label v-if="getDelivery(item)" :variant="getVariantFromDeliveryState(item)" appearance="pill" > {{ getDelivery(item).stateMachineState.translated.name }} </sw-label> </template> {% endblock %} {% block sw_order_list_bulk_edit_grid_columns_order_date %} <template #column-orderDateTime="{ item }"> <sw-time-ago :date="item.orderDateTime" /> </template> {% endblock %} </sw-bulk-edit-modal> {% endblock %} </template> {% endblock %} </sw-data-grid> {% endblock %} {% block sw_order_list_empty_state %} <template v-if="!isLoading && !total"> <sw-empty-state v-if="filterCriteria.length || isValidTerm(term)" :title="$tc('sw-empty-state.messageNoResultTitle')" > <template #icon> <img :src="assetFilter('/administration/administration/static/img/empty-states/order-empty-state.svg')" :alt="$tc('sw-empty-state.messageNoResultTitle')" > </template> <template #default> {{ $tc('sw-empty-state.messageNoResultSublineBefore') }} <router-link class="sw-empty-state__description-link" :to="{ name: 'sw.profile.index.searchPreferences' }" > {{ $tc('sw-empty-state.messageNoResultSublineLink') }} </router-link> {{ $tc('sw-empty-state.messageNoResultSublineAfter') }} </template> </sw-empty-state> <sw-empty-state v-else :title="$tc('sw-order.list.messageEmpty')" > <template #icon> <img :src="assetFilter('/administration/administration/static/img/empty-states/order-empty-state.svg')" :alt="$tc('sw-order.list.messageEmpty')" > </template> </sw-empty-state> </template> {% endblock %} </div> {% endblock %} </template> {% block sw_order_list_sidebar %} <template #sidebar> <sw-sidebar class="sw-order-list__sidebar"> {% block sw_order_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-order.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} {% block sw_order_list_sidebar_filter %} <sw-sidebar-filter-panel entity="order" :store-key="storeKey" :filters="listFilters" :defaults="defaultFilters" :active-filter-number="activeFilterNumber" @criteria-changed="updateCriteria" /> {% endblock %} </sw-sidebar> </template> {% endblock %} {% endblock %} </sw-page> {% endblock %}`,{Mixin:o}=Shopware,{Criteria:r}=Shopware.Data,d={template:s,inject:["repositoryFactory","stateStyleDataProviderService","acl","filterFactory","feature"],mixins:[o.getByName("listing")],data(){return{orders:[],sortBy:"orderDateTime",sortDirection:"DESC",isLoading:!1,filterLoading:!1,showDeleteModal:!1,filterCriteria:[],defaultFilters:["order-number-filter","customer-number-filter","affiliate-code-filter","campaign-code-filter","promotion-code-filter","document-filter","order-date-filter","order-value-filter","status-filter","payment-status-filter","delivery-status-filter","payment-method-filter","shipping-method-filter","sales-channel-filter","billing-country-filter","customer-group-filter","shipping-country-filter","customer-group-filter","tag-filter","line-item-filter"],storeKey:"grid.filter.order",activeFilterNumber:0,showBulkEditModal:!1,searchConfigEntity:"order"}},metaInfo(){return{title:this.$createTitle()}},computed:{orderRepository(){return this.repositoryFactory.create("order")},orderColumns(){return this.getOrderColumns()},orderCriteria(){const e=new r(this.page,this.limit);return e.setTerm(this.term),this.sortBy.split(",").forEach(t=>{e.addSorting(r.sort(t,this.sortDirection))}),this.filterCriteria.forEach(t=>{e.addFilter(t)}),e.addAssociation("addresses"),e.addAssociation("billingAddress"),e.addAssociation("salesChannel"),e.addAssociation("orderCustomer"),e.addAssociation("currency"),e.addAssociation("documents"),e.addAssociation("stateMachineState"),e.getAssociation("transactions").addAssociation("stateMachineState").addSorting(r.sort("createdAt")),e.addAssociation("primaryOrderTransaction").addAssociation("primaryOrderTransaction.paymentMethod").addAssociation("primaryOrderTransaction.stateMachineState").addAssociation("primaryOrderDelivery.shippingMethod").addAssociation("primaryOrderDelivery.stateMachineState").addAssociation("primaryOrderDelivery.shippingOrderAddress.country").addSorting(r.sort("shippingCosts.unitPrice","DESC")),Shopware.Feature.isActive("v6.8.0.0")||e.getAssociation("deliveries").addAssociation("stateMachineState").addAssociation("shippingOrderAddress").addAssociation("shippingMethod").addSorting(r.sort("shippingCosts.unitPrice","DESC")),e},filterSelectCriteria(){const e=new r(1,1);return e.addAggregation(r.terms("affiliateCodes","affiliateCode",null,null,null)),e.addAggregation(r.terms("campaignCodes","campaignCode",null,null,null)),e.addAggregation(r.terms("promotionCodes","lineItems.payload.code",null,null,null)),e},listFilterOptions(){return{"order-number-filter":{property:"orderNumber",type:"string-filter",label:this.$tc("sw-order.filters.orderNumberFilter.label"),placeholder:this.$tc("sw-order.filters.orderNumberFilter.placeholder"),valueProperty:"key",labelProperty:"key",criteriaFilterType:"equalsAny"},"sales-channel-filter":{property:"salesChannel",label:this.$tc("sw-order.filters.salesChannelFilter.label"),placeholder:this.$tc("sw-order.filters.salesChannelFilter.placeholder")},"order-value-filter":{property:"amountTotal",type:"number-filter",label:this.$tc("sw-order.filters.orderValueFilter.label"),fromFieldLabel:null,toFieldLabel:null,fromPlaceholder:this.$tc("global.default.from"),toPlaceholder:this.$tc("global.default.to")},"payment-status-filter":{property:"primaryOrderTransaction.stateMachineState",criteria:this.getStatusCriteria("order_transaction.state"),label:this.$tc("sw-order.filters.paymentStatusFilter.label"),placeholder:this.$tc("sw-order.filters.paymentStatusFilter.placeholder")},"delivery-status-filter":{property:"primaryOrderDelivery.stateMachineState",criteria:this.getStatusCriteria("order_delivery.state"),label:this.$tc("sw-order.filters.deliveryStatusFilter.label"),placeholder:this.$tc("sw-order.filters.deliveryStatusFilter.placeholder")},"status-filter":{property:"stateMachineState",criteria:this.getStatusCriteria("order.state"),label:this.$tc("sw-order.filters.statusFilter.label"),placeholder:this.$tc("sw-order.filters.statusFilter.placeholder")},"order-date-filter":{property:"orderDateTime",label:this.$tc("sw-order.filters.orderDateFilter.label"),dateType:"date",fromFieldLabel:null,toFieldLabel:null,showTimeframe:!0},"customer-number-filter":{property:"orderCustomer.customer.customerNumber",type:"string-filter",label:this.$tc("sw-order.filters.customerNumberFilter.label"),placeholder:this.$tc("sw-order.filters.customerNumberFilter.placeholder"),valueProperty:"key",labelProperty:"key",criteriaFilterType:"equals"},"tag-filter":{property:"tags",label:this.$tc("sw-order.filters.tagFilter.label"),placeholder:this.$tc("sw-order.filters.tagFilter.placeholder")},"affiliate-code-filter":{property:"affiliateCode",type:"string-filter",label:this.$tc("sw-order.filters.affiliateCodeFilter.label"),placeholder:this.$tc("sw-order.filters.affiliateCodeFilter.placeholder"),valueProperty:"key",labelProperty:"key"},"campaign-code-filter":{property:"campaignCode",type:"string-filter",label:this.$tc("sw-order.filters.campaignCodeFilter.label"),placeholder:this.$tc("sw-order.filters.campaignCodeFilter.placeholder"),valueProperty:"key",labelProperty:"key"},"promotion-code-filter":{property:"lineItems.payload.code",type:"string-filter",label:this.$tc("sw-order.filters.promotionCodeFilter.label"),placeholder:this.$tc("sw-order.filters.promotionCodeFilter.placeholder"),valueProperty:"key",labelProperty:"key"},"document-filter":{property:"documents",label:this.$tc("sw-order.filters.documentFilter.label"),placeholder:this.$tc("sw-order.filters.documentFilter.placeholder"),optionHasCriteria:this.$tc("sw-order.filters.documentFilter.textHasCriteria"),optionNoCriteria:this.$tc("sw-order.filters.documentFilter.textNoCriteria")},"payment-method-filter":{property:"transactions.paymentMethod",label:this.$tc("sw-order.filters.paymentMethodFilter.label"),placeholder:this.$tc("sw-order.filters.paymentMethodFilter.placeholder")},"shipping-method-filter":{property:"deliveries.shippingMethod",label:this.$tc("sw-order.filters.shippingMethodFilter.label"),placeholder:this.$tc("sw-order.filters.shippingMethodFilter.placeholder")},"billing-country-filter":{property:"billingAddress.country",label:this.$tc("sw-order.filters.billingCountryFilter.label"),placeholder:this.$tc("sw-order.filters.billingCountryFilter.placeholder")},"shipping-country-filter":{property:"deliveries.shippingOrderAddress.country",label:this.$tc("sw-order.filters.shippingCountryFilter.label"),placeholder:this.$tc("sw-order.filters.shippingCountryFilter.placeholder")},"customer-group-filter":{property:"orderCustomer.customer.group",label:this.$tc("sw-order.filters.customerGroupFilter.label"),placeholder:this.$tc("sw-order.filters.customerGroupFilter.placeholder")},"line-item-filter":{property:"lineItems.product",label:this.$tc("sw-order.filters.productFilter.label"),placeholder:this.$tc("sw-order.filters.productFilter.placeholder"),criteria:this.productCriteria,displayVariants:!0}}},listFilters(){return this.filterFactory.create("order",this.listFilterOptions)},productCriteria(){const e=new r(1,25);return e.addAssociation("options.group"),e},currencyFilter(){return Shopware.Filter.getByName("currency")},dateFilter(){return Shopware.Filter.getByName("date")},assetFilter(){return Shopware.Filter.getByName("asset")}},watch:{orderCriteria:{handler(){this.getList()},deep:!0}},created(){this.createdComponent()},methods:{createdComponent(){},deliveryTooltip(e){return e.map(t=>`${t.shippingOrderAddress.street},
                        ${t.shippingOrderAddress.zipcode}
                        ${t.shippingOrderAddress.city}`).join('<hr style="margin: 8px 0">')},onEdit(e){e!=null&&e.id&&this.$router.push({name:"sw.order.detail",params:{id:e.id}})},onInlineEditSave(e){e.save()},onChangeLanguage(){this.getList()},async getList(){this.isLoading=!0;let e=await Shopware.Service("filterService").mergeWithStoredFilters(this.storeKey,this.orderCriteria);if(e=await this.addQueryScores(this.term,e),this.activeFilterNumber=e.filters.length,!this.entitySearchable){this.isLoading=!1,this.total=0;return}this.freshSearchTerm&&e.resetSorting();try{const t=await this.orderRepository.search(e);this.total=t.total,this.orders=t,this.isLoading=!1}catch{this.isLoading=!1}},getBillingAddress(e){return e.addresses.find(t=>t.id===e.billingAddressId)},disableDeletion(e){return this.acl.can("order.deleter")?e.documents.length>0:!0},getOrderColumns(){return[{property:"orderNumber",label:"sw-order.list.columnOrderNumber",routerLink:"sw.order.detail",allowResize:!0,primary:!0},{property:"salesChannel.name",label:"sw-order.list.columnSalesChannel",allowResize:!0,visible:!1},{property:"orderCustomer.firstName",dataIndex:"orderCustomer.lastName,orderCustomer.firstName",label:"sw-order.list.columnCustomerName",allowResize:!0},{property:"orderCustomer.company",dataIndex:"orderCustomer.company",label:"sw-order.list.columnCustomerCompany",allowResize:!0,visible:!1},{property:"billingAddressId",dataIndex:"billingAddress.street",label:"sw-order.list.columnBillingAddress",allowResize:!0,visible:!1},{property:"deliveries.id",dataIndex:"deliveries.shippingOrderAddress.street",label:"sw-order.list.columnDeliveryAddress",allowResize:!0},{property:"amountTotal",label:"sw-order.list.columnAmount",align:"right",allowResize:!0},{property:"stateMachineState.name",label:"sw-order.list.columnState",allowResize:!0},{property:"transactions.last().stateMachineState.name",dataIndex:"transactions.stateMachineState.name",label:"sw-order.list.columnTransactionState",allowResize:!0},{property:"deliveries[0].stateMachineState.name",dataIndex:"deliveries.stateMachineState.name",label:"sw-order.list.columnDeliveryState",allowResize:!0},{property:"orderDateTime",label:"sw-order.list.orderDate",allowResize:!0},{property:"affiliateCode",inlineEdit:"string",label:"sw-order.list.columnAffiliateCode",allowResize:!0,visible:!1},{property:"campaignCode",inlineEdit:"string",label:"sw-order.list.columnCampaignCode",allowResize:!0,visible:!1}]},getVariantFromOrderState(e){return this.stateStyleDataProviderService.getStyle("order.state",e.stateMachineState.technicalName).colorCode},getVariantFromPaymentState(e){var a;let t=(a=e.primaryOrderTransaction)==null?void 0:a.stateMachineState.technicalName;Shopware.Feature.isActive("v6.8.0.0")||(t=e.transactions.last().stateMachineState.technicalName);for(let i=0;i<e.transactions.length;i+=1)if(!["cancelled","failed"].includes(e.transactions[i].stateMachineState.technicalName)){t=e.transactions[i].stateMachineState.technicalName;break}return this.stateStyleDataProviderService.getStyle("order_transaction.state",t).colorCode},getVariantFromDeliveryState(e){return this.stateStyleDataProviderService.getStyle("order_delivery.state",this.getDelivery(e).stateMachineState.technicalName).colorCode},onDelete(e){this.showDeleteModal=e},onCloseDeleteModal(){this.showDeleteModal=!1},onConfirmDelete(e){return this.showDeleteModal=!1,this.orderRepository.delete(e).then(()=>{this.$refs.orderGrid.resetSelection(),this.getList()})},updateCriteria(e){this.page=1,this.filterCriteria=e},getStatusCriteria(e){const t=new r(1,25);return t.addFilter(r.equals("stateMachine.technicalName",e)),t},async onBulkEditItems(){await this.$nextTick();const t=Object.values(this.$refs.orderGrid.selection).filter(l=>!this.getDelivery(l)).length>0?"1":"0";this.$router.push({name:"sw.bulk.edit.order",params:{excludeDelivery:t}})},transaction(e){for(let t=0;t<e.transactions.length;t+=1)if(!["cancelled","failed"].includes(e.transactions[t].stateMachineState.technicalName))return e.transactions[t];return Shopware.Feature.isActive("v6.8.0.0")?e.primaryOrderTransaction:e.transactions.last()},getDelivery(e){return Shopware.Feature.isActive("v6.8.0.0")?e.primaryOrderDelivery:e.deliveries[0]}}};export{d as default};
