const a=`{% block sw_app_app_url_changed_modal %} <sw-modal class="sw-app-app-url-changed-modal" variant="large" :title="$tc('sw-app.component.sw-app-app-url-changed-modal.title')" :is-loading="isLoading" @modal-close="closeModal" > <template #default> {% block sw_app_app_url_changed_modal_content %} {% block sw_app_app_url_changed_modal_content_description %} <div class="sw-app-app-url-changed-modal__content-description"> <h3>{{ $tc('sw-app.component.sw-app-app-url-changed-modal.explanationHeader') }}</h3> <div class="sw-app-app-url-changed-modal__content-description-change"> <span> <b> {{ $tc('sw-app.component.sw-app-app-url-changed-modal.oldLabel') }} </b> {{ urlDiff.oldUrl }} </span> <br> <span> <b> {{ $tc('sw-app.component.sw-app-app-url-changed-modal.newLabel') }} </b> {{ urlDiff.newUrl }} </span> </div> {% block sw_app_app_url_changed_modal_description_explanation %} {{ $tc('sw-app.component.sw-app-app-url-changed-modal.explanation') }} {% endblock %} </div> {% endblock %} {% block sw_app_app_url_changed_modal_content_strategies %} <div class="sw-app-app-url-changed-modal__content-choices"> <template v-for="(strategy, index) in strategies" :key="\`content-strategies-\${index}\`" > <mt-button class="sw-app-app-url-changed-modal__button-strategy" :class="getActiveStyle(strategy)" variant="secondary" @click="setSelectedStrategy(strategy)" > <div class="sw-app-app-url-changed-modal__content-migration-strategy"> <template v-if="isSelected(strategy)"> <mt-icon size="1rem" color="var(--color-icon-brand-default)" name="regular-circle-xxs" /> <mt-icon size="1rem" color="var(--color-elevation-surface-raised)" name="regular-circle" /> </template> <mt-icon v-else size="1rem" name="regular-circle" /> <span class="sw-app-app-url-changed-modal__content-choices-label"> {{ getStrategyLabel(strategy) }} </span> <span class="sw-app-app-url-changed-modal__content-choices-description"> {{ getStrategyDescription(strategy) }} </span> </div> </mt-button> </template> </div> {% endblock %} {% endblock %} </template> <template #modal-footer> <mt-button variant="secondary" @click="closeModal" > {{ $tc('global.default.cancel') }} </mt-button> <mt-button variant="primary" @click="confirm" > {{ $tc('sw-app.component.sw-app-app-url-changed-modal.confirmation') }} </mt-button> </template> </sw-modal> {% endblock %}`,t={template:a,inject:["appUrlChangeService"],emits:["modal-close"],mixins:[Shopware.Mixin.getByName("notification")],props:{urlDiff:{type:Object,required:!0}},data(){return{strategies:[],selectedStrategy:null,isLoading:!0}},created(){this.appUrlChangeService.fetchResolverStrategies().then(e=>{this.strategies=e,this.selectedStrategy=e[0]}).then(()=>{this.isLoading=!1})},methods:{closeModal(){this.$emit("modal-close")},setSelectedStrategy(e){this.selectedStrategy=e},isSelected({name:e}){return!!this.selectedStrategy&&this.selectedStrategy.name===e},getStrategyLabel({name:e}){return this.$tc(`sw-app.component.sw-app-app-url-changed-modal.${e}.name`)},getStrategyDescription({name:e}){return this.$tc(`sw-app.component.sw-app-app-url-changed-modal.${e}.description`)},getActiveStyle({name:e}){return{"sw-app-app-url-changed-modal__button-strategy--active":e===this.selectedStrategy.name}},async confirm(){try{await this.appUrlChangeService.resolveUrlChange(this.selectedStrategy),this.createNotificationSuccess({message:this.$tc("sw-app.component.sw-app-app-url-changed-modal.success")}),window.location.reload()}catch{this.createNotificationError({message:this.$tc("sw-app.component.sw-app-app-url-changed-modal.error")})}}}};export{t as default};
