<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelistsenum;

/**
 * Class representing the Currency Codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
enum ZugferdCurrencyCodes: string
{

    /**
     * UAE Dirham
     */
    case UAE_DIRHAM = "AED";

    /**
     * Afghani
     */
    case AFGHANI = "AFN";

    /**
     * Lek
     */
    case LEK = "ALL";

    /**
     * Armenian Dram
     */
    case ARMENIAN_DRAM = "AMD";

    /**
     * Netherlands Antillean Guilder
     */
    case NETHERLANDS_ANTILLEAN_GUILDER = "ANG";

    /**
     * Kwanza
     */
    case KWANZA = "AOA";

    /**
     * Argentine Peso
     */
    case ARGENTINE_PESO = "ARS";

    /**
     * Australian Dollar
     */
    case AUSTRALIAN_DOLLAR = "AUD";

    /**
     * Aruban Florin
     */
    case ARUBAN_FLORIN = "AWG";

    /**
     * Azerbaijan Manat
     */
    case AZERBAIJAN_MANAT = "AZN";

    /**
     * Convertible Mark
     */
    case CONVERTIBLE_MARK = "BAM";

    /**
     * Barbados Dollar
     */
    case BARBADOS_DOLLAR = "BBD";

    /**
     * Taka
     */
    case TAKA = "BDT";

    /**
     * Bulgarian Lev
     */
    case BULGARIAN_LEV = "BGN";

    /**
     * Bahraini Dinar
     */
    case BAHRAINI_DINAR = "BHD";

    /**
     * Burundi Franc
     */
    case BURUNDI_FRANC = "BIF";

    /**
     * Bermudian Dollar
     */
    case BERMUDIAN_DOLLAR = "BMD";

    /**
     * Brunei Dollar
     */
    case BRUNEI_DOLLAR = "BND";

    /**
     * Boliviano
     */
    case BOLIVIANO = "BOB";

    /**
     * Mvdol
     */
    case MVDOL = "BOV";

    /**
     * Brazilian Real
     */
    case BRAZILIAN_REAL = "BRL";

    /**
     * Bahamian Dollar
     */
    case BAHAMIAN_DOLLAR = "BSD";

    /**
     * Ngultrum
     */
    case NGULTRUM = "BTN";

    /**
     * Pula
     */
    case PULA = "BWP";

    /**
     * Belarusian Ruble
     */
    case BELARUSIAN_RUBLE = "BYN";

    /**
     * Belize Dollar
     */
    case BELIZE_DOLLAR = "BZD";

    /**
     * Canadian Dollar
     */
    case CANADIAN_DOLLAR = "CAD";

    /**
     * Congolese Franc
     */
    case CONGOLESE_FRANC = "CDF";

    /**
     * WIR Euro
     */
    case WIR_EURO = "CHE";

    /**
     * Swiss Franc
     */
    case SWISS_FRANC = "CHF";

    /**
     * WIR Franc
     */
    case WIR_FRANC = "CHW";

    /**
     * Unidad de Fomento
     */
    case UNIDAD_DE_FOMENTO = "CLF";

    /**
     * Chilean Peso
     */
    case CHILEAN_PESO = "CLP";

    /**
     * Yuan Renminbi
     */
    case YUAN_RENMINBI = "CNY";

    /**
     * Colombian Peso
     */
    case COLOMBIAN_PESO = "COP";

    /**
     * Unidad de Valor Real
     */
    case UNIDAD_DE_VALOR_REAL = "COU";

    /**
     * Costa Rican Colon
     */
    case COSTA_RICAN_COLON = "CRC";

    /**
     * Peso Convertible
     */
    case PESO_CONVERTIBLE = "CUC";

    /**
     * Cuban Peso
     */
    case CUBAN_PESO = "CUP";

    /**
     * Cabo Verde Escudo
     */
    case CABO_VERDE_ESCUDO = "CVE";

    /**
     * Czech Koruna
     */
    case CZECH_KORUNA = "CZK";

    /**
     * Djibouti Franc
     */
    case DJIBOUTI_FRANC = "DJF";

    /**
     * Danish Krone
     */
    case DANISH_KRONE = "DKK";

    /**
     * Dominican Peso
     */
    case DOMINICAN_PESO = "DOP";

    /**
     * Algerian Dinar
     */
    case ALGERIAN_DINAR = "DZD";

    /**
     * Egyptian Pound
     */
    case EGYPTIAN_POUND = "EGP";

    /**
     * Nakfa
     */
    case NAKFA = "ERN";

    /**
     * Ethiopian Birr
     */
    case ETHIOPIAN_BIRR = "ETB";

    /**
     * Euro
     */
    case EURO = "EUR";

    /**
     * Fiji Dollar
     */
    case FIJI_DOLLAR = "FJD";

    /**
     * Falkland Islands Pound
     */
    case FALKLAND_ISLANDS_POUND = "FKP";

    /**
     * Pound Sterling
     */
    case POUND_STERLING = "GBP";

    /**
     * Lari
     */
    case LARI = "GEL";

    /**
     * Ghana Cedi
     */
    case GHANA_CEDI = "GHS";

    /**
     * Gibraltar Pound
     */
    case GIBRALTAR_POUND = "GIP";

    /**
     * Dalasi
     */
    case DALASI = "GMD";

    /**
     * Guinean Franc
     */
    case GUINEAN_FRANC = "GNF";

    /**
     * Quetzal
     */
    case QUETZAL = "GTQ";

    /**
     * Guyana Dollar
     */
    case GUYANA_DOLLAR = "GYD";

    /**
     * Hong Kong Dollar
     */
    case HONG_KONG_DOLLAR = "HKD";

    /**
     * Lempira
     */
    case LEMPIRA = "HNL";

    /**
     * Kuna
     */
    case KUNA = "HRK";

    /**
     * Gourde
     */
    case GOURDE = "HTG";

    /**
     * Forint
     */
    case FORINT = "HUF";

    /**
     * Rupiah
     */
    case RUPIAH = "IDR";

    /**
     * New Israeli Sheqel
     */
    case NEW_ISRAELI_SHEQEL = "ILS";

    /**
     * Indian Rupee
     */
    case INDIAN_RUPEE = "INR";

    /**
     * Iraqi Dinar
     */
    case IRAQI_DINAR = "IQD";

    /**
     * Iranian Rial
     */
    case IRANIAN_RIAL = "IRR";

    /**
     * Iceland Krona
     */
    case ICELAND_KRONA = "ISK";

    /**
     * Jamaican Dollar
     */
    case JAMAICAN_DOLLAR = "JMD";

    /**
     * Jordanian Dinar
     */
    case JORDANIAN_DINAR = "JOD";

    /**
     * Yen
     */
    case YEN = "JPY";

    /**
     * Kenyan Shilling
     */
    case KENYAN_SHILLING = "KES";

    /**
     * Som
     */
    case SOM = "KGS";

    /**
     * Riel
     */
    case RIEL = "KHR";

    /**
     * Comorian Franc
     */
    case COMORIAN_FRANC = "KMF";

    /**
     * North Korean Won
     */
    case NORTH_KOREAN_WON = "KPW";

    /**
     * Won
     */
    case WON = "KRW";

    /**
     * Kuwaiti Dinar
     */
    case KUWAITI_DINAR = "KWD";

    /**
     * Cayman Islands Dollar
     */
    case CAYMAN_ISLANDS_DOLLAR = "KYD";

    /**
     * Tenge
     */
    case TENGE = "KZT";

    /**
     * Lao Kip
     */
    case LAO_KIP = "LAK";

    /**
     * Lebanese Pound
     */
    case LEBANESE_POUND = "LBP";

    /**
     * Sri Lanka Rupee
     */
    case SRI_LANKA_RUPEE = "LKR";

    /**
     * Liberian Dollar
     */
    case LIBERIAN_DOLLAR = "LRD";

    /**
     * Loti
     */
    case LOTI = "LSL";

    /**
     * Libyan Dinar
     */
    case LIBYAN_DINAR = "LYD";

    /**
     * Moroccan Dirham
     */
    case MOROCCAN_DIRHAM = "MAD";

    /**
     * Moldovan Leu
     */
    case MOLDOVAN_LEU = "MDL";

    /**
     * Malagasy Ariary
     */
    case MALAGASY_ARIARY = "MGA";

    /**
     * Denar
     */
    case DENAR = "MKD";

    /**
     * Kyat
     */
    case KYAT = "MMK";

    /**
     * Tugrik
     */
    case TUGRIK = "MNT";

    /**
     * Pataca
     */
    case PATACA = "MOP";

    /**
     * Ouguiya
     */
    case OUGUIYA = "MRU";

    /**
     * Mauritius Rupee
     */
    case MAURITIUS_RUPEE = "MUR";

    /**
     * Rufiyaa
     */
    case RUFIYAA = "MVR";

    /**
     * Malawi Kwacha
     */
    case MALAWI_KWACHA = "MWK";

    /**
     * Mexican Peso
     */
    case MEXICAN_PESO = "MXN";

    /**
     * Mexican Unidad de Inversion (UDI)
     */
    case MEXICAN_UNIDAD_DE_INVERSION_UDI = "MXV";

    /**
     * Malaysian Ringgit
     */
    case MALAYSIAN_RINGGIT = "MYR";

    /**
     * Mozambique Metical
     */
    case MOZAMBIQUE_METICAL = "MZN";

    /**
     * Namibia Dollar
     */
    case NAMIBIA_DOLLAR = "NAD";

    /**
     * Naira
     */
    case NAIRA = "NGN";

    /**
     * Cordoba Oro
     */
    case CORDOBA_ORO = "NIO";

    /**
     * Norwegian Krone
     */
    case NORWEGIAN_KRONE = "NOK";

    /**
     * Nepalese Rupee
     */
    case NEPALESE_RUPEE = "NPR";

    /**
     * New Zealand Dollar
     */
    case NEW_ZEALAND_DOLLAR = "NZD";

    /**
     * Rial Omani
     */
    case RIAL_OMANI = "OMR";

    /**
     * Balboa
     */
    case BALBOA = "PAB";

    /**
     * Sol
     */
    case SOL = "PEN";

    /**
     * Kina
     */
    case KINA = "PGK";

    /**
     * Philippine Peso
     */
    case PHILIPPINE_PESO = "PHP";

    /**
     * Pakistan Rupee
     */
    case PAKISTAN_RUPEE = "PKR";

    /**
     * Zloty
     */
    case ZLOTY = "PLN";

    /**
     * Guarani
     */
    case GUARANI = "PYG";

    /**
     * Qatari Rial
     */
    case QATARI_RIAL = "QAR";

    /**
     * Romanian Leu
     */
    case ROMANIAN_LEU = "RON";

    /**
     * Serbian Dinar
     */
    case SERBIAN_DINAR = "RSD";

    /**
     * Russian Ruble
     */
    case RUSSIAN_RUBLE = "RUB";

    /**
     * Rwanda Franc
     */
    case RWANDA_FRANC = "RWF";

    /**
     * Saudi Riyal
     */
    case SAUDI_RIYAL = "SAR";

    /**
     * Solomon Islands Dollar
     */
    case SOLOMON_ISLANDS_DOLLAR = "SBD";

    /**
     * Seychelles Rupee
     */
    case SEYCHELLES_RUPEE = "SCR";

    /**
     * Sudanese Pound
     */
    case SUDANESE_POUND = "SDG";

    /**
     * Swedish Krona
     */
    case SWEDISH_KRONA = "SEK";

    /**
     * Singapore Dollar
     */
    case SINGAPORE_DOLLAR = "SGD";

    /**
     * Saint Helena Pound
     */
    case SAINT_HELENA_POUND = "SHP";

    /**
     * Leone
     */
    case LEONE = "SLL";

    /**
     * Somali Shilling
     */
    case SOMALI_SHILLING = "SOS";

    /**
     * Surinam Dollar
     */
    case SURINAM_DOLLAR = "SRD";

    /**
     * South Sudanese Pound
     */
    case SOUTH_SUDANESE_POUND = "SSP";

    /**
     * Dobra
     */
    case DOBRA = "STN";

    /**
     * El Salvador Colon
     */
    case EL_SALVADOR_COLON = "SVC";

    /**
     * Syrian Pound
     */
    case SYRIAN_POUND = "SYP";

    /**
     * Lilangeni
     */
    case LILANGENI = "SZL";

    /**
     * Baht
     */
    case BAHT = "THB";

    /**
     * Somoni
     */
    case SOMONI = "TJS";

    /**
     * Turkmenistan New Manat
     */
    case TURKMENISTAN_NEW_MANAT = "TMT";

    /**
     * Tunisian Dinar
     */
    case TUNISIAN_DINAR = "TND";

    /**
     * Pa’anga
     */
    case PAANGA = "TOP";

    /**
     * Turkish Lira
     */
    case TURKISH_LIRA = "TRY";

    /**
     * Trinidad and Tobago Dollar
     */
    case TRINIDAD_AND_TOBAGO_DOLLAR = "TTD";

    /**
     * New Taiwan Dollar
     */
    case NEW_TAIWAN_DOLLAR = "TWD";

    /**
     * Tanzanian Shilling
     */
    case TANZANIAN_SHILLING = "TZS";

    /**
     * Hryvnia
     */
    case HRYVNIA = "UAH";

    /**
     * Uganda Shilling
     */
    case UGANDA_SHILLING = "UGX";

    /**
     * US Dollar
     */
    case US_DOLLAR = "USD";

    /**
     * US Dollar (Next day)
     */
    case US_DOLLAR_NEXT_DAY = "USN";

    /**
     * Uruguay Peso en Unidades Indexadas (UI)
     */
    case URUGUAY_PESO_EN_UNIDADES_INDEXADAS_UI = "UYI";

    /**
     * Peso Uruguayo
     */
    case PESO_URUGUAYO = "UYU";

    /**
     * Unidad Previsional
     */
    case UNIDAD_PREVISIONAL = "UYW";

    /**
     * Uzbekistan Sum
     */
    case UZBEKISTAN_SUM = "UZS";

    /**
     * Bolívar Soberano
     */
    case BOLVAR_SOBERANO = "VES";

    /**
     * Dong
     */
    case DONG = "VND";

    /**
     * Vatu
     */
    case VATU = "VUV";

    /**
     * Tala
     */
    case TALA = "WST";

    /**
     * CFA Franc BEAC
     */
    case CFA_FRANC_BEAC = "XAF";

    /**
     * Silver
     */
    case SILVER = "XAG";

    /**
     * Gold
     */
    case GOLD = "XAU";

    /**
     * Bond Markets Unit European Composite Unit (EURCO)
     */
    case BOND_MARKETS_UNIT_EUROPEAN_COMPOSITE_UNIT_EURCO = "XBA";

    /**
     * Bond Markets Unit European Monetary Unit (E.M.U.-6)
     */
    case BOND_MARKETS_UNIT_EUROPEAN_MONETARY_UNIT_EMU6 = "XBB";

    /**
     * Bond Markets Unit European Unit of Account 9 (E.U.A.-9)
     */
    case BOND_MARKETS_UNIT_EUROPEAN_UNIT_OF_ACCOUNT_9_EUA9 = "XBC";

    /**
     * Bond Markets Unit European Unit of Account 17 (E.U.A.-17)
     */
    case BOND_MARKETS_UNIT_EUROPEAN_UNIT_OF_ACCOUNT_17_EUA17 = "XBD";

    /**
     * East Caribbean Dollar
     */
    case EAST_CARIBBEAN_DOLLAR = "XCD";

    /**
     * SDR (Special Drawing Right)
     */
    case SDR_SPECIAL_DRAWING_RIGHT = "XDR";

    /**
     * CFA Franc BCEAO
     */
    case CFA_FRANC_BCEAO = "XOF";

    /**
     * Palladium
     */
    case PALLADIUM = "XPD";

    /**
     * CFP Franc
     */
    case CFP_FRANC = "XPF";

    /**
     * Platinum
     */
    case PLATINUM = "XPT";

    /**
     * Sucre
     */
    case SUCRE = "XSU";

    /**
     * Codes specifically reserved for testing purposes
     */
    case CODES_SPECIFICALLY_RESERVED_FOR_TESTING_PURPOSES = "XTS";

    /**
     * ADB Unit of Account
     */
    case ADB_UNIT_OF_ACCOUNT = "XUA";

    /**
     * The codes assigned for transactions where no currency is involved
     */
    case THE_CODES_ASSIGNED_FOR_TRANSACTIONS_WHERE_NO_CURRENCY_IS_INVOLVED = "XXX";

    /**
     * Yemeni Rial
     */
    case YEMENI_RIAL = "YER";

    /**
     * Rand
     */
    case RAND = "ZAR";

    /**
     * Zambian Kwacha
     */
    case ZAMBIAN_KWACHA = "ZMW";

    /**
     * Zimbabwe Dollar
     */
    case ZIMBABWE_DOLLAR = "ZWL";
}
