const c=`{% block sw_sales_channel_detail_products %} <mt-card v-if="salesChannel && products" position-identifier="sw-sales-channel-detail-products" class="sw-sales-channel-detail-products" :is-loading="isLoading || undefined" > {% block sw_sales_channel_detail_products_filled_state %} <template v-if="products.length > 0 || searchTerm" #grid > {% block sw_sales_channel_detail_products_card_section %} <sw-container rows="auto 500px"> {% block sw_sales_channel_detail_products_card_section_secondary %} <sw-card-section secondary> <sw-container columns="1fr auto" gap="0 15px" > {% block sw_sales_channel_detail_products_card_section_secondary_input %} <sw-simple-search-field v-model:value="searchTerm" variant="form" size="small" @search-term-change="onChangeSearchTerm" /> {% endblock %} {% block sw_sales_channel_detail_products_card_section_secondary_button %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('sales_channel.editor'), showOnDisabledElements: true }" ghost size="small" :disabled="!acl.can('sales_channel.editor')" variant="secondary" @click="openAddProductsModal" > {{ $tc('sw-sales-channel.detail.products.buttonAddProducts', {}, 0) }} </mt-button> {% endblock %} </sw-container> </sw-card-section> {% endblock %} {% block sw_sales_channel_detail_products_card_section_primary %} <sw-card-section divider="top"> {% block sw_sales_channel_detail_products_card_section_primary_filled_state %} <sw-entity-listing v-if="products.length > 0" ref="entityListing" class="sw-sales-channel-detail-products__list" identifier="sw-sales-channel-detail-products-list" detail-route="sw.product.detail" :repository="productRepository" :items="products" :data-source="products" :columns="productColumns" :plain-appearance="true" :skeleton-item-amount="limit" :is-loading="isLoading" :allow-inline-edit="false" :allow-view="acl.can('sales_channel.viewer')" :allow-edit="acl.can('product.editor')" :allow-delete="acl.can('sales_channel.deleter')" :is-record-selectable="isProductRemovable" @selection-change="onProductSelectionChanged" > <template #selection-content="{ item, isSelected, isRecordSelectable, selectItem, itemIdentifierProperty }"> <slot v-bind="{ item, isSelected, isRecordSelectable, selectItem, itemIdentifierProperty }"> <div class="sw-data-grid__cell-content"> {% block sw_sales_channel_detail_products_listing_select_item_checkbox %} <mt-checkbox v-tooltip="{ message: $tc('sw-sales-channel.detail.products.inheritVariantNotRemovableTooltip'), disabled: isRecordSelectable(item), showOnDisabledElements: true }" :disabled="!isRecordSelectable(item)" :checked="isSelected(item[itemIdentifierProperty])" @update:checked="selectItem($event, item)" /> {% endblock %} </div> </slot> </template> <template #column-name="{ item }"> <slot v-bind="{ item }"> {% block sw_sales_channel_detail_products_listing_column_name %} <sw-product-variant-info :variations="item.variation" > <router-link :to="{ name: 'sw.product.detail', params: { id: item.id } }"> {{ item.translated.name || item.name }} </router-link> </sw-product-variant-info> {% endblock %} </slot> </template> <template #column-active="{ item }"> {% block sw_sales_channel_detail_products_listing_column_active %} <mt-icon size="16px" :name="item.active === false ? 'regular-times-s' : 'regular-checkmark-xs'" :color="item.active === false ? '#de294c' : '#37d046'" /> {% endblock %} </template> <template #pagination> {% block sw_sales_channel_detail_products_listing_pagination %} <sw-pagination v-bind="{ page, limit, total }" :total-visible="5" :auto-hide="false" @page-change="onChangePage" /> {% endblock %} </template> <template #delete-action="{ item }"> {% block sw_sales_channel_detail_products_listing_delete_action %} <sw-context-menu-item variant="warning" :disabled="!isProductRemovable(item)" @click="onDeleteProduct(item)" > {{ $tc('global.default.remove') }} </sw-context-menu-item> {% endblock %} </template> <template #bulk> {% block sw_sales_channel_detail_products_listing_bulk %} <a class="link link-warning" role="button" tabindex="0" @click="onDeleteProducts" @keydown.enter="onDeleteProducts" > {{ $tc('global.default.remove') }} </a> {% endblock %} </template> </sw-entity-listing> {% endblock %} {% block sw_sales_channel_detail_products_card_section_primary_empty_state %} <sw-empty-state v-else :show-description="false" :title="$tc('sw-sales-channel.detail.products.titleEmptyStateTable')" > <template #icon> {% block sw_sales_channel_detail_products_card_section_primary_image %} <img :src="assetFilter('/administration/administration/static/img/empty-states/products-empty-state.svg')" :alt="$tc('sw-sales-channel.detail.products.titleEmptyStateTable')" > {% endblock %} </template> </sw-empty-state> {% endblock %} </sw-card-section> {% endblock %} </sw-container> {% endblock %} </template> {% endblock %} {% block sw_sales_channel_detail_products_empty_state %} <sw-empty-state v-if="products.length <= 0 && !searchTerm && !isLoading" :show-description="false" :absolute="false" :title="$tc('sw-sales-channel.detail.products.titleEmptyState')" > <template #icon> {% block sw_sales_channel_detail_products_empty_state_image %} <img :src="assetFilter('/administration/administration/static/img/empty-states/products-empty-state.svg')" :alt="$tc('sw-sales-channel.detail.products.titleEmptyState')" > {% endblock %} </template> <template #actions> {% block sw_sales_channel_detail_products_empty_state_button %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('sales_channel.editor'), showOnDisabledElements: true }" ghost :disabled="!acl.can('sales_channel.editor')" variant="secondary" @click="openAddProductsModal" > {{ $tc('sw-sales-channel.detail.products.buttonAddProducts', {}, 0) }} </mt-button> {% endblock %} </template> </sw-empty-state> {% endblock %} {% block sw_sales_channel_detail_products_assignment_modal %} <sw-sales-channel-products-assignment-modal v-if="showProductsModal" :sales-channel="salesChannel" :is-assign-product-loading="isAssignProductLoading" @modal-close="showProductsModal = false" @products-add="onAddProducts" /> {% endblock %} </mt-card> {% endblock %}`,{Mixin:r,Context:l}=Shopware,{EntityCollection:d,Criteria:o}=Shopware.Data,p={template:c,inject:["repositoryFactory","feature","acl"],mixins:[r.getByName("notification")],props:{salesChannel:{type:Object,required:!1,default:()=>{}}},data(){return{products:[],productSelection:[],isLoading:!1,searchTerm:null,page:1,limit:25,total:0,showProductsModal:!1,isAssignProductLoading:!1}},computed:{productRepository(){return this.repositoryFactory.create("product")},productVisibilityRepository(){return this.repositoryFactory.create("product_visibility")},productCriteria(){const e=new o(this.page,this.limit);return e.setTotalCountMode(1),e.addAssociation("visibilities.salesChannel"),e.addAssociation("options.group"),e.addFilter(o.equals("product.visibilities.salesChannelId",this.salesChannel.id)),this.searchTerm&&e.setTerm(this.searchTerm),e},productColumns(){return[{property:"name",label:this.$tc("sw-sales-channel.detail.products.columnProductName"),allowResize:!0,primary:!0},{property:"active",label:this.$tc("sw-sales-channel.detail.products.columnActive"),allowResize:!0,align:"center"},{property:"productNumber",label:this.$tc("sw-sales-channel.detail.products.columnProductNumber"),allowResize:!0}]},assetFilter(){return Shopware.Filter.getByName("asset")}},watch:{salesChannel:{deep:!0,immediate:!0,handler(e,t){!e||(t==null?void 0:t.id)===e.id||this.getProducts()}}},methods:{getProducts(){var t;if(!((t=this.salesChannel)!=null&&t.id))return Promise.reject();const e={...l.api};return e.inheritance=!0,this.isLoading=!0,this.productRepository.search(this.productCriteria,e).then(s=>{this.products=s,this.total=s.total,this.total>0&&this.products.length<=0&&(this.page=this.page===1?1:this.page-1,this.getProducts())}).catch(()=>{this.products=[]}).finally(()=>{this.isLoading=!1})},onDeleteProduct(e){const t=this.getDeleteId(e);return this.productVisibilityRepository.delete(t,l.api).then(()=>{this.getProducts(),this.$refs.entityListing.resetSelection()}).catch(s=>{var i,a;if((a=(i=s==null?void 0:s.response)==null?void 0:i.data)!=null&&a.errors){this.showNotificationError(s.response.data.errors);return}this.createNotificationError({message:s.message})})},onDeleteProducts(){const e=Object.values(this.productSelection).map(t=>this.getDeleteId(t));return this.isLoading=!0,this.productVisibilityRepository.syncDeleted(e,l.api).then(()=>{this.isLoading=!1,this.getProducts(),this.$refs.entityListing.resetSelection()}).catch(t=>{var s,i,a,n;if(this.isLoading=!1,(n=(a=(i=(s=t==null?void 0:t.response)==null?void 0:s.data)==null?void 0:i.data)==null?void 0:a.product_visibility)!=null&&n.result){this.showNotificationError(t.response.data.data.product_visibility.result);return}this.createNotificationError({message:t.message})})},getDeleteId(e){return e.visibilities.find(t=>t.salesChannelId===this.salesChannel.id).id},showNotificationError(e){e.forEach(t=>{t.errors?this.showNotificationError(t.errors):this.createNotificationError({message:`${t.code}: ${t.detail}`})})},onChangePage(e){this.page=e.page,this.limit=e.limit,this.products.criteria.sortings.forEach(({field:t,naturalSorting:s,order:i})=>{this.productCriteria.addSorting(o.sort(t,i,s))}),this.getProducts()},onChangeSearchTerm(e){this.searchTerm=e,e&&(this.page=1),this.getProducts()},openAddProductsModal(){this.showProductsModal=!0},onAddProducts(e){if(e.length<=0)return this.showProductsModal=!1,Promise.reject();const t=new d(this.productVisibilityRepository.route,this.productVisibilityRepository.entityName,l.api);return e.forEach(s=>{var a;if((a=this.products)!=null&&a.has(s.id))return;const i=this.productVisibilityRepository.create(l.api);Object.assign(i,{visibility:30,productId:s.id,salesChannelId:this.salesChannel.id,salesChannel:this.salesChannel}),t.add(i)}),this.isAssignProductLoading=!0,this.saveProductVisibilities(t).then(()=>{this.getProducts()}).catch(s=>{this.createNotificationError({message:s})}).finally(()=>{this.showProductsModal=!1,this.isAssignProductLoading=!1})},saveProductVisibilities(e){return e.length<=0?Promise.resolve():this.productVisibilityRepository.saveAll(e,l.api)},isProductRemovable(e){const t=e.visibilities.find(s=>s.salesChannelId===this.salesChannel.id);return e.parentId!==(t==null?void 0:t.productId)},onProductSelectionChanged(e){this.productSelection=e}}};export{p as default};
