const l=`{% block sw_sales_channel_detail %} <sw-page class="sw-sales-channel-detail"> {% block sw_sales_channel_detail_header %} <template #smart-bar-header> {% block sw_sales_channel_detail_header_headline %} <h2>{{ placeholder(salesChannel, 'name', $tc('sw-sales-channel.detail.textHeadline')) }}</h2> {% endblock %} </template> {% endblock %} {% block sw_sales_channel_detail_actions %} <template #smart-bar-actions> {% block sw_sales_channel_detail_actions_save %} <sw-button-process v-tooltip.bottom="tooltipSave" class="sw-sales-channel-detail__save-action" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="!allowSaving || isLoading || productComparison.invalidFileName" variant="primary" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('sw-sales-channel.detail.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_sales_channel_detail_language_switch %} <template #language-switch> <sw-language-switch :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_sales_channel_detail_content %} <template #content> <sw-card-view> {% block sw_sales_channel_detail_content_language_info %} <sw-language-info :entity-description="placeholder(salesChannel, 'name', $tc('sw-sales-channel.detail.textHeadline'))" /> {% endblock %} {% block sw_sales_channel_detail_content_tabs %} <sw-tabs class="sw-sales-channel-detail-__tabs" position-identifier="sw-sales-channel-detail" > {% block sw_sales_channel_detail_content_tab_general %} <sw-tabs-item :route="{ name: 'sw.sales.channel.detail.base', params: { id: $route.params.id } }" :title="$tc('sw-sales-channel.detail.tabBase')" > {{ $tc('sw-sales-channel.detail.tabBase') }} </sw-tabs-item> {% endblock %} {% block sw_sales_channel_detail_content_tab_products %} <sw-tabs-item v-if="isHeadless || isStorefront" :route="{ name: 'sw.sales.channel.detail.products', params: { id: $route.params.id } }" :title="$tc('sw-sales-channel.detail.tabProducts')" > {{ $tc('sw-sales-channel.detail.tabProducts') }} </sw-tabs-item> {% endblock %} {% block sw_sales_channel_detail_content_tab_theme %}{% endblock %} {% block sw_sales_channel_detail_content_tab_product_comparison %} <sw-tabs-item v-if="isProductComparison && !isLoading" :route="{ name: 'sw.sales.channel.detail.productComparison', params: { id: $route.params.id } }" :title="$tc('sw-sales-channel.detail.tabProductComparison')" > {{ $tc('sw-sales-channel.detail.tabProductComparison') }} </sw-tabs-item> {% endblock %} {% block sw_sales_channel_detail_content_tab_analytics %} <sw-tabs-item v-if="isStorefront" :route="{ name: 'sw.sales.channel.detail.analytics', params: { id: $route.params.id } }" :title="$tc('sw-sales-channel.detail.tabAnalytics')" > {{ $tc('sw-sales-channel.detail.tabAnalytics') }} </sw-tabs-item> {% endblock %} </sw-tabs> {% endblock %} {% block sw_sales_channel_detail_content_view %} <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> <template v-else> <router-view :key="$route.params.id" v-slot="{ Component }" > <component :is="Component" :sales-channel="salesChannel" :product-export="productExport" :storefront-sales-channel-criteria="storefrontSalesChannelCriteria" :custom-field-sets="customFieldSets" :is-loading="isLoading" :product-comparison-access-url="productComparison.productComparisonAccessUrl" :template-options="productComparison.templateOptions" :show-template-modal="productComparison.showTemplateModal" :template-name="productComparison.templateName" @template-selected="onTemplateSelected" @access-key-changed="generateAccessUrl" @domain-changed="generateAccessUrl" @invalid-file-name="setInvalidFileName(true)" @valid-file-name="setInvalidFileName(false)" @template-modal-close="onTemplateModalClose" @template-modal-confirm="onTemplateModalConfirm" /> </router-view> </template> {% endblock %} </sw-card-view> </template> {% endblock %} <template #sidebar> {% block sw_sales_channel_detail_sidebar %} {% endblock %} </template> </sw-page> {% endblock %}`,{Mixin:i,Context:o,Defaults:n}=Shopware,{Criteria:t}=Shopware.Data,c={template:l,inject:["repositoryFactory","exportTemplateService","acl","feature"],mixins:[i.getByName("notification"),i.getByName("placeholder")],shortcuts:{"SYSTEMKEY+S":"onSave"},data(){return{salesChannel:null,isLoading:!1,customFieldSets:[],isSaveSuccessful:!1,productComparison:{newProductExport:null,productComparisonAccessUrl:null,invalidFileName:!1,templateOptions:[],templates:null,templateName:null,showTemplateModal:!1,selectedTemplate:null}}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.placeholder(this.salesChannel,"name")},productExport(){return this.salesChannel&&this.salesChannel.productExports.first()?this.salesChannel.productExports.first():this.productComparison.newProductExport?this.productComparison.newProductExport:(this.productComparison.newProductExport=this.productExportRepository.create(),this.productComparison.newProductExport.interval=0,this.productComparison.newProductExport.generateByCronjob=!1,this.productComparison.newProductExport)},isStorefront(){return this.salesChannel?this.salesChannel.typeId===n.storefrontSalesChannelTypeId:this.$route.params.typeId===n.storefrontSalesChannelTypeId},isProductComparison(){return this.salesChannel?this.salesChannel.typeId===n.productComparisonTypeId:this.$route.params.typeId===n.productComparisonTypeId},isHeadless(){return this.salesChannel?this.salesChannel.typeId===n.apiSalesChannelTypeId:this.$route.params.typeId===n.apiSalesChannelTypeId},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},salesChannelAnalyticsRepository(){return this.repositoryFactory.create("sales_channel_analytics")},customFieldRepository(){return this.repositoryFactory.create("custom_field_set")},productExportRepository(){return this.repositoryFactory.create("product_export")},storefrontSalesChannelCriteria(){return new t(1,25).addFilter(t.equals("typeId",n.storefrontSalesChannelTypeId))},tooltipSave(){return this.allowSaving?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.allowSaving,showOnDisabledElements:!0}},allowSaving(){return this.acl.can("sales_channel.editor")}},watch:{"$route.params.id"(){this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){Shopware.ExtensionAPI.publishData({id:"sw-sales-channel-detail__salesChannel",path:"salesChannel",scope:this}),this.loadEntityData(),this.loadProductExportTemplates()},loadEntityData(){this.$route.params.id&&(this.$route.params.typeId||(this.salesChannel&&(this.salesChannel=null),this.loadSalesChannel(),this.loadCustomFieldSets()))},loadSalesChannel(){this.isLoading=!0,this.salesChannelRepository.get(this.$route.params.id.toLowerCase(),o.api,this.getLoadSalesChannelCriteria()).then(e=>{this.salesChannel=e,this.salesChannel.maintenanceIpWhitelist||(this.salesChannel.maintenanceIpWhitelist=[]),this.generateAccessUrl(),this.isLoading=!1})},getLoadSalesChannelCriteria(){const e=new t(1,25);return e.addAssociation("paymentMethods"),e.addAssociation("shippingMethods"),e.addAssociation("countries"),e.getAssociation("currencies").addSorting(t.sort("name","ASC")),e.addAssociation("domains"),e.getAssociation("languages").addSorting(t.sort("name","ASC")),e.addAssociation("analytics"),e.addAssociation("productExports"),e.addAssociation("productExports.salesChannelDomain.salesChannel"),e.getAssociation("domains.language").addSorting(t.sort("name","ASC")),e.getAssociation("domains.snippetSet").addSorting(t.sort("name","ASC")),e.addAssociation("domains.currency"),e.addAssociation("domains.productExports"),e},onTemplateSelected(e){this.productComparison.templates===null||this.productComparison.templates[e]===void 0||(this.productComparison.selectedTemplate=this.productComparison.templates[e],!Object.keys(this.productComparison.selectedTemplate).some(s=>this.productExport[s]!==this.productComparison.selectedTemplate[s]))||(this.productComparison.showTemplateModal=!0)},onTemplateModalClose(){this.productComparison.selectedTemplate=null,this.productComparison.templateName=null,this.productComparison.showTemplateModal=!1},onTemplateModalConfirm(){Object.keys(this.productComparison.selectedTemplate).forEach(e=>{this.productExport[e]=this.productComparison.selectedTemplate[e]}),this.onTemplateModalClose(),this.createNotificationInfo({message:this.$tc("sw-sales-channel.detail.productComparison.templates.message.template-applied-message")})},loadCustomFieldSets(){const e=new t(1,100);e.addFilter(t.equals("relations.entityName","sales_channel")),e.getAssociation("customFields").addSorting(t.sort("config.customFieldPosition","ASC",!0)),this.customFieldRepository.search(e,o.api).then(a=>{this.customFieldSets=a})},generateAccessUrl(){if(!this.productExport.salesChannelDomain){this.productComparison.productComparisonAccessUrl="";return}const e=this.productExport.salesChannelDomain.url.replace(/\/+$/g,"");this.productComparison.productComparisonAccessUrl=`${e}/store-api/product-export/${this.productExport.accessKey}/${this.productExport.fileName}`},loadProductExportTemplates(){this.productComparison.templateOptions=Object.values(this.exportTemplateService.getProductExportTemplateRegistry()),this.productComparison.templates=this.exportTemplateService.getProductExportTemplateRegistry()},saveFinish(){this.isSaveSuccessful=!1},setInvalidFileName(e){this.productComparison.invalidFileName=e},async onSave(){var a,s;this.isLoading=!0,this.isSaveSuccessful=!1,this.isProductComparison&&!this.salesChannel.productExports.length&&this.salesChannel.productExports.add(this.productExport);const e=this.updateAnalytics();try{await this.salesChannelRepository.save(this.salesChannel,o.api),e&&!((s=(a=this.salesChannel)==null?void 0:a.analytics)!=null&&s.trackingId)&&await this.salesChannelAnalyticsRepository.delete(e,o.api),this.isLoading=!1,this.isSaveSuccessful=!0,Shopware.Utils.EventBus.emit("sw-sales-channel-detail-sales-channel-change"),this.loadEntityData()}catch{this.isLoading=!1,this.createNotificationError({message:this.$tc("sw-sales-channel.detail.messageSaveError",{name:this.salesChannel.name||this.placeholder(this.salesChannel,"name")},0)})}},updateAnalytics(){var a,s;const e=this.salesChannel.analyticsId;return e&&!((s=(a=this.salesChannel)==null?void 0:a.analytics)!=null&&s.trackingId)&&(this.salesChannel.analyticsId=null,delete this.salesChannel.analytics),e},abortOnLanguageChange(){return this.salesChannelRepository.hasChanges(this.salesChannel)},saveOnLanguageChange(){return this.onSave()},onChangeLanguage(){this.loadEntityData()}}};export{c as default};
