<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Svenska';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'sv_SE';
$txt['lang_dictionary'] = 'sv';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'sv';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1 234,00';

$txt['days_title'] = 'Dagar';
$txt['days'] = array('Söndag', 'Måndag', 'tisdag', 'onsdag', 'torsdag', 'fredag', 'lördag');
$txt['days_short'] = array('sön', 'Mån', 'tis', 'ons', 'tor', 'fre', 'lör');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Månader';
$txt['months'] = array(1 => 'Januari', 2 => 'Februari', 3 => 'Mars', 4 => 'April', 5 => 'Maj', 6 => 'Juni', 7 => 'Juli', 8 => 'Augusti', 9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'December');
$txt['months_titles'] = array(1 => 'Januari', 2 => 'Februari', 3 => 'Mars', 4 => 'April', 5 => 'Maj', 6 => 'Juni', 7 => 'Juli', 8 => 'Augusti', 9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'December');
$txt['months_short'] = array(1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'Maj', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Okt', 11 => 'Nov', 12 => 'Dec');
$txt['prev_month'] = 'Föregående månad';
$txt['next_month'] = 'Nästa månad';
$txt['start'] = 'Börjar';
$txt['end'] = 'Slutar';
$txt['starts'] = 'Börjar';
$txt['ends'] = 'Slutar';
$txt['none'] = 'Ingen';

$txt['minutes_label'] = 'Minuter';
$txt['hours_label'] = 'Timmar';
$txt['years_title'] = 'År';

$txt['time_am'] = 'AM';
$txt['time_pm'] = 'PM';

// Short form of minutes
$txt['minutes_short'] = 'min';
// Short form of hour
$txt['hour_short'] = 'tim';
// Short form of hours
$txt['hours_short'] = 'tim';
// Decimal sign
$txt['decimal_sign'] = ',';

$txt['admin'] = 'Administration';
$txt['moderate'] = 'Moderering';

$txt['save'] = 'Spara';
$txt['reset'] = 'Återställ';
$txt['upload'] = 'Ladda upp';
$txt['upload_all'] = 'Ladda upp alla';
$txt['processing'] = 'Behandlar...';

$txt['modify'] = 'Ändra';
$txt['forum_index'] = '%1$s - Index';
$txt['members'] = 'Medlemmar';
$txt['board_name'] = 'Namn på tavla';
$txt['posts'] = 'Inlägg';

$txt['member_postcount'] = 'Inlägg';
$txt['no_subject'] = '(Ämne saknas)';
$txt['view_profile'] = 'Visa profil';
$txt['guest_title'] = 'Gäst';
$txt['author'] = 'Skapare';
$txt['on'] = 'skrivet';
$txt['remove'] = 'Ta bort';
$txt['start_new_topic'] = 'Starta nytt ämne';

$txt['login'] = 'Logga in';
// Use numeric entities in the below string.
$txt['username'] = 'Användarnamn';
$txt['password'] = 'Lösenord';

$txt['username_no_exist'] = 'Användarnamnet finns inte.';
$txt['no_user_with_email'] = 'Det finns ingen användare som har den e-postadressen.';

$txt['board_moderator'] = 'Moderator';
$txt['remove_topic'] = 'Radera ämne';
$txt['topics'] = 'Ämnen';
$txt['modify_msg'] = 'Redigera inlägg';
$txt['name'] = 'Namn';
$txt['email'] = 'E-post';
$txt['user_email_address'] = 'E-postadress';
$txt['subject'] = 'Ämne';
$txt['message'] = 'Inlägg';
$txt['redirects'] = 'Omdirigeringar';
$txt['quick_modify'] = 'Redigera inline';
$txt['quick_modify_message'] = 'Du har redigerat inlägget utan problem.';
$txt['reason_for_edit'] = 'Orsak till redigering';

$txt['choose_pass'] = 'Välj lösenord';
$txt['verify_pass'] = 'Skriv lösenordet igen';
$txt['notify_announcements'] = 'Tillåt att administratörerna skickar viktiga nyheter via e-post';

$txt['position'] = 'Position';

// argument(s): username
$txt['view_profile_of_username'] = 'Visa profil för %1$s';
$txt['total'] = 'Totalt';
$txt['website'] = 'Hemsida';
$txt['register'] = 'Registrera dig';
$txt['warning_status'] = 'Varningsstatus';
$txt['user_warn_watch'] = 'Användaren är på moderatorernas övervakningslista ';
$txt['user_warn_moderate'] = 'Användarens inlägg måste godkännas';
$txt['user_warn_mute'] = 'Användaren får inte skriva inlägg';
$txt['warn_watch'] = 'Övervakad';
$txt['warn_moderate'] = 'Modererad';
$txt['warn_mute'] = 'Nedtystad';

$txt['message_index'] = 'Meddelandeindex';
$txt['news'] = 'Forumnyheter';
$txt['home'] = 'Startsida';
$txt['page'] = 'Sida';
$txt['prev'] = 'Föregående sida';
$txt['next'] = 'Nästa sida';

$txt['lock_unlock'] = 'Lås/lås upp ämne';
$txt['post'] = 'Inlägg';
$txt['error_occured'] = 'Ett fel har uppstått';
$txt['at'] = 'klockan';
$txt['by'] = 'av';
$txt['logout'] = 'Logga ut';
$txt['started_by'] = 'Startat av';
$txt['topic_started_by'] = 'Startad av <strong>%1$s</strong> i <em>%2$s</em>';
$txt['replies'] = 'Svar';
$txt['last_post'] = 'Senaste inlägg';
$txt['first_post'] = 'Första inlägg';
$txt['last_poster'] = 'Senaste inlägg av';
$txt['last_post_message'] = '<strong>Senaste inlägg: </strong>%3$s <span class="postby">%2$s av %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>av %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> av <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s inlägg i %2$s ämnen av %3$s medlemmar';
$txt['show'] = 'Visa';
$txt['hide'] = 'Dölj';

$txt['admin_login'] = 'Administratörsinloggning';
// Use numeric entities in the below string.
$txt['topic'] = 'Ämne';
$txt['help'] = 'Hjälp';
$txt['terms_and_rules'] = 'Villkor och regler';
$txt['watch_board'] = 'Bevaka denna tavla';
$txt['unwatch_board'] = 'Sluta bevaka tavlan';
$txt['watch_topic'] = 'Bevaka detta ämne';
$txt['unwatch_topic'] = 'Sluta bevaka ämnet';
$txt['watching_topic'] = 'Ämne som du bevakar';
$txt['watching_this_topic'] = 'Du bevakar detta ämne och kommer få notifikationer om det.';
$txt['notify'] = 'Underrätta';
$txt['unnotify'] = 'Sluta bevaka';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Med vänlig hälsning
Teamet bakom %1$s';

$txt['notify_replies'] = 'Underrätta via e-post';
$txt['move_topic'] = 'Flytta ämne';
$txt['move_to'] = 'Flytta till';
$txt['pages'] = 'Sidor';
$txt['users_active'] = 'Aktiva användare under de senaste %s minuterna';
$txt['personal_messages'] = 'Privata meddelanden';
$txt['reply_quote'] = 'Svara med citat';
$txt['reply'] = 'Svara';
$txt['reply_noun'] = 'Svar';
$txt['reply_number'] = 'Svar #%1$s%2$s';
$txt['approve'] = 'Godkänn';
$txt['unapprove'] = 'Ångra godkännande';
$txt['approve_all'] = 'godkänn alla';
$txt['issue_warning'] = 'Utfärda varning';
$txt['awaiting_approval'] = 'Väntar på godkännande';
$txt['attach_awaiting_approve'] = 'Bifogade filer som väntar på godkännande';
$txt['post_awaiting_approval'] = 'Detta inlägg väntar på att godkännas av en moderator.';
$txt['there_are_unapproved_topics'] = 'Det finns %1$s ämnen och %2$s inlägg i denna tavla som väntar på godkännande. Klicka <a href="%3$s">här</a> för att visa alla.';
$txt['send_message'] = 'Skicka meddelande';

$txt['msg_alert_no_messages'] = 'du har inga meddelanden';
$txt['msg_alert_one_message'] = 'du har <a href="%1$s">1 meddelande</a>';
$txt['msg_alert_many_message'] = 'du har <a href="%1$s">%2$d meddelanden</a>';
$txt['msg_alert_one_new'] = '1 är nytt';
$txt['msg_alert_many_new'] = '%1$d är nya';
$txt['new_alert'] = 'Ny underrättelse';
$txt['remove_message'] = 'Radera detta inlägg';
$txt['remove_message_question'] = 'Radera detta inlägg?';

$txt['topic_alert_none'] = 'Inga meddelanden...';
$txt['pm_alert_none'] = 'Inga meddelanden...';
$txt['no_messages'] = 'Inga meddelanden';

$txt['online_users'] = 'Användare online';
$txt['jump_to'] = 'Gå till';
$txt['go'] = 'OK';
$txt['are_sure_remove_topic'] = 'Är du säker på att du vill radera det här ämnet?';
$txt['yes'] = 'Ja';
$txt['no'] = 'Nej';

$txt['search_end_results'] = 'Slut på resultat';
$txt['search_on'] = 'skrivet';

$txt['search'] = 'Sök';
$txt['all'] = 'Alla';
$txt['search_entireforum'] = 'Hela forumet';
$txt['search_thisboard'] = 'Denna tavla';
$txt['search_thistopic'] = 'Detta ämne';
$txt['search_members'] = 'Medlemmar';

$txt['back'] = 'Tillbaka';
$txt['continue'] = 'Fortsätt';
$txt['password_reminder'] = 'Lösenordspåminnelse';
$txt['topic_started'] = 'Ämnet startat av';
$txt['title'] = 'Titel';
$txt['post_by'] = 'Skrivet av';
$txt['memberlist_searchable'] = 'Sökbar lista över samtliga registrerade medlemmar.';
$txt['welcome_newest_member'] = 'Välkomna %1$s, vår nyaste medlem.';
$txt['admin_center'] = 'Administrationscenter';
$txt['last_edit_by'] = '<span class="lastedit">Senast ändrad</span>: %1$s av %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Anledning</span>: %1$s';
$txt['notify_deactivate'] = 'Vill du stänga av underrättelse vid svar för det här ämnet?';
$txt['modified_time'] = 'Senast ändrad';
$txt['modified_by'] = 'Ändrad av';

$txt['recent_posts'] = 'Senaste inlägg';

$txt['location'] = 'Plats';
$txt['location_desc'] = 'Geografisk plats.';
$txt['gender'] = 'Kön';
$txt['gender_0'] = 'Inget';
$txt['gender_1'] = 'Man';
$txt['gender_2'] = 'Kvinna';
$txt['gender_desc'] = 'Ditt kön.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Detta är ditt ICQ nummer.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Ditt Skype-namn';
$txt['personal_text'] = 'Personlig text';
$txt['date_registered'] = 'Registreringsdatum';

$txt['recent_view'] = 'Visa de senaste inläggen på forumet.';
$txt['recent_updated'] = 'är det senast uppdaterade ämnet';
$txt['is_recent_updated'] = '%1$s är det senast uppdaterade ämnet';

$txt['male'] = 'Man';
$txt['female'] = 'Kvinna';

$txt['error_invalid_characters_username'] = 'Ett ogiltigt tecken användes i användarnamnet.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Välkommen till <strong>%1$s</strong>. Vänligen <a href="%2$s" onclick="%3$s">logga in</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Välkommen till <strong>%1$s</strong>. Vänligen <a href="%2$s" onclick="%3$s">logga in</a> eller <a href="%4$s">registrera dig</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Saknar du ditt aktiverings-epost?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Har du inget konto? <a href="%1$s?action=signup">Registrera dig</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Välkommen till <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Hej';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Välkommen';
$txt['select_destination'] = 'Välj destination';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Skrivet av';

$txt['icon_smiley'] = 'Leende (smiley)';
$txt['icon_angry'] = 'Arg';
$txt['icon_cheesy'] = 'Glad';
$txt['icon_laugh'] = 'Skrattande';
$txt['icon_sad'] = 'Ledsen';
$txt['icon_wink'] = 'Med glimten i ögat';
$txt['icon_grin'] = 'Skrattande';
$txt['icon_shocked'] = 'Chockad';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Va';
$txt['icon_rolleyes'] = 'Rullande ögon (ironi)';
$txt['icon_tongue'] = 'Tunga';
$txt['icon_embarrassed'] = 'Generad';
$txt['icon_lips'] = 'Läpparna förseglade';
$txt['icon_undecided'] = 'Obeslutsam';
$txt['icon_kiss'] = 'Kyss';
$txt['icon_cry'] = 'Gråta';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderatorer';

$txt['views'] = 'Visningar';
$txt['new'] = 'Nytt';

$txt['view_all_members'] = 'Visa alla medlemmar';
$txt['view'] = 'Visa';

$txt['viewing_members'] = 'Visar medlemmarna %1$s till %2$s';
$txt['of_total_members'] = 'av totalt %1$s medlemmar';

$txt['forgot_your_password'] = 'Glömt ditt lösenord?';

$txt['date'] = 'Datum';
// Use numeric entities in the below string.
$txt['from'] = 'Från';
$txt['check_new_messages'] = 'Kolla om du fått nya meddelanden';
$txt['to'] = 'Till';

$txt['board_topics'] = 'Ämnen';
$txt['members_title'] = 'Medlemmar';
$txt['members_list'] = 'Medlemslista';
$txt['new_posts'] = 'Nya inlägg';
$txt['old_posts'] = 'Inga nya inlägg';
$txt['redirect_board'] = 'Omdirigera tavla';

$txt['sendtopic_send'] = 'Skicka';
$txt['report_sent'] = 'Din rapport har skickats.';
$txt['post_becomes_unapproved'] = 'Ditt inlägg godkändes inte eftersom det postades i ett ogranskat ämne. När ämnet godkänts kommer ditt inlägg också att bli godkänt.';

$txt['time_offset'] = 'Tidsskillnad';
$txt['or'] = '<em>eller</em>';

$txt['no_matches'] = 'Beklagar, sökningen gav inga resultat';

$txt['notification'] = 'Underrättelse';

$txt['your_ban'] = 'Ledsen %1$s, du är bannlyst från det här forumet!';
$txt['your_ban_expires'] = 'Denna bannlysning kommer att upphöra %1$s.';
$txt['your_ban_expires_never'] = 'Denna bannlysning kommer aldrig att upphöra.';
$txt['ban_continue_browse'] = 'Du kan fortsätta att visa forumet som gäst.';

$txt['mark_as_read'] = 'Markera alla ämnen på samtliga tavlor som lästa';

$txt['locked_topic'] = 'Låst ämne';
$txt['normal_topic'] = 'Normalt ämne';
$txt['participation_caption'] = 'Ämne du har skrivit i';
$txt['moved_topic'] = 'Flyttat ämne';

$txt['go_caps'] = 'OK';

$txt['print'] = 'Skriv ut';
$txt['profile'] = 'Profil';
$txt['topic_summary'] = 'Ämnessammanfattning';
$txt['not_applicable'] = 'Ej tillämpbart';
$txt['name_in_use'] = 'Det här användarnamnet är redan upptaget av en annan medlem.';

$txt['total_members'] = 'Totalt antal medlemmar';
$txt['total_posts'] = 'Totalt antal inlägg';
$txt['total_topics'] = 'Totalt antal ämnen';

$txt['time_logged_in'] = 'Tid att förbli inloggad';

$txt['preview'] = 'Förhandsgranska';
$txt['always_logged_in'] = 'För alltid';

$txt['logged'] = 'Loggat';
$txt['show_ip'] = 'Visa IP-adress';
// Use numeric entities in the below string.
$txt['ip'] = 'IP-adress';
$txt['url'] = 'URL';
$txt['www'] = 'Hemsida';

$txt['hours'] = 'timmar';
$txt['minutes'] = 'minuter';
$txt['seconds'] = 'sekunder';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Timmar';
$txt['days_word'] = 'dagar';

$txt['search_for'] = 'Sök efter';
$txt['search_match'] = 'Träff';

$txt['forum_in_maintenance'] = 'Ditt forum är i underhållsläge. Bara administratörer kan för närvarande logga in.';
$txt['maintenance_page'] = 'Du kan stänga av underhållsläge från <a href="%1$s">Serverinställningarna</a>.';

$txt['read_one_time'] = 'Läst 1 gång';
$txt['read_many_times'] = 'Läst %1$d gånger';

$txt['forum_stats'] = 'Forumstatistik';
$txt['latest_member'] = 'Nyaste medlemmen';
$txt['total_cats'] = 'Totalt antal kategorier';
$txt['latest_post'] = 'Senaste inlägg';

$txt['total_boards'] = 'Totalt antal tavlor';

$txt['print_page'] = 'Skriv ut sidan';
$txt['print_page_text'] = 'Bara texten';
$txt['print_page_images'] = 'Text och bilder';

$txt['valid_email'] = 'Detta måste vara en giltig e-postadress.';

$txt['geek'] = 'Jag är en tönt!!';
$txt['info_center_title'] = '%1$s - Informationscenter';

$txt['watch'] = 'Bevaka';
$txt['unwatch'] = 'Sluta bevaka';

$txt['check_all'] = 'Välj alla';

// Use numeric entities in the below string.
$txt['database_error'] = 'Databasfel';
$txt['try_again'] = 'Försök igen. Om du får detta felmeddelande upprepade gånger, var vänlig och meddela detta till en administratör.';
$txt['file'] = 'Fil';
$txt['line'] = 'Rad';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF har upptäckt och automatiskt försökt reparera ett fel i din databas. Om du fortsätter att ha problem, eller får dessa e-postmeddelanden vid upprepade tillfällen, vänligen ta kontakt med ditt webbhotell.';
$txt['database_error_versions'] = '<strong>OBS:</strong> Det ser ut som att din databas <em>kanske</em> behöver uppgraderas. Dina forumfiler tillhör version %1$s, medan din databas tillhör version %2$s. Det är mycket möjligt att detta fel kan lösas om du kör senaste versionen av Upgrade.php.';
$txt['template_parse_error'] = 'Malltolkningsfel!';
$txt['template_parse_error_message'] = 'Det ser ut som att något gått snett med mallsystemet på forumet. Mest troligt är problemet tillfälligt, så kom tillbaka lite senare och försök igen. Om du fortsätter att få detta meddelande, vänligen kontakta administratören.<br><br>Du kan också försöka att <a href="javascript:location.reload();">uppdatera den här sidan</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Det gick inte att ladda <pre><strong>%1$s</strong></pre>-mallen eller språkfilen. Vänligen kontrollera syntaxen och försök igen - kom ihåg, enkelt citationstecken (<pre>\'</pre>) ofta måste avslutas med bakåtstreck (<pre>\\</pre>). För att se mer specifik felinformation från PHP kan du försöka <a href="%2$s%1$s">hämta filen direkt</a>.<br><br>Du kan också försöka att<a href="javascript:location.reload();">ladda om sidan</a> eller <a href="%3$s?theme=1">använda standardtemat</a>.';
$txt['template_parse_errmsg'] = 'Dessvärre finns inte mer information tillgänglig om vad som gått fel, just nu.';

$txt['today'] = '<strong>Idag</strong> kl. ';
$txt['yesterday'] = '<strong>Igår</strong> kl. ';
$txt['new_poll'] = 'Skapa ny omröstning';
$txt['poll_question'] = 'Fråga';
$txt['poll_vote'] = 'Skicka röst';
$txt['poll_total_voters'] = 'Antal personer som röstat';
$txt['poll_results'] = 'Visa resultat.';
$txt['poll_lock'] = 'Lås omröstning';
$txt['poll_unlock'] = 'Lås upp omröstning';
$txt['poll_edit'] = 'Redigera omröstning';
$txt['poll'] = 'Omröstning';
$txt['one_hour'] = '1 timme';
$txt['one_day'] = '1 dag';
$txt['one_week'] = '1 vecka';
$txt['two_weeks'] = '2 veckor';
$txt['one_month'] = '1 månad';
$txt['two_months'] = '2 månader';
$txt['forever'] = 'Förbli inloggad för alltid';
$txt['moved'] = 'FLYTTAD';
$txt['move_why'] = 'Vänligen ange en kort beskrivning<br>om varför ämnet har flyttats.';
$txt['board'] = 'Tavla';
$txt['in'] = 'i';
$txt['sticky_topic'] = 'Klistrat ämne';

$txt['delete'] = 'Radera';
$txt['no_change'] = 'Ingen förändring';

$txt['your_pms'] = 'Dina personliga meddelanden';

$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Mer statistik]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Källkod';
$txt['code_select'] = 'Markera';
$txt['code_expand'] = 'Expandera';
$txt['code_shrink'] = 'Krymp';
$txt['quote_from'] = 'Citat från';
$txt['quote'] = 'Citat';
$txt['quote_action'] = 'Citera';
$txt['quote_selected_action'] = 'Citera markerad text';
$txt['fulledit'] = 'Fullständig redigerare';
$txt['edit'] = 'Redigera';
$txt['quick_edit'] = 'Redigera inlägg';
$txt['post_options'] = 'Mer...';

$txt['merge_to_topic_id'] = 'ID för målämnet';
$txt['split'] = 'Dela upp ämne';
$txt['merge'] = 'Sammanfoga ämnen';
$txt['target_id'] = 'Välj ämne med hjälp av id';
$txt['target_below'] = 'Välj ämne från listan nedan';
$txt['subject_new_topic'] = 'Ämnesrad för det nya ämnet:';
$txt['split_this_post'] = 'Dela endast upp detta inlägg.';
$txt['split_after_and_this_post'] = 'Dela alla inlägg fr.o.m. detta.';
$txt['select_split_posts'] = 'Välj exakt vilka inlägg du vill dela upp.';
$txt['new_topic'] = 'Nytt ämne';
$txt['split_successful'] = 'Ämnet har delats upp i två ämnen utan problem.';
$txt['origin_topic'] = 'Ursprungligt ämne';
$txt['please_select_split'] = 'Välj vilka inlägg du vill skapa ett nytt ämne av.';
$txt['merge_successful'] = 'Ämnena har nu sammanfogats till ett enda.';
$txt['new_merged_topic'] = 'Nyligen sammanfogade ämnen';
$txt['topic_to_merge'] = 'Ämne att sammanfoga med';
$txt['target_board'] = 'Välj vilken tavla det ska hamna på:';
$txt['target_topic'] = 'Välj vilket ämne det ska hamna i:';
$txt['merge_desc'] = 'Denna funktion kommer att sammanfoga inläggen i två olika ämnen till ett enda ämne. Inläggen i det nya ämnet kommer att sorteras i datumordning. Det först skrivna inlägget kommer därmed att bli det första inlägget i det nya sammanfogade ämnet.';

$txt['set_sticky'] = 'Klistra fast ämnet';
$txt['set_nonsticky'] = 'Ta bort klistret från detta ämne';
$txt['set_lock'] = 'Lås ämne';
$txt['set_unlock'] = 'Lås upp ämne';

$txt['search_advanced'] = 'Avancerad sökning';

$txt['security_risk'] = 'STOR SÄKERHETSRISK:';
$txt['not_removed'] = 'Du har inte tagit bort ';
$txt['not_removed_extra'] = '%1$s är en backup på %2$s som inte skapats av SMF. Den kan nås direkt och användas för att få otillåten kontakt till ditt forum. Du bör radera den omgående.';
$txt['generic_warning'] = 'Varning';
$txt['agreement_missing'] = 'Du kräver att nya användare ska acceptera ett användaravtal, men filen (agreement.txt) finns inte.';
$txt['policy_agreement_missing'] = 'Du kräver att nya användare ska acceptera en integritetspolicy, men integritetspolicyn är tom.';
$txt['auth_secret_missing'] = 'Kunde inte sätta autentiseringhemlighet i Settings.php. Detta kommer att försvaga säkerhet för ditt forum och utsätter ditt system för risk för attacker. Kontrollera rättigheterna på Settings.php för att säkerställa att SMF kan skriva till filen.';

$txt['cache_writable'] = 'Cachelagringskatalogen är inte skrivbar - detta kommer att påverka ditt forums prestanda avsevärt.';

$txt['page_created_full'] = 'Sidan skapades på %1$.3f sekunder med %2$d databasfrågor.';

$txt['report_to_mod_func'] = 'Använd denna funktion för att meddela moderatorer och administratörer om ett olämpligt eller problematiskt inlägg.';
$txt['report_profile_func'] = 'Använd denna funktion för att informera administratörerna om stötande profilinnehåll, som spam eller olämpliga bilder.';

$txt['online'] = 'Inloggad';
$txt['member_is_online'] = '%1$s är online';
$txt['offline'] = 'Utloggad';
$txt['member_is_offline'] = '%1$s är offline';
$txt['pm_online'] = 'Privat meddelande (Inloggad)';
$txt['pm_offline'] = 'Privat meddelande (Utloggad)';
$txt['status'] = 'Status';

$txt['go_up'] = 'Gå upp';
$txt['go_down'] = 'Gå ned';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="Licens" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Födelsedagar:';
$txt['events'] = 'Händelser:';
$txt['birthdays_upcoming'] = 'Kommande födelsedagar:';
$txt['events_upcoming'] = 'Kommande händelser:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Högtider:';
$txt['calendar_month'] = 'Månad';
$txt['calendar_year'] = 'År';
$txt['calendar_day'] = 'Dag';
$txt['calendar_event_title'] = 'Titel';
$txt['calendar_event_options'] = 'Alternativ för händelse';
$txt['calendar_post_in'] = 'Posta på tavla';
$txt['calendar_edit'] = 'Redigera händelse';
$txt['calendar_export'] = 'Exportera event';
$txt['calendar_view_week'] = 'Visa vecka';
$txt['event_delete_confirm'] = 'Radera den här händelsen?';
$txt['event_delete'] = 'Radera händelse';
$txt['calendar_post_event'] = 'Lägg till ny händelse';
$txt['calendar'] = 'Kalender';
$txt['calendar_link'] = 'Länka till kalender';
$txt['calendar_upcoming'] = 'Kommande kalenderhändelser';
$txt['calendar_today'] = 'Dagens kalenderhändelser';
$txt['calendar_week'] = 'Vecka';
$txt['calendar_week_title'] = 'Vecka %1$d av %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Vecka som börjar %2$s %1$s %3$s';
$txt['calendar_numb_days'] = 'Antal dagar';
$txt['calendar_how_edit'] = 'hur gör man för att ändra händelserna?';
$txt['calendar_link_event'] = 'Länka händelse till inlägg';
$txt['calendar_confirm_delete'] = 'Är du säker på att du vill radera denna händelse?';
$txt['calendar_linked_events'] = 'Ihoplänkade händelser';
$txt['calendar_click_all'] = 'klicka för att se alla %1$s';
$txt['calendar_allday'] = 'Hela dagen';
$txt['calendar_timezone'] = 'Tidszon';
$txt['calendar_list'] = 'Lista';
$txt['calendar_empty'] = 'Det finns inga händelser att visa.';

$txt['movetopic_change_subject'] = 'Ändra ämnets rubrik';
$txt['movetopic_new_subject'] = 'Ny rubrik';
$txt['movetopic_change_all_subjects'] = 'Ändra alla inläggs rubriker';
$txt['move_topic_unapproved_js'] = 'Varning! Detta ämne har inte blivit godkänt ännu. \n\n det är inte rekommenderat att du skapar vidarebefodrande ämnen om du avser att godkänna meddelandet
omedelbart efter flyttningen.';
$txt['movetopic_auto_board'] = '[TAVLA]';
$txt['movetopic_auto_topic'] = '[ÄMNESLÄNK]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Detta ämne har flyttats till %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Omdirigera till det flyttade ämnet';

$txt['post_redirection'] = 'Lämna kvar ett hänvisningsmeddelande';
$txt['redirect_topic_expires'] = 'Radera hänvisningsämnet automatiskt';
$txt['mergetopic_redirect'] = 'Hänvisa till sammanslaget ämne';
$txt['merge_topic_unapproved_js'] = 'Varning! Ämnet har ännu inte godkänts.\n\nDet rekommenderas inte att du skapar ett hänvinsningsämne såvida du inte tänker godkänna inlägget omeddelbart efter sammanslagningen.';

$txt['theme_template_error'] = 'Kunde inte ladda mallen \'%1$s\'.';
$txt['theme_language_error'] = 'Kunde inte ladda språkfilen \'%1$s\'.';

$txt['sub_boards'] = 'Undertavlor';
$txt['restricted_board'] = 'Begränsad tavla';

$txt['smtp_no_connect'] = 'Lyckades inte att ansluta till SMTP-servern';
$txt['smtp_port_ssl'] = 'SMTP-porten är fel inställd, det bör vara port 465 för SSL-servrar. Värdnamnet kan behöva ssl:// prefix.';
$txt['smtp_bad_response'] = 'Kunde inte avläsa svarskoden från servern';
$txt['smtp_error'] = 'Ett fel uppstod vid utskick av e-post. Fel: ';
$txt['mail_send_unable'] = 'Kunde inte skicka e-post till \'%1$s\'';

$txt['mlist_search'] = 'Sök efter medlemmar';
$txt['mlist_search_again'] = 'Sök igen';
$txt['mlist_search_filter'] = 'Sökalternativ';
$txt['mlist_search_email'] = 'Sök efter e-postadress';
$txt['mlist_search_messenger'] = 'Sök efter Messenger-smeknamn';
$txt['mlist_search_group'] = 'Sök efter position';
$txt['mlist_search_name'] = 'Sök efter namn';
$txt['mlist_search_website'] = 'Sök efter hemsida';
$txt['mlist_search_results'] = 'Sökresultat för';
$txt['mlist_search_by'] = 'Sök efter %1$s';
$txt['mlist_menu_view'] = 'Visa medlemslistan';

$txt['attach_downloaded'] = 'nedladdad %1$d gånger';
$txt['attach_viewed'] = 'visad %1$d gånger';

$txt['settings'] = 'Inställningar';
$txt['never'] = 'Aldrig';
$txt['more'] = 'fler';
$txt['etc'] = 'etc.';

$txt['hostname'] = 'Servernamn';
$txt['you_are_post_banned'] = 'Beklagar %1$s, du är bannlyst och får inte skriva inlägg och skicka personliga meddelanden på detta forum.';
$txt['ban_reason'] = 'Anledning';
$txt['select_item_check'] = 'Välj minst ett alternativ i listan';

$txt['tables_optimized'] = 'Databastabeller optimerade';

$txt['add_poll'] = 'Lägg till omröstning';
$txt['poll_options_limit'] = 'Du kan välja upp till %1$s alternativ.';
$txt['poll_remove'] = 'Ta bort omröstning';
$txt['poll_remove_warn'] = 'Är du säker på att du vill ta bort omröstningen från det här ämnet?';
$txt['poll_results_expire'] = 'Resultaten kommer att visas när omröstningen avslutats';
$txt['poll_expires_on'] = 'Omröstningen avslutas';
$txt['poll_expired_on'] = 'Omröstningen har avslutats';
$txt['poll_change_vote'] = 'Ta bort röst';
$txt['poll_return_vote'] = 'Omröstningstillval';
$txt['poll_cannot_see'] = 'Just nu kan du inte se resultaten i denna omröstning';

$txt['quick_mod_approve'] = 'Godkänn valda';
$txt['quick_mod_remove'] = 'Radera markerade';
$txt['quick_mod_lock'] = 'Lås/Lås upp valda';
$txt['quick_mod_sticky'] = 'Klistra fast/ta bort klistrat för valda';
$txt['quick_mod_move'] = 'Flytta valda till';
$txt['quick_mod_merge'] = 'Sammanfoga valda';
$txt['quick_mod_markread'] = 'Markera valda som lästa';
$txt['quick_mod_markunread'] = 'Markera valda som olästa';
$txt['quick_mod_selected'] = 'Med det valda alternativet, gör';
$txt['quick_mod_go'] = 'OK';
$txt['quickmod_confirm'] = 'Vill du verkligen göra detta?';

$txt['spell_check'] = 'Stavningskontroll';

$txt['quick_reply'] = 'Snabbsvar';
$txt['quick_reply_warning'] = 'Varning: Detta ämne är för närvarande låst! Endast administratörer och moderatorer kan svara.';
$txt['quick_reply_verification'] = 'Efter att du skickat ditt inlägg kommer du omdirigeras till den vanliga Posta inlägg-sidan för att verifiera ditt inlägg %1$s.';
$txt['quick_reply_verification_guests'] = '(krävs för alla gäster)';
$txt['quick_reply_verification_posts'] = '(krävs för alla användare med mindre än %1$d inlägg)';
$txt['wait_for_approval'] = 'Notera: Detta inlägg kommer inte synas förrän det godkänts av en moderator.';

$txt['notification_enable_board'] = 'Är du säker på att du vill få e-post vid alla nya ämnen på denna tavla?';
$txt['notification_disable_board'] = 'Är du säker på att du inte längre vill få e-post vid nya ämnen på denna tavla?';
$txt['notification_enable_topic'] = 'Är du säker på att du vill få e-post vid svar till detta ämne?';
$txt['notification_disable_topic'] = 'Är du säker på att du inte längre vill få e-post vid svar till detta ämne?';

// Mentions
$txt['mentions'] = 'Taggningar';

// Likes
$txt['likes'] = 'Gillningar';
$txt['like'] = 'Gilla';
$txt['unlike'] = 'Ta bort gilla-markeringen';
$txt['like_success'] = 'Ditt innehåll gillades.';
$txt['like_delete'] = 'Ditt innehåll togs bort.';
$txt['like_insert'] = 'Ditt innehåll infogades.';
$txt['like_error'] = 'Det inträffade ett fel med din begäran.';
$txt['like_disable'] = 'Gilla-funktionen är inaktiverad.';
$txt['not_valid_like_type'] = 'Den gillade typen är inte en giltig typ.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s person</a> gillar detta.';
$txt['likes_n'] = '<a href="%1$s">%2$s personer</a> gillar detta.';
$txt['you_likes_0'] = 'Du gillar detta.';
$txt['you_likes_1'] = 'Du och <a href="%1$s">%2$s annan person</a> gillar detta.';
$txt['you_likes_n'] = 'Du och <a href="%1$s">%2$s andra personer</a> gillar detta.';

$txt['report_to_mod'] = 'Anmäl till moderator';
$txt['report_profile'] = 'Anmäl profilen för %1$s';

$txt['unread_topics_visit'] = 'Senaste olästa ämnen';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Inga olästa ämnen sedan ditt senaste besök. <a href="%1$s?action=unread;all">Klicka här för att komma till alla olästa ämnen</a>.';
$txt['updated_topics_visit_none'] = 'Inga ämnen har uppdaterats sedan ditt senaste besök.';
$txt['unread_topics_all'] = 'Alla olästa ämnen';
$txt['unread_replies'] = 'Uppdaterade ämnen';

$txt['who_title'] = 'Vilka är online';
$txt['who_and'] = ' och ';
$txt['who_viewing_topic'] = ' tittar på detta ämne.';
$txt['who_viewing_board'] = ' tittar på denna tavla.';
$txt['who_member'] = 'Medlem';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Drivs med PHP';
$txt['powered_by_mysql'] = 'Drivs med MySQL';
$txt['valid_css'] = 'Giltig CSS!';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gäst';
$txt['guests'] = 'Gäster';
$txt['user'] = 'användare';
$txt['users'] = 'användare';
$txt['hidden'] = 'Dolda';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Dolda';
$txt['buddy'] = 'kompis';
$txt['buddies'] = 'kompisar';
$txt['most_online_ever'] = 'Flest online någonsin';
$txt['most_online_today'] = 'Flest online idag';

$txt['merge_select_target_board'] = 'Ange vilken tavla det sammanfogade ämnet ska hamna i';
$txt['merge_select_poll'] = 'Ange vilken omröstning som det sammanfogade ämnet ska ha';
$txt['merge_topic_list'] = 'Ange vilka ämnen som ska sammanfogas';
$txt['merge_select_subject'] = 'Ange rubrik för det sammanfogade ämnet';
$txt['merge_custom_subject'] = 'Ny rubrik';
$txt['merge_include_notifications'] = 'Inkludera underrättelser?';
$txt['merge_check'] = 'Sammanfoga?';
$txt['merge_no_poll'] = 'Ingen omröstning';
$txt['merge_why'] = 'Ange en kort beskrivning om varför dessa ämnen slås ihop.';
$txt['merged_subject'] = '[SAMMANFOGAT] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Detta ämne har slagits samman med %2$s.';

$txt['response_prefix'] = 'SV: ';
$txt['current_icon'] = 'Nuvarande ikon';
$txt['message_icon'] = 'Meddelandeikon';

$txt['smileys_current'] = 'Nuvarande smiley-uppsättning';
$txt['smileys_none'] = 'Inga smileys';
$txt['smileys_forum_board_default'] = 'Standard för tavlan/forumet';

$txt['search_results'] = 'Sökresultat';
$txt['search_no_results'] = 'Beklagar, hittade inga träffar.';

$txt['total_time_logged_days'] = 'dagar,';
$txt['total_time_logged_hours'] = ' timmar och ';
$txt['total_time_logged_minutes'] = ' minuter';
$txt['total_time_logged_d'] = 'd';
$txt['total_time_logged_h'] = 't ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'Medlemsförfrågningar';

$txt['activate_code'] = 'Din aktiveringskod är';

$txt['find_members'] = 'Hitta medlemmar';
$txt['find_username'] = 'Namn, användarnamn eller e-postadress';
$txt['find_buddies'] = 'Visa endast kompisar?';
$txt['find_wildcards'] = 'Tillåtna jokertecken: *, ?';
$txt['find_no_results'] = 'Inga resultat hittades';
$txt['find_results'] = 'Resultat';
$txt['find_close'] = 'Stäng';

$txt['unread_since_visit'] = 'Visa olästa inlägg sen ditt senaste besök.';
$txt['show_unread_replies'] = 'Visa nya svar på dina inlägg.';

$txt['change_color'] = 'Ändra färg';

$txt['quickmod_delete_selected'] = 'Radera markerade';
$txt['quickmod_split_selected'] = 'Dela upp valda';

$txt['show_personal_messages_heading'] = 'Nya meddelanden';
$txt['show_personal_messages'] = 'Du har <strong>%1$s</strong> olästa personliga meddelanden i din Inkorg.<br><br><a href="%2$s">Gå till Inkorgen</a>';

$txt['help_popup'] = 'Lite vilse? Låt mig förklara:';

$txt['previous_next_back'] = 'Föregående ämne';
$txt['previous_next_forward'] = 'Nästa ämne';

$txt['mark_unread'] = 'Markera som oläst';

$txt['ssi_not_direct'] = 'Anropa inte SSI.php direkt genom dess adress, du kan istället använda sökvägen (%1$s) eller lägga till ?ssi_function=någonting.';
$txt['ssi_session_broken'] = 'SSI.php lyckades inte att ladda en session! Detta kan orsaka problem med utloggning och andra funktioner - se till att SSI.php inkluderas före *allting annat* i alla dina skript!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Förhandsgranska inlägg';
$txt['preview_fetch'] = 'Hämtar förhandsgranskning...';
$txt['preview_new'] = 'Nytt inlägg';
$txt['pm_error_while_submitting'] = 'Följande fel inträffade när detta personliga meddelande skickades:';
$txt['error_while_submitting'] = 'Meddelandet har följande fel som måste rättas till innan du kan fortsätta:';
$txt['error_old_topic'] = 'Varning: Det har inte skrivits nya inlägg i detta ämne på %1$d dagar.<br>Om du inte är säker på att du faktiskt vill svara i det här ämnet, så bör du överväga att istället starta ett nytt ämne.';

$txt['split_selected_posts'] = 'Valda inlägg';
$txt['split_selected_posts_desc'] = 'Ovanstående inlägg kommer att bilda ett nytt ämne efter uppdelningen.';
$txt['split_reset_selection'] = 'Nollställ val';

$txt['modify_cancel'] = 'Ångra';
$txt['modify_cancel_all'] = 'Avbryt alla';
$txt['mark_read_short'] = 'Markera som läst';

$txt['alerts'] = 'Underrättelser';

$txt['pm_short'] = 'Meddelanden';
$txt['pm_menu_read'] = 'Läs dina meddelanden';
$txt['pm_menu_send'] = 'Skicka ett meddelande';

$txt['unapproved_posts'] = 'Ogranskade poster (Ämnen: %1$d, Inlägg: %2$d)';

$txt['ajax_in_progress'] = 'Laddar...';

$txt['mod_reports_waiting'] = 'Rapporterade inlägg';

$txt['view_unread_category'] = 'Olästa inlägg';
$txt['new_posts_in_category'] = 'Klicka för att se nya inlägg i %1$s';
$txt['verification'] = 'Verifiering';
$txt['visual_verification_hidden'] = 'Lämna detta fält tomt';
$txt['visual_verification_description'] = 'Skriv in bokstäverna som syns på bilden';
$txt['visual_verification_sound'] = 'Lyssna på bokstäverna muntligt';
$txt['visual_verification_request_new'] = 'Begär en ny bild';

// Sub menu labels
$txt['summary'] = 'Sammanfattning';
$txt['account'] = 'Kontoinställningar';
$txt['theme'] = 'Stil och utseende';
$txt['forumprofile'] = 'Forumprofil';
$txt['activate_changed_email_title'] = 'E-postadressen ändrades';
$txt['activate_changed_email_desc'] = 'Du har ändrat din e-postadress. För att verifiera adressen kommer du att få ett e-postmeddelande. Klicka på länken i meddelandet för att återaktivera ditt konto.';
$txt['modSettings_title'] = 'Inställningar och alternativ';
$txt['package'] = 'Pakethanterare';
$txt['errorlog'] = 'Fellogg';
$txt['edit_permissions'] = 'Rättigheter';
$txt['mc_unapproved_attachments'] = 'Ogranskade bilagor';
$txt['mc_unapproved_poststopics'] = 'Ogranskade inlägg och ämnen';
$txt['mc_reported_posts'] = 'Anmälda inlägg';
$txt['mc_reported_members'] = 'Rapporterade medlemmar';
$txt['modlog_view'] = 'Moderatorsloggen';
$txt['calendar_menu'] = 'Visa kalendern';

// @todo Send email strings - should move?
$txt['send_email'] = 'Skicka e-post';

$txt['ignoring_user'] = 'Du ignorerar denna användare.';
$txt['show_ignore_user_post'] = 'Visa inlägget.';

$txt['spider'] = 'Robot';
$txt['spiders'] = 'Sökrobotar';

$txt['downloads'] = 'Nedladdningar';
$txt['filesize'] = 'Filstorlek';

// Restore topic
$txt['restore_topic'] = 'Återställ ämne';
$txt['restore_message'] = 'Återställ';
$txt['quick_mod_restore'] = 'Återställ markerade';

// Editor prompt.
$txt['prompt_text_email'] = 'Var god ange e-postadressen.';
$txt['prompt_text_ftp'] = 'Var god ange FTP-adress.';
$txt['prompt_text_url'] = 'Ange den Internetadress du vill länka till';
$txt['prompt_text_img'] = 'Ange bildens Internetadress';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Radera objekt';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Teman:';
$txt['debug_subtemplates'] = 'Undermallar:';
$txt['debug_language_files'] = 'Språkfiler: ';
$txt['debug_stylesheets'] = 'Formatmallar:';
$txt['debug_files_included'] = 'Inkluderade filer:';
$txt['debug_memory_use'] = 'Minnesanvändning:';
$txt['debug_kb'] = 'kB.';
$txt['debug_show'] = 'visa';
$txt['debug_cache_hits'] = 'Cache träffar:';
$txt['debug_cache_misses'] = 'Cache-missar:';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s byte';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss för %2$s byte';
$txt['debug_queries_used'] = 'Antal frågor använda:';
$txt['debug_queries_used_and_warnings'] = 'Antal frågor använda: %1$d, %2$d varningar.';
$txt['debug_query_in_line'] = 'i <em>%1$s</em> rad <em>%2$s</em>,';
$txt['debug_query_which_took'] = 'vilket tog %1$s sekunder. ';
$txt['debug_query_which_took_at'] = 'vilket tog %1$s sekunder vid %2$s att verkställa.';
$txt['debug_show_queries'] = '[Visa frågor]';
$txt['debug_hide_queries'] = '[Dölj frågor]';
$txt['debug_tokens'] = 'Token:';
$txt['debug_browser'] = 'Webbläsare:';
$txt['debug_hooks'] = 'Använda hooks:';
$txt['debug_instances'] = 'Instanser skapade: ';
$txt['are_sure_mark_read'] = 'Är du säker på att du vill markera meddelandena som lästa?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Bilagor är inaktiverade';
$txt['attachments_no_data_loaded'] = 'Inte ett giltigt ID på en bilaga.';
$txt['attachments_not_allowed_to_see'] = 'Du kan inte se denna bilaga.';
$txt['attachments_no_msg_associated'] = 'Inget meddelande assossierat med denna bilaga.';
$txt['attachments_unapproved'] = 'Bilagan väntar på godkännande.';

// Accessibility
$txt['hide_category'] = 'Göm kategori';
$txt['show_category'] = 'Visa kategori';
$txt['hide_infocenter'] = 'Dölj informationscentret';
$txt['show_infocenter'] = 'Visa infocentret';

// Notification post control
$txt['notify_topic_0'] = 'Ignorera';
$txt['notify_topic_1'] = 'Inga underrättelser eller e-postmeddelanden';
$txt['notify_topic_2'] = 'Få underrättelser';
$txt['notify_topic_3'] = 'Få epost och underrättelser';
$txt['notify_topic_0_desc'] = 'Du kommer inte att få epost eller underrättelser för detta ämne och inte heller kommer inte att visas som olästa svar och ämnen. Du får fortfarande @taggar för detta ämne.';
$txt['notify_topic_1_desc'] = 'Du kommer bara få underrättelser eller e-post om någon @taggar dig.';
$txt['notify_topic_2_desc'] = 'Du kommer få underrättelser för detta ämne.';
$txt['notify_topic_3_desc'] = 'Du kommer att få både underrättelser och e-post för detta ämne.';
$txt['notify_board_1'] = 'Inga underrättelser eller e-postmeddelanden';
$txt['notify_board_2'] = 'Få underrättelser';
$txt['notify_board_3'] = 'Få epost och underrättelser';
$txt['notify_board_1_desc'] = 'Du kommer inte att få några underrättelser eller e-post om nya ämnen';
$txt['notify_board_2_desc'] = 'Du kommer få notiser för denna tavla.';
$txt['notify_board_3_desc'] = 'Du kommer få både notiser och e-post för denna tavla.';

$txt['notify_board_prompt'] = 'Vill du få e-post när någon startar ett nytt ämne på den här tavlan?';
$txt['notify_board_subscribed'] = '%1$s prenumererar nu på notifikationer för nya ämnen på denna tavla.';
$txt['notify_board_unsubscribed'] = '%1$s har slutat prenumerera på notifikationer för nya ämnen på denna tavla.';

$txt['notify_topic_prompt'] = 'Vill du få e-post när någon svarar på detta ämne?';
$txt['notify_topic_subscribed'] = '%1$s har börjat prenumerera på notifikationer för nya svar till detta ämne.';
$txt['notify_topic_unsubscribed'] = '%1$s har slutat prenumerera på notifikationer för nya svar till detta ämne.';

$txt['notify_announcements_prompt'] = 'Vill du ta emot nyhetsbrev, tillkännagivanden och andra viktiga meddelanden via e-post?';
$txt['notify_announcements_subscribed'] = '%1$s har börjat prenumerera på nyhetsbrev, tillkännagivande och andra viktiga notifikationer.';
$txt['notify_announcements_unsubscribed'] = '%1$s har slutat prenumerera på nyhetsbrev, tillkännagivande och andra viktiga notifikationer.';

$txt['unsubscribe_announcements_plain'] = 'För att sluta prenumerera på nyhetsbrev, tillkännagivanden och andra viktiga notifikationer, följ denna länk: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Sluta prenumerera</a> på nyhetsbrev, tillkännagivanden och andra viktiga notifikationer.</span>';
$txt['unsubscribe_announcements_manual'] = 'För att sluta prenumerera på forumets nyhetsbrev, tillkännagivanden och andra viktiga notifikationer, följ denna länk: %1$s.';

// Mobile Actions
$txt['mobile_action'] = 'Användaråtgärder';
$txt['mobile_moderation'] = 'Moderering';
$txt['mobile_user_menu'] = 'Huvudmeny';
$txt['mobile_generic_menu'] = '%1$s';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} och {-1}';
$txt['sentence_list_format'][3] = '{series} och {-1}';
$txt['sentence_list_format'][4] = '{series} och {-1}';
$txt['sentence_list_format'][5] = '{series} och {-1}';
$txt['sentence_list_format']['n'] = '{series} och {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>