<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Italiano';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'it_IT';
$txt['lang_dictionary'] = 'it';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'it';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1.234,00';

$txt['days_title'] = 'Giorni';
$txt['days'] = array('Domenica', 'Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato');
$txt['days_short'] = array('Dom', 'Lun', 'Mar', 'Mer', 'Gio', 'Ven', 'Sab');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Mesi';
$txt['months'] = array(1 => 'Gennaio', 2 => 'Febbraio', 3 => 'Marzo', 4 => 'Aprile', 5 => 'Maggio', 6 => 'Giugno', 7 => 'Luglio', 8 => 'Agosto', 9 => 'Settembre', 10 => 'Ottobre', 11 => 'Novembre', 12 => 'Dicembre');
$txt['months_titles'] = array(1 => 'Gennaio', 2 => 'Febbraio', 3 => 'Marzo', 4 => 'Aprile', 5 => 'Maggio', 6 => 'Giugno', 7 => 'Luglio', 8 => 'Agosto', 9 => 'Settembre', 10 => 'Ottobre', 11 => 'Novembre', 12 => 'Dicembre');
$txt['months_short'] = array(1 => 'Gen', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'Mag', 6 => 'Giu', 7 => 'Lug', 8 => 'Ago', 9 => 'Set', 10 => 'Ott', 11 => 'Nov', 12 => 'Dic');
$txt['prev_month'] = 'Mese precedente';
$txt['next_month'] = 'Mese successivo';
$txt['start'] = 'Inizio';
$txt['end'] = 'Fine';
$txt['starts'] = 'Inizia';
$txt['ends'] = 'Finisce';
$txt['none'] = 'Nessuna/o';

$txt['minutes_label'] = 'Minuti';
$txt['hours_label'] = 'Ore';
$txt['years_title'] = 'Anni';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Short form of minutes
$txt['minutes_short'] = 'min';
// Short form of hour
$txt['hour_short'] = 'ora';
// Short form of hours
$txt['hours_short'] = 'ore';
// Decimal sign
$txt['decimal_sign'] = '.';

$txt['admin'] = 'Amministra';
$txt['moderate'] = 'Moderazione';

$txt['save'] = 'Salva';
$txt['reset'] = 'Ripristina';
$txt['upload'] = 'Carica';
$txt['upload_all'] = 'Invia tutti';
$txt['processing'] = 'Elaborazione...';

$txt['modify'] = 'Modifica';
$txt['forum_index'] = '%1$s - Indice';
$txt['members'] = 'Utenti';
$txt['board_name'] = 'Nome sezione';
$txt['posts'] = 'Messaggi';

$txt['member_postcount'] = 'Messaggi';
$txt['no_subject'] = '(Nessun oggetto)';
$txt['view_profile'] = 'Mostra profilo';
$txt['guest_title'] = 'Visitatore';
$txt['author'] = 'Autore';
$txt['on'] = 'il';
$txt['remove'] = 'Elimina';
$txt['start_new_topic'] = 'Apri nuova discussione';

$txt['login'] = 'Accedi';
// Use numeric entities in the below string.
$txt['username'] = 'Nome utente';
$txt['password'] = 'Password';

$txt['username_no_exist'] = 'Questo nome utente non esiste.';
$txt['no_user_with_email'] = 'Non sono presenti nome utenti associati a questo indirizzo e-mail.';

$txt['board_moderator'] = 'Moderatore della sezione';
$txt['remove_topic'] = 'Elimina discussione';
$txt['topics'] = 'Discussioni';
$txt['modify_msg'] = 'Modifica messaggio';
$txt['name'] = 'Nome';
$txt['email'] = 'Email';
$txt['user_email_address'] = 'Indirizzo e-mail';
$txt['subject'] = 'Oggetto';
$txt['message'] = 'Messaggio';
$txt['redirects'] = 'Reindirizzamenti';
$txt['quick_modify'] = 'Modifica rapida';
$txt['quick_modify_message'] = 'Hai modificato con successo questo messaggio.';
$txt['reason_for_edit'] = 'Motivo della modifica';

$txt['choose_pass'] = 'Scegli password';
$txt['verify_pass'] = 'Verifica password';
$txt['notify_announcements'] = 'Ricevi email per le comunicazioni importanti';

$txt['position'] = 'Posizione';

// argument(s): username
$txt['view_profile_of_username'] = 'Mostra il profilo di %1$s';
$txt['total'] = 'Totale';
$txt['website'] = 'Sito web';
$txt['register'] = 'Registrati';
$txt['warning_status'] = 'Stato richiami';
$txt['user_warn_watch'] = 'L\'utente è presente nella lista controllata dai moderatori';
$txt['user_warn_moderate'] = 'I messaggi dell\'utente si aggiungono alla coda dei messaggi da approvare';
$txt['user_warn_mute'] = 'L\'utente non può inviare messaggi';
$txt['warn_watch'] = 'Controllato';
$txt['warn_moderate'] = 'Moderato';
$txt['warn_mute'] = 'Muto (no invio messaggi)';

$txt['message_index'] = 'Indice delle discussioni';
$txt['news'] = 'News';
$txt['home'] = 'Indice';
$txt['page'] = 'Pagina';
$txt['prev'] = 'Pagina precedente';
$txt['next'] = 'Pagina successiva';

$txt['lock_unlock'] = 'Chiudi/Riapri discussione';
$txt['post'] = 'Invia messaggio';
$txt['error_occured'] = 'Si è verificato un errore!';
$txt['at'] = 'su';
$txt['by'] = 'di';
$txt['logout'] = 'Esci';
$txt['started_by'] = 'Aperto da';
$txt['topic_started_by'] = 'Aperto da <strong>%1$s</strong> in <em>%2$s</em>';
$txt['replies'] = 'Risposte';
$txt['last_post'] = 'Ultimo messaggio';
$txt['first_post'] = 'Primo messaggio';
$txt['last_poster'] = 'Ultimo messaggio di';
$txt['last_post_message'] = '<strong>Ultimo messaggio: </strong>%3$s <span class="postby">%2$s di %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>di %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> di <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s Messaggi in %2$s discussioni di %3$s utenti';
$txt['show'] = 'Visualizza';
$txt['hide'] = 'Nascondi';

$txt['admin_login'] = 'Accesso amministrazione';
// Use numeric entities in the below string.
$txt['topic'] = 'Discussione';
$txt['help'] = 'Aiuto';
$txt['terms_and_rules'] = 'Termini di utilizzo';
$txt['watch_board'] = 'Iscriviti a questa sezione';
$txt['unwatch_board'] = 'Annulla iscrizione a questa sezione';
$txt['watch_topic'] = 'Iscriviti a questa discussione';
$txt['unwatch_topic'] = 'Annulla iscrizione discussione';
$txt['watching_topic'] = 'Discussioni che stai seguendo';
$txt['watching_this_topic'] = 'Sei iscritto a questa discussione e riceverai notifiche per i nuovi messaggi.';
$txt['notify'] = 'Attiva notifiche';
$txt['unnotify'] = 'Disattiva notifiche';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Saluti,
il Team di %1$s.';

$txt['notify_replies'] = 'Notifica delle risposte';
$txt['move_topic'] = 'Sposta discussione';
$txt['move_to'] = 'Sposta in';
$txt['pages'] = 'Pagine';
$txt['users_active'] = 'Utenti attivi negli ultimi %1$d minuti';
$txt['personal_messages'] = 'Messaggi Personali';
$txt['reply_quote'] = 'Rispondi citando';
$txt['reply'] = 'Risposta';
$txt['reply_noun'] = 'Rispondi';
$txt['reply_number'] = 'Risposta #%1$s%2$s';
$txt['approve'] = 'Approva';
$txt['unapprove'] = 'Non approvare';
$txt['approve_all'] = 'approva tutti';
$txt['issue_warning'] = 'Invia richiamo';
$txt['awaiting_approval'] = 'In attesa di approvazione';
$txt['attach_awaiting_approve'] = 'Allegati in attesa di approvazione';
$txt['post_awaiting_approval'] = 'Questo messaggio è in attesa di approvazione da parte di un moderatore.';
$txt['there_are_unapproved_topics'] = 'Ci sono %1$s discussioni e %2$s messaggi in attesa di approvazione per questa categoria. Clicca <a href="%3$s">qui</a> per visualizzarli tutti.';
$txt['send_message'] = 'Invia messaggio';

$txt['msg_alert_no_messages'] = 'non ci sono messaggi';
$txt['msg_alert_one_message'] = 'hai <a href="%1$s">1 messaggio</a>';
$txt['msg_alert_many_message'] = 'hai <a href="%1$s">%2$d messaggi</a>';
$txt['msg_alert_one_new'] = '1 è nuovo';
$txt['msg_alert_many_new'] = '%1$d sono nuovi';
$txt['new_alert'] = 'Nuovo avviso';
$txt['remove_message'] = 'Elimina questo messaggio';
$txt['remove_message_question'] = 'Elimina messaggio?';

$txt['topic_alert_none'] = 'Nessun messaggio...';
$txt['pm_alert_none'] = 'Nessun messaggio...';
$txt['no_messages'] = 'Nessun messaggio';

$txt['online_users'] = 'Utenti online';
$txt['jump_to'] = 'Vai a';
$txt['go'] = 'Vai';
$txt['are_sure_remove_topic'] = 'Sei sicuro di voler eliminare questa discussione?';
$txt['yes'] = 'Sì';
$txt['no'] = 'No';

$txt['search_end_results'] = 'Fine dei risultati';
$txt['search_on'] = 'il';

$txt['search'] = 'Cerca';
$txt['all'] = 'Tutto';
$txt['search_entireforum'] = 'Intero forum';
$txt['search_thisboard'] = 'Questa sezione';
$txt['search_thistopic'] = 'Questa discussione';
$txt['search_members'] = 'Utenti';

$txt['back'] = 'Indietro';
$txt['continue'] = 'Continua';
$txt['password_reminder'] = 'Promemoria password';
$txt['topic_started'] = 'Discussione aperta da';
$txt['title'] = 'Titolo';
$txt['post_by'] = 'Inserito da';
$txt['memberlist_searchable'] = 'Elenco di tutti gli utenti registrati.';
$txt['welcome_newest_member'] = 'Date il benvenuto a %1$s, ultimo utente registrato.';
$txt['admin_center'] = 'Centro amministrazione';
$txt['last_edit_by'] = '<span class="lastedit">Ultima modifica</span>: %1$s di %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Motivo</span>: %1$s ';
$txt['notify_deactivate'] = 'Desideri disattivare le notifiche per questa discussione?';
$txt['modified_time'] = 'Ultima modifica';
$txt['modified_by'] = 'Modificato da';

$txt['recent_posts'] = 'Messaggi recenti';

$txt['location'] = 'Posizione';
$txt['location_desc'] = 'Posizione geografica.';
$txt['gender'] = 'Sesso';
$txt['gender_0'] = 'Non specificato';
$txt['gender_1'] = 'Uomo';
$txt['gender_2'] = 'Donna';
$txt['gender_desc'] = 'Il tuo sesso.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Il tuo numero ICQ.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Nome utente Skype';
$txt['personal_text'] = 'Frase personale';
$txt['date_registered'] = 'Data di registrazione';

$txt['recent_view'] = 'Mostra gli ultimi messaggi del forum.';
$txt['recent_updated'] = 'è la discussione aggiornata più di recente';
$txt['is_recent_updated'] = '%1$s è la discussione aggiornata più di recente';

$txt['male'] = 'Maschio';
$txt['female'] = 'Femmina';

$txt['error_invalid_characters_username'] = 'Sono presenti caratteri non validi nel nome utente.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Benvenuto su <strong>%1$s</strong>. <a href="%2$s" onclick="%3$s">Accedi</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Benvenuto su <strong>%1$s</strong>. <a href="%2$s" onclick="%3$s">Accedi</a> o <a href="%4$s">registrati</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Non hai ricevuto l\'email di attivazione?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Non hai un account? <a href="%1$s?action=signup">Registrati</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Benvenuto su <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Ciao,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Benvenuto,';
$txt['select_destination'] = 'Scegliere una destinazione';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Inserito da';

$txt['icon_smiley'] = 'Sorriso';
$txt['icon_angry'] = 'Adirato';
$txt['icon_cheesy'] = 'Felice';
$txt['icon_laugh'] = 'Risata';
$txt['icon_sad'] = 'Triste';
$txt['icon_wink'] = 'Occhiolino';
$txt['icon_grin'] = 'Ghigno';
$txt['icon_shocked'] = 'Scioccato';
$txt['icon_cool'] = 'Fico';
$txt['icon_huh'] = 'Attonito';
$txt['icon_rolleyes'] = 'Occhi al cielo';
$txt['icon_tongue'] = 'Linguaccia';
$txt['icon_embarrassed'] = 'Imbarazzato';
$txt['icon_lips'] = 'Bocca cucita';
$txt['icon_undecided'] = 'Indeciso';
$txt['icon_kiss'] = 'Bacio';
$txt['icon_cry'] = 'Pianto';

$txt['moderator'] = 'Moderatore';
$txt['moderators'] = 'Moderatori';

$txt['views'] = 'Visite';
$txt['new'] = 'Nuovo';

$txt['view_all_members'] = 'Visualizza tutti gli utenti';
$txt['view'] = 'Vedi';

$txt['viewing_members'] = 'Visualizzazione degli utenti da %1$s a %2$s';
$txt['of_total_members'] = 'di %1$s utenti totali';

$txt['forgot_your_password'] = 'Dimenticato la password?';

$txt['date'] = 'Data';
// Use numeric entities in the below string.
$txt['from'] = 'Da';
$txt['check_new_messages'] = 'Controlla nuovi messaggi';
$txt['to'] = 'A';

$txt['board_topics'] = 'Discussioni';
$txt['members_title'] = 'Utenti';
$txt['members_list'] = 'Elenco utenti';
$txt['new_posts'] = 'Nuovi messaggi';
$txt['old_posts'] = 'Nessun nuovo messaggio';
$txt['redirect_board'] = 'Reindirizzamento';

$txt['sendtopic_send'] = 'Invia';
$txt['report_sent'] = 'Il tuo report è stato inviato con successo';
$txt['post_becomes_unapproved'] = 'Il tuo messaggio non è stato approvato perché è hai risposto ad una discussione non approvata. Quando la discussione sarà approvata anche il tuo messaggio verrà approvato.';

$txt['time_offset'] = 'Ore di differenza';
$txt['or'] = 'o';

$txt['no_matches'] = 'Non è stata trovata alcuna corrispondenza';

$txt['notification'] = 'Notifica';

$txt['your_ban'] = '%1$s, sei stato bannato da questo forum!';
$txt['your_ban_expires'] = 'Questo ban terminerà il %1$s.';
$txt['your_ban_expires_never'] = 'Questo ban non ha scadenza.';
$txt['ban_continue_browse'] = 'Puoi continuare a visualizzare il forum come visitatore.';

$txt['mark_as_read'] = 'Marca tutti i messaggi come letti';

$txt['locked_topic'] = 'Discussione chiusa';
$txt['normal_topic'] = 'Discussione normale';
$txt['participation_caption'] = 'Discussione a cui hai partecipato';
$txt['moved_topic'] = 'Discussione spostata in altra sezione';

$txt['go_caps'] = 'Vai';

$txt['print'] = 'Stampa';
$txt['profile'] = 'Profilo';
$txt['topic_summary'] = 'Sommario della discussione';
$txt['not_applicable'] = 'N/D';
$txt['name_in_use'] = 'Questo nome è già utilizzato da un altro utente.';

$txt['total_members'] = 'Utenti in totale';
$txt['total_posts'] = 'Messaggi totali';
$txt['total_topics'] = 'Totale discussioni';

$txt['time_logged_in'] = 'Rimani connesso per ';

$txt['preview'] = 'Anteprima';
$txt['always_logged_in'] = 'Sempre';

$txt['logged'] = 'Registrato';
$txt['show_ip'] = 'Mostra indirizzo IP';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';
$txt['url'] = 'URL';
$txt['www'] = 'WWW';

$txt['hours'] = 'ore';
$txt['minutes'] = 'minuti';
$txt['seconds'] = 'secondi';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Ora';
$txt['days_word'] = 'giorni';

$txt['search_for'] = 'Cerca';
$txt['search_match'] = 'Metodo';

$txt['forum_in_maintenance'] = 'Il forum è in Modalità Manutenzione. Al momento possono effettuare l\'accesso solo gli amministratori.';
$txt['maintenance_page'] = 'Puoi disattivare la Modalità Manutenzione dal menu <a href="%1$s">Impostazioni Server</a>.';

$txt['read_one_time'] = 'Letto 1 volta';
$txt['read_many_times'] = 'Letto %1$d volte';

$txt['forum_stats'] = 'Statistiche forum';
$txt['latest_member'] = 'Ultimo utente';
$txt['total_cats'] = 'Categorie in totale';
$txt['latest_post'] = 'Ultimo messaggio';

$txt['total_boards'] = 'Sezioni totali';

$txt['print_page'] = 'Pagina di stampa';
$txt['print_page_text'] = 'Solo testo';
$txt['print_page_images'] = 'Testo con Immagini';

$txt['valid_email'] = 'È necessario inserire un indirizzo email valido.';

$txt['geek'] = 'Sono un geek!!';
$txt['info_center_title'] = '%1$s - Centro Informazioni';

$txt['watch'] = 'Iscriviti';
$txt['unwatch'] = 'Annulla iscrizione';

$txt['check_all'] = 'Seleziona tutto';

// Use numeric entities in the below string.
$txt['database_error'] = 'Errore del Database';
$txt['try_again'] = 'Per favore riprova. Se riappare questa schermata, segnala il problema ad un amministratore.';
$txt['file'] = 'File';
$txt['line'] = 'Linea';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF ha rilevato un errore nel database ed ha provato a correggerlo automaticamente.  Se il problema persiste o si riceve in continuazione questa e-mail contattare il proprio provider.';
$txt['database_error_versions'] = '<strong>Nota:</strong> Sembra che il tuo database <em>debba</em> essere aggiornato. I file del forum risultano attualmente alla versione %1$s, mentre il database corrisponde alla versione %2$s. Il problema potrebbe essere risolto eseguendo l\'ultima versione del file upgrade.php.';
$txt['template_parse_error'] = 'Errore nella scansione del template!';
$txt['template_parse_error_message'] = 'Sembra che qualcosa si sia bloccato nel sistema dei temi del forum.  Il problema dovrebbe essere temporaneo: riprovare in un secondo momento. Se questo messaggio non scompare contattare un amministratore.<br><br>Puoi anche provare a <a href="javascript:location.reload();">ricaricare la pagina</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'C\'è un problema con il caricamento del <pre><strong>%1$s</strong></pre> template o del file di traduzione. Controlla la sintassi e riprova - ricorda, le virgolette semplici (<pre>\'</pre>) devo essere precedute da una barra (<pre>\\</pre>). Per visualizzare ulteriori informazioni su errori PHP prova ad <a href="%2$s%1$s">accedere direttamente al file</a>.<br><br><a href="javascript:location.reload();">Aggiorna questa pagina</a> o <a href="%3$s?theme=1">usa il tema di default</a>.';
$txt['template_parse_errmsg'] = 'Sfortunatamente non ci sono altre informazioni disponibili.';

$txt['today'] = '<strong>Oggi</strong> alle ';
$txt['yesterday'] = '<strong>Ieri</strong> alle ';
$txt['new_poll'] = 'Nuovo sondaggio';
$txt['poll_question'] = 'Domanda';
$txt['poll_vote'] = 'Invia voto';
$txt['poll_total_voters'] = 'Totale votanti';
$txt['poll_results'] = 'Visualizza risultati';
$txt['poll_lock'] = 'Chiudi votazioni';
$txt['poll_unlock'] = 'Riapri votazioni';
$txt['poll_edit'] = 'Modifica sondaggio';
$txt['poll'] = 'Sondaggio';
$txt['one_hour'] = '1 ora';
$txt['one_day'] = '1 giorno';
$txt['one_week'] = '1 settimana';
$txt['two_weeks'] = '2 settimane';
$txt['one_month'] = '1 mese';
$txt['two_months'] = '2 mesi';
$txt['forever'] = 'Rimani sempre connesso';
$txt['moved'] = 'SPOSTATO';
$txt['move_why'] = 'Inserisci una breve descrizione del motivo per cui questa discussione viene spostata.';
$txt['board'] = 'Sezione';
$txt['in'] = 'in';
$txt['sticky_topic'] = 'Discussione in evidenza';

$txt['delete'] = 'Elimina';
$txt['no_change'] = 'Nessun cambiamento';

$txt['your_pms'] = 'Messaggi privati';

$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Altre statistiche]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Codice';
$txt['code_select'] = 'Seleziona';
$txt['code_expand'] = 'Espandi';
$txt['code_shrink'] = 'Riduci';
$txt['quote_from'] = 'Citazione di';
$txt['quote'] = 'Citazione';
$txt['quote_action'] = 'Citazione';
$txt['quote_selected_action'] = 'Cita il testo selezionato';
$txt['fulledit'] = 'Modifica&nbsp;completa';
$txt['edit'] = 'Modifica';
$txt['quick_edit'] = 'Modifica rapida';
$txt['post_options'] = 'Altro...';

$txt['merge_to_topic_id'] = 'ID della discussione di destinazione';
$txt['split'] = 'Dividi discussione';
$txt['merge'] = 'Unisci discussione';
$txt['target_id'] = 'Seleziona destinazione per ID discussione';
$txt['target_below'] = 'Seleziona la destinazione dalla lista qui sotto';
$txt['subject_new_topic'] = 'Titolo della nuova discussione';
$txt['split_this_post'] = 'Dividi solamente questo messaggio.';
$txt['split_after_and_this_post'] = 'Dividi la discussione da questo messaggio.';
$txt['select_split_posts'] = 'Scegliere i messaggi da dividere.';
$txt['new_topic'] = 'Nuova discussione';
$txt['split_successful'] = 'La discussione è stata correttamente divisa in due discussioni distinte.';
$txt['origin_topic'] = 'Discussione originale';
$txt['please_select_split'] = 'Seleziona i messaggi da dividere.';
$txt['merge_successful'] = 'Le discussioni sono state unite correttamente.';
$txt['new_merged_topic'] = 'Nuova discussione unita';
$txt['topic_to_merge'] = 'Discussione da unire';
$txt['target_board'] = 'Sezione di destinazione';
$txt['target_topic'] = 'Discussione di destinazione';
$txt['merge_desc'] = 'Questa funzionalità unirà i messaggi di due discussioni diverse in una sola. I messaggi verranno ordinati secondo la data di inserimento, quindi il messaggio più vecchio diventerà il primo della discussione unita.';

$txt['set_sticky'] = 'Discussione in evidenza';
$txt['set_nonsticky'] = 'Discussione non in evidenza';
$txt['set_lock'] = 'Chiudi discussione';
$txt['set_unlock'] = 'Riapri discussione';

$txt['search_advanced'] = 'Ricerca avanzata';

$txt['security_risk'] = 'GRAVE RISCHIO DI SICUREZZA:';
$txt['not_removed'] = 'Non hai rimosso ';
$txt['not_removed_extra'] = '%1$s è un backup di %2$s non generato da SMF. Potrebbe essere usato da malintenzionati per accedere al forum o ottenere i privilegi da amministratore. Dovresti eliminarlo immediatamente.';
$txt['generic_warning'] = 'Attenzione';
$txt['agreement_missing'] = 'Stai richiedendo ai nuovi utenti di accettare un accordo di registrazione ma il file (agreement.txt) non esiste.';
$txt['policy_agreement_missing'] = 'Stai richiedendo ai nuovi utenti di accettare l\'informativa sulla privacy ma l\'informativa è vuota.';
$txt['auth_secret_missing'] = 'Non è possibile impostare la password di autenticazione in Settings.php. Questo diminuisce la sicurezza del tuo forum e lo mette a rischio di attacchi. Controlla i permessi del file Settings.php per assicurarti che SMF possa scrivere sul file.';

$txt['cache_writable'] = 'La cartella dedicata alla cache non dispone di adeguati permessi di scrittura, questo inciderà pesantemente sulle prestazioni del tuo forum.';

$txt['page_created_full'] = 'Pagina creata in %1$.3f secondi con %2$d interrogazioni.';

$txt['report_to_mod_func'] = 'Utilizza questa funzione per segnalare ai moderatori e amministratori un messaggio offensivo oppure inserito nella sezione sbagliata.';
$txt['report_profile_func'] = 'Usa questa funzione per informare gli amministratori di contenuti offensivi o indesiderati come spam o immagini inappropriate.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s è online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s è offline';
$txt['pm_online'] = 'Messaggio privato (Online)';
$txt['pm_offline'] = 'Messaggio privato (Offline)';
$txt['status'] = 'Stato';

$txt['go_up'] = 'Vai su';
$txt['go_down'] = 'Vai giù';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="License" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Compleanni:';
$txt['events'] = 'Eventi:';
$txt['birthdays_upcoming'] = 'Prossimi compleanni:';
$txt['events_upcoming'] = 'Prossimi eventi:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Festività:';
$txt['calendar_month'] = 'Mese';
$txt['calendar_year'] = 'Anno';
$txt['calendar_day'] = 'Giorno';
$txt['calendar_event_title'] = 'Titolo evento';
$txt['calendar_event_options'] = 'Opzioni evento';
$txt['calendar_post_in'] = 'Inserito in';
$txt['calendar_edit'] = 'Modifica evento';
$txt['calendar_export'] = 'Esporta evento';
$txt['calendar_view_week'] = 'Visualizza settimana';
$txt['event_delete_confirm'] = 'Eliminare questo evento?';
$txt['event_delete'] = 'Elimina evento';
$txt['calendar_post_event'] = 'Inserisci evento';
$txt['calendar'] = 'Calendario';
$txt['calendar_link'] = 'Link al calendario';
$txt['calendar_upcoming'] = 'Prossimi eventi';
$txt['calendar_today'] = 'Calendario di oggi';
$txt['calendar_week'] = 'Settimana';
$txt['calendar_week_title'] = 'Settimana %1$d di %2$d ';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Inizio settimana %2$s %1$s %3$s';
$txt['calendar_numb_days'] = 'Numero di giorni';
$txt['calendar_how_edit'] = 'come modificare questi eventi?';
$txt['calendar_link_event'] = 'Collegamento all\'evento da inserire';
$txt['calendar_confirm_delete'] = 'Sei sicuro di voler eliminare questo evento?';
$txt['calendar_linked_events'] = 'Eventi collegati';
$txt['calendar_click_all'] = 'clicca per vedere tutti %1$s';
$txt['calendar_allday'] = 'Tutto il giorno';
$txt['calendar_timezone'] = 'Fuso orario';
$txt['calendar_list'] = 'Lista';
$txt['calendar_empty'] = 'Non ci sono eventi da visualizzare.';

$txt['movetopic_change_subject'] = 'Cambia l\'oggetto della discussione';
$txt['movetopic_new_subject'] = 'Nuovo oggetto';
$txt['movetopic_change_all_subjects'] = 'Cambia l\'oggetto di tutti i messaggi';
$txt['move_topic_unapproved_js'] = 'Attenzione! Questa discussione non è ancora stata approvata.\n\nNon è consigliato creare una discussione di reindirizzamento, a meno che tu non voglia approvare il messaggio immediatamente dopo.';
$txt['movetopic_auto_board'] = '[SEZIONE]';
$txt['movetopic_auto_topic'] = '[LINK TOPIC]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Questa discussione è stata spostata in %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Reindirizza alla discussione spostata';

$txt['post_redirection'] = 'Inserisci una discussione di reindirizzamento';
$txt['redirect_topic_expires'] = 'Elimina automaticamente tutte le discussioni di reindirizzamento
';
$txt['mergetopic_redirect'] = 'Reindirizza alla discussione unita';
$txt['merge_topic_unapproved_js'] = 'Attenzione! Questa discussione non è stata ancora approvata.\n\nNon si consiglia di creare una discussione di reindirizzamento a meno che non si intenda approvare il messaggio immediatamente dopo l\'unione.';

$txt['theme_template_error'] = 'Impossibile caricare il template \'%1$s\'.';
$txt['theme_language_error'] = 'Impossibile caricare il file di traduzione \'%1$s\'.';

$txt['sub_boards'] = 'Sotto-Sezioni';
$txt['restricted_board'] = 'Sezione riservata';

$txt['smtp_no_connect'] = 'Impossibile collegarsi al server SMTP';
$txt['smtp_port_ssl'] = 'Impostazione porta SMTP errata; dovrebbe essere 465 per i server SSL. Potrebbe essere necessario inserire il prefisso ssl://';
$txt['smtp_bad_response'] = 'Impossibile ottenere una risposta dal server di posta elettronica';
$txt['smtp_error'] = 'Si sono verificati dei problemi nell\'invio dell\'e-mail. Errore: ';
$txt['mail_send_unable'] = 'Impossibile inviare una mail all\'indirizzo \'%1$s\'';

$txt['mlist_search'] = 'Cerca utenti';
$txt['mlist_search_again'] = 'Nuova ricerca';
$txt['mlist_search_filter'] = 'Opzioni di ricerca';
$txt['mlist_search_email'] = 'Cerca per indirizzo email';
$txt['mlist_search_messenger'] = 'Cerca per nickname di Messenger';
$txt['mlist_search_group'] = 'Cerca per posizione';
$txt['mlist_search_name'] = 'Cerca per nome';
$txt['mlist_search_website'] = 'Cerca per sito';
$txt['mlist_search_results'] = 'Cerca nei risultati per';
$txt['mlist_search_by'] = 'Cerca per %1$s';
$txt['mlist_menu_view'] = 'Visualizzare la lista degli utenti';

$txt['attach_downloaded'] = 'Scaricato %1$d volte';
$txt['attach_viewed'] = 'Visualizzato %1$d volte';

$txt['settings'] = 'Impostazioni';
$txt['never'] = 'Mai';
$txt['more'] = 'altri';
$txt['etc'] = 'ecc.';

$txt['hostname'] = 'Nome host';
$txt['you_are_post_banned'] = 'Spiacente %1$s, sei stato bannato da questo forum, non puoi più aggiungere messaggi o inviare messaggi privati.';
$txt['ban_reason'] = 'Motivo';
$txt['select_item_check'] = 'Seleziona almeno un elemento nell\'elenco';

$txt['tables_optimized'] = 'Tabelle del database ottimizzate';

$txt['add_poll'] = 'Aggiungi sondaggio';
$txt['poll_options_limit'] = 'Puoi selezionare fino a %1$s opzioni.';
$txt['poll_remove'] = 'Elimina sondaggio';
$txt['poll_remove_warn'] = 'Sei sicuro di voler rimuovere questo sondaggio dalla discussione?';
$txt['poll_results_expire'] = 'I risultati verranno mostrati a votazione conclusa';
$txt['poll_expires_on'] = 'Le votazioni chiudono';
$txt['poll_expired_on'] = 'Le votazioni sono chiuse';
$txt['poll_change_vote'] = 'Rimuovi voto';
$txt['poll_return_vote'] = 'Opzioni di voto';
$txt['poll_cannot_see'] = 'Al momento, non è possibile vedere i risultati di questo sondaggio.';

$txt['quick_mod_approve'] = 'Approva i selezionati';
$txt['quick_mod_remove'] = 'Rimuovi selezionati';
$txt['quick_mod_lock'] = 'Chiudi/Apri selezionate';
$txt['quick_mod_sticky'] = 'Imposta/Togli i selezionati in evidenza';
$txt['quick_mod_move'] = 'Sposta selezionati in';
$txt['quick_mod_merge'] = 'Unisci selezionati';
$txt['quick_mod_markread'] = 'Marca selezionato come letto';
$txt['quick_mod_markunread'] = 'Marca selezionato come non letto';
$txt['quick_mod_selected'] = 'Con le opzioni selezionate fai';
$txt['quick_mod_go'] = 'Vai';
$txt['quickmod_confirm'] = 'Sicuro di voler procedere?';

$txt['spell_check'] = 'Controllo ortografico';

$txt['quick_reply'] = 'Risposta rapida';
$txt['quick_reply_warning'] = 'Attenzione! Questa discussione è bloccata, solo gli amministratori e i moderatori potranno inserire ulteriori risposte.';
$txt['quick_reply_verification'] = 'Dopo l\'invio sarai reindirizzato alla pagina del messaggio per verificarlo %1$s.';
$txt['quick_reply_verification_guests'] = '(richiesta per tutti i visitatori)';
$txt['quick_reply_verification_posts'] = '(richiesta per tutti gli utenti con meno di %1$d messaggi)';
$txt['wait_for_approval'] = 'Nota: questo messaggio verrà visualizzato solamente dopo essere stato approvato da un moderatore.';

$txt['notification_enable_board'] = 'Sei sicuro di voler attivare le notifiche per la nuova discussioni aperte in questa sezione?';
$txt['notification_disable_board'] = 'Sei sicuro di voler disattivare le notifiche per le nuove discussioni aperte in questa sezione?';
$txt['notification_enable_topic'] = 'Sei sicuro di voler attivare le notifiche per i nuovi messaggi inseriti in questa discussione?';
$txt['notification_disable_topic'] = 'Sei sicuro di voler disattivare le notifiche per i nuovi messaggi inseriti in questa discussione?';

// Mentions
$txt['mentions'] = 'Menzioni';

// Likes
$txt['likes'] = 'Mi piace';
$txt['like'] = 'Mi piace';
$txt['unlike'] = 'Non mi piace';
$txt['like_success'] = 'Il tuo contenuto è stato apprezzato con successo.';
$txt['like_delete'] = 'Il tuo account è stato eliminato correttamente.';
$txt['like_insert'] = 'Il tuo account è stato eliminato correttamente.';
$txt['like_error'] = 'Si è verificato un errore con la tua richiesta.';
$txt['like_disable'] = 'La funzione Mi piace è disabilitata.';
$txt['not_valid_like_type'] = 'Il tipo di Mi piace non è valido.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = 'Piace a <a href="%1$s">%2$s persona</a>.';
$txt['likes_n'] = 'Piace a <a href="%1$s">%2$s persone</a>.';
$txt['you_likes_0'] = 'Ti piace.';
$txt['you_likes_1'] = 'Piace a te e a <a href="%1$s">%2$s persona</a>.';
$txt['you_likes_n'] = 'Piace a te e a <a href="%1$s">%2$s persone</a>.';

$txt['report_to_mod'] = 'Segnala';
$txt['report_profile'] = 'Segnala profilo di %1$s';

$txt['unread_topics_visit'] = 'Discussioni recenti non lette';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Non ci sono discussioni non lette dall\'ultima visita. <a href="%1$s?action=unread;all">Mostra tutte le discussioni non lette</a>.';
$txt['updated_topics_visit_none'] = 'Non ci sono discussioni aggiornate dall\'ultima visita.';
$txt['unread_topics_all'] = 'Tutte le discussioni non lette';
$txt['unread_replies'] = 'Discussioni aggiornate';

$txt['who_title'] = 'Chi è collegato';
$txt['who_and'] = ' e ';
$txt['who_viewing_topic'] = ' stanno visualizzando questa discussione.';
$txt['who_viewing_board'] = ' stanno visualizzando questa sezione.';
$txt['who_member'] = 'Utente';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Powered by PHP';
$txt['powered_by_mysql'] = 'Powered by MySQL';
$txt['valid_css'] = 'CSS valido';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Visitatore';
$txt['guests'] = 'Visitatori';
$txt['user'] = 'Utente';
$txt['users'] = 'Utenti';
$txt['hidden'] = 'Nascosto';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Nascosto';
$txt['buddy'] = 'Amico';
$txt['buddies'] = 'Amici';
$txt['most_online_ever'] = 'Record assoluto di presenze';
$txt['most_online_today'] = 'Record odierno di presenze';

$txt['merge_select_target_board'] = 'Scegliere la sezione di destinazione per la discussione unita';
$txt['merge_select_poll'] = 'Scegliere quale sondaggio dovrà avere la discussione unita';
$txt['merge_topic_list'] = 'Scegliere le discussioni da unire';
$txt['merge_select_subject'] = 'Scegliere l\'oggetto per la discussione unita';
$txt['merge_custom_subject'] = 'Oggetto personalizzato';
$txt['merge_include_notifications'] = 'Includi le notifiche?';
$txt['merge_check'] = 'Unisci?';
$txt['merge_no_poll'] = 'Nessun sondaggio';
$txt['merge_why'] = 'Inserisci una breve descrizione del motivo per cui questi argomenti vengono uniti.';
$txt['merged_subject'] = '[UNITO] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Questa discussione è stata unita con %2$s.';

$txt['response_prefix'] = 'Re: ';
$txt['current_icon'] = 'Icona corrente';
$txt['message_icon'] = 'Icona del messaggio';

$txt['smileys_current'] = 'Pacchetto di emoticon corrente';
$txt['smileys_none'] = 'Nessuna emoticon';
$txt['smileys_forum_board_default'] = 'Predefinito del forum/sezione';

$txt['search_results'] = 'Risultati ricerca';
$txt['search_no_results'] = 'Spiacente, nessuna corrispondenza trovata';

$txt['total_time_logged_days'] = ' giorni, ';
$txt['total_time_logged_hours'] = ' ore e ';
$txt['total_time_logged_minutes'] = ' minuti';
$txt['total_time_logged_d'] = 'g ';
$txt['total_time_logged_h'] = 'o ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'Utenti da approvare';

$txt['activate_code'] = 'Il codice di attivazione è';

$txt['find_members'] = 'Cerca un utente';
$txt['find_username'] = 'Nome, nome utente o indirizzo e-mail';
$txt['find_buddies'] = 'Mostrare solo gli amici?';
$txt['find_wildcards'] = 'Caratteri jolly consentiti: *, ?';
$txt['find_no_results'] = 'Nessuna corrispondenza trovata';
$txt['find_results'] = 'Risultati';
$txt['find_close'] = 'Chiudi';

$txt['unread_since_visit'] = 'Mostra i messaggi non letti dall\'ultima visita';
$txt['show_unread_replies'] = 'Mostra le nuove risposte alle discussioni a cui hai partecipato';

$txt['change_color'] = 'Modifica colore';

$txt['quickmod_delete_selected'] = 'Rimuovi selezionati';
$txt['quickmod_split_selected'] = 'Dividi selezionato';

$txt['show_personal_messages_heading'] = 'Nuovi messaggi';
$txt['show_personal_messages'] = 'Hai <strong>%1$s</strong> messaggi privati non letti.<br><br><a href="%2$s">Visualizza messaggi privati</a>';

$txt['help_popup'] = 'Hai bisogno di aiuto? Ecco qualche informazione:';

$txt['previous_next_back'] = 'Discussione precedente';
$txt['previous_next_forward'] = 'Discussione successiva';

$txt['mark_unread'] = 'Marca come non letto';

$txt['ssi_not_direct'] = 'Non accedere al file SSI.php tramite URL diretto; utilizzare il percorso(%1$s) o aggiungi ?ssi_function=qualcosa.';
$txt['ssi_session_broken'] = 'SSI.php non è riuscito a caricare la sessione! Questo potrebbe provocare alcuni problemi nella disconnessione e in altre funzioni - assicurarsi che SSI.php sia incluso prima di *qualsiasi* altra cosa negli script!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Anteprima messaggio';
$txt['preview_fetch'] = 'Recupero anteprima in corso...';
$txt['preview_new'] = 'Nuovo messaggio';
$txt['pm_error_while_submitting'] = 'Il seguente errore o i seguenti errori si sono verificati durante l\'invio di questo messaggio privato:';
$txt['error_while_submitting'] = 'Il seguente errore o i seguenti errori si sono verificati durante l\'invio del messaggio:';
$txt['error_old_topic'] = 'Attenzione: non sono stati aggiunti messaggi in questa discussione negli ultimi %1$d giorni.<br>A meno che tu non voglia realmente rispondere, prendi in considerazione l\'idea di iniziare un nuova discussione.';

$txt['split_selected_posts'] = 'Messaggi selezionati';
$txt['split_selected_posts_desc'] = 'I messaggi qui sotto formeranno una nuova discussione dopo la divisione.';
$txt['split_reset_selection'] = 'azzera selezione';

$txt['modify_cancel'] = 'Annulla';
$txt['modify_cancel_all'] = 'Cancella tutti';
$txt['mark_read_short'] = 'Marca come letto';

$txt['alerts'] = 'Avvisi';

$txt['pm_short'] = 'Messaggi privati';
$txt['pm_menu_read'] = 'Leggi i tuoi messaggi';
$txt['pm_menu_send'] = 'Invia un messaggio privato';

$txt['unapproved_posts'] = 'Messaggi non approvati (Discussione: %1$d, Messaggio: %2$d) ';

$txt['ajax_in_progress'] = 'Caricamento in corso...';

$txt['mod_reports_waiting'] = 'Messaggi segnalati';

$txt['view_unread_category'] = 'Messaggi non letti';
$txt['new_posts_in_category'] = 'Clicca per visualizzare i nuovi messaggi in %1$s';
$txt['verification'] = 'Verifica';
$txt['visual_verification_hidden'] = 'Lasciare vuota questa casella';
$txt['visual_verification_description'] = 'Digita le lettere visualizzate nell\'immagine';
$txt['visual_verification_sound'] = 'Ascolta le lettere visualizzate';
$txt['visual_verification_request_new'] = 'Carica una nuova immagine';

// Sub menu labels
$txt['summary'] = 'Sommario';
$txt['account'] = 'Impostazioni';
$txt['theme'] = 'Visualizzazione';
$txt['forumprofile'] = 'Profilo forum';
$txt['activate_changed_email_title'] = 'Indirizzo Email modificato';
$txt['activate_changed_email_desc'] = 'Hai cambiato il tuo indirizzo email. Per convalidare questo indirizzo, riceverai un\'email. Fai clic sul link in quell\'email per riattivare il tuo account.';
$txt['modSettings_title'] = 'Funzioni e opzioni';
$txt['package'] = 'Gestione MOD';
$txt['errorlog'] = 'Registro errori';
$txt['edit_permissions'] = 'Permessi';
$txt['mc_unapproved_attachments'] = 'Allegati non approvati';
$txt['mc_unapproved_poststopics'] = 'Messaggi e discussioni non approvate';
$txt['mc_reported_posts'] = 'Messaggi segnalati';
$txt['mc_reported_members'] = 'Utenti segnalati';
$txt['modlog_view'] = 'Registro moderazione';
$txt['calendar_menu'] = 'Visualizza calendario';

// @todo Send email strings - should move?
$txt['send_email'] = 'Invia email';

$txt['ignoring_user'] = 'Stai ignorando questo utente.';
$txt['show_ignore_user_post'] = 'Mostrami il messaggio.';

$txt['spider'] = 'Spider';
$txt['spiders'] = 'Spider';

$txt['downloads'] = 'Download';
$txt['filesize'] = 'Dimensione file';

// Restore topic
$txt['restore_topic'] = 'Ripristina discussione';
$txt['restore_message'] = 'Ripristina';
$txt['quick_mod_restore'] = 'Ripristina selezionati';

// Editor prompt.
$txt['prompt_text_email'] = 'Inserisci l\'indirizzo email.';
$txt['prompt_text_ftp'] = 'Inserisci l\'indirizzo FTP.';
$txt['prompt_text_url'] = 'Inserisci il collegamento da aggiungere.';
$txt['prompt_text_img'] = 'Inserisci il percorso dell\'immagine';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Elimina elemento';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Template:';
$txt['debug_subtemplates'] = 'Sotto-template:';
$txt['debug_language_files'] = 'File di traduzione:';
$txt['debug_stylesheets'] = 'Fogli di stile:';
$txt['debug_files_included'] = 'File inclusi:';
$txt['debug_memory_use'] = 'Memoria utilizzata: ';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'visualizza';
$txt['debug_cache_hits'] = 'Accessi alla cache:';
$txt['debug_cache_misses'] = 'Accessi alla cache: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s byte';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss per %2$s byte';
$txt['debug_queries_used'] = 'Interrogazioni utilizzate: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Interrogazioni utilizzate: %1$d, %2$d avvisi.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> riga <em>%2$s</em>,';
$txt['debug_query_which_took'] = 'in %1$s secondi.';
$txt['debug_query_which_took_at'] = 'in %1$s secondi a %2$s in richiesta.';
$txt['debug_show_queries'] = '[Visualizza Interrogazioni]';
$txt['debug_hide_queries'] = '[Nascondi Interrogazioni]';
$txt['debug_tokens'] = 'Tokens: ';
$txt['debug_browser'] = 'Browser ID: ';
$txt['debug_hooks'] = 'Hook utilizzati: ';
$txt['debug_instances'] = 'Istanza creata: ';
$txt['are_sure_mark_read'] = 'Sei sicuro di voler contrassegnare tutti i messaggi come letti?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Gli allegati sono disabilitati';
$txt['attachments_no_data_loaded'] = 'ID allegato non valido.';
$txt['attachments_not_allowed_to_see'] = 'Non puoi visualizzare questo allegato.';
$txt['attachments_no_msg_associated'] = 'Nessun messaggio è associato a questo allegato.';
$txt['attachments_unapproved'] = 'Allegati in attesa di approvazione.';

// Accessibility
$txt['hide_category'] = 'Nascondi categoria';
$txt['show_category'] = 'Mostra categoria';
$txt['hide_infocenter'] = 'Nascondi centro informazioni';
$txt['show_infocenter'] = 'Mostra centro informazioni';

// Notification post control
$txt['notify_topic_0'] = 'Non seguire';
$txt['notify_topic_1'] = 'Nessun avviso o email';
$txt['notify_topic_2'] = 'Ricevi avvisi';
$txt['notify_topic_3'] = 'Ricevi avvisi ed email';
$txt['notify_topic_0_desc'] = 'Non riceverai avvisi o email per questa discussione e non verrà visualizzata nella lista delle discussioni aggiornate e recenti. Riceverai comunque @menzioni per questa discussione.';
$txt['notify_topic_1_desc'] = 'Non riceverai avvisi o email per le nuove risposte ma solamente @menzioni da altri utenti.';
$txt['notify_topic_2_desc'] = 'Riceverai avvisi per le nuove risposte a questa discussione.';
$txt['notify_topic_3_desc'] = 'Riceverai avvisi ed email per le nuove risposte a questa discussione.';
$txt['notify_board_1'] = 'Nessun avviso o email';
$txt['notify_board_2'] = 'Ricevi avvisi';
$txt['notify_board_3'] = 'Ricevi avvisi ed email';
$txt['notify_board_1_desc'] = 'Non riceverai avvisi o email per le nuove discussioni create in questa sezione.';
$txt['notify_board_2_desc'] = 'Riceverai avvisi per le nuove discussioni create in questa sezione.';
$txt['notify_board_3_desc'] = 'Riceverai avvisi ed email per le nuove discussioni create in questa sezione.';

$txt['notify_board_prompt'] = 'Sei sicuro di voler ricevere una notifica quando viene creata una nuova discussione in questa sezione?';
$txt['notify_board_subscribed'] = '%1$s ha attivato le notifiche per le nuove discussioni in questo forum.';
$txt['notify_board_unsubscribed'] = '%1$s ha disattivato le notifiche per le nuove discussioni in questo forum.';

$txt['notify_topic_prompt'] = 'Desideri ricevere una notifica email se questa discussione riceve una risposta?';
$txt['notify_topic_subscribed'] = '%1$s ha attivato le notifiche per le nuove risposte in questa discussione.';
$txt['notify_topic_unsubscribed'] = '%1$s ha disattivato le notifiche per le nuove risposte in questa discussione.';

$txt['notify_announcements_prompt'] = 'Vuoi ricevere email con le newsletter del forum e le comunicazioni importanti?';
$txt['notify_announcements_subscribed'] = '%1$s ha attivato la newsletter del forum e le comunicazioni importanti.';
$txt['notify_announcements_unsubscribed'] = '%1$s ha disattivato la newsletter del forum e le comunicazioni importanti.';

$txt['unsubscribe_announcements_plain'] = 'Per annullare l\'iscrizione a newsletter, annunci e notifiche importanti del forum clicca su questo collegamento: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Annulla iscrizione</a> a newsletter, annunci e notifiche importanti del forum.</span>';
$txt['unsubscribe_announcements_manual'] = 'Per annullare l\'iscrizione alla newsletter, annunci e notifiche importanti del forum, clicca su questo collegamento: %1$s.';

// Mobile Actions
$txt['mobile_action'] = 'Azioni';
$txt['mobile_moderation'] = 'Moderazione';
$txt['mobile_user_menu'] = 'Menu principale';
$txt['mobile_generic_menu'] = '%1$s Menu';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} e {-1}';
$txt['sentence_list_format'][3] = '{series}, e {-1}';
$txt['sentence_list_format'][4] = '{series}, e {-1}';
$txt['sentence_list_format'][5] = '{series}, e {-1}';
$txt['sentence_list_format']['n'] = '{series}, e {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>