<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Norsk';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'no_NO';
$txt['lang_dictionary'] = 'no';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'nb';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1,234.00 ';

$txt['days_title'] = 'Dager';
$txt['days'] = array('søndag', 'mandag', 'tirsdag', 'onsdag', 'torsdag', 'fredag', 'lørdag');
$txt['days_short'] = array('søn', 'man', 'tir', 'ons', 'tor', 'fre', 'lør');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Måneder';
$txt['months'] = array(1 => 'januar', 2 => 'februar', 3 => 'mars', 4 => 'april', 5 => 'mai', 6 => 'juni', 7 => 'juli', 8 => 'august', 9 => 'september', 10 => 'oktober', 11 => 'november', 12 => 'desember');
$txt['months_titles'] = array(1 => 'januar', 2 => 'februar', 3 => 'mars', 4 => 'april', 5 => 'mai', 6 => 'juni', 7 => 'juli', 8 => 'august', 9 => 'september', 10 => 'oktober', 11 => 'november', 12 => 'desember');
$txt['months_short'] = array(1 => 'jan', 2 => 'feb', 3 => 'mar', 4 => 'apr', 5 => 'mai', 6 => 'jun', 7 => 'jul', 8 => 'aug', 9 => 'sep', 10 => 'okt', 11 => 'nov', 12 => 'des');
$txt['prev_month'] = 'Forrige måned';
$txt['next_month'] = 'Neste måned';
$txt['start'] = 'Start';
$txt['end'] = 'Slutt';
$txt['starts'] = 'Starter';
$txt['ends'] = 'Slutter';
$txt['none'] = 'Slått av';

$txt['minutes_label'] = 'Minutter';
$txt['hours_label'] = 'Timer';
$txt['years_title'] = 'År';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Short form of minutes
$txt['minutes_short'] = 'min';
// Short form of hour
$txt['hour_short'] = 't';
// Short form of hours
$txt['hours_short'] = 't';
// Decimal sign
$txt['decimal_sign'] = ',';

$txt['admin'] = 'Administrator';
$txt['moderate'] = 'Moderér';

$txt['save'] = 'Lagre';
$txt['reset'] = 'Nullstill';
$txt['upload'] = 'Last opp';
$txt['upload_all'] = 'Last opp alle';
$txt['processing'] = 'Behandler...';

$txt['modify'] = 'Rediger';
$txt['forum_index'] = '%1$s - Hovedside';
$txt['members'] = 'Medlemmer';
$txt['board_name'] = 'Navn på forum';
$txt['posts'] = 'Innlegg';

$txt['member_postcount'] = 'Innlegg';
$txt['no_subject'] = '(Uten tittel)';
$txt['view_profile'] = 'Vis profil';
$txt['guest_title'] = 'gjest';
$txt['author'] = 'Laget av';
$txt['on'] = 'på';
$txt['remove'] = 'Slett';
$txt['start_new_topic'] = 'Start nytt emne';

$txt['login'] = 'Logg Inn';
// Use numeric entities in the below string.
$txt['username'] = 'Brukernavn';
$txt['password'] = 'Passord';

$txt['username_no_exist'] = 'Brukernavnet eksisterer ikke.';
$txt['no_user_with_email'] = 'Det er ingen brukernavn knyttet til denne e-postadressen.';

$txt['board_moderator'] = 'Moderatorer av forum';
$txt['remove_topic'] = 'Slett emnet';
$txt['topics'] = 'Emner';
$txt['modify_msg'] = 'Rediger innlegg';
$txt['name'] = 'Navn';
$txt['email'] = 'E-post';
$txt['user_email_address'] = 'E-postadresse';
$txt['subject'] = 'Tittel';
$txt['message'] = 'Melding';
$txt['redirects'] = 'Omdirigeringer';
$txt['quick_modify'] = 'Endre integrert';
$txt['quick_modify_message'] = 'Du har endret denne meldingen.';
$txt['reason_for_edit'] = 'Årsak til redigering';

$txt['choose_pass'] = 'Velg passord';
$txt['verify_pass'] = 'Bekreft passord';
$txt['notify_announcements'] = 'Tillat at administrator sender meg viktige nyheter via e-post.';

$txt['position'] = 'Stilling';

// argument(s): username
$txt['view_profile_of_username'] = 'Vis profilen til %1$s';
$txt['total'] = 'Totalt';
$txt['website'] = 'Hjemmeside';
$txt['register'] = 'Registrer deg';
$txt['warning_status'] = 'Status advarsler';
$txt['user_warn_watch'] = 'Brukeren er på moderators overvåkingsliste';
$txt['user_warn_moderate'] = 'Brukerens innlegg er lagt i godkjenningskøen';
$txt['user_warn_mute'] = 'Brukeren er utestengt fra å legge til innlegg';
$txt['warn_watch'] = 'Overvåket';
$txt['warn_moderate'] = 'Modereret';
$txt['warn_mute'] = 'Ignorert';

$txt['message_index'] = 'Oversikt';
$txt['news'] = 'Nyheter';
$txt['home'] = 'Hovedside';
$txt['page'] = 'Side';
$txt['prev'] = 'forrige side';
$txt['next'] = 'neste side';

$txt['lock_unlock'] = 'Steng/åpne emne';
$txt['post'] = 'Legg til innlegg';
$txt['error_occured'] = 'En feil har inntruffet!';
$txt['at'] = 'ved';
$txt['by'] = 'av';
$txt['logout'] = 'Logg ut';
$txt['started_by'] = 'Startet av';
$txt['topic_started_by'] = ' Startet av <strong>%1$s</strong> i <em>%2$s</em> ';
$txt['replies'] = 'Svar';
$txt['last_post'] = 'Siste innlegg';
$txt['first_post'] = 'Første innlegg';
$txt['last_poster'] = 'Siste innlegg av';
$txt['last_post_message'] = '<strong>Siste innlegg: </strong>%3$s<span class="postby">%2$s av %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>av %2$s ';
$txt['post_by_member'] = '<strong>%1$s</strong> av <strong>%2$s</strong><br> ';
$txt['boardindex_total_posts'] = '%1$s innlegg i %2$s emner av %3$s medlemmer';
$txt['show'] = 'Vis';
$txt['hide'] = 'Skjul';

$txt['admin_login'] = 'Logg inn som administrator';
// Use numeric entities in the below string.
$txt['topic'] = 'Emne';
$txt['help'] = 'Hjelp';
$txt['terms_and_rules'] = 'Vilkår og regler';
$txt['watch_board'] = 'Følg dette Forumet';
$txt['unwatch_board'] = 'Avslutt å følge dette Forumet';
$txt['watch_topic'] = 'Følg dette emnet';
$txt['unwatch_topic'] = 'Slutt å følge dette emnet';
$txt['watching_topic'] = 'Emne du ser på';
$txt['watching_this_topic'] = 'Du følger dette temaet, og vil motta varslinger fra det.';
$txt['notify'] = 'Varsling';
$txt['unnotify'] = 'Stopp varsling';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'hilsen,
%1$s -teamet.';

$txt['notify_replies'] = 'Varsling ved svar';
$txt['move_topic'] = 'Flytt emne';
$txt['move_to'] = 'Flytt til';
$txt['pages'] = 'Sider';
$txt['users_active'] = 'Brukere aktive siste %1$d minutter';
$txt['personal_messages'] = 'Personlige meldinger';
$txt['reply_quote'] = 'Svar med sitat';
$txt['reply'] = 'Svar';
$txt['reply_noun'] = 'Svar';
$txt['reply_number'] = 'Svar #%1$s %2$s';
$txt['approve'] = 'Godkjenn';
$txt['unapprove'] = 'Ikke godkjent';
$txt['approve_all'] = 'godkjenn alle';
$txt['issue_warning'] = 'Gi advarsel';
$txt['awaiting_approval'] = 'Venter på godkjenning';
$txt['attach_awaiting_approve'] = 'Vedlegg venter på godkjenning';
$txt['post_awaiting_approval'] = 'Merk: Denne meldingen avventer godkjennelse av en moderator.';
$txt['there_are_unapproved_topics'] = 'Det er %1$s emner og %2$s innlegg som venter godkjenning i dette forumet. Klikk <a href="%3$s">her</a> for å vise dem alle.';
$txt['send_message'] = 'Send melding';

$txt['msg_alert_no_messages'] = 'du har ingen melding';
$txt['msg_alert_one_message'] = 'du har <a href="%1$s">1 melding</a> ';
$txt['msg_alert_many_message'] = 'du har <a href="%1$s">%2$d meldinger</a>';
$txt['msg_alert_one_new'] = '1 er ny';
$txt['msg_alert_many_new'] = '%1$d er nye';
$txt['new_alert'] = 'Nytt varsel';
$txt['remove_message'] = 'Fjern dette innlegget';
$txt['remove_message_question'] = 'Slett melding?';

$txt['topic_alert_none'] = 'Ingen meldinger...';
$txt['pm_alert_none'] = 'Ingen meldinger...';
$txt['no_messages'] = 'Ingen meldinger';

$txt['online_users'] = 'Brukere pålogget';
$txt['jump_to'] = 'Gå til';
$txt['go'] = 'Ok';
$txt['are_sure_remove_topic'] = 'Er du sikker på at du vil slette dette emnet?';
$txt['yes'] = 'Ja';
$txt['no'] = 'Nei';

$txt['search_end_results'] = 'Ingen flere treff';
$txt['search_on'] = 'på';

$txt['search'] = 'Søk';
$txt['all'] = 'Alle';
$txt['search_entireforum'] = 'Hele forumet';
$txt['search_thisboard'] = 'Dette forumet';
$txt['search_thistopic'] = 'Dette emnet';
$txt['search_members'] = 'Medlemmer';

$txt['back'] = 'Tilbake';
$txt['continue'] = 'Fortsett';
$txt['password_reminder'] = 'passord-påminnelse';
$txt['topic_started'] = 'Emne startet av';
$txt['title'] = 'Tittel';
$txt['post_by'] = 'Skrevet av';
$txt['memberlist_searchable'] = 'Søkbar liste over alle registrerte medlemmer.';
$txt['welcome_newest_member'] = 'Velkommen %1$s, vårt nyeste medlem.';
$txt['admin_center'] = 'Administratorpanel';
$txt['last_edit_by'] = '<span class="lastedit">sist endret</span>: %1$s by %2$s ';
$txt['last_edit_reason'] = '<span id="reason"  class="lastedit">Årsak</span>: %1$s ';
$txt['notify_deactivate'] = 'Ønsker du å deaktivere varsling for dette emnet?';
$txt['modified_time'] = 'Sist endret';
$txt['modified_by'] = 'Endret av';

$txt['recent_posts'] = 'Nyeste innlegg';

$txt['location'] = 'Lokasjon';
$txt['location_desc'] = 'Geografisk lokasjon.';
$txt['gender'] = 'Kjønn';
$txt['gender_0'] = 'Ikke oppgitt';
$txt['gender_1'] = 'Mann';
$txt['gender_2'] = 'Kvinne';
$txt['gender_desc'] = 'Ditt kjønn.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Dette er ditt ICQ nummer.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Ditt Skype brukernavn';
$txt['personal_text'] = 'Personlig tekst';
$txt['date_registered'] = 'Registreringsdato';

$txt['recent_view'] = 'Vis nyeste innleggene fra forumet.';
$txt['recent_updated'] = 'er det sist oppdaterte emnet';
$txt['is_recent_updated'] = '%1$s er det sist oppdaterte emnet';

$txt['male'] = 'Mann';
$txt['female'] = 'Kvinne';

$txt['error_invalid_characters_username'] = 'Ugyldig tegn benyttet i brukernavn.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Velkommen til <strong>%1$s</strong>. Vennligst <a href="%2$s" onclick="%3$s">logg inn</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Velkommen til <strong>%1$s</strong>. Vennligst <a href="%2$s" onclick="%3$s">logg inn</a> eller <a href="%4$s">registrer deg</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Gikk du glipp av aktiverings-eposten?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Har du ikke en konto? <a href="%1$s?action=signup">Registrèr deg</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Velkommen til <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Hei,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Velkommen,';
$txt['select_destination'] = 'Vennligst velg en destinasjon';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Skrevet av';

$txt['icon_smiley'] = 'Smiler';
$txt['icon_angry'] = 'Sint';
$txt['icon_cheesy'] = 'Osteaktig';
$txt['icon_laugh'] = 'Ler';
$txt['icon_sad'] = 'Trist';
$txt['icon_wink'] = 'Blunker';
$txt['icon_grin'] = 'Gliser';
$txt['icon_shocked'] = 'Sjokkert';
$txt['icon_cool'] = 'Kult';
$txt['icon_huh'] = 'Hææ';
$txt['icon_rolleyes'] = 'Øyerulling';
$txt['icon_tongue'] = 'Rekke tunge';
$txt['icon_embarrassed'] = 'Flaut';
$txt['icon_lips'] = 'Hemmelig';
$txt['icon_undecided'] = 'Tvilende';
$txt['icon_kiss'] = 'Kysser';
$txt['icon_cry'] = 'Gråter';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderatorer';

$txt['views'] = 'Visninger';
$txt['new'] = 'Nye';

$txt['view_all_members'] = 'Vis alle medlemmer';
$txt['view'] = 'Vis';

$txt['viewing_members'] = 'Viser medlemmer %1$s til %2$s';
$txt['of_total_members'] = 'av %1$s medlemmer';

$txt['forgot_your_password'] = 'Glemt passordet?';

$txt['date'] = 'Dato';
// Use numeric entities in the below string.
$txt['from'] = 'Fra';
$txt['check_new_messages'] = 'Se etter nye meldinger';
$txt['to'] = 'Til';

$txt['board_topics'] = 'Emner';
$txt['members_title'] = 'Medlemmer';
$txt['members_list'] = 'Medlemsliste';
$txt['new_posts'] = 'Nye innlegg';
$txt['old_posts'] = 'Ingen nye innlegg';
$txt['redirect_board'] = 'Omadresser emne';

$txt['sendtopic_send'] = 'Send';
$txt['report_sent'] = 'Din rapport er sendt.';
$txt['post_becomes_unapproved'] = 'Din melding er ikke godkjent fordi den er sent til et emne som ikke er godkjent. Når emnet er godkjent, vil meldingen din bli godkjent også.';

$txt['time_offset'] = 'Tidsavvik';
$txt['or'] = '<em>eller</em>';

$txt['no_matches'] = 'Beklager, ingen treff ble funnet';

$txt['notification'] = 'Varsling';

$txt['your_ban'] = 'Beklager %1$s, du er utestengt fra dette forumet!';
$txt['your_ban_expires'] = 'Denne utestengingen er satt til å utløpe %1$s.';
$txt['your_ban_expires_never'] = 'Denne utestengningen er satt til å vare for alltid';
$txt['ban_continue_browse'] = 'Du kan fortsette å surfe på forumet som en gjest.';

$txt['mark_as_read'] = 'Marker alle innlegg som lest';

$txt['locked_topic'] = 'Steng emne';
$txt['normal_topic'] = 'Vanlig emne';
$txt['participation_caption'] = 'Emne du har postet til';
$txt['moved_topic'] = 'Flyttet emne';

$txt['go_caps'] = 'OK';

$txt['print'] = 'Skriv ut';
$txt['profile'] = 'Profil';
$txt['topic_summary'] = 'Emneoversikt';
$txt['not_applicable'] = 'I/T';
$txt['name_in_use'] = 'Dette navnet er allerede tatt i bruk av et annet medlem.';

$txt['total_members'] = 'Medlemmer totalt';
$txt['total_posts'] = 'Innlegg totalt';
$txt['total_topics'] = 'Emner totalt';

$txt['time_logged_in'] = 'Forbli innlogget i';

$txt['preview'] = 'Forhåndsvisning';
$txt['always_logged_in'] = 'Alltid';

$txt['logged'] = 'Loggført';
$txt['show_ip'] = 'Vis IP adresse';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';
$txt['url'] = 'Adresse';
$txt['www'] = 'WWW';

$txt['hours'] = 'timer';
$txt['minutes'] = 'minutter';
$txt['seconds'] = 'sekunder';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Time';
$txt['days_word'] = 'dager';

$txt['search_for'] = 'Søk etter';
$txt['search_match'] = 'Treff';

$txt['forum_in_maintenance'] = 'Forumet ditt er i vedlikeholdsmodus. Bare administratorer kan logge inn nå.';
$txt['maintenance_page'] = 'Du kan slå av Vedlikeholdsmodus fra området <a href="%1$s">Serverinnstilinger</a>.';

$txt['read_one_time'] = 'Lest en gang';
$txt['read_many_times'] = 'Lest %1$d ganger';

$txt['forum_stats'] = 'Forum-statistikk';
$txt['latest_member'] = 'Nyeste medlem';
$txt['total_cats'] = 'Kategorier totalt';
$txt['latest_post'] = 'Nyeste innlegg';

$txt['total_boards'] = 'Forum totalt';

$txt['print_page'] = 'Skriv ut side';
$txt['print_page_text'] = 'Kun tekst';
$txt['print_page_images'] = 'Tekst med bilder';

$txt['valid_email'] = 'Dette må være en gyldig e-postadresse.';

$txt['geek'] = 'Jeg er en nerd!!';
$txt['info_center_title'] = '%1$s - Info-senter';

$txt['watch'] = 'Abonner på forumet';
$txt['unwatch'] = ' Stopp abonnementet på forumet';

$txt['check_all'] = 'Velg alle';

// Use numeric entities in the below string.
$txt['database_error'] = 'Feil i databasen';
$txt['try_again'] = 'Prøv på nytt. Om du kommer tilbake til denne feilmeldingen, rapporter feilen til en administrator.';
$txt['file'] = 'Fil';
$txt['line'] = 'Linje';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF har oppdaget og automatisk rettet en feil i din database. Om problemene fortsetter, eller du fremdeles får disse e-postmeldingene, ta kontakt med din nettleverandør.';
$txt['database_error_versions'] = '<strong>Merk:</strong> Det ser ut som din database trenger en oppgradering. Dine forumfiler er av versjon %1$s, mens databasen din inneholder versjon %2$s. For å forsøke å korrigere feilen nevnt ovenfor er det anbefalt at du kjører nyeste utgave av upgrade.php.';
$txt['template_parse_error'] = 'PHP-feil i designfilene!';
$txt['template_parse_error_message'] = 'Det kan se ut som noe har gått virkelig galt med designet du vil vise på forumet. Problemet er gjerne bare midlertidig, så du må gjerne komme tilbake og prøve på nytt. Dersom problemet fortsetter, ta kontakt med administrator.<br><br>Du kan også prøve å <a href="javascript:location.reload();">oppdatere denne siden</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Det oppstod et problem med å laste malen eller språkfilen <pre><strong>%1$s</strong></pre>. Sjekk skrivemåten og prøv igjen - husk at fnutter (<pre>\'</pre>) ofte må ha et metategn som (<pre>\\</pre>) foran. For å se en mer spesifikk feilmelding fra PHP prøv <a href="%2$s%1$s">å lese filen direkte</a>.<br><br>Du kan også prøve å <a href="javascript:location.reload();">laste denne siden på nytt</a> eller <a href="%3$s?theme=1">bruke standard-temaet</a>.';
$txt['template_parse_errmsg'] = 'Dessverre er det ikke mer informasjon tilgjengelig på dette tidspunktet med hensyn til nøyaktig hva som er galt.';

$txt['today'] = '<strong>I dag</strong> kl. ';
$txt['yesterday'] = '<strong>I går</strong> kl. ';
$txt['new_poll'] = 'Ny avstemning';
$txt['poll_question'] = 'Spørsmål';
$txt['poll_vote'] = 'Lagre avstemning';
$txt['poll_total_voters'] = 'Stemmer totalt';
$txt['poll_results'] = 'Vis resultater';
$txt['poll_lock'] = 'Steng avstemning';
$txt['poll_unlock'] = 'Åpne avstemning';
$txt['poll_edit'] = 'Rediger avstemning';
$txt['poll'] = 'Avstemning';
$txt['one_hour'] = '1 time';
$txt['one_day'] = '1 dag';
$txt['one_week'] = '1 uke';
$txt['two_weeks'] = '2 uker';
$txt['one_month'] = '1 måned';
$txt['two_months'] = '2 måneder';
$txt['forever'] = 'Forbli alltid innlogget';
$txt['moved'] = 'FLYTTET';
$txt['move_why'] = 'Angi en kort beskrivelse om <br> hvorfor dette emnet blir flyttet.';
$txt['board'] = 'Forum';
$txt['in'] = 'i';
$txt['sticky_topic'] = 'Prioritert emne';

$txt['delete'] = 'Slett';
$txt['no_change'] = 'Ingen endring';

$txt['your_pms'] = 'Dine personlige meldinger';

$txt['kilobyte'] = 'kB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Mer statisikk]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Kode';
$txt['code_select'] = '[Velg]';
$txt['code_expand'] = 'Utvid';
$txt['code_shrink'] = 'Gjør mindre';
$txt['quote_from'] = 'Sitat fra';
$txt['quote'] = 'Sitat';
$txt['quote_action'] = 'Sitat';
$txt['quote_selected_action'] = 'Sitèr valgt tekst';
$txt['fulledit'] = 'Full&nbsp;redigering';
$txt['edit'] = 'Rediger';
$txt['quick_edit'] = 'Hurtig redigering';
$txt['post_options'] = 'Mer...';

$txt['merge_to_topic_id'] = 'ID til målemne';
$txt['split'] = 'Splitt emne';
$txt['merge'] = 'Slå sammen emner';
$txt['target_id'] = 'Velg mål via emne-ID';
$txt['target_below'] = 'Velg mål fra listen under';
$txt['subject_new_topic'] = 'Tittel på nytt emne';
$txt['split_this_post'] = 'Splitt kun dette innlegget.';
$txt['split_after_and_this_post'] = 'Splitt emne fra og med dette innlegget.';
$txt['select_split_posts'] = 'Velg innlegg som skal splittes.';
$txt['new_topic'] = 'Nytt emne';
$txt['split_successful'] = 'Emnet ble splittet i to emner.';
$txt['origin_topic'] = 'Opprinnelig emne';
$txt['please_select_split'] = 'Velg hvilke innlegg du vil splitte.';
$txt['merge_successful'] = 'Emnene ble slått sammen.';
$txt['new_merged_topic'] = 'Nytt sammenslått emne';
$txt['topic_to_merge'] = 'Emnet som skal sammenslås';
$txt['target_board'] = 'Plasseres i forum';
$txt['target_topic'] = 'Plasseres i emne';
$txt['merge_desc'] = 'Denne funksjonen vil slå sammen innleggene i to emner til ett emne. Innleggene vil da bli sortert etter dato og derfor kan rekkefølgen på innleggene være forandret, slik at det eldste innlegget vil komme først i det nye emnet.';

$txt['set_sticky'] = 'Prioritér emnet';
$txt['set_nonsticky'] = 'Ikke prioritér emnet';
$txt['set_lock'] = 'Steng emnet';
$txt['set_unlock'] = 'Åpne emnet';

$txt['search_advanced'] = 'Avansert søk';

$txt['security_risk'] = 'ALVORLIG SIKKERHETSRISIKO:';
$txt['not_removed'] = 'Du har ikke slettet ';
$txt['not_removed_extra'] = '%1$s er en sikkerhetskopi av %2$s som ikke ble generert av SMF. Det kan nås direkte og brukes til å få uautorisert tilgang til forumet ditt. Du bør slette den umiddelbart.';
$txt['generic_warning'] = 'Advarsel';
$txt['agreement_missing'] = 'Du krever at nye brukere aksepterer en registreringsavtale, men filen (agreement.txt) eksisterer ikke.';
$txt['policy_agreement_missing'] = 'Du krever at nye brukere aksepterer en personvernerklæring, men personvernerklæringen er blank.';
$txt['auth_secret_missing'] = 'Kan ikke angi godkjenningshemmelighet i Settings.php. Dette svekker forumets sikkerhet og setter det i fare for angrep. Kontroller filtillatelsene for Settings.php for å sikre at SMF kan skrive til filen.';

$txt['cache_writable'] = 'Mappe formellomlagring er ikke skrivbar - dette vil påvirke ytelsen til forumet ditt.';

$txt['page_created_full'] = 'Siden ble generert på %1$.3f sekunder med %2$d spørringer.';

$txt['report_to_mod_func'] = 'Bruk denne funksjonen til å informere moderatorene og administratorene om et støtende eller feilplassert innlegg.';
$txt['report_profile_func'] = 'Bruk denne funksjonen til å informere administratorene om misbruk av profilinnhold, for eksempel spam eller upassende bilder.';

$txt['online'] = 'Innlogget';
$txt['member_is_online'] = ' %1$s brukere pålogget';
$txt['offline'] = 'Utlogget';
$txt['member_is_offline'] = '%1$s er ikke pålogget';
$txt['pm_online'] = 'Personlig melding (innlogget)';
$txt['pm_offline'] = 'Personlig melding (utlogget)';
$txt['status'] = 'Status';

$txt['go_up'] = 'Til toppen';
$txt['go_down'] = 'Til bunnen';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="License" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Fødselsdager:';
$txt['events'] = 'Arrangement:';
$txt['birthdays_upcoming'] = 'Kommende fødselsdager:';
$txt['events_upcoming'] = 'Kommende arrangement:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Helligdager:';
$txt['calendar_month'] = 'Måned';
$txt['calendar_year'] = 'År';
$txt['calendar_day'] = 'Dag';
$txt['calendar_event_title'] = 'Tittel på hendelsen:';
$txt['calendar_event_options'] = 'Hendelses alternativer';
$txt['calendar_post_in'] = 'Lag emne i:';
$txt['calendar_edit'] = 'Rediger hendelse';
$txt['calendar_export'] = 'Eksportere hendelse';
$txt['calendar_view_week'] = 'Vis uke';
$txt['event_delete_confirm'] = 'Slett denne hendelsen?';
$txt['event_delete'] = 'Slett hendelse';
$txt['calendar_post_event'] = 'Legg til hendelse';
$txt['calendar'] = 'Kalender';
$txt['calendar_link'] = 'Tilknytt kalender';
$txt['calendar_upcoming'] = 'Kommende hendelser';
$txt['calendar_today'] = 'Dagens kalender';
$txt['calendar_week'] = 'Uke';
$txt['calendar_week_title'] = 'Uke %1$d av %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Uken starter %2$s. %1$s %3$s ';
$txt['calendar_numb_days'] = 'Antall dager:';
$txt['calendar_how_edit'] = 'hvordan redigerer du disse arrangementene?';
$txt['calendar_link_event'] = 'Tilknytt hendelse';
$txt['calendar_confirm_delete'] = 'Er du sikker på at du vil slette denne hendelsen?';
$txt['calendar_linked_events'] = 'Tilknyttede arrangementer';
$txt['calendar_click_all'] = 'klikk for å se alle %1$s';
$txt['calendar_allday'] = 'Hele dagen';
$txt['calendar_timezone'] = 'Tidssone';
$txt['calendar_list'] = 'Liste';
$txt['calendar_empty'] = 'Det er ingen arrangement å vise.';

$txt['movetopic_change_subject'] = 'Endre emnets overskrift';
$txt['movetopic_new_subject'] = 'Nytt emne';
$txt['movetopic_change_all_subjects'] = 'Endre alle meldingers emne';
$txt['move_topic_unapproved_js'] = 'Advarsel! Dette emnet er ennå ikke godkjent.\n\nDet anbefales ikke at du oppretter en omdirigerings emne med mindre du har tenkt å godkjenne innlegget umiddelbart etter flyttingen.';
$txt['movetopic_auto_board'] = '[FORUM]';
$txt['movetopic_auto_topic'] = '[EMNE-LENKE]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Dette emnet har blitt flyttet til %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Viderekoble til det flyttede emnet';

$txt['post_redirection'] = 'Post et omdirigerings-emne';
$txt['redirect_topic_expires'] = 'Automatisk fjerne omdirigerings-emne';
$txt['mergetopic_redirect'] = 'Omdiriger til sammenslått emne';
$txt['merge_topic_unapproved_js'] = 'Advarsel! Dette emnet er ennå ikke godkjent. \n\nDet anbefales ikke at du oppretter et omdirigeringsemne med mindre du har tenkt å godkjenne innlegget umiddelbart etter sammenslåing.
';

$txt['theme_template_error'] = 'Kunne ikke laste utseende til \'%1$s\'.';
$txt['theme_language_error'] = 'Kunne ikke laste språkfilen til \'%1$s\'.';

$txt['sub_boards'] = 'Underforum';
$txt['restricted_board'] = 'Begrenset forum';

$txt['smtp_no_connect'] = 'Kunne ikke koble til SMTP verten';
$txt['smtp_port_ssl'] = 'SMTP-porten er stilt inn feil; den bør være 465 for SSL-servere. Vertsnavn kan behøve ssl:// prefiks.';
$txt['smtp_bad_response'] = 'Kunne ikke motta respons fra mailserver';
$txt['smtp_error'] = 'Det oppsto et problem ved sending av e-post. Feilmelding: ';
$txt['mail_send_unable'] = 'Kunne ikke sende e-post til adressen \'%1$s\'';

$txt['mlist_search'] = 'Søk etter medlemmer';
$txt['mlist_search_again'] = 'Søk på nytt';
$txt['mlist_search_filter'] = 'Søkealternativer';
$txt['mlist_search_email'] = 'Søk på e-postadresse';
$txt['mlist_search_messenger'] = 'Søk på Messenger kallenavn';
$txt['mlist_search_group'] = 'Søk på posisjon';
$txt['mlist_search_name'] = 'Søk på navn';
$txt['mlist_search_website'] = 'Søk på hjemmeside';
$txt['mlist_search_results'] = 'Søkeresultater';
$txt['mlist_search_by'] = 'Søk på %1$s';
$txt['mlist_menu_view'] = 'Vise medlemslista';

$txt['attach_downloaded'] = 'lastet ned %1$d ganger';
$txt['attach_viewed'] = 'vist %1$d ganger';

$txt['settings'] = 'Innstillinger';
$txt['never'] = 'Aldri';
$txt['more'] = 'flere';
$txt['etc'] = 'osv.';

$txt['hostname'] = 'Vertsnavn';
$txt['you_are_post_banned'] = 'Beklager %1$s, du er utestengt fra å skrive innlegg og personlige meldinger på dette forumet.';
$txt['ban_reason'] = 'Grunn';
$txt['select_item_check'] = 'Velg minst ett fra listen';

$txt['tables_optimized'] = 'Tabellene i databasen ble optimalisert';

$txt['add_poll'] = 'Legg til avstemning';
$txt['poll_options_limit'] = 'Du kan kun velge opp til %1$s varianter';
$txt['poll_remove'] = 'Fjern avstemning';
$txt['poll_remove_warn'] = 'Er du sikker på at du vil fjerne avstemningen fra dette emnet?';
$txt['poll_results_expire'] = 'Resultatene vil vises når avstemningen er avsluttet';
$txt['poll_expires_on'] = 'Avstemning avsluttes';
$txt['poll_expired_on'] = 'Avstemning er avsluttet';
$txt['poll_change_vote'] = 'Fjern stemme';
$txt['poll_return_vote'] = 'Innstillinger for stemmegivning';
$txt['poll_cannot_see'] = 'Du kan ikke se resultatene av denne avstemningen for øyeblikket.';

$txt['quick_mod_approve'] = 'Godkjenn valgte';
$txt['quick_mod_remove'] = 'Fjern valgte';
$txt['quick_mod_lock'] = 'Steng/åpne valgte';
$txt['quick_mod_sticky'] = 'Prioritert/Ikke prioritert valgt';
$txt['quick_mod_move'] = 'Flytt valgt(e) til';
$txt['quick_mod_merge'] = 'Slå sammen valgt(e)';
$txt['quick_mod_markread'] = 'Marker valgt(e) som lest';
$txt['quick_mod_markunread'] = 'Merk utvalget som ulest';
$txt['quick_mod_selected'] = 'Med utvalget gjør følgende';
$txt['quick_mod_go'] = 'Ok';
$txt['quickmod_confirm'] = 'Er du sikker på at du vil gjøre dette?';

$txt['spell_check'] = 'Stavekontroll';

$txt['quick_reply'] = 'Hurtigsvar';
$txt['quick_reply_warning'] = 'Advarsel: Dette emnet er stengt! Kun administratorer og moderatorer kan legge inn svar.';
$txt['quick_reply_verification'] = 'Etter innsending av innlegget ditt vil du bli henvist til den vanlige siden for å verifisere ditt innlegg %1$s.';
$txt['quick_reply_verification_guests'] = '(kreves for alle gjester)';
$txt['quick_reply_verification_posts'] = '(kreves for alle brukere med mindre enn %1$d innlegg)';
$txt['wait_for_approval'] = 'Merk: dette innlegget vil ikke vises før det er blitt godkjent av en moderator.';

$txt['notification_enable_board'] = 'Er du sikker på at du vil aktivere varsling om nye emner i dette forumet?';
$txt['notification_disable_board'] = 'Er du sikker på at du vil deaktivere varsling om nye emner i dette forumet?';
$txt['notification_enable_topic'] = 'Er du sikker på at du vil aktivere varsling om nye svar i dette emnet?';
$txt['notification_disable_topic'] = 'Er du sikker på at du vil deaktivere varsling om nye svar i dette emnet?';

// Mentions
$txt['mentions'] = 'Nevner';

// Likes
$txt['likes'] = 'Like';
$txt['like'] = 'Like';
$txt['unlike'] = 'Ikke like lengre';
$txt['like_success'] = 'Ditt innhold ble "likt"';
$txt['like_delete'] = 'Ditt innhold be slettet';
$txt['like_insert'] = 'Ditt innhold ble lagt til';
$txt['like_error'] = 'Det oppstod en feil med forespørselen.';
$txt['like_disable'] = '"Like" er deaktivert.';
$txt['not_valid_like_type'] = 'Like-typen er ikke gyldig.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s person(er)</a> liker dette. ';
$txt['likes_n'] = '<a href="%1$s">%2$s personer</a> liker dette. ';
$txt['you_likes_0'] = 'Du liker dette';
$txt['you_likes_1'] = 'Du og <a href="%1$s">1 annen person </a> like this. ';
$txt['you_likes_n'] = 'Du og <a href="%1$s">%2$s andre</a> liker dettes. ';

$txt['report_to_mod'] = 'Rapporter til moderator';
$txt['report_profile'] = 'Rapportèr profilen til %1$s';

$txt['unread_topics_visit'] = 'Nye uleste emner';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Ingen uleste emner siden ditt forrige besøk. <a href="%1$s?action=unread;all">Klikk her for å søke etter alle uleste emner</a>.';
$txt['updated_topics_visit_none'] = 'Ingen oppdaterte emner siden ditt forrige besøk.';
$txt['unread_topics_all'] = 'Alle uleste emner';
$txt['unread_replies'] = 'Oppdaterte emner';

$txt['who_title'] = 'Hvem er pålogget';
$txt['who_and'] = ' og ';
$txt['who_viewing_topic'] = ' leser dette emnet.';
$txt['who_viewing_board'] = ' er inne på dette forumet.';
$txt['who_member'] = 'Medlem';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Bygget på PHP';
$txt['powered_by_mysql'] = 'Bygget på MySQL';
$txt['valid_css'] = 'CSS godkjent!';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gjest';
$txt['guests'] = 'Gjester';
$txt['user'] = 'Bruker';
$txt['users'] = 'Brukere';
$txt['hidden'] = 'Skjult';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Skjult';
$txt['buddy'] = 'venn';
$txt['buddies'] = 'venner';
$txt['most_online_ever'] = 'Flest pålogget noen sinne';
$txt['most_online_today'] = 'Flest pålogget idag';

$txt['merge_select_target_board'] = 'Velg hvilket forum det sammenslåtte emnet skal plasseres i';
$txt['merge_select_poll'] = 'Velg hvilken avstemning det sammenslåtte emnet skal ha';
$txt['merge_topic_list'] = 'Velg emner som skal slås sammen';
$txt['merge_select_subject'] = 'Velg tittel på sammenslått emne';
$txt['merge_custom_subject'] = 'Annen tittel';
$txt['merge_include_notifications'] = 'Inkluder varslinger?';
$txt['merge_check'] = 'Slå sammen?';
$txt['merge_no_poll'] = 'Ingen avstemning';
$txt['merge_why'] = 'Legg inn en kort beskrivelse om hvorfor disse emnene ble slått sammen.';
$txt['merged_subject'] = '[SAMMENSLÅTT] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Dette emnet er slått sammen med %2$s.';

$txt['response_prefix'] = 'Sv: ';
$txt['current_icon'] = 'Gjeldende symbol';
$txt['message_icon'] = 'Ikon for innlegg';

$txt['smileys_current'] = 'Gjeldende smilefjes-sett';
$txt['smileys_none'] = 'Ingen smilefjes';
$txt['smileys_forum_board_default'] = 'Forvalg for forum';

$txt['search_results'] = 'Søkeresultater';
$txt['search_no_results'] = 'Beklager, ingen treff ble funnet';

$txt['total_time_logged_days'] = 'dager,';
$txt['total_time_logged_hours'] = 'timer og';
$txt['total_time_logged_minutes'] = ' minutter';
$txt['total_time_logged_d'] = 'd';
$txt['total_time_logged_h'] = 't';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'Medlemsgodkjennelser';

$txt['activate_code'] = 'Din aktiveringskode er';

$txt['find_members'] = 'Søk etter medlemmer';
$txt['find_username'] = 'Navn, brukernavn, eller e-postadresse';
$txt['find_buddies'] = 'Vis kun venner?';
$txt['find_wildcards'] = 'Tillatte jokertegn: *, ?';
$txt['find_no_results'] = 'Ingen treff funnet';
$txt['find_results'] = 'Resultater';
$txt['find_close'] = 'Lukk';

$txt['unread_since_visit'] = 'Vis uleste innlegg siden forrige besøk.';
$txt['show_unread_replies'] = 'Vis nye svar på dine innlegg.';

$txt['change_color'] = 'Endre farge';

$txt['quickmod_delete_selected'] = 'Fjern valgte';
$txt['quickmod_split_selected'] = 'Splitt valgte';

$txt['show_personal_messages_heading'] = 'Nye meldinger';
$txt['show_personal_messages'] = 'Du har <strong>%1$s</strong> uleste personlige meldinger i innboksen din.<br><br><a href="%2$s">Gå til innboksen din</a> ';

$txt['help_popup'] = 'Litt fortapt? La meg forklare:';

$txt['previous_next_back'] = '&laquo; forrige';
$txt['previous_next_forward'] = 'neste &raquo;';

$txt['mark_unread'] = 'Marker som ulest';

$txt['ssi_not_direct'] = 'Vennligst ikke lag lenker direkte mot SSI.php; du kan istedet benytte stien (%1$s) eller legge til ?ssi_function=etellerannet.';
$txt['ssi_session_broken'] = 'SSI.php klarte ikke å laste inn en sessjon! Dette kan skape problem med utlogging og andre funksjoner - vennligst forsikre deg om at SSI.php inkluderes før *alt* annet i dine scripts!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Forhåndsvis innlegg';
$txt['preview_fetch'] = 'Henter forhåndsvisning...';
$txt['preview_new'] = 'Ny melding';
$txt['pm_error_while_submitting'] = 'Følgende feil oppsto under sending av denne personlige meldingen:';
$txt['error_while_submitting'] = 'Følgende feil oppsto ved lagring av meldingen:';
$txt['error_old_topic'] = 'Advarsel: Det er ikke blitt lagt til noen emner her på minst %1$d dager.<br>Med mindre du er helt sikker på at du vil svare, kan du vurdere å starte et nytt emne.';

$txt['split_selected_posts'] = 'Valgte innlegg';
$txt['split_selected_posts_desc'] = 'Innleggene nedenfor vil danne et nytt emne etter splitting.';
$txt['split_reset_selection'] = 'tilbakestill valg';

$txt['modify_cancel'] = 'Avbryt';
$txt['modify_cancel_all'] = 'Kansellèr alle';
$txt['mark_read_short'] = 'Merk som lest';

$txt['alerts'] = 'Varsler';

$txt['pm_short'] = 'Mine meldinger';
$txt['pm_menu_read'] = 'Les meldinger';
$txt['pm_menu_send'] = 'Send en melding';

$txt['unapproved_posts'] = 'Ikke godkjente innlegg (Emner: %1$d, Innlegg: %2$d)';

$txt['ajax_in_progress'] = 'Laster...';

$txt['mod_reports_waiting'] = 'Rapportert innlegg';

$txt['view_unread_category'] = 'Uleste innlegg';
$txt['new_posts_in_category'] = 'Klikk for å se de nye innleggene i %1$s';
$txt['verification'] = 'Bekreftelse';
$txt['visual_verification_hidden'] = 'La denne boksen være tom';
$txt['visual_verification_description'] = 'Skriv tegn som vises i bildet';
$txt['visual_verification_sound'] = 'Lytt til tegn';
$txt['visual_verification_request_new'] = 'Be om et nytt bilde';

// Sub menu labels
$txt['summary'] = 'Oppsummering';
$txt['account'] = 'Innstillinger for medlemskonto';
$txt['theme'] = 'Oppsett og utseende ';
$txt['forumprofile'] = 'Forum profil';
$txt['activate_changed_email_title'] = 'E-postadressen endret';
$txt['activate_changed_email_desc'] = 'Du har endret din e-postadressen. For å validere denne adressen vil du motta en e-post. Klikk på lenken i e-posten for å aktivere kontoen din.';
$txt['modSettings_title'] = 'Funksjoner og innstillinger';
$txt['package'] = 'Pakkebehandling';
$txt['errorlog'] = 'Feillogg';
$txt['edit_permissions'] = 'Rettigheter';
$txt['mc_unapproved_attachments'] = 'Ikke godkjente vedlegg';
$txt['mc_unapproved_poststopics'] = 'Ikke godkjente innlegg og emner';
$txt['mc_reported_posts'] = 'Rapporterte innlegg';
$txt['mc_reported_members'] = 'Rapporterte medlemmer';
$txt['modlog_view'] = 'Moderasjonslogg';
$txt['calendar_menu'] = 'Vis kalender';

// @todo Send email strings - should move?
$txt['send_email'] = 'Send e-post';

$txt['ignoring_user'] = 'Du ignorerer denne brukeren.';
$txt['show_ignore_user_post'] = 'Vis meg innlegget.';

$txt['spider'] = 'Robot';
$txt['spiders'] = 'Indekseringsroboter';

$txt['downloads'] = 'Nedlastinger';
$txt['filesize'] = 'Filstørrelse';

// Restore topic
$txt['restore_topic'] = 'Gjenopprett emne';
$txt['restore_message'] = 'Gjenopprett';
$txt['quick_mod_restore'] = 'Gjenopprett utvalgte';

// Editor prompt.
$txt['prompt_text_email'] = 'Vennligst oppgi e-postadressen.';
$txt['prompt_text_ftp'] = 'Vennligst skriv inn ftp adressen.';
$txt['prompt_text_url'] = 'Vennligst skriv inn nettadressen du ønsker å lenke til.';
$txt['prompt_text_img'] = 'Skriv inn bilde plassering';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Slett element';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Maler: ';
$txt['debug_subtemplates'] = 'Undermaler: ';
$txt['debug_language_files'] = 'Språkfiler:';
$txt['debug_stylesheets'] = 'Stilark: ';
$txt['debug_files_included'] = 'Filer inkludert: ';
$txt['debug_memory_use'] = 'Minne brukt:';
$txt['debug_kb'] = 'kB.';
$txt['debug_show'] = 'vis';
$txt['debug_cache_hits'] = 'Hurtigbuffer treff: ';
$txt['debug_cache_misses'] = 'hurtigbuffer bom: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s byte';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss for %2$s byte';
$txt['debug_queries_used'] = 'Spørringer brukt: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Spørringer brukt: %1$d, %2$d advarsler.';
$txt['debug_query_in_line'] = 'i <em>%1$s</em> linje <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'som tok %1$s sekunder.';
$txt['debug_query_which_took_at'] = 'som tok %1$s sekunder ved %2$s inn i forespørselen.';
$txt['debug_show_queries'] = '[Vis spørringer]';
$txt['debug_hide_queries'] = '[Skjul spørringer]';
$txt['debug_tokens'] = 'Tokens:';
$txt['debug_browser'] = 'Nettleser Id:';
$txt['debug_hooks'] = 'Hooks heter:';
$txt['debug_instances'] = 'Forekomster opprettet:';
$txt['are_sure_mark_read'] = 'Er du sikker på at du vil merke meldingene som lest?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Vedlegg er deaktivert';
$txt['attachments_no_data_loaded'] = 'Ikke en gyldig vedlegg-ID.';
$txt['attachments_not_allowed_to_see'] = 'Du kan ikke vise dette vedlegget.';
$txt['attachments_no_msg_associated'] = 'Ingen melding er assosiert med dette vedlegget.';
$txt['attachments_unapproved'] = 'Vedlegg avventer godkjenning.';

// Accessibility
$txt['hide_category'] = 'Gjem kategori';
$txt['show_category'] = 'Vis kategori';
$txt['hide_infocenter'] = 'Gjem infosenter';
$txt['show_infocenter'] = 'Vis infosenter';

// Notification post control
$txt['notify_topic_0'] = 'Følger ikke';
$txt['notify_topic_1'] = 'Ingen varsler eller e-post';
$txt['notify_topic_2'] = 'Motta varsler';
$txt['notify_topic_3'] = 'Motta e-post og varsler';
$txt['notify_topic_0_desc'] = 'Du vil ikke motta noen e-postmeldinger eller varsler for dette emnet, og det vil heller ikke vises i dine uleste svar og emneliste. Du vil fortsatt motta @nevninger for dette emnet.';
$txt['notify_topic_1_desc'] = 'Du vil ikke motta noen e-post eller varsler, men bare @nevninger fra andre medlemmer.';
$txt['notify_topic_2_desc'] = 'Du vil motta varsler for dette emnet.';
$txt['notify_topic_3_desc'] = 'Du vil motta både varsler og e-post for dette emnet.';
$txt['notify_board_1'] = 'Ingen varsler eller e-post';
$txt['notify_board_2'] = 'Motta varsler';
$txt['notify_board_3'] = 'Motta varsler og e-post';
$txt['notify_board_1_desc'] = 'Du vil ikke motta e-post eller varsler for nye emner.';
$txt['notify_board_2_desc'] = 'Du vil motta varsler for dette forumet.';
$txt['notify_board_3_desc'] = 'Du vil motta både varsler og e-post for dette forumet.';

$txt['notify_board_prompt'] = 'Ønsker du å få varsling på e-post når noen lager et nytt emne i dette forumet?';
$txt['notify_board_subscribed'] = '%1$s er meldt på å motta notifikasjoner for dette forumet.';
$txt['notify_board_unsubscribed'] = '%1$s er meldt av fra å motta notifikasjoner for dette forumet.';

$txt['notify_topic_prompt'] = 'Ønsker du å få en varsling på e-post om noen svarer på dette emnet?';
$txt['notify_topic_subscribed'] = '%1$s er meldt på å motta varsler om nye svar for dette emnet.';
$txt['notify_topic_unsubscribed'] = '%1$s er meldt av fra å motta varsler om nye svar for dette emnet.';

$txt['notify_announcements_prompt'] = 'Motta kunngjøringer, nyhetsbrev og vikige varslinger på e-post?';
$txt['notify_announcements_subscribed'] = '%1$s har blitt meldt på nyhetsbrev, kunngjøringer og viktige varsler fra forumet.';
$txt['notify_announcements_unsubscribed'] = '%1$s har blitt avmeldt forum nyhetsbrev, kunngjøringer og viktige varsler fra forumet.';

$txt['unsubscribe_announcements_plain'] = 'For å melde deg av forum nyhetsbrev, kunngjøringer og viktige varsler, klikk på denne lenken: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Meld deg av</a> forum nyhetsbrev, kunngjøringer og viktige varsler.</span>';
$txt['unsubscribe_announcements_manual'] = 'For å melde deg av forum nyhetsbrev, kunngjøringer og viktige varsler, klikk på denne lenken, kontakt oss på %1$s.';

// Mobile Actions
$txt['mobile_action'] = 'Bruker-handlinger';
$txt['mobile_moderation'] = 'Moderering';
$txt['mobile_user_menu'] = 'Hovedmeny';
$txt['mobile_generic_menu'] = '%1$smeny';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} og {-1}';
$txt['sentence_list_format'][3] = '{series}, og {-1}';
$txt['sentence_list_format'][4] = '{series}, og {-1}
';
$txt['sentence_list_format'][5] = '{series}, og {-1}
';
$txt['sentence_list_format']['n'] = '{series}, og {-1}
';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ',';
$txt['sentence_list_separator_alt'] = ';';

?>