<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = 'Fenster schließen';

$helptxt['manage_boards'] = '
	<strong>Boards verwalten</strong><br>
	Hier können Sie „Boards“ und die darüberliegenden „Kategorien“ verwalten. Wenn
	Sie beispielsweise eine Seite betreiben, die Informationen über „Sport“, „Autos“
	und „Musik“ bereitstellt, wären dies die Kategorien auf der obersten Ebene,
	die Sie erzeugen würden. Innerhalb dieser Kategorien könnten Sie „Boards“ für die
	verschiedenen Themen darin einfügen.<br>
	Diese einfache Hierarchie könnte aussehen wie folgt:<br>
	<ul class="normallist">
		<li>
			<strong>Sport</strong>
			&nbsp;- Eine „Kategorie“
			<ul class="normallist">
				<li>
					<strong>Baseball</strong>
					&nbsp;- Ein Board innerhalb der Kategorie „Sport“
					<ul class="normallist">
						<li>
							<strong>Statistiken</strong>
							&nbsp;- Ein Unter-Board des Boards „Baseball“
						</li>
					</ul>
				</li>
				<li><strong>Fußball</strong>
				&nbsp;- Ein Board innerhalb der Kategorie „Sport“</li>
			</ul>
		</li>
	</ul>
	Kategorien erlauben Ihnen, das Forum in verschiedene Themenbereiche aufzuteilen („Autos,
	Sport“), die darunterliegenden Boards erlauben eine weitere Unterteilung und enthalten die
	tatsächlichen Themen. Wenn sich ein Benutzer für Porsche interessiert, würde er seinen
	Beitrag unter „Autos“ → „Porsche“ schreiben.
	Administrative Funktionen in diesem Menü sind das Hinzufügen von Boards in Kategorien, 
	die Änderung der Reihenfolge (z. B. „Porsche“ unter „Volkswagen“ einsortieren), sowie das
	Löschen von Boards bzw. Kategorien.';

$helptxt['edit_news'] = '
	<ul class="normallist">
		<li>
			<strong>Neuigkeiten</strong><br>
			Diese Sektion erlaubt Ihnen, den News-Text auf der Forumshauptseite festzulegen. Fügen Sie ein beliebiges Element hinzu (z. B. „Verpassen Sie nicht die Konferenz am Dienstag“). Jede Neuigkeit wird zufällig angezeigt und sollte in eine separate Box.
		</li>
		<li>
			<strong>Newsletter</strong><br>
			Diese Sektion erlaubt es Ihnen, Newsletter über E-Mail oder persönliche Mitteilungen an Benutzer zu versenden. Zunächst wählen Sie die Gruppen, an die Sie den Newsletter senden möchten und jene, an die Sie ihn nicht senden möchten. Wenn Sie möchten, können Sie zusätzliche E-Mail-Adressen angeben, die den Newsletter erhalten sollen. Abschließend geben Sie die Nachricht ein, die Sie versenden möchten, und wählen, ob der Newsletter als persönliche Mitteilung oder als E-Mail verschickt werden soll.
		</li>
		<li>
			<strong>Einstellungen</strong><br>
			Diese Sektion enthält einige Einstellungen, die mit Neuigkeiten und Newslettern zu tun haben. Dies schließt auch mit ein, welche Gruppen die Forums-News bearbeiten und Newsletter versenden können. Sie können außerdem einstellen, ob Newsfeeds für das Forum aktiviert sein sollen und wie viele Zeichen einer Neuigkeit im Newsfeed angezeigt werden.
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Mitglieder anzeigen</strong><br>
			Alle Mitglieder des Forums anzeigen. Ihnen wird eine Liste von Mitgliedernamen gezeigt, die auf die
			Benutzerprofile verlinken. Sie können jeden der Namen anklicken, um die Details (Webseite, Alter, etc.)
			anzusehen, und als Administrator können Sie diese bearbeiten. Sie haben vollständige Kontrolle über
			Mitglieder, einschließlich der Möglichkeit, diese aus dem Forum zu entfernen.<br><br>
		</li>
		<li>
			<strong>Erwartete Genehmigungen</strong><br>
			Diese Seite wird nur angezeigt, falls Sie „Admin-Genehmigung“ aller neuen Registrierungen aktiviert
			haben. Jede Person, die sich registriert, um Ihrem Forum beizutreten, wird erst zu einem vollen
			Mitglied, sobald sie durch einen Admin genehmigt wurde. Die Seite listet alle Mitglieder auf, die noch
			Genehmigung erwarten, zusammen mit ihrer E-Mail- und IP-Adresse. Sie können jedes Mitglied auf der
			Liste entweder akzeptieren oder ablehnen (löschen), indem Sie das Mitglied durch ein Häkchen
			markieren und die Aktion aus dem Ausklappmenü am Ende der Seite auswählen. Falls Sie ein Mitglied
			ablehnen, können Sie wählen, ob das Mitglied über Ihre Entscheidung informiert wird oder nicht.<br><br>
		</li>
		<li>
			<strong>Erwartete Aktivierungen</strong><br>
			Diese Seite wird nur angezeigt, falls Sie „E-Mail-Aktivierung“ aller neuen Registrierungen im Forum
			aktiviert haben. Die Seite listet alle Mitglieder auf, die ihre Benutzerkonten noch nicht aktiviert
			haben. Sie können dort wählen, diese Mitglieder zu akzeptieren, abzulehnen oder an ihre ausstehende
			Aktivierung zu erinnern. Wie oben können Sie jedes Mitglied wahlweise über die von Ihnen
			durchgeführte Aktion informieren oder nicht.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Mitglieder bannen</strong><br>
	SMF bietet die Möglichkeit, bestimmte Mitglieder zu „bannen“, weil sie aufgrund von Spam u.a. gegen die Nutzungsbedingungen
	verstoßen haben. Als Administrator können Sie in jedem Beitrag die IP-Adresse des Benutzers sehen und diese einfach in die
	Bann-Liste eintragen, so dass der betreffende Benutzer nicht mehr von dieser IP-Adresse aus schreiben kann.<br>Sie haben auch die
	Möglichkeit, die Benutzer durch die Eingabe ihrer E-Mail-Adresse zu bannen.';

$helptxt['featuresettings'] = '<strong>Features und Optionen</strong><br>
	Hier können Sie verschiedene Einstellungen zu den einzelnen Features machen.';

$helptxt['modsettings'] = '<strong>Modifikations-Einstellungen</strong><br>
	Diese Seite enthält alle Einstellungen, die von Modifikationen (Erweiterungspaketen) zu Ihrem Forum hinzugefügt wurden.';

$helptxt['time_format'] = '<strong>Zeitformat</strong><br>
	Hier können Sie einstellen, wie das Datum und die Zeit für Sie selbst angezeigt werden. Es gibt viele Einstellungen, ist aber nicht schwierig. Die Konventione folgen der
	PHP-Funktion strftime und sind nachfolgend beschrieben (mehr Details unter <a href="https://php.net/manual/function.strftime.php" target="_blank" rel="noopener">php.net</a>).<br>
	<br>
	Die folgenden Zeichen werden im Formatstring erkannt:<br>
	<span class="smalltext">
	&nbsp;&nbsp;%a – abgekürzter Name des Wochentags<br>
	&nbsp;&nbsp;%A – voller Name des Wochentags<br>
	&nbsp;&nbsp;%b – abgekürzter Monatsname<br>
	&nbsp;&nbsp;%B – voller Monatsname<br>
	&nbsp;&nbsp;%d – Tag des Monats (01 bis 31)<br>
	&nbsp;&nbsp;%D<strong>*</strong> – das gleiche wie %m/%d/%y<br>
	&nbsp;&nbsp;%e<strong>*</strong> – Tag des Monats (1 bis 31)<br>
	&nbsp;&nbsp;%H – Stunde einer 24-Stunden-Uhr (von 00 bis 23)<br>
	&nbsp;&nbsp;%I – Stunde einer 12-Stunden-Uhr (von 01 bis 12)<br>
	&nbsp;&nbsp;%m – aktueller Monat als Zahl (01 bis 12)<br>
	&nbsp;&nbsp;%M – Minute als Zahl<br>
	&nbsp;&nbsp;%p – entweder „am“ oder „pm“ entsprechend der aktuellen Zeit<br>
	&nbsp;&nbsp;%R<strong>*</strong> – Zeit in 24-Stunden-Anzeige<br>
	&nbsp;&nbsp;%S – Sekunde als Dezimalzahl<br>
	&nbsp;&nbsp;%T<strong>*</strong> – aktuelle Zeit, gleichwertig zu %H:%M:%S<br>
	&nbsp;&nbsp;%y – 2-stelliges Jahr (00 bis 99)<br>
	&nbsp;&nbsp;%Y – 4-stelliges Jahr<br>
	&nbsp;&nbsp;%Z – Zeitzone, Name oder Abkürzung der Zeitzone<br>
	&nbsp;&nbsp;%% – ein tatsächliches „%“-Zeichen<br>
	<br>
	<em>* Funktioniert nicht auf Windows-basierenden Servern</em></span>';

$helptxt['live_news'] = '<strong>Live-Ankündigungen</strong><br>
	Dieser Kasten zeigt aktuelle Meldungen von <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.
	Sie sollten hier regelmäßig nach Neuigkeiten, neuen Versionen und wichtigen Informationen vom Simple-Machines-Team schauen.';

$helptxt['registrations'] = '<strong>Registrierungsverwaltung</strong><br>
	Hier finden Sie alle Funktionen, die Sie zum Verwalten von neuen Registrierungen benötigen. Es gibt bis zu vier Bereiche,
	die je nach Einstellung des Forums sichtbar sind:<br><br>
	<ul class="normallist">
		<li>
			<strong>Neues Mitglied registrieren</strong><br>
			Hier können Sie neue Mitglieder in deren Auftrag registrieren. Diese Funktion ist nützlich bei deaktivierter
			Registrierung oder wenn der Administrator ein Testkonto erstellen möchte. Wenn das Forum so konfiguriert ist, dass Benutzerkonten aktiviert werden müssen, erhalten die Mitglieder eine E-Mail mit dem Aktivierungslink,
			den sie anklicken müssen, bevor sie sich einloggen können. Alternativ können Sie dem neuen Mitglied
			auch eine E-Mail mit dem Passwort an die angegebene Adresse schicken.<br><br>
		</li>
		<li>
			<strong>Registrierungsvereinbarung bearbeiten</strong><br>
			Diese Funktion erlaubt das Bearbeiten der Registrierungsvereinbarung, die bei Neuregistrierungen in Ihrem Forum angezeigt wird.
			Sie können Bedingungen zum Standardtext, der in SMF enthalten ist, hinzufügen oder aus diesem löschen.<br><br>
		</li>
		<li>
			<strong>Reservierte Namen festlegen</strong><br>
			Diese Funktion erlaubt das Hinzufügen von Wörtern oder Namen, die nicht von anderen Benutzern verwendet werden
			dürfen.<br><br>
		</li>
		<li>
			<strong>Einstellungen</strong><br>
			Dieser Bereich wird nur sichtbar sein, wenn Sie die Berechtigung zum Administrieren des Forums haben. Hier können
			Sie unter anderem Einstellungen zur Registrierungsmethode vornehmen.
		</li>
	</ul>';

$helptxt['modlog'] = '<strong>Moderationsprotokoll</strong><br>
	Diese Seite erlaubt es Mitgliedern des Moderationsteams, alle Moderations-Aktionen der Forums-Moderatoren zu verfolgen.
	Beachten Sie, dass das Löschen des Protokolls ebenfalls protokolliert wird, um Missbrauch zu verhindern.';
$helptxt['adminlog'] = '<strong>Administrationsprotokoll</strong><br>
	Diese Seite erlaubt es Mitgliedern des Administrationsteams, einige der durchgeführten administrativen Aktionen nachzuverfolgen. Beachten Sie, dass das Löschen des Protokolls ebenfalls protokolliert wird, um Missbrauch zu verhindern.';
$helptxt['userlog'] = '<strong>Profilbearbeitungs-Protokoll</strong><br>
	Diese Seite erlaubt Mitgliedern des Administrationsteams, Änderungen nachzuvollziehen, die Benutzer an ihren Profilen vornehmen. Sie kann über das Benutzerprofil erreicht werden.';
$helptxt['warning_enable'] = '<strong>Benutzer-Verwarnungssystem</strong><br>
	Diese Funktion erlaubt den Administratoren und Moderatoren, Benutzer zu verwarnen und auf Basis des Verwarnungslevels 
	bestimmte Sanktionen zu erlassen. Nach der Aktivierung kann mit Hilfe einer Berechtigung bestimmt werden, welche
	Mitgliedergruppen Verwarnungen vergeben dürfen. Das Verwarnungslevel kann im entsprechenden Mitgliederprofil geändert werden.';
$helptxt['warning_watch'] = 'Diese Einstellung definiert die prozentuelle Verwarnungsstufe, die ein Mitglied erreichen muss, um automatisch „beobachtet“ zu werden. Wird ein Mitglied „beobachtet“, wird es in der Liste der „beobachteten Mitglieder“ im Administrationszentrum erscheinen.';
$helptxt['warning_moderate'] = 'Jedes Mitglied, das den hier eingestellten Wert überschreitet, muss alle neuen Beiträge durch das Moderationsteam genehmigen lassen, bevor sie für die anderen Forumsmitglieder sichtbar werden. Dies überschreibt etwaige lokale Board-Berechtigungen bezüglich der Moderation.';
$helptxt['warning_mute'] = 'Falls diese Verwarnungsstufe überschritten wird, verliert das betroffene Mitglied die Berechtigung, weitere Beiträge zu schreiben.';
$helptxt['user_limit'] = 'Diese Einstellung beschränkt die Anzahl der Punkte, die ein Moderator einem Mitglied innerhalb von 24 Stunden hinzufügen/entfernen darf. Wenn dies nicht eingeschränkt werden soll, geben Sie 0 ein. Beachten Sie, dass Administratoren von diesem Wert nicht betroffen sind.';

$helptxt['error_log'] = '<strong>Fehlerprotokoll</strong><br>
	Das Fehlerprotokoll listet, nach Datum sortiert, alle Fehler auf, die von Benutzern im Forum produziert worden sind. Um den neuesten Fehler
	zuerst anzuzeigen, klicken Sie auf den kleinen schwarzen Pfeil neben dem Datum. Weiterhin können Sie die Fehlermeldungen
	nach der Art des Fehlers filtern, indem Sie auf die Grafik neben der entsprechenden Angabe klicken (z. B. Filtern nach Benutzernamen).
	Wenn ein Filter aktiv ist, werden nur die übereinstimmenden Fehler angezeigt.';
$helptxt['theme_settings'] = '<strong>Theme-Einstellungen</strong><br>
	Hier können Sie die Einstellungen jedes einzelnen Themes verändern. Die Einstellungen beinhalten Optionen wie das Theme-Verzeichnis
	und die URL-Informationen, sowie viele Einstellungen zum Layout. Die meisten Themes enthalten eine Vielzahl von benutzerkonfigurierbaren Optionen,
	die es erlauben, das Theme den Bedürfnissen Ihres Forums anzupassen.';
$helptxt['smileys'] = '<strong>Smileyzentrum</strong><br>
	Hier können Sie Smileys und Smileysammlungen hinzufügen oder löschen. Wenn ein Smiley in einer Sammlung vorhanden ist, sollte er in allen Sammlungen
	enthalten sein – sonst könnte es bei Verwendung verschiedener Sammlungen zu Verwirrungen kommen.<br><br>
	Sie können hier ebenfalls die Beitragssymbole verändern, wenn Sie diese in den Einstellungen aktiviert haben.';
$helptxt['calendar'] = '<strong>Kalender verwalten</strong><br>
	Hier können Sie die Einstellungen des Kalenders verändern sowie Feiertage hinzufügen bzw. löschen.';
$helptxt['cal_export'] = 'Exportiert eine Textdatei im iCal-Format, die Sie in andere Kalender-Anwendungen importieren können';
$helptxt['cal_highlight_events'] = 'Diese Einstellung erlaubt es Ihnen, Ereignisse in den Mini-Kalendern, dem Hauptkalender oder an beiden Orten hervorzuheben oder das Hervorheben von Ereignissen zu deaktivieren.';
$helptxt['cal_highlight_holidays'] = 'Diese Einstellung erlaubt es Ihnen, Feiertage in den Mini-Kalendern, dem Hauptkalender oder an beiden Orten hervorzuheben oder das Hervorheben von Ereignissen zu deaktivieren.';
$helptxt['cal_highlight_birthdays'] = 'Diese Einstellung erlaubt es Ihnen, Geburtstage in den Mini-Kalendern, dem Hauptkalender oder an beiden Orten hervorzuheben oder das Hervorheben von Ereignissen zu deaktivieren.';
$helptxt['cal_disable_prev_next'] = 'Falls diese Einstellung aktiviert ist, werden die drei Monatsblöcke auf der linken Seite deaktiviert.';
$helptxt['cal_display_type'] = 'Diese Einstellung erlaubt es Ihnen, den Anzeigetyp des Kalenders zu ändern.<br><br><strong>Komfortabel:</strong> zeigt große Kalenderzeilen.<br><strong>Kompakt:</strong> zeigt kleine Kalenderzeilen.';
$helptxt['cal_week_links'] = 'Falls diese Einstellung aktiviert ist, werden Links zur Wochenansicht neben jeder Woche im Kalender eingefügt.';
$helptxt['cal_prev_next_links'] = 'Falls diese Einstellung aktiviert ist, werden zur einfacheren Navigation Links auf den vorigen und nächsten Monat oberhalb jedes Monats eingefügt.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'Falls diese Einstellung aktiviert ist, werden Monatsnamen im Kalender abgekürzt.<br><br><strong>Aktiviert:</strong> 1. %1$s<br><strong>Deaktiviert:</strong> 1. %2$s';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'Falls diese Einstellung aktiviert ist, werden Wochentagsnamen im Kalender abgekürzt.<br><br><strong>Aktiviert:</strong> %1$s<br><strong>Deaktiviert:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Servereinstellungen</strong><br>
	Hier können Sie die Kernkonfiguration Ihres Forums vornehmen. Dieser Bereich enthält Einstellungen zu Datenbank und URL,
	sowie anderen wichtigen Einstellungen wie E-Mail und dem Cache. Bitte seien Sie hier vorsichtig,
	da Fehlkonfiguration Ihr Forum unbenutzbar machen kann';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Dateien durchsuchen</strong><br>
			Durchsuchen Sie alle Dateianhänge, Profil- und Minitaturbilder, die von SMF gespeichert wurden.<br><br>
		</li><li>
			<strong>Dateianhänge-Einstellungen</strong><br>
			Legen Sie fest, wo Dateianhänge gespeichert werden und geben Sie an, welche Dateitypen erlaubt sind.<br><br>
		</li><li>
			<strong>Profilbild-Einstellungen</strong><br>
			Legen Sie fest, wo Profilbilder gespeichert werden und konfigurieren Sie deren Größenanpassung.<br><br>
		</li><li>
			<strong>Dateiwartung</strong><br>
			Überprüfen und reparieren Sie Fehler im Dateianhänge-Verzeichnis oder löschen Sie ausgewählte Dateianhänge.<br><br>
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Anzahl der vorigen Beiträge, die beim Antwort-Bildschirm in der Zusammenfassung angezeigt werden.';
$helptxt['enableAllMessages'] = 'Stellen Sie hier die <em>maximale</em> Anzahl an Beiträgen ein, bei denen der „Alle“-Beiträge-Link angezeigt werden soll. Stellen Sie diesen Wert auf weniger als die „Beitragsanzahl pro Seite im Thema“ ein, wird dieser Link nie angezeigt. Wird der Wert zu hoch gesetzt, kann das Forum verlangsamt werden.';
$helptxt['allow_guestAccess'] = 'Sollten Sie diese Option deaktivieren, können Gäste nur noch grundlegende Funktionen – Einloggen, Registrieren, Passworterinnerung etc. – des Forums benutzen. Dies ist nicht dasselbe wie Gästen den Zugriff auf Boards zu verbieten.';
$helptxt['userLanguage'] = 'Ermöglicht den Benutzern die Auswahl einer individuellen Sprache im Forum. Betrifft nicht die Standardeinstellung.';
$helptxt['trackStats'] = 'Statistiken aufzeichnen:<br>Erlaubt den Benutzern, die neuesten Beiträge und die meistbesuchten Themen Ihres Forums zu sehen.
		Außerdem werden diverse Statistiken wie die Anzahl der meisten gleichzeitig aktiven Benutzer, neue Mitglieder und neue Themen angezeigt.<hr>
		Seitenaufrufe:<br>Fügt den Statistiken eine weitere Spalte mit den Seitenaufrufen des Forums hinzu.';
$helptxt['titlesEnable'] = 'Wenn Sie benutzerdefinierte Titel einschalten, können Mitglieder mit den entsprechenden Berechtigungen sich einen frei definierbaren „Titel“
		geben, der unter dem Namen angezeigt wird.<br><em>Beispiel:</em><br>Jeff<br>Cooler Typ';
$helptxt['onlineEnable'] = 'Zeigt mithilfe eines Symbols für jedes Mitglied an, ob es online oder offline ist';
$helptxt['todayMod'] = 'Zeigt „Heute“ oder „Gestern“ statt des Datums an.<br><br>
		<strong>Beispiele:</strong><br><br>
			<ul class="normallist">
				<li>
				<strong>Deaktiviert</strong><br>
				3. Oktober 2009 um 00:59:18</li>
				<li><strong>Nur heute</strong><br>
				Heute um 00:59:18</li>
				<li><strong>Heute und gestern</strong><br>
				Gestern um 21:36:55</li>
			</ul>';
$helptxt['disableCustomPerPage'] = 'Diese Option verhindert, dass Benutzer die Anzahl von Themen oder Beiträgen, die pro Seite in der Themenliste und Themenansicht angezeigt werden, selbst festlegen können.';
$helptxt['enablePreviousNext'] = 'Dies zeigt einen Link zum nächsten und vorherigen Thema an.';
$helptxt['pollMode'] = 'Aktiviert oder deaktiviert Umfragen. Sollten Sie Umfragen deaktivieren, werden alle existierenden
		Umfragen auf dem Themen-Index versteckt. Sollen die Themen weiterhin angezeigt werden, dann wählen Sie
		„Umfragen als Themen anzeigen“.<br><br>Um zu bestimmen, wer Umfragen erstellen und löschen bzw. in
		ihnen abstimmen kann, stellen Sie die entsprechenden Berechtigungen ein. Beachten Sie dies bitte, falls
		Umfragen nicht funktionieren sollten.';
$helptxt['enableCompressedOutput'] = 'Aktiviert die komprimierte Datenübertragung, um Bandbreite zu sparen. Benötigt „zlib“ auf dem Server.';
$helptxt['httponlyCookies'] = 'Cookies werden von Skriptsprachen wie JavaScript nicht zugreifbar sein. Diese Einstellung kann dabei helfen, Identitätsdiebstähle durch XSS-Angriffe zu verringern. Dies kann zu Problemen mit Drittanbieter-Scripts führen, sollte aber eingeschaltet sein, wenn möglich.';
$helptxt['samesiteCookies'] = 'Das SameSite-Attribut des Set-Cookie-HTTP-Antwort-Headers erlaubt Ihnen festzulegen, ob Ihr Cookie auf einen Erstanbieter- oder Same-Site-Kontext eingeschränkt sein soll. Für weitere Informationen siehe <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = 'Diese Einstellung verwendet die Datenbank zum Speichern von Sitzungen. Diese Option ist primär für Server hinter Load-Balancern wichtig, sie hilft aber bei allen „Timeout“-Problemen und könnte das Forum schneller machen.';
$helptxt['databaseSession_loose'] = 'Wenn Sie dies einschalten, wird die vom Forum verwendete Bandbreite reduziert, jedoch wird bei einem Klick auf den Zurück-Button im Browser die vorherige Seite nicht neu geladen – dadurch werden die „Neue Beiträge“-Symbole und andere Werte nicht aktualisiert (es sei denn, Sie folgen einem Link auf die Seite, statt zu ihr zurück zu gehen).';
$helptxt['databaseSession_lifetime'] = 'Anzahl der Sekunden für die Länge einer Datenbanksitzung. Sollte eine Sitzung diese Zeit lang nicht gebraucht werden, wird die Sitzung mit einer „Zeitüberschreitung“ beendet. Empfohlen wird mindestens der Wert 2400.';
$helptxt['tfa_mode'] = 'Sie können eine weitere Ebene der Absicherung zu Ihrem Forum hinzufügen, indem Sie <a href="https://de.wikipedia.org/wiki/Zwei-Faktor-Authentisierung">Zwei-Faktor-Authentisierung</a> aktivieren. 2FA zwingt Ihre Benutzer, nach dem Login einen maschinen-generierten Code einzugeben. Sie müssen die 2FA zunächst für sich selbst einschalten, bevor Sie sie für andere Benutzer erzwingen können!';
$helptxt['cache_enable'] = 'SMF führt Zwischenspeicherung (Caching) auf verschiedenen Ebenen durch. Je höher die Caching-Ebene, desto mehr CPU-Zeit wird dazu verwendet werden, Informationen aus dem Cache abzurufen. Falls Caching auf ihrem Server verfügbar ist, wird empfohlen, dass Sie zunächst Level-1-Caching testen.';
$helptxt['cache_memcached'] = 'Falls Sie memcached nutzen, müssen Sie die Server-Daten angeben. Diese sollten als Komma-separierte Liste eingegeben werden, wie im folgenden Beispiel:<br><br>	„server1,server2,server3:port,server4“<br><br>Beachten Sie, dass SMF den Port 11211 verwendet, falls kein Port angegeben ist, es sei denn die Host-Angabe enthält einen Slash, in diesem Fall wird angenommen, dass ein alternatives Transportprotokoll verwendet wird und der Port wird auf 0 gesetzt. SMF wird versuchen, einfache/zufällige Lastverteilung über die angegebenen Server zu machen.';
$helptxt['cache_cachedir'] = 'Diese Einstellung gilt nur für das Datei-basierte Cachesystem von SMF und gibt den Pfad zum Cacheverzeichnis an. Es wird empfohlen, dass Sie dieses unterhalb von /tmp/ platzieren, allerdings funktioniert auch jedes andere Verzeichnis';
$helptxt['cache_sqlite_cachedir'] = 'Diese Einstellung gilt nur für das SQLite-Datenbank-Cachesystem und gibt den Pfad zum Cacheverzeichnis an. Es wird empfohlen, dass Sie dieses unterhalb von /tmp/ platzieren, allerdings funktioniert auch jedes andere Verzeichnis';
$helptxt['enableErrorLogging'] = 'Dies protokolliert alle Fehlermeldungen im Forum (z. B. fehlerhafter Login), damit Sie nachvollziehen können, was schiefgelaufen ist.';
$helptxt['enableErrorQueryLogging'] = 'Diese Option fügt die komplette Datenbankabfrage in das Fehlerprotokoll ein – dazu muss das Protokollieren von Fehlern aktiviert sein.<br><br><strong>Achtung: Damit geht die Möglichkeit verloren, das Fehlerprotokoll nach Fehlermeldungen zu filtern.</strong>';
$helptxt['disallow_sendBody'] = 'Verhindert das Versenden des Beitragsinhalts bei Antworten, neuen Beiträgen oder persönlichen Mitteilungen in den Benachrichtigungs-E-Mails.<br><br>Oftmals antworten Mitglieder auf diese E-Mails, so dass der Webmaster nicht nur eine Flut an E-Mails erhält, sondern auch ungewollt Inhalte sieht, die für Andere bestimmt sind.';
$helptxt['enable_ajax_alerts'] = 'Diese Option erlaubt Ihren Mitgliedern, AJAX-Benachrichtigungen zu empfangen. Das bedeutet, dass die Forumsseite nicht neu geladen werden muss, um Benachrichtigungen zu erhalten.<br><strong>Beachten Sie:</strong> Diese Option kann hohe Last auf Ihrem Server erzeugen, wenn viele Benutzer online sind.';
$helptxt['alerts_auto_purge'] = 'Sobald Alarme gelesen wurden, werden sie selten noch gebraucht. Aus Leistungsgründen ist es eine gute Idee, sie nach einer Weile automatisch zu löschen.';
$helptxt['jquery_source'] = 'Dies legt die Bezugsquelle der jQuery-Bibliothek fest. <em>Google-CDN, jQuery CDN</em> und <em>Microsoft-CDN</em> laden die jQuery-Bibliothek aus den jeweiligen CDN-Netzwerken. Mit <em>Lokal</em> wird nur die lokale Quelle verwendet. Mit <em>Benutzerdefiniert</em> können Sie eine benutzerdefinierte URL für die Bibliothek angeben.';
$helptxt['compactTopicPagesEnable'] = 'Zeigt nur eine bestimmte Anzahl von Seitennummern an.<br><em> Beispiel:</em>
		„3“ für: 1 … 4 [5] 6 … 9 <br>
		„5“ für: 1 … 3 4 [5] 6 7 … 9';
$helptxt['timeLoadPageEnable'] = 'Dies zeigt am unteren Bildschirmrand die Zeit in Sekunden an, die SMF für das Erstellen der Seite gebraucht hat.';
$helptxt['removeNestedQuotes'] = 'Dies wird alle verschachtelten Kommentare eines Beitrags entfernen, wenn ein solcher Beitrag über einen entsprechenden Link zitiert wird.';
$helptxt['max_image_width'] = 'Erlaubt die Angabe einer maximalen Breite für Bilder, die in Beiträge eingebettet oder daran angehängt sind. Bilder, die kleiner sind, werden dadurch nicht beeinträchtigt. Dies legt zudem fest, wie Bildanhänge angezeigt werden, wenn auf ein Miniaturbild geklickt wird.';
$helptxt['mail_type'] = 'Diese Option erlaubt es Ihnen, entweder die PHP-Standardeinstellungen zu wählen oder diese mit SMTP-Einstellungen zu überschreiben. PHP unterstützt keine Authentifizierung mit SMTP (die viele Hosts heutzutage erfordern), so dass Sie gegebenenfalls SMTP wählen müssen. Beachten Sie, dass SMTP langsamer sein kann und manche Server keine Benutzernamen und Passwörter akzeptieren.<br><br>Sie müssen keine SMTP-Daten eingeben, wenn Sie den PHP-Standard benutzen.';
$helptxt['attachment_manager_settings'] = 'Dateianhänge sind Dateien, die von den Benutzern hochgeladen und an einen Beitrag angehängt werden können. Die Details können hier konfiguriert werden.';
$helptxt['attachmentCheckExtensions'] = 'Hier können Sie anhand der Dateiendung einschränken, welche Dateitypen hochgeladen werden dürfen (z. B. nur JPG).';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'Falls oberhalb „Endung von Dateianhängen prüfen“ aktiviert ist, geben Sie hier die erlaubten Dateiendungen für neue Anhänge an.';
$helptxt['attachmentUploadDir'] = 'Der Pfad zu Ihrem Dateianhänge-Verzeichnis.<br>(Beispiel: /home/seiten/ihreseite/www/forum/attachments)';
$helptxt['attachmentDirSizeLimit'] = 'Wählen Sie die max. Größe des Dateianhänge-Verzeichnisses, inkl. aller Dateien darin.';
$helptxt['attachmentPostLimit'] = 'Wählen Sie die max. Größe aller Dateianhänge (in KB) aus, die pro Beitrag angehängt werden können. Falls dies weniger als die max. Größe jedes einzelnen Anhangs ist, wird dieser Wert das Limit sein.';
$helptxt['attachmentSizeLimit'] = 'Wählen Sie die max. Größe jedes einzelnen Dateianhangs aus.';
$helptxt['attachmentNumPerPostLimit'] = 'Wählen Sie die Anzahl der Dateianhänge, die ein Benutzer pro Beitrag anhängen kann.';
$helptxt['attachmentShowImages'] = 'Falls die hochgeladene Datei ein Bild ist, wird es unterhalb des Beitrags angezeigt.';
$helptxt['attachmentThumbnails'] = 'Wenn die vorherige Option aktiviert ist, wird für das Miniaturbild ein separater (kleinerer) Anhang gespeichert, um Bandbreite zu sparen.';
$helptxt['attachmentThumbWidth'] = 'Wird nur in Verbindung mit der Option „Bilder verkleinern, wenn sie unterhalb des Beitrags angezeigt werden“ benutzt und gibt die maximale Breite an, auf die Miniaturbilder verkleinert werden. Diese werden proportional verkleinert.';
$helptxt['attachmentThumbHeight'] = 'Wird in Verbindung mit der Option „Bilder verkleinern, wenn sie unterhalb des Beitrags angezeigt werden“ benutzt und gibt die maximale Höhe an, auf die Miniaturbilder verkleinert werden. Diese werden proportional verkleinert.';
$helptxt['attachmentDirFileLimit'] = 'Max. Anzahl von Dateien pro Verzeichnis';
$helptxt['attachmentEnable'] = 'Diese Einstellung erlaubt es Ihnen, zu konfigurieren, ob und wie Dateien angehängt werden können.<br><br>
	<ul class="normallist">
		<li>
			<strong>Alle Dateianhänge deaktivieren</strong><br>
			Alle Anhänge sind deaktiviert. Existierende Dateianhänge werden nicht gelöscht, sind aber unsichtbar (selbst Administratoren können sie nicht sehen). Zudem können keine neuen Anhänge hochgeladen werden, unabhängig von Berechtigungen.<br><br>
		</li>
		<li>
			<strong>Alle Dateianhänge aktivieren</strong><br>
			Alles verhält sich „normal“: abhängig von ihren individuellen Berechtigungen können Benutzer Anhänge entweder sehen oder nicht, sowie hochladen oder nicht.<br><br>
		</li>
		<li>
			<strong>Neue Dateianhänge deaktivieren</strong><br>
			Existierende Anhänge sind weiterhin verfügbar, aber es können keinen neuen Dateien hochgeladen werden, unabhängig von Berechtigungen.
		</li>
	</ul>';
$helptxt['attachment_image_paranoid'] = 'Bei Auswahl dieser Option erfolgt eine strenge Sicherheitsprüfung der Bild-Dateianhänge. <strong>Warnung!</strong> Diese umfangreichen Tests können auch gültige Bilder ablehnen. Es wird dringend empfohlen, diese Option nur zusammen mit der Bild-Neukodierung zu verwenden, bei der SMF versucht, die Bilder durch Resampling zu reinigen. Ist die Bild-Neukodierung nicht aktiviert, werden Anhänge zurückgewiesen, falls ein Test fehlschlägt.';
$helptxt['attachment_image_reencode'] = 'Bei Auswahl dieser Option wird versucht, hochgeladene Bilder neu zu kodieren. Die Bild-Neukodierung bietet mehr Sicherheit. Beachten Sie jedoch, dass die Neukodierung alle animierten Bilder statisch macht.<br>Diese Funktion ist nur verfügbar, wenn das GD-Modul auf Ihrem Server installiert ist.';
$helptxt['attachment_thumb_memory'] = 'Je größer das ursprüngliche Bild ist (Dateigröße, Breite und Höhe), desto höher ist der Speicherbedarf für das Erzeugen eines Miniaturbilds.<br>Wenn Sie diese Option aktivieren, wird das System den Speicherbedarf vorher abschätzen und im Anschluss prüfen, ob ausreichend Speicher zur Verfügung steht. Nur dann wird SMF versuchen, das Miniaturbild zu erzeugen.<br>Dies wird zu weniger Problemen mit leeren, „weißen“ Seiten beim Hochladen von Bildern führen, kann aber auch zur Folge haben, dass weniger Miniaturbilder erzeugt werden. Falls diese Option abgeschaltet ist, wird immer versucht, Miniaturbilder (mit einer konstanten Speichermenge) zu erzeugen und falls diese nicht ausreicht, wird es vermehrt zu Leere-Seiten-Fehlern kommen.';
$helptxt['attachmentRecodeLineEndings'] = 'Das Script wird Zeilenumbrüche entsprechend Ihrer Server-Einstellungen re-kodieren.';
$helptxt['automanage_attachments'] = 'Standardmäßig legt SMF neue Dateianhänge in einem einzelnen Verzeichnis ab. Für die meisten Foren ist dies kein Problem, aber wenn Ihre Seite eine bestimmte Größe erreicht, kann es sinnvoll sein, mehrere Verzeichnisse zu verwenden.<br><br>Diese Einstellung erlaubt Ihnen festzulegen, ob Sie diese Verzeichnisse selbst verwalten möchten (z. B. Anlegen eines weiteren Verzeichnisses und Anpassen der Konfiguration, so dass neue Anhänge dort gespeichert werden) oder ob SMF dies basierend auf bestimmten Kriterien erledigen soll (z. B. Größe des aktuellen Verzeichnisses, oder Unterteilung nach Jahren oder sogar Monaten bei sehr aktiven Foren).';
$helptxt['dont_show_attach_under_post'] = 'Falls aktiviert, werden Dateianhänge, die in Beiträge eingebettet sind, nicht erneut unterhalb des Beitrags angezeigt, für sie gelten allerdings trotzdem alle Einschränkungen, die für normale Anhänge gelten.';
$helptxt['use_subdirectories_for_attachments'] = 'Neue Verzeichnisse erzeugen.';
$helptxt['max_image_height'] = 'Analog zur maximalen Breite legt diese Einstellung fest, wie hoch Bilder in Beiträgen max. sein dürfen.';
$helptxt['avatar_paranoid'] = 'Bei Auswahl dieser Option erfolgt eine strenge Sicherheitsprüfung der Profilbilder. <strong>Warnung!</strong> Diese umfangreichen Tests können auch gültige Bilder ablehnen. Es wird dringend empfohlen, diese Option nur zusammen mit der Profilbild-Neukodierung zu verwenden, bei der SMF versucht, die Bilder durch Resampling zu reinigen. Ist die Profilbild-Neukodierung nicht aktiviert, werden Profilbilder zurückgewiesen, falls ein Test fehlschlägt.';
$helptxt['avatar_reencode'] = 'Bei Auswahl dieser Option wird versucht, hochgeladene Profilbilder neu zu kodieren. Die Bild-Neukodierung bietet mehr Sicherheit. Beachten Sie jedoch, dass die Neukodierung alle animierten Profilbilder statisch macht.<br>Diese Funktion ist nur verfügbar, wenn das GD-Modul auf Ihrem Server installiert ist.';
$helptxt['cal_enabled'] = 'Der Kalender kann benutzt werden, um Geburtstage oder andere Ereignisse anzuzeigen, die in Ihrer Community passieren. Diese Einstellung aktiviert den Kalender und all seine Features.';
$helptxt['cal_link_postevent'] = 'Erlaubt es Mitgliedern, Ereignisse für einen Tag einzutragen, indem sie auf das Datum klicken';
$helptxt['cal_maxdays_advance'] = 'Beispiel: Falls dies auf 7 gesetzt wird, werden alle Ereignisse der nächsten Woche angezeigt';
$helptxt['cal_allow_unlinkedevents'] = 'Mitgliedern das Eintragen von Ereignissen erlauben, die nicht mit einem Forumsbeitrag verknüpft sind';
$helptxt['cal_min_year'] = 'Wählen Sie das „erste“ Jahr aus, das im Kalender angezeigt werden soll';
$helptxt['cal_max_year'] = 'Wählen Sie das „letzte“ Jahr aus, das im Kalender angezeigt werden soll';
$helptxt['cal_maxevent_span'] = 'Wählen Sie die maximale Tagesanzahl aus, die ein Ereignis dauern kann';
$helptxt['localCookies'] = 'SMF verwendet Cookies, um die Login-Informationen auf dem Client-Computer zu speichern.
	Cookies können global („meineseite.de“) oder lokal („meineseite.de/pfad/zum/forum“) gespeichert werden.<br><br>
	Aktivieren Sie diese Option, falls Sie das Problem haben, dass Benutzer automatisch ausgeloggt werden.<hr>
	Global gespeicherte Cookies sind weniger sicher, wenn sie auf auf einem Server verwendet werden, den Sie sich mit anderen Benutzern teilen (z. B. Tripod).<hr>
	Lokal gespeicherte Cookies funktionieren nicht außerhalb des Forum-Verzeichnisses. Wenn das Forum unter „www.meineseite.de/forum“ gespeichert ist, können Dateien wie „www.meineseite.de/index.php“ nicht auf die Benutzerkonto-Informationen zugreifen.<br><br>
	Die Verwendung globaler Cookies wird insbesondere dann empfohlen, wenn Sie die Datei „SSI.php“ benutzen, generell sollten globale Cookies aber für alle Foren mit eigener Domain funktionieren.';
$helptxt['enableBBC'] = 'Diese Einstellung erlaubt den Mitgliedern die Benutzung von Bulletin-Board-Code (BBC) im Forum, der es den Benutzern ermöglicht, ihre Beitragstexte zu formatieren, Bilder einzufügen, andere Schriftarten zu verwenden und mehr.';
$helptxt['legacy_bbc'] = 'Veraltete BBCodes sind obsolet und können in neuen Beiträgen nicht verwendet werden. Allerdings werden alte Beiträge, die sie enthalten, weiterhin korrekt angezeigt, falls Sie diese Option aktivieren.<br><br>Diese Option ist nur dann sinnvoll, wenn Ihr Forum von einer älteren SMF-Version aktualisiert wurde.<br><br>Beachten Sie: Einige veraltete BBCodes werden nicht exakt so dargestellt, wie sie es früher wurden. Zum Beispiel zeigt der „[flash]“-BBCode einfach nur einen Link auf den Flash-Inhalt, statt diesen einzubetten.';
$helptxt['default_timezone'] = 'Dies ist die Standard-Zeitzone, die überall im Forum zur Zeitanzeige verwendet wird.';
$helptxt['timezone_priority_countries'] = 'Diese Einstellung erlaubt es Ihnen, Zeitzonen für bestimmte Länder an den Anfang der Liste zu verschieben, mit der Benutzer ihre persönliche Zeitzone auswählen, Kalenderereignisse erzeugen, etc.<br><br>Falls z. B. viele Ihrer Benutzer in Neuseeland oder Fidschi leben, können Sie „NZ,FJ“ eingeben, um es einfacher zu machen, diese Zeitzonen schnell zu finden.<br><br>Sie können die komplette Liste der ISO-Ländercodes im Internet finden, indem Sie nach „<a href="https://www.google.com/search?q=iso+3166-1+alpha-2" target="_blank" rel="noopener">ISO 3166-1 alpha-2</a>“ suchen.';
$helptxt['spamWaitTime'] = 'Hier können Sie die Zeitdauer angeben, die zwischen zwei Beiträgen von derselben IP-Adresse vergehen muss. Dies kann genutzt werden, um den „Spam“ in Ihrem Forum zu verringern.';

$helptxt['enablePostHTML'] = 'Erlaubt die Verwendung von einigen grundlegenden HTML-Tags:
	<ul class="normallist">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;strong&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br&gt;, &lt;hr&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['themes_manage'] = 'Hier können Sie neue Themes installieren und festlegen, welche Themes Ihre Benutzer auswählen können, was das Standard-Theme für neue Benutzer und Gäste ist, sowie weitere Theme-Einstellungen vornehmen.';
$helptxt['theme_install'] = 'Hier können Sie neue Themes installieren, indem Sie ein schon vorhandenes Verzeichnis benutzen, ein Theme-Paket hochladen oder das vorhandene Theme kopieren.<br><br>Beachten Sie, dass das Verzeichnis bzw. das Paket die Datei <pre>theme_info.xml</pre> enthalten muss.';
$helptxt['xmlnews_enable'] = 'Diese Option erlaubt den Benutzern, zu den <a href="%1$s?action=.xml;sa=news" target="_blank" rel="noopener">aktuellen Neuigkeiten</a> und ähnlichen Dingen zu verlinken. Es wird empfohlen, die Größe der „Neuesten Beiträge“/„News“ zu begrenzen, da einige RSS-Reader erwarten, dass die anzuzeigenden Daten abgekürzt werden.';
$helptxt['xmlnews_attachments'] = 'Erlaubt Verknüpfungen auf Dateianhänge in Ihren XML/RSS-Feeds. Schalten Sie dies ein, falls Sie ihr Forum als Verteilplattform für Podcasts, Broadcatching, oder Ähnliches verwenden wollen.
	<br><br>
	Die Berechtigung „Dateianhänge sehen“ beeinflusst diese Einstellung. Mitglieder und Gäste können an Beiträge angehängte Dateien im Feed nur sehen, wenn sie dies auch auf der Forums-Webseite können. Beachten Sie, dass die meisten Feedreader als Gast auf Ihre Feeds zugreifen.
	<br><br>
	Einige Feed-Formate erlauben nur einen Dateianhang pro Beitrag. Falls ein Beitrag mehrere Anhänge hat, wird SMF in diese Feeds den größten einfügen.';
$helptxt['globalCookies'] = 'Ermöglicht die Nutzung von Subdomain-unabhängigen Cookies. Ein Beispiel:<br>
	Ihre Webseite hat die Domain „https://www.example.com“,<br>
	Ihr Forum hat die Domain „https://forum.example.com“.<br>
	Diese Einstellung ermöglicht es, auch von Ihrer Webseite auf die Forum-Cookies zuzugreifen. Aktivieren Sie diese Einstellung nicht, wenn es noch andere Subdomains gibt, die nicht unter Ihrer Kontrolle sind (wie „hacker.example.com“).<br><br>
	Diese Einstellung funktioniert nicht, falls Sie die Option „lokal gespeicherte Cookies verwenden“ aktiviert haben.';
$helptxt['globalCookiesDomain'] = 'Falls Sie Subdomain-unabhängige Cookies („globale Cookies“) verwenden, können Sie hier angeben, welche Domain dafür verwendet werden soll. Dies sollte, natürlich, Ihre Hauptdomain sein – falls Sie z. B. <em>forum.example.com</em> und <em>www.example.com</em> benutzen, ist Ihre Hauptdomain <em>example.com</em>. Geben Sie nicht das Protokoll (<em>http://</em> oder <em>https://</em>) mit an.';
$helptxt['secureCookies'] = 'Wenn diese Option aktiviert ist, wird erzwungen, dass die für die Benutzer Ihres Forums erstellten Cookies als sicher markiert werden. Aktivieren Sie diese Option nur, wenn Sie HTTPS auf Ihrer gesamten Seite verwenden, da sich sonst niemand im Forum anmelden kann!';
$helptxt['securityDisable'] = 'Wenn Sie dies aktivieren, wird die erneute Passwortabfrage für das Administrationszentrum <em>deaktiviert</em>. Dies wird nicht empfohlen!';
$helptxt['securityDisable_why'] = 'Geben Sie hier Ihr aktuelles Passwort ein (dasselbe, das Sie zum Einloggen benutzen).<br><br>Diese erneute Passwortabfrage soll sicherstellen, dass Sie sich darüber im Klaren sind, dass Sie anschließend Administrationstätigkeiten nachgehen werden und dass wirklich <strong>Sie</strong> Ihr Konto bedienen.';
$helptxt['securityDisable_moderate'] = 'Wenn Sie dies aktivieren, wird die erneute Passwortabfrage für das Moderationszentrum <em>deaktiviert</em>. Dies ist standardmäßig aktiviert.';
$helptxt['securityDisable_moderate_why'] = 'Geben Sie hier Ihr aktuelles Passwort ein (dasselbe, das Sie zum Einloggen benutzen).<br><br>Diese erneute Passwortabfrage soll sicherstellen, dass Sie sich darüber im Klaren sind, dass Sie anschließend Moderationstätigkeiten nachgehen werden und dass wirklich <strong>Sie</strong> Ihr Konto bedienen.';
$helptxt['allow_cors'] = 'Cross Origin Resource Sharing oder CORS ist eine Richtlinie für moderne Browser, um Ressourcen zu vertrauen, die über verschiedene Domänen hinweg angefordert werden. Wenn diese Funktion aktiviert ist, wird versucht, die CORS-Richtlinie für Skripte, die auf die Ressourcen des Forums von verschiedenen Domänen aus zugreifen, aufzulösen. Wenn Subdomain-unabhängige Cookies (globale Cookies) aktiviert sind, wird versucht, die richtige Domain zu ermitteln. Die Angabe der zusätzlichen CORS-Domänen mit einer durch Kommata getrennten Liste von Domänen ermöglicht die Angabe weiterer Domänen. Das Format sollte {SCHEMA}://{DOMAIN} lauten. Wenn ein Platzhalter (*) in der Domäne angegeben wird, wird versucht, den Platzhalter aufzulösen. Wenn ein Platzhalter (*) als einzige zusätzliche Domäne angegeben wird, sind alle Domänen erlaubt. Dies kann ein Sicherheitsrisiko für Ihr Forum darstellen und sollte nur in Extremfällen verwendet werden. Zusätzliche Header können in einer kommaseparierten Liste angegeben werden und werden bei Anfragen, die diese Header enthalten, zugelassen, und der Platzhalter (*) ist erlaubt.';
$helptxt['frame_security'] = 'Moderne Browser verstehen einen vom Server mitgelieferten Security-Header namens „X-Frame-Options“. Mit dieser Option geben Sie an, ob und wie Ihr Forum in „framesets“ oder „iframes“ eingebettet werden darf. Falls Sie die Option „Deaktivieren“ wählen, wird kein Header gesendet; dies ist die unsicherste Wahl, bietet aber die meiste Freiheit. „Verbiete alle Frames“ wird jegliche Frames verhindern und ist die strikteste, sicherste Option. „Same-Origin erlauben“ wird lediglich Ihrer eigenen Domain erlauben, Frames zu verwenden und ist der Mittelweg zwischen den beiden vorigen Optionen.';
$helptxt['proxy_ip_header'] = 'Dies ist der Server-Header, dem SMF vertrauen wird, die tatsächlichen IP-Adressen der Benutzer zu enthalten. Falls Sie diesen Wert verändern, kann dies zu unerwarteten IP-Adress-Ergebnissen führen. Bevor Sie ihn verändern, befragen Sie ihren Serveradministrator, CDN-Anbieter oder Proxyadministrator. Die meisten Anbieter verstehen und nutzen "HTTP_X_FORWARDED_FOR". Sie sollten aus Sicherheitsgründen die Liste der Reverse-Proxy-Server-IPs ausfüllen, um sicherzustellen, dass diese Header nur aus vertrauenswürdigen Quellen kommen.';
$helptxt['email_members'] = 'In dieser Nachricht können Sie die folgenden „Variablen“ verwenden:<br>
	{$board_url} – Die URL Ihres Forums.<br>
	{$current_time} – Die aktuelle Zeit.<br>
	{$member.email} – Die E-Mail-Adresse des aktuellen Mitglieds.<br>
	{$member.link} – Der Link des aktuellen Mitglieds.<br>
	{$member.id} – Die ID des aktuellen Mitglieds.<br>
	{$member.name} – Der Name des aktuellen Mitglieds (zwecks Personalisierung).<br>
	{$latest_member.link} – Der Link des neuesten Mitglieds.<br>
	{$latest_member.id} – Die ID des neuesten Mitglieds.<br>
	{$latest_member.name} – Der Name des neuesten Mitglieds.';

$helptxt['failed_login_threshold'] = 'Geben Sie die Anzahl der erfolglosen Login-Versuche an, bevor der Benutzer zur Passworterinnerungsseite weitergeleitet wird.';
$helptxt['loginHistoryDays'] = 'Die Anzahl an Tagen, für die die Login-Historie im Benutzerprofil-Tracking aufbewahrt wird. Voreingestellt sind 30 Tage.';
$helptxt['oldTopicDays'] = 'Ist diese Option aktiviert, wird dem Benutzer eine Warnung angezeigt, wenn dieser versucht, auf ein Thema zu antworten, auf das seit der angegebenen Zeit (in Tagen) niemand mehr geantwortet hat. Setzen Sie den Wert auf 0, um die Funktion zu deaktivieren.';
$helptxt['edit_wait_time'] = 'Anzahl von Sekunden, innerhalb derer ein Beitrag bearbeitet werden darf, bevor das Datum der letzten Bearbeitung gespeichert wird.';
$helptxt['edit_disable_time'] = 'Anzahl von Minuten, nach denen ein Benutzer seine eigenen Beiträge nicht mehr bearbeiten darf. Setzen Sie den Wert auf 0, um die Funktion zu deaktivieren.<br><br><em>Beachten Sie: Diese Option hat keinen Effekt auf Benutzer, die die Berechtigung haben, die Beiträge anderer Personen zu bearbeiten.</em>';
$helptxt['preview_characters'] = 'Diese Einstellung setzt die Anzahl der verfügbaren Zeichen für die Themenvorschau der ersten und letzten Nachricht.';
$helptxt['quote_expand'] = 'Diese Einstellung erlaubt es, lange Zitate zusammenzuklappen und gibt den Benutzern die Möglichkeit, diese auf ihre volle Länge auszuklappen. Diese Einstellung hat keinen Einfluss auf Zitate, die kürzer als dieser Wert sind.';
$helptxt['posts_require_captcha'] = 'Diese Einstellung zwingt die Benutzer, jedes Mal eine Anti-Spam-Bot-Verifizierung durchzuführen, bevor ihre Beiträge veröffentlicht werden. Dies betrifft nur Benutzer, die unter die angegebene Anzahl von Beiträgen fallen und sollte das Spammen durch automatische Skripte verhindern.';
$helptxt['disable_wysiwyg'] = 'Diese Option verhindert die Benutzung des WYSIWYG-Editors („What You See Is What You Get“ – Was Sie sehen, ist, was Sie bekommen) auf der Antwortseite.';
$helptxt['lastActive'] = 'Gibt die Anzahl in Minuten an, für die Besucher auf der Forumshauptseite als aktiv gekennzeichnet werden. Standard sind 15 Minuten.';

$helptxt['customoptions'] = 'Dieser Bereich definiert die Optionen, die ein Benutzer aus einem Drop-Down Menü wählen kann. Hier müssen ein paar Punkte beachtet werden:
	<ul class="normallist">
		<li><strong>Standardoption:</strong> Das durch den „Radio-Button“ ausgewählte Feld ist die aktivierte Standardoption, wenn der Benutzer zum ersten Mal sein Profil anschaut.</li>
		<li><strong>Optionen löschen:</strong> Um eine Option zu löschen, entfernen Sie einfach den Text aus dem betreffenden Textfeld – bei allen Benutzern, die diese Option gewählt hatten, wird sie gelöscht.</li>
		<li><strong>Optionen neu ordnen:</strong> Sie können die Optionen neu ordnen, indem Sie den Text von einem Textfeld in ein anderes schreiben. Wichtig: Achten Sie unbedingt darauf, dass Sie den Text beim Umsortieren <strong>nicht</strong> verändern, da sonst die Benutzerdaten verlorengehen.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'Diese Funktion repariert automatisch kaputte Tabellen in Ihrer Datenbank, sodass Ihr Forum weiterhin funktioniert, und benachrichtigt Sie, wenn dies passiert.<br>Falls Sie diese Option deaktivieren, wird Ihr Forum so lange beeinträchtigt sein, bis Sie das Problem bemerken und manuell beheben.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'Diese Einstellung legt die Sprache fest, die PostgreSQLs Volltextsuche verwendet. Wählen Sie die Sprache, die in Ihrem Forum hauptsächlich verwendet wird. Falls Ihre Sprache in der Liste fehlt, oder Ihr Forum mehrere Sprachen verwendet, wählen Sie die Option „simple“.<br>
Diese Einstellung ist unabhängig von den SMF-Spracheinstellungen und den installierten Sprachen für SMF. <br>
Wenn Sie diesen Wert verändern, müssen Sie <a href="%1$s?action=admin;area=managesearch;sa=method" target="_blank" rel="noopener">den Volltext-Index wiederherstellen</a>.<br>
Falls eine benötigte Sprache nicht aufgeführt ist, bitten Sie Ihren Datenbank-Administrator, die PostgreSQL-Sprachunterstützung für diese Sprache zu installieren.';

$helptxt['enableParticipation'] = 'Zeigt ein kleines Symbol neben den Themen, zu denen der Benutzer beigetragen hat.';

$helptxt['db_persist'] = 'Erhöht die Geschwindigkeit zur Datenbank, indem eine Verbindung dauerhaft aufrecht erhalten wird. Wenn Sie keinen dedizierten Server benutzen, könnte es Probleme mit Ihrem Serveranbieter geben.<br>
Falls diese Option deaktiviert ist, müssen Sie gegebenenfalls die Optionen „mysqli.allow_persistent“ oder „pgsql.allow_persistent“ in Ihrer „php.ini“ aktivieren.';
$helptxt['ssi_db_user'] = 'Diese optionale Einstellung erlaubt die Verwendung eines anderen Datenbankbenutzers und -Passworts, wenn Sie „SSI.php“ verwenden.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'Dies verändert das URL-Format ein wenig, sodass sie Suchmaschinen besser gefallen. Sie sehen dann aus wie folgt: index.php/topic,1.0.html.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = 'Dieses Feature wird auf Ihrem Server funktionieren.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = 'Dieses Feature wird auf Ihrem Server nicht funktionieren.';
$helptxt['minimize_files'] = 'Diese Option wird die CSS- und JavaScript-Dateien minimieren, die Ihr Forum verwendet, wodurch die Server-Anfragen reduziert und die Ladezeiten für Ihre Benutzer verbessert werden.<br><br>Normalerweise sollten Sie diese Option aktiviert lassen. Der einzige Zeitpunkt, diese Option temporär zu deaktivieren, ist, während Sie die CSS- oder JavaScript-Dateien bearbeiten (z. B. beim Bearbeiten Ihres Themes oder der Entwicklung eines Mod-Pakets).';
$helptxt['boardindex_max_depth'] = 'Diese Einstellung steuert, wie viele Ebenen von Unter-Boards SMF überprüft, wenn es nach neuen Beiträgen sucht. Sie beeinflusst zudem, welche Boards miteinbezogen werden, falls die Option „Beiträge von untergeordneten Boards im Gesamtwert des übergeordneten Boards mitzählen“ aktiviert ist.<br><br>Falls dies z. B. auf „1“ gesetzt ist, wird ein Unter-Board auf der Übersichtsseite nur als „neu“ markiert, falls das Unter-Board selbst einen neuen Beitrag enthält. Falls es auf „2“ gesetzt ist, wird das Unter-Board als „neu“ markiert, sobald ein neuer Beitrag im Unter-Board selbst oder einem Unter-Unter-Board geschrieben wurde. Falls „10“ gesetzt ist, wird das Unter-Board mit „neu“ markiert, falls es einen neuen Beitrag im Unter-Board, einem Unter-Unter-Board, Unter-Unter-Unter-Board etc., bis zu 10 Ebenen tief, gibt.<br><br>Große, aktive Foren sollten diesen Wert auf eine niedrige Nummer setzen, um Server-Ressourcen zu sparen.';
$helptxt['countChildPosts'] = 'Aktivieren Sie diese Option, um die Beiträge und Themen der untergeordneten Boards zum Gesamtwert auf dem Board-Index zu addieren.<br><br>Das bedeutet, dass Boards ohne Beiträge nicht mehr mit „0“ angezeigt werden, falls diese untergeordnete Boards mit Beiträgen enthalten.';
$helptxt['allow_ignore_boards'] = 'Diese Option erlaubt den Benutzern, bestimmte Boards zu ignorieren.';
$helptxt['deny_boards_access'] = 'Wenn Sie diese Option auswählen, können Sie den Zugriff auf bestimmte Boards, basierend auf den Mitgliedergruppen-Berechtigungen, verweigern';

// argument(s): scripturl
$helptxt['who_enabled'] = 'Diese Einstellung steuert die Funktion „<a href="%1$s?action=who" target="_blank" rel="noopener">Wer ist online</a>“, die anzeigt, wer aktuell das Forum nutzt und was getan wird.';

$helptxt['recycle_enable'] = 'Ermöglicht die „Wiederherstellung“ von gelöschten Themen und Beiträgen in die entsprechenden Boards.';

$helptxt['enableReportPM'] = 'Diese Option erlaubt den Benutzern das Melden von persönlichen Mitteilungen an die Administratoren. Sie soll helfen, Missbräuche des Mitteilungssystems zu verfolgen.';
$helptxt['max_pm_recipients'] = 'Diese Option bestimmt die maximale Anzahl von Empfängern, die beim Schreiben von persönlichen Mitteilungen durch ein Forumsmitglied erlaubt sind. Dies soll helfen, PM-Spam zu verhindern. Benutzer mit der Berechtigung zum Senden von Newslettern sind von dieser Beschränkung ausgeschlossen. Geben Sie 0 für kein Limit ein.';
$helptxt['pm_posts_verification'] = 'Diese Einstellung zwingt die Benutzer, jedes Mal einen Code von einem Verifizierungsbild einzugeben, bevor eine persönliche Mitteilung versendet wird. Dies betrifft nur Benutzer, die unter die angegebene Anzahl von Beiträgen fallen und sollte das Spammen durch automatische Skripte verhindern.';
$helptxt['pm_posts_per_hour'] = 'Diese Einstellung limitiert die Anzahl der persönlichen Mitteilungen, die jeder Benutzer pro Stunde versenden darf. Dies hat keinen Effekt auf Administratoren oder Moderatoren.';

$helptxt['default_personal_text'] = 'Gibt den Standardtext an, den neue Benutzer als „persönlichen Text“ haben. Diese Einstellung steht nicht zur Verfügung, falls der persönliche Text deaktiviert ist, oder falls der Benutzer bei der Registrierung einen selbst gewählten persönlichen Text eingeben kann.';

$helptxt['registration_method'] = 'Diese Einstellung legt verschiedene Möglichkeiten der Registrierung fest. Sie können aus folgenden wählen:<br><br>
	<ul class="normallist">
		<li>
			<strong>Registrierung deaktiviert</strong><br>
				Deaktiviert die Registrierung, so dass sich neue Mitglieder nicht selbst im Forum registrieren können.<br>
		</li><li>
			<strong>Sofortige Registrierung</strong><br>
				Neue Mitglieder können, nachdem sie sich registriert haben, sofort einloggen und Beiträge schreiben.<br>
		</li><li>
			<strong>E-Mail-Aktivierung</strong><br>
				Nach der Registrierung erhalten neue Mitglieder eine E-Mail mit einem Aktivierungslink, den sie anklicken müssen, bevor sie das Forum nutzen können.<br>
		</li><li>
			<strong>Admin-Genehmigung</strong><br>
				Alle neuen Mitglieder müssen zuerst von einem Administrator genehmigt werden, bevor sie das Forum nutzen können.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Falls diese Einstellung aktiviert ist, müssen alle Mitglieder, die ihre E-Mail-Adresse in ihrem Profil ändern, diese bestätigen, bevor sie ihr Benutzerkonto wieder nutzen können';
$helptxt['approveAccountDeletion'] = 'Falls diese Einstellung aktiviert ist, muss das Löschen von Benutzerkonten durch einen Administrator genehmigt werden';

$helptxt['send_welcomeEmail'] = 'Falls diese Option aktiviert ist, wird allen neuen Mitgliedern nach der Registrierung eine Willkommens-E-Mail geschickt';
$helptxt['password_strength'] = 'Diese Einstellung bestimmt die "Qualität" der Passwörter aller Benutzer. Je komplexer das Passwort, desto schwieriger ist es zu erraten.
	Die verfügbaren Optionen sind:
	<ul class="normallist">
		<li><strong>Niedrig:</strong> Das Passwort muss aus mindestens vier Zeichen bestehen.</li>
		<li><strong>Mittel:</strong> Das Passwort muss mindestens acht Zeichen haben und darf nicht aus Teilen des Benutzernamens oder der E-Mail-Adresse bestehen.</li>
		<li><strong>Hoch:</strong> Gleiche Voraussetzungen wie bei "Mittel", aber das Passwort muss außerdem einen Mix aus Groß- und Kleinbuchstaben sowie mindestens eine Zahl enthalten.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'Falls diese Einstellung aktiviert ist, wird SMF versuchen, das Passwort-Speicherformat zu erkennen und es in das von SMF genutzte Format zu konvertieren. Dies wird typischerweise genutzt, wenn Sie von einer anderen Forumssoftware zu SMF wechseln, kann aber auch in anderen Szenarien genutzt werden. Falls Sie diese Option deaktivieren, können Benutzer sich nach einer Forumskonvertierung nicht mehr mit ihrem Passwort einloggen und müssen es zurücksetzen.';

$helptxt['coppaAge'] = 'The value specified in this box will determine the minimum age that new members must be in order to be granted immediate access to the forum.
	On registration they will be prompted to confirm whether they are over this age, and if not will either have their application rejected or suspended awaiting parental approval - dependent on the type of restriction chosen.
	If a value of 0 is chosen for this setting then all other age restriction settings shall be ignored.';
$helptxt['coppaType'] = 'Sollte die Altersbeschränkung aktiviert sein, bestimmt diese Option, was mit den Registrierungen der Benutzer passiert, die jünger als das Mindestalter sind. Es gibt die folgenden zwei Möglichkeiten:
	<ul class="normallist">
		<li>
			<strong>Registrierung ablehnen:</strong><br>
				Die Registrierung neuer Mitglieder unterhalb des Mindestalters wird sofort abgelehnt.<br>
		</li><li>
			<strong>Genehmigung von Eltern/Erziehungsberechtigten erforderlich</strong><br>
				Die Benutzerkonten neuer Mitglieder unterhalb des Mindestalters werden auf „Erwarte Genehmigung“ gesetzt und es wird ein Formular angezeigt, mit dem die Eltern die Genehmigung für die Mitgliedschaft im Forum erteilen müssen.
				Ihnen werden ebenso die Kontaktmöglichkeiten angezeigt, mit denen das Formular an den Administrator geschickt werden kann (per Post oder per Fax).
		</li>
	</ul>';
$helptxt['coppaPost'] = 'Die Textfelder mit den Kontaktangaben sind erforderlich, damit das Formular an den Administrator geschickt werden kann. Die Angaben werden allen neuen Mitgliedern angezeigt, die das Mindestalter noch nicht erreicht haben und sind für die Genehmigung durch Eltern/Erziehungsberechtigte unbedingt notwendig. Es muss mindestens eine Postadresse oder eine Faxnummer angegeben werden.';

$helptxt['allow_hideOnline'] = 'Wenn Sie diese Option aktivieren, können alle Mitglieder ihren Onlinestatus vor anderen Benutzern verstecken (außer vor Administratoren). Beachten Sie, dass das Deaktivieren keinen Einfluss auf gerade aktive Nutzer hat – es verhindert nur, dass sie sich zukünftig verstecken.';
$helptxt['meta_keywords'] = 'Diese Schlüsselwörter werden auf jeder Seite eingebunden um Suchmaschinen (usw.) die Hauptinhalte ihres Forums mitzuteilen. Geben Sie eine kommaseparierte Liste von Wörtern an und verwenden Sie kein HTML.';

$helptxt['latest_themes'] = 'Dieser Bereich zeigt die neuesten und beliebtesten Themes von <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a> an. Sollte er nicht sichtbar sein, kann Ihr Server <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a> nicht kontaktieren.';

$helptxt['secret_why_blank'] = 'Zu Ihrer Sicherheit werden sowohl Ihr Passwort als auch die Antwort auf Ihre geheime Frage verschlüsselt, sodass SMF weder Ihnen noch anderen verraten kann, wie diese lauten.';
$helptxt['moderator_why_missing'] = 'Da die Moderatoren für jedes Board einzeln ausgewählt werden, müssen Sie diese im Bereich <a href="%1$s?action=admin;area=manageboards" target="_blank" rel=noopener>Boards verwalten</a> eintragen.';

$helptxt['permissions'] = 'Berechtigungen haben die Funktion, Gruppen bestimmte Aktionen zu erlauben oder zu verbieten.<br><br>Sie können mit Hilfe der Checkboxen mehrere Boards gleichzeitig ändern oder die Berechtigungen einer bestimmten Gruppe ändern, indem Sie auf „Ändern“ klicken.';
$helptxt['permissions_board'] = 'Wenn ein Board auf „Global“ gesetzt ist, hat es keine speziellen Berechtigungen. „Lokal“ dagegen bedeutet, dass es eigene Berechtigungen hat – getrennt von den globalen. Dies erlaubt Ihnen, Boards mit mehr oder weniger Berechtigungen als andere zu haben, ohne dass Sie sie für jedes einzelne Board festlegen müssen.';
$helptxt['permissions_quickgroups'] = 'Erlaubt das Verwenden der „vordefinierten“ Berechtigungen – <em>Standard</em> bedeutet „nichts spezielles“, <em>einschränkend</em> bedeutet „wie ein Gast“, <em>Moderator</em> vergibt Berechtigungen „wie ein Moderator sie hat“ und <em>Wartungsmodus</em> bedeutet, dass die Berechtigungen einem Administrator sehr nahe kommen.';
$helptxt['permissions_deny'] = 'Das Verbieten von Berechtigungen erlaubt es Ihnen, gewählten Mitgliedergruppen bestimmte Fähigkeiten zu entziehen. Sie können eine Mitgliedergruppe mit einer „Verweigern“-Berechtigung jenen Mitgliedern zuweisen, denen Sie eine Berechtigung verweigern möchten.<br><br><strong>Seien Sie vorsichtig</strong>, da entzogene Berechtigungen einem Mitglied verweigert werden, egal in welchen Gruppen das Mitglied sonst noch ist.';
$helptxt['permissions_postgroups'] = 'Das Aktivieren von Berechtigungen für beitragsbasierende Gruppen erlaubt Ihnen, Mitgliedern mit einer bestimmten Beitragszahl Berechtigungen zuzuweisen. Diese Berechtigungen werden zu den bereits vorhanden <em>addiert</em>.';
$helptxt['membergroup_guests'] = 'Die Mitgliedergruppe „Gäste“ enthält alle Benutzer, die nicht eingeloggt sind.';
$helptxt['membergroup_regular_members'] = 'Die Mitgliedergruppe „Normale Mitglieder“ bezeichnet alle Benutzer, die eingeloggt sind, jedoch keiner primären Mitgliedergruppe zugeordnet sind.';
$helptxt['membergroup_administrator'] = 'Der Administrator kann, per Definition, alles im Forum machen und jedes Board ansehen. Es gibt keine Berechtigungseinstellungen für den Administrator.';
$helptxt['membergroup_moderator'] = 'Die Mitgliedergruppe „Moderator“ ist eine spezielle Gruppe. Die zugewiesenen Berechtigungen und Einstellungen gelten für Moderatoren, aber <em>nur in den Boards, die sie moderieren</em>. Außerhalb dieser Boards sind sie wie normale Benutzer. Beachten Sie, dass Berechtigungen dieser Gruppe ebenfalls für jede Gruppe gelten, der die Moderation von Boards erlaubt ist.';
$helptxt['membergroups'] = 'In SMF gibt es zwei Arten von Gruppen, denen die Mitglieder angehören können:
	<ul class="normallist">
		<li><strong>Reguläre Gruppen:</strong> In eine reguläre Gruppe werden Mitglieder nicht automatisch eingeteilt. Um ein Mitglied einer dieser Gruppen zuzuordnen, besuchen Sie das Profil des Benutzers und klicken auf „Benutzerkonto“. Von hier aus können Sie nun das Mitglied verschiedenen Gruppen zuordnen.</li>
		<li><strong>Beitragsbasierende Gruppen:</strong> Im Gegensatz zu regulären Gruppen können Sie beitragsabhängige Gruppen nicht zuordnen. Stattdessen werden Mitglieder diesen automatisch zugeordnet, wenn sie eine bestimmte Zahl an Beiträgen geschrieben haben.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Sie können diese Ereignisse bearbeiten, indem Sie auf den roten Stern (*) neben dem Namen klicken.';

$helptxt['maintenance_backup'] = 'Dieser Bereich ermöglicht Ihnen, eine Sicherung aller Beiträge, Einstellungen, Mitglieder und anderen Informationen Ihres Forums in einer – womöglich sehr großen – Datei zu speichern.<br><br>Es ist aus Sicherheitsgründen empfehlenswert, die Daten regelmäßig zu sichern, z. B. wöchentlich.';
$helptxt['maintenance_rot'] = 'Diese Funktion erlaubt die <strong>vollständige</strong> und <strong>unwiderrufliche</strong> Löschung alter Themen. Es ist empfehlenswert, vorher eine Sicherung vorzunehmen, falls Sie versehentlich zu viel löschen.<br><br><strong>Benutzen Sie diese Funktion mit Vorsicht!</strong>';
$helptxt['maintenance_members'] = 'Diese Funktion erlaubt die <strong>vollständige</strong> und <strong>unwiderrufliche</strong> Löschung von Benutzerkonten aus dem Forum. Es ist <strong>sehr</strong> empfehlenswert, vorher eine Sicherung vorzunehmen, falls Sie versehentlich zu viel löschen.<br><br><strong>Benutzen Sie diese Funktion mit Vorsicht!</strong>';

$helptxt['avatar_server_stored'] = 'Erlaubt Ihren Mitgliedern, aus Profilbildern auszuwählen, die auf Ihrem Server gespeichert sind. Standardmäßig werden sie im „avatars“-Verzeichnis gespeichert.<br>Tipp: Wenn Sie darin weitere Verzeichnisse erstellen, können Sie „Kategorien“ von Profilbildern einrichten.';
$helptxt['avatar_external'] = 'Erlaubt den Mitgliedern, URLs zu ihren Profilbildern auf anderen Servern einzugeben. Der Nachteil ist, dass Bilder verlinkt werden können, die sehr groß sind oder Inhalte zeigen, die im Forum unerwünscht sind.';
$helptxt['avatar_download_external'] = 'Wenn diese Einstellung aktiviert ist, werden externe Profilbilder von den durch die Benutzer angegebenen URLs heruntergeladen. Bei Erfolg werden die Profilbilder wie hochgeladene Profilbilder behandelt.';
$helptxt['avatar_action_too_large'] = 'Diese Einstellung erlaubt es Ihnen, zu große Bilder (von anderen Webseiten) entweder abzulehnen, im Browser des Benutzers zu verkleinern oder auf Ihren Server herunterzuladen.<br><br>Falls Benutzer sehr große Profilbilder verwenden und diese Option auf „Im Browser des Benutzers skalieren“ eingestellt ist, kann dies die Ladezeiten aller Benutzer beeinträchtigen, denn die Bilder werden nicht wirklich verkleinert, nur skaliert dargestellt. Große Bilder werden also trotzdem vollständig geladen und erst dann für die Darstellung verkleinert – für Ihre Benutzer könnte dies lang dauern und viel Bandbreite verbrauchen.<br><br>Andererseits kostet Sie das Herunterladen auf Ihren Server Bandbreite und Speicherplatz, aber so können Sie sicherstellen, dass die Profilbilder verkleinert werden, was für Ihre Benutzer schnellere Ladezeiten bedeutet. (Hinweis: Herunterladen und Skalieren benötigt entweder die GD-Bibliothek oder ImageMagick mit der Imagick- oder MagickWand-Erweiterung)';
$helptxt['avatar_upload'] = 'Diese Option gleicht dem „externen Profilbild“, hat aber den Vorteil, dass Sie mehr Kontrolle über die Profilbilder haben und die Mitglieder keine Möglichkeit brauchen, ihre Profilbilder selbst bereitzustellen.<br><br>Der Nachteil ist, dass Sie entsprechend mehr Platz auf Ihrem Server bereitstellen müssen.';
$helptxt['avatar_download_png'] = 'PNGs sind größer, bieten aber eine bessere Kompression. Sollte dies nicht aktiviert sein, werden stattdessen JPEG-Bilder benutzt – diese benötigen meist weniger Speicherplatz, bieten jedoch eine schlechtere Qualität.';

$helptxt['disableHostnameLookup'] = 'Deaktiviert die Hostnamen-Auflösung, die auf manchen Servern sehr langsam ist. Beachten Sie, dass dies das Bannen von Mitgliedern ineffektiver macht.';

$helptxt['smiley_sameall'] = 'Wenn Sie „Gleiches Bild für alle Sammlungen“ aktivieren, wird allen Ihren Smileysammlungen das gleiche Bild hinzugefügt. Wenn Sie die Option deaktivieren, kann für jede installierte Smileysammlung ein anderes Bild hochgeladen werden. Beachten Sie, dass für jede Smileysammlung ein Bild angegeben werden muss.';

$helptxt['search_weight_frequency'] = 'Gewichtungsfaktoren werden benutzt, um die Relevanz eines Suchresultats zu bestimmen. Verändern Sie diese Gewichtungen, um die Resultate auf Ihr Forum abzustimmen. Das Forum einer News-Seite zum Beispiel benötigt eine hohe Gewichtung auf „Alter der neuesten Übereinstimmung“. Alle Werte sind relativ zueinander und sollten positive Zahlen sein.<br><br>Dieser Faktor zählt die Anzahl der übereinstimmenden Beiträge und teilt sie durch die gesamte Zahl der Beiträge innerhalb eines Themas.';
$helptxt['search_weight_age'] = 'Gewichtungsfaktoren werden benutzt, um die Relevanz eines Suchresultats zu bestimmen. Verändern Sie diese Gewichtungen, um die Resultate auf Ihr Forum abzustimmen. Das Forum einer News-Seite zum Beispiel benötigt eine hohe Gewichtung auf „Alter der neuesten Übereinstimmung“. Alle Werte sind relativ zueinander und sollten positive Zahlen sein.<br><br>Dieser Faktor bewertet das Alter der neuesten Übereinstimmung innerhalb eines Themas. Je neuer der Beitrag, desto höher ist die Bewertung.';
$helptxt['search_weight_length'] = 'Gewichtungsfaktoren werden benutzt, um die Relevanz eines Suchresultats zu bestimmen. Verändern Sie diese Gewichtungen, um die Resultate auf Ihr Forum abzustimmen. Das Forum einer News-Seite zum Beispiel benötigt eine hohe Gewichtung auf „Alter der neuesten Übereinstimmung“. Alle Werte sind relativ zueinander und sollten positive Zahlen sein.<br><br>Dieser Faktor basiert auf der Themengröße. Je mehr Beiträge innerhalb eines Themas, desto höher ist die Bewertung.';
$helptxt['search_weight_subject'] = 'Gewichtungsfaktoren werden benutzt, um die Relevanz eines Suchresultats zu bestimmen. Verändern Sie diese Gewichtungen, um die Resultate auf Ihr Forum abzustimmen. Das Forum einer News-Seite zum Beispiel benötigt eine hohe Gewichtung auf „Alter der neuesten Übereinstimmung“. Alle Werte sind relativ zueinander und sollten positive Zahlen sein.<br><br>Dieser Faktor prüft das Vorhandensein eines Suchbegriffs innerhalb des Betreffs eines Themas.';
$helptxt['search_weight_first_message'] = 'Gewichtungsfaktoren werden benutzt, um die Relevanz eines Suchresultats zu bestimmen. Verändern Sie diese Gewichtungen, um die Resultate auf Ihr Forum abzustimmen. Das Forum einer News-Seite zum Beispiel benötigt eine hohe Gewichtung auf „Alter der neuesten Übereinstimmung“. Alle Werte sind relativ zueinander und sollten positive Zahlen sein.<br><br>Dieser Faktor prüft das Vorhandensein des Suchbegriffs im ersten Beitrag eines Themas.';
$helptxt['search_weight_sticky'] = 'Gewichtungsfaktoren werden benutzt, um die Relevanz eines Suchresultats zu bestimmen. Verändern Sie diese Gewichtungen, um die Resultate auf Ihr Forum abzustimmen. Das Forum einer News-Seite zum Beispiel benötigt eine hohe Gewichtung auf „Alter der neuesten Übereinstimmung“. Alle Werte sind relativ zueinander und sollten positive Zahlen sein.<br><br>Dieser Faktor prüft, ob das gefundene Thema angeheftet ist und bewertet es in diesem Fall höher.';
$helptxt['search'] = 'Hier können Sie die Einstellungen für die Suche verändern.';
$helptxt['search_why_use_index'] = 'Ein Such-Index kann die Geschwindigkeit der Suche im Forum deutlich erhöhen. Gerade bei einer großen Anzahl an Beiträgen kann die Suche ohne einen Index sehr lange dauern und die Datenbank stark belasten. Falls Ihr Forum mehr als 50 000 Beiträge enthält, sollten Sie die Erstellung eines Index in Erwägung ziehen, damit Ihr Forum weiterhin schnell reagiert.<br><br>Beachten Sie, dass ein Index unter Umständen einiges an Platz einnehmen kann. Ein Volltext-Index ist ein integrierter Index von MySQL und PostgreSQL. Dieser ist relativ kompakt (ungefähr so groß wie die Beitragstabelle), aber viele Wörter werden nicht indiziert und er kann, bei bestimmten Suchanfragen, sehr langsam sein. Der benutzerdefinierte Index ist meist größer (je nach Konfiguration bis zur 3-fachen Größe der Beitragstabelle), hat jedoch Geschwindigkeitsvorteile und ist relativ stabil.';

$helptxt['see_admin_ip'] = 'IP-Adressen werden Administratoren und Moderatoren zur besseren Moderation bzw. Verfolgung von missbräuchlichen Aktivitäten angezeigt. Beachten Sie, dass IP-Adressen Personen nicht unbedingt eindeutig identifizieren und häufig nach einer gewissen Zeit wechseln.<br><br>Mitglieder können ihre eigenen IP-Adressen sehen.';
$helptxt['see_member_ip'] = 'Ihre IP-Adresse wird nur Ihnen und Moderatoren angezeigt. Beachten Sie, dass diese Daten Personen nicht unbedingt eindeutig identifizieren, da IP-Adressen häufig nach einer gewissen Zeit wechseln.<br><br>Sie können die IP-Adressen anderer Benutzer nicht sehen und diese können Ihre nicht sehen.';
$helptxt['whytwoip'] = 'SMF verwendet verschiedene Methoden zur Ermittlung von Benutzer-IP-Adressen. Normalerweise ergeben diese beiden Methoden dieselbe Adresse, aber in einigen Fällen kann mehr als eine Adresse erkannt werden. In diesem Fall protokolliert SMF die beiden neuesten Adressen und verwendet sie beide für Sperrprüfungen (usw.). Sie können auf eine der beiden Adressen klicken, um diese IP zu verfolgen und gegebenenfalls zu sperren.';

$helptxt['ban_cannot_post'] = 'Die „Kann nicht schreiben“-Einschränkung erlaubt dem gebannten Benutzer nur noch das Lesen des Forums. Er kann keine neuen Themen erstellen oder auf existierende antworten, persönliche Mitteilungen versenden oder bei Umfragen abstimmen. Der Benutzer kann aber weiterhin Themen und persönliche Mitteilungen lesen.<br><br>Dem gebannten Benutzer wird eine Warnmeldung angezeigt.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Beitragseinstellungen</strong><br>
			Hier können Sie die Einstellungen bezüglich des Schreibens und der Ansicht von Beiträgen ändern. Auch die Rechtschreibprüfung lässt sich hier aktivieren.
		</li><li>
			<strong>Bulletin-Board-Code</strong><br>
			Aktivieren Sie hier die Code-Tags für die Formatierung von Beiträgen und bestimmen Sie, welche Codes erlaubt sind und welche nicht.
		</li><li>
			<strong>Zensierte Wörter</strong><br>
			Um die Ausdrucksweise in Ihrem Forum unter Kontrolle zu halten, können Sie bestimmte Wörter zensieren. Diese Funktion ersetzt verbotene Wörter mit harmlosen.
		</li><li>
			<strong>Themen-Einstellungen</strong><br>
			Hier können Sie Einstellungen bezüglich der Themen verändern: Anzahl der Themen pro Seite, ob die Druckansicht aktiviert ist, etc.
		</li>
	</ul>';

$helptxt['spider_mode'] = 'Setzt die Protokollierungsstufe.<br>
Standard – protokolliert minimale Crawler-Aktivität.<br>
Moderat – bietet genauere Statistiken.<br>
Aggressiv – dasselbe wie „Moderat“, aber protokolliert Daten über die besuchten Seiten.';

$helptxt['spider_group'] = 'Wenn Sie hier eine einschränkende Gruppe auswählen und ein Gast als Suchmaschinen-Crawler erkannt wird, werden diesem automatisch die „Verweigern“-Berechtigungen dieser Gruppe zusätzlich zu den Gastberechtigungen zugewiesen. Sie können dies tun, um Suchmaschinen weniger Berechtigungen einzuräumen als Gästen. Sie könnten z. B. eine neue Gruppe namens „Crawler“ erzeugen und diese hier auswählen. Dieser Gruppe könnten Sie verweigern, Benutzerprofile anzusehen, um zu verhindern, dass Suchmaschinen diese indexieren.<br>Beachten Sie: Die Suchmaschinen-Erkennung ist nicht perfekt und könnte legitime Benutzer als Suchmaschine erkennen und in ihren Berechtigungen einschränken.';
$helptxt['show_spider_online'] = 'Diese Einstellung erlaubt Ihnen zu wählen, ob Suchmaschinen-Crawler in der „Wer ist online?“-Liste auf der Forumshauptseite und „Wer ist online?“-Seite angezeigt werden. Die Optionen sind:
	<ul class="normallist">
		<li>
			<strong>Überhaupt nicht</strong><br>
			Crawler erscheinen als Gäste.
		</li><li>
			<strong>Zeige Crawler-Anzahl</strong><br>
			Die Forumshauptseite zeigt die Anzahl der zurzeit im Forum aktiven Crawler.
		</li><li>
			<strong>Zeige Crawler-Namen</strong><br>
			Alle Crawler-Namen werden angezeigt, so dass jeder Benutzer sehen kann, wie viele der verschiedenen Crawler gerade das Forum besuchen – dies gilt sowohl für die Forumshauptseite als auch die „Wer ist online?“-Seite.
		</li><li>
			<strong>Zeige Crawler-Namen – nur Administratoren</strong><br>
			Wie oben, nur dass lediglich Administratoren den Crawler-Status sehen können – alle anderen sehen sie als Gäste.
		</li>
	</ul>';

$helptxt['birthday_email'] = 'Wählen Sie die Nummer der Geburtstags-E-Mail-Vorlage. Eine Vorschau wird in den Feldern „E-Mail-Betreff“ und „E-Mail-Text“ angezeigt.<br><strong>Achtung:</strong> Das Auswählen dieser Option aktiviert nicht den automatischen Versand von Geburtstagsnachrichten. Um diesen zu aktivieren, benutzen Sie bitte die Seite „<a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" rel="noopener">Geplante Aufgaben</a>“ und aktivieren die Aufgabe „Geburtstagsnachricht senden“.';
$helptxt['pm_bcc'] = 'Wenn Sie eine persönliche Mitteilung versenden, können Sie weitere Empfänger als BCC (Blind Carbon Copy) hinzufügen. Die Identität der BCC-Empfänger wird den anderen Empfängern nicht mitgeteilt.';

$helptxt['move_topics_maintenance'] = 'Diese Funktion erlaubt es Ihnen, alle Beiträge aus einem Board in ein anderes Board zu verschieben.';
$helptxt['maintain_reattribute_posts'] = 'Sie können diese Funktion nutzen, um Gastbeiträge einem registrierten Mitglied zuzuordnen. Das ist z. B. sinnvoll, wenn ein Mitglied sein Benutzerkonto gelöscht hat, es sich dann anders überlegt und nach einer erneuten Registrierung die Beiträge mit seinem Konto verbunden haben möchte.';
$helptxt['chmod_flags'] = 'Sie können die Dateiberechtigungen auf einen selbst bestimmten Wert setzen. Geben Sie dazu einen numerischen (oktalen) chmod-Wert an. Beachten Sie – diese Einstellung hat keine Auswirkungen auf Microsoft-Windows-Betriebssysteme.';

$helptxt['postmod'] = 'Diese Sektion erlaubt es Mitgliedern des Moderatoren-Teams (mit ausreichenden Berechtigungen), Beiträge und Themen zu genehmigen, bevor diese angezeigt werden.';

$helptxt['field_show_enclosed'] = 'Umschließt die Benutzereingaben mit Text oder HTML. Dies erlaubt es Ihnen, weitere Sofortnachrichtenquellen, Bilder, Einbettungen oder Ähnliches hinzuzufügen. Beispielsweise:<br><br>
		&lt;a href="https://example.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br>
		Beachten Sie, dass Sie folgende Variablen verwenden können:<br>
		<ul class="normallist">
			<li>{INPUT} – die Eingabe des Benutzers.</li>
			<li>{SCRIPTURL} – Web-Adresse des Forums.</li>
			<li>{IMAGES_URL} – URL zum Bilder-Verzeichnis des vom Benutzer aktuell verwendeten Themes.</li>
			<li>{DEFAULT_IMAGES_URL} – URL zum Bilder-Verzeichnis des Standard-Themes.</li>
			<li>{KEY} – falls ein Feld mehrere Optionen hat, geben sie die eindeutige numerische ID der Option ein.</li>
		</ul>';

$helptxt['custom_mask'] = 'Die Eingabemaske ist für die Forumssicherheit wichtig. Das Validieren der Benutzereingaben stellt sicher, dass Daten nicht in einer Weise genutzt werden, die Sie nicht erwarten. Wir zeigen Ihnen im Folgenden einige einfache reguläre Ausdrücke als Hinweise.<br><br>
    Sie benötigen Trennzeichen zu Beginn und Ende des Musters. In den folgenden Beispielen wird die Tilde (~) verwendet.<br><br>
	<div class="smalltext" style="margin: 0 2em">
		„~[A-Za-z]+~“ – Trifft auf alle Groß- und Kleinbuchstaben zu.<br>
		„~[0-9]+~“ – trifft auf alle Zahlen zu.<br>
		„~[A-Za-z0-9]{7}~“ – trifft auf alle Groß- und Kleinbuchstaben sowie Zahlen in einer Länge von 7 Zeichen zu.<br>
		„~[^0-9]?~“ – schließe alle Zahlen aus.<br>
		„~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~“ – erlaube nur 3- oder 6-stellige Hex-Ziffern.<br>
		</div><br><br>
	Zusätzlich können die speziellen Meta-Zeichen ?+*^$ und {xx} definiert werden.
	<div class="smalltext" style="margin: 0 2em">
		? – kein oder ein Zutreffen des letzten Ausdrucks.<br>
		+ – ein oder mehrere Vorkommnisse des vorigen Ausdrucks.<br>
		* – kein oder mehr Vorkommnisse des vorigen Ausdrucks.<br>
		{xx} – eine bestimmte Anzahl an aufeinanderfolgenden Vorkommnissen des vorigen Ausdrucks.<br>
		{xx,} – eine bestimmte Anzahl oder mehr Vorkommnisse des vorigen Ausdrucks.<br>
		{,xx} – eine bestimmte Anzahl oder weniger an aufeinanderfolgenden Vorkommnissen des vorigen Ausdrucks.<br>
		{xx,yy} – eine Anzahl an aufeinanderfolgenden Vorkommnissen zwischen den beiden Zahlen des vorigen Ausdrucks.<br>
		^ – Start des Textes.<br>
		$ – Ende des Textes.<br>
		\\ – escapet das nächste Zeichen.<br>
	</div><br><br>
	Weitere Informationen und Methoden können im Internet nachgelesen werden.';

$helptxt['topic_move_any'] = 'Falls aktiviert, können Benutzer Themen in jedes Board verschieben, das sie sehen können. Andernfalls können sie Themen nur in Boards verschieben, in denen sie auch neue Themen beginnen können.';

$helptxt['alert_pm_new'] = 'Benachrichtigungen neuer persönlicher Mitteilungen erscheinen nicht im Alarme-Fenster, sondern in der „Meine-Mitteilungen“-Liste.';
$helptxt['alert_event_new'] = 'Dies wird einen Alarm, eine E-Mail oder beides erzeugen, falls ein neues Kalenderereignis hinzugefügt wird. Beachten Sie, dass Sie keinen zusätzlichen Alarm erhalten, falls das Ereignis mit einem Beitrag verknüpft ist und Sie für das Board bereits benachrichtigt werden – der Board-Alarm erledigt dies bereits.';

$helptxt['force_ssl'] = '<strong>Testen Sie SSL und HTTPS auf Ihrem Server gründlich, bevor Sie dies aktivieren, denn es kann dazu führen, dass Sie nicht mehr auf Ihr Forum zugreifen können.</strong> Falls dies passiert, aktivieren Sie den Wartungsmodus.<br><br><strong>Falls Sie diese Einstellung verändern, wird die Haupt-URL des Forums aktualisiert, sowie alle URLs Ihrer Theme-Dateien, Bilder, Smileys und Profilbilder, indem entweder http: oder https: eingetragen wird. Angepasste URLs sind hiervon nicht betroffen.</strong>';
$helptxt['image_proxy_enabled'] = 'Falls Sie ausschließlich SSL verwenden, benötigen Sie dies, um externe Bilder einzubetten';
$helptxt['image_proxy_secret'] = 'Halten Sie dies geheim, es beschützt Ihr Forum vor Direktverlinkung von Bildern. Verändern Sie es, falls Bilder bereits direkt verlinkt sind und Sie dies stoppen wollen';
$helptxt['image_proxy_maxsize'] = 'Maximale Bildgröße, die der SSL-Bild-Proxy zwischenspeichert: Bilder, die größer als dieser Wert sind, werden nicht zwischengespeichert. Zwischengespeicherte Bilder werden in Ihrem SMF-Cache-Verzeichnis gespeichert, also stellen Sie sicher, dass Sie über ausreichend freien Speicherplatz verfügen.';

$helptxt['enable_sm_stats'] = 'Falls aktiviert, erlaubt dies Simple Machines, Ihre Webseite monatlich zu besuchen, um grundlegende Statistiken zu sammeln. Dies hilft uns, Entscheidungen zu treffen, für welche Konfigurationen die Software optimiert wird. Für weitere Informationen besuchen Sie bitte unsere <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">Informationsseite</a>.';

$helptxt['field_reg_require'] = 'Falls dieses Feld während der Registrierung benötigt wird, wird es auch bei Profiländerungen benötigt.';

$helptxt['translatable_fields'] = 'Wenn Sie mehrsprachige Unterstützung für Ihre benutzerdefinierten Profilfelder anbieten möchten, können Sie übersetzbare Token sowohl für das Namens- als auch für das Beschreibungsfeld verwenden.<br><br>
Alles, was in geschweifte Klammern <span class="monospace">{}</span> eingeschlossen ist, wird als Token betrachtet und mit einer $txt-Zeichenkette abgeglichen. Zum Beispiel wird das Token <span class="monospace">{gender}</span> durch den Wert von $txt[\'gender\'] ersetzt<br><br>
Es ist <strong>sehr wichtig</strong>, die passende $txt-Zeichenkette zu <strong>ALLEN</strong> derzeit installierten Sprachen hinzuzufügen. Gehen Sie dazu auf die Seite <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Sprachen bearbeiten</a> und führen Sie die folgenden Schritte für jede installierte Sprache aus:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Klicken Sie auf die Schaltfläche „Bearbeiten“ neben dem Namen der Sprache.</li>
	<li>Im Menü „Zu bearbeitende Einträge auswählen“ wählen Sie „Modifications“.</li>
	<li>Scrollen Sie nach unten und klicken Sie auf die Schaltfläche „Weiteren Eintrag hinzufügen“.</li>
	<li>Folgen Sie den Aufforderungen, um die neue Zeichenfolge hinzuzufügen.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'SMF fügt standardmäßig jeder Seite ein bisschen JavaScript hinzu, das den Browser des Benutzers auffordert, im Hintergrund die Datei „cron.php“ von SMF aufzurufen. Dieser Ansatz erlaubt es SMF, regelmäßige Aufgaben auszuführen, ohne dass Sie zusätzliche Einstellungen am Server vornehmen müssen. Falls Sie jedoch bevorzugen, „cron.php“ regelmäßig direkt von Ihrem Server ausführen zu lassen, können Sie hier die JavaScript-Methode deaktivieren.<br><br><strong>Hinweis:</strong> Sie können SMF nicht nutzen, um Ihren Server zu konfigurieren, die regelmäßigen Aufgaben direkt auszuführen. Sie müssen dies über Ihre Server-Konfigurations-Software tun. Typische Werkzeuge dafür sind u.a. <code>cron</code> (für Linux-Server), <code>schtasks.exe</code> (für Windows-Server) und <code>launchd</code> (für macOS-Server). Viele Webhosting-Firmen stellen eine Art von Systemsteuerungs-Interface bereit, um ihren Kunden den Zugriff auf diese Werkzeuge zu gewähren.<br><br>Der Pfad und die URL der „cron.php“ Ihres Forums sind:<br>Pfad: %1$s/cron.php<br>URL: %2$s/cron.php';

$helptxt['languages_txt'] = 'Diese Sprachen-Einträge werden von SMF verwendet, um lokalisierte Versionen von Texten in verschiedenen Sprachen darzustellen.<br><br>Falls Sie einen Wert wie <code>&#37;1$s</code> in einem Eintrag sehen, ist dies ein Platzhalter, den SMF zur Laufzeit mit einem echten Wert füllt. Stellen Sie sicher, diese Platzhalter in Ihrem angepassten Text beizubehalten.';
$helptxt['languages_helptxt'] = 'Diese Sprachen-Einträge werden verwendet, um Popups mit Hilfetexten (wie diesen) anzuzeigen.';
$helptxt['languages_editortxt'] = 'Diese Sprachen-Einträge werden für Elemente der Benutzerschnittstelle im Beitrags-Editor verwendet.';
$helptxt['languages_tztxt'] = 'Diese Spracheinträge werden verwendet, um Beschreibungen für Zeitzonen zu erzeugen.<br><br>Zum Beispiel kann die Zeichenkette <code>Europe_Western</code> mit der Zeichenkette <code>daylight_saving_time_false</code> kombiniert werden, um die Zeichenkette „Westeuropäische Standardzeit“ zu produzieren.<br><br>Hinweis: Falls für eine Zeitzone keine Beschreibung angegeben wird, wird SMF eine Beschreibung basierend auf einer Ortsliste innerhalb der Zeitzone erzeugen.';
$helptxt['languages_txt_for_timezones'] = 'Diese Spracheinträge erlauben es Ihnen, folgendes zu tun:<br><ol class="bbc_list" style="list-style-type: decimal;"><li>Die Namen bearbeiten, die für verschiedene Orte im Kontext von Zeitzonen angezeigt werden. Beispielsweise können Sie SMF konfigurieren, „Qaanaaq“ statt „Thule“ für den Ort „Amerika/Thule“ anzuzeigen.</li><li>Die Namen bearbeiten, die für unterschiedliche Länder angezeigt werden. Sie können dies tun, indem Sie den dazugehörigen <code>iso3166[]</code>-Bezeichner bearbeiten.</li></ol>';
$helptxt['languages_txt_for_email_templates'] = 'Diese Spracheinträge werden benutzt, um Email-Nachrichten zu erstellen, die SMF an Ihre Mitglieder sendet.';
$helptxt['languages_native_name'] = 'Der Name der Sprache für sich selbst, dargestellt in der eigenen Schrift.';
$helptxt['languages_character_set'] = 'Die Zeichenkodierung, die für diese Sprache verwendet wird. In SMF 2.1 sollte dies immer „UTF-8“ sein.';
$helptxt['languages_locale'] = 'Der Gebietsschema-Code wird verwendet, um diverse Formatierungskonventionen etc. zu bestimmen.<br><br>Der Gebietsschema-Code hat üblicherweise die Form eines zweistelligen Sprachencodes, optional gefolgt von einem Unterstrich und einem zweistelligen Ländercode. Zum Beispiel würde <code>en</code> allgemeines Englisch identifizieren, während <code>en_AU</code> Australisches Englisch im Besonderen identifiziert.';
$helptxt['languages_rtl'] = 'Geben Sie hier eine  „1“ ein, falls diese Sprache von rechts nach links gelesen wird (z. B. Hebräisch, Arabisch).  Lassen Sie es auf  „0“ für Links-nach-Rechts-Sprachen.';
$helptxt['languages_dictionary'] = 'Dies definiert das Hauptsprachwörterbuch, das von der <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a>-Rechtschreibprüfung genutzt wird (falls diese installiert ist).';
$helptxt['languages_recaptcha'] = 'Der Sprachcode, der für das reCAPTCHA-Verifizierungs-Widget verwendet werden soll.<br><br>Bitte lesen Sie in der Google-reCAPTCHA-Dokumentation die <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" rel="noopener" class="bbc_link">Liste der unterstützten Sprachen</a> nach.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'Es wird empfohlen, diese Einstellung zu aktivieren, um den Regeln der <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR/DSGVO</a> zu entsprechen.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'Es wird empfohlen, diese Einstellung zu aktivieren, um den Regeln der <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR/DSGVO</a> zu entsprechen.';
$helptxt['gravatar'] = 'Gravatar steht für „Globally Recognized Avatars“ („Weltweit wiedererkennbare Profilbilder“). Registrieren Sie ein Benutzerkonto auf <a href="https://www.gravatar.com" target="_blank" rel="noopener">https://www.gravatar.com</a> um ein Profilbild auszuwählen. Dieses Profilbild ist dann auf jeder Seite verfügbar, die Gravatare unterstützt. Falls Sie kein Gravatar-Benutzerkonto haben, wird ein Standardbild verwendet.';

?>