<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Português brasileiro';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'pt_BR';
$txt['lang_dictionary'] = 'pt-br';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'pt-br';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1 234,00';

$txt['days_title'] = 'Dias';
$txt['days'] = array('Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado');
$txt['days_short'] = array('Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Meses';
$txt['months'] = array(1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril', 5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto', 9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro');
$txt['months_titles'] = array(1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril', 5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto', 9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro');
$txt['months_short'] = array(1 => 'Mar', 2 => 'Fev', 3 => 'Mar', 4 => 'Abr', 5 => 'Mai', 6 => 'Jun', 7 => 'Jul', 8 => 'Ago', 9 => 'Set', 10 => 'Out', 11 => 'Nov', 12 => 'Dez');
$txt['prev_month'] = 'Mês anterior';
$txt['next_month'] = 'Próximo mês';
$txt['start'] = 'Começo';
$txt['end'] = 'Fim';
$txt['starts'] = 'Começa';
$txt['ends'] = 'Acaba';
$txt['none'] = 'Nenhum';

$txt['minutes_label'] = 'Minutos';
$txt['hours_label'] = 'Horas';
$txt['years_title'] = 'Anos';

$txt['time_am'] = 'AM';
$txt['time_pm'] = 'PM';

// Short form of minutes
$txt['minutes_short'] = 'min';
// Short form of hour
$txt['hour_short'] = 'hr';
// Short form of hours
$txt['hours_short'] = 'hrs';
// Decimal sign
$txt['decimal_sign'] = '.';

$txt['admin'] = 'Administração';
$txt['moderate'] = 'Moderação';

$txt['save'] = 'Salvar';
$txt['reset'] = 'Redefinir';
$txt['upload'] = 'Enviar';
$txt['upload_all'] = 'Enviar tudo';
$txt['processing'] = 'Processando...';

$txt['modify'] = 'Alterar';
$txt['forum_index'] = '%1$s - Índice';
$txt['members'] = 'Membros';
$txt['board_name'] = 'Nome da seção';
$txt['posts'] = 'Postagens';

$txt['member_postcount'] = 'Postagens';
$txt['no_subject'] = '(Sem assunto)';
$txt['view_profile'] = 'Ver perfil';
$txt['guest_title'] = 'Visitante';
$txt['author'] = 'Autor';
$txt['on'] = 'em';
$txt['remove'] = 'Remover';
$txt['start_new_topic'] = 'Iniciar novo tópico';

$txt['login'] = 'Entrar';
// Use numeric entities in the below string.
$txt['username'] = 'Nome de usuário';
$txt['password'] = 'Senha';

$txt['username_no_exist'] = 'Esse usuário não existe.';
$txt['no_user_with_email'] = 'Não há nenhum usuário associado a esse email.';

$txt['board_moderator'] = 'Moderador da seção';
$txt['remove_topic'] = 'Excluir tópico';
$txt['topics'] = 'Tópicos';
$txt['modify_msg'] = 'Modificar mensagem';
$txt['name'] = 'Nome';
$txt['email'] = 'Email';
$txt['user_email_address'] = 'Endereço de email';
$txt['subject'] = 'Assunto';
$txt['message'] = 'Mensagem';
$txt['redirects'] = 'Redirecionamentos';
$txt['quick_modify'] = 'Edição rápida';
$txt['quick_modify_message'] = 'Você modificou esta mensagem com sucesso.';
$txt['reason_for_edit'] = 'Motivo para editar';

$txt['choose_pass'] = 'Escolha uma senha';
$txt['verify_pass'] = 'Verifique a senha';
$txt['notify_announcements'] = 'Permitir que os administradores me enviem notícias importantes por email';

$txt['position'] = 'Posição ';

// argument(s): username
$txt['view_profile_of_username'] = 'Ver o perfil de %1$s';
$txt['total'] = 'Total:';
$txt['website'] = 'Site';
$txt['register'] = 'Registrar-se';
$txt['warning_status'] = 'Estado de aviso';
$txt['user_warn_watch'] = 'O usuário está na lista de observação da moderação';
$txt['user_warn_moderate'] = 'As postagens do usuário entram na fila de aprovação';
$txt['user_warn_mute'] = 'Usuário é proibido de postar';
$txt['warn_watch'] = 'Observado';
$txt['warn_moderate'] = 'Moderado';
$txt['warn_mute'] = 'Silenciado';

$txt['message_index'] = 'Índice de mensagens';
$txt['news'] = 'Notícias';
$txt['home'] = 'Início';
$txt['page'] = 'Página';
$txt['prev'] = 'página anterior';
$txt['next'] = 'próxima página';

$txt['lock_unlock'] = 'Trancar/Destrancar Tópico';
$txt['post'] = 'Postar';
$txt['error_occured'] = 'Ocorreu um erro!';
$txt['at'] = 'em';
$txt['by'] = 'por';
$txt['logout'] = 'Sair';
$txt['started_by'] = 'Iniciado por';
$txt['topic_started_by'] = 'Iniciado por <strong>%1$s</strong> em <em>%2$s</em>';
$txt['replies'] = 'Respostas';
$txt['last_post'] = 'Última postagem';
$txt['first_post'] = 'Primeira postagem';
$txt['last_poster'] = 'Última postagem por';
$txt['last_post_message'] = '<strong>Última postagem: </strong>%3$s <span class="postby">%2$s por %1$s</span>';
$txt['last_post_topic'] = '%1$s <br>por %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> por <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$d postagens em %2$d Tópicos por %3$d membros';
$txt['show'] = 'Mostrar';
$txt['hide'] = 'Esconder';

$txt['admin_login'] = 'Login da administração';
// Use numeric entities in the below string.
$txt['topic'] = 'Tópico';
$txt['help'] = 'Ajuda';
$txt['terms_and_rules'] = 'Regras e Condições';
$txt['watch_board'] = 'Acompanhar esta seção';
$txt['unwatch_board'] = 'Parar de acompanhar esta seção';
$txt['watch_topic'] = 'Acompanhar este tópico';
$txt['unwatch_topic'] = 'Parar de acompanhar este tópico';
$txt['watching_topic'] = 'Tópico que você está acompanhando';
$txt['watching_this_topic'] = 'Você está acompanhando este tópico, e irá receber notificações sobre ele.';
$txt['notify'] = 'Notificar';
$txt['unnotify'] = 'Desativar notificação';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Atenciosamente,
Equipe %1$s.';

$txt['notify_replies'] = 'Notificar de respostas';
$txt['move_topic'] = 'Mover tópico';
$txt['move_to'] = 'Mover para';
$txt['pages'] = 'Páginas';
$txt['users_active'] = 'Usuários ativos nos últimos %1$d minutos';
$txt['personal_messages'] = 'Mensagens pessoais';
$txt['reply_quote'] = 'Responder com citação';
$txt['reply'] = 'Resposta';
$txt['reply_noun'] = 'Responder';
$txt['reply_number'] = 'Responder #%1$s%2$s';
$txt['approve'] = 'Aprovar';
$txt['unapprove'] = 'Desaprovar';
$txt['approve_all'] = 'aprovar todos';
$txt['issue_warning'] = 'Dar aviso';
$txt['awaiting_approval'] = 'Aguardando aprovação';
$txt['attach_awaiting_approve'] = 'Anexos aguardando aprovação';
$txt['post_awaiting_approval'] = 'Nota: Esta mensagem está aguardando aprovação de um moderador.';
$txt['there_are_unapproved_topics'] = 'Existem %1$s tópicos e %2$s postagens aguardando aprovação nesta seção. Clique <a href="%3$s">aqui</a> para ver todos eles.';
$txt['send_message'] = 'Enviar mensagem';

$txt['msg_alert_no_messages'] = 'você não tem nenhuma mensagem';
$txt['msg_alert_one_message'] = 'você tem <a href="%1$s">1 mensagem</a>';
$txt['msg_alert_many_message'] = 'você tem <a href="%1$s">%2$d mensagens</a>';
$txt['msg_alert_one_new'] = '1 é nova';
$txt['msg_alert_many_new'] = '%1$d são novas';
$txt['new_alert'] = 'Novo alerta';
$txt['remove_message'] = 'Excluir esta postagem';
$txt['remove_message_question'] = 'Excluir esta postagem?';

$txt['topic_alert_none'] = 'Nenhuma mensagem...';
$txt['pm_alert_none'] = 'Nenhuma mensagem...';
$txt['no_messages'] = 'Nenhuma mensagem';

$txt['online_users'] = 'Usuários online';
$txt['jump_to'] = 'Ir para';
$txt['go'] = 'Ir';
$txt['are_sure_remove_topic'] = 'Tem certeza que quer excluir este tópico?';
$txt['yes'] = 'Sim';
$txt['no'] = 'Não';

$txt['search_end_results'] = 'Fim dos resultados';
$txt['search_on'] = 'online';

$txt['search'] = 'Buscar';
$txt['all'] = 'Tudo';
$txt['search_entireforum'] = 'No fórum inteiro';
$txt['search_thisboard'] = 'Esta seção';
$txt['search_thistopic'] = 'Neste tópico';
$txt['search_members'] = 'Membros';

$txt['back'] = 'Voltar';
$txt['continue'] = 'Continuar';
$txt['password_reminder'] = 'Lembrete de senha';
$txt['topic_started'] = 'Tópico iniciado por';
$txt['title'] = 'Título';
$txt['post_by'] = 'Enviado por';
$txt['memberlist_searchable'] = 'Lista pesquisável de todos os usuários registrados.';
$txt['welcome_newest_member'] = 'Dêem as boas vindas para %1$s, que acabou de se registrar.';
$txt['admin_center'] = 'Centro de Administração';
$txt['last_edit_by'] = '<span class="lastedit">Última edição</span>: %1$s por %2$s';
$txt['last_edit_reason'] = '<span class="lastedit">Motivo</span>: %1$s';
$txt['notify_deactivate'] = 'Deseja desativar notificações deste tópico?';
$txt['modified_time'] = 'Última edição';
$txt['modified_by'] = 'Editado por';

$txt['recent_posts'] = 'Postagens recentes';

$txt['location'] = 'Local';
$txt['location_desc'] = 'Localização geográfica.';
$txt['gender'] = 'Sexo';
$txt['gender_0'] = 'Não informar';
$txt['gender_1'] = 'Masculino';
$txt['gender_2'] = 'Feminino';
$txt['gender_desc'] = 'Seu gênero.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Seu ID do ICQ.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Seu nome de usuário no Skype';
$txt['personal_text'] = 'Texto pessoal';
$txt['date_registered'] = 'Data de registro';

$txt['recent_view'] = 'Ver os postagens mais recentes do fórum.';
$txt['recent_updated'] = 'foi o último tópico a ser respondido';
$txt['is_recent_updated'] = '%1$s é o tópico mais recentemente atualizado';

$txt['male'] = 'Masculino';
$txt['female'] = 'Feminino';

$txt['error_invalid_characters_username'] = 'Uso de caractere inválido no nome de usuário.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Bem-vindo ao <strong>%1$s</strong>. Por favor, <a href="%2$s" onclick="%3$s">faça o login</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Bem-vindo ao <strong>%1$s</strong>. Por favor, <a href="%2$s" onclick="%3$s">faça o login</a> ou <a href="%4$s">registre-se</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Perdeu o seu e-mail de ativação?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Não tem uma conta? <a href="%1$s?action=signup">Registre-se</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Bem-vindo ao <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Olá,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Bem-vindo(a),';
$txt['select_destination'] = 'Por favor, selecione um destino';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Enviado por';

$txt['icon_smiley'] = 'Sorrindo';
$txt['icon_angry'] = 'Zangado';
$txt['icon_cheesy'] = 'Feliz';
$txt['icon_laugh'] = 'Risada';
$txt['icon_sad'] = 'Triste';
$txt['icon_wink'] = 'Piscar o olho';
$txt['icon_grin'] = 'Sorriso grande';
$txt['icon_shocked'] = 'Chocado';
$txt['icon_cool'] = 'Legal';
$txt['icon_huh'] = 'Hã?';
$txt['icon_rolleyes'] = 'Virar os olhos';
$txt['icon_tongue'] = 'Língua';
$txt['icon_embarrassed'] = 'Envergonhado';
$txt['icon_lips'] = 'Lábios selados';
$txt['icon_undecided'] = 'Indeciso';
$txt['icon_kiss'] = 'Beijo';
$txt['icon_cry'] = 'Chorar';

$txt['moderator'] = 'Moderador';
$txt['moderators'] = 'Moderadores';

$txt['views'] = 'Visualizações';
$txt['new'] = 'Nova';

$txt['view_all_members'] = 'Ver todos os membros';
$txt['view'] = 'Ver';

$txt['viewing_members'] = 'Vendo membros %1$s à %2$s ';
$txt['of_total_members'] = 'de %1$s membros totais.';

$txt['forgot_your_password'] = 'Esqueceu sua senha?';

$txt['date'] = 'Data';
// Use numeric entities in the below string.
$txt['from'] = 'De';
$txt['check_new_messages'] = 'Verificar se há novas mensagens';
$txt['to'] = 'Para';

$txt['board_topics'] = 'Tópicos';
$txt['members_title'] = 'Membros';
$txt['members_list'] = 'Lista de Membros';
$txt['new_posts'] = 'Novas postagens';
$txt['old_posts'] = 'Não há novas postagens';
$txt['redirect_board'] = 'Seção de redirecionamento';

$txt['sendtopic_send'] = 'Enviar';
$txt['report_sent'] = 'Sua denúncia foi enviada com sucesso.';
$txt['post_becomes_unapproved'] = 'Sua mensagem não foi aprovada porque foi postada em um tópico não aprovado. Assim que o tópico for aprovado, sua mensagem também será aprovada.';

$txt['time_offset'] = 'Diferença horária';
$txt['or'] = '<em>ou</em>';

$txt['no_matches'] = 'Desculpe, não foram encontrados resultados para sua busca.';

$txt['notification'] = 'Notificação';

$txt['your_ban'] = 'Desculpe %1$s, mas você foi banido deste fórum!';
$txt['your_ban_expires'] = 'Este banimento expira em %1$s.';
$txt['your_ban_expires_never'] = 'Este banimento não está definido para expirar.';
$txt['ban_continue_browse'] = 'Você pode continuar acessando este fórum como visitante.';

$txt['mark_as_read'] = 'Marcar TODAS as mensagens como lidas';

$txt['locked_topic'] = 'Tópico trancado';
$txt['normal_topic'] = 'Tópico normal';
$txt['participation_caption'] = 'Tópico que você participou';
$txt['moved_topic'] = 'Tópico movido';

$txt['go_caps'] = 'IR';

$txt['print'] = 'Imprimir';
$txt['profile'] = 'Perfil';
$txt['topic_summary'] = 'Resumo do tópico';
$txt['not_applicable'] = 'N/D';
$txt['name_in_use'] = 'Este nome já está em uso por outro usuário.';

$txt['total_members'] = 'Total de usuários';
$txt['total_posts'] = 'Total de postagens';
$txt['total_topics'] = 'Total de tópicos';

$txt['time_logged_in'] = 'Tempo para permanecer conectado';

$txt['preview'] = 'Pré-visualizar';
$txt['always_logged_in'] = 'Pra sempre';

$txt['logged'] = 'Logado';
$txt['show_ip'] = 'Mostrar endereço de IP';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';
$txt['url'] = 'URL';
$txt['www'] = 'WWW';

$txt['hours'] = 'horas';
$txt['minutes'] = 'minutos';
$txt['seconds'] = 'segundos';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Hora';
$txt['days_word'] = 'dias';

$txt['search_for'] = 'Buscar por';
$txt['search_match'] = 'Encontrar';

$txt['forum_in_maintenance'] = 'Seu fórum está em Modo de Manutenção no momento. Somente administradores podem logar.';
$txt['maintenance_page'] = 'Você pode desativar o Modo de Manutenção na área de <a href="%1$s">Configurações de Servidor</a>.';

$txt['read_one_time'] = 'Lido 1 vez';
$txt['read_many_times'] = 'Lido %1$d vezes';

$txt['forum_stats'] = 'Estatísticas do fórum';
$txt['latest_member'] = 'Usuário mais recente';
$txt['total_cats'] = 'Total de categorias';
$txt['latest_post'] = 'Última postagem';

$txt['total_boards'] = 'Total de seções';

$txt['print_page'] = 'Imprimir página';
$txt['print_page_text'] = 'Somente texto';
$txt['print_page_images'] = 'Texto com imagens';

$txt['valid_email'] = 'Isto precisa ser um email válido.';

$txt['geek'] = 'Sou um Geek!!';
$txt['info_center_title'] = '%1$s - Centro de Informação';

$txt['watch'] = 'Acompanhar';
$txt['unwatch'] = 'Parar de acompanhar';

$txt['check_all'] = 'Selecionar todas';

// Use numeric entities in the below string.
$txt['database_error'] = 'Erro no banco de dados';
$txt['try_again'] = 'Por favor, tente novamente. Se voltar a esta tela de erro, informe a um administrador.';
$txt['file'] = 'Arquivo';
$txt['line'] = 'Linha';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'O SMF detectou e tentou reparar automaticamente um erro no banco de dados. Se continuar a ter problemas, ou continuar a receber estes emails, entre em contato com seu host.';
$txt['database_error_versions'] = '<strong>Nota:</strong> Parece que seu banco de dados precisa ser atualizado. Os arquivos do seu fórum estão na versão %1$s, mas seu banco de dados está na versão %2$s. É possível que este erro possa ser consertado usando a última versão do upgrade.php.';
$txt['template_parse_error'] = 'Erro na análise do modelo!';
$txt['template_parse_error_message'] = 'Parece que algo deu errado no fórum com o sistema de modelos. Este problema deve ser apenas temporário. Volte mais tarde e tente novamente. Se continuar vendo esta mensagem, entre em contato com o administrador.<br><br>Você também pode tentar <a href="javascript:location.reload();">atualizar esta página</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Ocorreu um problema ao carregar o modelo ou arquivo de idioma <pre><strong>%1$s</strong></pre>. Por favor, verifique a sintaxe e tente novamente - lembre-se, aspas simples (<pre>\'</pre>) geralmente precisam ser escapadas com uma barra (<pre>\\</pre>). Para ver informações de erro mais específicas do PHP, tente <a href="%2$s%1$s">acessar o arquivo diretamente</a>.<br><br>Você também pode tentar <a href="javascript:location.reload();">atualizar esta página</a> ou <a href="%3$s?theme=1">usar o tema padrão</a>.';
$txt['template_parse_errmsg'] = 'Infelizmente, não há mais informações disponíveis neste momento sobre o que deu errado.';

$txt['today'] = '<strong>Hoje</strong> às ';
$txt['yesterday'] = '<strong>Ontem</strong> às ';
$txt['new_poll'] = 'Nova enquete';
$txt['poll_question'] = 'Pergunta';
$txt['poll_vote'] = 'Enviar voto';
$txt['poll_total_voters'] = 'Total de membros que votaram';
$txt['poll_results'] = 'Ver resultados';
$txt['poll_lock'] = 'Trancar votação';
$txt['poll_unlock'] = 'Destrancar votação';
$txt['poll_edit'] = 'Editar enquete';
$txt['poll'] = 'Enquete';
$txt['one_hour'] = '1 hora';
$txt['one_day'] = '1 dia';
$txt['one_week'] = '1 semana';
$txt['two_weeks'] = '2 semanas';
$txt['one_month'] = '1 mês';
$txt['two_months'] = '2 meses';
$txt['forever'] = 'Ficar sempre online';
$txt['moved'] = 'MOVIDO';
$txt['move_why'] = 'Insira uma breve descrição do<br>motivo pelo qual este tópico está sendo movido.';
$txt['board'] = 'Seção';
$txt['in'] = 'em';
$txt['sticky_topic'] = 'Tópico fixo';

$txt['delete'] = 'Apagar';
$txt['no_change'] = 'Não alterar';

$txt['your_pms'] = 'Suas mensagens pessoais';

$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Mais estatísticas]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Código';
$txt['code_select'] = 'Selecionar';
$txt['code_expand'] = 'Expandir';
$txt['code_shrink'] = 'Encolher';
$txt['quote_from'] = 'Citação de';
$txt['quote'] = 'Citar';
$txt['quote_action'] = 'Citar';
$txt['quote_selected_action'] = 'Citar texto selecionado';
$txt['fulledit'] = 'Edição&nbsp;completa';
$txt['edit'] = 'Editar';
$txt['quick_edit'] = 'Edição rápida';
$txt['post_options'] = 'Mais...';

$txt['merge_to_topic_id'] = 'ID do tópico alvo';
$txt['split'] = 'Dividir o tópico';
$txt['merge'] = 'Unir tópicos';
$txt['target_id'] = 'Selecionar alvo por ID de tópico';
$txt['target_below'] = 'Selecionar alvo da lista abaixo';
$txt['subject_new_topic'] = 'Título para o novo tópico';
$txt['split_this_post'] = 'Separar apenas esta postagem.';
$txt['split_after_and_this_post'] = 'Dividir o tópico desta postagem em diante.';
$txt['select_split_posts'] = 'Selecione as postagens para dividir.';
$txt['new_topic'] = 'Novo tópico';
$txt['split_successful'] = 'O tópico foi dividido em dois com sucesso.';
$txt['origin_topic'] = 'Tópico de origem';
$txt['please_select_split'] = 'Selecione quais postagens você deseja dividir.';
$txt['merge_successful'] = 'Os tópicos foram unidos com sucesso.';
$txt['new_merged_topic'] = 'Tópico unido recentemente';
$txt['topic_to_merge'] = 'Tópico a ser unido';
$txt['target_board'] = 'Seção alvo';
$txt['target_topic'] = 'Tópico alvo';
$txt['merge_desc'] = 'Esta função irá unir as mensagens de dois tópicos diferentes em um único tópico. As mensagens serão ordenadas de acordo com a data em que foram enviadas. Como tal, a mensagem mais antiga será o primeiro post do novo tópico.';

$txt['set_sticky'] = 'Fixar tópico';
$txt['set_nonsticky'] = 'Desfixar tópico';
$txt['set_lock'] = 'Trancar tópico';
$txt['set_unlock'] = 'Destrancar tópico';

$txt['search_advanced'] = 'Busca avançada';

$txt['security_risk'] = 'RISCO DE SEGURANÇA:';
$txt['not_removed'] = 'Você não apagou ';
$txt['not_removed_extra'] = '%1$s é um backup de %2$s que não foi gerado pelo SMF. Ele pode ser acessado diretamente e usado para obter acesso não autorizado ao seu fórum. Você deve excluí-lo imediatamente.';
$txt['generic_warning'] = 'Aviso';
$txt['agreement_missing'] = 'Você está exigindo que novos usuários aceitem um contrato de registro; mas, o arquivo (agreement.txt) não existe.';
$txt['policy_agreement_missing'] = 'Você está exigindo que novos usuários aceitem uma política de privacidade; mas, a política de privacidade está vazia.';
$txt['auth_secret_missing'] = 'Não foi possível definir o segredo de autenticação em Settings.php. Isso enfraquece a segurança do seu fórum e o coloca em risco de ataques. Verifique as permissões do arquivo em Settings.php para garantir que o SMF possa gravar no arquivo.';

$txt['cache_writable'] = 'O diretório do cache não tem permissões de escrita - isto irá afetar negativamente o desempenho do seu fórum.';

$txt['page_created_full'] = 'Página criada em %1$.3f segundos com %2$d procedimentos.';

$txt['report_to_mod_func'] = 'Use esta função para informar aos Moderadores e Administradores algum uso abusivo do fórum ou de alguma mensagem que não se enquadra neste tópico.';
$txt['report_profile_func'] = 'Use esta função para informar os Administradores de conteúdo de perfil abusivo, como spam ou imagens inapropriadas.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s está online';
$txt['offline'] = 'Desconectado';
$txt['member_is_offline'] = '%1$s está offline';
$txt['pm_online'] = 'Mesagem pessoal (Online)';
$txt['pm_offline'] = 'Mesagem pessoal (Offline)';
$txt['status'] = 'Estado';

$txt['go_up'] = 'Ir para o topo';
$txt['go_down'] = 'Ir para o fim';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title=Licença" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Aniversários:';
$txt['events'] = 'Eventos:';
$txt['birthdays_upcoming'] = 'Próximos aniversários:';
$txt['events_upcoming'] = 'Próximos eventos:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Férias:';
$txt['calendar_month'] = 'Mês';
$txt['calendar_year'] = 'Ano';
$txt['calendar_day'] = 'Dia';
$txt['calendar_event_title'] = 'Título do evento';
$txt['calendar_event_options'] = 'Opções do evento';
$txt['calendar_post_in'] = 'Postar em';
$txt['calendar_edit'] = 'Editar evento';
$txt['calendar_export'] = 'Exportar evento';
$txt['calendar_view_week'] = 'Ver semana';
$txt['event_delete_confirm'] = 'Excluir este evento?';
$txt['event_delete'] = 'Excluir evento';
$txt['calendar_post_event'] = 'Adicionar evento';
$txt['calendar'] = 'Calendário';
$txt['calendar_link'] = 'Link para o calendário';
$txt['calendar_upcoming'] = 'Próximas datas importantes';
$txt['calendar_today'] = 'Calendário de hoje';
$txt['calendar_week'] = 'Semana';
$txt['calendar_week_title'] = 'Semana %1$d de %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Semana começando em %2$s de %1$s, %3$s';
$txt['calendar_numb_days'] = 'Número de dias';
$txt['calendar_how_edit'] = 'como se edita estes eventos?';
$txt['calendar_link_event'] = 'Associar o evento a uma postagem';
$txt['calendar_confirm_delete'] = 'Tem certeza que quer excluir este evento?';
$txt['calendar_linked_events'] = 'Eventos associados';
$txt['calendar_click_all'] = 'clique para ver todos os %1$s';
$txt['calendar_allday'] = 'O dia inteiro';
$txt['calendar_timezone'] = 'Fuso horário';
$txt['calendar_list'] = 'Lista';
$txt['calendar_empty'] = 'Não há eventos para exibir.';

$txt['movetopic_change_subject'] = 'Mudar o título do tópico';
$txt['movetopic_new_subject'] = 'Novo título';
$txt['movetopic_change_all_subjects'] = 'Mudar o título em todas as postagens';
$txt['move_topic_unapproved_js'] = 'Atenção! Este tópico não foi aprovado ainda.\n\n Não é recomendado que você crie um tópico de redirecionamento a não ser que você pretenda aprovar o tópico imediatamente depois de movê-lo.';
$txt['movetopic_auto_board'] = '[SEÇÃO]';
$txt['movetopic_auto_topic'] = '[LINK DO TÓPICO]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Este tópico foi movido para %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Redirecionar para o tópico movido';

$txt['post_redirection'] = 'Postar um tópico de redirecionamento';
$txt['redirect_topic_expires'] = 'Remover o tópico de redirecionamento automaticamente';
$txt['mergetopic_redirect'] = 'Redirecionar para o tópico movido';
$txt['merge_topic_unapproved_js'] = 'Atenção! Este tópico não foi aprovado ainda.\n\nNão é recomendado que você crie um tópico de redirecionamento a não ser que você pretenda aprovar a postagem imediatamente depois de movê-lo.';

$txt['theme_template_error'] = 'Não foi possível carregar o modelo \'%1$s\'.';
$txt['theme_language_error'] = 'Não foi possível carregar o arquivo de idioma \'%1$s\'.';

$txt['sub_boards'] = 'Subseções';
$txt['restricted_board'] = 'Seção de acesso restrito';

$txt['smtp_no_connect'] = 'Não foi possível se conectar ao servidor SMTP';
$txt['smtp_port_ssl'] = 'Porta SMTP incorreta; a porta deve ser 465 para servidores SSL.';
$txt['smtp_bad_response'] = 'Não foi possível receber os códigos de resposta do servidor de email';
$txt['smtp_error'] = 'Ocorreram alguns problemas durante o envio de emails. Erro: ';
$txt['mail_send_unable'] = 'Não foi possível enviar o email para o endereço de email \'%1$s\'';

$txt['mlist_search'] = 'Buscar por usuários';
$txt['mlist_search_again'] = 'Procurar novamente';
$txt['mlist_search_filter'] = 'Opções de busca';
$txt['mlist_search_email'] = 'Buscar por endereços de email';
$txt['mlist_search_messenger'] = 'Buscar por apelido do messenger';
$txt['mlist_search_group'] = 'Buscar por posição';
$txt['mlist_search_name'] = 'Buscar por nome';
$txt['mlist_search_website'] = 'Buscar por site';
$txt['mlist_search_results'] = 'Resultados da busca por';
$txt['mlist_search_by'] = 'Buscar por %1$s';
$txt['mlist_menu_view'] = 'Ver a lista de membros';

$txt['attach_downloaded'] = 'baixado %1$d vez(es)';
$txt['attach_viewed'] = 'visto %1$d vez(es)';

$txt['settings'] = 'Configurações';
$txt['never'] = 'Nunca';
$txt['more'] = 'mais';
$txt['etc'] = 'etc.';

$txt['hostname'] = 'Nome do host';
$txt['you_are_post_banned'] = 'Desculpe %1$s, você foi banido de postar e enviar mensagens pessoais neste fórum.';
$txt['ban_reason'] = 'Motivo';
$txt['select_item_check'] = 'Selecione pelo menos um item na lista';

$txt['tables_optimized'] = 'As tabelas do banco de dados foram otimizadas';

$txt['add_poll'] = 'Adicionar enquete';
$txt['poll_options_limit'] = 'Você só pode selecionar até %1$s opções.';
$txt['poll_remove'] = 'Remover enquete';
$txt['poll_remove_warn'] = 'Tem certeza que quer remover esta enquete do tópico?';
$txt['poll_results_expire'] = 'Os resultados serão divulgados quando a enquete for encerrada';
$txt['poll_expires_on'] = 'Votação encerra em';
$txt['poll_expired_on'] = 'Votação encerrada';
$txt['poll_change_vote'] = 'Remover voto';
$txt['poll_return_vote'] = 'Opções de votação';
$txt['poll_cannot_see'] = 'Você não pode ver o resultado desta enquete neste momento.';

$txt['quick_mod_approve'] = 'Aprovar selecionados';
$txt['quick_mod_remove'] = 'Remover selecionados';
$txt['quick_mod_lock'] = 'Trancar/Destrancar selecionados';
$txt['quick_mod_sticky'] = 'Fixar/Desfixar selecionados';
$txt['quick_mod_move'] = 'Mover selecionados para';
$txt['quick_mod_merge'] = 'Unir selecionados';
$txt['quick_mod_markread'] = 'Marcar selecionados como lidos';
$txt['quick_mod_markunread'] = 'Marcar selecionados como não lidos';
$txt['quick_mod_selected'] = 'Com as opções selecionadas:';
$txt['quick_mod_go'] = 'Ir';
$txt['quickmod_confirm'] = 'Tem certeza?';

$txt['spell_check'] = 'Corretor ortográfico';

$txt['quick_reply'] = 'Resposta rápida';
$txt['quick_reply_warning'] = 'Aviso: este tópico está trancado!<br>
Apenas moderadores ou administradores podem postar.';
$txt['quick_reply_verification'] = 'Após enviar sua postagem, você será direcionado para a página normal de postagem para verificar sua postagem %1$s.';
$txt['quick_reply_verification_guests'] = '(Exigido para todos os visitantes)';
$txt['quick_reply_verification_posts'] = '(Exigido para todos os usuários com menos que %1$d postagens)';
$txt['wait_for_approval'] = 'Observação: Esta postagem não será mostrada enquanto não for aprovada por um moderador.';

$txt['notification_enable_board'] = 'Tem certeza que quer ativar a notificação de novos tópicos nesta seção?';
$txt['notification_disable_board'] = 'Tem certeza que quer desativar a notificação de novos tópicos nesta seção?';
$txt['notification_enable_topic'] = 'Tem certeza que quer ativar a notificação de novos posts neste tópico?';
$txt['notification_disable_topic'] = 'Tem certeza que quer desativar a notificação de novas postagens neste tópico?';

// Mentions
$txt['mentions'] = 'Menções';

// Likes
$txt['likes'] = 'Curtidas';
$txt['like'] = 'Curtir';
$txt['unlike'] = 'Descurtir';
$txt['like_success'] = 'Seu conteúdo foi curtido com sucesso.';
$txt['like_delete'] = 'Seu conteúdo foi excluído com sucesso.';
$txt['like_insert'] = 'Seu conteúdo foi inserido com sucesso.';
$txt['like_error'] = 'Houve um erro com sua solicitação.';
$txt['like_disable'] = 'As curtidas estão desativadas.';
$txt['not_valid_like_type'] = 'O tipo de curtida não é válido.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s pessoa</a> curtiu isto.';
$txt['likes_n'] = '<a href="%1$s">%2$s pessoas</a> curtiram isto.';
$txt['you_likes_0'] = 'Você curtiu isto.';
$txt['you_likes_1'] = 'Você e <a href="%1$s">%2$s outra pessa</a> curtiram isto.';
$txt['you_likes_n'] = 'Você e <a href="%1$s">%2$s outras pessoas</a> curtiram isto.';

$txt['report_to_mod'] = 'Reportar a um moderador';
$txt['report_profile'] = 'Reportar o perfil de %1$s';

$txt['unread_topics_visit'] = 'Tópicos recentes não lidos';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Nenhum tópico não lido foi encontrado desde sua última visita. <a href="%1$s?action=unread;all">Clique aqui para ver todos os tópicos não lidos</a>.';
$txt['updated_topics_visit_none'] = 'Nenhum tópico atualizado encontrado desde sua última visita.';
$txt['unread_topics_all'] = 'Todos os tópicos não lidos';
$txt['unread_replies'] = 'Tópicos atualizados';

$txt['who_title'] = 'Quem está online';
$txt['who_and'] = ' e ';
$txt['who_viewing_topic'] = ' estão vendo este tópico.';
$txt['who_viewing_board'] = ' estão vendo esta seção.';
$txt['who_member'] = 'Membro';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Desenvolvido por PHP';
$txt['powered_by_mysql'] = 'Desenvolvido por MySQL';
$txt['valid_css'] = 'CSS válido';

$txt['rss'] = 'Resposta';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Visitante';
$txt['guests'] = 'Visitantes';
$txt['user'] = 'Usuário';
$txt['users'] = 'Usuários';
$txt['hidden'] = 'Oculto';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Oculto';
$txt['buddy'] = 'Amigo';
$txt['buddies'] = 'Amigos';
$txt['most_online_ever'] = 'Maior número de usuários online';
$txt['most_online_today'] = 'Maior número de usuários online hoje';

$txt['merge_select_target_board'] = 'Selecione a seção alvo do tópico unido';
$txt['merge_select_poll'] = 'Selecione qual das enquetes o tópico unido deve ter';
$txt['merge_topic_list'] = 'Selecione os tópicos para unir';
$txt['merge_select_subject'] = 'Selecione o título do tópico unido';
$txt['merge_custom_subject'] = 'Alterar título';
$txt['merge_include_notifications'] = 'Incluir notificações?';
$txt['merge_check'] = 'Unir?';
$txt['merge_no_poll'] = 'Sem enquetes';
$txt['merge_why'] = 'Coloque uma breve descrição do porque estes tópicos foram unidos.';
$txt['merged_subject'] = '[UNIDO] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Este tópico foi unido com %2$s.';

$txt['response_prefix'] = 'Res: ';
$txt['current_icon'] = 'Ícone atual';
$txt['message_icon'] = 'Ícone de mensagem';

$txt['smileys_current'] = 'Conjunto de smiley atual';
$txt['smileys_none'] = 'Sem smileys';
$txt['smileys_forum_board_default'] = 'Padrão do fórum/seção';

$txt['search_results'] = 'Resultados da busca';
$txt['search_no_results'] = 'Desculpe, mas não foram encontrados resultados para a sua busca';

$txt['total_time_logged_days'] = ' dias, ';
$txt['total_time_logged_hours'] = ' horas e ';
$txt['total_time_logged_minutes'] = ' minutos';
$txt['total_time_logged_d'] = 'd ';
$txt['total_time_logged_h'] = 'h ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'Membros esperando aprovação';

$txt['activate_code'] = 'O seu código de ativação é';

$txt['find_members'] = 'Encontrar usuários';
$txt['find_username'] = 'Nome de usuário, apelido, ou endereço de email';
$txt['find_buddies'] = 'Mostrar apenas amigos?';
$txt['find_wildcards'] = '\'Wildcards\' permitidos: *, ?';
$txt['find_no_results'] = 'Nenhum resultado encontrado';
$txt['find_results'] = 'Resultados';
$txt['find_close'] = 'Fechar';

$txt['unread_since_visit'] = 'Ver tópicos não lidos desde a última visita.';
$txt['show_unread_replies'] = 'Ver novas respostas às minhas postagens.';

$txt['change_color'] = 'Mudar a cor';

$txt['quickmod_delete_selected'] = 'Remover selecionados';
$txt['quickmod_split_selected'] = 'Dividir selecionados';

$txt['show_personal_messages_heading'] = 'Novas mensagens';
$txt['show_personal_messages'] = 'Você tem <strong>%1$s</strong> MP(s) não lida(s).<br><br><a href="%2$s">Ir para a caixa de mensagens</a>';

$txt['help_popup'] = 'Um pouco perdido? Me deixe explicar:';

$txt['previous_next_back'] = 'tópico anterior';
$txt['previous_next_forward'] = 'próximo tópico';

$txt['mark_unread'] = 'Marcar como não lido';

$txt['ssi_not_direct'] = 'Por favor não acesse o arquivo SSI.php diretamente; você pode querer usar um caminho (%1$s) ou adicionar ?ssi_function=algumacoisa.';
$txt['ssi_session_broken'] = 'SSI.php não conseguiu carregar uma sessão! Isto pode causar problemas com logout e outras funções - por favor certifique-se que o SSI.php está incluso antes de <strong>qualquer outra coisa</strong> em todos os seus scripts!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Pré-visualizar a postagem';
$txt['preview_fetch'] = 'Carregando pré-visualização...';
$txt['preview_new'] = 'Nova mensagem';
$txt['pm_error_while_submitting'] = 'O seguinte erro ou erros ocorreram ao enviar esta mensagem pessoal:';
$txt['error_while_submitting'] = 'A mensagem tem o seguinte erro (ou erros) que precisa ser corrigido antes de continuar:';
$txt['error_old_topic'] = 'Aviso: este tópico não recebeu respostas em pelo menos %1$d dias.<br> A não ser que tenha certeza que quer responder, considere abrir um novo tópico.';

$txt['split_selected_posts'] = 'Postagens selecionadas';
$txt['split_selected_posts_desc'] = 'As postagens abaixo irão formar um novo tópico depois da divisão.';
$txt['split_reset_selection'] = 'resetar seleção';

$txt['modify_cancel'] = 'Cancelar';
$txt['modify_cancel_all'] = 'Cancelar tudo';
$txt['mark_read_short'] = 'Marcar como lido';

$txt['alerts'] = 'Alertas';

$txt['pm_short'] = 'Minhas mensagens';
$txt['pm_menu_read'] = 'Ler suas mensagens';
$txt['pm_menu_send'] = 'Enviar mensagem';

$txt['unapproved_posts'] = 'Postagens não aprovadas (Tópicos: %1$d, Postagens: %2$d)';

$txt['ajax_in_progress'] = 'Carregando...';

$txt['mod_reports_waiting'] = 'Postagens denunciadas';

$txt['view_unread_category'] = 'Postagens não lidas';
$txt['new_posts_in_category'] = 'Clique para ver os novas postagens em %1$s';
$txt['verification'] = 'Verificação';
$txt['visual_verification_hidden'] = 'Por favor, deixe esta caixa vazia';
$txt['visual_verification_description'] = 'Escreva as letras mostradas na imagem';
$txt['visual_verification_sound'] = 'Escutar as letras';
$txt['visual_verification_request_new'] = 'Pedir uma nova imagem';

// Sub menu labels
$txt['summary'] = 'Resumo';
$txt['account'] = 'Configurações da conta';
$txt['theme'] = 'Aparência';
$txt['forumprofile'] = 'Perfil no fórum';
$txt['activate_changed_email_title'] = 'Endereço de email alterado!';
$txt['activate_changed_email_desc'] = 'Você alterou seu email. Para validar este endereço, você irá receber um email. Clique no link desse email para reativar sua conta.';
$txt['modSettings_title'] = 'Funcionalidades e Opções';
$txt['package'] = 'Gerenciador de Pacotes';
$txt['errorlog'] = 'Log de erros';
$txt['edit_permissions'] = 'Permissões';
$txt['mc_unapproved_attachments'] = 'Anexos não aprovados';
$txt['mc_unapproved_poststopics'] = 'Postagens e tópicos não aprovados';
$txt['mc_reported_posts'] = 'Postagens denunciadas';
$txt['mc_reported_members'] = 'Usuários denunciados';
$txt['modlog_view'] = 'Log de Moderação';
$txt['calendar_menu'] = 'Ver calendário';

// @todo Send email strings - should move?
$txt['send_email'] = 'Enviar email';

$txt['ignoring_user'] = 'Você está ignorando este usuário.';
$txt['show_ignore_user_post'] = 'Mostrar a postagem.';

$txt['spider'] = 'Mecanismo de pesquisa';
$txt['spiders'] = 'Mecanismos de pesquisa';

$txt['downloads'] = 'Transferências';
$txt['filesize'] = 'Tamanho do anexo';

// Restore topic
$txt['restore_topic'] = 'Restaurar tópico';
$txt['restore_message'] = 'Restaurar';
$txt['quick_mod_restore'] = 'Restaurar selecionados';

// Editor prompt.
$txt['prompt_text_email'] = 'Por favor, insira o endereço de email.';
$txt['prompt_text_ftp'] = 'Por favor, insira o endereço de FTP.';
$txt['prompt_text_url'] = 'Por favor, insira a URL ao qual deseja vincular.';
$txt['prompt_text_img'] = 'Insira a localização da imagem';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Apagar item';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Temas: ';
$txt['debug_subtemplates'] = 'Submodelos: ';
$txt['debug_language_files'] = 'Arquivos de idioma:';
$txt['debug_stylesheets'] = 'Folhas de estilo: ';
$txt['debug_files_included'] = 'Arquivos incluídos:';
$txt['debug_memory_use'] = 'Memória usada: ';
$txt['debug_kb'] = 'KB.';
$txt['debug_show'] = 'mostrar';
$txt['debug_cache_hits'] = 'Acessos de cache: ';
$txt['debug_cache_misses'] = 'Falhas de cache: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss para %2$s bytes ';
$txt['debug_queries_used'] = 'Consultas usadas: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Consultas usadas: %1$d, %2$d avisos.';
$txt['debug_query_in_line'] = 'na linha <em>%1$s</em> <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'que levou %1$s segundos';
$txt['debug_query_which_took_at'] = 'que levou %1$s segundos em %2$s requests.';
$txt['debug_show_queries'] = '[Mostrar consultas]';
$txt['debug_hide_queries'] = '[Mostrar consultas]';
$txt['debug_tokens'] = 'Tokens: ';
$txt['debug_browser'] = 'ID do navegador: ';
$txt['debug_hooks'] = 'Hooks chamados: ';
$txt['debug_instances'] = 'Instâncias criadas: ';
$txt['are_sure_mark_read'] = 'Tem certeza que quer marcar as mensagens como lidas?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Anexos estão desabilitados';
$txt['attachments_no_data_loaded'] = 'ID de anexo inválido.';
$txt['attachments_not_allowed_to_see'] = 'Você não pode ver este anexo.';
$txt['attachments_no_msg_associated'] = 'Nenhuma mensagem está associada a este anexo.';
$txt['attachments_unapproved'] = 'O anexo aguarda aprovação.';

// Accessibility
$txt['hide_category'] = 'Ocultar categoria';
$txt['show_category'] = 'Mostrar categoria';
$txt['hide_infocenter'] = 'Ocultar o centro de informações';
$txt['show_infocenter'] = 'Exibir o centro de informações';

// Notification post control
$txt['notify_topic_0'] = 'Não acompanhado';
$txt['notify_topic_1'] = 'Nenhum alerta ou e-mail';
$txt['notify_topic_2'] = 'Receber alertas';
$txt['notify_topic_3'] = 'Receber alertas e e-mails';
$txt['notify_topic_0_desc'] = 'Você não irá receber nenhum alerta ou email para esta postagem e ele também não irá aparecer na sua lista de tópicos e postagens não lidas. Você ainda irá receber @menções para este tópico.';
$txt['notify_topic_1_desc'] = 'Você não irá receber nenhum alerta ou email, somente @menções de outros membros.';
$txt['notify_topic_2_desc'] = 'Você irá receber alertas para este tópico.';
$txt['notify_topic_3_desc'] = 'Você irá receber alertas e emails para este tópico.';
$txt['notify_board_1'] = 'Nenhum alerta ou e-mails';
$txt['notify_board_2'] = 'Receber alertas';
$txt['notify_board_3'] = 'Receber alertas e e-mails';
$txt['notify_board_1_desc'] = 'Você não irá receber nenhum alerta ou email para novos tópicos.';
$txt['notify_board_2_desc'] = 'Você irá receber alertas para esta seção.';
$txt['notify_board_3_desc'] = 'Você irá receber alertas e emails para esta seção.';

$txt['notify_board_prompt'] = 'Deseja receber um email de notificação quando alguém postar um novo tópico nesta seção?';
$txt['notify_board_subscribed'] = '%1$s se inscreveu para receber notificações de novos tópicos neste fórum.';
$txt['notify_board_unsubscribed'] = '%1$s removeu a inscrição das notificações de novos tópicos deste fórum.';

$txt['notify_topic_prompt'] = 'Quer receber um email de notificação se alguém responder a este tópico?';
$txt['notify_topic_subscribed'] = '%1$s inscreveu-se para receber novas notificações de resposta para este tópico.';
$txt['notify_topic_unsubscribed'] = '%1$s removeu a inscrição para novas notificações de resposta para este tópico.';

$txt['notify_announcements_prompt'] = 'Quer receber boletins informativos do fórum, anúncios e notificações importantes por e-mail?';
$txt['notify_announcements_subscribed'] = '%1$s assinou boletins informativos, anúncios e notificações importantes do fórum.';
$txt['notify_announcements_unsubscribed'] = '%1$s removeu a inscrição de boletins informativos, anúncios e notificações importantes do fórum.';

$txt['unsubscribe_announcements_plain'] = 'Para remover a inscrição de boletins informativos, anúncios e notificações importantes do fórum, siga este link: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Remover inscrição</a> de boletins informativos, anúncios e notificações importantes do fórum.</span>';
$txt['unsubscribe_announcements_manual'] = 'Para remover a inscrição de boletins informativos, anúncios e notificações importantes do fórum, contate-nos em %1$s com sua solicitação.';

// Mobile Actions
$txt['mobile_action'] = 'Ações';
$txt['mobile_moderation'] = 'Moderação';
$txt['mobile_user_menu'] = 'Menu principal';
$txt['mobile_generic_menu'] = 'Menu %1$s';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1}, e {-1}';
$txt['sentence_list_format'][3] = '{series}, e {-1}';
$txt['sentence_list_format'][4] = '{series}, e {-1}';
$txt['sentence_list_format'][5] = '{series}, e {-1}';
$txt['sentence_list_format']['n'] = '{series}, e {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>