<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Σας ευχαριστούμε για την εγγραφή σας στο {FORUMNAME}. Το όνομα χρήστη σας είναι {USERNAME}. Εάν ξεχάσετε τον κωδικό πρόσβασής σας, μπορείτε να τον επαναφέρετε μεταβαίνοντας στο {FORGOTPASSWORDLINK}.

Για να μπορέσετε να συνδεθείτε, πρέπει πρώτα να ενεργοποιήσετε τον λογαριασμό σας επιλέγοντας τον παρακάτω σύνδεσμο:

{ACTIVATIONLINK}

Εάν αντιμετωπίζετε προβλήματα με την ενεργοποίηση, επισκεφτείτε τη διεύθυνση {ACTIVATIONLINKWITHOUTCODE} και εισαγάγετε τον κωδικό "{ACTIVATIONCODE}".

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Γεια σας {REALNAME}, το αίτημα εγγραφής σας στο {FORUMNAME} έχει ληφθεί.

Το όνομα χρήστη με το οποίο εγγραφήκατε ήταν {USERNAME}.

Προτού μπορέσετε να συνδεθείτε και να αρχίσετε να χρησιμοποιείτε το φόρουμ, το αίτημά σας θα εξεταστεί και θα εγκριθεί.

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Έγκριση μέλους ομάδας';
$txt['mc_group_approve_body'] = '{USERNAME},

We\'re pleased to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been accepted, and your account has been updated to include this new membergroup.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Απόρριψη μέλους ομάδας';
$txt['mc_group_reject_body'] = '{USERNAME},

We\'re sorry to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been rejected.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Απόρριψη μέλους ομάδας';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

We\'re sorry to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been rejected.

This is due to the following reason: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Καλώς ορίσατε, {NAME}

Ο λογαριασμός σας έχει ενεργοποιηθεί με μη αυτόματο τρόπο από τον διαχειριστή και τώρα μπορείτε να συνδεθείτε και να δημοσιεύσετε. Το όνομα χρήστη σας είναι: {USERNAME}. Εάν ξεχάσετε τον κωδικό πρόσβασής σας, μπορείτε να τον αλλάξετε στο {FORGOTPASSWORDLINK}.

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Καλώς ορίσατε, {USERNAME}!

Ο λογαριασμός σας στο {FORUMNAME} έχει εγκριθεί από τον διαχειριστή του φόρουμ. Για να μπορέσετε να συνδεθείτε, πρέπει πρώτα να ενεργοποιήσετε τον λογαριασμό σας επιλέγοντας τον παρακάτω σύνδεσμο:

{ACTIVATIONLINK}

Εάν αντιμετωπίζετε προβλήματα με την ενεργοποίηση, επισκεφτείτε τη διεύθυνση {ACTIVATIONLINKWITHOUTCODE} και εισαγάγετε τον κωδικό "{ACTIVATIONCODE}".

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Η εγγραφή απορρίφθηκε';
$txt['admin_approve_reject_body'] = '{USERNAME},

Regrettably, your application to join {FORUMNAME} has been rejected.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Ο λογαριασμός διαγράφηκε';
$txt['admin_approve_delete_body'] = '{USERNAME},

Your account on {FORUMNAME} has been deleted. This may be because you never activated your account, in which case you should be able to register again.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Υπενθύμιση εγγραφής';
$txt['admin_approve_remind_body'] = '{USERNAME},
You still have not activated your account at {FORUMNAME}.

Please use the link below to activate your account:
{ACTIVATIONLINK}

Should you have any problems with the activation, please visit {ACTIVATIONLINKWITHOUTCODE} and enter the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Σας ευχαριστούμε για την εγγραφή σας στο {FORUMNAME}. Το όνομα χρήστη σας είναι {USERNAME} και ο κωδικός πρόσβασής σας είναι {PASSWORD}.

Για να μπορέσετε να συνδεθείτε, πρέπει πρώτα να ενεργοποιήσετε τον λογαριασμό σας επιλέγοντας τον παρακάτω σύνδεσμο:

{ACTIVATIONLINK}

Εάν αντιμετωπίζετε προβλήματα με την ενεργοποίηση, επισκεφτείτε τη διεύθυνση {ACTIVATIONLINKWITHOUTCODE} και εισαγάγετε τον κωδικό "{ACTIVATIONCODE}".

{ΜΕ ΕΚΤΊΜΗΣΗ}';

$txt['admin_register_immediate_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Σας ευχαριστούμε για την εγγραφή σας στο {FORUMNAME}. Το όνομα χρήστη σας είναι {USERNAME}, ο κωδικός πρόσβασής σας είναι {PASSWORD} και η διεύθυνση URL του φόρουμ είναι: {SCRIPTURL}.

{ΜΕ ΕΚΤΊΜΗΣΗ}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Νέα ανακοίνωση: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{ΜΗΝΥΜΑ}

Μπορείτε να δείτε ολόκληρη την ανακοίνωση ακολουθώντας τον παρακάτω σύνδεσμο:
{TOPICLINK}

Για να διαγραφείτε από αυτές τις ανακοινώσεις, ακολουθήστε αυτόν τον σύνδεσμο:
{UNSUBSCRIBELINK}

Για περισσότερο έλεγχο στις ειδοποιήσεις email που λαμβάνετε, συνδεθείτε στο φόρουμ και μεταβείτε στην περιοχή Ειδοποιήσεις στο προφίλ σας.

{ΜΕ ΕΚΤΊΜΗΣΗ}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Νέο θέμα: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Ένα νέο θέμα, "{TOPICSUBJECT}", δημιουργήθηκε σε έναν πίνακα που παρακολουθείτε.

Μπορείτε να το δείτε στο
{TOPICLINK}

Μπορεί να αναρτηθούν περισσότερα θέματα, αλλά δεν θα λαμβάνετε περισσότερες ειδοποιήσεις μέσω email για αυτόν τον πίνακα μέχρι να επιστρέψετε στον πίνακα και να διαβάσετε μερικά από αυτά.

Το κείμενο του θέματος φαίνεται παρακάτω:
{ΜΗΝΥΜΑ}

Καταργήστε την εγγραφή σας από νέα θέματα από αυτόν τον πίνακα χρησιμοποιώντας αυτόν τον σύνδεσμο:
{UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Νέο θέμα: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Ένα νέο θέμα, "{TOPICSUBJECT}", δημιουργήθηκε σε έναν πίνακα που παρακολουθείτε.

Μπορείτε να το δείτε στο
{TOPICLINK}

Μπορεί να αναρτηθούν περισσότερα θέματα, αλλά δεν θα λαμβάνετε περισσότερες ειδοποιήσεις μέσω email για αυτόν τον πίνακα μέχρι να επιστρέψετε στον πίνακα και να διαβάσετε μερικά από αυτά.

Καταργήστε την εγγραφή σας από νέα θέματα από αυτόν τον πίνακα χρησιμοποιώντας αυτόν τον σύνδεσμο:
{UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Νέο θέμα: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Ένα νέο θέμα, "{TOPICSUBJECT}", δημιουργήθηκε σε έναν πίνακα που παρακολουθείτε.

Μπορείτε να το δείτε στο
{TOPICLINK}

Το κείμενο του θέματος φαίνεται παρακάτω:
{ΜΗΝΥΜΑ}

Καταργήστε την εγγραφή σας από νέα θέματα από αυτόν τον πίνακα χρησιμοποιώντας αυτόν τον σύνδεσμο:
{UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Νέο θέμα: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Ένα νέο θέμα, "{TOPICSUBJECT}", δημιουργήθηκε σε έναν πίνακα που παρακολουθείτε.

Μπορείτε να το δείτε στο
{TOPICLINK}

Καταργήστε την εγγραφή σας από νέα θέματα από αυτόν τον πίνακα χρησιμοποιώντας αυτόν τον σύνδεσμο:
{UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Απάντηση θέματος: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Δημοσιεύτηκε μια απάντηση στο "{SUBJECT}" από τον χρήστη {POSTERNAME}.

Μπορείτε να το δείτε στο
{ΣΥΝΔΕΣΜΟΣ}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Νέο μη εγκεκριμένο συνημμένο σε: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'A new attachment has been made in \'{SUBJECT}\' which needs to be approved.

You can approve or reject this attachment from the link below which will take you to the message that it is a part of.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Νέα μη εγκεκριμένη ανάρτηση: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'A new post has been made which needs to be approved: \'{SUBJECT}\'

You can approve or reject this post by using the link below:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Νέο μη εγκεκριμένο θέμα: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'A new topic has been made which needs to be approved: \'{SUBJECT}\'

You can approve or reject this topic by using the link below:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Νέα ομάδα εφαρμογών';
$txt['request_membership_body'] = '{RECPNAME},

Η εφαρμογή {APPLYNAME} ζήτησε συμμετοχή στην ομάδα "{GROUPNAME}". Ο χρήστης έδωσε τον ακόλουθο λόγο:

{REASON}

Μπορείτε να εγκρίνετε ή να απορρίψετε αυτήν την αίτηση χρησιμοποιώντας τον παρακάτω σύνδεσμο:

{MODLINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Η συνδρομή πρόκειται να λήξει στο {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Η συνδρομή σας στο {FORUMNAME} πρόκειται να λήξει. Εάν έχετε επιλέξει την αυτόματη ανανέωση, δεν χρειάζεται να προβείτε σε ενέργειες. Διαφορετικά, ίσως θελήσετε να σκεφτείτε να εγγραφείτε ξανά. Λεπτομέρειες είναι παρακάτω:

Όνομα συνδρομής: {SUBSCRIPTION}
Λήγει: {END_DATE}

Για να επεξεργαστείτε τις συνδρομές σας, επισκεφτείτε την ακόλουθη διεύθυνση URL:
{PROFILE_LINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Καλώς επιστρέψατε στο {FORUMNAME}';
$txt['activate_reactivate_body'] = 'In order to re-validate your email address, your account has been deactivated. Click the following link to activate it again:
{ACTIVATIONLINK}

Should you have any problems with activation, please visit {ACTIVATIONLINKWITHOUTCODE} and use the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Νέος κωδικός πρόσβασης για {FORUMNAME}';
$txt['forgot_password_body'] = 'Dear {REALNAME},
This mail was sent because the \'forgot password\' function has been applied to your account. To set a new password, click the following link:
{REMINDLINK}

IP: {IP}
Username: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Αναφέρθηκε ανάρτηση: {TOPICSUBJECT} από {POSTERNAME}';
$txt['report_to_moderator_body'] = 'The following post, "{TOPICSUBJECT}" by {POSTERNAME} has been reported by {REPORTERNAME} on a board you moderate:

The topic: {TOPICLINK}
Moderation center: {REPORTLINK}

The reporter has made the following comment:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Συνέχεια στην αναφερόμενη ανάρτηση: {TOPICSUBJECT} από {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Προηγουμένως, το "{TOPICSUBJECT}" αναφέρθηκε στους επόπτες.

Έκτοτε, ο χρήστης {COMMENTERNAME} πρόσθεσε ένα σχόλιο στην αναφορά. Περισσότερες πληροφορίες μπορείτε να βρείτε στο φόρουμ.

Το θέμα: {TOPICLINK}
Κέντρο συντονισμού: {REPORTLINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Αναφερόμενο προφίλ: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'The profile of "{MEMBERNAME}" has been reported by {REPORTERNAME}.

The profile: {PROFILELINK}
Moderation center: {REPORTLINK}

The reporter has made the following comment:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Συνέχεια στο αναφερόμενο προφίλ: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Previously, the profile of {MEMBERNAME} was reported.

Since then, {COMMENTERNAME} has added a comment to the report. More information can be found in the forum.

The profile: {PROFILELINK}
Moderation center: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Στοιχεία νέου κωδικού πρόσβασης';
$txt['change_password_body'] = 'Αγαπητέ {USERNAME},

Τα στοιχεία σύνδεσής σας στο {FORUMNAME} έχουν αλλάξει και ο κωδικός πρόσβασής σας επαναφέρεται. Παρακάτω είναι τα νέα στοιχεία σύνδεσής σας.

Το όνομα χρήστη σας είναι "{USERNAME}" και ο κωδικός πρόσβασής σας είναι "{PASSWORD}".

Μπορείτε να το αλλάξετε αφού συνδεθείτε μεταβαίνοντας στη σελίδα προφίλ ή επισκεπτόμενοι αυτήν τη σελίδα αφού συνδεθείτε:
{SCRIPTURL}?action=profile

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['register_activate_body'] = 'Σας ευχαριστούμε για την εγγραφή σας στο {FORUMNAME}. Το όνομα χρήστη σας είναι {USERNAME}. Εάν ξεχάσετε τον κωδικό πρόσβασής σας, μπορείτε να τον επαναφέρετε μεταβαίνοντας στο {FORGOTPASSWORDLINK}.

Για να μπορέσετε να συνδεθείτε, πρέπει πρώτα να ενεργοποιήσετε τον λογαριασμό σας. Για να το κάνετε αυτό, ακολουθήστε αυτόν τον σύνδεσμο:

{ACTIVATIONLINK}

Εάν αντιμετωπίζετε προβλήματα με την ενεργοποίηση, επισκεφτείτε τη διεύθυνση {ACTIVATIONLINKWITHOUTCODE} και χρησιμοποιήστε τον κωδικό "{ACTIVATIONCODE}".

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['register_coppa_body'] = 'Σας ευχαριστούμε για την εγγραφή σας στο {FORUMNAME}. Το όνομα χρήστη σας είναι {USERNAME}. Εάν ξεχάσετε τον κωδικό πρόσβασής σας, μπορείτε να τον αλλάξετε στο {FORGOTPASSWORDLINK}

Για να μπορέσετε να συνδεθείτε, ο διαχειριστής απαιτεί τη συγκατάθεση του γονέα/κηδεμόνα σας για να γίνετε μέλος της κοινότητας. Μπορείτε να λάβετε περισσότερες πληροφορίες στον παρακάτω σύνδεσμο:

{COPPALINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['register_immediate_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you may change it at {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Καλώς ήρθατε στο {FORUMNAME}';
$txt['register_pending_body'] = 'Γεια σας {REALNAME}, το αίτημα εγγραφής σας στο {FORUMNAME} έχει ληφθεί.

Το όνομα χρήστη με το οποίο θέλετε να εγγραφείτε ήταν {USERNAME}. Εάν ξεχάσετε τον κωδικό πρόσβασής σας, μπορείτε να τον αλλάξετε στο {FORGOTPASSWORDLINK}.

Προτού μπορέσετε να συνδεθείτε και να αρχίσετε να χρησιμοποιείτε το φόρουμ, το αίτημά σας θα εξεταστεί και θα εγκριθεί.

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Απάντηση θέματος: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Σε ένα θέμα που παρακολουθείτε, έχει αναρτηθεί μια απάντηση από τον χρήστη {POSTERNAME}.

Δείτε την απάντηση στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Απάντηση θέματος: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Σε ένα θέμα που παρακολουθείτε, έχει αναρτηθεί μια απάντηση από τον χρήστη {POSTERNAME}.

Δείτε την απάντηση στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

Το κείμενο της απάντησης φαίνεται παρακάτω:
{ΜΗΝΥΜΑ}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Απάντηση θέματος: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Σε ένα θέμα που παρακολουθείτε, έχει αναρτηθεί μια απάντηση από τον χρήστη {POSTERNAME}.

Δείτε την απάντηση στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

Μπορεί να αναρτηθούν περισσότερες απαντήσεις, αλλά δεν θα λαμβάνετε άλλες ειδοποιήσεις για αυτό το θέμα μέχρι να το επισκεφτείτε.

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Απάντηση θέματος: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Σε ένα θέμα που παρακολουθείτε, έχει αναρτηθεί μια απάντηση από τον χρήστη {POSTERNAME}.

Δείτε την απάντηση στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

Το κείμενο της απάντησης φαίνεται παρακάτω:
{ΜΗΝΥΜΑ}

Μπορεί να αναρτηθούν περισσότερες απαντήσεις, αλλά δεν θα λαμβάνετε άλλες ειδοποιήσεις για αυτό το θέμα μέχρι να το επισκεφτείτε.

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Το θέμα έγινε μόνιμο: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Ένα θέμα που παρακολουθείτε έχει επισημανθεί ως μόνιμο θέμα.

Δείτε το θέμα στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Το θέμα κλειδώθηκε: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Ένα θέμα που παρακολουθείτε έχει κλειδωθεί.

Δείτε το θέμα στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Ξεκλειδώθηκε το θέμα: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Ένα θέμα που παρακολουθείτε ξεκλειδώθηκε.

Δείτε το θέμα στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Το θέμα καταργήθηκε: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'A topic you are watching has been removed.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Το θέμα μετακινήθηκε: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Ένα θέμα που παρακολουθείτε έχει μετακινηθεί σε άλλο πίνακα.

Δείτε το θέμα στο: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Το θέμα συγχωνεύτηκε: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Ένα θέμα που παρακολουθείτε έχει συγχωνευθεί με ένα άλλο θέμα.

Δείτε το νέο συγχωνευμένο θέμα στη διεύθυνση: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Διαίρεση θέματος: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Ένα θέμα που παρακολουθείτε έχει χωριστεί σε δύο ή περισσότερα θέματα.

Δείτε τι απομένει από αυτό το θέμα στη διεύθυνση: {TOPICLINK}

Καταργήστε την εγγραφή σας από αυτό το θέμα χρησιμοποιώντας αυτόν τον σύνδεσμο: {UNSUBSCRIBELINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Έγινε εγγραφή ενός νέου μέλους';
$txt['admin_notify_body'] = '{USERNAME} has just signed up as a new member of your forum. Click the link below to view their profile.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Έγινε εγγραφή ενός νέου μέλους';
$txt['admin_notify_approval_body'] = '{USERNAME} has just signed up as a new member of your forum. Click the link below to view their profile.
{PROFILELINK}

Before this member can begin posting they must first have their account approved. Click the link below to go to the approval screen.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Επείγων! Ο κατάλογος συνημμένων είναι σχεδόν γεμάτος';
$txt['admin_attachments_full_body'] = '{REALNAME},

Ο κατάλογος συνημμένων στο {FORUMNAME} είναι σχεδόν γεμάτος. Επισκεφτείτε το φόρουμ για να επιλύσετε αυτό το πρόβλημα.

Μόλις ο κατάλογος συνημμένων φτάσει στο μέγιστο επιτρεπόμενο μέγεθος, οι χρήστες δεν θα μπορούν να συνεχίσουν να δημοσιεύουν συνημμένα ή να ανεβάζουν προσαρμοσμένα avatar (αν είναι ενεργοποιημένα).

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Επιστροφή χρημάτων από πληρωμή συνδρομής';
$txt['paid_subscription_refund_body'] = '{REALNAME},

A member has received a refund on a paid subscription. Below are the details of this subscription:

	Subscription: {NAME}
	User Name: {REFUNDNAME} ({REFUNDUSER})
	Date: {DATE}

You can view this member\'s profile by clicking the link below:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Νέα συνδρομή επί πληρωμή';
$txt['paid_subscription_new_body'] = '{REALNAME},

A member has taken out a new paid subscription. Below are the details of this subscription:

	Subscription: {NAME}
	User Name: {SUBNAME} ({SUBUSER})
	User Email: {SUBEMAIL}
	Price: {PRICE}
	Date: {DATE}

You can view this member\'s profile by clicking the link below:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Παρουσιάστηκε σφάλμα σε συνδρομή επί πληρωμή';
$txt['paid_subscription_error_body'] = 'Dear {REALNAME},

The following error occurred when processing a paid subscription
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Νέο προσωπικό μήνυμα: {SUBJECT}';
$txt['new_pm_body'] = 'Μόλις σας εστάλη ένα προσωπικό μήνυμα από τον χρήστη {SENDER} στο {FORUMNAME}.

ΣΗΜΑΝΤΙΚΟ: Θυμηθείτε, αυτή είναι απλώς μια ειδοποίηση. Παρακαλώ μην απαντήσετε σε αυτό το μήνυμα ηλεκτρονικού ταχυδρομείου.

Διαβάστε αυτό το Προσωπικό Μήνυμα εδώ: {READLINK}

Απαντήστε σε αυτό το προσωπικό μήνυμα εδώ: {REPLYLINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Νέο προσωπικό μήνυμα: {SUBJECT}';
$txt['new_pm_body_body'] = 'Μόλις σας εστάλη ένα προσωπικό μήνυμα από τον χρήστη {SENDER} στο {FORUMNAME}.

ΣΗΜΑΝΤΙΚΟ: Θυμηθείτε, αυτή είναι απλώς μια ειδοποίηση. Παρακαλώ μην απαντήσετε σε αυτό το μήνυμα ηλεκτρονικού ταχυδρομείου.

Το μήνυμα που σου έστειλαν ήταν:

{MESSAGE}

Απαντήστε σε αυτό το προσωπικό μήνυμα εδώ: {REPLYLINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Νέο προσωπικό μήνυμα: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Μόλις εστάλη σε εσάς και τον {TOLIST} ένα προσωπικό μήνυμα από τον χρήστη {SENDER} στο {FORUMNAME}.

ΣΗΜΑΝΤΙΚΟ: Θυμηθείτε, αυτή είναι απλώς μια ειδοποίηση. Παρακαλώ μην απαντήσετε σε αυτό το μήνυμα ηλεκτρονικού ταχυδρομείου.

Διαβάστε αυτό το Προσωπικό Μήνυμα εδώ: {READLINK}

Απαντήστε σε αυτό το Προσωπικό Μήνυμα (μόνο στον αποστολέα) εδώ: {REPLYLINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Νέο προσωπικό μήνυμα: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Μόλις εστάλη σε εσάς και τον {TOLIST} ένα προσωπικό μήνυμα από τον χρήστη {SENDER} στο {FORUMNAME}.

ΣΗΜΑΝΤΙΚΟ: Θυμηθείτε, αυτή είναι απλώς μια ειδοποίηση. Παρακαλώ μην απαντήσετε σε αυτό το μήνυμα ηλεκτρονικού ταχυδρομείου.

Το μήνυμα που σου έστειλαν ήταν:

{MESSAGE}

Απαντήστε σε αυτό το Προσωπικό Μήνυμα (μόνο στον αποστολέα) εδώ: {REPLYLINK}

{ΜΕ ΕΚΤΙΜΗΣΗ}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Έχετε αναφερθεί στην παρατηθέμενη ανάρτηση: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hello {MEMBERNAME},

You have been quoted in the post titled "{CONTENTSUBJECT}" by {QUOTENAME}, you can see the post here:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Έχετε αναφερθεί στην ανάρτηση: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Hello {MEMBERNAME},

You have been mentioned in the post titled "{CONTENTSUBJECT}" by {MENTIONNAME}, you can see the post here:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Ευτυχισμένα Γενέθλια από το {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Dear {REALNAME},

We here at {FORUMNAME} would like to wish you a happy birthday. May this day and the year to follow be full of joy.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'Στα γενέθλια σου...';
$txtBirthdayEmails['karlbenson1_body'] = 'Θα μπορούσαμε να σας είχαμε στείλει μια κάρτα γενεθλίων. Θα μπορούσαμε να σας στείλουμε μερικά λουλούδια ή μία τούρτα.

Αλλά δεν το κάναμε.

Θα μπορούσαμε ακόμη και να σας είχαμε στείλει ένα από αυτά τα μηνύματα που δημιουργούνται αυτόματα για να σας ευχηθούμε χρόνια πολλά, όπου δεν χρειάζεται καν να αντικαταστήσουμε το εισαγώμενο όνομα.

Αλλά δεν το κάναμε.

Γράψαμε αυτόν τον χαιρετισμό γενεθλίων μόνο για εσάς.

Θα θέλαμε να σας ευχηθούμε να έχετε πολύ ξεχωριστά γενέθλια.

{ΜΕ ΕΚΤΙΜΗΣΗ}

//:: Αυτό το μήνυμα δημιουργήθηκε αυτόματα :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Χαρούμενα γενέθλια!';
$txtBirthdayEmails['nite0859_body'] = 'Your friends at {FORUMNAME} would like to take a moment of your time to wish you a happy birthday, {REALNAME}. If you have not done so recently, please visit our community in order for others to have the opportunity to pass along their warm regards.

Even though today is your birthday, {REALNAME}, we would like to remind you that your membership in our community has been the best gift to us thus far.

Best Wishes,
The Staff of {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Ευχές γενεθλίων σου {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Dear {REALNAME},

Another year in your life has passed. We at {FORUMNAME} hope it has been filled with happiness, and wish you luck in the coming one.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Χρόνια πολλά, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Do you know who\'s having a birthday today, {REALNAME}?

We know... YOU!

Happy birthday!

You\'re now a year older but we hope you\'re a lot happier than last year.

Enjoy your day today, {REALNAME}!

- From your {FORUMNAME} family';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Οι ευχές των γενεθλίων σας';
$txtBirthdayEmails['karlbenson2_body'] = 'Ελπίζουμε τα γενέθλιά σας να είναι τα καλύτερα. Με συννεφιά, ηλιοφάνεια ή οποιοσδήποτε καιρό.
Να έχετε μία γλυκιά τούρτα γενεθλίων με πολύ διασκέδαση, και μην ξεχάσετε να μας πείτε, πως τα περάσατε.

Ελπίζουμε αυτό το μήνυμα να σας χαροποιήσει και να κάνει τα γενέθλιά σας να διαρκέσουν, μέχρι την ίδια ώρα, το επόμενο έτος.

{ΜΕ ΕΚΤΙΜΗΣΗ}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>