<?php

/*
 * This file is part of the tmilos/scim-schema package.
 *
 * (c) Milos Tomic <tmilos@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace Tmilos\ScimSchema\Builder;

use Tmilos\ScimSchema\Model\v2\Schema;
use Tmilos\ScimSchema\ScimConstants;
use Tmilos\ScimSchema\ScimConstantsV2;

class SchemaBuilderV2 extends SchemaBuilder
{
    protected static $schemas = array(
        ScimConstantsV2::SCHEMA_SCHEMA => array(
            'schemas' => array(
                'urn:ietf:params:scim:schemas:core:2.0:Schema',
            ),
            'id' => 'urn:ietf:params:scim:schemas:core:2.0:Schema',
            'name' => 'Schema',
            'description' => 'Specifies the schema that describes a SCIM schema.',
            'attributes' => array(
                array(
                    'name' => 'name',
                    'description' => 'The schema\'s human-readable name. When applicable, service providers MUST specify the name, e.g., \'User\'.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'description',
                    'description' => 'The schema\'s human-readable description. When applicable, service providers MUST specify the description.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'attributes',
                    'description' => 'A complex attribute that includes the attributes of a schema.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'name',
                            'description' => 'The attribute\'s name.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'The attribute\'s data type. Valid values include \'string\', \'complex\', \'boolean\', \'decimal\', \'integer\', \'dateTime\', \'reference\', \'binary\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'string',
                                'complex',
                                'boolean',
                                'decimal',
                                'integer',
                                'dateTime',
                                'reference',
                                'binary',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'description',
                            'description' => 'A human-readable description of the attribute.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'multiValued',
                            'description' => 'A Boolean value indicating an attribute\'s plurality.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'required',
                            'description' => 'A Boolean value indicating whether or not the attribute is required.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'canonicalValues',
                            'description' => "A collection of canonical values. When applicable, service providers MUST specify the canonical types, e.g., 'work', 'home'.",
                            'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                            'multiValued' => true,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'caseExact',
                            'description' => 'A Boolean value indicating whether or not a string attribute is case sensitive.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'mutability',
                            'description' => 'Indicates whether or not an attribute is modifiable.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'readOnly',
                                'readWrite',
                                'immutable',
                                'writeOnly',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'returned',
                            'description' => 'Indicates when an attribute is returned in a response (e.g., to a query).',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'always',
                                'never',
                                'default',
                                'request',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'uniqueness',
                            'description' => 'Indicates how unique a value must be.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'none',
                                'server',
                                'global',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'referenceTypes',
                            'description' => "Used only with an attribute of type 'reference'. Specifies a SCIM resourceType that a reference attribute MAY refer to, e.g., 'User'.",
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'scim',
                                'external',
                                'uri',
                                'User',
                                'Group',
                            ),
                            'caseExact' => false,
                            'multiValued' => true,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'subAttributes',
                            'description' => 'Used to define the sub-attributes of a complex attribute.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                            'multiValued' => true,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                            'subAttributes' => array(
                                array(
                                    'name' => 'name',
                                    'description' => 'The attribute\'s name.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                                    'caseExact' => true,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => true,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'type',
                                    'description' => 'The attribute\'s data type. Valid values include \'string\', \'complex\', \'boolean\', \'decimal\', \'integer\', \'dateTime\', \'reference\', \'binary\'.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                                    'canonicalValues' => array(
                                        'string',
                                        'complex',
                                        'boolean',
                                        'decimal',
                                        'integer',
                                        'dateTime',
                                        'reference',
                                        'binary',
                                    ),
                                    'caseExact' => false,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => true,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'description',
                                    'description' => 'A human-readable description of the attribute.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                                    'caseExact' => false,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => false,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'multiValued',
                                    'description' => 'A Boolean value indicating an attribute\'s plurality.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => true,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'required',
                                    'description' => 'A Boolean value indicating whether or not the attribute is required.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => true,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'canonicalValues',
                                    'description' => "A collection of canonical values. When applicable, service providers MUST specify the canonical types, e.g., 'work', 'home'.",
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                                    'multiValued' => true,
                                    'mutability' => 'readOnly',
                                    'required' => false,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'caseExact',
                                    'description' => 'A Boolean value indicating whether or not a string attribute is case sensitive.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => false,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'mutability',
                                    'description' => 'Indicates whether or not an attribute is modifiable.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                                    'canonicalValues' => array(
                                        'readOnly',
                                        'readWrite',
                                        'immutable',
                                        'writeOnly',
                                    ),
                                    'caseExact' => false,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => false,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'returned',
                                    'description' => 'Indicates when an attribute is returned in a response (e.g., to a query).',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                                    'canonicalValues' => array(
                                        'always',
                                        'never',
                                        'default',
                                        'request',
                                    ),
                                    'caseExact' => false,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => false,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'uniqueness',
                                    'description' => 'Indicates how unique a value must be.',
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                                    'canonicalValues' => array(
                                        'none',
                                        'server',
                                        'global',
                                    ),
                                    'caseExact' => false,
                                    'multiValued' => false,
                                    'mutability' => 'readOnly',
                                    'required' => false,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                                array(
                                    'name' => 'referenceTypes',
                                    'description' => "Used only with an attribute of type 'reference'. Specifies a SCIM resourceType that a reference attribute MAY refer to, e.g., 'User'.",
                                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                                    'canonicalValues' => array(
                                        'scim',
                                        'external',
                                        'uri',
                                        'User',
                                        'Group',
                                    ),
                                    'caseExact' => false,
                                    'multiValued' => true,
                                    'mutability' => 'readOnly',
                                    'required' => false,
                                    'returned' => 'default',
                                    'uniqueness' => 'none',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v2/schemas/urn:ietf:params:scim:schemas:core:2.0:Schema',
                'version' => 'W/"9F2C753BE314F95593B8B16669E0191653049038"',
            ),
        ),
        ScimConstantsV2::SCHEMA_RESOURCE_TYPE => array(
            'schemas' => array(
                'urn:ietf:params:scim:schemas:core:2.0:Schema',
            ),
            'id' => 'urn:ietf:params:scim:schemas:core:2.0:ResourceType',
            'name' => 'ResourceType',
            'description' => 'Specifies the schema that describes a SCIM resource type.',
            'attributes' => array(
                array(
                    'name' => 'name',
                    'description' => 'The resource type name. When applicable, service providers MUST specify the name, e.g., \'User\'.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'description',
                    'description' => 'The resource type\'s human-readable description. When applicable, service providers MUST specify the description.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'endpoint',
                    'description' => 'The resource type\'s HTTP-addressable endpoint relative to the Base URL of the service provider, e.g., "Users".',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'schema',
                    'description' => 'The resource type\'s primary/base schema URI.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'schemaExtensions',
                    'description' => 'A list of URIs of the resource type\'s schema extensions.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'schema',
                            'description' => 'The URI of an extended schema, e.g., "urn:edu:2.0:Staff". This MUST be equal to the "id" attribute of a "Schema" resource.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'required',
                            'description' => 'A Boolean value that specifies whether or not the schema extension is required for the resource type. If true, a resource of this type MUST include this schema extension and also include any attributes declared as required in this schema extension. If false, a resource of this type MAY omit this schema extension.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v2/schemas/urn:ietf:params:scim:schemas:core:2.0:ResourceType',
                'version' => 'W/"DB7B1335326DD0B77C0DDB33392C6AF3789E1AB3"',
            ),
        ),
        ScimConstantsV2::SCHEMA_GROUP => array(
            'schemas' => array(
                'urn:ietf:params:scim:schemas:core:2.0:Schema',
            ),
            'id' => 'urn:ietf:params:scim:schemas:core:2.0:Group',
            'name' => 'Group',
            'description' => 'Group resource.',
            'attributes' => array(
                array(
                    'name' => 'displayName',
                    'description' => 'A human-readable name for the Group. REQUIRED.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'members',
                    'description' => 'A list of members of the Group.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the type of resource, e.g., \'User\' or \'Group\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'User',
                                'Group',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'immutable',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'Display name for the member',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'immutable',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'Identifier of the member of this Group.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'immutable',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => 'The URI corresponding to a SCIM resource that is a member of this Group.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                            'multiValued' => false,
                            'mutability' => 'immutable',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'User',
                                'Group',
                            ),
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v2/schemas/urn:ietf:params:scim:schemas:core:2.0:Group',
                'version' => 'W/"05A8B9B6C912798878B44A358F579A083EF9C4A3"',
            ),
        ),
        ScimConstantsV2::SCHEMA_USER => array(
            'schemas' => array(
                'urn:ietf:params:scim:schemas:core:2.0:Schema',
            ),
            'id' => 'urn:ietf:params:scim:schemas:core:2.0:User',
            'name' => 'User',
            'description' => 'User resource.',
            'attributes' => array(
                array(
                    'name' => 'userName',
                    'description' => 'Unique identifier for the User, typically used by the user to directly authenticate to the service provider. Each User MUST include a non-empty userName value. This identifier MUST be unique across the service provider\'s entire set of Users. REQUIRED.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'server',
                ),
                array(
                    'name' => 'name',
                    'description' => 'The components of the user\'s real name. Providers MAY return just the full name as a single string in the formatted sub-attribute, or they MAY return just the individual component attributes using the other sub-attributes, or they MAY return both. If both variants are returned, they SHOULD be describing the same name, with the formatted name indicating how the component attributes should be combined.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'formatted',
                            'description' => 'The full name, including all middle names, titles, and suffixes as appropriate, formatted for display (e.g., \'Ms. Barbara J Jensen, III\').',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'familyName',
                            'description' => 'The family name of the User, or last name in most Western languages (e.g., \'Jensen\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'givenName',
                            'description' => 'The given name of the User, or first name in most Western languages (e.g., \'Barbara\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'middleName',
                            'description' => 'The middle name(s) of the User (e.g., \'Jane\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'honorificPrefix',
                            'description' => 'The honorific prefix(es) of the User, or title in most Western languages (e.g., \'Ms.\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'honorificSuffix',
                            'description' => 'The honorific suffix(es) of the User, or suffix in most Western languages (e.g., \'III\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'displayName',
                    'description' => 'The name of the User, suitable for display to end-users. The name SHOULD be the full name of the User being described, if known.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'nickName',
                    'description' => 'The casual way to address the user in real life, e.g., \'Bob\' or \'Bobby\' instead of \'Robert\'. This attribute SHOULD NOT be used to represent a User\'s username (e.g., \'bjensen\' or \'mpepperidge\').',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'profileUrl',
                    'description' => 'A fully qualified URL pointing to a page representing the User\'s online profile.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'referenceTypes' => array(
                        'external',
                    ),
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'title',
                    'description' => 'The user\'s title, such as "Vice President".',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'userType',
                    'description' => 'Used to identify the relationship between the organization and the user. Typical values used might be \'Contractor\', \'Employee\', \'Intern\', \'Temp\', \'External\', and \'Unknown\', but any value may be used.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'canonicalValues' => array(
                        'Contractor',
                        'Employee',
                        'Intern',
                        'Temp',
                        'External',
                        'Internal',
                        'Unknown',
                    ),
                ),
                array(
                    'name' => 'preferredLanguage',
                    'description' => 'Indicates the User\'s preferred written or spoken language. Generally used for selecting a localized user interface; e.g., \'en-US\' specifies the language English and country US.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'canonicalValues' => array(
                        'zh-CN',
                        'en-US',
                        'en-CA',
                    ),
                ),
                array(
                    'name' => 'locale',
                    'description' => 'Used to indicate the User\'s default location for purposes of localizing items such as currency, date time format, or numerical representations.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'canonicalValues' => array(
                        'en-CA',
                        'fr-CA',
                        'en-US',
                        'zh-CN',
                    ),
                ),
                array(
                    'name' => 'timezone',
                    'description' => 'The User\'s time zone in the \'Olson\' time zone database format, e.g., \'America/Los_Angeles\'.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'canonicalValues' => array(
                        'Asia/Shanghai',
                        'America/New_York',
                        'America/Toronto',
                    ),
                ),
                array(
                    'name' => 'active',
                    'description' => 'A Boolean value indicating the User\'s administrative status.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'password',
                    'description' => 'The User\'s cleartext password. This attribute is intended to be used as a means to specify an initial password when creating a new User or to reset an existing User\'s password.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'writeOnly',
                    'required' => false,
                    'returned' => 'never',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'emails',
                    'description' => 'Email addresses for the user. The value SHOULD be canonicalized by the service provider, e.g., \'bjensen@example.com\' instead of \'bjensen@EXAMPLE.COM\'.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'Email addresses for the user. The value SHOULD be canonicalized by the service provider, e.g., \'bjensen@example.com\' instead of \'bjensen@EXAMPLE.COM\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'Display value for an email',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\' or \'home\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'work',
                                'home',
                                'other',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute, e.g., the preferred mailing address or primary email address. The primary attribute value \'true\' MUST appear no more than once.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'phoneNumbers',
                    'description' => 'Phone numbers for the User. The value SHOULD be canonicalized by the service provider according to the format specified in RFC 3966, e.g., \'tel:+1-201-555-0123\'.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'Phone number of the User.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'Display value for a phone number',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\', \'home\', \'mobile\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'work',
                                'home',
                                'mobile',
                                'fax',
                                'pager',
                                'other',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => "A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred phone number or primary phone number. The primary attribute value 'true' MUST appear no more than once.",
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'ims',
                    'description' => 'Instant messaging addresses for the User.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'Instant messaging address for the User.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'Display value for an IMS',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'aim\', \'gtalk\', \'xmpp\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'aim',
                                'gtalk',
                                'icq',
                                'xmpp',
                                'msn',
                                'skype',
                                'qq',
                                'yahoo',
                                'wechat',
                                'facebook',
                                'weibo',
                                'other',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute, e.g., the preferred messenger or primary messenger. The primary attribute value \'true\' MUST appear no more than once.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'photos',
                    'description' => 'URLs of photos of the User.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'URL of a photo of the User.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'external',
                            ),
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, i.e., \'photo\' or \'thumbnail\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'photo',
                                'thumbnail',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute, e.g., the preferred photo or thumbnail. The primary attribute value \'true\' MUST appear no more than once.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'addresses',
                    'description' => 'A physical mailing address for this User.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'formatted',
                            'description' => 'The full mailing address, formatted for display or use with a mailing label. This attribute MAY contain newlines.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'streetAddress',
                            'description' => 'The full street address component, which may include house number, street name, P.O. box, and multi-line extended street address information. This attribute MAY contain newlines.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'locality',
                            'description' => 'The city or locality component.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'region',
                            'description' => 'The state or region component.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'postalCode',
                            'description' => 'The zip code or postal code component.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'country',
                            'description' => 'The country name component.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\' or \'home\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'work',
                                'home',
                                'id',
                                'driverlicense',
                                'other',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute. The primary attribute value \'true\' MUST appear no more than once.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'groups',
                    'description' => 'A list of groups to which the user belongs, either through direct membership, through nested groups, or dynamically calculated.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'The identifier of the User\'s group.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => 'The URI of the corresponding \'Group\' resource to which the user belongs.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'Group',
                            ),
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes. READ-ONLY.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'direct\' or \'indirect\'.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'canonicalValues' => array(
                                'direct',
                                'indirect',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'entitlements',
                    'description' => 'A list of entitlements for the User that represent a thing the User has.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'The value of an entitlement.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'The display value of an entitlement.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute. The primary attribute value \'true\' MUST appear no more than once.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'roles',
                    'description' => 'A list of roles for the User that collectively represent who the User is, e.g., \'Student\', \'Faculty\'.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'The value of a role.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'The display value of a role.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute. The primary attribute value \'true\' MUST appear no more than once.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'x509Certificates',
                    'description' => 'A list of certificates issued to the User.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'The value of an X.509 certificate.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BINARY,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'The display value of a certificate.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => "A label indicating the attribute's function.",
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => "A Boolean value indicating the 'primary' or preferred attribute value for this attribute. The primary attribute value 'true' MUST appear no more than once.",
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v2/schemas/urn:ietf:params:scim:schemas:core:2.0:User',
                'version' => 'W/"5CF43FF3C1E0C85DE1F13305C3B1AC83009FF941"',
            ),
        ),
        ScimConstantsV2::SCHEMA_ENTERPRISE_USER => array(
            'schemas' => array(
                'urn:ietf:params:scim:schemas:core:2.0:Schema',
            ),
            'id' => 'urn:ietf:params:scim:schemas:extension:enterprise:2.0:User',
            'name' => 'EnterpriseUser',
            'description' => 'Enterprise User',
            'attributes' => array(
                array(
                    'name' => 'employeeNumber',
                    'description' => 'Numeric or alphanumeric identifier assigned to a person, typically based on order of hire or association with an organization.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'costCenter',
                    'description' => 'Identifies the name of a cost center.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'organization',
                    'description' => 'Identifies the name of an organization.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'division',
                    'description' => 'Identifies the name of a division.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'department',
                    'description' => 'Identifies the name of a department.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'manager',
                    'description' => "The User's manager.  A complex type that optionally allows service providers to represent organizational hierarchy by referencing the 'id' attribute of another User.",
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => "The id of the SCIM resource representing the User's manager. REQUIRED.",
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => "The URI of the SCIM resource representing the User's manager.",
                            'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                            'referenceTypes' => array(
                                'User',
                            ),
                        ),
                        array(
                            'name' => 'displayName',
                            'description' => 'The displayName of the User\'s manager.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v2/schemas/urn:ietf:params:scim:schemas:extension:enterprise:2.0:User',
                'version' => 'W/"4E3F49246DCA6C2FC7E7F368DD9A15DB2B22C183"',
            ),
        ),
        ScimConstantsV2::SCHEMA_SERVICE_PROVIDER_CONFIG => array(
            'schemas' => array(
                'urn:ietf:params:scim:schemas:core:2.0:Schema',
            ),
            'id' => 'urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig',
            'name' => 'Service Provider Configuration',
            'description' => 'Schema for representing the service provider\'s configuration',
            'attributes' => array(
                array(
                    'name' => 'documentationUri',
                    'description' => 'An HTTP-addressable URL pointing to the service provider\'s human-consumable help documentation.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'referenceTypes' => array(
                        'external',
                    ),
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'patch',
                    'description' => 'A complex type that specifies PATCH configuration options.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A Boolean value specifying whether or not the operation is supported.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'bulk',
                    'description' => 'A complex type that specifies bulk configuration options.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A Boolean value specifying whether or not the operation is supported.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'maxOperations',
                            'description' => 'An integer value specifying the maximum number of operations.',
                            'type' => 'integer',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'maxPayloadSize',
                            'description' => 'An integer value specifying the maximum payload size in bytes.',
                            'type' => 'integer',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'filter',
                    'description' => 'A complex type that specifies FILTER options.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A Boolean value specifying whether or not the operation is supported.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'maxResults',
                            'description' => 'An integer value specifying the maximum number of resources returned in a response.',
                            'type' => 'integer',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'changePassword',
                    'description' => 'A complex type that specifies configuration options related to changing a password.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A Boolean value specifying whether or not the operation is supported.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'sort',
                    'description' => 'A complex type that specifies sort configuration options.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A Boolean value specifying whether or not the operation is supported.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'etag',
                    'description' => 'A complex type that specifies etag configuration options.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A Boolean value specifying whether or not the operation is supported.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'authenticationSchemes',
                    'description' => 'A multi-valued complex type that specifies supported authentication scheme properties.',
                    'type' => ScimConstants::ATTRIBUTE_TYPE_COMPLEX,
                    'multiValued' => true,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'Specifies the type of the authentication scheme',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                            'canonicalValues' => array(
                                'oauth2',
                                'httpbasic',
                            ),
                        ),
                        array(
                            'name' => 'name',
                            'description' => 'The common authentication scheme name, e.g., HTTP Basic.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'description',
                            'description' => 'A description of the authentication scheme.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_STRING,
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'specUri',
                            'description' => 'An HTTP-addressable URL pointing to the authentication scheme\'s specification.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'external',
                            ),
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'documentationUri',
                            'description' => 'An HTTP-addressable URL pointing to the authentication scheme\'s usage documentation.',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_REFERENCE,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'external',
                            ),
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A boolean indicates whether this authentication schema is primary',
                            'type' => ScimConstants::ATTRIBUTE_TYPE_BOOLEAN,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v2/schemas/urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig',
                'version' => 'W/"96A2414FE73EC8C63FD54E9CB681821DF467D94D"',
            ),
        ),
    );

    public function __construct($schemasEndpointUrl = null)
    {
        parent::__construct($schemasEndpointUrl ?: 'http://localhost/'.ScimConstantsV2::ENDPOINT_SCHEMAS);
    }

    protected function getSchemaClass()
    {
        return Schema::class;
    }

    /**
     * @return Schema
     */
    public function getGroup()
    {
        return $this->get(ScimConstantsV2::SCHEMA_GROUP);
    }

    /**
     * @return Schema
     */
    public function getSchema()
    {
        return $this->get(ScimConstantsV2::SCHEMA_SCHEMA);
    }

    /**
     * @return Schema
     */
    public function getUser()
    {
        return $this->get(ScimConstantsV2::SCHEMA_USER);
    }

    /**
     * @return Schema
     */
    public function getEnterpriseUser()
    {
        return $this->get(ScimConstantsV2::SCHEMA_ENTERPRISE_USER);
    }

    /**
     * @return Schema
     */
    public function getServiceProviderConfig()
    {
        return $this->get(ScimConstantsV2::SCHEMA_SERVICE_PROVIDER_CONFIG);
    }

    /**
     * @return Schema
     */
    public function getResourceType()
    {
        return $this->get(ScimConstantsV2::SCHEMA_RESOURCE_TYPE);
    }
}
