<?php

/*

mounts a ramdisk and provides alternative path for cache files
is a pure reading cache, just duplicate files from harddisk

*/

if (!defined('SOFAWIKI')) die('invalid acces');


$swRamDiskDBpath = $swRoot.'/site/indexes/records.db';
if (!defined('SOFAWIKICLI'))
{
	if (!is_dir($swRoot.'/site/')) mkdir($swRoot.'/site/');
	if (!is_dir($swRoot.'/site/indexes')) mkdir($swRoot.'/site/indexes');
}
$swRamDiskDBfilter = '/site/revisions/';
$swMemcache;

function swInitRamdisk()
{
	
	global $swRamdiskPath;
	global $swRamDiskDB;
	global $swRoot;
	global $swRamDiskDBpath;
	global $swMemcache;
	if (is_dir($swRamdiskPath)) 
	{
		 
	 $ramfree = sprintf('%0d',disk_free_space($swRamdiskPath)/1024/1024);
	 
	 echotime('ram free '. $ramfree. ' MB');
	
	 if ($ramfree < 16)
	 {
	 	// purge to prevent full ramdisk
	 	$files1 = glob($swRamdiskPath.'*.txt');
		shuffle($files);
		$files = array_slice($files,0,1000);
		foreach($files as $file) unlink($file);
		echotime('deleted 1000 files from ramdisk');
		$ramfree = sprintf('%0d',disk_free_space($swRamdiskPath)/1024/1024);
	 	echotime('ram free '. $ramfree. ' MB');
	 }
	 return;
	 
	}
	elseif ($swRamdiskPath=='memcache')
	{ 
		$swMemcache = new Memcache;
		if (!@$swMemcache->connect('localhost', 11211))
		{
			echotime('Could not connect do memcache');
		}

		$version = $swMemcache->getVersion();
		echotime('memcache server: '.$version);
		return;
	}
	elseif ($swRamdiskPath=='db')
	{
		if ($swRamDiskDB) return; 
		if (!file_exists($swRamDiskDBpath))
		{
			$swRamDiskDB = swDbaOpen($swRamDiskDBpath, 'c');
			echotime('new db');
		}
		else
		{
			$swRamDiskDB = swDbaOpen($swRamDiskDBpath, 'rdt');
			echotime('open db');  // if it fails, it is false
		}
		return;
	}
	
	echotime('no ramdisk');
	$swRamdiskPath = '';
		
}

function swFileGet($path)
{

	global $swRamdiskPath;
	global $swRamDiskDB;
	global $swRamDiskJobs;
	global $swRoot;
	global $swRamDiskDBpath; 
	global $swRamDiskDBfilter;
	global $swMemcache;
	
	// echotime("swFileGet($path)");
	
	if (isset($swRamdiskPath) && $swRamdiskPath != '')
	{
		if ($swRamdiskPath=='memcache')
		{
			if (!$swMemcache) swInitRamdisk();
			if ($swRamDiskDB && stristr($path,$swRamDiskDBfilter))
			{
				$v = @$swMemcache->get($path);
				if ($v) 
				{  
					echotime('memcache sucess '.floor(strlen($s)/1024).' KB '.$path);
					return $v; 		
				}
				$s = file_get_contents($path);
				$memcached->set($path,$s,60*60*24*30);
				return $s;			
			}
		}
		elseif ($swRamdiskPath=='db')
		{
			if (!$swRamDiskDB) swInitRamdisk();
			if ($swRamDiskDB && stristr($path,$swRamDiskDBfilter))
			{
				
				$pos = stripos($path,$swRamDiskDBfilter) + strlen($swRamDiskDBfilter);
				$path2 = substr($path,$pos);
				
				
				$v = swDbaFetch($path2,$swRamDiskDB);
				if ($v)
				{
					return $v;
				}
				$s = file_get_contents($path);
				
				// only keep short files
				if (strlen($s) <= 10000)
					$swRamDiskJobs[$path2] = $s;
				
				if (isset($swRamDiskJobs) && count($swRamDiskJobs) % 100 == 0)
				{
					
					swUpdateRamDiskDB();
				}
				
				
				return $s;
			}
			$s = file_get_contents($path);
			// echotime('db not '.floor(strlen($s)/1024).' KB '.$path);
			return $s;
		}
		
		
		
		
		$hash = $swRamdiskPath.md5($path).'.txt';
		
		if (@file_exists($hash))
			return file_get_contents($hash);
		else
		{
			$s = file_get_contents($path);
			if ($s != '')
			{
				echotime('tocache '.basename($path));
				@file_put_contents($hash,$s);
			}
			return $s;
			
		}
		
	}
	else
		return file_get_contents($path);

}

function swUnlink($path)
{
	
	global $swRamdiskPath;
	global $swRoot;
	global $swRamDiskDBpath;
	global $swRamDiskDBfilter;
	global $swMemcache;
	
	if (file_exists($path))
		unlink($path);
	
	if (isset($swRamdiskPath) && $swRamdiskPath != '')
	{
		
		if ($swRamdiskPath=='memcached')
		{
			if (!stristr($path,$swRamDiskDBfilter)) return;
			if (!$swMemcache) return;
			@$swMemcache->delete($path);
			
		}
		elseif ($swRamdiskPath=='db')
		{
			if (!stristr($path,$swRamDiskDBfilter)) return;
			
			if (isset($swRamDiskDB) and $swRamDiskDB) swDBA_close($swRamDiskDB);

			$swRamDiskDB = swDbaOpen($swRamDiskDBpath, 'wdt');
			if ($swRamDiskDB)
			{
				swDbaDelete($path,$swRamDiskDB);
				echotime('delete db ok');
				
			}
			else			
			{
				echotime('delete db failed '.$path);
			}
			swDbaClose($swRamDiskDB);
			swInitRamdisk();
			return;
		}
		
		
		$hash = $swRamdiskPath.md5($path).'.txt';
		if (file_exists($hash))
			unlink($hash);
	}
	
}

function swIndexRamDiskDB()
{
	global $swRamDiskJobs;
	global $swRamDiskDBfilter;
	global $db;
	global $swOvertime;
	
	$k = rand(0,$db->lastrevision/1000)*1000; 
	
	global $swMemoryLimit;
	
	for($i=$k;$i<$k+2000;$i++)
	{ 
		if (memory_get_usage()>$swMemoryLimit) break;
		if ($db->indexedbitmap->getbit($i) && !$db->currentbitmap->getbit($i)) continue;
		$path = swGetPath($i);
		if (!file_exists($path)) continue;
		if (filesize($path)>4096) continue;
		
		$s = file_get_contents($path);
		$pos = stripos($path,$swRamDiskDBfilter) + strlen($swRamDiskDBfilter);
		$path2 = substr($path,$pos);
		$swRamDiskJobs[$path2] = $s;
		
		if ($swRamDiskJobs && count($swRamDiskJobs)>500) swUpdateRamDiskDB();
				
	}
	if ($swRamDiskJobs && count($swRamDiskJobs)) $swOvertime = true;
	swUpdateRamDiskDB();
	return true;

}

function swUpdateRamDiskDB()
{
	global $swRamDiskDB;
	global $swRamDiskDBpath;
	global $swRamDiskJobs;
	
	if (!$swRamDiskJobs || !@count($swRamDiskJobs)) return;
	
	if ($swRamDiskDB) swDbaClose($swRamDiskDB);
	$swRamDiskDB = swDbaOpen($swRamDiskDBpath, 'wdt');
	if ($swRamDiskDB && is_array($swRamDiskJobs))
	{
		foreach($swRamDiskJobs as $k=>$v)
		{	swDbaReplace($k,$v,$swRamDiskDB);
			//echotime('insert db '.$k);
		}
		$swRamDiskJobs = array();				
	}
	else
	{
		echotime('insert db failed');
	}
	swDbaClose($swRamDiskDB);
	swInitRamdisk();

}




?>