/*!
 * chartjs-plugin-rough v0.2.0
 * https://nagix.github.io/chartjs-plugin-rough
 * (c) 2019 Akihiko Kusanagi
 * Released under the MIT license
 */
!function(e, t) {
    "object" == typeof exports && "undefined" != typeof module ? module.exports = t(require("chart.js"), require("roughjs")) : "function" == typeof define && define.amd ? define(["chart.js", "roughjs"], t) : (e = e || self).ChartRough = t(e.Chart, e.rough)
}(this, function(e, t) {
    "use strict";
    e = e && e.hasOwnProperty("default") ? e.default : e,
    t = t && t.hasOwnProperty("default") ? t.default : t;
    var o = Math.PI,
        n = o / 180,
        r = o / 4,
        a = 2 * o / 3,
        i = {
            roughKeys: ["roughness", "bowing", "fillStyle", "fillWeight", "hachureAngle", "hachureGap", "curveStepCount", "simplification"],
            drawPoint: function(e, t, o, i, l, s, d, u) {
                var c,
                    p,
                    h,
                    g,
                    f,
                    v,
                    b,
                    y,
                    m,
                    x,
                    _ = this.getFillOptions(u),
                    M = this.getStrokeOptions(u),
                    k = (s || 0) * n;
                if (!t || "object" != typeof t || "[object HTMLImageElement]" !== (c = t.toString()) && "[object HTMLCanvasElement]" !== c) {
                    if (!(isNaN(o) || o <= 0))
                        switch (t) {
                        default:
                            d.circle(i, l, 2 * o, _),
                            d.circle(i, l, 2 * o, M);
                            break;
                        case "triangle":
                            (y = []).push([i + Math.sin(k) * o, l - Math.cos(k) * o]),
                            k += a,
                            y.push([i + Math.sin(k) * o, l - Math.cos(k) * o]),
                            k += a,
                            y.push([i + Math.sin(k) * o, l - Math.cos(k) * o]),
                            d.polygon(y, _),
                            d.polygon(y, M);
                            break;
                        case "rectRounded":
                            b = .516 * o,
                            g = Math.cos(k) * b,
                            f = Math.sin(k) * b,
                            k += r,
                            v = o - b,
                            m = "M" + (i - (p = Math.cos(k) * v) - g) + " " + (l - (h = Math.sin(k) * v) - f) + (x = "A" + b + " " + b + " 0 0 1 ") + (i - p + f) + " " + (l - h - g) + "L" + (i + h + f) + " " + (l - p - g) + x + (i + h + g) + " " + (l - p + f) + "L" + (i + p + g) + " " + (l + h + f) + x + (i + p - f) + " " + (l + h + g) + "L" + (i - h - f) + " " + (l + p + g) + x + (i - h - g) + " " + (l + p - f) + "Z",
                            d.path(m, _),
                            d.path(m, M);
                            break;
                        case "rect":
                            if (!s) {
                                v = Math.SQRT1_2 * o,
                                d.rectangle(i - v, l - v, 2 * v, 2 * v, _),
                                d.rectangle(i - v, l - v, 2 * v, 2 * v, M);
                                break
                            }
                            k += r;
                        case "rectRot":
                            y = [[i - (p = Math.cos(k) * o), l - (h = Math.sin(k) * o)], [i + h, l - p], [i + p, l + h], [i - h, l + p]],
                            d.polygon(y, _),
                            d.polygon(y, M);
                            break;
                        case "crossRot":
                            k += r;
                        case "cross":
                            p = Math.cos(k) * o,
                            h = Math.sin(k) * o,
                            d.line(i - p, l - h, i + p, l + h, M),
                            d.line(i + h, l - p, i - h, l + p, M);
                            break;
                        case "star":
                            p = Math.cos(k) * o,
                            h = Math.sin(k) * o,
                            d.line(i - p, l - h, i + p, l + h, M),
                            d.line(i + h, l - p, i - h, l + p, M),
                            k += r,
                            p = Math.cos(k) * o,
                            h = Math.sin(k) * o,
                            d.line(i - p, l - h, i + p, l + h, M),
                            d.line(i + h, l - p, i - h, l + p, M);
                            break;
                        case "line":
                            p = Math.cos(k) * o,
                            h = Math.sin(k) * o,
                            d.line(i - p, l - h, i + p, l + h, M);
                            break;
                        case "dash":
                            d.line(i, l, i + Math.cos(k) * o, l + Math.sin(k) * o, M)
                        }
                } else
                    e.drawImage(t, i - t.width / 2, l - t.height / 2, t.width, t.height)
            },
            lineTo: function(e, t, o) {
                var n,
                    r = t.steppedLine;
                return r ? ("middle" === r ? "L" + (n = (e.x + t.x) / 2) + " " + (o ? t.y : e.y) + "L" + n + " " + (o ? e.y : t.y) : "after" === r && !o || "after" !== r && o ? "L" + e.x + " " + t.y : "L" + t.x + " " + e.y) + "L" + t.x + " " + t.y : t.tension ? "C " + (o ? e.controlPointPreviousX : e.controlPointNextX) + " " + (o ? e.controlPointPreviousY : e.controlPointNextY) + "," + (o ? t.controlPointNextX : t.controlPointPreviousX) + " " + (o ? t.controlPointNextY : t.controlPointPreviousY) + "," + t.x + " " + t.y : "L" + t.x + " " + t.y
            },
            resolve: function(t, o) {
                var n = t.rough;
                return !1 === n ? null : (!0 === n && (n = {}), e.helpers.merge({}, [o, n]))
            },
            getFillOptions: function(e) {
                var t = {
                    stroke: "transparent",
                    fill: e.backgroundColor
                };
                return this.roughKeys.forEach(function(o) {
                    void 0 !== e[o] && (t[o] = e[o])
                }), t
            },
            getStrokeOptions: function(e) {
                var t = {
                    stroke: e.borderColor,
                    strokeWidth: e.borderWidth
                };
                return ["roughness", "bowing", "curveStepCount", "simplification"].forEach(function(o) {
                    void 0 !== e[o] && (t[o] = e[o])
                }), t
            }
        },
        l = e.helpers;
    function s(e, t) {
        if (void 0 === t)
            return e;
        var o = l.color(e);
        return o.alpha(t * o.alpha()).rgbaString()
    }
    var d = e.Tooltip,
        u = d.extend({
            update: function() {
                var e,
                    t = this,
                    o = [];
                return d.prototype.update.apply(t, arguments), e = t._model, t._active.length && (l.each(e.dataPoints, function(e) {
                    var n = t._chart.getDatasetMeta(e.datasetIndex).data[e.index]._view;
                    o.push({
                        fillOptions: i.getFillOptions(n),
                        strokeOptions: i.getStrokeOptions(n)
                    })
                }), e.rough = o), t
            },
            drawBody: function(e, o, n, r) {
                var a,
                    i = o.bodyFontSize,
                    u = o.body,
                    c = o.rough,
                    p = t.canvas(this._chart.canvas),
                    h = l.each;
                l.each = function(e, t) {
                    e === u ? h(e, function(e, o) {
                        a = c[o],
                        t.apply(null, arguments)
                    }) : h.apply(null, arguments)
                },
                n.fillRect = function(e, t, o, n) {
                    var d = a.fillOptions;
                    o === i ? CanvasRenderingContext2D.prototype.fillRect.apply(this, arguments) : p.rectangle(e, t, o, n, l.extend({}, d, {
                        fill: s(d.fill, r)
                    }))
                },
                n.strokeRect = function(e, t, o, n) {
                    var i = a.strokeOptions;
                    p.rectangle(e, t, o, n, l.extend({}, i, {
                        stroke: s(i.stroke, r),
                        strokeWidth: 1
                    }))
                },
                d.prototype.drawBody.apply(this, arguments),
                l.each = h,
                delete n.fillRect,
                delete n.strokeRect
            }
        });
    var c = e.elements.Rectangle.extend({
            draw: function() {
                var o = this._view,
                    n = function(e) {
                        var t,
                            o = e.x,
                            n = e.y,
                            r = e.width,
                            a = e.base;
                        return void 0 !== r ? {
                            l: o - (t = r / 2),
                            r: o + t,
                            t: Math.min(n, a),
                            b: Math.max(n, a)
                        } : (t = e.height / 2, {
                            l: Math.min(o, a),
                            r: Math.max(o, a),
                            t: n - t,
                            b: n + t
                        })
                    }(o),
                    r = function(t, o, n) {
                        var r,
                            a,
                            i,
                            l,
                            s = t.borderWidth,
                            d = function(e) {
                                var t = e.borderSkipped,
                                    o = e.base,
                                    n = {};
                                return t ? (e.horizontal ? o > e.x && (t = "left" === t ? "right" : "right" === t ? "left" : t) : o < e.y && (t = "bottom" === t ? "top" : "top" === t ? "bottom" : t), n[t] = !0, n) : n
                            }(t);
                        return e.helpers.isObject(s) ? (r = +s.top || 0, a = +s.right || 0, i = +s.bottom || 0, l = +s.left || 0) : r = a = i = l = +s || 0, {
                            t: d.top || r < 0 ? 0 : r > n ? n : r,
                            r: d.right || a < 0 ? 0 : a > o ? o : a,
                            b: d.bottom || i < 0 ? 0 : i > n ? n : i,
                            l: d.left || l < 0 ? 0 : l > o ? o : l
                        }
                    }(o, (n.r - n.l) / 2, (n.b - n.t) / 2),
                    a = n.l + r.l / 2,
                    l = n.t + r.t / 2,
                    s = n.r - r.r / 2,
                    d = n.b - r.b / 2,
                    u = t.canvas(this._chart.canvas),
                    c = i.getFillOptions(o),
                    p = i.getStrokeOptions(o);
                u.rectangle(a, l, s - a, d - l, c),
                r.l && (p.strokeWidth = r.l, u.line(a, d, a, l, p)),
                r.t && (p.strokeWidth = r.t, u.line(a, l, s, l, p)),
                r.r && (p.strokeWidth = r.r, u.line(s, l, s, d, p)),
                r.b && (p.strokeWidth = r.b, u.line(s, d, a, d, p))
            }
        }),
        p = e.controllers.bar,
        h = p.extend({
            dataElementType: c,
            updateElement: function(t) {
                var o = this,
                    n = {};
                Object.defineProperty(t, "_model", {
                    configurable: !0,
                    get: function() {
                        return n
                    },
                    set: function(t) {
                        e.helpers.extend(n, t, i.resolve(o.getDataset(), o.chart.options.plugins.rough))
                    }
                }),
                p.prototype.updateElement.apply(o, arguments),
                delete t._model,
                t._model = n
            }
        }),
        g = e.helpers.canvas._isPointInArea || function(e, t) {
            return e.x > t.left - 1e-6 && e.x < t.right + 1e-6 && e.y > t.top - 1e-6 && e.y < t.bottom + 1e-6
        },
        f = e.elements.Point.extend({
            draw: function(e) {
                var o = this._view,
                    n = this._chart,
                    r = t.canvas(n.canvas);
                o.skip || void 0 !== e && !g(o, e) || i.drawPoint(n.ctx, o.pointStyle, o.radius, o.x, o.y, o.rotation, r, o)
            }
        }),
        v = e.controllers.bubble,
        b = v.extend({
            dataElementType: f,
            updateElement: function(t) {
                var o = this,
                    n = {};
                Object.defineProperty(t, "_model", {
                    configurable: !0,
                    get: function() {
                        return n
                    },
                    set: function(t) {
                        e.helpers.extend(n, t, i.resolve(o.getDataset(), o.chart.options.plugins.rough))
                    }
                }),
                v.prototype.updateElement.apply(o, arguments),
                delete t._model,
                t._model = n
            }
        }),
        y = e.elements.Arc.extend({
            draw: function() {
                var e = this._view,
                    o = e.x,
                    n = e.y,
                    r = e.outerRadius,
                    a = e.innerRadius,
                    l = e.startAngle,
                    s = e.endAngle,
                    d = Math.cos(l),
                    u = Math.sin(l),
                    c = Math.cos(s),
                    p = Math.sin(s),
                    h = s - l > Math.PI ? 1 : 0,
                    g = t.canvas(this._chart.canvas),
                    f = "M" + (o + r * d) + " " + (n + r * u) + "A" + r + " " + r + " 0 " + h + " 1 " + (o + r * c) + " " + (n + r * p) + "L" + (o + a * c) + " " + (n + a * p) + "A" + a + " " + a + " 0 " + h + " 0 " + (o + a * d) + " " + (n + a * u) + "Z";
                g.path(f, i.getFillOptions(e)),
                e.borderWidth && g.path(f, i.getStrokeOptions(e))
            }
        }),
        m = e.defaults,
        x = e.helpers,
        _ = x.options.resolve;
    m.doughnut.legend.labels.generateLabels = m.pie.legend.labels.generateLabels = function(e) {
        var t = e.data;
        return t.labels.length && t.datasets.length ? t.labels.map(function(o, n) {
            var r = e.getDatasetMeta(0),
                a = t.datasets[0],
                l = r.data[n],
                s = l && l.custom || {},
                d = e.options,
                u = d.elements.arc;
            return {
                text: o,
                fillStyle: _([s.backgroundColor, a.backgroundColor, u.backgroundColor], void 0, n),
                strokeStyle: _([s.borderColor, a.borderColor, u.borderColor], void 0, n),
                lineWidth: _([s.borderWidth, a.borderWidth, u.borderWidth], void 0, n),
                hidden: isNaN(a.data[n]) || r.data[n].hidden,
                rough: i.resolve(a, d.plugins.rough),
                index: n
            }
        }) : []
    };
    var M = e.controllers.doughnut,
        k = M.extend({
            dataElementType: y,
            updateElement: function(e) {
                var t = this,
                    o = {};
                Object.defineProperty(e, "_model", {
                    configurable: !0,
                    get: function() {
                        return o
                    },
                    set: function(e) {
                        x.extend(o, e, i.resolve(t.getDataset(), t.chart.options.plugins.rough))
                    }
                }),
                M.prototype.updateElement.apply(t, arguments),
                delete e._model,
                e._model = o
            }
        }),
        w = h.extend({
            _getValueScaleId: function() {
                return this.getMeta().xAxisID
            },
            _getIndexScaleId: function() {
                return this.getMeta().yAxisID
            },
            getValueScaleId: function() {
                return this.getMeta().xAxisID
            },
            getIndexScaleId: function() {
                return this.getMeta().yAxisID
            }
        }),
        S = e.elements.Line.extend({
            draw: function() {
                var o,
                    n,
                    r,
                    a,
                    l = this._view,
                    s = l.spanGaps,
                    d = this._children.slice(),
                    u = -1,
                    c = t.canvas(this._chart.canvas),
                    p = "";
                for (this._loop && d.length && d.push(d[0]), u = -1, o = 0; o < d.length; ++o)
                    n = d[o],
                    r = e.helpers.previousItem(d, o),
                    a = n._view,
                    0 === o ? a.skip || (p += "M" + a.x + " " + a.y, u = o) : (r = -1 === u ? r : d[u], a.skip || (p += u !== o - 1 && !s || -1 === u ? "M" + a.x + " " + a.y : i.lineTo(r._view, n._view), u = o));
                c.path(p, i.getStrokeOptions(l))
            }
        }),
        C = e.helpers.extend,
        O = e.controllers.line,
        P = O.extend({
            datasetElementType: S,
            dataElementType: f,
            update: function() {
                var e = this,
                    t = e.getMeta().dataset,
                    o = {};
                Object.defineProperty(t, "_model", {
                    configurable: !0,
                    get: function() {
                        return o
                    },
                    set: function(t) {
                        C(o, t, i.resolve(e.getDataset(), e.chart.options.plugins.rough))
                    }
                }),
                O.prototype.update.apply(e, arguments),
                delete t._model,
                t._model = o
            },
            updateElement: function(e) {
                O.prototype.updateElement.apply(this, arguments),
                C(e._model, i.resolve(this.getDataset(), this.chart.options.plugins.rough))
            }
        }),
        D = e.helpers,
        E = D.options.resolve;
    e.defaults.polarArea.legend.labels.generateLabels = function(e) {
        var t = e.data;
        return t.labels.length && t.datasets.length ? t.labels.map(function(o, n) {
            var r = e.getDatasetMeta(0),
                a = t.datasets[0],
                l = r.data[n].custom || {},
                s = e.options,
                d = s.elements.arc;
            return {
                text: o,
                fillStyle: E([l.backgroundColor, a.backgroundColor, d.backgroundColor], void 0, n),
                strokeStyle: E([l.borderColor, a.borderColor, d.borderColor], void 0, n),
                lineWidth: E([l.borderWidth, a.borderWidth, d.borderWidth], void 0, n),
                hidden: isNaN(a.data[n]) || r.data[n].hidden,
                rough: i.resolve(a, s.plugins.rough),
                index: n
            }
        }) : []
    };
    var I = e.controllers.polarArea,
        W = I.extend({
            dataElementType: y,
            updateElement: function(e) {
                var t = this,
                    o = {};
                Object.defineProperty(e, "_model", {
                    configurable: !0,
                    get: function() {
                        return o
                    },
                    set: function(e) {
                        D.extend(o, e, i.resolve(t.getDataset(), t.chart.options.plugins.rough))
                    }
                }),
                I.prototype.updateElement.apply(t, arguments),
                delete e._model,
                e._model = o
            }
        }),
        A = e.helpers.extend,
        L = e.controllers.radar,
        R = L.extend({
            datasetElementType: S,
            dataElementType: f,
            update: function() {
                var e = this,
                    t = e.getMeta().dataset,
                    o = {};
                Object.defineProperty(t, "_model", {
                    configurable: !0,
                    get: function() {
                        return o
                    },
                    set: function(t) {
                        A(o, t, i.resolve(e.getDataset(), e.chart.options.plugins.rough))
                    }
                }),
                L.prototype.update.apply(e, arguments),
                delete t._model,
                t._model = o
            },
            updateElement: function(e) {
                L.prototype.updateElement.apply(this, arguments),
                A(e._model, i.resolve(this.getDataset(), this.chart.options.plugins.rough))
            }
        }),
        T = e.helpers,
        j = e.plugins.getAll().filter(function(e) {
            return "filler" === e.id
        })[0];
    function N(e) {
        return e && !e.skip
    }
    function F(e, t, o, n) {
        var r,
            a;
        if (o && n) {
            for (r = "M" + e[0].x + " " + e[0].y, a = 1; a < o; ++a)
                r += i.lineTo(e[a - 1], e[a]);
            for (r += "L" + t[n - 1].x + " " + t[n - 1].y, a = n - 1; a > 0; --a)
                r += i.lineTo(t[a], t[a - 1], !0);
            return r
        }
    }
    var B = T.extend({}, j, {
            beforeDatasetDraw: function(o, n) {
                var r = n.meta.$filler;
                if (r) {
                    var a = o.ctx,
                        l = r.el,
                        s = l._view,
                        d = l._children || [],
                        u = r.mapper,
                        c = s.backgroundColor || e.defaults.global.defaultColor;
                    u && c && d.length && (T.canvas.clipArea(a, o.chartArea), function(e, o, n, r, a, l) {
                        var s,
                            d,
                            u,
                            c,
                            p,
                            h,
                            g,
                            f = o.length,
                            v = r.spanGaps,
                            b = [],
                            y = [],
                            m = 0,
                            x = 0,
                            _ = t.canvas(e.canvas),
                            M = "";
                        for (s = 0, d = f + !!l; s < d; ++s)
                            p = n(c = o[u = s % f]._view, u, r),
                            h = N(c),
                            g = N(p),
                            h && g ? (m = b.push(c), x = y.push(p)) : m && x && (v ? (h && b.push(c), g && y.push(p)) : (M += F(b, y, m, x), m = x = 0, b = [], y = []));
                        M += F(b, y, m, x),
                        _.path(M, i.getFillOptions(r))
                    }(o, d, u, s, 0, l._loop), T.canvas.unclipArea(a))
                }
            }
        }),
        G = e.defaults,
        X = e.helpers,
        Y = e.layouts || e.layoutService,
        $ = X.valueOrDefault;
    G.global.legend.labels.generateLabels = function(e) {
        var t = e.data;
        return X.isArray(t.datasets) ? t.datasets.map(function(t, o) {
            return {
                text: t.label,
                fillStyle: X.valueAtIndexOrDefault(t.backgroundColor, 0),
                hidden: !e.isDatasetVisible(o),
                lineCap: t.borderCapStyle,
                lineDash: t.borderDash,
                lineDashOffset: t.borderDashOffset,
                lineJoin: t.borderJoinStyle,
                lineWidth: t.borderWidth,
                strokeStyle: t.borderColor,
                pointStyle: t.pointStyle,
                rough: i.resolve(t, e.options.plugins.rough),
                datasetIndex: o
            }
        }, this) : []
    };
    var z = e.Legend.extend({
        draw: function() {
            var o,
                n = G.global,
                r = X.each,
                a = X.canvas.drawPoint,
                l = t.canvas(this.chart.canvas),
                s = this.ctx;
            X.each = function(e, t) {
                r(e, function(e) {
                    o = X.extend({
                        borderColor: $(e.strokeStyle, n.defaultColor),
                        borderWidth: $(e.lineWidth, n.elements.line.borderWidth),
                        backgroundColor: $(e.fillStyle, n.defaultColor)
                    }, e.rough),
                    t.apply(null, arguments)
                })
            },
            X.canvas.drawPoint = function(e, t, n, r, a, s) {
                i.drawPoint(e, t, n, r, a, s, l, o)
            },
            s.strokeRect = function() {},
            s.fillRect = function(e, t, n, r) {
                l.rectangle(e, t, n, r, i.getFillOptions(o)),
                0 !== o.borderWidth && l.rectangle(e, t, n, r, i.getStrokeOptions(o))
            },
            e.Legend.prototype.draw.apply(this, arguments),
            X.each = r,
            X.canvas.drawPoint = a,
            delete s.fillRect,
            delete s.strokeRect
        }
    });
    function V(e, t) {
        var o = new z({
            ctx: e.ctx,
            options: t,
            chart: e
        });
        Y.configure(e, o, t),
        Y.addBox(e, o),
        e.legend = o
    }
    var q = {
            id: "legend",
            _element: z,
            beforeInit: function(e) {
                var t = e.options.legend;
                t && V(e, t)
            },
            beforeUpdate: function(e) {
                var t = e.options.legend,
                    o = e.legend;
                t ? (X.mergeIf(t, G.global.legend), o ? (Y.configure(e, o, t), o.options = t) : V(e, t)) : o && (Y.removeBox(e, o), delete e.legend)
            },
            afterEvent: function(e, t) {
                var o = e.legend;
                o && o.handleEvent(t)
            }
        },
        H = e.layouts || e.layoutService,
        J = e.plugins;
    e.defaults.global.plugins.rough = {
        roughness: 1,
        bowing: 1,
        fillStyle: "hachure",
        fillWeight: .5,
        hachureAngle: -41,
        hachureGap: 4,
        curveStepCount: 9,
        simplification: 0
    };
    var K = {
        bar: h,
        bubble: b,
        doughnut: k,
        horizontalBar: w,
        line: P,
        polarArea: W,
        pie: k,
        radar: R,
        scatter: P
    };
    function U() {
        var t = this,
            o = [];
        return e.helpers.each(t.data.datasets, function(e, n) {
            var r = t.getDatasetMeta(n),
                a = e.type || t.config.type;
            if (r.type && r.type !== a && (t.destroyDatasetMeta(n), r = t.getDatasetMeta(n)), r.type = a, r.controller)
                r.controller.updateIndex(n),
                r.controller.linkScales();
            else {
                var i = K[r.type];
                if (void 0 === i)
                    throw new Error('"' + r.type + '" is not a chart type.');
                r.controller = new i(t, n),
                o.push(r.controller)
            }
        }, t), o
    }
    function Z() {
        var e = this;
        e.tooltip = new u({
            _chart: e,
            _chartInstance: e,
            _data: e.data,
            _options: e.options.tooltips
        }, e)
    }
    var Q = J.descriptors;
    return J.descriptors = function(e) {
        var t = e._rough;
        if (t) {
            var o = e.$plugins || e._plugins || (e.$plugins = e._plugins = {});
            if (o.id === this._cacheId)
                return o.descriptors;
            var n,
                r = this._plugins;
            this._plugins = r.map(function(e) {
                return "filler" === e.id ? B : "legend" === e.id ? q : e
            })
        }
        return n = Q.apply(this, arguments), t && (this._plugins = r), n
    }, {
        id: "rough",
        beforeInit: function(e) {
            e._rough = {},
            e.buildOrUpdateControllers = U,
            e.initToolTip = Z,
            e.legend && (H.removeBox(e, e.legend), delete e.legend),
            delete e.$plugins,
            delete e._plugins,
            J.descriptors(e)
        }
    }
});

