<?php
/**
 * Tools Administration Screen.
 *
 * @package SitePad
 * @subpackage Administration
 */

/** SitePad Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'Sorry, you are not allowed to manage options for this site.' ) );
}

// Documentations
$opts['documentor'] = ['t' => 'Enable Docs', 'e' => 'You can write documentations about your product(s) and API, if this feature is enabled'];

// Kkart
$opts['kkart-pro'] = ['t' => 'Enable Kkart E-Commerce', 'e' => 'If you would like to convert your site to a shopping cart, please enable this feature', 'comp' => function(){
	
	$ret = array();
	
	if(version_compare(PHP_VERSION, '7.2.0') < 0){
		$ret['error'][] = __('PHP version must be at least 7.2.0 to enable Kkart. And your current PHP version: ') . PHP_VERSION . "\n";
	}
	
	return $ret;
}];

if(!empty($sitepad['dev'])){

	// HR Monitor
	$opts['workviewer'] = ['t' => 'WorkViewer', 'e' => 'Tracker office work'];
	
	// Speedify
	$opts['speedify'] = ['t' => 'Speedify', 'e' => 'Cached pages and WebP support'];

	// Google Site Kit
	$opts['google-site-kit'] = ['t' => 'Google Site Kit', 'e' => 'Connect with Google Services'];

	// AMP
	$opts['amp'] = ['t' => 'AMP', 'e' => 'Accelerated Mobile Pages (by Google)'];
}

$message = array();

if(isset($_REQUEST['submit'])){
	
	// Check nonce
	check_admin_referer( 'sitepad-options' );
	$success = false;
	
	foreach($opts as $v => $r){
		
		$enable = get_option('enable_'.$v);
		$new_enable = isset($_POST['enable_'.$v]) ? (bool)$_POST['enable_'.$v] : false;
		
		if( !empty($new_enable) && isset($r['comp']) && is_callable($r['comp']) ){
			$ret = $r['comp']();
			
			if( !empty($ret) && isset($ret['error']) ){
				
				foreach($ret['error'] as $note){
					$message[] = '<div id="message" class="error notice is-dismissible"><p>'.$note.'</p></div>';
				}
				
				continue;
			}
			
		}
		
		$success = true;
		update_option('enable_'.$v, $new_enable);
		
		if(!empty($new_enable) && empty($enable)){
			activate_plugin($v.'/'.$v.'.php');
		}
		
	}
	
	if($success){
		$message[] = '<div id="message" class="updated notice is-dismissible"><p>'.__('Your preferences have been updated successfully !').'</p></div>';
		set_transient('features_message', $message );
		wp_safe_redirect(admin_url('features.php'));
		exit;
	}
	
}

$transient = get_transient('features_message');

if(!empty($transient)){
	$message = $transient;
	set_transient('features_message', array() );
}

$title       = __( 'SitePad Feature Management' );

include( ABSPATH . 'site-admin/admin-header.php' );

echo '<div class="wrap" style="margin: 0px;">	
	<h1>'.$title.'</h1>
	<hr />';

foreach($message as $msg){
	echo $msg;
}
	
?>

<form method="post" action="">

<?php wp_nonce_field('sitepad-options') ?>

<table class="form-table">

<?php

foreach($opts as $k => $v){
	echo '<tr>
	<th scope="row"><label for="full-width-blog">'.$v['t'].'</label></th>
	<td>
		<input name="enable_'.$k.'" type="checkbox" id="enable_documentor" value="1" '; echo checked('1', get_option('enable_'.$k)); echo ' />
		<p class="description">'. _( $v['e'] ).'</p><br/>
	</td>
</tr>';
}

?>

</table>

<?php submit_button(); ?>
</form>

<?php

include( ABSPATH . 'site-admin/admin-footer.php' );
