/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { InspectorControls } from '@wordpress/block-editor';
import { Disabled, PanelBody, withSpokenMessages } from '@wordpress/components';
import HeadingToolbar from '@kkart/editor-components/heading-toolbar';
import BlockTitle from '@kkart/editor-components/block-title';
import ToggleButtonControl from '@kkart/editor-components/toggle-button-control';

/**
 * Internal dependencies
 */
import Block from './block.js';

const Edit = ( { attributes, setAttributes } ) => {
	const { className, displayStyle, heading, headingLevel } = attributes;

	const getInspectorControls = () => {
		return (
			<InspectorControls key="inspector">
				<PanelBody
					title={ __(
						'Block Settings',
						'kkart'
					) }
				>
					<ToggleButtonControl
						label={ __(
							'Display Style',
							'kkart'
						) }
						value={ displayStyle }
						options={ [
							{
								label: __(
									'List',
									'kkart'
								),
								value: 'list',
							},
							{
								/* translators: "Chips" is a tag-like display style for chosen attributes. */
								label: __(
									'Chips',
									'kkart'
								),
								value: 'chips',
							},
						] }
						onChange={ ( value ) =>
							setAttributes( {
								displayStyle: value,
							} )
						}
					/>
					<p>
						{ __(
							'Heading Level',
							'kkart'
						) }
					</p>
					<HeadingToolbar
						isCollapsed={ false }
						minLevel={ 2 }
						maxLevel={ 7 }
						selectedLevel={ headingLevel }
						onChange={ ( newLevel ) =>
							setAttributes( { headingLevel: newLevel } )
						}
					/>
				</PanelBody>
			</InspectorControls>
		);
	};

	return (
		<div className={ className }>
			{ getInspectorControls() }
			<BlockTitle
				headingLevel={ headingLevel }
				heading={ heading }
				onChange={ ( value ) => setAttributes( { heading: value } ) }
			/>
			<Disabled>
				<Block attributes={ attributes } isEditor={ true } />
			</Disabled>
		</div>
	);
};

export default withSpokenMessages( Edit );
