/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Placeholder } from '@wordpress/components';
import { Icon, discussion } from '@kkart/icons';

const NoCategoryReviewsPlaceholder = () => {
	return (
		<Placeholder
			className="kkart-block-all-reviews"
			icon={
				<Icon
					srcElement={ discussion }
					className="block-editor-block-icon"
				/>
			}
			label={ __( 'All Reviews', 'kkart' ) }
		>
			{ __(
				'This block shows a list of all product reviews. Your store does not have any reviews yet, but they will show up here when it does.',
				'kkart'
			) }
		</Placeholder>
	);
};

export default NoCategoryReviewsPlaceholder;
