<?php
/**
 * Proxies class file.
 */

namespace Automattic\Kkart\Internal\DependencyManagement\ServiceProviders;

use Automattic\Kkart\Internal\DependencyManagement\AbstractServiceProvider;
use Automattic\Kkart\Proxies\LegacyProxy;
use Automattic\Kkart\Proxies\ActionsProxy;

/**
 * Service provider for the classes in the Automattic\Kkart\Proxies namespace.
 */
class ProxiesServiceProvider extends AbstractServiceProvider {

	/**
	 * The classes/interfaces that are serviced by this service provider.
	 *
	 * @var array
	 */
	protected $provides = array(
		LegacyProxy::class,
		ActionsProxy::class,
	);

	/**
	 * Register the classes.
	 */
	public function register() {
		$this->share( ActionsProxy::class );
		$this->share_with_auto_arguments( LegacyProxy::class );
	}
}
