<?php
/**
 * WordPress Administration Template Header
 *
 * @package WordPress
 * @subpackage Administration
 */

@header( 'Content-Type: ' . get_option( 'html_type' ) . '; charset=' . get_option( 'blog_charset' ) );
if ( ! defined( 'WP_ADMIN' ) ) {
	require_once( dirname( __FILE__ ) . '/admin.php' );
}

/**
 * In case admin-header.php is included in a function.
 *
 * @global string    $title
 * @global string    $hook_suffix
 * @global WP_Screen $current_screen
 * @global WP_Locale $wp_locale
 * @global string    $pagenow
 * @global string    $update_title
 * @global int       $total_update_count
 * @global string    $parent_file
 */
global $title, $hook_suffix, $current_screen, $wp_locale, $pagenow,
	$update_title, $total_update_count, $parent_file;

// Catch plugins that include admin-header.php before admin.php completes.
if ( empty( $current_screen ) ) {
	set_current_screen();
}

get_admin_page_title();
$title = esc_html( strip_tags( $title ) );

if(empty($title)){
	$title = __('Dashboard');
}

if ( is_user_admin() ) {
	/* translators: User dashboard screen title. %s: Network name */
	$admin_title = sprintf( __( 'User Dashboard: %s' ), esc_html( get_network()->site_name ) );
} else {
	$admin_title = get_bloginfo( 'name' );
}

if ( $admin_title == $title ) {
	/* translators: Admin screen title. %s: Admin screen name */
	$admin_title = sprintf( __( '%s &#8212; '.BRAND_SM ), $title );
} else {
	/* translators: Admin screen title. 1: Admin screen name, 2: Network or site name */
	$admin_title = sprintf( __( '%1$s &lsaquo; %2$s &#8212; '.BRAND_SM ), $title, $admin_title );
}

/**
 * Filters the title tag content for an admin page.
 *
 * @since 3.1.0
 *
 * @param string $admin_title The page title, with extra context added.
 * @param string $title       The original page title.
 */
$admin_title = apply_filters( 'admin_title', $admin_title, $title );

wp_user_settings();

_wp_admin_html_begin();
?>
<title><?php echo $admin_title; ?></title>
<?php

// Enqueue our stuff
wp_register_script('pagelayer-bootstrap', admin_url().'/js/bootstrap.min.js', array('jquery'), PAGELAYER_VERSION);
wp_register_script('pagelayer-admin-custom', admin_url().'/js/admin-custom.js', array('jquery'), PAGELAYER_VERSION);
wp_enqueue_script('pagelayer-bootstrap');
wp_enqueue_script('pagelayer-admin-custom');

wp_enqueue_style( 'colors' );
wp_enqueue_style( 'ie' );
wp_enqueue_script( 'utils' );
wp_enqueue_script( 'svg-painter' );

$admin_body_class = preg_replace( '/[^a-z0-9_-]+/i', '-', $hook_suffix );
?>
<script type="text/javascript">
addLoadEvent = function(func){if(typeof jQuery!="undefined")jQuery(document).ready(func);else if(typeof wpOnload!='function'){wpOnload=func;}else{var oldonload=wpOnload;wpOnload=function(){oldonload();func();}}};
var ajaxurl = '<?php echo admin_url( 'admin-ajax.php', 'relative' ); ?>',
	pagenow = '<?php echo $current_screen->id; ?>',
	typenow = '<?php echo $current_screen->post_type; ?>',
	adminpage = '<?php echo $admin_body_class; ?>',
	thousandsSeparator = '<?php echo addslashes( $wp_locale->number_format['thousands_sep'] ); ?>',
	decimalPoint = '<?php echo addslashes( $wp_locale->number_format['decimal_point'] ); ?>',
	isRtl = <?php echo (int) is_rtl(); ?>;
</script>

<meta name="viewport" content="width=device-width,initial-scale=1.0">
<?php

/**
 * Enqueue scripts for all admin pages.
 *
 * @since 2.8.0
 *
 * @param string $hook_suffix The current admin page.
 */
do_action( 'admin_enqueue_scripts', $hook_suffix );

/**
 * Fires when styles are printed for a specific admin page based on $hook_suffix.
 *
 * @since 2.6.0
 */
do_action( "admin_print_styles-{$hook_suffix}" );

/**
 * Fires when styles are printed for all admin pages.
 *
 * @since 2.6.0
 */
do_action( 'admin_print_styles' );

/**
 * Fires when scripts are printed for a specific admin page based on $hook_suffix.
 *
 * @since 2.1.0
 */
do_action( "admin_print_scripts-{$hook_suffix}" );

/**
 * Fires when scripts are printed for all admin pages.
 *
 * @since 2.1.0
 */
do_action( 'admin_print_scripts' );

/**
 * Fires in head section for a specific admin page.
 *
 * The dynamic portion of the hook, `$hook_suffix`, refers to the hook suffix
 * for the admin page.
 *
 * @since 2.1.0
 */
do_action( "admin_head-{$hook_suffix}" );

/**
 * Fires in head section for all admin pages.
 *
 * @since 2.1.0
 */
do_action( 'admin_head' );

if ( get_user_setting( 'mfold' ) == 'f' ) {
	$admin_body_class .= ' folded';
}

if ( ! get_user_setting( 'unfold' ) ) {
	$admin_body_class .= ' auto-fold';
}

if ( is_admin_bar_showing() ) {
	$admin_body_class .= ' admin-bar';
}

if ( is_rtl() ) {
	$admin_body_class .= ' rtl';
}

if ( $current_screen->post_type ) {
	$admin_body_class .= ' post-type-' . $current_screen->post_type;
}

if ( $current_screen->taxonomy ) {
	$admin_body_class .= ' taxonomy-' . $current_screen->taxonomy;
}

$admin_body_class .= ' branch-' . str_replace( array( '.', ',' ), '-', floatval( get_bloginfo( 'version' ) ) );
$admin_body_class .= ' version-' . str_replace( '.', '-', preg_replace( '/^([.0-9]+).*/', '$1', get_bloginfo( 'version' ) ) );
$admin_body_class .= ' admin-color-' . sanitize_html_class( get_user_option( 'admin_color' ), 'fresh' );
$admin_body_class .= ' locale-' . sanitize_html_class( strtolower( str_replace( '_', '-', get_user_locale() ) ) );

if ( wp_is_mobile() ) {
	$admin_body_class .= ' mobile';
}

$admin_body_class .= ' no-customize-support no-svg';

?>
</head>
<?php
/**
 * Filters the CSS classes for the body tag in the admin.
 *
 * This filter differs from the {@see 'post_class'} and {@see 'body_class'} filters
 * in two important ways:
 *
 * 1. `$classes` is a space-separated string of class names instead of an array.
 * 2. Not all core admin classes are filterable, notably: site-admin, wp-core-ui,
 *    and no-js cannot be removed.
 *
 * @since 2.3.0
 *
 * @param string $classes Space-separated list of CSS classes.
 */
$admin_body_classes = apply_filters( 'admin_body_class', '' );
$admin_body_classes = ltrim( $admin_body_classes . ' ' . $admin_body_class );
?>
<body class="site-admin wp-core-ui no-js <?php echo $admin_body_classes; ?>">
<script type="text/javascript">
	document.body.className = document.body.className.replace('no-js','js');
</script>

<?php
// Make sure the customize body classes are correct as early as possible.
if ( current_user_can( 'customize' ) ) {
	wp_customize_support_script();
}

?>

<div id="wpwrap">

<div class="row mx-0">
	<div class="col-sm-12 px-0 height-40">
<?php

function sitepad_top_nav(){
	
	global $sitepad, $current_user;

?>
	<div class="site-top-nav">
		<nav class="layout-navbar navbar navbar-expand-lg align-items-lg-center sitepad-admin-menu-bg">
		<div class="site-brand justify-content-md-center flex-grow-1 flex-md-grow-0">
			<a href="javascript:void(0)" class="site-left-nav-toggler outside"> 
				<span class="dashicons dashicons-menu"></span>
			</a>
			<a class="site-logo" href="">
				<?php echo (!empty($sitepad['sm_brand_logo']) ? '<img src="'.$sitepad['sm_brand_logo'].'" width="32"/>' : '<span class="dashicons dashicons-wordpress"></span>');?>				
			</a>
			<a class="site-title-name site-label" href="#"><?php echo BRAND_SM;?></a>
        </div>
			<div class="navbar-nav align-items-lg-center">
			<!-- Search -->
				<ul class="site-nav">
					<li>
						<a href="<?php echo home_url(); ?>" class="site-nav-link" target="_blank">
							<i class="dashicons-before dashicons-visibility"></i>
							<span class="site-nav-name d-md-inline-block d-none"><?php _e('View Site') ?></span>
						</a>
					</li>
					<li>
						<a href="<?php echo admin_url('admin.php?page=pagelayer_getting_started'); ?>" class="site-nav-link" target="_blank">
							<i class="dashicons-before dashicons-welcome-learn-more"></i>
							<span class="site-nav-name d-md-inline-block d-none"><?php _e('Getting Started') ?></span>
						</a>
					</li>
				</ul>
			</div>

			<div class="navbar-nav align-items-center ml-auto height-40 justify-content-center flex-row">
			
<?php

	$translations = json_decode(file_get_contents(WP_LANG_DIR.'/lang.json'), true);
	//r_print($translations);
	
	$languages = array_keys($translations);
	//r_print($languages);
	
	if ( defined( 'WPLANG' ) && '' !== WPLANG && 'en_US' !== WPLANG && ! in_array( WPLANG, $languages ) ) {
		$languages[] = WPLANG;
	}

	$locale = get_locale();
	if ( ! in_array( $locale, $languages ) ) {
		$locale = '';
	}
	
	$new_lang = array();
	$new_lang['en_US']['native_name'] = 'English (United States)';
	$new_lang['en_US']['language'] = 'en_US';

	if(!empty($translations)){
		foreach($translations as $lang_code => $lang){
			$new_lang[$lang_code]['native_name'] = $lang;
			$new_lang[$lang_code]['language'] = $lang_code;
		}
	}
	
	if(empty($locale)){
		$selected_lang = 'English (United States)';
	}else{
		$selected_lang = $new_lang[$locale]['native_name'];
	}
	
	//r_print($new_lang);
	
	if(count($new_lang) > 1){

?>
				<!-- Language Options -->
				<div class="nav-item dropdown mr-2 d-md-inline-block d-none">
					<a class="site-nav-link dropdown-toggle" href="#" data-toggle="dropdown">
						<?php echo $selected_lang;?>
					</a>
					<div class="dropdown-menu dropdown-menu-right container site-top-langs mt-2">
						<div class="row">
					<?php
					foreach($new_lang as $k => $v){
						echo '<div class="col-sm-3"><a href="javascript:selectLang(\''.$k.'\');">'.$v['native_name'].'</a></div>';
					}
					?>
						</div>
					</div>
				</div>
				
<?php

	}

?>
				<div class="nav-item mr-2">
					<!--<button type="button" class="btn btn-sm btn-success" onclick="javascript:sp_publish_site()">
						  Publish
					</button>-->
				</div>				
				<!-- User Options -->
				<div class="nav-item dropdown mr-2">
					<a class="site-nav-link sitepad-user-menu" href="#" data-toggle="dropdown">
						<?php echo ucfirst($current_user->data->display_name[0]); ?>
					</a>
					<div class="dropdown-menu dropdown-menu-right sitepad-admin-menu-bg position-absolute mt-2">
						<!-- <a href="javascript:void(0)" class="dropdown-item"><i class="ion ion-ios-mail text-lightest"></i> &nbsp; Enable Assistant</a> -->
						<a href="<?php echo admin_url('/profile.php'); ?>" class="sitepad-admin-users">
							<i class="dashicons dashicons-admin-users sitepad-user-menu"></i>
							<span><?php _e('Welcome') ?> <?php echo $current_user->data->display_name;?>
							<br>
							<?php echo $current_user->data->user_email; ?> </span>
						</a>
						<a href="<?php echo admin_url('/profile.php'); ?>" class="dropdown-item"><i class="dashicons dashicons-id"></i> &nbsp; <?php _e('My profile') ?></a>
						
						<a href="<?php echo @$sitepad['goto_cp'];?>" class="dropdown-item"><i class="dashicons-before dashicons-welcome-widgets-menus"></i> &nbsp; <?php _e('Control Panel') ?></a>
						
						<a href="<?php echo home_url('login.php?action=logout&logout-code='.wp_create_nonce('log-out')); ?>" class="dropdown-item"><i class="dashicons-before dashicons-migrate"></i> &nbsp; <?php _e('Logout') ?></a>
					</div>
				</div>
			</div>
		</nav>
	</div>
	
<script type="text/javascript">

// Bring the searchbox and tablenav in same row
jQuery(document).ready(function($){
	
	// Shift the search box
	if($(".sp-search").length > 0 && $(".sp-search").html().length < 1){
		
		var search = $(".search-box");
		var form = search.closest("form");
		form.append("<input type=hidden name=s id=hidden-s />");
		var input = search.find("input");
		var submit = search.find("button");
		submit.on("click", function(){
			$("#hidden-s").val(input.val());
			form.submit();
			//alert(1);
			return false;
		});
		search.detach();
		search.appendTo(".sp-search");
		$(".search-box").show();
	
	}
	
	// Search result numbers
	if($(".subtitle").length > 0){
		
		var subtitle = $(".subtitle");
		subtitle.detach();
		subtitle.appendTo(".sp-subtitle");
		$(".sp-subtitle").show();
		
	}
	
	// Bulk actions
	if($(".bulk-actions-top").length > 0){
		
		var bulkactions = $(".bulk-actions-top");
		
		$("[id^=cb-select]").change(function(){
			
			var is_checked = false;
			$("[id^=cb-select]").each(function(){
				if($(this).is(":checked")){
					is_checked = true;
				}
			});
			
			if(is_checked){
				bulkactions.show();
				$(".sp-search").hide();
			}else{
				bulkactions.hide();
				$(".sp-search").show();
			}
			
		});
	
	}
	
});

function selectLang(x){
	var ajaxurl = <?php echo "'".admin_url('admin-ajax.php?')."';"; ?>
	jQuery.ajax({
		url: ajaxurl+'&action=change_lang&sitepad_lang='+x+'&sitepad_nonce='+sitepad_ajax_nonce,
		type: 'POST',
		success: function(data){ 
			window.location.reload();
		},
	});
}

</script>

<?php

}// End of sitepad_top_nav

sitepad_top_nav();
?>
	</div>
</div>
<div class="row mx-0">
<div class="col w-100 px-0 lnav-col <?php echo (!empty($_COOKIE['sp-menu-collapsed']) ? 'collapsed' : '')?>">
	<div class="site-menu-header">
		<ul class="site-nav" id="adminmenu">
			<?php
			
			include_once( ABSPATH . 'site-admin/menu-header.php' ); 
			
			?>
		</ul>
		<span class="close-menu">&times;</span>
	</div>
</div>
<div class="col w-100 px-0">
	
<div id="wpcontent">

<?php
/**
 * Fires at the beginning of the content section in an admin page.
 *
 * @since 3.0.0
 */
do_action( 'in_admin_header' );
?>

<div id="wpbody" role="main">
<?php
unset( $blog_name, $total_update_count, $update_title );

$current_screen->set_parentage( $parent_file );

?>

<div id="wpbody-content">
<?php

$current_screen->render_screen_meta();

if ( is_network_admin() ) {
	/**
	 * Prints network admin screen notices.
	 *
	 * @since 3.1.0
	 */
	do_action( 'network_admin_notices' );
} elseif ( is_user_admin() ) {
	/**
	 * Prints user admin screen notices.
	 *
	 * @since 3.1.0
	 */
	do_action( 'user_admin_notices' );
} else {
	/**
	 * Prints admin screen notices.
	 *
	 * @since 3.1.0
	 */
	do_action( 'admin_notices' );
}

/**
 * Prints generic admin screen notices.
 *
 * @since 3.1.0
 */
do_action( 'all_admin_notices' );

if ( $parent_file == 'options-general.php' ) {
	require( ABSPATH . 'site-admin/options-head.php' );
}
