<?php
/**
 * Build Administration Menu.
 *
 * @package WordPress
 * @subpackage Administration
 */

/**
 * Constructs the admin menu.
 *
 * The elements in the array are :
 *     0: Menu item name
 *     1: Minimum level or capability required.
 *     2: The URL of the item's file
 *     3: Class
 *     4: ID
 *     5: Icon for top level menu
 *
 * @global array $menu
 */

$menu[2] = array( __( 'Dashboard' ), 'read', 'index.php', '', 'menu-top menu-top-first menu-icon-dashboard', 'menu-dashboard', 'dashicons-dashboard' );

$menu[4] = array( '', 'read', 'separator1', '', 'wp-menu-separator' );

$menu[10]                     = array( __( 'Media' ), 'upload_files', 'upload.php', '', 'menu-top menu-icon-media', 'menu-media', 'dashicons-admin-media' );
	$submenu['upload.php'][5] = array( __( 'Library' ), 'upload_files', 'upload.php' );
	/* translators: add new file */
	$submenu['upload.php'][10] = array( _x( 'Add New', 'file' ), 'upload_files', 'media-new.php' );
	$i                         = 15;
foreach ( get_taxonomies_for_attachments( 'objects' ) as $tax ) {
	if ( ! $tax->show_ui || ! $tax->show_in_menu ) {
		continue;
	}

	$submenu['upload.php'][ $i++ ] = array( esc_attr( $tax->labels->menu_name ), $tax->cap->manage_terms, 'edit-tags.php?taxonomy=' . $tax->name . '&amp;post_type=attachment' );
}
	unset( $tax, $i );

// $menu[20] = Pages

// Avoid the comment count query for users who cannot edit_posts.
if ( current_user_can( 'edit_posts' ) && false) {
	$awaiting_mod = wp_count_comments();
	$awaiting_mod = $awaiting_mod->moderated;
	$menu[25]     = array(
		sprintf( __( 'Comments %s' ), '<span class="awaiting-mod count-' . absint( $awaiting_mod ) . '"><span class="pending-count">' . number_format_i18n( $awaiting_mod ) . '</span></span>' ),
		'edit_posts',
		'edit-comments.php',
		'',
		'menu-top menu-icon-comments',
		'menu-comments',
		'dashicons-admin-comments',
	);
	unset( $awaiting_mod );
	
	$submenu['edit-comments.php'][0] = array( __( 'All Comments' ), 'edit_posts', 'edit-comments.php' );

}

$_wp_last_object_menu = 25; // The index of the last top-level menu in the object menu group

$types   = (array) get_post_types(
	array(
		'show_ui'      => true,
		'_builtin'     => false,
		'show_in_menu' => true,
	)
);
$builtin = array( 'post', 'page' );
foreach ( array_merge( $builtin, $types ) as $ptype ) {
	$ptype_obj = get_post_type_object( $ptype );
	// Check if it should be a submenu.
	if ( $ptype_obj->show_in_menu !== true ) {
		continue;
	}
	$ptype_menu_position = is_int( $ptype_obj->menu_position ) ? $ptype_obj->menu_position : ++$_wp_last_object_menu; // If we're to use $_wp_last_object_menu, increment it first.
	$ptype_for_id        = sanitize_html_class( $ptype );

	$menu_icon = 'dashicons-admin-post';
	if ( is_string( $ptype_obj->menu_icon ) ) {
		// Special handling for data:image/svg+xml and Dashicons.
		if ( 0 === strpos( $ptype_obj->menu_icon, 'data:image/svg+xml;base64,' ) || 0 === strpos( $ptype_obj->menu_icon, 'dashicons-' ) ) {
			$menu_icon = $ptype_obj->menu_icon;
		} else {
			$menu_icon = esc_url( $ptype_obj->menu_icon );
		}
	} elseif ( in_array( $ptype, $builtin ) ) {
		$menu_icon = 'dashicons-admin-' . $ptype;
	}

	$menu_class = 'menu-top menu-icon-' . $ptype_for_id;
	// 'post' special case
	if ( 'post' === $ptype ) {
		$menu_class    .= ' open-if-no-js';
		$ptype_file     = 'edit.php';
		$post_new_file  = 'post-new.php';
		$edit_tags_file = 'edit-tags.php?taxonomy=%s';
	} else {
		$ptype_file     = "edit.php?post_type=$ptype";
		$post_new_file  = "post-new.php?post_type=$ptype";
		$edit_tags_file = "edit-tags.php?taxonomy=%s&amp;post_type=$ptype";
	}

	if ( in_array( $ptype, $builtin ) ) {
		$ptype_menu_id = 'menu-' . $ptype_for_id . 's';
	} else {
		$ptype_menu_id = 'menu-posts-' . $ptype_for_id;
	}
	/*
	 * If $ptype_menu_position is already populated or will be populated
	 * by a hard-coded value below, increment the position.
	 */
	$core_menu_positions = array( 58, 59, 60, 65, 70, 75, 80, 85, 99 );
	while ( isset( $menu[ $ptype_menu_position ] ) || in_array( $ptype_menu_position, $core_menu_positions ) ) {
		$ptype_menu_position++;
	}
	
	$post_type_menu_name = $ptype_obj->labels->menu_name;
	if ( 'post' === $ptype ) {
		$post_type_menu_name = __('Blog');
	}

	$menu[ $ptype_menu_position ] = array( esc_attr( $post_type_menu_name ), $ptype_obj->cap->edit_posts, $ptype_file, '', $menu_class, $ptype_menu_id, $menu_icon );
	$submenu[ $ptype_file ][5]    = array( $ptype_obj->labels->all_items, $ptype_obj->cap->edit_posts, $ptype_file );
	$submenu[ $ptype_file ][10]   = array( $ptype_obj->labels->add_new, $ptype_obj->cap->create_posts, $post_new_file );

	$i = 15;
	foreach ( get_taxonomies( array(), 'objects' ) as $tax ) {
		if ( ! $tax->show_ui || ! $tax->show_in_menu || ! in_array( $ptype, (array) $tax->object_type, true ) ) {
			continue;
		}

		$submenu[ $ptype_file ][ $i++ ] = array( esc_attr( $tax->labels->menu_name ), $tax->cap->manage_terms, sprintf( $edit_tags_file, $tax->name ) );
	}
}
unset( $ptype, $ptype_obj, $ptype_for_id, $ptype_menu_position, $menu_icon, $i, $tax, $post_new_file );

$menu[58] = array( '', 'read', 'separator2', '', 'wp-menu-separator' );

$appearance_cap = current_user_can( 'switch_themes' ) ? 'switch_themes' : 'edit_theme_options';

$menu[59] = array( __( 'Menus' ), 'edit_theme_options', 'nav-menus.php', '', 'menu-top menu-icon-appearance', 'menu-appearance', 'dashicons-list-view' );

$menu[60] = array( __( 'Themes' ), $appearance_cap, 'themes.php', '', 'menu-top menu-icon-appearance', 'menu-appearance', 'dashicons-admin-appearance' );

$menu[65] = array( __( 'Templates' ), $appearance_cap, 'edit.php?post_type=pagelayer-template', '', 'menu-top menu-icon-customizer', 'menu-customizer', 'dashicons-admin-customizer' );

if ( current_theme_supports( 'menus' ) || current_theme_supports( 'widgets' ) ) {
	//$submenu['themes.php'][10] = array( __( 'Menus' ), 'edit_theme_options', 'nav-menus.php' );
	
}

if ( current_user_can( 'list_users' )) {
	$menu[70] = array( __( 'Users' ), 'list_users', 'users.php', '', 'menu-top menu-icon-users', 'menu-users', 'dashicons-admin-users' );
}

if ( current_user_can( 'list_users' ) ) {
	$_wp_real_parent_file['profile.php'] = 'users.php'; // Back-compat for plugins adding submenus to profile.php.
	$submenu['users.php'][5]             = array( __( 'All Users' ), 'list_users', 'users.php' );
	if ( current_user_can( 'create_users' ) ) {
		$submenu['users.php'][10] = array( _x( 'Add New', 'user' ), 'create_users', 'user-new.php' );
	}

	$submenu['users.php'][15] = array( __( 'Your Profile' ), 'read', 'profile.php' );
} else {
	$_wp_real_parent_file['users.php'] = 'profile.php';
	$submenu['profile.php'][5]         = array( __( 'Your Profile' ), 'read', 'profile.php' );
	if ( current_user_can( 'create_users' ) ) {
		$submenu['profile.php'][10] = array( __( 'Add New User' ), 'create_users', 'user-new.php' );
	}
}
$change_notice = '';

// translators: %s is the update notification bubble, if updates are available.
$menu[80] = array( sprintf( __( 'Settings %s' ), $change_notice ), 'manage_options', 'options-general.php', '', 'menu-top menu-icon-settings', 'menu-settings', 'dashicons-admin-settings' );
	$submenu['options-general.php'][10] = array( _x( 'General', 'settings screen' ), 'manage_options', 'options-general.php' );
	$submenu['options-general.php'][15] = array( __( 'Editor Settings' ), 'manage_options', 'admin.php?page=pagelayer#social_tab' );
	$submenu['options-general.php'][16] = array( __( 'Website UI' ), 'manage_options', 'admin.php?page=pagelayer_website_settings' );
	$submenu['options-general.php'][17] = array( __( 'Custom Fonts' ), 'manage_options', 'edit.php?post_type=pagelayer-fonts' );
	$submenu['options-general.php'][20] = array( __( 'Reading' ), 'manage_options', 'options-reading.php' );
	//$submenu['options-general.php'][25] = array( __( 'Discussion' ), 'manage_options', 'options-discussion.php' );
	$submenu['options-general.php'][30] = array( __( 'Media' ), 'manage_options', 'options-media.php' );
	$submenu['options-general.php'][40] = array( __( 'Permalinks' ), 'manage_options', 'options-permalink.php' );
	// translators: %s is the update notification bubble, if updates are available.
	$submenu['options-general.php'][45] = array( sprintf( __( 'Privacy %s' ), $change_notice ), 'manage_privacy_options', 'privacy.php' );
	$submenu['options-general.php'][50] = array( __( 'Contact Form' ), 'manage_options', 'admin.php?page=pagelayer#contactform_tab' );
	$submenu['options-general.php'][51] = array( __( 'Features' ), 'manage_options', 'features.php' );
	
if(empty($sitepad['server_license']) || !empty($sitepad['dev'])){
	$menu[87] = array( __( 'Plans' ), 'manage_options', 'plans.php', '', 'menu-top menu-icon-settings', 'menu-settings', 'dashicons-cart' );
}

$menu[81] = array( __( 'Advanced' ), 'manage_options', 'smtp-mail.php', '', 'menu-top menu-icon-generic', 'menu-generic', 'dashicons-admin-generic' );
	// $submenu['smtp-mail.php'][10] = array( __( 'SMTP Mail' ), 'manage_options', 'smtp-mail.php' );
	$submenu['smtp-mail.php'][15] = array( __( 'Google Analytics' ), 'manage_options', 'google-analytics.php' );
	$submenu['smtp-mail.php'][20] = array( __( 'Mail Chimp' ), 'manage_options', 'mailchimp.php' );
	$submenu['smtp-mail.php'][25] = array( __( 'Cookie Consent' ), 'manage_options', 'cookie-consent.php' );
	$submenu['smtp-mail.php'][30] = array( __( 'Sitemap' ), 'manage_options', 'sitemap.php' );
	$submenu['smtp-mail.php'][35] = array( __( 'SEO' ), 'manage_options', 'seo.php' );

$_wp_last_utility_menu = 87; // The index of the last top-level menu in the utility menu group

$menu[99] = array( '', 'read', 'separator-last', '', 'wp-menu-separator' );

// Back-compat for old top-levels
$_wp_real_parent_file['post.php']       = 'edit.php';
$_wp_real_parent_file['post-new.php']   = 'edit.php';
$_wp_real_parent_file['edit-pages.php'] = 'edit.php?post_type=page';
$_wp_real_parent_file['page-new.php']   = 'edit.php?post_type=page';

require_once( ABSPATH . 'site-admin/includes/menu.php' );
