<?php
/**
 * Tools Administration Screen.
 *
 * @package SitePad
 * @subpackage Administration
 */

/** SitePad Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

/** SitePad Translation Installation API */
require_once( ABSPATH . 'site-admin/includes/translation-install.php' );

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'Sorry, you are not allowed to manage options for this site.' ) );
}

$title       = __( 'Add SEO options for site wide' );

include( ABSPATH . 'site-admin/admin-header.php' );

	echo '<div class="wrap" style="margin: 0px;">	
		<h1>'.$title.'</h1>
		<hr />';
		
	$values = array();
	$details = array();
	$option_name = 'sitepad_global_meta_tags';
	
	
	if(isset($_REQUEST['submit'])){
		
		// Check nonce
		check_admin_referer( 'sitepad-options' );
	
		$allowed_meta = array('site_title', 'meta_author', 'meta_contact', 'meta_copyright', 'meta_description', 'meta_keys');
	
		foreach($allowed_meta as $meta_key){
			if(!empty($_REQUEST[$meta_key])){
				$details[$meta_key] = $_REQUEST[$meta_key];
			}
		}	
		// The option already exists, so we just update it.
		update_option( $option_name, wp_unslash( $details ) );
		
		echo '<div id="message" class="updated notice is-dismissible"><p>'.__('The SEO options updated successfully !').'</p></div>';
	}
	
	$values = get_option( $option_name );
	
	echo '<div id="sitepad_meta_data" class="sitepad-seo-option-padding">
		<form id="sitepad_meta_form" name="sitepad_meta_form" method="post">
		'. wp_nonce_field('sitepad-options') .'
		<div class="alert alert-info" role="alert">
		'. __('Note: This Meta Data will be used site-wide. If you want to add Meta Data for a particular page / post, you can edit it while editing the page / post in SitePad Editor.').'
		</div>
			<table style="border-collapse:separate;border-spacing:15px;">
				<tr>
				<td colspan="2" style="align:middle;">
					<p>'. __('There are some pre defined variables:- $site_title, $page_title, $post_type, $author, $email.').'</p>
				</td>
				</tr>
				<tr>
				<td style="text-align: left" width="25%">'. __('Site Title') .' : </td>
				<td width="70%">
					<input type="text" name="site_title" value="'.(!empty($values['site_title']) ? $values['site_title'] : '' ).'" id="site_title" style="width:100%;" />
				</td>
				</tr>
				<tr>	
				<td style="text-align: left" width="25%">'. __('Author') .' : </td>
				<td width="70%">
					<input type="text" name="meta_author" value="'.(!empty($values['meta_author']) ? $values['meta_author'] : '' ).'" id="meta_author" style="width:100%;" />
				</td>
				</tr>
				<tr>
				<td style="text-align: left" width="25%">'. __(' Contact') .' : </td>
				<td width="70%">
					<input type="text" name="meta_contact" value="'.(!empty($values['meta_contact']) ? $values['meta_contact'] : '' ).'" id="meta_contact" style="width:100%;"  />
				</td>
				</tr>
				<tr>
				<td style="text-align: left" width="25%">'. __(' Copyright') .' : </td>
				<td width="70%">
					<input type="text" name="meta_copyright" value="'.(!empty($values['meta_copyright']) ? $values['meta_copyright'] : '' ).'" id="meta_copyright" style="width:100%;"  />
				</td>
				</tr>
				<tr>
				<td style="text-align: left" width="25%">'. __(' Description') .' : </td>
				<td width="70%">
					<textarea rows="3" style="width:100%;" name="meta_description" id="meta_description" >'.(!empty($values['meta_description']) ? $values['meta_description'] : '' ).'</textarea>
				</td>
				</tr>
				<tr>
				<td style="text-align: left" width="25%">'. __(' Keywords') .' : </td>
				<td width="70%">
					<textarea rows="3" style="width:100%;" name="meta_keys" id="meta_keys" >'.(!empty($values['meta_keys']) ? $values['meta_keys'] : '' ).'</textarea>
				</td>
				</tr>
			</table>
			<button type="submit" name="submit" class="button button-primary">'. __('Save Meta') .'</button>
			<button type="reset" name="reset" class="button button-primary">'. __('Reset Meta') .'</button>
		</form>
		<br />
	</div>
</div>';

include( ABSPATH . 'site-admin/admin-footer.php' );
