<?php
/**
 * Helper admin navigation.
 *
 * @package Kkart\Helper
 */

defined( 'ABSPATH' ) || exit(); ?>

<nav class="nav-tab-wrapper kkart-nav-tab-wrapper">
	<a href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-addons' ) ); ?>" class="nav-tab"><?php esc_html_e( 'Browse Extensions', 'kkart' ); ?></a>

	<?php
		$count_html = KKART_Helper_Updater::get_updates_count_html();
		/* translators: %s: Kkart.com Subscriptions tab count HTML. */
		$menu_title = sprintf( __( 'Kkart.com Subscriptions %s', 'kkart' ), $count_html );
	?>
	<a href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-addons&section=helper' ) ); ?>" class="nav-tab nav-tab-active"><?php echo wp_kses_post( $menu_title ); ?></a>
</nav>
