<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div data-taxonomy="<?php echo esc_attr( $attribute->get_taxonomy() ); ?>" class="kkart_attribute kkart-metabox closed <?php echo esc_attr( implode( ' ', $metabox_class ) ); ?>" rel="<?php echo esc_attr( $attribute->get_position() ); ?>">
	<h3>
		<a href="#" class="remove_row delete"><?php esc_html_e( 'Remove', 'kkart' ); ?></a>
		<div class="handlediv" title="<?php esc_attr_e( 'Click to toggle', 'kkart' ); ?>"><?php _e('Edit'); ?></div>
		<div class="tips sort" data-tip="<?php esc_attr_e( 'Drag and drop to set admin attribute order', 'kkart' ); ?>"></div>			
		<strong class="attribute_name"><?php echo kkart_attribute_label( $attribute->get_name() ); ?></strong>
	</h3>
	<div class="kkart_attribute_data kkart-metabox-content hidden">
		<table cellpadding="0" cellspacing="0">
			<tbody>
				<tr>
					<td class="attribute_name">
						<label><?php esc_html_e( 'Name', 'kkart' ); ?>:</label>

						<?php if ( $attribute->is_taxonomy() ) : ?>
							<strong><?php echo kkart_attribute_label( $attribute->get_name() ); ?></strong>
							<input type="hidden" name="attribute_names[<?php echo esc_attr( $i ); ?>]" value="<?php echo esc_attr( $attribute->get_name() ); ?>" />
						<?php else : ?>
							<input type="text" class="attribute_name" name="attribute_names[<?php echo esc_attr( $i ); ?>]" value="<?php echo esc_attr( $attribute->get_name() ); ?>" />
						<?php endif; ?>

						<input type="hidden" name="attribute_position[<?php echo esc_attr( $i ); ?>]" class="attribute_position" value="<?php echo esc_attr( $attribute->get_position() ); ?>" />
					</td>
					<td rowspan="3">
						<label><?php esc_html_e( 'Value(s)', 'kkart' ); ?>:</label>
						<?php
						if ( $attribute->is_taxonomy() && $attribute_taxonomy = $attribute->get_taxonomy_object() ) {
							$attribute_types = kkart_get_attribute_types();

							if ( ! array_key_exists( $attribute_taxonomy->attribute_type, $attribute_types ) ) {
								$attribute_taxonomy->attribute_type = 'select';
							}

							if ( 'select' === $attribute_taxonomy->attribute_type ) {
								?>
								<select multiple="multiple" data-placeholder="<?php esc_attr_e( 'Select terms', 'kkart' ); ?>" class="multiselect attribute_values kkart-enhanced-select" name="attribute_values[<?php echo esc_attr( $i ); ?>][]">
									<?php
									$args      = array(
										'orderby'    => ! empty( $attribute_taxonomy->attribute_orderby ) ? $attribute_taxonomy->attribute_orderby : 'name',
										'hide_empty' => 0,
									);
									$all_terms = get_terms( $attribute->get_taxonomy(), apply_filters( 'kkart_product_attribute_terms', $args ) );
									if ( $all_terms ) {
										foreach ( $all_terms as $term ) {
											$options = $attribute->get_options();
											$options = ! empty( $options ) ? $options : array();
											echo '<option value="' . esc_attr( $term->term_id ) . '"' . kkart_selected( $term->term_id, $options ) . '>' . esc_html( apply_filters( 'kkart_product_attribute_term_name', $term->name, $term ) ) . '</option>';
										}
									}
									?>
								</select>
								<button class="button plus select_all_attributes"><?php esc_html_e( 'Select all', 'kkart' ); ?></button>
								<button class="button minus select_no_attributes"><?php esc_html_e( 'Select none', 'kkart' ); ?></button>
								<button class="button fr plus add_new_attribute"><?php esc_html_e( 'Add new', 'kkart' ); ?></button>
								<?php
							}

							do_action( 'kkart_product_option_terms', $attribute_taxonomy, $i, $attribute );
						} else {
							/* translators: %s: KKART_DELIMITER */
							?>
							<textarea name="attribute_values[<?php echo esc_attr( $i ); ?>]" cols="5" rows="5" placeholder="<?php printf( esc_attr__( 'Enter some text, or some attributes by "%s" separating values.', 'kkart' ), KKART_DELIMITER ); ?>"><?php echo esc_textarea( kkart_implode_text_attributes( $attribute->get_options() ) ); ?></textarea>
							<?php
						}
						?>
					</td>
				</tr>
				<tr>
					<td>
						<label><input type="checkbox" class="checkbox" <?php checked( $attribute->get_visible(), true ); ?> name="attribute_visibility[<?php echo esc_attr( $i ); ?>]" value="1" /> <?php esc_html_e( 'Visible on the product page', 'kkart' ); ?></label>
					</td>
				</tr>
				<tr>
					<td>
						<div class="enable_variation show_if_variable">
							<label><input type="checkbox" class="checkbox" <?php checked( $attribute->get_variation(), true ); ?> name="attribute_variation[<?php echo esc_attr( $i ); ?>]" value="1" /> <?php esc_html_e( 'Used for variations', 'kkart' ); ?></label>
						</div>
					</td>
				</tr>
				<?php do_action( 'kkart_after_product_attribute_settings', $attribute, $i ); ?>
			</tbody>
		</table>
	</div>
</div>
