<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div id="shipping_product_data" class="panel kkart_options_panel hidden">
	<div class="options_group">
		<?php
		if ( kkart_product_weight_enabled() ) {
			kkart_wp_text_input(
				array(
					'id'          => '_weight',
					'value'       => $product_object->get_weight( 'edit' ),
					'label'       => __( 'Weight', 'kkart' ) . ' (' . get_option( 'kkart_weight_unit' ) . ')',
					'placeholder' => kkart_format_localized_decimal( 0 ),
					'desc_tip'    => true,
					'description' => __( 'Weight in decimal form', 'kkart' ),
					'type'        => 'text',
					'data_type'   => 'decimal',
				)
			);
		}

		if ( kkart_product_dimensions_enabled() ) {
			?>
			<p class="form-field dimensions_field">
				<?php /* translators: Kkart dimension unit*/ ?>
				<label for="product_length"><?php printf( __( 'Dimensions (%s)', 'kkart' ), get_option( 'kkart_dimension_unit' ) ); ?></label>
				<span class="wrap">
					<input id="product_length" placeholder="<?php esc_attr_e( 'Length', 'kkart' ); ?>" class="input-text kkart_input_decimal" size="6" type="text" name="_length" value="<?php echo esc_attr( kkart_format_localized_decimal( $product_object->get_length( 'edit' ) ) ); ?>" />
					<input id="product_width" placeholder="<?php esc_attr_e( 'Width', 'kkart' ); ?>" class="input-text kkart_input_decimal" size="6" type="text" name="_width" value="<?php echo esc_attr( kkart_format_localized_decimal( $product_object->get_width( 'edit' ) ) ); ?>" />
					<input id="product_height" placeholder="<?php esc_attr_e( 'Height', 'kkart' ); ?>" class="input-text kkart_input_decimal last" size="6" type="text" name="_height" value="<?php echo esc_attr( kkart_format_localized_decimal( $product_object->get_height( 'edit' ) ) ); ?>" />
				</span>
				<?php echo kkart_help_tip( __( 'LxWxH in decimal form', 'kkart' ) ); ?>
			</p>
			<?php
		}

		do_action( 'kkart_product_options_dimensions' );
		?>
	</div>

	<div class="options_group">
		<?php
		$args = array(
			'taxonomy'         => 'product_shipping_class',
			'hide_empty'       => 0,
			'show_option_none' => __( 'No shipping class', 'kkart' ),
			'name'             => 'product_shipping_class',
			'id'               => 'product_shipping_class',
			'selected'         => $product_object->get_shipping_class_id( 'edit' ),
			'class'            => 'select short',
			'orderby'          => 'name',
		);
		?>
		<p class="form-field shipping_class_field">
			<label for="product_shipping_class"><?php esc_html_e( 'Shipping class', 'kkart' ); ?></label>
			<?php wp_dropdown_categories( $args ); ?>
			<?php echo kkart_help_tip( __( 'Shipping classes are used by certain shipping methods to group similar products.', 'kkart' ) ); ?>
		</p>
		<?php

		do_action( 'kkart_product_options_shipping' );
		?>
	</div>
</div>
