<?php
/**
 * Admin View: Notice - Legacy Shipping.
 *
 * @package Kkart\Admin\Notices
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div id="message" class="updated kkart-message">
	<a class="kkart-message-close notice-dismiss" href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'kkart-hide-notice', 'legacy_shipping' ), 'kkart_hide_notices_nonce', '_kkart_notice_nonce' ) ); ?>">
		<?php esc_html_e( 'Dismiss', 'kkart' ); ?>
	</a>

	<p class="main">
		<strong><?php esc_html_e( 'New:', 'kkart' ); ?> <?php esc_html_e( 'Shipping zones', 'kkart' ); ?></strong> &#8211; <?php esc_html_e( 'a group of regions that can be assigned different shipping methods and rates.', 'kkart' ); ?>
	</p>
	<p>
		<?php esc_html_e( 'Legacy shipping methods (flat rate, international flat rate, local pickup and delivery, and free shipping) are deprecated but will continue to work as normal for now. <b><em>They will be removed in future versions of Kkart</em></b>. We recommend disabling these and setting up new rates within shipping zones as soon as possible.', 'kkart' ); ?>
	</p>

	<p class="submit">
		<?php if ( empty( $_GET['page'] ) || empty( $_GET['tab'] ) || 'kkart-settings' !== $_GET['page'] || 'shipping' !== $_GET['tab'] ) : ?>
			<a class="button-primary" href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-settings&tab=shipping' ) ); ?>">
				<?php esc_html_e( 'Setup shipping zones', 'kkart' ); ?>
			</a>
		<?php endif; ?>
		<a class="button-secondary" href="https://docs.kkart.com/document/setting-up-shipping-zones/">
			<?php esc_html_e( 'Learn more about shipping zones', 'kkart' ); ?>
		</a>
	</p>
</div>
